
// File PDSRC

// Generalised BCPL parameter decoding routines

STATIC $(
PD..PARAM     = ?
PD..PARPTR    = ?
PD..PARLENG   = ?
$)

LET PARAMDECODE(KEYS, PARS, STRING) BE
$( LET PMAX, PNUM = KEYS!0, 1
   LET WKSP, PN = PARS + PMAX + 1, ?
 
   PD..PARAM := STRING

   FOR I = 0 TO PMAX DO PARS!I := 0
   PD..PARPTR := 0
   PD..PARLENG := PD..PARAM%0
   $( LET C = PD..GETPAR(WKSP)
      PN := (C NE '=') -> PNUM, VALOF
      $( LET N = PD..FINDKEY(KEYS, WKSP)
         C := PD..GETPAR(WKSP)
         RESULTIS N
      $)
      PARS!0 := VALOF
      $( LET L = WKSP%0
         IF C = '='          RESULTIS PAR.ERR
         IF PN = -1          RESULTIS PAR.AMB
         IF PN = -2          RESULTIS PAR.MIS
         IF PN = 0           RESULTIS PAR.UNK
         IF PN > PMAX        RESULTIS PAR.XS
         IF L = 0            RESULTIS PAR.OK
         IF PARS!PN NE 0     RESULTIS PAR.DUP
         PARS!PN := WKSP
         WKSP := WKSP + L/BYTESPERWORD + 1
         RESULTIS PAR.OK
      $)
      UNLESS PARS!0 = PAR.OK RETURN
      IF C = ENDSTREAMCH RETURN
      PNUM := PNUM + 1
   $) REPEAT
$)
 
AND PD..GETPAR(WKSP) = VALOF
$( LET C, SPCNT = ?, 0
   AND INPR, LENGTH = FALSE, 0
 
   $( C := PD..GETCH()
      SWITCHON C INTO
      $( CASE ENDSTREAMCH:
         CASE ',':
         CASE '=':
            WKSP%0 := LENGTH
            RESULTIS C
 
         CASE '*S':
            SPCNT := SPCNT + 1
            ENDCASE
 
         DEFAULT:
            TEST INPR THEN
               FOR I = 1 TO SPCNT DO
               $( LENGTH := LENGTH + 1
                  WKSP%LENGTH := '*S'
               $)
            OR
               INPR := TRUE
            SPCNT := 0
            LENGTH := LENGTH + 1
            WKSP%LENGTH := C
      $)
   $) REPEAT
$)
 
AND PD..FINDKEY(KEYS, WKSP) = VALOF
$( LET F = 0
 
   IF WKSP%0 = 0 RESULTIS -2   // Missing keyword
   FOR I = 1 TO KEYS!0 DO
   $( IF MATCHSTRINGS(WKSP, KEYS!I) DO
      $( UNLESS F = 0 RESULTIS -1
         F := I
      $)
   $)
   RESULTIS F
$)
 
AND MATCHSTRINGS(A, B) = VALOF
$( LET L = A%0
   IF B%0 < L RESULTIS FALSE
   FOR I = 1 TO L DO
      UNLESS A%I = B%I RESULTIS FALSE
   RESULTIS TRUE
$)
 
AND PD..GETCH() = VALOF
$( PD..PARPTR := PD..PARPTR + 1
   RESULTIS PD..PARPTR > PD..PARLENG ->
   ENDSTREAMCH, PD..PARAM%PD..PARPTR
$)

AND STRTONUM(STR) = VALOF
$( LET BASE , NUM , MINUS = 10 , 0 , FALSE
   PD..PARPTR := 0 ; PD..PARAM := STR
   PD..PARLENG := STR%0
   TEST PD..GETCH() = '-' THEN MINUS := TRUE
   OR PD..PARPTR := PD..PARPTR -1
   TEST PD..GETCH() = '#' THEN
   SWITCHON PD..GETCH() INTO
   $( CASE 'X'  : BASE := 16
                  ENDCASE
      CASE 'B'  : BASE := 2
                  ENDCASE
      DEFAULT   : PD..PARPTR := PD..PARPTR - 1
      CASE 'O'  : BASE := 8
   $)
   OR PD..PARPTR := PD..PARPTR - 1
   $( LET N = PD..GETNUM()
      IF N >= BASE BREAK
      NUM := NUM * BASE + N
   $) REPEAT
   RESULTIS MINUS -> -NUM , NUM
$)

AND PD..GETNUM() = VALOF
$( LET C = PD..GETCH()
   RESULTIS ('0' LE C LE '9') -> C - '0',
            ('A' LE C LE 'F') -> C - 'A' + 10, 99   // 99 is greater than the maximum base
$)
 
// End of file PDLIB

