 
// Version: V2.8   (also alter MANIFESTs below)
 
// BCPL code generator for DEC VAX-11 under UNIX
 
// Copyright (C) R.D. Eager   University of Kent   MCMLXXXVI
 
 
// History:
//  V1.0   - Initial UNIX version.
//  V1.1   - 'svsize' increased from 20 to 30.
//  V2.0   - Converted to run on Berkeley VM-UNIX.
//  V2.1   - 'max.labels' increased to 600.
//         - Global 96 (_default) added to automatic NEEDS list.
//  V2.2   - Global 66 (_bvfork) removed from automatic NEEDS list.
//  V2.3   - Correction  to  handling  of  's.res'  OCODE  in 'gencode';
//           previously, SP was not adjusted immediately  after  loading
//           R0.
//         - Correction  to  code  of  'stack',  to adjust SP by 'n-ssf'
//           rather than 'n-ssp'.
//         - Addition of 'n' flag to allow meaningful filenames in error
//           messages when being driven from a temporary file.
//         - Correction to 'cgglobal', to call  '_bcplsgi'  rather  than
//           '_bcplgi' if traced code is being compiled.
//  V2.5   - 's.blab'  OCODE  renamed to 's.labx'.
//         - Addition  of  's.labr'  and  's.mark'  OCODEs;  treated  as
//           's.lab' and 's.stack' respectively.
//  V2.6   - Correction to 'loadlv', to call 'cgpendingop' at start.
//  V2.7   - Corrections  to  'cggenselector'  and  'cgbyteselector', to
//           update register slaves in the case where a new register  is
//           not used and the operation is 's.slctap'.
//  V2.8   - Correction to 'cgstring' to suppress strings in dead code.
//         - Renaming of some identifiers.
//         - Correction   to  'cgbyteselector',  to  truncate  immediate
//           operands to byte size.

 
MANIFEST $(   // Alter these if changes are made
version = 2   // Major version number
edit    = 8   // Edit number within major version
$)
 
 
/* Exit status:-
    0 - Normal termination (possibly with warnings)
    1 - Filing or parameter error
  254 - Compiler error
  255 - Errors in translation
*/
 
// 1 - System-dependent initialisation code

GET "b2.h"
 
STATIC $( flags = ?; param_pos = ?; ocodename = ?; sourcename = ? $)

LET start(argc, argv, envp) BE
$( LET argp = 1
   AND on = VEC maxstrlength/bytesperword + 1
   AND real_rdch = rdch
   AND ch, res = ?, ?
   AND objfilestream, ocodestream, objfilename = ?, ?, ?
 
   // Set default options

   tracing, profiling, debug, textstrings, autoneeds := FALSE, FALSE, FALSE, FALSE, TRUE
   IF metering_ THEN printstats := FALSE

   ocodename, sourcename, objfilename := 0, 0, 0

   WHILE argp LE argc DO
   $( LET s = argv!argp

      argp := argp + 1

      TEST s%0 > 1 & s%1 = '-' THEN
      $( flags := s
         param_pos := 1
         rdch := s_rdch   // Takes input from FLAGS string
         $( ch := rdch()

            SWITCHON ch INTO
            $( CASE endstreamch:   BREAK
               CASE 's':           IF metering_ THEN printstats := TRUE
               CASE '-':
               CASE'*S': 
               CASE'*N':           ENDCASE
               CASE 'b':           selectoutput(journal)
                                   writef("%S: version: V%N.%N*N", argv!0, version, edit)
                                   selectoutput(sysout)
                                   ENDCASE
               CASE 't':           tracing := TRUE; ENDCASE
               CASE 'p':           profiling := TRUE; ENDCASE
               CASE 'd':           debug := TRUE; ENDCASE
               CASE 'r':           textstrings := TRUE; ENDCASE
               CASE 'm':           autoneeds := FALSE; ENDCASE
               CASE 'o':           IF argp > argc THEN error(sourcename, "No file for *'o*' flag")
                                   objfilename := argv!argp
                                   argp := argp + 1
                                   ENDCASE
               CASE 'n':           IF argp > argc THEN error(sourcename, "No file for *'n*' flag")
                                   sourcename := argv!argp
                                   argp := argp + 1
                                   ENDCASE
               DEFAULT:            error(ocodename, "Flag *'%C*' not recognised", ch)
            $)
         $) REPEAT
         rdch := real_rdch   // Restore RDCH
      $)
      OR
      $( IF ocodename NE 0 THEN error(0, "More than one input file")
         ocodename := s
         IF sourcename = 0 THEN sourcename := ocodename
      $)
   $)
 
   // Set up OCODE file

   IF ocodename = 0 THEN ocodename := "-"
   IF sourcename = 0 THEN sourcename := ocodename
   TEST ocodename%0 = 1 & ocodename%1 = '-' THEN
      ocodestream := sysin
   OR
   $( ocodestream := findinput(ocodename)
      IF ocodestream = 0 THEN error(ocodename, "Cannot open *'%S*'", ocodename)
   $)
   selectinput(ocodestream)

   // Set up object file

   TEST objfilename = 0 THEN
      objfilestream := sysout
   OR
   $( objfilestream := findoutput(objfilename)
      IF objfilestream = 0 THEN error(ocodename, "Cannot open output file *'%S*'", objfilename)
   $)
   selectoutput(objfilestream)

   IF metering_ THEN init_statistics()

   res := cgen(sourcename)

   endread(); endwrite()
   selectoutput(sysout)

   IF metering_ THEN
      IF printstats THEN print_statistics()

   stop(res)
$)
 
AND s_rdch() = VALOF
$( IF param_pos > flags%0 RESULTIS endstreamch
   param_pos := param_pos + 1
   RESULTIS flags%(param_pos - 1)
$)

AND message(prefix, mes, a, b, c, d, e, f) BE
$( writef("%S: ", argv!0)
   IF prefix NE 0 THEN writef("*"%S*", ", prefix)
   writef(mes, a, b, c, d, e, f)
$)

AND error(prefix, mes, a, b, c, d, e, f) BE
$( message(prefix, mes, a, b, c)
   newline()
   stop(1)
$)

AND report(mes, a, b, c, d, e, f) BE
$( selectoutput(sysout)

   IF debugging THEN abort(0)
 
   message(sourcename, mes, a, b, c, d, e, f)
   newline()
   stop(255)
$)
 
AND comment(mes, a, b, c, d, e, f) BE
$( LET o = output()
   AND s = VEC maxstrlength/bytesperword + 1
   AND prefix = "Warning - "
   LET l = prefix%0

   selectoutput(sysout)

   FOR i = 1 TO l DO s%i := prefix%i

   FOR i = 1 TO mes%0 DO s%(i + l) := mes%i
   s%0 := l + mes%0

   message(sourcename, s, a, b, c, d, e, f)
   newline()

   comments := comments + 1
 
   selectoutput(o)
$)
 
AND compilererror(mes, a, b, c, d, e, f) BE
$( LET s = VEC maxstrlength/bytesperword + 1
   AND prefix = "in compiler - "
   LET l = prefix%0

   FOR i = 1 TO l DO s%i := prefix%i

   FOR i = 1 TO mes%0 DO s%(i + l) := mes%i
   s%0 := l + mes%0

   message(s, a, b, c, d, e, f)
   newline()

   stop(254)
$)

 .
