
// 2 - The main codegenerator

GET "b2.h"

LET cgen(file) = VALOF
$( LET sa = VEC numregs*slavesize - 1
   AND sv = VEC numregs*slavesize - 1
   AND sk = VEC numregs*slavesize - 1
   AND sl = VEC numregs*slavesize - 1
   AND tv = VEC tempvsize*tempsize - 1
   AND lbv = VEC max.labels
   AND lm = VEC (max.labels + 1 + bitsperword - 1)/bitsperword - 1
   AND grm = VEC (firstfreeglobal + bitsperword - 1)/bitsperword - 1
 
   tempv := tv
   slaves_a, slaves_v, slaves_k, slaves_l := sa, sv, sk, sl
   labv, labmap := lbv, lm
   globrefmap := grm
 
   comments := 0
   incompd := FALSE
   IF profiling THEN tracing := TRUE   // To ensure names are compiled
 
   writef("*T.file*T*"%S*"*N", file)
   initialise_glob()
   initialise_code()
   trans(file)
   finalise_glob()
   finalise_code()

   RESULTIS 0
$)
 
AND initialise_glob() BE
$( globname := "_g"
   writef("*T.comm*T%S,%N*N", globname, (svsize + 1)*bytesperword)
   clear_bitmap(globrefmap, firstfreeglobal)
   hwglobal := 1
$)

AND finalise_glob() BE
$( LET cs = (svsize + hwglobal)*bytesperword   // Size of global vector area

   IF autoneeds THEN
   $( FOR i = 1 TO firstfreeglobal - 1 DO
         IF NOT setbit(globrefmap, i) THEN
         $( LET s = extname(i)

            IF s%0 NE 0 THEN cgsection_or_needs(s.needs, s)
         $)
   $)

   writef("*T.comm*T%S,%N*N", globname, cs)
$)

AND initialise_code() BE
$( cursect := 'A'
   curarea := a.data   // To force a change
   setarea(a.text)
   loadp := 0
   IF profiling THEN cgsection_or_needs(s.needs, "_bcplps")   // Code to set global PROFILE to TRUE
   cgsection_or_needs(s.needs, tracing -> "_bcplsgi", "_bcplgi")
   IF tracing THEN
      cgsection_or_needs(s.needs, "_bcplet")    // Trace support
   cgsection_or_needs(s.needs, tracing -> "_conting", "_skelcon")

   setarea(a.const)
   writes("*Tjbr*TLLL0*N")
   writes("*T.align*T2*N")
$)
 
AND finalise_code() BE
$( LET l = nextparam()

   comps(i.jbr, k.lab, l)
   writes("*T.align*T2*N")   // Otherwise the loader will do it, and may break the skip chain
   compl(l)

   setarea(a.const)
   writes("*T.align*T2*N")
   writes("LLL0:*N")   // End of bridging jump
$)

AND clear_bitmap(map, size) BE
$( FOR i = 0 TO (size + bitsperword - 1)/bitsperword - 1 DO
      map!i := 0
$)

AND setbit(map, bitno) = VALOF
$( LET offset = bitno/bitsperword
   LET word = map!offset

   IF ((word >> (bitno REM bitsperword)) & 1) NE 0 RESULTIS FALSE   // Bit already set

   map!offset := word \/ (1 << (bitno REM bitsperword))
   RESULTIS TRUE
$)
 
AND extname(n) = VALOF SWITCHON n INTO
$( CASE 04:   RESULTIS "_stop"
   CASE 09:   RESULTIS "_bclose"
   CASE 10:   RESULTIS "_findin"
   CASE 11:   RESULTIS "_findout"
   CASE 14:   RESULTIS "_selin"
   CASE 15:   RESULTIS "_selout"
   CASE 18:   RESULTIS "_endread"
   CASE 19:   RESULTIS "_endwrit"
   CASE 22:   RESULTIS "_rdch"
   CASE 23:   RESULTIS "_wrch"
   CASE 24:   RESULTIS "_input"
   CASE 25:   RESULTIS "_output"
   CASE 26:   RESULTIS "_rdblock"
   CASE 27:   RESULTIS "_wrblock"
   CASE 28:   RESULTIS "_prompt"
   CASE 29:   RESULTIS "_unrdch"
   CASE 32:   RESULTIS "_bcstr"
   CASE 33:   RESULTIS "_cbstr"
   CASE 34:   RESULTIS "_bisatty"
   CASE 35:   RESULTIS "_date"
   CASE 36:   RESULTIS "_tod"
   CASE 39:   RESULTIS "_muldiv"
   CASE 40:   RESULTIS "_rnfile"
   CASE 41:   RESULTIS "_delfile"
   CASE 51:   RESULTIS "_level"
   CASE 52:   RESULTIS "_longjmp"
   CASE 53:   RESULTIS "_aptovec"
   CASE 54:   RESULTIS "_getvec"
   CASE 55:   RESULTIS "_getvec"
   CASE 56:   RESULTIS "_pkstr"
   CASE 57:   RESULTIS "_unpkstr"
   CASE 58:   RESULTIS "_getbyte"
   CASE 59:   RESULTIS "_putbyte"
   CASE 60:   RESULTIS "_rewind"
   CASE 61:   RESULTIS "_endtoin"
   CASE 62:   RESULTIS "_bexecv"
   CASE 63:   RESULTIS "_bexecve"
   CASE 64:   RESULTIS "_bfork"
   CASE 65:   RESULTIS "_bwait"
   CASE 67:   RESULTIS "_newpage"
   CASE 68:   RESULTIS "_writeo"
   CASE 69:   RESULTIS "_writeh"
   CASE 70:   RESULTIS "_newline"
   CASE 71:   RESULTIS "_writen"
   CASE 72:   RESULTIS "_writed"
   CASE 73:   RESULTIS "_writhex"
   CASE 74:   RESULTIS "_writoct"
   CASE 75:   RESULTIS "_writes"
   CASE 76:   RESULTIS "_writef"
   CASE 77:   RESULTIS "_readn"
   CASE 79:   RESULTIS "_readnum"
   CASE 80:   RESULTIS "_transla"
   CASE 82:   RESULTIS "_move"
   CASE 87:   RESULTIS "_mapstat"
   CASE 88:   RESULTIS "_mapregs"
   CASE 89:   RESULTIS "_mapcode"
   CASE 90:   RESULTIS "_backtra"
   CASE 91:   RESULTIS "_postmor"
   CASE 92:   RESULTIS "_mapglob"
   CASE 93:   RESULTIS "_mapstor"
   CASE 94:   RESULTIS "_abort"
   CASE 96:   RESULTIS "_default"
   CASE 97:   RESULTIS "_catchsi"
   CASE 98:   RESULTIS "_ignores"
   CASE 99:   RESULTIS tracing -> "_conting", "_skelcon"

   DEFAULT:   RESULTIS ""
$)
 
 .
