 
// 3 - Code executed for each BCPL segment

GET "b2.h"
 
LET trans(file) BE
$( clear_bitmap(labmap, max.labels + 1)
   paramno := max.labels

   staticchain := -1   // Initialise STATIC name chain
 
   op := readop()
   process_section_and_needs()
   IF op = s.end RETURN   // End of OCODE file
   UNLESS op = s.stack \/ op = s.mark DO
      report("corrupt OCODE file")
 
   ssf := readnum()
   initstack(ssf)   // Initialises PENDINGOP as well
   incode_ := TRUE
 
   comps(i.jbr, k.blab, max.labels)   // Jump round main code
   incode_ := FALSE
 
   clear_slaves()
   clear_locks()
 
   gencode(file)

   IF debugging THEN check_locks()

   setarea(a.text)
   complab(max.labels, TRUE)   // Ensure that this label is not 'profiled'

   cgglobal()

   IF staticchain NE -1 THEN
   $( writes("#*N# STATIC name linkage*N#*N")

      comps(i.jsb, k.extern, "_bcplsni")
      compwl(staticchain)
   $)

   cursect := cursect + 1
   IF cursect = 'Z' THEN cursect := 'a'
$) REPEAT
 
AND cgglobal() BE
$( writes("#*N# Global initialisation*N#*N")

   comps(i.jsb, k.extern, tracing -> "_bcplsgi", "_bcplgi")
 
   FOR i = 1 TO globaln DO
   $( LET n = readnum()
      LET l = readl()
 
      IF n > hwglobal THEN hwglobal := n
      writef("*T.long*T%N,L%C%N*N", n + svsize, cursect, l)
   $)
 
   writes("*T.long*T-1*N")   // Terminator
$)

AND process_section_and_needs() BE
$( LET v = VEC maxstrlength/bytesperword + 1
   AND n = ?

   WHILE op = s.section \/ op = s.needs DO
   $( n := readnum()
      FOR i = 1 TO n DO v%i := readnum()
      v%0 := n > 8 -> 8, n
      cgsection_or_needs(op, v)
      op := readop()
   $)
$)
 
 .
