 
// 4 - Main scanning routine

GET "b2.h"
 
LET gencode(file) = VALOF
$( prev_ssp := -1
                       // 'STACK n' and 'RTRN' opcodes
   op := readop()
   $( SWITCHON op INTO
      $( DEFAULT:         report("illegal OCODE - %N", op)
    
         CASE s.end:      report("unexpected end of input file")

         CASE s.lp:       loadt(k.loc, readnum()); BREAK
    
         CASE s.lg:       loadt(k.glob, readnum()); BREAK
    
         CASE s.ln:       $( LET n = readnum()
                             AND op2 = ?

                             IF n = 0 & pendingop = s.logand THEN
                             $( op := readop()
                                TEST op = s.eq \/ op = s.ne THEN
                                $( op2 := readop()
                                   IF op2 = s.jt \/ op2 = s.jf THEN
                                   $( cgbitjump(op, op2, readl())
                                      IF metering_ THEN add_statistic(27)
                                      BREAK
                                   $)
                                   loadt(k.numb, 0)
                                   pendingop := op
                                   op := op2
                                   LOOP
                                $)
                                OR
                                $( loadt(k.numb, 0)
                                   LOOP
                                $)
                             $)
                             loadt(k.numb, n)
                             BREAK
                          $)
    
         CASE s.ll:       loadt(k.lab, readl()); BREAK
    
         CASE s.true:
         CASE s.false:    loadt(k.numb, op = s.true); BREAK
    
         CASE s.lstr:     cgstring(readnum()); BREAK
    
         CASE s.llp:      loadlv(k.loc, readnum()); BREAK
    
         CASE s.llg:      loadlv(k.glob, readnum()); BREAK
    
         CASE s.lll:      loadlv(k.lab, readl()); BREAK
    
         CASE s.sp:       storein(k.loc, readnum()); BREAK
    
         CASE s.sg:       storein(k.glob, readnum()); BREAK
    
         CASE s.sl:       storein(k.lab, readl()); BREAK
    
         CASE s.stind:    storei(); BREAK
    
         CASE s.not:      TEST pendingop = s.eqv THEN
                             pendingop := s.neqv
                          OR
                          $( cgpendingop()
                             pendingop := op
                          $)
                          BREAK
    
         CASE s.neg:      IF pendingop = s.mult THEN
                          $( LET nrand = (h1!arg1 = k.numb) -> arg1,
                                         (h1!arg2 = k.numb) -> arg2, 0

                             IF nrand NE 0 THEN
                             $( h2!nrand := -h2!nrand
                                IF metering_ THEN add_statistic(26)
                                BREAK
                             $)
                          $)
                          cgpendingop()
                          pendingop := s.neg
                          BREAK

         CASE s.mult: CASE s.div: CASE s.rem: CASE s.plus: CASE s.minus:
         CASE s.abs: CASE s.lshift: CASE s.rshift:
         CASE s.ge: CASE s.ls: CASE s.gr: CASE s.le: CASE s.eq: CASE s.ne:
         CASE s.logand: CASE s.logor: CASE s.eqv: CASE s.neqv: CASE s.getbyte:
    
                          cgpendingop()
                          pendingop := op
                          BREAK
    
         CASE s.rv:       cgrv(); BREAK
   
         CASE s.putbyte:  cgputbyte(); BREAK
    
         CASE s.slctap:
         CASE s.slctst:   cgselect(op); BREAK
    
         CASE s.endfor:   cgpendingop()
                          pendingop := s.le
                          op := s.jt   // Drop through
   
         CASE s.jt:
         CASE s.jf:       cgbranch(op = s.jt, readl())
                          BREAK
    
         CASE s.goto:     cggoto(); BREAK
    
         CASE s.jump:     cgpendingop()
                          store(0, ssp - 1)
                          asf(ssp - ssf)
                          comps(i.jbr, k.blab, readl())
                          incode_ := FALSE
                          BREAK
    
         CASE s.labr:
         CASE s.labx:
         CASE s.lab:      complab(readl(), FALSE); BREAK
    
         CASE s.mark:
         CASE s.stack:    $( LET k = ?
    
                             cgpendingop()
    
                             $( k := readnum()
                                op := readop()
                             $) REPEATWHILE op = s.stack \/ op = s.mark
    
                             IF op = s.rtrn THEN
                             $( prev_ssp := k
                                k := 2
                             $)
    
                             stack(k)
                             asf(k - ssf)
                             LOOP
                          $)
    
         CASE s.prcl:     cgpendingop()
                          store(0, ssp - 1)
                          asf(precallsize)
                          initstack(ssp + precallsize)
                          BREAK
    
         CASE s.store:    cgpendingop()
                          store(0, ssp - 1)
                          FOR a = tempv TO arg1 BY tempsize DO
                             IF h1!a = k.temp THEN h1!a := k.loc
                          asf(ssp - ssf)
                          BREAK
    
         CASE s.query:    loadt(k.numb, 0); BREAK
    
         CASE s.entry:    cgentry(); BREAK
    
         CASE s.endproc:  readnum()   // Ignore for now
                          BREAK
   
         CASE s.mc:       cgcode(readnum()); BREAK
    
         CASE s.save:     cgsave(readnum()); LOOP
    
         CASE s.rtap:
         CASE s.fnap:     cgapply(op, readnum()); BREAK
    
         CASE s.rtcall:
         CASE s.fncall:   cgcall(op); BREAK
    
         CASE s.fnrn:
         CASE s.rtrn:     cgreturn(); BREAK

         CASE s.res:      $( LET newsf = readnum()
                             LET l = readl()
                             AND p = ?
   
                             cgpendingop()
                             store(0, ssp - 2)
                             movetor(r.r0, arg1)
                             stack(ssp - 1)
                             UNLESS newsf = ssp DO
                                asf(newsf - ssp)
                             p := ssp
                             op := readop()
                             WHILE op = s.stack \/ op = s.mark DO
                             $( p := readnum()
                                op := readop()
                             $)
                             TEST op = s.lab \/ op = s.labr THEN
                             $( LET m = readl()

                                IF metering_ THEN
                                   IF l = m THEN add_statistic(22)

                                IF l NE m THEN
                                   comps(i.jbr, k.blab, l)

                                incode_ := FALSE
                                stack(p)

                                complab(m, FALSE)
                                BREAK
                             $)
                             OR
                             $( comps(i.jbr, k.blab, l)
                                incode_ := FALSE
                                stack(p)
                                LOOP
                             $)
                          $)
    
         CASE s.rstack:   initstack(readnum())
                          loadt(k.reg, r.r0)
                          BREAK
    
         CASE s.finish:   // Compile as STOP(0)
                          cgpendingop()
                          stack(ssp + 2)
                          loadt(k.numb, 0)
                          loadt(k.glob, gv.stop)
                          cgapply(s.rtap, ssp - 4)
                          incode_ := FALSE
                          BREAK
    
         CASE s.switchon: cgswitch(readnum()); BREAK
    
         CASE s.global:   globaln := readnum()
                          IF globaln LE 0 THEN
                             comment("no globals set in file %S", file)
                          RETURN
    
         CASE s.datalab:  $( LET l = readl()
                             LET n = readnum()
                             AND v = VEC maxstrlength/bytesperword + 1
    
                             FOR i = 1 TO n DO v%i := readnum()
                             v%0 := n
                             makelower(v)

                             IF tracing & n NE 0 THEN
                             $( LET sl = nextparam()
                                AND m, a = 0, n

                                IF staticchain = -1 THEN
                                $( setarea(a.data)
                                   staticchain := nextparam()
                                   compl(staticchain)
                                   compw(-1)   // Chain terminator
                                $)

                                setarea(a.const)
                                compl(sl)
                                compwl(staticchain)

                                staticchain := sl
                                compwl(l)

                                FOR i = 1 TO n/bytesperword + 1 DO
                                $( LET w = 0

                                   FOR j = 0 TO bitsperword - 1 BY bitsperbyte DO
                                   $( w := w \/ ((a & #XFF) << j)
                                      m := m + 1
                                      a := (m > n) -> 0, v%m
                                   $)
                                   compw(w)
                                $)
                             $)
                             setarea(a.data)
                             compl(l)
                             BREAK
                          $)
    
         CASE s.itemn:    setarea(a.data)
                          compw(readnum())
                          BREAK
    
         CASE s.iteml:    $( LET l = readl()
    
                             IF l GE max.labels THEN
                                report("too many *'labels*' in program")
    
                             setarea(a.data)
                             compwl(l)
                             setarea(a.text)
                             setbit(labmap, l)     // Mark as a label/routine cell
                             BREAK
                          $)
    
      $)
   $) REPEAT
$) REPEAT
 
AND readop() = VALOF
$( LET sum = 0
   AND ch = ?

   ch := rdch() REPEATWHILE ch = '*S' \/ ch = '*N'

   WHILE '0' LE ch LE '9' DO
   $( sum := sum*10 + ch - '0'
      ch := rdch()
   $)
   RESULTIS ch < 0 -> s.end, sum
$)
 
AND readl() = VALOF
$( LET sum = 0
   AND ch = ?
 
   ch := rdch() REPEATWHILE ch = '*S' \/ ch = '*N'
 
   UNLESS ch = 'L' DO report("no L where label expected")
   ch := rdch()
 
   WHILE '0' LE ch LE '9' DO
   $( sum := sum*10 + ch - '0'
      ch := rdch()
   $)

   IF sum GE max.labels THEN
      report("too many *'labels*' in program")

   RESULTIS sum
$)
 
AND readnum() = VALOF
$( LET sum, neg = 0, FALSE
   AND ch = ?
 
   $( ch := rdch()
      SWITCHON ch INTO
      $( CASE '-' : neg := TRUE
                    ch := rdch()
         DEFAULT  : BREAK
         CASE '*S':
         CASE '*T':
         CASE '*N':
      $)
   $) REPEAT
 
   $( LET c = '0' LE ch LE '9' -> ch - '0',
              'A' LE ch LE 'Z' -> ch - 'A' + 10,
                                          100
      IF c GE 10 RESULTIS neg -> -sum, sum
      sum := sum*10 + c
      ch := rdch()
   $) REPEAT
$)
 
 .
