
// 5 - Operator and register handling

GET "b2.h"

LET cgpendingop() BE
$( LET rand1, rand2 = arg1, arg2
   AND sw = FALSE
   AND f, l = ?, ?
   AND r, rr = r.null, r.null
 
   IF pendingop = s.none RETURN
 
   SWITCHON pendingop INTO
   $( CASE s.eq:  f := i.jeql; GOTO rel
      CASE s.ne:  f := i.jneq; GOTO rel
      CASE s.ls:  f := i.jlss; GOTO rel
      CASE s.gr:  f := i.jgtr; GOTO rel
      CASE s.le:  f := i.jleq; GOTO rel
      CASE s.ge:  f := i.jgeq
 
            rel:  r := movecontoanyr(-1)
                  IF (h1!arg1 = k.temp = h1!arg2) \/ (h1!arg2 NE k.reg) \/ (h1!arg2 = k.numb) THEN
                  $( rand1, rand2 := arg2, arg1
                     f := invop(f)
                  $)
                  UNLESS h1!rand2 = k.reg DO
                  $( rr := findslave(h1!rand2, h2!rand2, 0)
                     IF rr NE r.null THEN
                     $( h1!rand2, h2!rand2 := k.reg, rr
                        IF metering_ THEN add_statistic(21)
                     $)
                  $)
                  TEST numberis(0, rand1) THEN
                     comps(i.tstl, h1!rand2, h2!rand2)
                  OR
                     compd(i.cmpl, h1!rand2, h2!rand2, h1!rand1, h2!rand1)
                  l := nextparam()
                  comps(f, k.blab, l)
                  comps(i.clrl, k.reg, r)
                  compl(l)
                  lose1(r)
                  ENDCASE
 
      CASE s.eqv:
         sw := TRUE
      CASE s.neqv:
         IF h1!arg2 = k.reg THEN rand1, rand2 := arg2, arg1
         TEST h1!rand1 = k.reg THEN
         $( r := h2!rand1
            compd(i.xorl2, h1!rand2, h2!rand2, k.reg, r)
         $)
         OR
         $( r := nextreg()
            compt(i.xorl3, h1!rand2, h2!rand2, h1!rand1, h2!rand1, k.reg, r)
         $)
         IF sw THEN compd(i.mcoml, k.reg, r, k.reg, r)
         lose1(r)
         ENDCASE
 
      CASE s.plus:
         IF h1!arg2 = k.numb THEN rand1, rand2 := arg2, arg1
         IF numberis(0, rand1) THEN
         $( h1!arg2, h2!arg2 := h1!rand2, h2!rand2
            stack(ssp - 1)
            ENDCASE
         $)
         IF h1!arg1 = k.reg THEN rand1, rand2 := arg2, arg1
         TEST h1!rand1 = k.numb & ABS h2!rand1 = 1 & h1!rand2 = k.reg THEN
         $( r := h2!rand2
            comps(h2!rand1 > 0 -> i.incl, i.decl, k.reg, r)
            IF metering_ THEN add_statistic(h2!rand1 > 0 -> 19, 20)
         $)
         OR TEST h1!rand2 = k.reg THEN
         $( r := h2!rand2
            compd(i.addl2, h1!rand1, h2!rand1, k.reg, r)
         $)
         OR
         $( r := nextreg()
            compt(i.addl3, h1!arg1, h2!arg1, h1!arg2, h2!arg2, k.reg, r)
         $)
         lose1(r)
         ENDCASE
 
      CASE s.minus:
         IF numberis(0, arg1) THEN
         $( stack(ssp - 1)
            ENDCASE
         $)
         TEST h1!arg1 = k.numb & ABS h2!arg1 = 1 & h1!arg2 = k.reg THEN
         $( r := h2!arg2
            comps(h2!arg1 > 0 -> i.decl, i.incl, k.reg, r)
            IF metering_ THEN add_statistic(h2!arg1 > 0 -> 20, 19)
         $)
         OR TEST h1!arg2 = k.reg THEN
         $( r := h2!arg2
            compd(i.subl2, h1!arg1, h2!arg1, k.reg, r)
         $)
         OR
         $( r := nextreg()
            compt(i.subl3, h1!arg1, h2!arg1, h1!arg2, h2!arg2, k.reg, r)
         $)
         lose1(r)
         ENDCASE
 
      CASE s.mult:
         IF h1!arg2 = k.numb THEN rand1, rand2 := arg2, arg1
         IF numberis(0, rand1) THEN
         $( h1!arg2, h2!arg2 := k.numb, 0
            stack(ssp - 1)
            ENDCASE
         $)
         IF numberis(1, rand1) THEN
         $( h1!arg2, h2!arg2 := h1!rand2, h2!rand2
            stack(ssp - 1)
            ENDCASE
         $)
         IF h1!arg1 = k.reg THEN rand1, rand2 := arg2, arg1
         TEST h1!rand2 = k.reg THEN
         $( r := h2!rand2
            compd(i.mull2, h1!rand1, h2!rand1, k.reg, r)
         $)
         OR
         $( r := nextreg()
            compt(i.mull3, h1!arg1, h2!arg1, h1!arg2, h2!arg2, k.reg, r)
         $)
         lose1(r)
         ENDCASE
 
      CASE s.div:
         IF numberis(1, arg1) THEN
         $( stack(ssp - 1)
            ENDCASE
         $)
         TEST h1!arg2 = k.reg THEN
         $( r := h2!arg2
            compd(i.divl2, h1!arg1, h2!arg1, k.reg, r)
         $)
         OR
         $( r := nextreg()
            compt(i.divl3, h1!arg1, h2!arg1, h1!arg2, h2!arg2, k.reg, r)
         $)
         lose1(r)
         ENDCASE
 
      CASE s.rem:
         IF numberis(1, arg1) THEN
         $( h1!arg2, h2!arg2 := k.numb, 0
            stack(ssp - 1)
            ENDCASE
         $)
         freereg(r.r11); unslave(r.r11); lock(r.r11)
         freereg(r.ap) ; unslave(r.ap) ; lock(r.ap)
         IF h1!arg1 = k.temp = h1!arg2 THEN
         $( rr := movetoanyr(arg1)
            lock(rr)
         $)
         unlock(r.r11); unlock(r.ap)
         movetor(r.ap, arg2)
         unslave(r.ap)
         compt(i.ashq, k.numb, -32, k.reg, r.r11, k.reg, r.r11)
         UNLESS rr = r.null DO unlock(rr)
         compq(i.ediv, h1!arg1, h2!arg1, k.reg, r.r11, k.reg, r.ap, k.reg, r.r11)
         lose1(r.r11)
         ENDCASE
 
      CASE s.logor:
         IF h1!arg1 = k.reg THEN rand1, rand2 := arg2, arg1
         TEST h1!rand2 = k.reg THEN
         $( r := h2!rand2
            compd(i.bisl2, h1!rand1, h2!rand1, k.reg, r)
         $)
         OR
         $( r := nextreg()
            compt(i.bisl3, h1!arg1, h2!arg1, h1!arg2, h2!arg2, k.reg, r)
         $)
         lose1(r)
         ENDCASE
 
      CASE s.logand:
         IF (h1!arg1 = k.temp = h1!arg2) \/ (h1!arg2 = k.numb) \/ (h1!arg1 = k.reg) THEN
            rand1, rand2 := arg2, arg1
         TEST h1!rand1 = k.numb THEN
         $( r := nextreg()
            compt(i.bicl3, k.numb, NOT h2!rand1, h1!rand2, h2!rand2, k.reg, r)
         $)
         OR
         $( r := nextreg()
            compd(i.mcoml, h1!rand2, h2!rand2, k.reg, r)
            compt(i.bicl3, k.reg, r, h1!rand1, h2!rand1, k.reg, r)
         $)
         lose1(r)
         ENDCASE

      CASE s.abs:
         r := movetoanyr(arg1)
         UNLESS regloaded DO comps(i.tstl, k.reg, r)
         l := nextparam()
         comps(i.jgeq, k.blab, l)
         compd(i.mnegl, k.reg, r, k.reg, r)
         compl(l)
         h1!arg1, h2!arg1 := k.reg, r
         unslave(r)
         pendingop := s.none
         ENDCASE

      CASE s.neg:
         sw := TRUE
      CASE s.not:
         r := regfor(arg1)
         compd(sw -> i.mnegl, i.mcoml, h1!arg1, h2!arg1, k.reg, r)
         h1!arg1, h2!arg1 := k.reg, r
         unslave(r)
         pendingop := s.none
         ENDCASE
 
      CASE s.lshift:
         r := regfor(arg2)
         compt(i.ashl, h1!arg1, h2!arg1, h1!arg2, h2!arg2, k.reg, r)
         lose1(r)
         ENDCASE
 
      CASE s.rshift:
         TEST h1!arg1 = k.numb THEN
         $( IF h1!arg2 = k.temp THEN movetoanyr(arg2)   // Autoincrement must not take place; mode is .vb
            r := regfor(arg2)
            compq(i.extzv, k.numb, h2!arg1, k.numb, 32 - h2!arg1, h1!arg2, h2!arg2, k.reg, r)
         $)
         OR TEST h1!arg2 = k.numb THEN
         $( freereg(r.ap)
            comps(i.clrl, k.reg, r.ap)
            r := movetoanyr(arg1)
            compd(i.mnegl, k.reg, r, k.reg, r)
            movetor(r.r11, arg2)
            compt(i.ashq, k.reg, r, k.reg, r.r11, k.reg, r.r11)
            r := r.r11
         $)
         OR
         $( movetor(r.ap, arg1)
            lock(r.ap)
            r := nextreg()
            lock(r)
            compt(i.subl3, k.reg, r.ap, k.numb, 32, k.reg, r)
            IF h1!arg2 = k.temp THEN movetoanyr(arg2)
            compq(i.extzv, k.reg, r.ap, k.reg, r, h1!arg2, h2!arg2, k.reg, r)
            unlock(r)
            unlock(r.ap)
         $)
         lose1(r)
         ENDCASE
 
      CASE s.getbyte:
      $( LET lockflag = FALSE

         IF h1!arg1 = k.temp = h1!arg2 THEN movetoanyr(arg1)
         TEST h1!arg2 = k.reg THEN
         $( r := h2!arg2
            compd(i.mull2, k.numb, bytesperword, k.reg, h2!arg2)
         $)
         OR
         $( r := nextreg()
            lock(r)
            lockflag := TRUE
            TEST numberis(0, arg2) THEN
               moveconstant(0, k.reg, r)
            OR
               compt(i.mull3, h1!arg2, h2!arg2, k.numb, bytesperword, k.reg, r)
         $)
         TEST h1!arg1 = k.numb THEN
         $( TEST h2!arg1 = 0 THEN
               compd(i.movzbl, k.regdef, r, k.reg, r)
            OR
               compd(i.movzbl, k.abs \/ k.index \/ (r << 16), h2!arg1, k.reg, r)
         $)
         OR
         $( rr := movetoanyr(arg1)
            compd(i.movzbl, k.regdef \/ k.index \/ (r << 16), rr, k.reg, r)
         $)
         IF lockflag THEN unlock(r)
         lose1(r)
         ENDCASE
      $)

      DEFAULT:
         compilererror("bad op in CGPENDINGOP - %N", pendingop)
   $)
$)
 
AND lose1(r) BE
$( ssp := ssp - 1
   pendingop := s.none
 
   TEST arg2 = tempv THEN
      h1!arg2, h2!arg2, h3!arg2 := k.loc, ssp - 2, ssp - 2
   OR
   $( arg1 := arg2
      arg2 := arg2 - tempsize
   $)
   h1!arg1, h2!arg1, h3!arg1 := k.reg, r, ssp - 1
 
   unslave(r)
$)
 
AND numberis(n, a) = h1!a = k.numb & h2!a = n
 
AND movetoanyr(a) = movetor(regfor(a), a)
 
AND movecontoanyr(n) = VALOF
$( LET t = VEC tempsize - 1

   h1!t := k.numb
   h2!t := n
   h3!t := 0

   RESULTIS movetoanyr(t)
$)

AND regfor(a) = VALOF
$( IF h1!a = k.reg & NOT locked(h2!a) THEN RESULTIS h2!a
 
   FOR r = r.r0 TO r.r11 DO
      IF slaved(r, h1!a, h2!a, 0) & NOT locked(r) THEN
      $( freereg(r)
         RESULTIS r
      $)

   RESULTIS nextreg()
$)
 
AND movetor(r, a) = VALOF
$( regloaded := FALSE
   UNLESS regusedby(a) = r DO
   $( freereg(r)
      IF slaved(r, h1!a, h2!a, 0) THEN
      $( IF metering_ THEN add_statistic(18)
         RESULTIS r
      $)
      compd(i.movl, h1!a, h2!a, k.reg, r)
      regloaded := TRUE
      unslave(r)
      slave(r, h1!a, h2!a, 0)
      h1!a, h2!a := k.reg, r
   $)
   RESULTIS r
$)
 
AND moveconstant(value, k, n) = VALOF
$( IF k = k.reg THEN
   $( freereg(n)
      IF slaved(n, k.numb, value, 0) THEN
      $( IF metering_ THEN add_statistic(17)
         RETURN
      $)
   $)

   TEST value = 0 THEN
      comps(i.clrl, k, n)
   OR TEST 64 LE value LE 255 THEN
      compd(i.movzbl, k.numb, value, k, n)
   OR TEST 256 LE value LE 65535 THEN
      compd(i.movzwl, k.numb, value, k, n)
   OR TEST -63 LE value LE -1 THEN
      compd(i.mnegl, k.numb, -value, k, n)
   OR TEST -128 LE value LE -64 THEN
      compd(i.cvtbl, k.numb, value, k, n)
   OR TEST -32768 LE value LE -129 THEN
      compd(i.cvtwl, k.numb, value, k, n)
   OR compd(i.movl, k.numb, value, k, n)

   TEST k = k.reg THEN
      slave(n, k.numb, value, 0)
   OR
      discardslaves(k, n)
$)
 
AND nextreg() = VALOF
$( LET res = VALOF
   $( // First try for a free register with no known contents
   
      FOR r = r.r0 TO r.r11 DO
         IF slaves_v!r = k.none & isfree(r) & NOT locked(r) THEN RESULTIS r
   
      // Now try for a free register with known contents
   
      FOR r = r.r0 TO r.r11 DO
         IF isfree(r) & NOT locked(r) RESULTIS r
   
      // If all else fails, free a register; choose one as far down the
      // stack as possible.
   
      FOR t = tempv TO arg1 BY tempsize DO
         IF h1!t = k.reg THEN
         $( LET r = h2!t
   
            IF NOT locked(r) THEN
            $( freereg(r)
               RESULTIS r
            $)
         $)
      compilererror("failure of NEXTREG")
   $)
   unslave(res)
   RESULTIS res
$)

AND regusedby(t) = h1!t = k.reg -> h2!t, r.null
 
AND freereg(r) BE
   FOR t = tempv TO arg1 BY tempsize DO
      IF regusedby(t) = r THEN
      $( LET type = k.loc
         AND n = h3!t

         IF n > ssf THEN asf(n - ssf)
 
         TEST n = ssf THEN
         $( comps(i.pushl, k.reg, r)
            type := k.temp
         $)
         OR
         $( compd(i.movl, k.reg, r, k.loc, n)
            discardslaves(k.loc, n)
         $)
         h1!t, h2!t := type, n
 
         slave(r, k.loc, n, 0)
         RETURN
      $)
 
AND isfree(r) = VALOF
$( FOR t = tempv TO arg1 BY tempsize DO
      IF regusedby(t) = r RESULTIS FALSE
   RESULTIS TRUE
$)
 
AND lock(r) BE
$( IF debugging THEN
      IF slaves_l!r THEN compilererror("LOCK failure - %N", r)

   slaves_l!r := TRUE
$)

AND unlock(r) BE
$( IF debugging THEN
      UNLESS slaves_l!r THEN compilererror("UNLOCK failure - %N", r)

   slaves_l!r := FALSE
$)

AND locked(r) = slaves_l!r

AND clear_locks() BE
   FOR r = r.r0 TO r.ap DO slaves_l!r := FALSE

AND slave(r, v, a, k) BE
$( IF v = k.temp THEN v := k.loc
 
   TEST r.r0 LE r LE r.ap THEN
      slaves_v!r, slaves_a!r, slaves_k!r := v, a, k
   OR compilererror("bad R in SLAVE - %N", r)
$)
 
AND unslave(r) BE
   TEST r.r0 LE r LE r.ap THEN
      slaves_v!r := k.none
   OR
      compilererror("bad R in UNSLAVE - %N", r)
 
AND clear_slaves() BE
   FOR i = r.r0 TO r.ap DO
      slaves_v!i := k.none
 
AND slaved(r, v, a, k) = VALOF
   TEST r.r0 LE r LE r.ap THEN
      RESULTIS slaves_v!r = v &
               slaves_a!r = a &
               slaves_k!r = k
   OR compilererror("bad R in SLAVED - %N", r)

AND findslave(v, a, k) = VALOF
$( FOR r = r.r0 TO r.ap DO
      IF slaves_v!r = v &
         slaves_a!r = a &
         slaves_k!r = k THEN RESULTIS r
   RESULTIS r.null
$)

AND discardslaves(k, n) BE
$( FOR r = r.r0 TO r.ap DO
      IF slaves_v!r = k & slaves_a!r = n THEN unslave(r)
$)

IF debugging THEN
$( LET check_locks() BE
      FOR r = r.r0 TO r.ap DO
         IF slaves_l!r THEN report("LOCK check fails - %N", r)
$)
 
 .
