
// 8 - Address and indirection handling

GET "b2.h"

LET loadlv(k, n) BE
$( LET r = r.null

   cgpendingop()

   SWITCHON k INTO
   $( CASE k.loc:
         FOR i = r.r0 TO r.r11 DO
         $( IF slaves_v!i = k.fp THEN
            $( r := i
               BREAK
            $)
         $)
         TEST r = r.null THEN
         $( r := nextreg()
            compq(i.extzv, k.numb, 2, k.numb, 30, k.reg, r.fp, k.reg, r)
            compd(i.subl2, k.numb, n, k.reg, r)
         $)
         OR
         $( LET n1 = slaves_a!r

            freereg(r)
            compd(i.subl2, k.numb, n - n1, k.reg, r)
            IF metering_ THEN add_statistic(3)
         $)
         slave(r, k.fp, n, 0)
         ENDCASE

      CASE k.glob:
         FOR i = r.r0 TO r.r11 DO
         $( IF slaves_v!i = k.gv THEN
            $( r := i
               BREAK
            $)
         $)
         TEST r = r.null THEN
         $( r := nextreg()
            compd(i.movl, k.imglob, n, k.reg, r)
            compq(i.extzv, k.numb, 2, k.numb, 30, k.reg, r, k.reg, r)
         $)
         OR
         $( LET n1 = slaves_a!r

            freereg(r)
            compd(i.addl2, k.numb, n - n1, k.reg, r)
            IF metering_ THEN add_statistic(3)
         $)
         slave(r, k.gv, n, 0)
         ENDCASE

      CASE k.lab:
         r := nextreg()
         compd(i.movl, k.imdl, n, k.reg, r)
         compq(i.extzv, k.numb, 2, k.numb, 30, k.reg, r, k.reg, r)
         unslave(r)
         ENDCASE

      DEFAULT:
         compilererror("bad K in LOADLV - %N %N", k, n)
   $)
   loadt(k.reg, r)
$)
 
AND storei() BE
$( LET r = ?

   cgpendingop()

   r := movetoanyr(arg1)    // BCPL address
   compd(i.movl, h1!arg2, h2!arg2, k.abs \/ k.index \/ (r << 16), 0)
   clear_slaves()

   stack(ssp - 2)
$)

AND cgrv() BE
$( LET r = ?
   AND rr = ?

   cgpendingop()

   r := movetoanyr(arg1)   // BCPL address
   rr := nextreg()

   compd(i.movl, k.abs \/ k.index \/ (r << 16), 0, k.reg, rr)
   h1!arg1, h2!arg1 := k.reg, rr
$)

AND cgputbyte() BE
$( LET r, rr = ?, ?
   AND h1a, h2a = ?, ?
   AND f = i.movb

   cgpendingop()
   store(0, ssp - 4)

   IF h1!arg1 = k.temp = h1!arg2 THEN movetoanyr(arg1)   // Offset
   h1a, h2a := h1!arg1, h2!arg1
   TEST h1!arg2 = k.reg THEN
   $( r := h2!arg2
      compd(i.mull2, k.numb, bytesperword, k.reg, r)
   $)
   OR
   $( r := nextreg()
      TEST numberis(0, arg2) THEN
         moveconstant(0, k.reg, r)
      OR
         compt(i.mull3, h1!arg2, h2!arg2, k.numb, bytesperword, k.reg, r)
   $)
   stack(ssp - 2)
   IF h1!arg1 = k.temp THEN f := i.cvtlb   // To avoid 'movb (sp)+' confusing the stack
   TEST h1a = k.numb THEN
   $( TEST h2a = 0 THEN
         compd(f, h1!arg1, h2!arg1, k.regdef, r)
      OR
         compd(f, h1!arg1, h2!arg1, k.abs \/ k.index \/ (r << 16), h2a)
   $)
   OR
   $( LET t = VEC tempsize - 1

      h1!t, h2!t, h3!t := h1a, h2a, 0
      lock(r)
      rr := movetoanyr(t)
      unlock(r)
      compd(f, h1!arg1, h2!arg1, k.regdef \/ k.index \/ (r << 16), rr)
   $)
   stack(ssp - 1)
   clear_slaves()
$)

AND cgselect(op) BE
$( LET size = readnum()
   LET shift = readnum()
   LET offset = readnum()
 
   TEST (size = bitsperbyte) & (shift REM bitsperbyte = 0) THEN
      cgbyteselector(op, shift, offset)
   OR cggenselector(op, size, shift, offset)
$)
 
AND cgbyteselector(op, shift, offset) BE
$( LET index = offset*bytesperword + shift/bitsperbyte   // Byte offset from base
   AND r, rr = ?, ?

   cgpendingop()

   TEST h1!arg1 = k.reg THEN
   $( r := h2!arg1
      compd(i.mull2, k.numb, bytesperword, k.reg, r)
   $)
   OR
   $( r := nextreg()
      compt(i.mull3, k.numb, bytesperword, h1!arg1, h2!arg1, k.reg, r)
   $)

   TEST op = s.slctap THEN
   $( unslave(r)
      lock(r)
      rr := nextreg()
      unlock(r)
      compd(i.movzbl, k.abs \/ k.index \/ (r << 16), index, k.reg, rr)
      h1!arg1, h2!arg1 := k.reg, rr
   $)
   OR
   $( LET f = h1!arg2 = k.temp -> i.cvtlb, i.movb

      IF h1!arg2 = k.numb THEN h2!arg2 := h2!arg2 & #xff

      TEST index = 0 THEN
         compd(f, h1!arg2, h2!arg2, k.regdef, r)
      OR
         compd(f, h1!arg2, h2!arg2, k.abs \/ k.index \/ (r << 16), index)
      clear_slaves()
      stack(ssp - 2)
   $)
$)
 
AND cggenselector(op, size, shift, offset) BE
$( LET r = ?

   cgpendingop()

   TEST h1!arg1 = k.reg THEN
   $( r := h2!arg1
      compd(i.mull2, k.numb, bytesperword, k.reg, r)
   $)
   OR
   $( r := nextreg()
      compt(i.mull3, k.numb, bytesperword, h1!arg1, h2!arg1, k.reg, r)
   $)

   TEST op = s.slctap THEN
   $( compq(i.extzv, k.numb, shift, k.numb, size, k.abs \/ k.index \/ (r << 16), offset*bytesperword, k.reg, r)
      unslave(r)
      h1!arg1, h2!arg1 := k.reg, r
   $)
   OR
   $( compq(i.insv, h1!arg2, h2!arg2, k.numb, shift, k.numb, size, k.abs \/ k.index \/ (r << 16), offset*bytesperword)
      stack(ssp - 2)
      clear_slaves()
   $)
$)

 .
