
// 9 - Branch and jump handling

GET "b2.h"
 
LET cggoto() BE
$( cgpendingop()
 
   store(0, ssp - 2)
 
   SWITCHON h1!arg1 INTO
   $( DEFAULT:
         movetoanyr(arg1)   // Drop through

      CASE k.glob:
      CASE k.lab:
      CASE k.loc:
         comps(i.jmp, k.stackdef, arg1)
         ENDCASE
   $)
   stack(ssp - 1)
   incode_ := FALSE
$)
 
AND cgbranch(b, l) BE
$( LET f = ?
   AND r = ?
   AND rand1, rand2 = arg1, arg2
 
   SWITCHON pendingop INTO
   $( DEFAULT:        cgpendingop()
                      store(0, ssp - 2)
                      IF local(arg1) THEN h1!arg1, h2!arg1 := k.autoinc, r.sp
                      comps(i.tstl, h1!arg1, h2!arg1)
                      stack(ssp - 1)
                      comps(b -> i.jneq, i.jeql, k.blab, l)
                      RETURN
 
      CASE s.ne:      b := NOT b
      CASE s.eq:      f := b -> i.jeql, i.jneq
                      ENDCASE
 
      CASE s.ls:      b := NOT b
      CASE s.ge:      f := b -> i.jgeq, i.jlss
                      ENDCASE
 
      CASE s.le:      b := NOT b
      CASE s.gr:      f := b -> i.jgtr, i.jleq
                      ENDCASE
   $)
   store(0, ssp - 3)
 
   UNLESS h1!arg2 = k.reg DO
   $( r := findslave(h1!arg2, h2!arg2, 0)
      IF r NE r.null THEN
      $( h1!arg2, h2!arg2 := k.reg, r
         IF metering_ THEN add_statistic(24)
      $)
   $)
   UNLESS h1!arg1 = k.reg DO
   $( r := findslave(h1!arg1, h2!arg1, 0)
      IF r NE r.null THEN
      $( h1!arg1, h2!arg1 := k.reg, r
         IF metering_ THEN add_statistic(24)
      $)
   $)

   // It is essential that the call of STACK below should not generate code
   // which might alter the condition codes. Thus, any temporary items for
   // ARG1 or ARG2 are converted so that they are 'popped' from the stack
   // during the course of the test.

   IF local(arg1) & local(arg2) THEN rand1, rand2 := arg2, arg1   // For safety
   IF local(rand1) THEN h1!rand1, h2!rand1 := k.autoinc, r.sp
   IF local(rand2) THEN h1!rand2, h2!rand2 := k.autoinc, r.sp

   TEST numberis(0, rand1) THEN
      comps(i.tstl, h1!rand2, h2!rand2)
   OR TEST numberis(0, rand2) THEN
   $( f := invop(f)
      comps(i.tstl, h1!rand1, h2!rand1)
   $)
   OR
      compd(i.cmpl, h1!rand2, h2!rand2, h1!rand1, h2!rand1)
 
   stack(ssp - 2)
   comps(f, k.blab, l)
$)
 
AND cgbitjump(rel, jump, l) BE
$( LET rand1, rand2 = arg1, arg2
   AND eqsw = rel = s.eq
   AND jtsw = jump = s.jt
   LET f = eqsw EQV jtsw -> i.jeql, i.jneq

   IF h1!arg2 = k.numb THEN rand1, rand2 := arg2, arg1

   TEST numberis(1, rand1) THEN
   $( f := f = i.jeql -> i.jlbc, i.jlbs
      compd(f, h1!rand2, h2!rand2, k.lab, l)
   $)
   OR
   $( compd(i.bitl, h1!rand1, h2!rand1, h1!rand2, h2!rand2)
      comps(f, k.lab, l)
   $)
   stack(ssp - 2)
$)

AND invop(op) = VALOF SWITCHON op INTO
   $( CASE i.jeql:
      CASE i.jneq:  RESULTIS op
      CASE i.jlss:  RESULTIS i.jgtr
      CASE i.jgtr:  RESULTIS i.jlss
      CASE i.jleq:  RESULTIS i.jgeq
      CASE i.jgeq:  RESULTIS i.jleq
      DEFAULT    :  compilererror("bad op in INVOP - %N", op)
   $)
 
AND cgcode(n) BE
$( LET v = VEC maxstrlength/bytesperword + 1

   FOR i = 1 TO n DO v%i := readnum()
   v%0 := n

   writes(v)
   IF v%n NE '*N' THEN newline()
$)
 
AND plant_profile() BE
$( LET p = nextparam()
 
   setarea(a.data)
   compl(p)
   compw(0)   // Allocate space for the profile counter
 
   setarea(a.text)
   compd(i.movl, k.reg, r.r0, k.reg, r.r0)   // No-op (unique pattern marking profile code)
   comps(i.incl, k.lab, p)
$)
 
AND set_sf(newsf) BE
$( compt(i.subl3, k.numb, (newsf - 1)*bytesperword, k.reg, r.fp, k.reg, r.sp)
   ssf := newsf
$)
 
AND asf(n) BE UNLESS n = 0 DO
$( LET oldssf = ssf

   TEST ABS n = 1 THEN
   $( comps(i.tstl, n > 0 -> k.autodec, k.autoinc, r.sp)
      IF metering_ THEN add_statistic(2)
   $)
   OR
      compd(n > 0 -> i.subl2, i.addl2, k.numb, ABS n*bytesperword, k.reg, r.sp)
 
   IF n < 0 THEN
      FOR i = oldssf - 1 TO oldssf - n - 1 DO
         discardslaves(k.loc, i)
 
   ssf := oldssf + n
$)

 .
