
// C - Code planting routines

GET "b2.h"

LET comp(mode, arg) BE
$( SWITCHON mode & #XFFFF INTO
   $( CASE k.reg:              writes(regname(arg)); ENDCASE

      CASE k.autodec:          wrch('-')
                               IF arg = r.sp THEN ssf := ssf + 1

      CASE k.regdef:           writef("(%S)", regname(arg)); ENDCASE

      CASE k.temp:             IF arg NE ssf - 1 THEN
                                  compilererror("bad ARG in COMP(TEMP) - %N", arg)
                               arg := r.sp   // Drop through

      CASE k.autoinc:          writef("(%S)+", regname(arg))
                               IF arg = r.sp THEN ssf := ssf - 1
                               ENDCASE

      CASE k.abs:              wrch('**')

      CASE k.numb:             writef("$%N", arg); ENDCASE

      CASE k.stackdef:         wrch('**')

      CASE k.stack:            comp(h1!arg, h2!arg); ENDCASE

      CASE k.imdl:             wrch('$')

      CASE k.blab:
      CASE k.lab:              writef("L%C%N", cursect, arg); ENDCASE

      CASE k.imglob:           wrch('$')

      CASE k.glob:             writef("%S+0x%X4", globname, (arg + svsize)*bytesperword)
                               IF arg > hwglobal THEN hwglobal := arg
                               IF 0 < arg < firstfreeglobal THEN setbit(globrefmap, arg)
                               ENDCASE

      CASE k.extern:           writes(arg); ENDCASE

      CASE k.loc:              writef("%N(%S)", -arg*bytesperword, regname(r.fp)); ENDCASE

      DEFAULT:                 compilererror("bad MODE in COMP - %N", mode)
   $)

   IF (mode & k.index) NE 0 THEN
   $( LET reg = (mode & NOT k.index) >> 16

      writef("[%S]", regname(reg))
   $)
$)

AND compf(op) BE
$( LET s = VALOF SWITCHON op INTO
   $(
      CASE i.addl2 :  RESULTIS "addl2"
      CASE i.addl3 :  RESULTIS "addl3"
      CASE i.ashl  :  RESULTIS "ashl"
      CASE i.ashq  :  RESULTIS "ashq"
      CASE i.bicl2 :  RESULTIS "bicl2"
      CASE i.bicl3 :  RESULTIS "bicl3"
      CASE i.bisl2 :  RESULTIS "bisl2"
      CASE i.bisl3 :  RESULTIS "bisl3"
      CASE i.bitl  :  RESULTIS "bitl"
      CASE i.calls :  RESULTIS "calls"
      CASE i.casel :  RESULTIS "casel"
      CASE i.clrb  :  RESULTIS "clrb"
      CASE i.clrl  :  RESULTIS "clrl"
      CASE i.clrw  :  RESULTIS "clrw"
      CASE i.cmpl  :  RESULTIS "cmpl"
      CASE i.cvtbl :  RESULTIS "cvtbl"
      CASE i.cvtlb :  RESULTIS "cvtlb"
      CASE i.cvtwl :  RESULTIS "cvtwl"
      CASE i.decl  :  RESULTIS "decl"
      CASE i.divl2 :  RESULTIS "divl2"
      CASE i.divl3 :  RESULTIS "divl3"
      CASE i.ediv  :  RESULTIS "ediv"
      CASE i.extzv :  RESULTIS "extzv"
      CASE i.incl  :  RESULTIS "incl"
      CASE i.insv  :  RESULTIS "insv"
      CASE i.jbr   :  RESULTIS "jbr"
      CASE i.jeql  :  RESULTIS "jeql"
      CASE i.jgeq  :  RESULTIS "jgeq"
      CASE i.jgtr  :  RESULTIS "jgtr"
      CASE i.jlbc  :  RESULTIS "jlbc"
      CASE i.jlbs  :  RESULTIS "jlbs"
      CASE i.jleq  :  RESULTIS "jleq"
      CASE i.jlss  :  RESULTIS "jlss"
      CASE i.jmp   :  RESULTIS "jmp"
      CASE i.jneq  :  RESULTIS "jneq"
      CASE i.jsb   :  RESULTIS "jsb"
      CASE i.mcoml :  RESULTIS "mcoml"
      CASE i.mnegl :  RESULTIS "mnegl"
      CASE i.movb  :  RESULTIS "movb"
      CASE i.movl  :  RESULTIS "movl"
      CASE i.movq  :  RESULTIS "movq"
      CASE i.movzbl:  RESULTIS "movzbl"
      CASE i.movzwl:  RESULTIS "movzwl"
      CASE i.mull2 :  RESULTIS "mull2"
      CASE i.mull3 :  RESULTIS "mull3"
      CASE i.pushl :  RESULTIS "pushl"
      CASE i.rsb   :  RESULTIS "rsb"
      CASE i.subl2 :  RESULTIS "subl2"
      CASE i.subl3 :  RESULTIS "subl3"
      CASE i.tstl  :  RESULTIS "tstl"
      CASE i.xorl2 :  RESULTIS "xorl2"
      CASE i.xorl3 :  RESULTIS "xorl3"
      DEFAULT      :  compilererror("illegal OP in COMPF - X%X4", op)
   $)

   loadp := loadp + 1
   setarea(a.text)
   writef("*T%S*T", s)
$)

AND compn(op) BE IF incode_ THEN
$( compf(op)
   newline()
$)

AND comps(op, m1, a1) BE IF incode_ THEN
$( TEST op = i.pushl & m1 = k.numb & ((-32768 LE a1 LE -1) \/ (64 LE a1 LE 32767)) THEN
   $( moveconstant(a1, k.autodec, r.sp)
      IF metering_ THEN add_statistic(1)
   $)
   OR
   $( compf(op)
      comp(m1, a1)
      newline()
      IF op = i.pushl THEN ssf := ssf + 1
   $)
$)

AND compd(op, m1, a1, m2, a2) BE IF incode_ THEN
$( TEST op = i.movl & m1 = k.numb & NOT incompd THEN
   $( incompd := TRUE
      moveconstant(a1, m2, a2)
      incompd := FALSE
      IF metering_ THEN add_statistic(0)
   $)
   OR TEST op = i.movb & m1 = k.numb & a1 = 0 THEN
   $( comps(i.clrb, m2, a2)
      IF metering_ THEN add_statistic(25)
   $)
   OR
   $( compf(op)
      comp(m1, a1)
      wrch(',')
      comp(m2, a2)
      newline()
   $)
$)

AND compt(op, m1, a1, m2, a2, m3, a3) BE IF incode_ THEN
$( compf(op)
   comp(m1, a1)
   wrch(',')
   comp(m2, a2)
   wrch(',')
   comp(m3, a3)
   newline()
$)

AND compq(op, m1, a1, m2, a2, m3, a3, m4, a4) BE IF incode_ THEN
$( compf(op)
   comp(m1, a1)
   wrch(',')
   comp(m2, a2)
   wrch(',')
   comp(m3, a3)
   wrch(',')
   comp(m4, a4)
   newline()
$)

AND compl(l) BE
$( writef("L%C%N:*N", cursect, l)
$)

AND compwl(l) BE
$( writef("*T.long*TL%C%N*N", cursect, l)
$)

AND compw(n) BE
$( writef("*T.long*T0x%X8*N", n)
$)

AND cgstring(n) BE
$( LET wordlength = n/bytesperword + 1
   AND m, a = 0, n
   AND l = nextparam()
 
   IF incode_ THEN
   $( loadlv(k.lab, l)

      setarea(textstrings -> a.const, a.data)
      compl(l)
   $)

   FOR i = 1 TO wordlength DO
   $( LET w = 0
 
      FOR j = 0 TO bitsperword - 1 BY bitsperbyte DO
      $( w := w \/ ((a & #XFF) << j)
         m := m + 1
         a := (m > n) -> 0, readnum()
      $)
      IF incode_ THEN compw(w)
   $)
   IF incode_ THEN setarea(a.text)
$)
 
AND regname(r) = VALOF SWITCHON r INTO
$( CASE r.r0  :   RESULTIS "r0"
   CASE r.r1  :   RESULTIS "r1"
   CASE r.r2  :   RESULTIS "r2"
   CASE r.r3  :   RESULTIS "r3"
   CASE r.r4  :   RESULTIS "r4"
   CASE r.r5  :   RESULTIS "r5"
   CASE r.r6  :   RESULTIS "r6"
   CASE r.r7  :   RESULTIS "r7"
   CASE r.r8  :   RESULTIS "r8"
   CASE r.r9  :   RESULTIS "r9"
   CASE r.r10 :   RESULTIS "r10"
   CASE r.r11 :   RESULTIS "r11"
   CASE r.ap  :   RESULTIS "ap"
   CASE r.fp  :   RESULTIS "fp"
   CASE r.sp  :   RESULTIS "sp"
   CASE r.pc  :   RESULTIS "pc"

   DEFAULT    :   compilererror("bad register in REGNAME - X%X2", r)
$)

AND setarea(a) BE UNLESS curarea = a DO
$( LET s = VALOF SWITCHON a INTO
   $( CASE a.text:   RESULTIS ".text*T0"
      CASE a.const:  RESULTIS ".text*T1"
      CASE a.data:   RESULTIS ".data"

      DEFAULT    :   compilererror("bad A in SETAREA - %N", a)
   $)
   writef("*T%S*N", s)
   curarea := a
$)

 .
