.TH BCPL 1 "UKC local %G%"
.SH NAME
bcpl \- BCPL compiler
.SH SYNOPSIS
.B bcpl
[ -option ] [ +b1opt:b2opt ] ... file ...
.SH DESCRIPTION
.I Bcpl
is the UNIX BCPL compiler.
It accepts several types of arguments:
.PP
Arguments whose names end with `.b' are taken to be
BCPL source programs; they are compiled, and
each object program is left on the file
whose name is that of the source with `.o' substituted
for `.b'.
The `.o' file is normally deleted, however, if a single
BCPL program is compiled and loaded all at one go.
.PP
In the same way,
arguments whose names end with `.s' are taken to be assembler
source programs
and are assembled, producing a `.o' file.
.PP
The following options are interpreted by
.IR bcpl .
See
.IR as (1)
for assembly time options, and
.IR ld (1)
for load-time options.
.TP 8
.B \-c
Suppress the loading phase of the compilation, and force
an object file to be produced even if only one program is compiled.
.TP
.B \-g
Have the compiler produce additional code for
.IR bdb ,
the BCPL interactive debugging package.
.TP
.B \-p
Arrange for the compiler to generate code
which records a run-time profile of the program.
An execution histogram is then produced by a call of MAPSTORE
(automatic at end of run).
.TP
.B \-O
Produce optimised (non-traced) code.
This option must be used whenever optimised code is required, even if
only loading.
.TP
.B \-S
Compile the named BCPL programs, and leave the
assembler-language output on corresponding files suffixed `.s'.
.TP
.BI \-o " output"
Name the final output file
.IR output .
If this option is used, the file `a.out' will be left undisturbed.
.TP
.BI \-C " file"
Treat
.I file
as a compiled C program, and link it into the final object file. Note
that this is the only way in which C files may be linked with BCPL
program. Only compiled C modules are valid.
.TP
.BI \-t " directory"
Create temporary files in
.IR directory ,
instead of in /tmp.  This option is also passed to
.IR as .
.TP
.B \-v
Cause the compiler to be `verbose', and print tree size statistics, etc.
.TP
.B \-b
Print the version number of
.I bcpl
itself.
.PP
Certain more obscure options are passed to the compiler
.RI ( b1 )
or the
codegenerator
.RI ( b2 )
by means of an option string starting with a + sign.
Within this option string, the options for
.I b1
are separated from the options for
.I b2
by a colon (:). If there are no options for
.IR b2 ,
the colon may be omitted.
.PP
Valid options for
.I b1
are:
.TP 8
.B b
Print the version number of
.IR b1 .
.TP
.B t
Print a picture of the syntax tree.
.TP
.B c
Enable use of the CODE command.
.TP
.BR l n
Set the size of the compiler workspace to
.I n
words (default 8000).
.TP
.BR a n
Set the abandon threshold for compilation errors to
.I n
(default 20).
.TP
.BR d n
Set the dictionary size to
.I n
words (default 2400).
.TP
.BR g n
Set the maximum number of global initialisations per segment to
.I n
(default 100).
.TP
.BR k n
Set the maximum number of cases in a SWITCHON to
.I n
(default 150).
.PP
Valid options for
.I b2
are:
.TP 8
.B b
Print the version number of
.IR b2 .
.TP
.B r
Arrange for all strings to be read-only.
.TP
.B m
Inhibit the automatic fetching of library routines referenced within
a segment.
.PP
Certain other `secret' options are used for debugging the compiler.
.PP
Other arguments
are taken
to be either assembler or
loader option arguments, or BCPL-compatible
object programs, typically produced by an earlier
.I bcpl
run,
or perhaps libraries of BCPL-compatible routines.
These programs, together with the results of any
compilations specified, are loaded (in the order
given) to produce an executable program with name
.I a.out.
.SH FILES
.ta \w'/usr/lib/bcpl/bcplep.o  'u
file.b	input file
.br
file.o	object file
.br
a.out	loaded output
.br
/tmp/btm?	default temporary files
.br
/usr/lib/bcpl/b1	compiler
.br
/usr/lib/bcpl/b2	code generator
.br
/usr/lib/bcpl/bcplep.o	runtime prelude
.br
/usr/lib/bcpl/bcplst.o  runtime postlude
.br
/usr/lib/bcpl/libD.a	standard library (debug)
.br
/usr/lib/bcpl/libO.a	standard library (optimised)
.br
/usr/lib/bcpl/libhdr	standard header
.br
/usr/lib/bcpl/rtshdr    runtime system header
.br
/lib/libc.a	C library
.SH "SEE ALSO"
M. Richards and C.Whitby-Strevens,
.I
BCPL - the language and its compiler,
Cambridge University Press,
1979
.br
R. Firth, M.Richards and I. Willers,
.I
A proposed definition of the language BCPL,
BCPL User Group, Cambridge,
1979
.br
adb(1), ld(1)
.SH DIAGNOSTICS
The diagnostics produced by
.I bcpl
itself are intended to be
self-explanatory.
Occasional messages may be produced by the assembler
or loader.
.SH BUGS
The
.B -g
option is not yet implemented.
.SH AUTHOR
R.D. Eager, University of Kent at Canterbury, England.
