.TH BCPLZ 1 "UKC local %G%"
.SH NAME
bcplz \- BCPL compiler for Z80
.SH SYNOPSIS
.B bcplz
[ -option ] [ +b1opt ] ... file ...
.SH DESCRIPTION
.I Bcplz
is a BCPL compiler for the Zilog Z80 microprocessor.
This compiler exists primarily to support the UKC ring PADs, although
it is also possible to generate code for CP/M systems and even other
stand-alone systems. Contact the author for further details.
.PP
By default, the generated code is left in the file
`a.z'.
.PP
The following options are interpreted by
.IR bcplz .
.TP 8
.B \-b
Output the version number of
.I bcplz
to the standard output.
.TP
.B \-c
Produce a listing of the generated code on the standard output.
.TP
.B \-f
Locate the global vector at a fixed memory address. This reduces the size of
the generated code at the expense of flexibility.
.TP
.B \-g
Generate diagnostic records in the object file.
.TP
.BI \-o " output"
Name the final output file
.IR output .
If this option is used, the file `a.z' will be left undisturbed.
.TP
.B \-s
Enable a special compilation option which reverses the usage of the
IX and IY registers in the generated code.
.TP
.BI \-t " directory"
Create temporary files in
.IR directory ,
instead of in /tmp.
.TP
.B \-v
Enable verbose mode for the compiler; additional information is output
during compilation.
.TP
.BI \-w value
Set the workspace for the compiler to
.I value
words; the default is 60000.
Note that there should be no white space after the `w'.
.TP
.B \-x
Compile calls to globals -1 to -8 into RST instructions.
.TP
.B \-y
Force the generation of a jump table for all SWITCHON statements, even
if the case distribution is sparse.
.TP
.B \-z
Flag all references to locals and globals with offsets that exceed
127 bytes from their base registers. Access to these items is
very expensive in code terms.
.TP
.B \-D
Generate names of procedures at their entry points in the compiled code.
This is useful for debugging.
.TP
.BI \-G number
Set the number of globals in the compiled program to
.IR number .
The default is 400.
Note that there should be no white space after the `G'.
.TP
.B \-O
Produce optimised (non-traced) code.
This option must be used whenever optimised code is required.
.TP
.BI \-T base
Set the base of the jump table used by the compiled code to
.IR base ,
which must be a four digit hexadecimal number.
Note that there should be no white space after the `T'.
.PP
Certain more obscure options are passed to the compiler
.RI ( b1 )
by means of an option string starting with a + sign.
.PP
Valid options for
.I b1
are:
.TP 8
.B b
Print the version number of
.IR b1 .
.TP
.B t
Print a picture of the syntax tree.
.TP
.B c
Enable use of the CODE command.
.TP
.BR l n
Set the size of the compiler workspace to
.I n
words (default 8000).
.TP
.BR a n
Set the abandon threshold for compilation errors to
.I n
(default 20).
.TP
.BR d n
Set the dictionary size to
.I n
words (default 2400).
.TP
.BR g n
Set the maximum number of global initialisations per segment to
.I n
(default 100).
.TP
.BR k n
Set the maximum number of cases in a SWITCHON to
.I n
(default 150).
.PP
Certain other `secret' options are used for debugging the compiler.
.SH FILES
.ta \w'/usr/lib/bcpl/libhdr  'u
file.b	input file
.br
file.z	object file
.br
a.z	output file
.br
/tmp/btm?	default temporary files
.br
/usr/lib/bcpl/b1	compiler
.br
/usr/lib/bcpl/bz	code generator
.br
/usr/lib/bcpl/libhdr	standard header
.SH "SEE ALSO"
M. Richards and C.Whitby-Strevens,
.I
BCPL - the language and its compiler,
Cambridge University Press,
1979
.br
R. Firth, M.Richards and I. Willers,
.I
A proposed definition of the language BCPL,
BCPL User Group, Cambridge,
1979
.SH DIAGNOSTICS
The diagnostics produced by
.I bcplz
itself are intended to be
self-explanatory.
.SH AUTHOR
R.D. Eager, University of Kent at Canterbury, England.
