
// File backtra.b

SECTION "_backtra"
NEEDS "_bcpldbs"

GET "rtshdr"

LET backtrace() BE
$( LET trb = sv.traceb >> 2   // Derive word address
   LET trp = (sv.tracep < 0 -> -sv.tracep - 1, sv.tracep) + trb
   LET otrp = trp   // Copy
   AND trmk = 0
   AND linesize = 72
   AND cols.left = ?

   IF trb = 0 THEN RETURN   // No trace buffer present
   FOR i = 0 TO sv.tbsize - 1 DO
      trmk := trmk \/ trb!i   // See if there's anything traced
   IF trmk = 0 RETURN   // No - give up

   cols.left := linesize
   writes("*N*NFunction trace:*N*N")

   $( trp := trp - 1   // Move to next item
      IF trp < trb THEN trp := trp + sv.tbsize   // Wrap around
      IF !trp = 0 LOOP   // Empty entry

      $( LET pt = !trp >> 2   // BCPL pointer to string
         LET size = pt%0 + 8   // Length of string plus the arrow

         IF size > linesize THEN size := linesize   // Do the best we can
         IF size > cols.left THEN
         $( newline()
            cols.left := linesize
         $)

         sv.writefn(pt, 1, size - 8)
         writes("   <-   ")
         cols.left := cols.left - size
      $)
   $) REPEATUNTIL trp = otrp   // Gone all the way round
   newline(); newline()
$)

// End of file backtra.b

