
// File bcpldbs.b

SECTION "_bcpldbs"

GET "rtshdr"

LET sv.writefn(address, min, max) BE
$( LET l = address%0
   LET j = (l < max) -> l, max
 
   FOR i = 1 TO j DO wrch(address%i)
   FOR i = j + 1 TO min DO wrch('*S')
$)

AND sv.writeval(value) BE
$( TEST 0 LE value LE sv.highcode THEN   // Address in text segment
   $( TEST sv.isfun(value) THEN
      $( LET name = sv.nfentry(value)
         TEST name = 0 THEN writef("*S%X8*****S", value)
         OR
         $( wrch('*S')
            sv.writefn(name, 8, 8)
            writes("*S*S*S")
         $)
      $)
      OR
         writef("*S%X8***S*S", value)   // Probably a label
   $)
   OR
      writef("*S%X8*S*S*S", value)   // Some other value
$)
 
AND sv.isfun(address) = VALOF
$( TEST 0%address = i.jsb &
        0%(address + 1) = m.relpcw THEN address := address + 8   // Skip over short trace call
   OR IF 0%address = i.jsb &
         0%(address + 1) = m.relpcl THEN address := address + 10   // Skip over long trace call

   IF 0%(address + 0) = i.movl &   // Check for profile code
      0%(address + 1) = m.r0reg &
      0%(address + 2) = m.r0reg &
      0%(address + 3) = i.incl THEN
   $( address := address + 4   // Point to mode byte
      TEST 0%address = m.relpcl THEN address := address + 5
      OR TEST 0%address = m.relpcw THEN address := address + 3
      OR RESULTIS FALSE
   $)

   IF 0%(address + 0) = i.pushl &       // pushl fp
      0%(address + 1) = m.fpreg &
      0%(address + 2) = i.addl3 &       // addl3 $248,sp,fp
      0%(address + 3) = m.imd &
      0%(address + 4) = 248 &
      0%(address + 5) = 0 &
      0%(address + 6) = 0 &
      0%(address + 7) = 0 &
      0%(address + 8) = m.spreg &
      0%(address + 9) = m.fpreg THEN RESULTIS TRUE

   RESULTIS FALSE
$)

AND sv.nfentry(ep) = VALOF
$( TEST 0%ep = i.jsb & 0%(ep + 1) = m.relpcw THEN ep := ep + 4
   OR TEST 0%ep = i.jsb & 0%(ep + 1) = m.relpcl THEN ep := ep + 6
   OR RESULTIS 0   // Not traced

   $( LET word = 0

      FOR i = 3 TO 0 BY -1 DO
         word := (word << 8) \/ 0%(ep + i)

      RESULTIS word >> 2   // BCPL address of string
   $)
$)

// End of file bcpldbs.b

