#
# BCPL library - bcplet.s
# Trace package
#
	.text
#
	.globl	_etext
#
	jbr	2f			# avoid breaking skip chain
#
	.globl	_bcplet
#
_bcplet:movl	_g+TRACEP,r0		# pick up trace pointer
	jlss	4f			# tracing turned off at present
	movl	*(sp),*$trcbuf[r0]	# fill in next item
	incl	r0			# bump pointer
	cmpl	r0,$TBSIZE		# over top?
	jlss	1f			# j if not
	clrl	r0			# else wrap round
1:	movl	r0,_g+TRACEP		# store away again
4:	addl2	$4,(sp)			# avoid trace item in code
	rsb				# and return
#
# Global initialisation
#
2:	jsb	_bcplgi			# put trace buffer info into system vector
	.long	TRACEB/4,trcbuf		# address
	.long	TSSG/4,TBSIZE		# size
	.long	TRACEP/4,0		# initialise trace pointer
	.long	-1			# terminator
#
	subl3	$1,$_etext,_g+HIGHCODE	# address of last byte in text segment
#
	jbr	3f			# avoid loader alignment problems
	.align	2
3:
#
	.data
	.lcomm	trcbuf,TBSIZE*4		# Trace buffer
#
# End of file bcplet.s
#
