
// File bcplin.b

SECTION "_bcplin"
NEEDS "_bcplios"

GET "rtshdr"

LET bcplinit() BE
$( sysin := io.finduio(0, dir_read)   // Set up SYSIN - file descriptor 0
   sv.curin := sysin

   sysout := io.finduio(1, dir_write)   // Set up SYSOUT - file descriptor 1
   sv.curout := sysout

   journal := io.finduio(2, dir_write)   // Set up JOURNAL - file descriptor 2
   scb_link::journal := 0
   sv.scbchain := journal

   // Initialise prompt area and file descriptor

   sv.prompt := (TABLE 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
   sv.ttyfd := isatty(journal) -> 2, 255  // OK for most cases

   // Initialise error handling re-entrancy flag

   sv.errflag := FALSE

   // Arrange to catch relevant signals

   catchsignals(sv.traceb = 0 -> #B0011000000001000000000000110,
                                 #B0011000000001111110111111110, TRUE)

   interactive := isatty(sysin) & isatty(sysout)
$)

// End of file bcplin.b

