#
# BCPL library - bcplst.s
# Run-time start-off; machine code skeleton
#
	.text
	.globl	_stop
#
	.globl	_bcplst
_bcplst:
#
# Inhibit integer overflow traps
#
	bicpsw	$0x20
#
# Shuffle the arguments and environment strings on the stack so that:
#  a) They are BCPL-style strings
#  b) They all start on a longword boundary
#  c) Their respective pointers are BCPL-style addresses
#
# In order to ensure that there is enough room for the word-alignment, the
# vector of pointers is shifted down by a number of longwords, equal to the
# total number of strings; this gives a breathing space of one longword for
# each string.
#
	movl	(sp)+,r0		# number of arguments
	movl	r0,_g+ARGC		# save for user programs
	decl	_g+ARGC			# but adjust to sensible value
	incl	r0			# allow for terminating zero
	movl	r0,r1			# save for counting
	mull2	$4,r0			# convert to byte offset
	addl2	sp,r0			# point to env0 pointer
1:	incl	r1			# bump pointer count
	tstl	(r0)+			# see if any more
	jneq	1b			# j if so
	mull2	$4,r1			# r1 = size of block to move
	movl	sp,r6			# save string pointer over move
	movl	sp,r0			# r0 = source pointer
	subl2	r1,sp			# sp = destination pointer
	movc3	r1,(r0),(sp)		# do the move
	extzv	$2,$30,sp,_g+ARGV	# set up global
	movl	sp,r0			# initialise for loop
4:	movl	(r0),r2			# get next arg pointer
	jeql	3f			# j if finished args
	movl	r6,r3			# save address of length byte
	incl	r6			# move past length byte
2:	movb	(r2)+,(r6)+		# copy bytes of string
	jneq	2b			# stop on zero byte
	decl	r6			# back up over zero byte
	subl3	r3,r6,r1		# derive string length
	decl	r1			# avoid counting length byte
	movb	r1,(r3)			# fill in length byte
	extzv	$2,$30,r3,(r0)+		# convert string pointer
	addl2	$3,r6			# round up
	bicl2	$3,r6			# word-align for next one
	jbr	4b			# see if more to do
3:	tstl	(r0)+			# skip arg vector terminator
	extzv	$2,$30,r0,_g+ENVP	# set up global
7:	movl	(r0),r2			# get next env pointer
	jeql	5f			# j if finished envs
	movl	r6,r3			# save address of length byte
	incl	r6			# move past length byte
6:	movb	(r2)+,(r6)+		# copy bytes
	jneq	6b			# j if more to do
	decl	r6			# back up over zero byte
	subl3	r3,r6,r1		# derive string length
	decl	r1			# avoid counting length byte
	movb	r1,(r3)			# fill in length byte
	extzv	$2,$30,r3,(r0)+		# convert string pointer
	addl2	$3,r6
	bicl2	$3,r6			# word-align for next one
	jbr	7b			# see if more to do
5:
#
# Pad spare space with any bytes except 0 or 255; this stops 'ps'
# getting confused.
#
9:	probew	$3,$4,(r6)		# check that longword is accessible
	jgeq	8f			# stop at end of stack
	movb	$0xaa,(r6)+		# pretty pattern!
	jbr	9b
8:
#
# Set up miscellaneous globals
#
	subl3	$_g,$_bcplge,r0		# get size of global vector
	subl2	$SVSIZE,r0		# avoid counting system vector
	divl3	$4,r0,_g+GLOBSZ		# convert to longwords, and set into global
	subl3	$4,sp,_g+STKBASE	# frame pointer for START
#
# Call main initialisation routine
#
	subl2	$244,sp			# set up for call ...
	jsb	*_g+BCPLINIT		# ... to library initialisation code
#
# Initialisation complete; enter START, passing the standard (UNIX) parameters
# of ARGC, ARGV and ENVP.
#
	movl	sp,fp			# set to sensible value
	subl2	$8,sp			# prepare for call to START
	pushl	_g+ARGC			# stack standard parameters
	pushl	_g+ARGV
	pushl	_g+ENVP
	subl2	$224,sp
	jsb	*_g+START		# enter the program proper
#
# A return from START is equivalent to a call of STOP(0).
#
	subl2	$8,sp			# prepare to call STOP
	clrl	-(sp)
	subl2	$232,sp
	jsb	*_g+STOP		# never returns
#
# Global vector
#
	.comm	_g,SVSIZE*4
	.comm	_bcplge,4		# marks end of global vector
#
# End of file bcplst.s
#
