
// File bexecve.b

SECTION "_bexecve"

GET "rtshdr"

STATIC $(
p_acount    = ?   // Count of arguments
p_ecount    = ?   // Count of environment strings
p_name      = ?   // Pointer to new program name
p_argv      = ?   // Pointer to input ARGV
p_envp      = ?   // Pointer to input ENVP
$)

LET execve(name, argv, envp) = VALOF
$( LET p, size = 0, 0

   size := name%0/bytesperword + 1   // Allow space to copy 'name' string

   WHILE argv!p NE 0 DO
   $( LET n = (argv!p)%0   // Length of this argument

      size := size + n/bytesperword + 1   // Save enough space to copy it
      p := p + 1
   $)
   p_acount := p   // Count of arguments, including argument zero
   size := size + p_acount + 1   // Allow for terminator

   TEST envp NE 0 THEN
   $( p := 0
      WHILE envp!p NE 0 DO
      $( LET n = (envp!p)%0   // Length of this argument string
   
         size := size + n/bytesperword + 1   // Save enough space to copy it
         p := p + 1
      $)
      p_ecount := p   // Count of environment strings
   $)
   OR p_ecount := 0
   size := size + p_ecount + 1   // Allow for terminator

   p_name, p_argv, p_envp := name, argv, envp

   RESULTIS aptovec(myexecve, size - 1)
$)

AND myexecve(v, size) = VALOF
$( LET argv = v
   LET envp = argv + p_acount + 1   // Allow space for terminator
   LET name = envp + p_ecount + 1   // Allow space for terminator
   AND res = ?

   bcstr(p_name, name)   // Copy and convert filename
   v := name + p_name%0/bytesperword + 1   // Leave enough space for converted name

   FOR i = 0 TO p_acount - 1 DO
   $( LET p = p_argv!i

      argv!i := bcstr(p, v) << 2
      v := v + p%0/bytesperword + 1
   $)
   argv!p_acount := 0   // Terminator

   TEST p_envp NE 0 THEN
   $( FOR i = 0 TO p_ecount - 1 DO
      $( LET p = p_envp!i
   
         envp!i := bcstr(p, v) << 2
         v := v + p%0/bytesperword + 1
      $)
      envp!p_ecount := 0   // Terminator
   $)
   OR envp := 0

   res := uexecve(name << 2, argv << 2, envp << 2)

   result2 := res   // Might be useful

   RESULTIS res
$)

// End of file bexecve.b

