#
# BCPL library - catchsi.s
# Routine to arrange catching of signals
#
	.text
	.globl	_bcplgi
	.globl	_bcplotr
	.globl	_sigvec
#
	.globl	_catchsi
_catchsi:
#
	jbr	4f			# skip chain
#
1:	pushl	fp			# standard entry sequence
	addl3	$248,sp,fp
	movq	(sp)+,-4(fp)
	addl2	$228,sp			# parameters on top of stack
	popr	$0xc0			# parameters to r7,r6
	movl	$1,r8			# initialise signal number
	subl2	$12,sp			# space for signal vector
2:	ashl	$-1,r7,r7		# move to next bit
	jlbc	r7,3f			# j if not set
	tstl	r6			# interested in previous value?
	jeql	6f			# j if not
	movl	sp,r9
	pushl	r9
	clrl	-(sp)			# no new value
	pushl	r8			# stack signal number
	calls	$3,_sigvec		# get previous setting
	cmpl	(sp),$1			# see if it was SIG_IGN
	jeql	3f			# j if so - not to be altered
6:	clrl	8(sp)			# no signal stack
	clrl	4(sp)			# no mask change
	movl	$_bcplotr,(sp)		# signal handler
	clrl	-(sp)			# old value not needed
	pushl	r9			# space for new value
	pushl	r8			# stack signal number
	calls	$3,_sigvec
3:	aobleq	$27,r8,2b		# j if more to do
	addl2	$12,sp			# lose 'new value' vector
	movl	(sp)+,fp		# standard exit code
	rsb
#
# Global initialisation
#
4:	jsb	_bcplgi
	.long	CATCHSI/4,1b
	.long	-1
	jbr	5f			# avoid loader alignment problems
	.align	2
5:
#
# End of file catchsi.s
#
