
// File mapstat.b

SECTION "_mapstat"

GET "rtshdr"

LET mapstatics() BE
$( IF sv.stchain = 0 RETURN   // No STATIC names present
 
   $( LET no.online = 0
      AND chain = sv.stchain >> 2   // Word address of first STATIC name entry
 
      writef("*N*NValues of STATIC variables:*N")
 
      UNTIL chain = 0 DO
      $( IF no.online = 0 THEN
         $( no.online := 2
            newline()
         $)
         no.online := no.online - 1
 
         sv.writefn(chain + 2, 16, 16)
         wrch('=')
         sv.writeval(!(chain!1 >> 2))
         UNLESS no.online = 0 DO writes("    ")
 
         chain := !chain >> 2 REPEATUNTIL 0 LE (chain << 2) LE sv.highcode   // Skip over inter-segment links
      $)
   $)
   newline(); newline()
$)

// End of file mapstat.b

