
// File skelcon.b

SECTION "_skelcon"

GET "rtshdr"

LET contingency(signo, code, sigcontext, p) BE
$( IF signo = 2 THEN stop(255)   // Interrupt

   selectoutput(journal)

   writef("*N%S*N", sigreason(signo))

   stop(255)
$)

 .

SECTION "_conting"

GET "rtshdr"

LET sigreason(n) = VALOF SWITCHON n INTO
$( CASE 00:  RESULTIS "Jump to zero"
   CASE 01:  RESULTIS "Hangup"
   CASE 03:  RESULTIS "Quit"
   CASE 04:  RESULTIS "Illegal instruction"
   CASE 05:  RESULTIS "Trace trap"
   CASE 06:  RESULTIS "Signal 6"
   CASE 07:  RESULTIS "XFC instruction"
   CASE 08:  RESULTIS "Arithmetic exception"
   CASE 10:  RESULTIS "Bus error"
   CASE 11:  RESULTIS "Segmentation violation"
   CASE 12:  RESULTIS "Bad argument to system call"
   CASE 13:  RESULTIS "Broken pipe"
   CASE 14:  RESULTIS "Alarm clock"
   CASE 15:  RESULTIS "Software termination"
   CASE 16:  RESULTIS "Urgent condition on socket"
   CASE 18:  RESULTIS "Stop from keyboard"
   CASE 19:  RESULTIS "Continue after stop"
   CASE 20:  RESULTIS "Child status has changed"
   CASE 21:  RESULTIS "Background read from control terminal"
   CASE 22:  RESULTIS "Background write from control terminal"
   CASE 23:  RESULTIS "I/O possible on a descriptor"
   CASE 24:  RESULTIS "CPU time limit exceeded"
   CASE 25:  RESULTIS "File size limit exceeded"
   CASE 26:  RESULTIS "Virtual time alarm"
   CASE 27:  RESULTIS "Profiling timer alarm"

   DEFAULT:  RESULTIS "Unknown signal"
$)

// End of file skelcon.b

