
// File: BCPLCASE.B

// Version: V4.0   (also alter MANIFESTs below)

// BCPL source file case conversion program

// R.D. Eager   University of Kent   MCMLXXXVIII

// History:
//  E1.0   - Initial version
//  E1.1   - Correction  to 'rdstrch', to improve recovery after missing
//           quotes.
//  E2.0   - Modification  so  that  'ALL'  option translates lower case
//           character constants to hexadecimal numbers.
//  E3.0   - Addition of ESCAPECASE parameter.
//  E3.1   - Correction to handle OF keyword.
//  V4.0   - First VAX/VMS version; allows '$' in identifiers.

MANIFEST $(   // Alter these if changes are made
version = 4   // Major version number
edit    = 0   // Edit number within major version
$)

/* Stop codes:-
    0 - Success
 1000 - Workspace exhausted
*/

GET "BCPLCASE.H"
GET "DSCDEF.H"

MANIFEST $(   // CLI parser status codes
cli$_absent    = #X000381f0
$)

EXTERNAL $(
cli$get_value
cli$present
str$trim
$)


LET start() BE
$( LET size = ?
   AND status = ?
   AND outfile_ = ?
   AND verbose_ = ?
   AND infile = VEC maxstrlength/bytesperword
   AND dv = VEC maxstrlength/bytesperword
   AND outfile = VEC maxstrlength/bytesperword
   AND opt = VEC maxstrlength/bytesperword
   AND wsv = VEC maxstrlength/bytesperword
   AND ksv = VEC maxstrlength/bytesperword
   AND ecv = VEC maxstrlength/bytesperword

   dictname := dv
   dictfile_ := FALSE

   second_ := FALSE
   upper_, lower_, wch := FALSE, FALSE, wrch

   get_value("P1", infile)
   get_value("OUTPUT", outfile)
   IF outfile%0 = 0 THEN outfile := "NLA0:"
   get_value("OPTION", opt)
   dictfile_ := present("NAMEFILE")
   IF dictfile_ THEN get_value("NAMEFILE", dictname)
   get_value("WORKSIZE", wsv)
   get_value("KEYCASE", ksv)
   get_value("ESCAPECASE", ecv)
   verbose_ := present("VERBOSE")

   TEST matchstrings(opt, "UPPER") THEN upper_ := TRUE
   OR TEST matchstrings(opt, "LOWER") THEN lower_ := TRUE
   OR upper_, wch := TRUE, allupperwrch

   size := strtonum(wsv)
   UNLESS 2000 LE size LE 30000 DO fail(bcplcase_invqualval, "WORKSIZE" << 2)

   TEST matchstrings(ksv, "UPPER") THEN lowerkeys_ := FALSE
   OR TEST matchstrings(ksv, "LOWER") THEN lowerkeys_ := TRUE
   OR fail(bcplcase_invqualval, "KEYCASE" << 2)

   TEST matchstrings(ecv, "UPPER") THEN escape_case := ec.upper
   OR TEST matchstrings(ecv, "LOWER") THEN escape_case := ec.lower
   OR TEST matchstrings(ecv, "LEAVE") THEN escape_case := ec.leave
   OR fail(bcplcase_invqualval, "ESCAPECASE" << 2)

   IF verbose_ THEN
      message(bcplcase_version, version, edit)

   instream := findio(infile, findinput)
   outstream := findio(outfile, findoutput)

   aptovec(main, size)

   stop(0)
$)

AND fail(n, a, b, c) BE
/*  Outputs  the  message specified by 'n', with parameters 'a', 'b' and
'c', then stops with status 'n'. */
$( message(n, a, b, c)

   stop(n \/ #X10000000)
$)

AND findio(file, r) BE
/* Opens file 'file' using routine 'r'. Never returns if there is a
failure. */
$( LET strp = r(file)

   IF strp = 0 THEN
   $( LET res2 = result2

      message(r = findinput -> bcplcase_openin,
                               bcplcase_openout, file << 2)
      second_ := TRUE
      fail(res2, 0)
   $)
$)

AND get_value(key, result) BE
$( LET key_d = VEC dsc$k_s_bln/bytesperword - 1
   AND res_d = VEC dsc$k_s_bln/bytesperword - 1
   AND status = ?
   AND len = ?

   key_d%dsc$w_length := key%0
   key_d%(dsc$w_length+1) := 0
   key_d%dsc$b_dtype := dsc$k_dtype_t
   key_d%dsc$b_class := dsc$k_class_s
   key_d!(dsc$a_pointer/bytesperword) := (key << 2) + 1

   res_d%dsc$w_length := maxstrlength/bytesperword
   res_d%(dsc$w_length+1) := 0
   res_d%dsc$b_dtype := dsc$k_dtype_t
   res_d%dsc$b_class := dsc$k_class_s
   res_d!(dsc$a_pointer/bytesperword) := (result << 2) + 1

   cli$get_value(key_d << 2, res_d << 2)

   str$trim(res_d << 2, res_d << 2, @len << 2)
   result%0 := len
$)

AND matchstrings(a, b) = VALOF
$( LET l = a%0

   IF b%0 < l RESULTIS FALSE
   FOR i = 1 TO l DO
   UNLESS a%i = b%i RESULTIS FALSE
   RESULTIS TRUE
$)

AND message(n, a, b, c) BE
/* Obtains the message specified by 'n', and outputs it with specified
parameters. */
$( LET m = getmessage(n, 0)
   AND v = VEC maxstrlength/bytesperword
   AND args = VEC 2
   AND o = output()

   /* Put arguments into ascending address order */

   args!0 := a
   args!1 := b
   args!2 := c

   selectoutput(journal)
   IF a NE 0 THEN
   $( faostring(m, v, args)
      m := v
   $)
   IF second_ THEN
   $( m%1 := '-'
      second_ := FALSE
   $)
   writes(m); newline()

   selectoutput(o)
$)

AND present(key) = VALOF
$( LET key_d = VEC dsc$k_s_bln/bytesperword - 1
   AND status = ?

   key_d%dsc$w_length := key%0
   key_d%(dsc$w_length+1) := 0
   key_d%dsc$b_dtype := dsc$k_dtype_t
   key_d%dsc$b_class := dsc$k_class_s
   key_d!(dsc$a_pointer/bytesperword) := (key << 2) + 1

   status := cli$present(key_d << 2)

   RESULTIS (status & 1) NE 0
$)

AND strtonum(str) = VALOF
$( LET num, minus_ = 0, FALSE
   AND ptr = 1

   IF str%1 = '-' THEN
   $( minus_ := TRUE
      ptr := 2
   $)

   FOR i = ptr TO str%0 DO
      num := num*10 + str%i - '0'

   RESULTIS minus_ -> -num, num
$)

 .

GET "BCPLCASE.H"

LET main(t, ts) BE
$( LET cv = VEC maxstrlength
   AND wv = VEC maxstrlength/bytesperword

   charv, wordv := cv, wv

   treevec, treep := t, t + ts
   linecount := 0
   nametree := 0

   declsyswords()

   IF dictfile_ DO
   $( LET dictstream = findio(dictname, findinput)

      selectinput(dictstream)
      echo_ := FALSE
      settag_ := TRUE
      rch(FALSE)
      readprog()
      endread()
   $)

   echo_ := TRUE
   settag_ := FALSE
   selectinput(instream)
   selectoutput(outstream)
   rch(FALSE)
   readprog()
   endread()
$)

AND readprog() BE
$( SWITCHON ch INTO
   $( CASE '*P':
      CASE '*N':   linecount := linecount + 1 
      CASE '*T':
      CASE '*S':   rch(echo_) REPEATWHILE ch = '*S'
                   LOOP

      CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
      CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
                   readnum(10)
                   LOOP

      CASE 'a':CASE 'b':CASE 'c':CASE 'd':CASE 'e':
      CASE 'f':CASE 'g':CASE 'h':CASE 'i':CASE 'j':
      CASE 'k':CASE 'l':CASE 'm':CASE 'n':CASE 'o':
      CASE 'p':CASE 'q':CASE 'r':CASE 's':CASE 't':
      CASE 'u':CASE 'v':CASE 'w':CASE 'x':CASE 'y':
      CASE 'z':
      CASE 'A':CASE 'B':CASE 'C':CASE 'D':CASE 'E':
      CASE 'F':CASE 'G':CASE 'H':CASE 'I':CASE 'J':
      CASE 'K':CASE 'L':CASE 'M':CASE 'N':CASE 'O':
      CASE 'P':CASE 'Q':CASE 'R':CASE 'S':CASE 'T':
      CASE 'U':CASE 'V':CASE 'W':CASE 'X':CASE 'Y':
      CASE 'Z':
      CASE '{':
      CASE '}':
                   rdtag()
                   writetag()
                   LOOP

      CASE '$':    rch(echo_)
                   TEST ch = '(' \/ ch = ')' THEN 
                   $( rdtag()
                      writetag()
                   $)
                   ELSE rch(echo_)
                   LOOP

      CASE '/':    rch(echo_)
                   IF ch = '\' THEN
                   $( rch(echo_)
                      LOOP
                   $)
                   IF ch = '**' THEN
                   $( readcomment('/')
                      LOOP 
                   $)
                   UNLESS ch = '/' LOOP

      comment:     rch(echo_) REPEATUNTIL iscc(ch) \/ ch = endstreamch
                   LOOP

      CASE '|':    rch(echo_)
                   IF ch = '|' GOTO comment
                   UNLESS ch = '**' LOOP
                   readcomment('|')
                   LOOP

      CASE '#':    $( LET radix = 8

                      rch(echo_)
                      TEST ch = 'B' THEN
                      $( radix := 2
                         rch(echo_)
                      $)
                      ELSE TEST ch = 'O' THEN
                         rch(echo_)
                      ELSE IF ch = 'X' THEN
                      $( radix := 16
                         rch(echo_)
                      $)
                      readnum(radix)
                      LOOP
                   $)

      CASE '*"':   rch(echo_)
                   FOR i = 1 TO maxstrlength DO
                   $( IF ch = '*"' BREAK
                      rdstrch(TRUE)
                   $)
                   rch(echo_)
                   LOOP

      CASE '*'':   rch(echo_)
                   rdstrch(FALSE)            // drop through

      DEFAULT:     rch(echo_)
                   LOOP

      CASE endstreamch:
                   RETURN
   $)
$) REPEAT

AND iscc(ch) = (ch = '*N') \/ (ch = '*P') \/ (ch = '*C')

AND readcomment(term) BE
$( rch(echo_)
   $( IF iscc(ch) THEN linecount := linecount + 1
      IF ch = '**' THEN
      $( rch(echo_)
         UNLESS ch = term LOOP
         rch(echo_)
         RETURN
      $)
      IF ch = endstreamch THEN
      $( error("End of file encountered in comment")
         stop(0)
      $)
      rch(echo_)
   $) REPEAT
$)

AND lookupword(makenew_) = VALOF
$( LET p = @nametree

   wordnode := !p

   UNTIL wordnode = 0 DO
   $( LET cmp = cmpstr(wordv, wordnode+2)

      IF cmp = 0 RESULTIS wordnode+2
      p := wordnode + (cmp < 0 -> 0, 1)
      wordnode := !p
   $)

   IF makenew_ THEN
   $( wordnode := newvec(wordsize+2)
      wordnode!0, wordnode!1 := 0, 0
      FOR i = 0 TO wordsize DO wordnode!(i+2) := wordv!i
      !p := wordnode
   $)
   RESULTIS 0
$)

AND cmpstr(s1, s2) = VALOF
$( LET len1, len2 = s1%0, s2%0

   FOR i = 1 TO len1 DO
   $( LET ch1, ch2 = s1%i, s2%i

      IF i > len2 RESULTIS 1
      IF 'a' LE ch1 LE 'z' DO ch1 := ch1 - 'a' + 'A'
      IF 'a' LE ch2 LE 'z' DO ch2 := ch2 - 'a' + 'A'
      IF ch1 > ch2 RESULTIS 1
      IF ch1 < ch2 RESULTIS -1
   $)
   IF len1 < len2 RESULTIS -1
   RESULTIS 0
$)

AND declsyswords() BE
$( d("ABS/AND/*
     *BE/BREAK/BY/*
     *CASE/*
     *DO/DEFAULT/*
     *EXTERNAL/EQ/EQV/ELSE/ENDCASE/*
     *FALSE/FOR/FINISH/*
     *GOTO/GE/GR/GLOBAL/GET/*
     *IF/INTO/*
     *LET/LV/LE/LS/LOGOR/LOGAND/LOOP/LSHIFT//")

   d("MANIFEST/*
     *NEEDS/NE/NOT/NEQV/*
     *OF/OR/*
     *RESULTIS/RETURN/REM/RSHIFT/RV/*
     *REPEAT/REPEATWHILE/REPEATUNTIL/*
     *SLCT/SECTION/SWITCHON/STATIC/*
     *TO/TEST/TRUE/THEN/TABLE/*
     *UNTIL/UNLESS/*
     *VEC/VALOF/*
     *WHILE//")

   lowerkeys_ := FALSE
$)

AND d(words) BE
$( LET i, length = 1, 0

   $( LET ch = words%i

      TEST ch = '/' THEN
      $( IF length = 0 RETURN
         charv!0 := length
         IF lowerkeys_ THEN
         $( FOR i = 1 TO length DO
               IF 'A' LE charv!i LE 'Z' THEN
                  charv!i := charv!i - 'A' + 'a'
         $)
         wordsize := packstring(charv, wordv)
         lookupword(TRUE)
 
         length := 0
      $)
      ELSE
      $( length := length + 1
         charv!length := ch
      $)
      i := i + 1
   $) REPEAT
$)

AND rch(echo_) BE
$( IF echo_ THEN wch(ch)
   ch := rdch()
$)

AND rdtag() BE
$( LET n = 1

   charv!1 := ch

   $( rch(FALSE)
      UNLESS 'A' LE ch LE 'Z' \/
             'a' LE ch LE 'z' \/
             '0' LE ch LE '9' \/
              ch = '$' \/
              ch = '_' \/
              ch = '.' BREAK
      n := n + 1
      charv!n := ch
   $) REPEAT

   charv!0 := n
   wordsize := packstring(charv, wordv)
$)

AND writetag() BE
$( LET mode = lookupword(settag_)

   TEST mode = 0 THEN
   $( IF upper_ THEN
      $( FOR i = 1 TO charv!0 DO
         $( LET ch = charv!i

            IF 'a' LE ch LE 'z' THEN charv!i := ch - 'a' + 'A'
         $)
         packstring(charv, wordv)
      $)
      IF lower_ THEN FOR i = 1 TO charv!0 DO
      $( LET ch = charv!i

         IF 'A' LE ch LE 'Z' THEN charv!i := ch - 'A' + 'a'
      $)
      IF echo_ THEN FOR i = 1 TO charv!0 DO wch(charv!i)
   $)
   ELSE IF echo_ DO writes(mode)
$)

AND allupperwrch(ch) BE
$( IF 'a' LE ch LE 'z' THEN ch := ch - 'a' + 'A'
   wrch(ch)
$)

AND readnum(radix) BE
   UNTIL value(ch) GE radix DO rch(echo_)

AND value(ch) = '0' LE ch LE '9' -> ch - '0',
                'a' LE ch LE 'f' -> ch - 'a' + 10,
                'A' LE ch LE 'F' -> ch - 'A' + 10,
                100

AND rdstrch(trans_) = VALOF
$( LET k = ch

   TEST (#x00 LE ch LE #x5f) \/ trans_ \/ NOT upper_ THEN
      rch(echo_)
   OR
   $( writef("**X%X2", ch)
      rch(FALSE)
   $)

   IF k = '*N' THEN
   $( error("Incorrect use of newline in string")
      k := '*"'
      ch := k
   $)

   IF k = '**' THEN
   $( IF ch = '*N' \/ ch = '*S' \/ ch = '*T' THEN
      $( $( IF ch = '*N' DO linecount := linecount + 1
            rch(echo_)
         $) REPEATWHILE ch = '*N' \/ ch = '*S' \/ ch = '*T'
         rch(echo_)
         RESULTIS rdstrch()
      $)

      SWITCHON escape_case INTO
      $( DEFAULT:
         CASE ec.leave:
            rch(echo_)
            ENDCASE

         CASE ec.upper:
            allupperwrch(ch)
            rch(FALSE)
            ENDCASE

         CASE ec.lower:
            IF 'A' LE ch LE 'Z' THEN ch := ch - 'A' + 'a'
            wch(ch)
            rch(FALSE)
            ENDCASE
      $)
   $)
   RESULTIS k
$)

AND newvec(n) = VALOF
$( treep := treep - n - 1
   IF treep LE treevec THEN
      fail(bcplcase_insvirmem, 0)

   RESULTIS treep
$)

AND error(mess) BE
$( message(bcplcase_progerr1, linecount)
   second_ := TRUE
   message(bcplcase_progerr2, mess << 2)
$)

// End of file: BCPLCASE.B


