
// File: BCPLCASE.H

// Header file for BCPL source file case conversion program

// R.D. Eager   University of Kent   MCMLXXXVIII

GET "LIBHDR"

MANIFEST $( gpb = firstfreeglobal $)

GLOBAL $(
allupperwrch        : gpb+000
fail                : gpb+001
findio              : gpb+002
main                : gpb+003
message             : gpb+004
wch                 : gpb+005
$)

MANIFEST $( gvb = gpb + 006 $)

GLOBAL $(
ch                  : gvb+000
charv               : gvb+001
dictfile_           : gvb+002
dictname            : gvb+003
echo_               : gvb+004
escape_case         : gvb+005
instream            : gvb+006
linecount           : gvb+007
lower_              : gvb+008
lowerkeys_          : gvb+009
nametree            : gvb+010
outstream           : gvb+011
second_             : gvb+012
settag_             : gvb+013
treep               : gvb+014
treevec             : gvb+015
upper_              : gvb+016
word                : gvb+017
wordnode            : gvb+018
wordsize            : gvb+019
wordv               : gvb+020
$)

MANIFEST $(   // Message codes
facility                = #X08098000
severity_informational  = 3
severity_fatal          = 4

bcplcase_invqualval     = facility \/ severity_fatal \/ (1 << 3)
bcplcase_openin         = facility \/ severity_fatal \/ (2 << 3)
bcplcase_openout        = facility \/ severity_fatal \/ (3 << 3)
bcplcase_progerr1       = facility \/ severity_fatal \/ (4 << 3)
bcplcase_progerr2       = facility \/ severity_fatal \/ (5 << 3)
bcplcase_insvirmem      = facility \/ severity_fatal \/ (6 << 3)

bcplcase_version        = facility \/ severity_informational \/ (51 << 3)
$)

MANIFEST $(   // Values for 'escape_case'
ec.leave            = 0   // Leave escaped characters alone
ec.upper            = 1   // Force escaped characters to upper case
ec.lower            = 2   // Force escaped characters to lower case
$)

// End of file: BCPLCASE.H


