.NA "BCPLCASE - a case conversion program for BCPL source" "R.D Eager"
.HD August 1982 DOC/EMAS/K3.9/8
.RV "June 1985 (1)"
.KE BCPL,CASE CONVERSION
.S1 Introduction
.PG
This document describes a program for processing BCPL source files.  Its
action  is  to  translate  some  or  all  of the identifiers (optionally
including BCPL keywords) from upper case to lower case, or  vice  versa.
There are facilities for conversion of a selected set of identifiers
to a mixture of upper and lower case.
.PG
Selected components of string and character constants may also be converted.
.S1 "Access"
.PG
Before the program can be used for the first time, its object file  must
be  inserted  into  a  directory  in  the user's search list.
To  do
this, issue the command:
.sp
.CP
INSERT(PUBLIC.BCPLCASE)
.EC
.S1 "Program call"
.PG
BCPLCASE takes several parameters; only the first two are mandatory.
.PS
.PA INPUT 1 "Input file" none
This is the name of the file to be converted.
.PA OUTPUT 2 "Output file" none
This  is  the  name  of the file in which the converted program is to be
stored.
.PA OPTION 3 "Conversion option" LOWER
This parameter may be UPPER (to  convert  identifiers  to  Upper  case),
LOWER  (to convert identifiers to Lower case), or ALL (to convert All of
the file, including comments and strings, to upper case).
.PA NAMEFILE 4 "Dictionary file" none
If this parameter is included, it is taken as the name of the dictionary
file.  See Section 4 for more details on the use of this file.
.PA WORKSIZE 5 "Workspace size" 10000
This parameter  specifies  the  number  of  words  of  workspace  to  be
allocated for internal tables.  The default value is adequate for nearly
all programs.
.PA KEYCASE 6 "Case of keywords" UPPER
This  parameter  controls  the  case  in which BCPL keywords are output.
Possible values are UPPER and LOWER.
.PA ESCASE 7 "Case of escaped characters" LEAVE
This parameter affects the escaped characters (those following the `*'
character in strings and character constants). It may take the value LEAVE
(to leave such characters as they are), LOWER (to convert them to lower case)
or UPPER (to convert them to upper case). The OPTION values UPPER and ALL
override the setting of ESCAPECASE if LOWER or LEAVE are used in the same run.
.PE
.S1 "The dictionary file"
.PG
If a dictionary file is not specified, a blanket conversion  is  carried
out   on  all  characters  of  each  identifier.   However,  identifiers
appearing in the dictionary file, which are the same (without regard  to
case)  as  identifiers appearing in the input file, cause the conversion
process to be modified.  Such identifiers are  converted  to  the  exact
form appearing in the dictionary file; all others are treated normally.
.PG
For  example,  if  the  identifier 'ReadProg' appeared in the dictionary
file, all occurrences of 'readprog', 'READPROG', 'Readprog' etc. in  the
input file would be converted to 'ReadProg'.
.PG
The dictionary file is free-format; identifiers are separated by one  or
more spaces, tabs or newlines.

