
// Version: D2.9   (also alter MANIFESTs below)

// BCPL code generator for DEC VAX-11 under VAX/VMS

// Copyright (C) R.D. Eager   University of Kent   MCMLXXXVIII


// History:
//  D1.0   - Initial VAX/VMS version (not this code at all).
//  D2.0   - First new version.
//  D2.1   - First version on UKC VAX cluster.
//  D2.2   - First locally generated version.
//  D2.3   - Added automatic NEEDS calls for all of library, thus allowing use of object library.
//  D2.4   - Fixed automatic NEEDS call by using .EXTERNAL (not .GLOBAL) and using /LIBRARY only (not /INCLUDE).
//  D2.5   - Fixed local labels.
//         - Suppressed library references when compiling libraries.
//  D2.6   - Fixed local labels for multiple segment programs.
//  D2.7   - Fixed bug in 'cgswitch'; code was failing to increment 'loadp' for
//           the space occupied by case table entries.
//  D2.8   - Fixed EXTERNAL code to use G^ operand form.
//  D2.9   - Fixed 'genjumps' to switch to code PSECT before emitting code.

MANIFEST $(   // Alter these if changes are made
version = 2   // Major version number
edit    = 9   // Edit number within major version
$)


// 1 - System-dependent initialisation code

GET "b2.h"
GET "bcplcgmsg.h"

STATIC $(
p_ptr       = 0       // Pointer into parameter string
second_     = FALSE   // Set to TRUE iff second VMS message to be displayed
verbose_    = ?       // Controls whether additional informational messages are output
$)

LET start() BE
$( LET ocodename = VEC maxstrlength/bytesperword
   AND valfilename = VEC maxstrlength/bytesperword
   AND sourcename = VEC maxstrlength/bytesperword
   AND real_rdch = rdch
   AND valfilestream, ocodestream = ?, ?
   AND assemble_ = ?

   // Set non-alterable options

   autoneeds, debug, conststrings := FALSE, FALSE, FALSE
   IF metering_ THEN printstats := FALSE

   // Set default options

   verbose_, assemble_, tracing, profiling := FALSE, TRUE, FALSE, FALSE

   // Set up special reading function to handle parameters

   real_rdch := rdch                    // Save original value
   rdch := s_rdch                       // Reads from parameter string

   // Get filenames

   findtitles(ocodename, valfilename, sourcename)

   // Read option flags

   $( LET ch = gch()

      SWITCHON ch INTO
      $( CASE endstreamch:   BREAK
         CASE '*S':
         CASE '*T':
         CASE  ':':
         CASE  '/':          ENDCASE
         CASE  'V':          verbose_ := TRUE
                             ENDCASE
         CASE  'T':          tracing := TRUE
                             ENDCASE
         CASE  'P':          profiling := TRUE
                             ENDCASE
         CASE  'N':          assemble_ := FALSE
                             ENDCASE
         DEFAULT:            $( LET v = VEC 0

                                v%0 := 1
                                v%1 := ch

                                message(journal, bcplcg_unkflag, v << 2)
                             $)
      $)
   $) REPEAT

   rdch := real_rdch   // Restore 'rdch'

   // Open the OCODE file

   ocodestream := findio(ocodename, findinput, bcplcg_openin)
   selectinput(ocodestream)

   // Open the object file

   valfilestream := findio(valfilename, findoutput, bcplcg_openout)
   selectoutput(valfilestream)

   IF verbose_ THEN
      message(journal, bcplcg_version, version, edit)

   IF metering_ THEN init_statistics()

   cgen(sourcename, version, edit)

   endread(); endwrite()

   deletefile(ocodename)

   IF metering_ THEN
      IF printstats THEN
      $( selectoutput(sysout)
         print_statistics()
      $)

   IF assemble_ THEN
   $( LET strp = findio("CGEN.TMP", findoutput, bcplcg_openout)

      selectoutput(strp)
      writef("$ macro %S*N*
             *$ delete %S;0*N*
             *$ delete CGEN.TMP;0*N", valfilename, valfilename)
      endwrite()

      docommand("@CGEN.TMP")
   $)

   stop(0)
$)

AND encode(format, dest, a, b, c, d, e, f, g, h, i, j, k) BE
$( STATIC $( dvec = ?; dpt = ? $)

   LET e_wrch(ch) = VALOF
   $( dpt := dpt + 1
      dvec%dpt := ch
      RESULTIS 1
   $)
   LET oldwrch = wrch

   dvec, dpt := dest, 0
   wrch := e_wrch
   writef(format, a, b, c, d, e, f, g, h, i, j, k)
   wrch := oldwrch
   dvec%0 := dpt
$)

AND fail(n, a, b, c) BE
/*  Outputs  the  message specified by 'n', with parameters 'a', 'b' and
'c', then stops with status 'n'. */
$( message(journal, n, a, b, c)

   stop(n \/ #X10000000)
$)

AND findio(file, r, err_code) = VALOF
/* Opens 'file' using routine 'r', yielding a stream pointer. Does not
return if there is any error; instead, an error is indicated using the
supplied error code 'err_code'. */
$( LET strp = r(file)

   IF strp = 0 THEN
   $( message(journal, err_code, file << 2)
      second_ := TRUE
      fail(result2, 0)
   $)

   RESULTIS strp
$)

AND findtitles(ocodename, valfilename, sourcename) BE
/* Obtains the OCODE file name and object file name from the command
line, and generates a source title. */
$( LET p, ch = 0, ?

   // Obtain the OCODE file name from the command line

   ch := gch() REPEATWHILE ch = '*S'    // Lose leading white space

   UNTIL ch = '/' \/ ch = '*S' \/ ch = endstreamch DO
   $( p := p + 1
      ocodename%p := ch
      ch := gch()
   $)
   ocodename%0 := p

   // Obtain the object file name from the command line

   ch := gch() REPEATWHILE ch = '*S'    // Lose leading white space

   p := 0
   UNTIL ch = '/' \/ ch = '*S' \/ ch = endstreamch DO
   $( p := p + 1
      valfilename%p := ch
      ch := gch()
   $)
   valfilename%0 := p

   // Generate the source name from the filename stem

   $( LET l = 0

      FOR i = 1 TO ocodename%0 DO
      $( LET c = ocodename%i

         IF c = '.' BREAK
         sourcename%i := c
         l := l + 1
      $)
      sourcename%0 := l
   $)
$)

AND gch() = VALOF
/* Yields the next input character, forced to upper case. */
$( LET k = rdch()

   IF k = '*T' RESULTIS '*S'

   RESULTIS 'a' <= k <= 'z' -> k - ('a'-'A'), k
$)

AND message(stream, n, a, b, c) BE
/* Obtains the message specified by 'n', and outputs it with specified
parameters. */
$( LET m = getmessage(n, 0)
   AND v = VEC maxstrlength/bytesperword
   AND args = VEC 2
   AND o = output()

   /* Put arguments into ascending address order */

   args!0 := a
   args!1 := b
   args!2 := c

   selectoutput(stream)
   IF a NE 0 THEN
   $( faostring(m, v, args)
      m := v
   $)
   IF second_ THEN
   $( m%1 := '-'
      second_ := FALSE
   $)
   writes(m); newline()

   selectoutput(o)
$)

AND report(mes, a, b, c, d, e, f) BE
$( LET s = VEC maxstrlength/bytesperword

   encode(mes, s, a, b, c, d, e, f)
   message(journal, bcplcg_faterr, s << 2)

   IF debugging THEN abort(0)

   stop(bcplcg_faterr)
$)

AND s_rdch() = VALOF
/* Acts as a replacement for 'rdch', yielding the next character from
the command line. */
$( IF p_ptr >= param%0 RESULTIS endstreamch
   p_ptr := p_ptr + 1
   RESULTIS param%p_ptr
$)

AND comment(mes, a, b, c, d, e, f) BE
$( LET s = VEC maxstrlength/bytesperword

   encode(mes, s, a, b, c, d, e, f)
   message(journal, bcplcg_usrwarn, s << 2)

   comments := comments + 1
$)

AND compilererror(mes, a, b, c, d, e, f) BE
$( LET s = VEC maxstrlength/bytesperword

   encode(mes, s, a, b, c, d, e, f)
   message(journal, bcplcg_fatinterr, s << 2)

   abort(bcplcg_fatinterr)
$)

// End of file b21.b


