
// File b23.b

// 3 - Code executed for each BCPL segment

GET "b2.h"

LET trans(file) BE
$( clear_bitmap(labmap, max.labels + 1)
   FOR i = 0 TO max.labels DO labv!i, labt!i := 0, l.null
   labv!0 := maxint
   redlab := 0
   paramno := max.labels
   hwlabel := -1

   staticchain := -1   // Initialise STATIC name chain

   op := readop()
   process_section_and_needs()
   IF op = s.end RETURN   // End of OCODE file
   UNLESS op = s.stack \/ op = s.mark DO
      report("corrupt OCODE file")

   ssf := readnum()
   initstack(ssf)   // Initialises PENDINGOP as well
   incode_ := TRUE

   $( LET l = nextparam()

      compbranch(i.brb, k.blab, l)   // Jump round main code
      incode_ := FALSE

      clear_slaves()
      clear_locks()

      gencode(file)

      IF debugging THEN check_locks()

      setarea(a.code)
      complab(l, TRUE)   // Ensure that this label is not 'profiled'
   $)

   cgglobal()

   IF staticchain NE -1 THEN
   $( writes(";*N; STATIC name linkage*N;*N")

      comps(i.jsb, k.extern, "BCP$SNI")
      compwl(staticchain)
      loadp := loadp + 4
   $)

   cursect := cursect + 1
   IF cursect = 'Z' THEN cursect := '.'
$) REPEAT

AND cgglobal() BE
$( writes(";*N; Global initialisation*N;*N")

   comps(i.jsb, k.extern, tracing -> "BCP$SGI", "BCP$GI")

   FOR i = 1 TO globaln DO
   $( LET n = readnum()
      LET l = readl()

      IF n > hwglobal THEN hwglobal := n
      writef("*T.LONG*T*T%N*N", n + svsize)
      writef("*T.ADDRESS*TL%C%N*N", cursect, l)
      loadp := loadp + 8
   $)

   writes("*T.LONG*T-1*N")   // Terminator
   loadp := loadp + 4
$)

AND process_section_and_needs() BE
$( LET v = VEC maxstrlength/bytesperword + 1
   AND n = ?

   WHILE op = s.section \/ op = s.needs DO
   $( n := readnum()
      FOR i = 1 TO n DO v%i := readnum()
      v%0 := n
      cgsection_or_needs(op, v)
      op := readop()
   $)
$)

// End of file b23.b


