
// File b26.b

// 6 - Simulated stack handling

GET "b2.h"

LET store(a, b) BE
$( LET base, p = h3!tempv, ?
   AND r, l = ?, ?

   IF a < base THEN a := base
   IF b > ssp - 1 THEN b := ssp - 1

   p := tempv + (a - base)*tempsize

   UNTIL a > b DO
   $( UNLESS local(p) DO
      $( l := h3!p
         IF l > ssf THEN asf(l - ssf)
         UNLESS h1!p = k.reg DO
         $( r := findslave(h1!p, h2!p, 0)
            IF r NE r.null THEN
            $( h1!p, h2!p := k.reg, r
               IF metering_ THEN add_statistic(23)
            $)
         $)
         TEST l < ssf THEN
            compd(i.movl, h1!p, h2!p, k.loc, l)
         OR
            comps(i.pushl, h1!p, h2!p)
         discardslaves(k.loc, l)
         IF h1!p = k.reg THEN slave(h2!p, k.loc, l, 0)

         h1!p, h2!p := k.temp, l
      $)
      a, p := a + 1, p + tempsize
   $)
$)

AND local(a) = ((h1!a = k.loc) \/ (h1!a = k.temp)) & h2!a = h3!a

AND initstack(n) BE
$( arg2, arg1 := tempv, tempv + tempsize
   UNLESS ssf = n DO asf(n - ssf)

   ssp, ssf := n, n
   pendingop := s.none

   h1!arg2, h2!arg2, h3!arg2 := k.loc, n - 2, n - 2
   h1!arg1, h2!arg1, h3!arg1 := k.loc, n - 1, n - 1
$)

AND loadt(v, a) BE
$( cgpendingop()
   arg2 := arg1
   arg1 := arg1 + tempsize
   IF debugging THEN
      IF arg1 GE tempv + tempvsize*tempsize DO
         compilererror("overflow of simulated stack")
   h1!arg1, h2!arg1, h3!arg1 := v, a, ssp
   ssp := ssp + 1
$)

AND stack(n) BE
$( pendingop := s.none

   IF n > ssp + 3 THEN
   $( store(0, ssp - 1)
      initstack(n)
      RETURN
   $)

   WHILE n > ssp DO loadt(k.loc, ssp)

   UNTIL n = ssp DO
   $( discardslaves(k.loc, h3!arg1)
      IF arg2 = tempv THEN
      $( TEST n = (ssp - 1) THEN
         $( asf(n - ssf)
            ssp := n
            h1!arg1, h2!arg1, h3!arg1 := h1!arg2, h2!arg2, h3!arg2
            h1!arg2, h2!arg2, h3!arg2 := k.loc, ssp - 2, ssp - 2
         $)
         OR initstack(n)
         RETURN
      $)
      arg1, arg2 := arg1 - tempsize, arg2 - tempsize
      ssp := ssp - 1
   $)

   IF ssf > ssp THEN asf(ssp - ssf)
$)

AND storein(k, n) BE
$( LET b = (h1!arg1 = k & h2!arg1 = n) -> 1,
           (h1!arg2 = k & h2!arg2 = n) -> 2, 0
   LET rand1, rand2 = arg1, arg2

   IF b = 0 GOTO gencase   // Nothing matches
   IF b = 1 THEN rand1, rand2 := arg2, arg1   // Bring matched item into RAND2

   SWITCHON pendingop INTO
   $( DEFAULT:
      gencase:
         cgpendingop()
         discardslaves(k, n)
         IF k = k.loc & n > ssf THEN asf(n - ssf)
         TEST k = k.loc & n = ssf THEN
            comps(i.pushl, h1!arg1, h2!arg1)
         OR
            compd(i.movl, h1!arg1, h2!arg1, k, n)
         IF h1!arg1 = k.reg THEN slave(h2!arg1, k, n, 0)
         stack(ssp - 1)
         RETURN

      CASE s.neqv:
         compd(i.xorl2, h1!rand1, h2!rand1, k, n)
         IF metering_ THEN add_statistic(4)
         discardslaves(k, n)
         ENDCASE

      CASE s.plus:
         IF numberis(0, rand1) ENDCASE
         TEST numberis(1, rand1) THEN
         $( comps(i.incl, k, n)
            IF metering_ THEN add_statistic(5)
         $)
         OR TEST numberis(-1, rand1) THEN
         $( comps(i.decl, k, n)
            IF metering_ THEN add_statistic(6)
         $)
         OR
         $( compd(i.addl2, h1!rand1, h2!rand1, k, n)
            IF metering_ THEN add_statistic(7)
         $)
         discardslaves(k, n)
         ENDCASE

      CASE s.minus:
         IF numberis(0, rand1) ENDCASE
         TEST b = 1 THEN   // Reversed operands - use SUBL3
         $( compt(i.subl3, k, n, h1!rand1, h2!rand1, k, n)
            IF metering_ THEN add_statistic(9)
         $)
         OR TEST numberis(1, rand1) THEN
         $( comps(i.decl, k, n)
            IF metering_ THEN add_statistic(6)
         $)
         OR TEST numberis(-1, rand1) THEN
         $( comps(i.incl, k, n)
            IF metering_ THEN add_statistic(5)
         $)
         OR
         $( compd(i.subl2, h1!rand1, h2!rand1, k, n)
            IF metering_ THEN add_statistic(8)
         $)
         discardslaves(k, n)
         ENDCASE

      CASE s.mult:
         IF numberis(1, rand1) ENDCASE
         TEST numberis(0, rand1) THEN
            comps(i.clrl, k, n)
         OR compd(i.mull2, h1!rand1, h2!rand1, k, n)
         IF metering_ THEN add_statistic(10)
         discardslaves(k, n)
         ENDCASE

      CASE s.div:
         IF numberis(1, rand1) ENDCASE
         TEST b = 1 THEN   // Reversed operands - use DIVL3
         $( compt(i.divl3, k, n, h1!rand1, h2!rand1, k, n)
            IF metering_ THEN add_statistic(12)
         $)
         OR
         $( compd(i.divl2, h1!rand1, h2!rand1, k, n)
            IF metering_ THEN add_statistic(11)
         $)
         discardslaves(k, n)
         ENDCASE

      CASE s.logor:
         compd(i.bisl2, h1!rand1, h2!rand1, k, n)
         IF metering_ THEN add_statistic(13)
         discardslaves(k, n)
         ENDCASE

      CASE s.logand:
         TEST h1!rand1 = k.numb THEN
            compd(i.bicl2, k.numb, NOT h2!rand1, k, n)
         OR
         $( compd(i.mcoml, h1!rand1, h2!rand1, k.reg, r.ap)
            compd(i.bicl2, k.reg, r.ap, k, n)
         $)
         IF metering_ THEN add_statistic(14)
         discardslaves(k, n)
         ENDCASE

      CASE s.lshift:
         IF b = 1 GOTO gencase   // Operands reversed - no good
         compt(i.ashl, h1!rand1, h2!rand1, k, n, k, n)
         IF metering_ THEN add_statistic(15)
         discardslaves(k, n)
         ENDCASE

      CASE s.rshift:
         IF b = 1 \/ h1!rand1 NE k.numb GOTO gencase   // Only worth it for simple case
         compq(i.extzv, k.numb, h2!rand1, k.numb, 32 - h2!rand1, k, n, k, n)
         IF metering_ THEN add_statistic(16)
         discardslaves(k, n)
         ENDCASE
   $)
   stack(ssp - 2)
$)

// End of file b26.b


