
// File b2a.b

// A - Switch handling routines

GET "b2.h"

STATIC $( defaultlabel = ? $)

STATIC $( caselv = ?; caseuv = ?; casel = ? $)

LET cgswitch(n) BE
$( LET clv = VEC maxswitchlabels
   AND cuv = VEC maxswitchlabels
   AND clab = VEC maxswitchlabels
   AND r = ?

   IF n > maxswitchlabels THEN
      report("too many CASEs in a SWITCHON")

   defaultlabel := readl()

   cgpendingop()
   store(0, ssp - 2)
   r := movetoanyr(arg1)
   stack(ssp - 1)
   clear_slaves()

   FOR i = 1 TO n DO
   $( LET k = readnum()
      LET l = readl()
      AND j = i - 1

      UNTIL j = 0 DO
      $( IF k GE clv!j BREAK
         clv!(j + 1), cuv!(j + 1), clab!(j + 1) := clv!j, cuv!j, clab!j
         j := j - 1
      $)
      clv!(j + 1), cuv!(j + 1), clab!(j + 1) := k, k, l
   $)

   // Merge adjoining CASEs

   FOR i = n - 1 TO 1 BY -1 DO
   $( LET pll, plu = labv!(clab!i), labv!(clab!(i + 1))

      UNLESS pll = plu LOOP   // They don't label the same code

      UNLESS (cuv!i + 1) = clv!(i + 1) LOOP   // They aren't adjacent values

      cuv!i := cuv!(i + 1)
      n := n - 1
      FOR j = i + 1 TO n DO
         clv!j, cuv!j, clab!j := clv!(j + 1), cuv!(j + 1), clab!(j + 1)
   $)

   caselv, caseuv, casel := clv, cuv, clab

   switch(1, n, FALSE, FALSE, r)

$)

AND switch(b, t, lwb, upb, r) BE
$( LET size, ncases = 0, t - b + 1
   AND l = caselv!b               // Lowest CASE value
   AND u = caseuv!t               // Highest CASE value
   LET range = (u - l + 1)*2 + 6 + opsize(l) + opsize(r)

   FOR i = b TO t DO
      size := size + (caselv!i = caseuv!i -> 9, 18)

   TEST size < range THEN
   $( TEST ncases LE 5 THEN
      $( FOR i = b TO t DO
         $( TEST caselv!i = caseuv!i THEN
               reljump(i.beql, caselv!i, casel!i, r)
            OR
            $( LET lab = nextparam()

               reljump(i.blss, caselv!i, lab, r)
               reljump(i.bleq, caseuv!i, casel!i, r)
               compl(lab)
            $)
         $)
         compbranch(i.brb, k.blab, defaultlabel)
      $)
      OR
      $( LET half = b + ncases/2
         AND lab = nextparam()

         reljump(i.bgtr, caseuv!half, lab, r)
         switch(b, half, lwb, TRUE, r)
         compl(lab)
         switch(half + 1, t, FALSE, upb, r)
      $)
   $)
   OR
   $( UNLESS lwb DO
         reljump(i.blss, l, defaultlabel, r)

      UNLESS upb DO
         reljump(i.bgtr, u, defaultlabel, r)

      checklabrefs((u - l + 1)*2 + 18)

      compt(i.casel, k.reg, r, k.numb, l, k.numb, u - l)

      $( LET baselab = nextparam()

         compl(baselab)

         FOR i = l TO u DO
         $( TEST (b > t) \/ (caselv!b > i) THEN
               writef("*T.WORD*TL%C%N-L%C%N*N", cursect, defaultlabel, cursect, baselab)
            OR
            $( writef("*T.WORD*TL%C%N-L%C%N*N", cursect, casel!b, cursect, baselab)
               IF i = caseuv!b THEN b := b + 1
            $)
            loadp := loadp + 2
         $)
      $)
   $)
$)

AND opsize(n) = 0 LE n LE 63 -> 1,
                -128 LE n LE 127 -> 2,
                -32768 LE n LE 32767 -> 3, 5

AND reljump(op, val, lab, r) BE
$( TEST val = 0 THEN
      comps(i.tstl, k.reg, r)
   OR
      compd(i.cmpl, k.reg, r, k.numb, val)

   checklabrefs(9)
   compbranch(op, k.blab, lab)
$)

// End of file b2a.b


