$!
$! Drive generation of BCPL MANIFEST header file from MACRO definitions
$!
$! Usage:
$!		@B_DEFS	name
$!
$! where $NAME is a definitional macro in either STARLET.MLB or LIB.MLB.
$! Output: []'p1'.H
$!
$! Note:  This command file can be changed to produce files in languages other
$! than BCPL.  To do this, change the definitions of "lang" and "type" to the
$! language name and default file type for include files; the "write DEFS_MAR"
$! statements to create header and trailer comments appropriate to the new
$! language; and the definition of the macro EMIT to produce the right kind
$! of definition lines.
$!
$! Originally written and posted to INFOVAX by:
$!
$! W.J.Moeller, GWDG, D-3400 Goettingen, F.R.Germany  <GWD21T@DGOGWD01.BITNET>
$!                                                 Phone +49 551 201516
$!
$! Later revised by Jerry Leichter (LEICHTER@YALE)
$! 
$! Revision History
$! 0.0	??-???-?? WJM	Creation
$! 1.0	 6-Apr-87 JSL	Centralize actual creation of output lines in the EMIT
$!			macro; this makes changes a lot easier.  Similarly,
$!			define the output file type ("type") and the language
$!			("lang") in symbols to simplify changes.  Allow for
$!			special handling of negative values in EMIT - for C,
$!			wrap them in parentheses.  Try to warn the user if
$!			it looks like there was an error.
$ set noon
$ on control_y then goto fin
$ lang = "BCPL"
$ type = "H"
$ open/write DEFS_MAR []defs.tmp
$ write DEFS_MAR "    .print;//"
$ write DEFS_MAR "    .print;// File: ''p1'.''type'"
$ write DEFS_MAR "    .print;//"
$ write DEFS_MAR "    .print;// Definitions created by ''lang'_DEFS",	-
					" at ''f$time()'"
$ write DEFS_MAR "    .print;//"
$ write DEFS_MAR "    .print;"
$ write DEFS_MAR "    .print;MANIFEST $("
$ write DEFS_MAR "    $''p1'"
$ write DEFS_MAR "    .print;$)"
$ write DEFS_MAR "    .print;"
$ write DEFS_MAR "    .print;//"
$ write DEFS_MAR "    .print;// End of file: ''p1'.''type'"
$ write DEFS_MAR "    .print;//"
$ write DEFS_MAR "    .end"
$ close DEFS_MAR
$!
$ define/user SYS$ERROR 'p1'.'type	! MACRO puts .PRINT output here
$ macro/nolist/noobject SYS$INPUT+SYS$LIBRARY:LIB/LIB+SYS$DISK:[]defs.tmp
        .MACRO  $GBLINI GBL
	.MACRO	EMIT	SYM,VALUE
.print;SYM	= VALUE
	.ENDM
        .MACRO  $DEF    SYM,ALLOC,SIZ
        .if     NB,SYM
SYM:
	EMIT	SYM,\SYM
        .endc
        .IIF    NB,ALLOC,       ALLOC   SIZ
        .ENDM   $DEF
        .MACRO  $EQU    SYM,VAL
        SYM=VAL
	EMIT	SYM,\SYM
        .ENDM   $EQU
        .MACRO  $VIELD1 MOD,SEP,SYM,SIZ,MSK
        SIZ...=1
        .IIF    NB,SIZ, SIZ...=SIZ
        .IF     NB,SYM
        MOD'SEP'V_'SYM=BIT...
	EMIT	MOD'SEP'V_'SYM,\MOD'SEP'V_'SYM
        .if     nb,siz
MOD'SEP'S_'SYM=SIZ
	EMIT	MOD'SEP'S_'SYM,\MOD'SEP'S_'SYM
        .endc
        .if     nb,msk
MOD'SEP'M_'SYM=<<<1@SIZ...>-1>@BIT...>
	EMIT	MOD'SEP'M_'SYM,\MOD'SEP'M_'SYM
        .endc
        .ENDC
        BIT...=BIT...+SIZ...
        .ENDM   $VIELD1
        .ENDM   $GBLINI
$ 
$!
$ assign/user _NL: SYS$ERROR			!Avoid "No strings matched"
$ assign/user _NL: SYS$OUTPUT
$ search/nooutput 'p1'.'type' "%MACRO-"
$ if $severity .ne. 1 then goto fin
$ write SYS$ERROR "Error in producing ''p1'.''type' - file not usable."
$ write SYS$ERROR "(This probably means that there is no $",p1," macro.)"
$fin:
$ close/err=noerrdefs DEFS_MAR
$noerrdefs:
$ delete/nolog []defs.tmp;

