
// Segment 2


GET "bz.h"

LET cgen(work, size) = VALOF
$( STATIC $( copy_zbyte = 0 $)

   LET v = VEC simstacksize - 1
   AND r = VEC reglistsize - 1
   AND z = VEC zstacksize - 1
   AND n = VEC namestacksize*namesize/bytesperword - 1
   AND overall_maxgn = 1
   AND overall_data, overall_code, overall_reloc = ?, ?, ?

   namestack := n
   simstack := v
   reglist := r
   zstack := z

   // Ensure that codegenerator is serially reusable

   TEST copy_zbyte = 0 THEN
      copy_zbyte := zbyte
   OR
      zbyte := copy_zbyte

   zbytecopy := zbyte   // Used to bypass code lister where necessary

   code_heading_done_ := FALSE
   IF codelist_ THEN
   $( selectoutput(sysout)
      code_heading()
      zbyte := zbytel   // Intercept calls to ZBYTE, to list the code produced
      selectoutput(objcode)
   $)

   datasize := size/100 * 13
   labsize := size/100 * 7
   relocsize := size/100 * 13
   progsize := size - datasize - labsize - relocsize

   IF debugging THEN
   $( LET o = output()

      selectoutput(journal)

      writef("SIZE = %N*N", size)
      writef("DATASIZE = %N*N", datasize)
      writef("LABSIZE = %N*N", labsize)
      writef("RELOCSIZE = %N*N", relocsize)
      writef("PROGSIZE = %N*N", progsize)

      selectoutput(o)
   $)

   datav := work
   labv := datav + datasize
   relocbuff := labv + labsize
   progbuff := relocbuff + relocsize

   r_hl, r_de, r_bc := reglist, reglist + regitemsize, reglist + 2*regitemsize

   h4!r_hl, h4!r_de, h4!r_bc := k.hl, k.de, k.bc

   comments, incode := 0, TRUE

   // Open object file

   IF sys.emas THEN
   $( objcode := findoutput(objfile)
      IF objcode < 0 THEN
      $( ioerror(objfile)
         RESULTIS -objcode
      $)
   $)

   // Connect source file, and set up appropriate reading routine

   IF sys.emas THEN
   $( TEST compiler_ THEN
      $( LET s = findinput(ocode)
   
         IF s < 0 THEN
         $( ioerror(ocode)
            RESULTIS s
         $)
         selectinput(s)
         ocode_conad := getconad(s)
         IF ocode_conad > 0 THEN
         $( IF ocode_conad!3 NE 3 THEN   // Not a character file
            $( ioerror(ocode)
               RESULTIS e.ift
            $)
            ocode_ptr := ocode_conad!1   // Length of header
            rdch := con_rdch
         $)
      $)
      OR
      $( ocode_conad := comreg!46 >> 2
         TEST ocode_conad NE 0 THEN
         $( rdch := con_rdch
            ocode_ptr := ocode_conad!1   // Length of header
         $)
         OR
         $( selectinput(sysin)
            prompt("BCPLZ: ")
         $)
      $)
   $)

   programsize := 0
   entrypoint := 0
   symbolbase := 0

   init_codelist()

   op := readop()

   UNTIL op = s.end DO
   $( LET sectionsize = ?

      cgparam := labsize
      hwlabel := 0

      maxgn := 1
      ssp := 0
      FOR i = 0 TO labsize - 1 DO labv!i := 0
      datap := datav
      procdepth := 0
      relocbuffp := 0
      progbuffp := 0

      initstack(2)
      cgsectionentry()

      flush_codelist(m.code)   // Change mode of code listing

      discardregs()
      discardstack()

      pendingop := k.none

      scan()

      sectionsize := programsize - entrypoint

      op := readop()

      progbuff%4 := sectionsize & #xff   // Just after B C P L
      progbuff%5 := (sectionsize >> 8) & #xff

      selectoutput(objcode)
      cgdatarecords()
      cgrelocrecords()
      selectoutput(sysout)

      IF maxgn > overall_maxgn THEN overall_maxgn := maxgn   // Keep overall 'high water' mark
      dsize := (dsize + 2 + 2*globals_in_segment)*target.bytesperword
      overall_data := overall_data + dsize
      overall_code := overall_code + sectionsize - dsize
      overall_reloc := overall_reloc + relocbuffp

      flush_codelist(m.data)   // In case this is the last segment

      IF codelist_ THEN
         writes(" ;*N ; ******************************** End of segment *********************************N ;*N")

      entrypoint := programsize
      symbolbase := symbolbase + labsize
   $)

   selectoutput(objcode)
   cgendrecord()
   selectoutput(sysout)

   IF overall_maxgn > globalmax THEN
      comment("Globals used exceed %s value by %n", sys.emas -> "GLOBSIZE", "-G", overall_maxgn - globalmax)

   IF sys.emas \/ codelist_ THEN
   $( writef("*NCode %N bytes    Data %N bytes", overall_code, overall_data)
      writef("    Globals %N bytes    Relocations %N*N", overall_maxgn*target.bytesperword, overall_reloc)
      writef("Total %N bytes*N", overall_code + overall_data)
   $)

   RESULTIS 0
$)

AND scan() BE
$( SWITCHON op INTO
   $( DEFAULT:         report("illegal OCODE - %N", op)

      CASE s.end:      RETURN

      CASE s.lp:       load(loc, rdn()); ENDCASE
      CASE s.lg:       load(glob, rdgn()); ENDCASE

      CASE s.ln:       $( LET n = rdn()
                          AND op2 = ?

                          IF n = 0 & pendingop = s.logand THEN
                          $( op := readop()
                             TEST op = s.eq \/ op = s.ne THEN
                             $( op2 := readop()
                                IF op2 = s.jt \/ op2 = s.jf THEN
                                $( IF cgbitjump(op, op2) THEN
                                   $( pendingop := k.none
                                      ENDCASE
                                   $)
                                $)
                                load(numb, 0)   // Calls 'cgpendingop'
                                pendingop := op
                                op := op2
                                LOOP
                             $)
                             OR
                             $( load(numb, 0)
                                LOOP
                             $)
                          $)
                          load(numb, n)
                          ENDCASE
                       $)

      CASE s.ll:       load(lab, rdl()); ENDCASE

      CASE s.llp:      load(lvloc, rdn()); ENDCASE
      CASE s.llg:      load(lvglob, rdgn()); ENDCASE
      CASE s.lll:      load(lvlab, rdl()); ENDCASE

      CASE s.true:     load(numb, TRUE); ENDCASE
      CASE s.false:    load(numb, FALSE); ENDCASE

      CASE s.lstr:     loadstring(rdn()); ENDCASE
      CASE s.query:    cgpendingop()
                       stack(ssp + 1)
                       ENDCASE

      CASE s.sp:       cgstore(loc, rdn()); ENDCASE
      CASE s.sg:       cgstore(glob, rdgn()); ENDCASE
      CASE s.sl:       cgstore(lab, rdl()); ENDCASE

      CASE s.stind:    cgstind(); ENDCASE

      CASE s.putbyte:  cgputbyte(); ENDCASE

      CASE s.jump:     cgpendingop()
                       store(0, ssp)
                       code_jp(c.none, k.lab, rdl())
                       incode := FALSE
                       ENDCASE

      CASE s.endfor:   cgpendingop()
                       pendingop := s.le
                       op := s.jt   // Drop through

      CASE s.jf:
      CASE s.jt:       store(0, ssp - 3)
                       cgcondjump(op, rdl())
                       ENDCASE

      CASE s.goto:     cgpendingop()
                       store(0, ssp - 2)
                       movetor(r_hl, arg1)
                       code_jp(c.none, k.i.hl)   // JP (HL)
                       initstack(ssp - 1)
                       incode := FALSE
                       ENDCASE

      CASE s.labx:
      CASE s.labr:
      CASE s.lab:      cgpendingop()
                       store(0, ssp)
                       discardregs()
                       initstack(ssp)
                       incode := TRUE
                       setlab(rdl())
                       ENDCASE

      CASE s.save:     cgsave(rdn())
                       ENDCASE

      CASE s.mark:
      CASE s.stack:    cgpendingop()
                       stack(rdn())
                       ENDCASE

      CASE s.store:    cgpendingop()
                       store(0, ssp)
                       initstack(ssp)
                       ENDCASE

      CASE s.entry:    $( LET n = rdn()
                          LET l = rdl()

                          incode := TRUE
                          TEST procdepth < 0 THEN
                             procdepth := procdepth - 1
                          OR
                          $( procdepth := procdepth + 1
                             IF procdepth > namestacksize THEN
                                procdepth := -procdepth
                          $)
                          cgentry(n, l)
                          ENDCASE
                       $)

      CASE s.fnap:
      CASE s.rtap:     cgapply(op, rdn())
                       ENDCASE

      CASE s.fnrn:
      CASE s.rtrn:     cgreturn(op); ENDCASE

      CASE s.endproc:  rdn()
                       TEST procdepth < 0 THEN
                       $( procdepth := procdepth + 1
                          IF procdepth = -namestacksize THEN
                             procdepth := -procdepth
                       $)
                       OR
                          procdepth := procdepth - 1
                       ENDCASE

      CASE s.res:      cgpendingop()
                       store(0, ssp - 2)
                       movetor(r_hl, arg1)
                       stack(ssp - 1)
                       $( LET dummy = rdn()   // New stack front - not used for Z80 code
                          LET l = rdl()

                          op := readop()

                          IF op = s.stack \/ op = s.mark THEN
                          $( stack(rdn())
                             op := readop()
                          $)

                          TEST op = s.lab \/ op = s.labr THEN
                          $( LET m = rdl()

                             UNLESS l = m DO
                                code_jp(c.none, k.lab, l)

                             setlab(m)
                             discardregs()
                             ENDCASE
                          $)
                          OR
                          $( code_jp(c.none, k.lab, l)
                             incode := FALSE
                             LOOP
                          $)
                       $)

      CASE s.rstack:   stack(rdn())
                       h1!r_hl, h2!r_hl, h3!r_hl := loc, ssp, ssp
                       load(reg, r_hl)
                       ENDCASE

      CASE s.finish:   code_jp(c.none, k.arith, a.finish)
                       incode := FALSE
                       ENDCASE

      CASE s.switchon: aptovec(cgswitch, rdn()*2)
                       ENDCASE

      CASE s.global:   cgglobals(rdn())
                       RETURN

      CASE s.datalab:  $( LET l = rdl()
                          LET n = rdn()

                          $( LET v = VEC maxstrlength/bytesperword

                             v%0 := n
                             FOR i = 1 TO n DO v%i := rdn()   // Get name
                             cgdebugrecord(7, symbolbase + l, v)
                          $)

                          cgdata(op, l)
                          ENDCASE
                       $)

      CASE s.iteml:    cgdata(op, rdl())
                       ENDCASE

      CASE s.itemn:    cgdata(op, rdn())
                       ENDCASE

      CASE s.getbyte: CASE s.plus: CASE s.minus: CASE s.logand: CASE s.logor:
      CASE s.eqv: CASE s.neqv: CASE s.lshift: CASE s.rshift: CASE s.mult:
      CASE s.div: CASE s.rem: CASE s.eq: CASE s.ne: CASE s.ls: CASE s.gr:
      CASE s.le: CASE s.ge: CASE s.rv: CASE s.neg: CASE s.not: CASE s.abs:
                       cgpendingop()
                       pendingop := op
                       ENDCASE

      CASE s.rtcall: CASE s.fncall: CASE s.prcl:
                       report("EXTERNAL not supported in Z80 code")

      CASE s.mc:       cgcode(rdn())
                       ENDCASE
   $)

   op := readop()
$) REPEAT

AND load(argtype, argval) BE
/* Loads an item of type 'argtype' and value 'argval' onto the simulated
stack.  No code is generated at this stage.  */
$( cgpendingop()

   arg2 := arg1
   arg1 := arg1 + itemsize

   IF arg1 + itemsize GE simstack + simstacksize THEN
      report("in compiler - simulated stack overflow")

   h1!arg1, h2!arg1, h3!arg1 := argtype, argval, ssp

   ssp := ssp + 1
$)

AND initstack(stacksize) BE
/*  Initialises  the simulated stack to be of size 'stacksize'.  The top
two items on the simulated stack ('arg1' and 'arg2') are assumed to have
been stacked already.  */
$( arg2 := simstack
   arg1 := arg2 + itemsize

   ssp := stacksize

   h1!arg1, h2!arg1, h3!arg1 := loc, ssp - 1, ssp - 1
   h1!arg2, h2!arg2, h3!arg2 := loc, ssp - 2, ssp - 2

   FOR r = r_hl TO r_bc BY regitemsize DO discardaddress(r)
   discardstack()
$)

AND stack(stacksize) BE
/* Sets the size of the simulated stack to be 'stacksize'.  */
$( IF stacksize GE ssp + 4 THEN
   $( store(0, ssp - 1)
      initstack(stacksize)
      RETURN
   $)

   WHILE stacksize > ssp DO load(loc, ssp)

   UNTIL stacksize = ssp DO
   $( IF arg2 = simstack THEN
      $( TEST stacksize = ssp - 1 THEN
         $( ssp := stacksize
            h1!arg1, h2!arg1 := h1!arg2, h2!arg2
            h3!arg1 := ssp - 1

            h1!arg2, h2!arg2 := loc, ssp - 2
            h3!arg2 := ssp - 2
         $)
         OR initstack(stacksize)

         RETURN
      $)
      arg1, arg2 := arg1 - itemsize, arg2 - itemsize
      ssp := ssp - 1
   $)
$)

AND store(low, high) BE
/* Stores the items on the simulated stack, between the stack  positions
'high' and 'low'.  */
$( FOR t = simstack TO arg1 BY itemsize DO
   $( LET s = h3!t

      IF s > high THEN RETURN
      IF s GE low THEN storet(t)
   $)
$)

AND storet(t) BE
/*  Stores the simulated stack item 't' (if necessary) onto the real run
time stack.  */
$( LET s = h3!t

   UNLESS h1!t = loc & h2!t = s DO
   $( LET inreg = (h1!t = reg)
      LET r = inreg -> h2!t, movetoanyr(t)

      storeindex(k_ix, r, s)

      UNLESS inreg DO h1!r, h2!r, h3!r := loc, s, s
   $)
   h1!t, h2!t := loc, s
$)

AND cgnamerecord(modulename) BE
   writef("$%S050100*N", modulename)

AND cgendrecord() BE
   writes(":00000001FF*N")

AND cgdatarecords() BE
$( FOR i = 0 TO progbuffp - 1 BY 32 DO
   $( LET bytes = progbuffp - i
      LET size = bytes < 32 -> bytes, 32
      LET base = entrypoint + i
      LET checksum = size + (base >> 8) + base

      writef(":%X2%X400", size, base)

      FOR j = i TO i + size - 1 DO
      $( LET byte = progbuff%j

         writehex(byte, 2)
         checksum := checksum + byte
      $)

      writef("%X2*N", -checksum)
   $)
$)

AND cgrelocrecords() BE
$( FOR i = 0 TO relocbuffp - 1 BY 16 DO
   $( LET words = relocbuffp - i
      LET size = words < 16 -> words, 16
      LET checksum = size + 4

      writef("$%X2000004", size)

      FOR j = i TO i + size - 1 DO
      $( LET address = relocbuff!j

         checksum := checksum + (address >> 8) + address

         writehex(address, 4)
      $)
      writef("%X2*N", -checksum)
   $)
$)

AND cgdebugrecord(type, p1, p2) BE IF debug_ THEN
/* Generate a (non-loading) debug record in the object file.  */
$( selectoutput(objcode)

   writef("$DEBUGX%X2%X4", type, p1)

   SWITCHON type INTO
   $( CASE 6:   // Routine or function name - address of string in P2
      CASE 7:   // Symbol table entry for STATIC - address of string in P2
      $( LET l = p2%0 > 31 -> 31, p2%0

         writehex(l, 2)   // Length of string
         FOR i = 1 TO l DO wrch(p2%i)
         ENDCASE
      $)

      CASE 8:   // Address fill-in for STATIC symbol - address in P2
         writehex(p2, 4)
         ENDCASE

      DEFAULT:
         report("in compiler - bad TYPE in CGDEBUGRECORD - %N", type)
   $)
   writes("00*N")   // Dummy checksum
   selectoutput(sysout)
$)

 .
