
// Segment 3

GET "bz.h"

LET cgstore(argtype, argval) BE
/* Generates code to store the stack item of type  'argtype'  and  value
'argval' onto the real run time stack.  */
$( LET r = ?

   cgpendingop()
   r := movetoanyr(arg1)

   TEST argtype = lab THEN
      code_ld(k.i.lab, argval, h4!r)
   OR
   $( storeindex((argtype = loc -> k_ix, k_iy), r, argval)

      IF argtype = loc THEN
         FOR x = simstack TO arg2 BY itemsize DO
            IF h3!x = argval THEN
               h1!x, h2!x := loc, argval

      FOR r = r_hl TO r_bc BY regitemsize DO
         IF h1!r = argtype & h2!r = argval THEN
            discardreg(r)
   $)

   h1!r, h2!r := argtype, argval
   stack(ssp - 1)
$)

AND storeindex(indexr, r, pind) BE
/* Store register 'r' at offset 'ind'.  */
$( UNLESS h1!r = k.none DO
   TEST fixed_ & indexr = k_iy THEN      // Fixed global reference
      code_ld(k.arith, pind*target.bytesperword + globalbase, h4!r)
   OR
   $( LET ind = (pind << 1) - 128

      TEST ind > 127 THEN
      $( code_push(h4!r)
         code_call(indexr = k_ix -> a.six, a.siy)
         flush_codelist(m.data)
         setdmax(2)
         code_dw(k.nn, ind)
         flush_codelist(m.code)
         IF parmz_ THEN
            comment("use of %S offset %N in routine/function %S", indexr = k_ix -> "local", "global",
                       pind, curprocname())
      $)
      OR
      $( code_ld(indexr, ind, lowbyte(r))
         code_ld(indexr, ind + 1, highbyte(r))
      $)
   $)
$)

AND lowbyte(regpair) = h4!regpair + 2

AND highbyte(regpair) = h4!regpair + 1

AND movetoanyr(x) = VALOF
/*  Moves the item 'x' on the simulated stack to any available register.
*/
$( LET k, n, r = h1!x, h2!x, 0

   IF k = reg THEN
   $( freereg(n, x)
      RESULTIS n
   $)

   FOR r = r_hl TO r_bc BY regitemsize DO
      IF isfree(r) & h1!r = k & h2!r = n THEN
      $( h1!x, h2!x := reg, r
         h3!r := h3!x
         RESULTIS r
      $)

   r := nextr()
   movetor(r, x)
   RESULTIS r
$)

AND nextr() = VALOF
/* Returns the next free register for public use.
   The order of preference for allocation of registers is:
      (1)  an undefined free register
      (2)  a defined free register
      (3)  a defined allocated register
In cases (1) and (2), 'hl' before 'de'  before  'bc'  (i.e. most  usable
register first); in case (3), item furthest from top of simulated stack.
*/
$( FOR r = r_hl TO r_bc BY regitemsize DO
      IF h1!r = k.none & isfree(r) RESULTIS r

   FOR r = r_hl TO r_bc BY regitemsize DO
      IF isfree(r) RESULTIS r

   FOR x = simstack TO arg1 BY itemsize DO
      IF h1!x = reg THEN
      $( LET r = h2!x

         freereg(r, 0)
         RESULTIS r
      $)
$)

AND destackitem() BE
/* Takes the item on the Z80 stack and deposits it in a register.  */
   UNLESS h1!zstack = k.none DO
      FOR t = simstack TO arg1 BY itemsize DO
         IF h1!t = stck THEN movetoanyr(t)

AND freereg(r, x) BE
/*  Looks  at  the  simulated  stack for references to register 'r', and
unless the stack item is 'x', stores the register in its rightful place.
*/
   FOR t = simstack TO arg1 BY itemsize DO
      UNLESS t = x DO
         IF h1!t = reg & h2!t = r THEN
            UNLESS x NE 0 & h1!r = h1!x & h2!r = h2!x & h3!r = h3!x DO storet(t)

AND isfree(r) = VALOF
/* Returns a boolean, depending on whether there are any  references  to
the register 'r' in the current simulated stack frame.  */
$( FOR t = simstack TO arg1 BY itemsize DO
      IF h1!t = reg & h2!t = r RESULTIS FALSE
   RESULTIS TRUE
$)

AND discardregs() BE
/*  Ignore  the  values  in all the registers;; needed after a jump or a
procedure call.  */
   FOR r = r_hl TO r_bc BY regitemsize DO discardreg(r)

AND discardreg(r) BE
/* Discard the contents of register 'r'.  */
   h1!r, h2!r, h3!r := k.none, 0, 0

AND discardaddress(r) BE
/* Ignore the value in register 'r' if it belongs to the stack above the
current simulated stack pointer.  */
$( FOR t = arg1 TO simstack BY -itemsize DO
      IF h1!t = reg & h2!t = r THEN
      $( h3!r := h3!t
         RETURN
      $)

   IF h1!r = loc & h2!r GE ssp THEN discardreg(r)
$)

AND discardstack() BE
/* Discard the item on the Z80 stack.  */
   h1!zstack, h2!zstack, h3!zstack := k.none, 0, 0

AND loadstring(l) BE
/* Load the string of length 'l' onto the top of  the  simulated  stack.
This  is  done by generating a compiler label at the head of the string,
and putting the data at the end of the program.  */
$( LET label = nextparam()
   AND w = l & #XFF

   cgdata(s.datalab, label)

   UNTIL l = 0 DO
   $( w := (rdn() << 8) \/ w
      l := l - 1
      IF l = 0 THEN BREAK
      cgdata(s.itemn, w)
      w := rdn() & #XFF
      l := l - 1
   $)

   cgdata(s.itemn, w)
   load(lvlab, label)
$)

AND readop()  = VALOF
/* Read an OCODE operation.  Return 's.end' at end of file.  */
$( LET op = rdn()

   IF terminator = endstreamch RESULTIS s.end
   TEST sys.emas THEN
   $( IF terminator < 0 THEN
         report("failure %N on input", ABS(terminator))
   $)
   OR
   $( IF terminator = 0 THEN
         report("failure %N on input", result2)
   $)

   RESULTIS op
$)

AND cgstind() BE
/* Generate code for the STIND OCODE.  */
$( LET r = ?

   cgpendingop()
   store(0, ssp - 3)

   r := movetoanybut(r_hl, arg2)
   movetor(r_hl, arg1)

   code_add(k.hl, k.hl)
   code_ld(k.i.hl, lowbyte(r))
   code_inc(k.hl)
   code_ld(k.i.hl, highbyte(r))

   stack(ssp - 2)
   discardregs()
$)

AND cgputbyte() BE
/* Generate code for the 'a%b := c' construction.  */
$( LET r = ?

   cgpendingop()
   store(0, ssp - 4)

   loadhloffset(arg1, arg2)

   r := movetoanybut(r_hl, arg1)
   code_ld(k.i.hl, lowbyte(r))

   stack(ssp - 1)
   discardregs()
$)

AND movetor(r, x) BE
/* Generate code to load item 'x' into register 'r', saving the contents
of 'r', if necessary, on the run time stack.  */
$( LET r1 = lookinregs(x)
   AND h2x = h2!x
   AND rr = h4!r

   freereg(r, x)

   TEST r1 > 0 THEN
      loadreg(r, r1)
   OR
   $( UNLESS h1!r = h1!x & h2!r = h2x DO
         SWITCHON h1!x INTO
         $( CASE stck:     code_pop(rr)
                           ENDCASE
            CASE loc:      loadindex(k_ix, r, h2x)
                           ENDCASE
            CASE glob:     loadindex(k_iy, r, h2x)
                           ENDCASE
            CASE lab:      code_ld(rr, k.i.lab, h2x)
                           ENDCASE
            CASE numb:     code_ld(rr, k.nn, h2x)
                           ENDCASE

            CASE lvloc:    loadlvindex(k_ix, r, h2x)
                           ENDCASE
            CASE lvglob:   loadlvindex(k_iy, r, h2x)
                           ENDCASE

            CASE lvlab:    code_ld(rr, k.lab, h2x)
                           code_srl(highbyte(r))
                           code_rr(lowbyte(r))
                           ENDCASE

            DEFAULT:       report("in compiler - bad H1X in MOVETOR - %N", h1!x)
         $)

      TEST h1!x = reg THEN
         FOR h = h1 TO h3 DO h!r := h!h2x OR
      TEST h1!x = stck THEN
      $( FOR h = h1 TO h3 DO h!r := h!zstack
         discardstack()
      $) OR
         FOR h = h1 TO h3 DO h!r := h!x
   $)

   h1!x, h2!x := reg, r
$)

AND loadreg(r1, r2) BE
/* Generate code to load 'r1' with the contents of 'r2'.  */
$( UNLESS r1 = r2 DO
   $( /* TEST r1 = r_hl & r2 = r_de THEN   // Can optimise this case
      $( code_exdehl()
         FOR h = h1 TO h3 DO
         $( LET temp = h!r1
            h!r1 := h!r2
            h!r2 := temp
         $)
         FOR t = arg1 TO simstack BY -itemsize DO
            IF h1!t = reg & h2!t = r_de THEN h2!t := r_hl
      $)
      OR */
      $( code_ld(lowbyte(r1),lowbyte(r2))
         code_ld(highbyte(r1),highbyte(r2))
         FOR h = h1 TO h3 DO
            h!r1 := h!r2
      $)
   $)
$)

AND lookinregs(x) = VALOF
/* Returns a register containing 'x', or -1 if not found.  */
$( IF h1!x = reg RESULTIS h2!x

   FOR r = r_hl TO r_bc BY regitemsize DO
      IF h1!r = h1!x & h2!r = h2!x RESULTIS r

   RESULTIS -1
$)

AND cgcode(n) BE
/* Implements the CODE command.  */
$( STATIC $( c_ptr = ?; c_max = ?; c_vec = ? $)

   LET s.rdch() = VALOF
   $( IF c_ptr = c_max RESULTIS endstreamch
      c_ptr := c_ptr + 1
      $( LET c = c_vec%c_ptr

         IF 'a' LE c LE 'z' THEN c := c - 'a' + 'A'

         RESULTIS c
      $)
   $)

   AND s_unrdch() BE c_ptr := c_ptr - 1

   AND match(a, b) = VALOF
   $( FOR i = 1 TO a%0 DO
      $( LET ac, bc = a%i, b%i

         IF 'a' LE ac LE 'z' THEN ac := ac - 'a' + 'A'
         IF 'a' LE bc LE 'z' THEN bc := bc - 'a' + 'A'

         UNLESS ac = bc RESULTIS FALSE
      $)
      RESULTIS TRUE
   $)

   LET v = VEC maxstrlength/bytesperword + 1
   AND word = 0
   AND save_rdch = rdch
   AND item_read = FALSE
   AND size = ?

   v%0 := n
   FOR i = 1 TO n DO
      v%i := readn()

   IF n = 6 & match(v, "CODEON") THEN
   $( zbyte := zbytel   // Turn on code listing
      codelist_ := TRUE
      flush_codelist(m.code)   // Initialise code lister
      TEST code_heading_done_ THEN newline() OR code_heading()
      RETURN
   $)
   IF n = 7 & match(v, "CODEOFF") THEN
   $( zbyte := zbytecopy   // Turn off code listing
      flush_codelist(m.code)   // Clear out rest of any code listing
      codelist_ := FALSE
      RETURN
   $)

   cgpendingop()
   store(0, ssp - 1)
   discardregs()
   discardstack()

   flush_codelist(m.data)   // Change to data listing mode

   c_ptr, c_max, c_vec := 0, n, v

   terminator := '*S'
   rdch := s.rdch

   setdmax(4)

   $( LET radix = 10

      UNTIL terminator = '#' \/
            '0' LE terminator LE '9' \/
            terminator = '*N' \/
            terminator = endstreamch DO
         terminator := rdch()

      IF terminator = endstreamch BREAK

      IF terminator = '*N' THEN
      $( UNLESS item_read DO   // Blank line
         $( terminator := '*S'
            LOOP
         $)
         item_read := FALSE
         terminator := '*S'
         codeout(size, word)
         word := 0
         LOOP
      $)

      TEST terminator = '#' THEN
      $( radix := 8
         terminator := rdch()
         TEST terminator = 'X' THEN radix := 16 OR
         TEST terminator = 'O' THEN radix := 8 OR
         TEST terminator = 'B' THEN radix := 2 OR
            s_unrdch()
      $) OR s_unrdch()
      IF terminator = endstreamch BREAK

      TEST item_read THEN
         word := word \/ readnumber(radix)
      OR
      $( item_read := TRUE
         size := readnumber(radix)
      $)
      IF terminator = endstreamch BREAK
   $) REPEAT

   rdch := save_rdch
   IF item_read THEN codeout(size, word)
   flush_codelist(m.code)   // Change back to code listing mode
$)

AND codeout(size, word) BE IF incode THEN
$( FOR i = size*2 - 2 TO 0 BY -2 DO
      zbyte((word >> (i*4)) & #XFF)
$)

 .
