
// Segment 5

GET "bz.h"

LET cgpendingop() BE
/*  Generate  code  to deal with the pending operator, ensuring that the
generation of code is left until the last possible moment.  */
$( LET num1, num2 = (h1!arg1 = numb), (h1!arg2 = numb)
   AND rand1, rand2 = arg1, arg2
   AND val1, val2 = h2!arg1, h2!arg2
   AND pendop = pendingop
   AND atype, aval = ?, ?

   pendingop := k.none

   UNLESS pendop = k.none DO
   $( TEST monadicop(pendop) THEN
      $( TEST pendop = s.rv THEN
         $( movetor(r_hl, rand1)
            code_add(k.hl, k.hl)
            code_ld(k.a, k.i.hl)
            code_inc(k.hl)
            code_ld(k.h, k.i.hl)
            code_ld(k.l, k.a)
            stack(ssp - 1)
            atype, aval := reg, r_hl
         $)
         OR TEST num1 THEN
         $( stack(ssp - 1)
            atype := numb
            aval := VALOF SWITCHON pendop INTO
            $( CASE s.abs: RESULTIS ABS(val1)
               CASE s.neg: RESULTIS -val1
               CASE s.not: RESULTIS NOT val1
            $)
         $)
         OR
         $( LET r = movetoanyr(rand1)
            LET hb,lb = highbyte(r), lowbyte(r)

            SWITCHON pendop INTO
            $( CASE s.neg:
                  code_dec(h4!r)   // Drop through

               CASE s.not:
                  code_ld(k.a, lb)
                  code_cpl()
                  code_ld(lb, k.a)

                  code_ld(k.a, hb)
                  code_cpl()
                  code_ld(hb, k.a)

                  atype, aval := reg, r
                  stack(ssp - 1)
                  ENDCASE

               CASE s.abs:
                  destackitem()
                  code_push(h4!r)
                  code_call(a.abs)
                  stack(ssp - 1)
                  h1!zstack, h2!zstack, h3!zstack := loc, ssp, ssp
                  atype, aval := stck, ssp
                  discardaddress(r)
                  ENDCASE
            $)
         $)
         FOR r = r_hl TO r_bc BY regitemsize DO discardaddress(r)

         IF atype = reg THEN h1!aval, h2!aval, h3!aval := loc, ssp, ssp
         load(atype, aval)
      $)
      OR
      $( TEST num1 & num2 & pendop NE s.getbyte THEN
         $( stack(ssp - 2)
            atype := numb
            aval := VALOF SWITCHON pendop INTO
            $( CASE s.plus:   RESULTIS val2 + val1
               CASE s.minus:  RESULTIS val2 - val1
               CASE s.mult:   RESULTIS val2 * val1
               CASE s.div:    RESULTIS val2 / val1
               CASE s.rem:    RESULTIS val2 REM val1
               CASE s.logand: RESULTIS val2 & val1
               CASE s.logor:  RESULTIS val2 \/ val1
               CASE s.eqv:    RESULTIS val2 EQV val1
               CASE s.neqv:   RESULTIS val2 NEQV val1
               CASE s.eq:     RESULTIS val2 = val1
               CASE s.ne:     RESULTIS val2 NE val1
               CASE s.ls:     RESULTIS val2 < val1
               CASE s.gr:     RESULTIS val2 > val1
               CASE s.ge:     RESULTIS val2 GE val1
               CASE s.le:     RESULTIS val2 LE val1
               CASE s.lshift: RESULTIS val2 << val1
               CASE s.rshift: RESULTIS val2 >> val1

               DEFAULT:       report("in compiler - bad PENDOP in CGPENDINGOP(1) - %N", pendop)
            $)
         $)
         OR   // Some code will have to be compiled
         $( SWITCHON pendop INTO
            $( CASE s.plus:
                  IF num2 THEN rand1, rand2 := arg2, arg1

               CASE s.minus:
                  atype := reg
                  aval := cginlineop(pendop, rand1, rand2)
                  ENDCASE

               CASE s.lshift: CASE s.rshift:
                  IF num1 & val1 = 1 THEN
                  $( atype := reg
                     aval := cgshift1(pendop, rand2)
                     ENDCASE
                  $)
                  IF num1 & val1 = 2 THEN
                  $( atype := reg
                     aval := cgshift2(pendop, rand2)
                     ENDCASE
                  $)
                  IF num1 & val1 = 8 THEN
                  $( atype := reg
                     aval := cgshift8(pendop, rand2)
                     ENDCASE
                  $)

                  // Other shifts just drop through

               CASE s.mult: CASE s.div: CASE s.rem:
               CASE s.eq: CASE s.ne: CASE s.gr: CASE s.ls:
               CASE s.ge: CASE s.le:
                  IF pendop = s.gr \/ pendop = s.le THEN
                     rand1, rand2 := arg2, arg1
                  cgstackop(arith(pendop), rand1, rand2)
                  atype, aval := stck, ssp
                  ENDCASE

               CASE s.logand: CASE s.logor: CASE s.eqv: CASE s.neqv:
                  IF num2 THEN rand1, rand2 := arg2, arg1
                  atype := reg
                  aval := cglogop(arith(pendop), rand1, rand2, pendop = s.eqv)
                  ENDCASE

               CASE s.getbyte:
                  loadhloffset(rand1, rand2)
                  code_ld(k.l, k.i.hl)
                  code_ld(k.h, k.n, 0)
                  atype, aval := reg, r_hl
                  ENDCASE

               DEFAULT:
                  report("in compiler - bad PENDOP in CGPENDINGOP(2) - %N", pendop)
            $)
         $)

         FOR r = r_hl TO r_bc BY regitemsize DO discardaddress(r)

         IF atype = reg THEN h1!aval, h2!aval, h3!aval := loc, ssp, ssp
         load(atype, aval)
      $)
   $)
$)

AND loadhloffset(a1, a2) BE
/* Common routine for the 'getbyte' and 'putbyte' operations.  Generates
the  final  address in HL, from the values in stack items 'a1' and 'a2'.
*/
$( LET a1val = h2!a1

   TEST H1!a1 = numb & (0 LE a1val LE 6) THEN   // Small constant offsets can be optimised
   $( LET before = a1val >> 1
      AND after = a1val & 1

      movetor(r_hl, a2)
      FOR i = 1 TO before DO code_inc(k.hl)
      code_add(k.hl, k.hl)
      FOR i = 1 TO after DO code_inc(k.hl)
      stack(ssp - 2)
   $)
   OR
   $( LET r = movetoanybut(r_hl, a1)

      movetor(r_hl, a2)
      code_add(k.hl, k.hl)
      code_add(k.hl, h4!r)
      stack(ssp - 2)
      discardaddress(r)
   $)
$)

AND arith(op) = VALOF SWITCHON(op) INTO
/* Return an 'arith' representation of the operator 'op'.  */
$( CASE s.mult:    RESULTIS a.mult
   CASE s.div:     RESULTIS a.div
   CASE s.rem:     RESULTIS a.rem
   CASE s.eq:      RESULTIS a.eq
   CASE s.ne:      RESULTIS a.ne
   CASE s.gr:
   CASE s.ls:      RESULTIS a.lt
   CASE s.ge:
   CASE s.le:      RESULTIS a.ge
   CASE s.lshift:  RESULTIS a.lshift
   CASE s.rshift:  RESULTIS a.rshift

   CASE s.logand:  RESULTIS code_and
   CASE s.logor:   RESULTIS code_or
   CASE s.eqv:
   CASE s.neqv:    RESULTIS code_xor
$)

AND singlebit(b) = VALOF
/* See if 'b' contains only one nonzero bit.  If so, yield the number of
that bit, otherwise yield -1.  */
$( LET t = (TABLE #B00000001,
                  #B00000010,
                  #B00000100,
                  #B00001000,
                  #B00010000,
                  #B00100000,
                  #B01000000,
                  #B10000000 )

   FOR i = 0 TO 7 DO
      IF t!i = b RESULTIS i

   RESULTIS -1
$)

AND cglogop(rtn, a1, a2, cpl) = VALOF
/* Generate code for logical operator served by  'rtn'.   Iff  'cpl'  is
TRUE, result is to be complemented.  */
$( LET num1, val1 = (h1!a1 = numb), h2!a1
   AND r = movetoanyr(a2)
   AND r1 = ?
   LET hb, lb = highbyte(r), lowbyte(r)

   UNLESS num1 DO r1 := movetoanyr(a1)

   TEST num1 THEN
      cglogbyte(lb, val1 & #XFF, rtn, cpl)
   OR
   $( code_ld(k.a, lb)
      rtn(lowbyte(r1))
      IF cpl THEN code_cpl()
      code_ld(lb, k.a)
   $)

   TEST num1 THEN
      cglogbyte(hb, val1 >> 8, rtn, cpl)
   OR
   $( code_ld(k.a, hb)
      rtn(highbyte(r1))
      IF cpl THEN code_cpl()
      code_ld(hb, k.a)
   $)

   stack(ssp - 2)
   UNLESS num1 DO discardaddress(r1)
   RESULTIS r
$)

AND cglogbyte(b, val, rtn, cpl) BE
/*    Subsidiary    routine    for    'cglogop',    used   for   numeric
operands. Generates code for each byte of the operand.  */
$( IF (val = 0 & rtn NE code_and & NOT cpl) \/
      (val = #XFF & cpl & rtn = code_xor) THEN RETURN

   IF rtn = code_and THEN
   $( IF val = 0 THEN code_ld(b, k.n, 0)
      UNLESS 0 NE val NE #XFF RETURN
   $)

   $( LET n = singlebit((NOT val) & #XFF)

      IF n GE 0 THEN
      $( code_res(n, b)
         RETURN
      $)
   $)

   IF val = #XFF & rtn = code_or THEN
   $( code_ld(b, k.n, #XFF)
      RETURN
   $)

   $( LET n = singlebit(val)

      IF rtn = code_or & n GE 0 THEN
      $( code_set(n, b)
         RETURN
      $)
   $)

   code_ld(k.a, b)
   TEST (rtn = code_xor) &
        ((val = #XFF) \/ (val = 0 & cpl)) THEN
      code_cpl()
   OR
   $( rtn(k.n, val)
      IF cpl THEN code_cpl()
   $)
   code_ld(b, k.a)
$)

AND cgbitjump(rel,jump) = VALOF
/*  Yields  TRUE iff the operand was numeric and code could be compiled.
*/
$( LET rand1, rand2 = arg1, arg2
   AND eqsw_ = rel = s.eq
   AND jtsw_ = jump = s.jt
   LET cc = eqsw_ EQV jtsw_ -> c.z, c.nz
   AND n, nh, nl, vh, vl, r = ?, ?, ?, ?, ?, ?
   AND lb, hb = ?, ?
   AND l = ?

   IF h1!arg1 = numb THEN rand1, rand2 := arg2, arg1

   UNLESS h1!rand2 = numb RESULTIS FALSE

   l := rdl()

   r := movetoanyr(rand1)
   lb, hb := lowbyte(r), highbyte(r)

   n := h2!rand2
   vh, vl := n >> 8, n & #XFF
   nh, nl := singlebit(vh), singlebit(vl)

   TEST (nh GE 0 & vl = 0) \/ (nl GE 0 & vh = 0) THEN
                                        // Not single bit operand
      code_bit((nh GE 0 -> nh, nl), vl = 0 -> hb, lb)
   OR
   $( cglogbyte(lb, vl, code_and, FALSE)
      cglogbyte(hb, vh, code_and, FALSE)
      code_ld(k.a, lb)
      code_or(hb)
   $)

   stack(ssp - 2)
   discardaddress(r)
   code_jp(cc, k.lab, l)

   RESULTIS TRUE
$)

AND cgstackop(arithop, a1, a2) BE
/* Generate code for 'arithop', leaving the result on the Z80 stack.  */
$( LET r1, r2 = ?, ?
   AND rand1, rand2 = a1, a2
   AND onstack_ = ?

   IF h1!a1 = stck THEN
      IF arithop = a.mult \/ arithop = a.eq \/ arithop = a.ne THEN
         rand1, rand2 := a2, a1

   onstack_ := h1!rand2 = stck
   UNLESS onstack_ DO destackitem()

   r2 := lookinregs(rand2)
   UNLESS onstack_ \/ r2 > 0 DO r2 := movetoanyr(rand2)
   UNLESS onstack_ DO code_push(h4!r2)

   r1 := lookinregs(rand1)
   UNLESS r1 > 0 DO r1 := movetoanyr(rand1)

   code_push(h4!r1)
   code_call(arithop)

   stack(ssp - 2)
   UNLESS onstack_ DO discardaddress(r2)
   discardaddress(r1)

   h1!zstack, h2!zstack, h3!zstack := loc, ssp, ssp
$)

AND cgshift1(op, arg) = VALOF
/* Generate code for a 1-bit shift.  */
$( TEST op = s.lshift THEN
   $( movetor(r_hl, arg)
      code_add(k.hl, k.hl)
      stack(ssp - 2)
      discardaddress(r_hl)
      RESULTIS r_hl
   $)
   OR
   $( LET r = movetoanyr(arg)

      code_srl(highbyte(r))
      code_rr(lowbyte(r))
      stack(ssp - 2)
      discardaddress(r)
      RESULTIS r
   $)
$)

AND cgshift2(op, arg) = VALOF
/* Generate code for a 2-bit shift.  */
$( TEST op = s.lshift THEN
   $( movetor(r_hl, arg)
      code_add(k.hl, k.hl)
      code_add(k.hl, k.hl)
      stack(ssp - 2)
      discardaddress(r_hl)
      RESULTIS r_hl
   $)
   OR
   $( LET r = movetoanyr(arg)

      FOR i = 1 TO 2 DO
      $( code_srl(highbyte(r))
         code_rr(lowbyte(r))
      $)
      stack(ssp - 2)
      discardaddress(r)
      RESULTIS r
   $)
$)

AND cgshift8(op, arg) = VALOF
/* Generate code for an 8-bit shift.  */
$( LET r = movetoanyr(arg)

   TEST op = s.lshift THEN
   $( code_ld(highbyte(r), lowbyte(r))
      code_ld(lowbyte(r), k.n, 0)
   $)
   OR
   $( code_ld(lowbyte(r), highbyte(r))
      code_ld(highbyte(r), k.n, 0)
   $)

   stack(ssp - 2)
   discardaddress(r)
   RESULTIS r
$)

AND cginlineop(op, a1, a2) = VALOF
/* Generate code for the inline operators + and -.  */
$( LET rtn = (op = s.plus -> code_inc, code_dec)
   AND num1 = (h1!a1 = numb)
   AND val1 = h2!a1

   TEST num1 & 0 LE val1 LE 3 THEN
   $( LET r = movetoanyr(a2)

      FOR i = 1 TO val1 DO rtn(h4!r)
      stack(ssp - 2)
      RESULTIS r
   $)
   OR
   $( LET r = lookinregs(a1)

      movetor(r_hl, a2)
      IF r < 0 \/ r = r_hl THEN
         r := movetoanybut(r_hl, a1)

      TEST op = s.plus THEN
         code_add(k.hl, h4!r)
      OR
      $( code_and(k.a)
         code_sbc(k.hl, h4!r)
      $)

      stack(ssp - 2)
      discardaddress(r)
      RESULTIS r_hl
   $)
$)

AND cgcondjump(op, ll) BE
/*  Generate  code  to jump to label 'll', depending on the value of the
top item on the stack, and also the jump operator 'op'.  */
$( LET rand1, rand2 = arg1, arg2
   LET num1, num2 = (h1!rand1 = numb), (h1!rand2 = numb)
   AND cc, r = ?, ?
   AND p, jt = pendingop, (op = s.jt)

   TEST (p = s.eq \/ p = s.ne \/ p = s.gr \/ p = s.ls \/ p = s.le \/ p = s.ge) &
     ((num1 & h2!rand1 = 0) \/ (num2 & h2!rand2 = 0 )) THEN
   $( IF num2 THEN
      $( rand1, rand2 := arg2, arg1
         p := reverse(p)
      $)

      SWITCHON p INTO
      $( CASE s.eq:
         CASE s.ne:
            cc := (p = s.eq -> (jt -> c.z, c.nz), (jt -> c.nz, c.z))
            $( LET r = movetoanyr(rand2)

               code_ld(k.a, lowbyte(r))
               code_or(highbyte(r))
               stack(ssp - 2)
               discardaddress(r)
            $)
            ENDCASE

         CASE s.ls:
         CASE s.ge:
            cc :=  (p = s.ls -> (jt -> c.m, c.p), (jt -> c.p, c.m))
            r := movetoanyr(rand2)
            code_xor(k.a)
            code_xor(highbyte(r))
            stack(ssp - 2)
            discardaddress(r)
            ENDCASE

         CASE s.gr:
         CASE s.le:
            cc := (p = s.gr -> (jt -> c.m, c.p), (jt -> c.p, c.m))
            r := movetoanyr(rand2)
            code_xor(k.a)
            code_sbc(k.a, lowbyte(r))
            code_ld(k.a, k.n, 0)
            code_sbc(k.a, highbyte(r))
            stack(ssp - 2)
            discardaddress(r)
            ENDCASE

         DEFAULT:
            report("in compiler - bad P in CGCONDJUMP - %N", p)
      $)

      code_jp(cc, k.lab, ll)
      pendingop := k.none
   $)
   OR
   $( TEST p = s.eq \/ p = s.ne THEN   // No need to worry about overflow
      $( LET r = movetoanybut(r_hl, arg1)
 
         movetor(r_hl, arg2)
         code_and(k.a)
         code_sbc(k.hl, h4!r)
         code_jp(p = s.eq -> (jt -> c.z, c.nz), (jt -> c.nz, c.z), k.lab, ll)
         stack(ssp - 2)
         discardreg(r_hl)
         discardaddress(r)
         pendingop := k.none
      $)
      OR
      $( cc := jt -> c.nz, c.z
         cgpendingop()
         store(0, ssp-2)
         $( LET r = movetoanyr(arg1)
 
            code_ld(k.a, lowbyte(r))
            code_or(highbyte(r))
            code_jp(cc, k.lab, ll)
            stack(ssp - 1)
            discardaddress(r)
         $)
      $)
   $)
$)

AND monadicop(op) = op = s.abs \/ op = s.neg \/ op = s.not \/ op = s.rv

AND cgreturn(op) BE
/* Generate code to return  from  the  current  procedure  body;  either
function or routine, depending on 'op'.  */
$( cgpendingop()

   IF op = s.fnrn THEN
   $( TEST h1!arg1 = reg & h2!arg1 = r_de THEN
      $( freereg(r_hl, 0)
         code_exdehl()
      $)
      OR
         movetor(r_hl, arg1)
      stack(ssp - 1)
   $)

   code_jp(c.none, k.arith, a.return)
   initstack(ssp)
   discardregs()
   incode := FALSE
$)

AND reverse(p) = VALOF SWITCHON p INTO
/* Return the reverse of the relational operator 'op'.  */
$( CASE s.gr:    RESULTIS s.ls
   CASE s.ls:    RESULTIS s.gr
   CASE s.ge:    RESULTIS s.le
   CASE s.le:    RESULTIS s.ge

   DEFAULT:      RESULTIS p
$)

 .
