
// Segment 8

GET "bz.h"

/* Z80 code lister. A.L. Ibbetson UKC 1980.
   Operates by ZBYTEL being plugged into ZBYTE
*/

STATIC $(
zblptr    = ?   // Position in PROGBUFF used by NEXTBYTE
wrchcopy  = ?   // WRCH on entry to code lister
linepos   = ?   // Maintained by CLWRCH (plugged into WRCH)
hlflag    = ?   // NE 0 if in IX or IY mode
curmode   = ?   // Current code listing mode
dcount    = ?   // Count of data items waiting to be printed
dmax      = 4   // Trigger point for data listing
$)

LET zbytel(b) BE
$( IF starting_codelist_ THEN
   $( zblptr := progbuffp
      starting_codelist_ := FALSE
   $)
   zbytecopy(b)   // The real ZBYTE
   TEST curmode = m.code THEN
      IF (progbuffp - zblptr) GE 4 DO clist()
   OR
      dlist(FALSE)
$)

AND dlist(flushing_) BE
$( UNLESS flushing_ DO dcount := dcount + 1

   IF dcount GE dmax \/ (flushing_ & dcount > 0) THEN
   $( wrchcopy := wrch
      linepos := 1
      wrch := clwrch
      writeaddress(zblptr)
      writes("DATA*T")

      FOR i = 0 TO dcount - 1 DO
         writehex(progbuff%(zblptr+i), 2)
      wrch('h')

      wrch('*T') REPEATUNTIL linepos > 40   // Align listing
      wrch := wrchcopy

      FOR i = 0 TO dcount - 1 DO
         writef(" %X2", progbuff%(zblptr+i))
      newline()

      zblptr := zblptr + dcount
      dcount := 0
   $)
$)

AND setdmax(n) BE dmax := n

// Because the code listing may be up to 3 bytes behind ZBYTE, this
// routine must be called at the end of each section of the code listing

AND flush_codelist(newmode) BE IF codelist_ THEN
$( TEST curmode = m.data THEN
   $( dlist(TRUE)
      starting_codelist_ := TRUE
   $)
   OR
      IF NOT starting_codelist_ THEN
      $( WHILE zblptr < progbuffp DO clist()
         starting_codelist_ := TRUE
      $)

   curmode := newmode
$)

AND init_codelist() BE
$( curmode := m.data
   dcount := 0
   starting_codelist_ := TRUE
$)

AND nextbyte() = VALOF
$( LET b = ?

   UNLESS 4 GE (progbuffp-zblptr) > 0 THEN
      report("in code lister - code buffering out of step - %X4 %X4", progbuffp, zblptr)

   b := progbuff%zblptr
   zblptr := zblptr + 1

   RESULTIS b
$)

AND clist() BE
$( LET instrptr = zblptr

   wrchcopy := wrch
   linepos := 1
   wrch := clwrch
   hlflag := 0

   writeaddress(instrptr)

   cldecode( nextbyte() ) //Write instr in memonic form

   wrch('*T') REPEATUNTIL linepos > 40   // Align listing
   wrch := wrchcopy
   FOR i = instrptr TO zblptr - 1 DO
      writef(" %X2", progbuff%i)
   newline()
$)

// There is a bug in the 2900 runtime library.
// WRCH calls itself with SPACE 1-8 times for a TAB.
// This means that to get LINEPOS correct we must not
// adjust LINEPOS at all on a TAB. Implementations on
// other machines will necessitate a modification to CLWRCH

AND clwrch(c) = VALOF
$( TEST sys.emas THEN
      UNLESS c = '*T' DO linepos := linepos + 1
   OR
   $( TEST c = '*T' THEN linepos := ((linepos+7)/8)*8 + 1
      OR linepos := linepos + 1
   $)

   IF c = '*N' THEN linepos := 1
   RESULTIS wrchcopy(c)
$)

AND cldecode(byte1) BE
$( LET byte2,byte3,nn = ?,?,?

   SWITCHON (byte1 >> 6) & 3 INTO
   $( CASE 0:
         SWITCHON byte1 & 7 INTO
         $( CASE 0:
               SWITCHON (byte1 >> 3) & 7 INTO
               $( CASE 0:
                     writes("NOP")
                     ENDCASE
                  CASE 1:
                     writes("EX*TAF,AF*'")
                     ENDCASE
                  DEFAULT:
                     relative_jump(byte1, nextbyte())
               $)
               ENDCASE
      
            CASE 1:
               TEST (byte1 & 8) = 0
               $( byte2 := nextbyte(); byte3 := nextbyte()
                  writes("LD*T")
                  regdd(byte1 >> 4) //16 bit reg variant
                  writef(",%N", byte2 + (byte3 << 8)) // 'nn' literal
               $)
               OR
               $( writef("ADD*T%S,", reghlixiy() )
                  regdd(byte1 >> 4)
               $)
               ENDCASE
      
            CASE 2:
               IF (byte1 & #40) NE 0
               $( byte2 := nextbyte()
                  byte3 := nextbyte()
                  nn := byte2 + (byte3 << 8)
               $)
      
               writes("LD*T")
      
               TEST (byte1 & #60) = #40 THEN
                  TEST (byte1 & #10) NE 0 THEN
                     writef("%S,(%N)",reghlixiy(),nn)
                  OR
                     writef("(%N),%S",nn,reghlixiy())
               OR
               $( TEST (byte1 & #60) = 0 THEN nn := "BC"
                  OR IF (byte1 & #60) = #20 THEN nn := "DE"
                  TEST (byte1 & #10) = 0 THEN
                     TEST (byte1 & #60) = #60 DO writef("(%N),A",nn)
                     OR writef("(%S),A",nn)
                  OR
                     TEST (byte1 & #60) = #60 DO writef("A,(%N)",nn)
                     OR writef("A,(%S)",nn)
               $)
               ENDCASE
      
            CASE 3:
               writes(((byte1 & #10) = 0) -> "INC*T", "DEC*T")
               regdd(byte1 >> 4)
               ENDCASE
      
            CASE 4:
               writef("INC*T%S", regr(byte1 >> 3)) //8 bit reg
               ENDCASE
      
            CASE 5:
               writef("DEC*T%S", regr(byte1 >> 3))
               ENDCASE
      
            CASE 6:
               writef("LD*T%S,%N", regr(byte1 >> 3), nextbyte())
               ENDCASE
      
            CASE 7:
               nn := VALOF SWITCHON (byte1 >> 3) & 7 INTO
               $( CASE 0: RESULTIS "RCLA"
                  CASE 1: RESULTIS "RRCA"
                  CASE 2: RESULTIS "RLA"
                  CASE 3: RESULTIS "RRA"
                  CASE 4: RESULTIS "DAA"
                  CASE 5: RESULTIS "CPL"
                  CASE 6: RESULTIS "SCF"
                  CASE 7: RESULTIS "CCF"
               $)
               writes(nn)
         $)
         ENDCASE

      CASE 1:
         TEST byte1 = #X76 THEN writes("HALT")
         OR writef("LD*T%S,%S",regr(byte1>>3),regr(byte1))
         ENDCASE

      CASE 2:
         writef("%S*T%S", addgroup(byte1), regr(byte1))
         ENDCASE

      CASE 3:
         SWITCHON byte1 & 7 INTO
         $( CASE 0:
               writef("RET*T%S", cc(byte1))
               ENDCASE

            CASE 1:
               popgroup(byte1)
               ENDCASE

            CASE 2:
               byte2 := nextbyte()
               byte3 := nextbyte()
               writes("JP*T")
               ccnn(byte1, byte2, byte3)
               ENDCASE

            CASE 3:
               SWITCHON (byte1 >> 3) & 7 INTO
               $( CASE 0:
                     byte2 := nextbyte()
                     byte3 := nextbyte()
                     writef("JP*T%X4h", byte2+(byte3<<8))
                     ENDCASE

                  CASE 1:
                     bitgroup()
                     ENDCASE

                  CASE 2:
                     writef("OUT*T(%N),A", nextbyte())
                     ENDCASE

                  CASE 3:
                     writef("IN*TA,(%N)", nextbyte())
                     ENDCASE

                  CASE 4:
                     writef("EX*T(SP),%S", reghlixiy())
                     ENDCASE

                  CASE 5:
                     writes("EX*TDE,HL")
                     ENDCASE

                  CASE 6:
                     writes("DI")
                     ENDCASE

                  CASE 7:
                     writes("EI")
               $)
               ENDCASE

            CASE 4:
               byte2 := nextbyte()
               byte3 := nextbyte()
               writes("CALL*T")
               ccnn(byte1, byte2, byte3)
               ENDCASE

            CASE 5:
               SWITCHON (byte1 >> 3) & 7 INTO
               $( CASE 1:
                     byte2 := nextbyte(); byte3 := nextbyte()
                     writef("CALL*T%X4h", byte2+(byte3<<8))
                     ENDCASE

                  CASE 3:
                  CASE 7:
                     hlflag := ((byte1 & #40) = 0 -> k.ix, k.iy)
                     cldecode(nextbyte()) //Recursive
                     RETURN

                  CASE 5:
                     secondary.instr( nextbyte() )
                     ENDCASE

                  DEFAULT:
                     writes("PUSH*T")
                     regqq(byte1 >> 4)
               $)
               ENDCASE

            CASE 6:
               writef("%S*T%N", addgroup(byte1), nextbyte())
               ENDCASE

            CASE 7:
               writef("RST*T%N", (byte1 >> 3) & #X07)
         $)
   $)
$)

AND relative_jump(byte1, byte2) BE
$( writes((byte1 & #70) = #20 -> "DJNZ*T","JR*T")
   IF (byte1 & #40) NE 0 $( writes(cc(byte1 & #30)); wrch(',') $)
   IF byte2 > 127 THEN byte2 := byte2 \/ #XFF00
   writef("%X4h", byte2 + zblptr)
$)

AND regqq(r) BE TEST (r&3)=3 DO writes("AF") OR regdd(r)

AND regdd(r) BE SWITCHON r & 3 INTO
$( CASE 0: writes("BC"); ENDCASE
   CASE 1: writes("DE"); ENDCASE
   CASE 2: writes(reghlixiy()); ENDCASE
   CASE 3: writes("SP")
$)

AND reghlixiy() = VALOF SWITCHON hlflag INTO
$( CASE 0:      RESULTIS "HL"
   CASE k.ix:   RESULTIS "IX"
   CASE k.iy:   RESULTIS "IY"
$)

AND regr(r) = VALOF SWITCHON r & 7 INTO
$( CASE 0: RESULTIS "B"
   CASE 1: RESULTIS "C"
   CASE 2: RESULTIS "D"
   CASE 3: RESULTIS "E"
   CASE 4: RESULTIS "H"
   CASE 5: RESULTIS "L"
   CASE 6: RESULTIS indirectr()
   CASE 7: RESULTIS "A"
$)

AND indirectr() = VALOF SWITCHON hlflag INTO
$( CASE 0:       RESULTIS "(HL)"
   CASE k.ix:    nextbyte(); RESULTIS "(IX+d)"
   CASE k.iy:    nextbyte(); RESULTIS "(IY+d)"
$)

AND addgroup(op) = VALOF SWITCHON (op >> 3) & 7 INTO
$( CASE 0: RESULTIS "ADD"
   CASE 1: RESULTIS "ADC"
   CASE 2: RESULTIS "SUB"
   CASE 3: RESULTIS "SBC"
   CASE 4: RESULTIS "AND"
   CASE 5: RESULTIS "XOR"
   CASE 6: RESULTIS "OR"
   CASE 7: RESULTIS "CP"
$)

AND popgroup(byte1) BE
$( TEST (byte1 & #10) = 0
   $( writes("POP*T")
      regqq(byte1 >> 4)
   $)
   OR SWITCHON (byte1 >> 4) & 3 INTO
   $( CASE 0:
         writes("RET")
         ENDCASE
      CASE 1:
         writes("EXX")
         ENDCASE
      CASE 2:
         writef("JP*T(%S)", reghlixiy())
         ENDCASE
      CASE 3:
         writef("LD*TSP,%S", reghlixiy())
   $)
$)

AND ccnn(byte1, byte2, byte3) BE
   writef("%S,%X4h", cc(byte1), byte2+(byte3<<8))

AND cc(byte1) = VALOF SWITCHON (byte1 >> 3) & 7 INTO
$( CASE 0: RESULTIS "NZ"
   CASE 1: RESULTIS "Z"
   CASE 2: RESULTIS "NC"
   CASE 3: RESULTIS "C"
   CASE 4: RESULTIS "PO"
   CASE 5: RESULTIS "PE"
   CASE 6: RESULTIS "P"
   CASE 7: RESULTIS "M"
$)

AND bitgroup() BE
$( LET r, s, byte2 = ?, ?, ?

   IF hlflag NE 0 THEN r := indirectr()   // Now to absorb d in IX+d mode

   byte2 := nextbyte()
   SWITCHON (byte2 >> 6) & 3 INTO
   $( CASE 0:
         s := VALOF SWITCHON (byte2 >> 3) & 7 INTO
         $( CASE 0: RESULTIS "RLC*T"
            CASE 1: RESULTIS "RRC*T"
            CASE 2: RESULTIS "RL*T"
            CASE 3: RESULTIS "RR*T"
            CASE 4: RESULTIS "SLA*T"
            CASE 5: RESULTIS "SRA*T"
            CASE 6: RESULTIS "?"
            CASE 7: RESULTIS "SRL*T"
         $)
         writes(s)
         ENDCASE

      CASE 1:
         writef("BIT*T%N,", (byte2>>3)&7)
         ENDCASE

      CASE 2:
         writef("RES*T%N,", (byte2>>3) & 7)
         ENDCASE

      CASE 3:
         writef("SET*T%N,", (byte2>>3) & 7)
   $)

   writes(hlflag NE 0 -> r, regr(byte2))
$)

AND secondary.instr(byte1) BE
$( LET n = ?

   SWITCHON (byte1 >> 6) & 3 INTO
   $( CASE 0:
         wrch('?')
         ENDCASE

      CASE 1:
         SWITCHON byte1 & 7 INTO
         $( CASE 0:
               writef("IN*T%S,(C)", regr(byte1 >> 3))
               ENDCASE

            CASE 1:
               writef("OUT*T%S,(C)", regr(byte1 >> 3))
               ENDCASE

            CASE 2:
               writef("%S*THL,",((byte1&#10)=0 -> "SBC","ADC"))
               regdd(byte1>>4)
               ENDCASE

            CASE 3:
               n := nextbyte()
               n := n + (nextbyte() << 8)
               TEST (byte1 & #10) = 0
               $( writef("LD*T(%N),", n)
                  regdd(byte1 >> 4)
               $)
               OR
               $( writes("LD*T")
                  regdd(byte1 >> 4)
                  writef(",(%N)", n)
               $)
               ENDCASE

            CASE 4:
               TEST (byte1 & #70) NE 0 DO wrch('?')
               OR writes("NEG")
               ENDCASE

            CASE 5:
               TEST (byte1 & #60) NE 0 DO wrch('?')
               OR TEST (byte1 & #10) = 0 DO writes("RETN")
                  OR writes("RETI")
               ENDCASE

            CASE 6:
               byte1 := (byte1 >> 3) & 3
               IF byte1 NE 0 DO byte1 := byte1 - 1
               writef("IM*T%N", byte1)
               ENDCASE

            CASE 7:
               n := VALOF SWITCHON (byte1 >> 3) & 7 INTO
               $( CASE 0:  RESULTIS "LD*TI,A"
                  CASE 1:  RESULTIS "LD*TR,A"
                  CASE 2:  RESULTIS "LD*TA,I"
                  CASE 3:  RESULTIS "LD*TA,R"
                  CASE 4:  RESULTIS "RRD"
                  CASE 5:  RESULTIS "RLD"
                  DEFAULT: RESULTIS "?"
               $)
               writes(n)
               ENDCASE
         $)
         ENDCASE

      CASE 2:
         SWITCHON byte1 & 7 INTO
         $( CASE 0:
               writes("Block move")
               ENDCASE
            CASE 1:
               writes("Block move & compare")
               ENDCASE
            CASE 2:
               writes("Block input")
               ENDCASE
            CASE 3:
               writes("Block output")
               ENDCASE
            DEFAULT:
               wrch('?')
         $)
         ENDCASE

      CASE 3:
         wrch('?')
   $)
$)

AND writeaddress(n) BE
   writef(" C+%X4*T", n)

AND code_heading() BE
$( writes("*N*T*TListing of generated code*N*N")
   writes(" Address*TOpcode   Operand*T    Code*N*N")
   code_heading_done_ := TRUE
$)

// End of file BCPLZ_BCPLZSRC

