 
// File CPM_BLIBS
 
// Version: C1.0
 
// BCPL part of standard BCPL library for Zilog Z80 under CP/M
 
// Copyright R.D. Eager   University of Kent   MCMLXXXIII
 
 
// History:
//  C1.0   - Initial version
 
GET "LIBHDR"
 
LET writed(n, d) BE
$( LET t = VEC 10
   AND i, k = 0, n
 
   IF (n NE 0) & ((n << 1) = 0) THEN
   $( writes("-2147483648")
      RETURN
   $)
   IF n < 0 THEN d, k := d - 1, -n
   $( t!i := k REM 10
      k := k / 10
      i := i + 1
   $) REPEATUNTIL k = 0
   FOR j = i + 1 TO d DO wrch('*S')
   IF n < 0 DO wrch('-')
   FOR j = i - 1 TO 0 BY -1 DO wrch(t!j + '0')
$)
 
LET readnumber(radix) = VALOF
$( LET sum, neg_, sign = 0, FALSE, +1
 
   $( terminator := rdch()
      SWITCHON terminator INTO
      $( CASE '-' : neg_ := TRUE
         CASE '+' : terminator := rdch()
         DEFAULT  : BREAK
         CASE '*S':
         CASE '*T':
         CASE '*C':
         CASE '*N':
         CASE '*P':
      $)
   $) REPEAT
 
   $( LET c = '0' LE terminator LE '9' -> terminator - '0',
              'a' LE terminator LE 'z' -> terminator - 'a' + 10,
              'A' LE terminator LE 'Z' -> terminator - 'A' + 10,
                                          100
      IF c GE radix RESULTIS sum
      sum := sum*radix + c*sign
      IF neg_ & sum NE 0 THEN
      $( sum := -sum
         sign := -1
         neg_ := FALSE
      $)
      terminator := rdch()
   $) REPEAT
$)
 
AND writef(format, a, b, c, d, e, f, g, h, i, j, k) BE
$( LET t = @a
 
   FOR p = 1 TO format%0 DO
   $( LET k = format%p
 
      TEST k = '%' THEN
      $( LET q, n = !t, 0
         AND type = format%(p + 1)
         AND f = ?
 
         p := p + 1
         SWITCHON type INTO
         $( DEFAULT  :  wrch(type); ENDCASE
 
            CASE 's' :
            CASE 'S' :  f := writes;   GOTO l
            CASE 'c' :
            CASE 'C' :  f := wrch;     GOTO l
            CASE 'o' :
            CASE 'O' :  f := writeoct; GOTO m
            CASE 'x' :
            CASE 'X' :  f := writehex; GOTO m
            CASE 'i' :
            CASE 'I' :  f := writed;   GOTO m
            CASE 'n' :
            CASE 'N' :  f := writed;   GOTO l
                   m :  p := p + 1
                        n := format%p
                        IF 'a' LE n LE 'z' THEN n := n - 'a' + 'A'
                        n := '0' LE n LE '9' -> n - '0', n - 'A' + 10
                   l :  f(q, n)
            CASE '$' :  t := t + 1
         $)
      $)
      OR wrch(k)
   $)
$)
 
AND writeoct(n, p) BE
$( IF p > 1 THEN writeoct(n >> 3, p - 1)
   wrch((n & #7) + '0')
$)
 
AND writehex(n, p) BE
$( LET m = n &#17
   IF p > 1 THEN writehex(n >> 4, p - 1)
   wrch(m + (m < 10 -> '0', 'A' - 10))
$)
 
AND writes(s) BE FOR i = 1 to s%0 DO wrch(s%i)
 
AND writeo(n) BE writeoct(n, 11)
 
AND writeh(n) BE writehex(n, 8)
 
AND writen(n) BE writed(n, 0)
 
AND newline() BE wrch('*N')
 
AND newpage() BE wrch('*P')
 
AND readn() = readnumber(10)
 
AND packstring(v, s) = VALOF
$( LET last.word = !v/bytesperword
 
   s!last.word := 0
   FOR i = 0 to !v DO s%i := v!i
   RESULTIS last.word
$)
 
AND unpackstring(s, v) BE
   FOR i = 0 TO s%0 DO v!i := s%i
 
// End of file CPM_BLIBS

