			BLOCK	VECTOR

			NOTE	VECTOR(PROCEDURE, SIZE)
			NOTE	APPLIES 'PROCEDURE' TO A DYNAMICALLY
			NOTE	CREATED VECTOR OF SIZE 'SIZE', BY MEANS
			NOTE	OF A CALL  PROCEDURE(VECTORADDRESS, SIZE)
			NOTE	THIS IS DONE BY PUSHING A LITTLE CODE
			NOTE	ONTO THE STACK TO SIMULATE A CALL TO
			NOTE	'PROCEDURE' WITH A SAVESPACE OF THE
			NOTE	APPROPRIATE SIZE. THE VECTOR DISAPPEARS
			NOTE	WHEN 'PROCEDURE' RETURNS. 'PROCEDURE' CAN
			NOTE	BE A FUNCTION, IN WHICH CASE ITS RESULT
			NOTE	WILL BE THE RESULT OF VECTOR.

			CONST
		I1	LD:M	2
		I2		N:731/9
		I3	SUBR:L	9
		I4	JI:M	0

			CODE
			JF	INIT

		VECTOR	RTOM		BASE OF CURRENT STACK FRAME
			ADD:L	11	SPACE FOR CODE, PARAMS, LINK AND VEC 0
			ADD:M	3	SIZE REQUIRED
			ST:S	0	TEMPORARY
			RTOM
			ADD:L	8	ADDRESS OF VECTOR
			ST:I	0	PUT IN NEXT FRAME
			INCS:S	0
			LD:M	3	SIZE REQUIRED
			ST:I	0	PUT IN NEXT FRAME
			ADD	I2	GENERATE CORRECT CALL INSTRUCTION
			ST:M	5	PUSH ONTO STACK
			LD	I1
			ST:M	4	PUSH SETUP INSTRUCTION ONTO STACK
			LD	I3	GENERATE CORRECT STACK
			ADD:M	3	UNWINDING INSTRUCTION
			ST:M	6	PUSH ONTO STACK
			LD	I4	PUSH RETURN INSTRUCTION
			ST:M	7	ONTO STACK
			RTOM
			ADD:L	4	GET ADDRESS OF CODE ON STACK
			LDK:S	1
			SML		CONVERT TO S-VALUE
			MTOS		EXECUTE ENTRY CODE

		INIT		N:751/0
				GLOBAL+399
			JB	VECTOR
				0


			BLOCK	ASSIGNED

			NOTE	FUNCTION TO CHECK IF A CHANNEL
			NOTE	IS ASSIGNED
			NOTE	TAKES ONE PARAMETER - THE CHANNEL NUMBER
			NOTE	RETURNS TRUE IF ASSIGNED, FALSE OTHERWISE

			DATA
		SAVE		

			CODE
			JF	INIT

			NOTE	ENTRY TO ASSIGNED

		ASSIGNED	STR	SAVE
			ADDR:L	2
			LD:L	18
			JIL	166
				N:711/0	SKIP AND CLEAR M
			LD	V:-1
			LDR	SAVE
			JI:M	0

		INIT		N:751/0
				GLOBAL+386
			JB	ASSIGNED
				0


			BLOCK	IOCHARS

			CODE
			JF	INIT

			NOTE	 ENTRY TO READCH

		READCH	LD:M	2	STREAM FOR INPUT
			ST:M	6
			LD	GLOBAL+63	INCH
				N:731/4
			SUBR:L	4
			ADD	GLOBAL+13
			ST	0
			LD:I	0
			ST	1
			LD:M	3
			ST:S	0
			LD:S	1
			ST:I	0
			JI:M	0

			NOTE	 ENTRY TO WRITECH

		WRITECH	LD:M	2	STREAM FOR OUTPUT
			ST:M	6
			LD:L	127
			AND:M	3
			ADD	GLOBAL+14
			ST	0
			LD:I	0
			ST:M	7
			LD	GLOBAL+64	OUTCH
				N:731/4
			SUBR:L	4
			JI:M	0

		INIT		N:751/0
				GLOBAL+69
			JB	READCH
				GLOBAL+70
			JB	WRITECH
				0


			BLOCK	STRINGS

			DATA
		COUNT
		SHIFT
		IPTR
		OPTR

			CODE
			JF	INIT

			NOTE	ENTRY TO PACKSTRING

		PACKSTRI	LD:M	2
			ST	IPTR
			LD:L	16
			ST	SHIFT
			LD:M	3
			ST	OPTR
			CLS:I	OPTR
			LD:I	IPTR
			AND:L	255
			ST	COUNT
			JZ:S	RDONE	NULL STRING
			JF:S	2
		PLOOP	LD:I	IPTR
			LDK	SHIFT
			SML
			F
			ADDS:I	OPTR
			LD:L	8
			SUBS	SHIFT
			JNN	SAMEWORD
			INCS	OPTR
			CLS:I	OPTR
			LD:L	16
			ST	SHIFT
		SAMEWORD	INCS	IPTR
			DECS	COUNT
			JN:S	RDONE
			JB:S	PLOOP
		RDONE	JI:M	0

			NOTE	ENTRY TO UNPACKSTRING

		UNPACKST	LD:M	2
			ST	IPTR
			LD:M	3
			ST	OPTR
			LD:L	8
			ST	SHIFT
			LD:I	IPTR
			LDK:S	16
			SMRL
			ST	COUNT
			ST:I	OPTR	PUT STRING LENGTH INTO ELEMENT ZERO
			JZ	UDONE	NULL STRING
			INCS	OPTR
		ULOOP	LD:I	IPTR
			LDK	SHIFT
			SMRL
			F
			AND:L	255
			ST:I	OPTR
			INCS	OPTR
			DECS	COUNT
			JZ	UDONE
			LD:L	8
			SUBS	SHIFT
			JN:S	NEXTWORD
			JB:S	ULOOP
		NEXTWORD	LD:L	16
			ST	SHIFT
			INCS	IPTR
			JB	ULOOP
		UDONE	JI:M	0

		INIT		N:751/0
				GLOBAL+66
			JB	PACKSTRING
				GLOBAL+67
			JB	UNPACKSTRING
				0


			BLOCK	JMPLEVEL

			CODE
			JF	INIT

			NOTE	ENTRY TO LEVEL

		LEVEL	RTOM
			SUB	1
			JI:M	0

			NOTE	ENTRY TO LONGJUMP

		LONGJUMP	LD:M	3
			LDR:M	2
			MTOS

		INIT		N:751/0
				GLOBAL+61
			JB	LEVEL
				GLOBAL+62
			JB	LONGJUMP
				0


			BLOCK	PRINTARROW

			CONST
		ARROW		0	SLEW CHARACTER
				O:00010166
				C:<===
				C:====
				C:====
			DATA
		SAVE

			CODE
			JF	INIT

			NOTE	ENTRY TO PRINTARROW

		PRINTARR	STR	SAVE
			LDR:L	ARROW
			LDK:L	20
			JIL	162
			LDR	SAVE
			JI:M	0

		INIT		N:751/0
				GLOBAL+49
			JB	PRINTARROW
				0


			BLOCK	UPNODE

			CODE
			JF	INIT

			NOTE	ENTRY TO OPENX

		OPENX	LD:M	2
			ADD:L	2
			JI:M	0

			NOTE	ENTRY TO POPX

		POPX	LD:M	2
			ST	0
			INCS:I	0
			LD:I	0
			ST	0
			LD:I	0
			JI:M	0

		INIT		N:751/0
				GLOBAL+103
			JB	OPENX
				GLOBAL+104
			JB	POPX
				0
