			BLOCK	VECTOR

			NOTE	THIS ROUTINE PRODUCES THE EFFECT OF A DYNAMIC
			NOTE	VECTOR IN A BCPL PROGRAM
			NOTE	IT IS CALLED BY	VECTOR(ROUTINE, SIZE)
			NOTE	'ROUTINE' IS THE ROUTINE TO WHICH THE
			NOTE	VECTOR IS TO BE APPLIED
			NOTE	'SIZE' IS THE SIZE OF THE VECTOR REQUIRED
			NOTE	THE GIVEN ROUTINE IS CALLED WITH TWO PARAMETERS
			NOTE	THE FIRST IS THE VECTOR ADDRESS,
			NOTE	THE SECOND IS THE VECTOR SIZE

			CONST
		LABV		0
				1
				GLOBAL+399
				2

			CODE
			LDR:L	LABV
			JFL	INIT*LAST	INITIALISATION
			JF	LEND

			NOTE	ENTRY TO VECTOR

		VECTOR	LD	0
			ST:M	0	SAVE LINK
			RTOM		BASE OF CURRENT STACK FRAME
			ADD:L	7	SPACE FOR PARAMS, LINK AND VEC 0
			ADD:M	3	SIZE REQUIRED
			ST:S	0	TEMPORARY
			RTOM
			ADD:L	4	ADDRESS OF VECTOR
			ST:I	0	PUT IN NEXT FRAME
			INCS:S	0
			LD:M	3	SIZE REQUIRED
			ST:I	0	PUT IN NEXT FRAME
			ADD:L	5
			ST:S	0	SAVE REQUIRED INCREMENT TO R
			LD:M	2	ROUTINE ADDRESS
			ST:S	1	TEMPORARY
			RTOM
			ADDR:S	0	INCREMENT R FOR CALL
			ST:M	1	SAVE OLD STACK POINTER IN NEXT FRAME
			JIL:S	1	CALL THE ROUTINE
			LD:M	0	GET RETURN LINK
			LDR:M	1	RESTORE STACK POINTER
			MTOS		RETURN FROM VECTOR ROUTINE

		LEND	HALT


			BLOCK	SHIFTS	TEMPORARY ROUTINES
			CONST
		LABV		0
				4
				GLOBAL+299
				2
				GLOBAL+298
				12
				GLOBAL+297
				22
				GLOBAL+296
				36

			CODE
			LDR:L	LABV
			JFL	INIT*LAST
			JF	LEND

			NOTE	ENTRY TO ARSHIFT

			LD:M	2
			LDK:M	3
			SMR
			ST:M	0
			LDR:M	1
			JIR	0

			NOTE	ENTRY TO ROTL

			LD:M	2
			LDK:M	3
			SMLA
			ST:M	0
			LDR:M	1
			JIR	0

			NOTE	ENTRY TO ROTR

			LD:L	24
			SUB:M	3
			MTOK
			LD:M	2
			SMLA
			ST:M	0
			LDR:M	1
			JIR	0

			NOTE	ENTRY TO ABS

			LD:M	2
			JNN:S	2
			NADD:L	0
			ST:M	0
			LDR:M	1
			JIR	0

		LEND	HALT


			BLOCK	ASSIGNED

			NOTE	FUNCTION TO CHECK IF A CHANNEL
			NOTE	IS ASSIGNED
			NOTE	TAKES ONE PARAMETER - THE CHANNEL NUMBER
			NOTE	RETURNS TRUE IF ASSIGNED, FALSE OTHERWISE

			DATA
		SAVE		2

			CONST
		LABV		0
				1
				GLOBAL+386
				2

			CODE
			LDR:L	LABV
			JFL	INIT*LAST
			JF	LEND

			NOTE	ENTRY TO ASSIGNED

		ASSIGNED	LD	0
			WB	SAVE
			ADDR:L	2
			LD:L	18
			JIL	166
			JF	4
			LD	V:-1
			JF	2
			LD:L	0
			LDR	SAVE
			ST:M	0
			LDR:M	1
			JI	SAVE+1

		LEND	HALT


			BLOCK	IOCHARS

			CONST
		LABV		0
				2
				GLOBAL+69	READCH
				2
				GLOBAL+70	WRITECH
				40

			CODE
			LDR:L	LABV
			JFL	INIT*LAST
			JF	LEND

			NOTE	 ENTRY TO READCH

		READCH	LD	0
			ST:M	0
			LD:M	2
			ST:M	6
			STR:M	5
			ADDR:L	4
			JIL	GLOBAL+63	INCH
			LD:M	4
			ADD	GLOBAL+13
			ST	TEMP
			LD:I	TEMP
			ST:M	4
			LD:M	3
			ST	TEMP
			LD:M	4
			ST:I	TEMP
			LD:M	0
			LDR:M	1
			MTOS	

			NOTE	 ENTRY TO WRITECH

		WRITECH	LD	0
			ST:M	0
			LD:M	2
			ST:M	6
			LD:L	127
			AND:M	3
			ADD	GLOBAL+14
			ST	TEMP
			LD:I	TEMP
			ST:M	7
			STR:M	5
			ADDR:L	4
			JIL	GLOBAL+64	OUTCH
			LD:M	0
			LDR:M	1
			MTOS	

		LEND	HALT


			BLOCK	STRINGS

			DATA
		COUNT
		SHIFT
		IPTR
		OPTR

			CONST
		LABV		0
				2
				GLOBAL+66	PACKSTRING
				2
				GLOBAL+67	UNPACKSTRING
				56

			CODE
			LDR:L	LABV
			JFL	INIT*LAST
			JF	LEND

			NOTE	ENTRY TO PACKSTRING

		PACKSTRI	LD:M	2
			ST	IPTR
			LD:L	16
			ST	SHIFT
			LD:M	3
			ST	OPTR
			CLS:I	OPTR
			LD:I	IPTR
			AND:L	255
			ST	COUNT
			JZ:S	RDONE	NULL STRING
			JF:S	2
		PLOOP	LD:I	IPTR
			LDK	SHIFT
			SML
			F
			ADDS:I	OPTR
			LD:L	8
			SUBS	SHIFT
			JNN	SAMEWORD
			INCS	OPTR
			CLS:I	OPTR
			LD:L	16
			ST	SHIFT
		SAMEWORD	INCS	IPTR
			DECS	COUNT
			JN:S	RDONE
			JB:S	PLOOP
		RDONE	LDR:M	1
			JI	0

			NOTE	ENTRY TO UNPACKSTRING

		UNPACKST	LD:M	2
			ST	IPTR
			LD:M	3
			ST	OPTR
			LD:L	8
			ST	SHIFT
			LD:I	IPTR
			LDK:L	16
			SMRL
			ST	COUNT
			ST:I	OPTR	PUT STRING LENGTH INTO ELEMENT ZERO
			JZ:S	UDONE	NULL STRING
			INCS	OPTR
		ULOOP	LD:I	IPTR
			LDK	SHIFT
			SMRL
			AND:L	255
			ST:I	OPTR
			INCS	OPTR
			DECS	COUNT
			JZ:S	UDONE
			LD:L	8
			SUBS	SHIFT
			JN:S	NEXTWORD
			JB:S	ULOOP
		NEXTWORD	LD:L	16
			ST	SHIFT
			INCS	IPTR
			JB:S	ULOOP
		UDONE	LDR:M	1
			JI	0

		LEND	HALT


			BLOCK	JMPLEVEL

			CONST
		LABV		0
				2
				GLOBAL+61	LEVEL
				2
				GLOBAL+62	LONGJUMP
				10

			CODE
			LDR:L	LABV
			JFL	INIT*LAST
			JF	LEND

			NOTE	ENTRY TO LEVEL

		LEVEL	LD:M	1
			ST:M	0
			MTOR
			JI	0

			NOTE	ENTRY TO LONGJUMP

		LONGJUMP	LD:M	3
			LDR:M	2
			MTOS

		LEND	HALT


			BLOCK	PRINTARROW

			CONST
		ARROW		0	SLEW CHARACTER
				O:00010166
				C:<===
				C:====
				C:====
		LABV		0
				1
				GLOBAL+49
				2

			CODE
			LDR:L	LABV
			JFL	INIT*LAST
			JF	LEND

			NOTE	ENTRY TO PRINTARROW

		PRINTARR	STR	TEMP
			LD	0
			ST:M	0
			LDR:L	ARROW
			LDK:L	20
			JIL	162
			LDR	TEMP
			LD:M	0
			LDR:M	1
			MTOS

		LEND	HALT


			BLOCK	UPNODE

			CONST
		LABV		0
				2
				GLOBAL+103
				2
				GLOBAL+104
				12

			CODE
			LDR:L	LABV
			JFL	INIT*LAST
			JF	LEND

			NOTE	ENTRY TO OPENX

		OPENX	LD:M	2
			ADD:L	2
			ST:M	0
			LDR:M	1
			JI	0

			NOTE	ENTRY TO POPX

		POPX	LD:M	2
			ST	TEMP
			INCS:I	TEMP
			LD:I	TEMP
			ST	TEMP
			LD:I	TEMP
			ST:M	0
			LDR:M	1
			JI	0

		LEND	HALT
