//
// TISL/src/tisl/operation.h
// TISL Ver. 4.x
//

#ifndef TISL_OPERATION_H
#define TISL_OPERATION_H

#ifdef _WIN32
#define OPERATION_CALL _stdcall
#else
#define OPERATION_CALL
#endif

VM_RET OPERATION_CALL op_discard(tPVM vm);
VM_RET OPERATION_CALL op_push_nil(tPVM vm);
VM_RET OPERATION_CALL op_push_t(tPVM vm);
VM_RET OPERATION_CALL op_push_integer(tINT i, tPVM vm);
VM_RET OPERATION_CALL op_push_float(tFLOAT f, tPVM vm);
VM_RET OPERATION_CALL op_push_character(tCHAR c, tPVM vm);
VM_RET OPERATION_CALL op_push_cons(tPCELL cell, tPVM vm);
VM_RET OPERATION_CALL op_push_string(tPCELL cell, tPVM vm);
VM_RET OPERATION_CALL op_push_symbol(tPCELL cell, tPVM vm);
VM_RET OPERATION_CALL op_push_vector(tPCELL cell, tPVM vm);
VM_RET OPERATION_CALL op_push_array(tPCELL cell, tPVM vm);
VM_RET OPERATION_CALL op_push_cell_object(tPCELL cell, tPVM vm);
//[
VM_RET OPERATION_CALL op_push_stack(tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_push_heap(tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_push_variable(tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_call_rec(tPVM vm);
VM_RET OPERATION_CALL op_call_tail_rec(tPVM vm);
VM_RET OPERATION_CALL op_call(tINT anum, tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_call_tail(tINT anum, tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_call_bind(tINT anum, tPCELL bind, tPVM vm);
VM_RET OPERATION_CALL op_call_bind_tail(tINT anum, tPCELL bind, tPVM vm);
VM_RET OPERATION_CALL op_call_local_stack(tPCELL func, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_call_local_heap(tPCELL func, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_call_local_stack_tail(tPCELL func, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_call_local_heap_tail(tPCELL func, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_lambda_in(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_lambda_out(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_lambda_heap_in(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_lambda_heap_out(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_push_function(tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_push_local_function(tPCELL function, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_push_lambda(tPCELL func, tPVM vm);
VM_RET OPERATION_CALL op_labels_in(tPCELL nlist, tPVM vm);
VM_RET OPERATION_CALL op_labels_out(tPVM vm);
VM_RET OPERATION_CALL op_flet_in(tPCELL nlist, tPVM vm);
VM_RET OPERATION_CALL op_flet_out(tPVM vm);
VM_RET OPERATION_CALL op_and_check(tPVM vm);
VM_RET OPERATION_CALL op_or_check(tPVM vm);
VM_RET OPERATION_CALL op_set_stack(tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_set_heap(tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_set_variable(tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_set_dynamic(tPCELL name, tPVM vm);
VM_RET OPERATION_CALL op_set_aref(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_set_garef(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_set_elt(tPVM vm);
VM_RET OPERATION_CALL op_set_property(tPVM vm);
VM_RET OPERATION_CALL op_set_car(tPVM vm);
VM_RET OPERATION_CALL op_set_cdr(tPVM vm);
VM_RET OPERATION_CALL op_set_accessor(tPCELL name, tPVM vm);
VM_RET OPERATION_CALL op_push_dynamic(tPCELL name, tPVM vm);
VM_RET OPERATION_CALL op_dynamic_let_init(tPCELL name, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_dynamic_let(tPCELL function, tINT n, tPVM vm);
VM_RET OPERATION_CALL op_case_check(tPCELL keylist, tPVM vm);
VM_RET OPERATION_CALL op_case_result(tPCELL function, tPVM vm);
void OPERATION_CALL op_case_end(tPVM vm);
VM_RET OPERATION_CALL op_case_using_predicate(tPCELL keylist, tPVM vm);
VM_RET OPERATION_CALL op_case_using_check(tPVM vm);
VM_RET OPERATION_CALL op_case_using_result(tPCELL function, tPVM vm);
void OPERATION_CALL op_case_using_end(tPVM vm);
VM_RET OPERATION_CALL op_while_check(tPVM vm);
VM_RET OPERATION_CALL op_for_stack_init(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_for_test(tPVM vm);
VM_RET OPERATION_CALL op_for_stack_iteration(tINT n, tPVM vm);
VM_RET OPERATION_CALL op_for_stack_result(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_for_heap_init(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_for_heap_iteration(tINT n, tPVM vm);
VM_RET OPERATION_CALL op_for_heap_result(tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_block(tPCELL function, tPCELL tag, tPVM vm);
VM_RET OPERATION_CALL op_return_from(tPCELL tag, tPVM vm);
VM_RET OPERATION_CALL op_catch(tPCELL function, tPVM vm);
VM_RET OPERATION_CALL op_throw(tPVM vm);
VM_RET OPERATION_CALL op_tagbody(tPCELL flist, tPCELL taglist, tPVM vm);
VM_RET OPERATION_CALL op_go(tPCELL tag, tPVM vm);
VM_RET OPERATION_CALL op_unwind_protect(tPCELL clean_up, tPCELL body, tPVM vm);
VM_RET OPERATION_CALL op_class(tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_the(tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_assure(tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_convert(tPCELL blist, tPVM vm);
VM_RET OPERATION_CALL op_with_standard_input(tPCELL function, tPVM vm);
VM_RET OPERATION_CALL op_with_standard_output(tPCELL function, tPVM vm);
VM_RET OPERATION_CALL op_with_error_output(tPCELL function, tPVM vm);
VM_RET OPERATION_CALL op_with_open_input_file(tPCELL function, tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_with_open_output_file(tPCELL function, tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_with_open_io_file(tPCELL function, tPCELL plist, tPVM vm);
VM_RET OPERATION_CALL op_ignore_errors(tPCELL function, tPVM vm);
VM_RET OPERATION_CALL op_with_handler(tPCELL function, tPVM vm);
VM_RET OPERATION_CALL op_continue_condition(tPVM vm);
VM_RET OPERATION_CALL op_time(tPCELL function, tPVM vm);
VM_RET OPERATION_CALL op_quasiquote(tPVM vm);
VM_RET OPERATION_CALL op_quasiquote2(tPVM vm);
VM_RET OPERATION_CALL op_unquote(tPVM vm);
VM_RET OPERATION_CALL op_unquote_splicing(tPVM vm);
VM_RET OPERATION_CALL op_unquote_splicing2(tPVM vm);
VM_RET OPERATION_CALL op_call_next_method_around(tINT dymmy, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_call_next_method_primary(tINT dummy, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_next_method_p_around(tINT dummy, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_next_method_p_primary(tINT dummy, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_functionp(tPVM vm);
VM_RET OPERATION_CALL op_apply(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_funcall(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_eq(tPVM vm);
VM_RET OPERATION_CALL op_eql(tPVM vm);
VM_RET OPERATION_CALL op_equal(tPVM vm);
VM_RET OPERATION_CALL op_not(tPVM vm);
VM_RET OPERATION_CALL op_generic_function_p(tPVM vm);
VM_RET OPERATION_CALL op_class_of(tPVM vm);
VM_RET OPERATION_CALL op_instancep(tPVM vm);
VM_RET OPERATION_CALL op_subclassp(tPVM vm);
VM_RET OPERATION_CALL op_symbolp(tPVM vm);
VM_RET OPERATION_CALL op_property(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_remove_property(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_gensym(tPVM vm);
VM_RET OPERATION_CALL op_numberp(tPVM vm);
VM_RET OPERATION_CALL op_parse_number(tPVM vm);
VM_RET OPERATION_CALL op_number_equal(tPVM vm);
VM_RET OPERATION_CALL op_number_not_equal(tPVM vm);
VM_RET OPERATION_CALL op_number_ge(tPVM vm);
VM_RET OPERATION_CALL op_number_le(tPVM vm);
VM_RET OPERATION_CALL op_number_greater(tPVM vm);
VM_RET OPERATION_CALL op_number_less(tPVM vm);
VM_RET OPERATION_CALL op_addition(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_multiplication(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_substraction(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_quotient(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_reciprocal(tPVM vm);
VM_RET OPERATION_CALL op_max(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_min(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_abs(tPVM vm);
VM_RET OPERATION_CALL op_exp(tPVM vm);
VM_RET OPERATION_CALL op_log(tPVM vm);
VM_RET OPERATION_CALL op_expt(tPVM vm);
VM_RET OPERATION_CALL op_sqrt(tPVM vm);
VM_RET OPERATION_CALL op_sin(tPVM vm);
VM_RET OPERATION_CALL op_cos(tPVM vm);
VM_RET OPERATION_CALL op_tan(tPVM vm);
VM_RET OPERATION_CALL op_atan(tPVM vm);
VM_RET OPERATION_CALL op_atan2(tPVM vm);
VM_RET OPERATION_CALL op_sinh(tPVM vm);
VM_RET OPERATION_CALL op_cosh(tPVM vm);
VM_RET OPERATION_CALL op_tanh(tPVM vm);
VM_RET OPERATION_CALL op_atanh(tPVM vm);
VM_RET OPERATION_CALL op_floatp(tPVM vm);
VM_RET OPERATION_CALL op_float(tPVM vm);
VM_RET OPERATION_CALL op_floor(tPVM vm);
VM_RET OPERATION_CALL op_ceiling(tPVM vm);
VM_RET OPERATION_CALL op_truncate(tPVM vm);
VM_RET OPERATION_CALL op_round(tPVM vm);
VM_RET OPERATION_CALL op_integerp(tPVM vm);
VM_RET OPERATION_CALL op_div(tPVM vm);
VM_RET OPERATION_CALL op_mod(tPVM vm);
VM_RET OPERATION_CALL op_gcd(tPVM vm);
VM_RET OPERATION_CALL op_lcm(tPVM vm);
VM_RET OPERATION_CALL op_isqrt(tPVM vm);
VM_RET OPERATION_CALL op_characterp(tPVM vm);
VM_RET OPERATION_CALL op_char_equal(tPVM vm);
VM_RET OPERATION_CALL op_char_not_equal(tPVM vm);
VM_RET OPERATION_CALL op_char_less(tPVM vm);
VM_RET OPERATION_CALL op_char_greater(tPVM vm);
VM_RET OPERATION_CALL op_char_le(tPVM vm);
VM_RET OPERATION_CALL op_char_ge(tPVM vm);
VM_RET OPERATION_CALL op_consp(tPVM vm);
VM_RET OPERATION_CALL op_cons(tPVM vm);
VM_RET OPERATION_CALL op_car(tPVM vm);
VM_RET OPERATION_CALL op_cdr(tPVM vm);
VM_RET OPERATION_CALL op_null(tPVM vm);
VM_RET OPERATION_CALL op_listp(tPVM vm);
VM_RET OPERATION_CALL op_create_list(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_list(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_reverse(tPVM vm);
VM_RET OPERATION_CALL op_nreverse(tPVM vm);
VM_RET OPERATION_CALL op_append(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_member(tPVM vm);
VM_RET OPERATION_CALL op_mapcar(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_mapc(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_mapcan(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_maplist(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_mapl(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_mapcon(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_assoc(tPVM vm);
VM_RET OPERATION_CALL op_basic_array_p(tPVM vm);
VM_RET OPERATION_CALL op_basic_array_a_p(tPVM vm);
VM_RET OPERATION_CALL op_general_array_a_p(tPVM vm);
VM_RET OPERATION_CALL op_create_array(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_aref(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_garef(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_array_dimensions(tPVM vm);
VM_RET OPERATION_CALL op_basic_vector_p(tPVM vm);
VM_RET OPERATION_CALL op_general_vector_p(tPVM vm);
VM_RET OPERATION_CALL op_create_vector(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_vector(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_stringp(tPVM vm);
VM_RET OPERATION_CALL op_create_string(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_string_equal(tPVM vm);
VM_RET OPERATION_CALL op_string_not_equal(tPVM vm);
VM_RET OPERATION_CALL op_string_less(tPVM vm);
VM_RET OPERATION_CALL op_string_greater(tPVM vm);
VM_RET OPERATION_CALL op_string_ge(tPVM vm);
VM_RET OPERATION_CALL op_string_le(tPVM vm);
VM_RET OPERATION_CALL op_char_index(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_string_index(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_string_append(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_length(tPVM vm);
VM_RET OPERATION_CALL op_elt(tPVM vm);
VM_RET OPERATION_CALL op_subseq(tPVM vm);
VM_RET OPERATION_CALL op_map_into(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_streamp(tPVM vm);
VM_RET OPERATION_CALL op_open_stream_p(tPVM vm);
VM_RET OPERATION_CALL op_input_stream_p(tPVM vm);
VM_RET OPERATION_CALL op_output_stream_p(tPVM vm);
VM_RET OPERATION_CALL op_standard_input(tPVM vm);
VM_RET OPERATION_CALL op_standard_output(tPVM vm);
VM_RET OPERATION_CALL op_error_output(tPVM vm);
VM_RET OPERATION_CALL op_open_input_file(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_open_output_file(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_open_io_file(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_close(tPVM vm);
VM_RET OPERATION_CALL op_finish_output(tPVM vm);
VM_RET OPERATION_CALL op_create_string_input_stream(tPVM vm);
VM_RET OPERATION_CALL op_create_string_output_stream(tPVM vm);
VM_RET OPERATION_CALL op_get_output_stream_string(tPVM vm);
VM_RET OPERATION_CALL op_read(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_read_char(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_preview_char(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_read_line(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_stream_ready_p(tPVM vm);
VM_RET OPERATION_CALL op_format(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_format_char(tPVM vm);
VM_RET OPERATION_CALL op_format_float(tPVM vm);
VM_RET OPERATION_CALL op_format_fresh_line(tPVM vm);
VM_RET OPERATION_CALL op_format_integer(tPVM vm);
VM_RET OPERATION_CALL op_format_object(tPVM vm);
VM_RET OPERATION_CALL op_format_tab(tPVM vm);
VM_RET OPERATION_CALL op_read_byte(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_write_byte(tPVM vm);
VM_RET OPERATION_CALL op_probe_file(tPVM vm);
VM_RET OPERATION_CALL op_file_position(tPVM vm);
VM_RET OPERATION_CALL op_set_file_position(tPVM vm);
VM_RET OPERATION_CALL op_file_length(tPVM vm);
VM_RET OPERATION_CALL op_error(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_cerror(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_signal_condition(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_condition_continuable(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_arithmetic_error_operation(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_arithmetic_error_operand(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_domain_error_object(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_domain_error_expected_class(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_parse_error_string(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_parse_error_expected_class(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_simple_error_format_string(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_simple_error_format_arguments(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_stream_error_stream(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_undefined_entity_name(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_undefined_entity_namespace(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_identity(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_get_universal_time(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_get_internal_run_time(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_get_internal_real_time(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_get_internal_time_units_per_second(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_system(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_exit(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_strftime(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_get_argument(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_get_environment(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_eval(tINT anum, tPVM vm);
VM_RET OPERATION_CALL op_arity_error(tPVM vm);
VM_RET OPERATION_CALL op_number_equal_stack_integer(tINT i, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_number_equal_stack_stack(tINT offset2, tINT offset1, tPVM vm);
VM_RET OPERATION_CALL op_number_not_equal_stack_integer(tINT i, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_number_not_equal_stack_stack(tINT offset2, tINT offset1, tPVM vm);
VM_RET OPERATION_CALL op_number_less_stack_integer(tINT i, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_number_less_integer_stack(tINT offset, tINT i, tPVM vm);
VM_RET OPERATION_CALL op_number_less_stack_stack(tINT offset2, tINT offset1, tPVM vm);
VM_RET OPERATION_CALL op_number_le_stack_integer(tINT i, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_number_le_integer_stack(tINT offset, tINT i, tPVM vm);
VM_RET OPERATION_CALL op_number_le_stack_stack(tINT offset2, tINT offset1, tPVM vm);
VM_RET OPERATION_CALL op_addition_stack_integer(tINT i, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_addition_stack_stack(tINT offset2, tINT offset1, tPVM vm);
VM_RET OPERATION_CALL op_substraction_stack_integer(tINT i, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_substraction_integer_stack(tINT offset, tINT i, tPVM vm);
VM_RET OPERATION_CALL op_substraction_stack_stack(tINT offset2, tINT offset1, tPVM vm);
VM_RET OPERATION_CALL op_eq_stack_integer(tINT i, tINT offset, tPVM vm);
VM_RET OPERATION_CALL op_eq_stack_stack(tINT offset2, tINT offset1, tPVM vm);
VM_RET OPERATION_CALL op_equal_stack_stack(tINT offset2, tINT offset1, tPVM vm);

#endif
