; bucket.lsp             Gordon S. Novak Jr.             ; 08 Jan 04

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.


; Generic types for Ordered-Buckets symbol table.

; 21 May 92; 05 Jan 95; 02 Jan 97; 28 Feb 02

; (glviewas 'sorted-linked-list 'syment)

(gldefclusterc
  'ordered-buckets
  '((index-array (ordered-buckets-index-array
	      (tuple (index-array (arrayof sll-pointer)))
	     msg     ((insert      ordered-buckets-insert       open t)
		      (insertb     ordered-buckets-insertb      open t)
		      (insert-key  ordered-buckets-insert-key   open t)
		      (remove      ordered-buckets-remove       open t)
		      (remove-key  ordered-buckets-remove-key   open t)
		      (merge       ordered-buckets-merge  specialize t)
		      (newrec      ordered-buckets-newrec specialize t)
		      (subset      ordered-buckets-subset specialize t)
		      (iterator    double-iterator) )
            supers   (array)  ) ) )
  '()   )

; 26 Sep 91; 02 Oct 91; 10 Oct 91
(gldefun ordered-buckets-insert ((q ordered-buckets) rec)
  (insertb q (sorted-linked-list rec) ) )

; 10 Oct 91
(gldefun ordered-buckets-insertb ((q ordered-buckets) rec)
  ((index q (indexfn q rec)) = (insert (index q (indexfn q rec)) rec)) )

; 26 Sep 91; 02 Oct 91
(gldefun ordered-buckets-insert-key ((q ordered-buckets) key)
  (let (newitem)
    (newitem = (newrec q))
    ((sort-value (^. newitem)) = key)
    (insertb q newitem)
    newitem ))

; 26 Sep 91; 10 Oct 91
(gldefun ordered-buckets-remove ((q ordered-buckets) rec)
  ((index q (indexfn q rec)) = (remove (index q (indexfn q rec))) ) )

; 26 Sep 91; 10 Oct 91
(gldefun ordered-buckets-remove-key ((q ordered-buckets) key)
  (let (newitem)
    (newitem = (newrec q))               ; ***** yuck: wastes storage!
    ((sort-value (^. newitem)) = key)
    ((index q (indexfn q newitem)) =
            (remove-key (index q (indexfn q newitem)) key) ) ))

; 02 Oct 91
(gldefun ordered-buckets-merge ((q ordered-buckets) (qq ordered-buckets))
  (let ((i 0) (sz (size q)))
    (while (i < sz) do
      ((index q i) = (merge (index q i) (index qq i)))
      (i _+ 1) ) ))

; 04 Oct 91
(gldefun ordered-buckets-subset ((q ordered-buckets) p)
  (let ((i 0) (sz (size q)) qq)
    (qq = (new (a (typeof q))))
    (while (i < sz) do
      ((index qq i) = (subset (index q i) p))
      (i _+ 1) )
    qq))

; 10 Oct 91
(gldefun ordered-buckets-newrec ((q ordered-buckets))
  (result (typeof (index q 0)))
  (a (typeof (implementation (^. (index q 0))))) )


; Example of hand-coded data structures for alphabetized-buckets symbol table

(glispobjects

(syment (list (name     string)               ; symbol table entry
	      (datatype symbol)
	      (offset   integer)
	      (nxt      (^ syment))) )

;              (arrayof (sorted-linked-list syment)) would be better
(syment-symtab (arrayof syment-as-sll-pointer) ; symbol table of syment entries
 prop ((creation-size (26)))
  msg ((indexfn syment-symtab-indexfn))
 supers (ordered-buckets-index-array) )

; symbol table of integers whose buckets are bl's ("backward" lists).
(bl-symtab (arrayof bl-as-sll-pointer)
 prop ((creation-size (10)))
  msg ((indexfn bl-symtab-indexfn))
 supers (ordered-buckets-index-array) )

 ) ; glispobjects

(gldefun syment-symtab-indexfn ((self syment-symtab) (rec syment))
  (result integer)
  (- (char-int (char-upcase (char (name rec) 0)))
     (char-int '#\A)))

(gldefun bl-symtab-indexfn ((self bl-symtab) (rec bl))
  (result integer)
  (truncate (val rec) 30))

(gldefun sya ((s syment) new) (insert (sorted-linked-list s) new))

(gldefun tsa ((s syment-symtab) (r syment)) (insert s r))

(gldefun tsb ((s syment-symtab) (r syment)) (indexfn s r))

(gldefun tsc () (new (a syment-symtab)))

(gldefun tsd ((s syment-symtab)) (for sym in s do (print (name sym))))

(gldefun tse ((s syment-symtab) (sb syment-symtab)) (merge s sb))

(gldefun tsl ((s syment-symtab)) (for sym in s stats (length (name sym))))

(gldefun tsm ((s syment-symtab)) (for sym in s sum (name sym)))

(gldefun syment-3char ((s syment)) ((length (name s)) == 3))
(gldefun syment-intp ((s syment)) ((datatype s) == 'integer))
(gldefun tsn ((s syment-symtab)) (subset s #'syment-3char))
(gldefun tsp ((s syment-symtab)) (subset s #'syment-intp))

(gldefun tso ((s syment-symtab))
  (for sym in s when (syment-3char sym) sum (name sym)))

(gldefun tsq ((s syment-symtab) (str string)) (insert-key s str))

(gldefun tsr ((s syment-symtab) (str string)) (remove-key s str))

(setq mysyms (list (a syment name "fum" datatype 'real offset 12)
		   (a syment name "baz" datatype 'integer offset 16)
		   (a syment name "foo" datatype 'real offset 4)
		   (a syment name "foobar" datatype 'integer offset 8)
		   (a syment name "bar" datatype 'real offset 20)
		   (a syment name "bat" datatype 'integer offset 24) ))

(setq mysymsb (list (a syment name "fulminate" datatype 'real offset 12)
		    (a syment name "bazoom" datatype 'integer offset 16)
		    (a syment name "foob" datatype 'integer offset 4)
		    (a syment name "foobarprime" datatype 'real offset 8)
		    (a syment name "barroom" datatype 'real offset 20)
		    (a syment name "battle" datatype 'integer offset 24) ))

(setq mysyment '("I" integer 3 ("N" integer 7 ("X" real 2 nil))))

; (glviewas 'sorted-linked-list 'syment) ; choose NAME, ASCENDING
; (sya mysyment '("W" string 4 nil))                ; insert a symbol
; (setq myst (tsc))                                 ; new symbol table
; (dolist (x (copy-tree mysyms)) (tsa myst x))      ; put in symbols
; (setq mystb (tsc))                                ; new symbol table
; (dolist (x (copy-tree mysymsb)) (tsa mystb x))    ; put in symbols
; (tse myst mystb)                                  ; merge the two
; (tsd myst)                                        ; print the result
; (glcp 'syment-3char)
; (tsd (tsn myst))                                  ; 3-char names
; (tsq myst "bats")                                 ; add a symbol
; (tsr myst "battle")                               ; remove a symbol

(gldefun tsf () (new (a bl-symtab)))

(gldefun tsg ((s bl-symtab) (r bl)) (insert s r))

(gldefun tsh ((s bl-symtab))
  (dotimes (i 20) (tsg s (a bl with val = (random 300)))) )

(gldefun tsi ((s bl-symtab)) (for sym in s do (print (val sym))))

(gldefun tsj ((s bl-symtab) (sb bl-symtab)) (merge s sb))

(gldefun tsk ((s bl-symtab)) (for sym in s stats (val sym)))

(gldefun tss ((s bl-symtab) (val integer)) (insert-key s val))

(gldefun tst ((s bl-symtab) (val integer)) (remove-key s val))

(gldefun tsu ((s bl-symtab)) (for sym in s sum (val sym)))

; (glviewas 'sorted-linked-list 'bl) ; choose ASCENDING
; (setq mybls (tsf))                                 ; new symbol table
; (tsh mybls)                                        ; put in symbols
; (setq myblsb (tsf))                                ; new symbol table
; (tsh myblsb)                                       ; put in symbols
; (tsj mybls myblsb)                                 ; merge the two
; (tsi mybls)                                        ; print the result
