; cone.lsp                Gordon S. Novak Jr.                ; 22 May 13

; Copyright (c) 2013 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; Menu and drawing code for cone and other graphical views.
; Note: button names must be consistent with equations as in physlaws.lsp

; 07 Nov 94; 05 Jan 95; 01 Mar 96; 04 Mar 97; 17 Oct 97; 29 May 98; 14 Jan 99
; 02 Feb 99; 04 Feb 99; 09 Feb 99; 18 Feb 99; 30 May 02; 03 Jun 04; 16 Jun 04
; 25 Jun 04; 02 Aug 04; 03 Aug 04; 04 Aug 04; 08 Feb 05; 30 Jun 06; 29 Sep 06
; 17 Apr 07; 24 Apr 07; 04 May 07; 09 May 07; 06 Dec 07; 15 Apr 08; 31 Dec 08
; 09 Jan 09; 02 Mar 10; 25 Mar 10; 17 Dec 10

; /v/ai/v0/novak/glisp/lseg.lsp    6 Oct 1992 10:16: 4


(SETF (GET 'CYLINDER 'DRAW-DESCR)
  '(DRAW-DESC CYLINDER
    ((DRAW-ELLIPSE (0 153) (104 46) NIL 0)
     (DRAW-LINE (52 176) (0 -154) NIL 0)
     (DRAW-ELLIPSE (1 0) (104 46) NIL 0)
     (DRAW-LINE (1 176) (0 -154) NIL 0)
     (DRAW-LINE (105 175) (0 -154) NIL 0)
     (DRAW-ARROW (52 176) (-36 -16) NIL 0)
     (DRAW-BUTTON (35 167) (4 4) RADIUS 0)
     (DRAW-TEXT (26 174) (7 10) "r" 0)
     (DRAW-BUTTON (50 99) (4 4) LENGTH 0)
     (DRAW-TEXT (39 106) (7 10) "l" 0)
     (DRAW-ARROW (52 23) (-36 -16) NIL 0)
     (DRAW-ARROW (52 22) (36 18) NIL 0)
     (DRAW-BUTTON (64 27) (4 4) DIAMETER 0)
     (DRAW-TEXT (56 33) (7 10) "d" 0)
     (DRAW-BUTTON (77 125) (4 4) VOLUME 1)
     (DRAW-TEXT (67 134) (7 14) "v" 1)
     (DRAW-BUTTON (76 177) (4 4) AREA 1)
     (DRAW-TEXT (65 179) (7 14) "a" 1)
     (DRAW-BUTTON (43 196) (4 4) CIRCUMFERENCE 1)
     (DRAW-TEXT (49 185) (7 14) "c" 1))
    (0 0) (105 199)))

(DEFUN DRAW-CYLINDER (W X Y)
  (WINDOW-DRAW-ELLIPSE-XY W (+ 52 X) (+ 176 Y) 52 23)
  (WINDOW-DRAW-LINE-XY W (+ 52 X) (+ 176 Y) (+ 52 X) (+ 22 Y))
  (WINDOW-DRAW-ELLIPSE-XY W (+ 53 X) (+ 23 Y) 52 23)
  (WINDOW-DRAW-LINE-XY W (1+ X) (+ 176 Y) (1+ X) (+ 22 Y))
  (WINDOW-DRAW-LINE-XY W (+ 105 X) (+ 175 Y) (+ 105 X) (+ 21 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 52 X) (+ 176 Y) (+ 16 X) (+ 160 Y))
  (WINDOW-PRINTAT-XY W "r" (+ 26 X) (+ 174 Y))
  (WINDOW-PRINTAT-XY W "l" (+ 39 X) (+ 106 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 52 X) (+ 23 Y) (+ 16 X) (+ 7 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 52 X) (+ 22 Y) (+ 88 X) (+ 40 Y))
  (WINDOW-PRINTAT-XY W "d" (+ 56 X) (+ 33 Y))
  (WINDOW-PRINTAT-XY W "v" (+ 67 X) (+ 134 Y))
  (WINDOW-PRINTAT-XY W "a" (+ 65 X) (+ 179 Y))
  (WINDOW-PRINTAT-XY W "c" (+ 49 X) (+ 185 Y))
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'CYLINDER 'PICMENU-SPEC)
      '(PICMENU-SPEC 105 199
           ((RADIUS (37 169)) (length (52 101)) (DIAMETER (66 29))) T
           DRAW-CYLINDER 9X15)) 

(SETF (GET 'CONE 'DRAW-DESCR)
      '(DRAW-DESC CONE
           ((DRAW-DOT (64 33) (4 4) NIL 0)
            (DRAW-ELLIPSE (0 0) (132 70) NIL 0)
            (DRAW-LINE (66 35) (0 152) NIL 0)
            (DRAW-LINE (66 187) (66 -152) NIL 0)
            (DRAW-LINE (66 187) (-66 -152) NIL 0)
            (DRAW-ARROW (66 35) (-48 -24) NIL 0)
            (DRAW-TEXT (37 30) (7 10) "r" 0)
            (DRAW-TEXT (53 115) (7 10) "h" 0)
            (DRAW-TEXT (89 145) (7 10) "m" 0)
            (DRAW-BUTTON (47 25) (4 4) RADIUS 0)
            (DRAW-BUTTON (64 112) (4 4) HEIGHT 0)
            (DRAW-BUTTON (84 139) (4 4) SIDE 0)
            (DRAW-TEXT (36 92) (21 14) "vol" 0)
            (DRAW-BUTTON (45 84) (4 4) VOLUME 0)
            (DRAW-TEXT (118 96) (28 14) "side" 0)
            (DRAW-TEXT (117 85) (28 14) "area" 0)
            (DRAW-BUTTON (106 91) (4 4) SIDE-AREA 0))
           (0 0) (146 187))) 

(DEFUN DRAW-CONE (W X Y)
  (WINDOW-DRAW-DOT-XY W (+ 66 X) (+ 35 Y))
  (WINDOW-DRAW-ELLIPSE-XY W (+ 66 X) (+ 35 Y) 66 35)
  (WINDOW-DRAW-LINE-XY W (+ 66 X) (+ 35 Y) (+ 66 X) (+ 187 Y))
  (WINDOW-DRAW-LINE-XY W (+ 66 X) (+ 187 Y) (+ 132 X) (+ 35 Y))
  (WINDOW-DRAW-LINE-XY W (+ 66 X) (+ 187 Y) X (+ 35 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 66 X) (+ 35 Y) (+ 18 X) (+ 11 Y))
  (WINDOW-PRINTAT-XY W "r" (+ 37 X) (+ 30 Y))
  (WINDOW-PRINTAT-XY W "h" (+ 53 X) (+ 115 Y))
  (WINDOW-PRINTAT-XY W "m" (+ 89 X) (+ 145 Y))
  (WINDOW-PRINTAT-XY W "vol" (+ 36 X) (+ 92 Y))
  (WINDOW-PRINTAT-XY W "side" (+ 118 X) (+ 96 Y))
  (WINDOW-PRINTAT-XY W "area" (+ 117 X) (+ 85 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'CONE 'PICMENU-SPEC)
      '(PICMENU-SPEC 146 187
           ((RADIUS (49 27)) (HEIGHT (66 114)) (SIDE (86 141))
            (VOLUME (47 86)) (SIDE-AREA (108 93)))
           T DRAW-CONE 9X15)) 

; glisp/draw.del    4 Feb 1999 16:45: 1


(SETF (GET 'CIRCLE'DRAW-DESCR)
      '(DRAW-DESC CIRCLE
           ((DRAW-CIRCLE (0 7) (166 166) NIL 0)
            (DRAW-DOT (81 84) (4 4) NIL 0)
            (DRAW-BUTTON (44 68) (4 4) RADIUS 0)
            (DRAW-TEXT (34 69) (7 10) "r" 0)
            (DRAW-ARROW (83 86) (-80 19) NIL 0)
            (DRAW-ARROW (83 86) (79 -20) NIL 0)
            (DRAW-BUTTON (114 75) (4 4) DIAMETER 0)
            (DRAW-TEXT (116 84) (7 10) "d" 0)
            (DRAW-BUTTON (108 10) (4 4) CIRCUMFERENCE 0)
            (DRAW-TEXT (115 0) (7 10) "c" 0)
            (DRAW-BUTTON (53 137) (4 4) AREA 0)
            (DRAW-TEXT (58 144) (28 10) "area" 0)
            (DRAW-BUTTON (81 84) (4 4) CENTER 0)
            (DRAW-TEXT (63 94) (42 10) "center" 0)
            (DRAW-ARROW (83 48) (0 36) NIL 0)
            (DRAW-ARROW (52 49) (32 0) NIL 0)
            (DRAW-ARROW (83 86) (-74 -33) NIL 0)
            (DRAW-BUTTON (62 47) (4 4) CENTERX 0)
            (DRAW-TEXT (61 36) (7 14) "x" 0)
            (DRAW-BUTTON (81 63) (4 4) CENTERY 0)
            (DRAW-TEXT (91 62) (7 14) "y" 0))
           (0 0) (166 173))) 

(DEFUN DRAW-CIRCLE (W X Y)
  (WINDOW-DRAW-CIRCLE-XY W (+ 83 X) (+ 90 Y) 83)
  (WINDOW-DRAW-DOT-XY W (+ 83 X) (+ 86 Y))
  (WINDOW-PRINTAT-XY W "r" (+ 34 X) (+ 69 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 83 X) (+ 86 Y) (+ 3 X) (+ 105 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 83 X) (+ 86 Y) (+ 162 X) (+ 66 Y))
  (WINDOW-PRINTAT-XY W "d" (+ 116 X) (+ 84 Y))
  (WINDOW-PRINTAT-XY W "c" (+ 115 X) Y)
  (WINDOW-PRINTAT-XY W "area" (+ 58 X) (+ 144 Y))
  (WINDOW-PRINTAT-XY W "center" (+ 63 X) (+ 94 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 83 X) (+ 48 Y) (+ 83 X) (+ 84 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 52 X) (+ 49 Y) (+ 84 X) (+ 49 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 83 X) (+ 86 Y) (+ 9 X) (+ 53 Y))
  (WINDOW-PRINTAT-XY W "x" (+ 61 X) (+ 36 Y))
  (WINDOW-PRINTAT-XY W "y" (+ 91 X) (+ 62 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'CIRCLE 'PICMENU-SPEC)
      '(PICMENU-SPEC 166 173
           ((RADIUS (46 70)) (DIAMETER (116 77))
            (CIRCUMFERENCE (110 12)) (AREA (55 139)) (CENTER (83 86))
            (CENTERX (64 49)) (CENTERY (83 65)))
           T DRAW-CIRCLE 9X15)) 


(SETF (GET 'RECTANGLE 'DRAW-DESCR)
      '(DRAW-DESC RECTANGLE
           ((DRAW-BOX (25 47) (158 89) NIL 0)
            (DRAW-ARROW (0 0) (25 47) NIL 0)
            (DRAW-BUTTON (9 17) (4 4) OFFSET 0)
            (DRAW-TEXT (19 14) (42 10) "offset" 0)
            (DRAW-ARROW (25 47) (158 89) NIL 0)
            (DRAW-BUTTON (96 85) (4 4) SIZE 0)
            (DRAW-TEXT (104 77) (28 10) "size" 0)
            (DRAW-BUTTON (102 45) (4 4) WIDTH 0)
            (DRAW-TEXT (89 32) (35 10) "width" 0)
            (DRAW-BUTTON (23 85) (4 4) HEIGHT 0)
            (DRAW-TEXT (27 90) (42 10) "height" 0)
            (DRAW-BUTTON (181 134) (4 4) CORNER 0)
            (DRAW-TEXT (163 141) (42 10) "corner" 0))
           (0 0) (205 151))) 

(DEFUN DRAW-RECTANGLE (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ X 25) (+ Y 47) 158 89)
  (WINDOW-DRAW-ARROW-XY W (+ X 0) (+ Y 0) (+ X 25) (+ Y 47))
  (WINDOW-PRINTAT-XY W "offset" (+ X 19) (+ Y 14))
  (WINDOW-DRAW-ARROW-XY W (+ X 25) (+ Y 47) (+ X 183) (+ Y 136))
  (WINDOW-PRINTAT-XY W "size" (+ X 104) (+ Y 77))
  (WINDOW-PRINTAT-XY W "width" (+ X 89) (+ Y 32))
  (WINDOW-PRINTAT-XY W "height" (+ X 27) (+ Y 90))
  (WINDOW-PRINTAT-XY W "corner" (+ X 163) (+ Y 141))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'RECTANGLE 'PICMENU-SPEC)
      '(PICMENU-SPEC 205 151
           ((OFFSET (11 19)) (SIZE (98 87)) (WIDTH (104 47))
            (HEIGHT (25 87)) (CORNER (183 136)))
           T DRAW-RECTANGLE 9X15)) 

; glisp/draw.del    2 Feb 1999 15:35:32


(SETF (GET 'LINE-SEGMENT 'DRAW-DESCR)
      '(DRAW-DESC LINE-SEGMENT
           ((DRAW-LINE (70 55) (131 83) NIL 0)
            (DRAW-LINE (66 60) (-11 15) NIL 0)
            (DRAW-LINE (198 144) (-11 15) NIL 0)
            (DRAW-ARROW (135 117) (55 36) NIL 0)
            (DRAW-ARROW (114 105) (-54 -34) NIL 0)
            (DRAW-LINE (83 54) (118 0) NIL 0)
            (DRAW-LINE (201 54) (0 73) NIL 0)
            (DRAW-LINE (100 73) (5 -7) NIL 0)
            (DRAW-LINE (105 66) (3 -13) NIL 0)
            (DRAW-BUTTON (121 108) (4 4) LENGTH 0)
            (DRAW-BUTTON (68 53) (4 4) P1 0)
            (DRAW-BUTTON (199 136) (4 4) P2 0)
            (DRAW-BUTTON (103 64) (4 4) THETA 0)
            (DRAW-BUTTON (140 52) (4 4) DELTAX 0)
            (DRAW-BUTTON (199 88) (4 4) DELTAY 0)
            (DRAW-LINE (212 138) (28 0) NIL 0)
            (DRAW-LINE (201 149) (0 24) NIL 0)
            (DRAW-LINE (32 54) (28 0) NIL 0)
            (DRAW-LINE (70 21) (0 24) NIL 0)
            (DRAW-TEXT (111 64) (35 10) "theta" 0)
            (DRAW-TEXT (124 38) (42 10) "deltax" 0)
            (DRAW-TEXT (210 86) (42 10) "deltay" 0)
            (DRAW-TEXT (52 41) (14 10) "p1" 0)
            (DRAW-TEXT (206 143) (14 10) "p2" 0)
            (DRAW-TEXT (62 0) (21 10) "p1x" 0)
            (DRAW-TEXT (0 50) (21 10) "p1y" 0)
            (DRAW-TEXT (190 182) (21 10) "p2x" 0)
            (DRAW-TEXT (251 134) (21 10) "p2y" 0)
            (DRAW-BUTTON (68 19) (4 4) P1X 0)
            (DRAW-BUTTON (30 52) (4 4) P1Y 0)
            (DRAW-BUTTON (199 171) (4 4) P2X 0)
            (DRAW-BUTTON (238 136) (4 4) P2Y 0)
            (DRAW-TEXT (90 116) (42 10) "length" 0)
            (DRAW-BUTTON (132 93) (4 4) SLOPE 0)
            (DRAW-TEXT (132 80) (35 14) "slope" 0)
            (DRAW-LINE (179 123) (8 -7) NIL 0)
            (DRAW-LINE (191 115) (10 -3) NIL 0)
            (DRAW-BUTTON (185 114) (4 4) PHI 0)
            (DRAW-TEXT (169 97) (21 14) "phi" 0)
            (DRAW-BUTTON (199 52) (4 4) SIZE 0)
            (DRAW-TEXT (205 40) (28 14) "size" 0))
           (0 0) (272 192))) 

(DEFUN DRAW-LINE-SEGMENT (W X Y)
  (WINDOW-DRAW-LINE-XY W (+ 70 X) (+ 55 Y) (+ 201 X) (+ 138 Y))
  (WINDOW-DRAW-LINE-XY W (+ 66 X) (+ 60 Y) (+ 55 X) (+ 75 Y))
  (WINDOW-DRAW-LINE-XY W (+ 198 X) (+ 144 Y) (+ 187 X) (+ 159 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 135 X) (+ 117 Y) (+ 190 X) (+ 153 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 114 X) (+ 105 Y) (+ 60 X) (+ 71 Y))
  (WINDOW-DRAW-LINE-XY W (+ 83 X) (+ 54 Y) (+ 201 X) (+ 54 Y))
  (WINDOW-DRAW-LINE-XY W (+ 201 X) (+ 54 Y) (+ 201 X) (+ 127 Y))
  (WINDOW-DRAW-LINE-XY W (+ 100 X) (+ 73 Y) (+ 105 X) (+ 66 Y))
  (WINDOW-DRAW-LINE-XY W (+ 105 X) (+ 66 Y) (+ 108 X) (+ 53 Y))
  (WINDOW-DRAW-LINE-XY W (+ 212 X) (+ 138 Y) (+ 240 X) (+ 138 Y))
  (WINDOW-DRAW-LINE-XY W (+ 201 X) (+ 149 Y) (+ 201 X) (+ 173 Y))
  (WINDOW-DRAW-LINE-XY W (+ 32 X) (+ 54 Y) (+ 60 X) (+ 54 Y))
  (WINDOW-DRAW-LINE-XY W (+ 70 X) (+ 21 Y) (+ 70 X) (+ 45 Y))
  (WINDOW-PRINTAT-XY W "theta" (+ 111 X) (+ 64 Y))
  (WINDOW-PRINTAT-XY W "deltax" (+ 124 X) (+ 38 Y))
  (WINDOW-PRINTAT-XY W "deltay" (+ 210 X) (+ 86 Y))
  (WINDOW-PRINTAT-XY W "p1" (+ 52 X) (+ 41 Y))
  (WINDOW-PRINTAT-XY W "p2" (+ 206 X) (+ 143 Y))
  (WINDOW-PRINTAT-XY W "p1x" (+ 62 X) Y)
  (WINDOW-PRINTAT-XY W "p1y" X (+ 50 Y))
  (WINDOW-PRINTAT-XY W "p2x" (+ 190 X) (+ 182 Y))
  (WINDOW-PRINTAT-XY W "p2y" (+ 251 X) (+ 134 Y))
  (WINDOW-PRINTAT-XY W "length" (+ 90 X) (+ 116 Y))
  (WINDOW-PRINTAT-XY W "slope" (+ 132 X) (+ 80 Y))
  (WINDOW-DRAW-LINE-XY W (+ 179 X) (+ 123 Y) (+ 187 X) (+ 116 Y))
  (WINDOW-DRAW-LINE-XY W (+ 191 X) (+ 115 Y) (+ 201 X) (+ 112 Y))
  (WINDOW-PRINTAT-XY W "phi" (+ 169 X) (+ 97 Y))
  (WINDOW-PRINTAT-XY W "size" (+ 205 X) (+ 40 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'LINE-SEGMENT 'PICMENU-SPEC)
      '(PICMENU-SPEC 272 192
           ((LENGTH (123 110)) (P1 (70 55)) (P2 (201 138))
            (THETA (105 66)) (DELTAX (142 54)) (DELTAY (201 90))
            (P1X (70 21)) (P1Y (32 54)) (P2X (201 173)) (P2Y (240 138))
            (SLOPE (134 95)) (PHI (187 116)) (SIZE (201 54)))
           T DRAW-LINE-SEGMENT 9X15)) 



; /v/ai/v0/novak/glisp/region.lsp    7 Oct 1992 16:59:12


(SETF (GET 'REGION 'DRAW-DESCR)
      '(DRAW-DESC REGION
           ((DRAW-BOX (53 38) (158 89) NIL 0)
            (DRAW-ARROW (53 38) (158 89) NIL 0)
            (DRAW-BUTTON (124 76) (4 4) SIZE 0)
            (DRAW-TEXT (132 68) (28 10) "size" 0)
            (DRAW-BUTTON (130 36) (4 4) WIDTH 0)
            (DRAW-TEXT (117 23) (35 10) "width" 0)
            (DRAW-BUTTON (51 76) (4 4) HEIGHT 0)
            (DRAW-TEXT (55 81) (42 10) "height" 0)
            (DRAW-BUTTON (209 36) (4 4) C2 0)
            (DRAW-TEXT (215 23) (14 14) "c2" 0)
            (DRAW-BUTTON (209 125) (4 4) C3 0)
            (DRAW-BUTTON (51 125) (4 4) C4 0)
            (DRAW-TEXT (35 130) (14 14) "c4" 0)
            (DRAW-LINE (37 38) (-32 0) NIL 0)
            (DRAW-LINE (227 127) (31 0) NIL 0)
            (DRAW-BUTTON (17 36) (4 4) BOTTOM 0)
            (DRAW-TEXT (0 43) (42 14) "bottom" 0)
            (DRAW-BUTTON (242 125) (4 4) TOP 0)
            (DRAW-LINE (212 136) (0 32) NIL 0)
            (DRAW-BUTTON (210 150) (4 4) RIGHT 0)
            (DRAW-TEXT (217 146) (35 14) "right" 0)
            (DRAW-TEXT (235 108) (21 14) "top" 0)
            (DRAW-TEXT (217 130) (14 14) "c3" 0)
            (DRAW-LINE (53 26) (0 -26) NIL 0)
            (DRAW-BUTTON (51 10) (4 4) LEFT 0)
            (DRAW-TEXT (59 6) (28 14) "left" 0)
            (DRAW-BUTTON (51 36) (4 4) START 0)
            (DRAW-TEXT (14 19) (35 14) "start" 0))
           (0 0) (258 168))) 

(DEFUN DRAW-REGION (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ X 53) (+ Y 38) 158 89)
  (WINDOW-DRAW-ARROW-XY W (+ X 53) (+ Y 38) (+ X 211) (+ Y 127))
  (WINDOW-PRINTAT-XY W "size" (+ X 132) (+ Y 68))
  (WINDOW-PRINTAT-XY W "width" (+ X 117) (+ Y 23))
  (WINDOW-PRINTAT-XY W "height" (+ X 55) (+ Y 81))
  (WINDOW-PRINTAT-XY W "c2" (+ X 215) (+ Y 23))
  (WINDOW-PRINTAT-XY W "c4" (+ X 35) (+ Y 130))
  (WINDOW-DRAW-LINE-XY W (+ X 37) (+ Y 38) (+ X 5) (+ Y 38))
  (WINDOW-DRAW-LINE-XY W (+ X 227) (+ Y 127) (+ X 258) (+ Y 127))
  (WINDOW-PRINTAT-XY W "bottom" (+ X 0) (+ Y 43))
  (WINDOW-DRAW-LINE-XY W (+ X 212) (+ Y 136) (+ X 212) (+ Y 168))
  (WINDOW-PRINTAT-XY W "right" (+ X 217) (+ Y 146))
  (WINDOW-PRINTAT-XY W "top" (+ X 235) (+ Y 108))
  (WINDOW-PRINTAT-XY W "c3" (+ X 217) (+ Y 130))
  (WINDOW-DRAW-LINE-XY W (+ X 53) (+ Y 26) (+ X 53) (+ Y 0))
  (WINDOW-PRINTAT-XY W "left" (+ X 59) (+ Y 6))
  (WINDOW-PRINTAT-XY W "start" (+ X 14) (+ Y 19))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'REGION 'PICMENU-SPEC)
      '(PICMENU-SPEC 258 168
           ((SIZE (126 78)) (WIDTH (132 38)) (HEIGHT (53 78))
            (C2 (211 38)) (C3 (211 127)) (C4 (53 127)) (BOTTOM (19 38))
            (TOP (244 127)) (RIGHT (212 152)) (LEFT (53 12))
            (START (53 38)))
           T DRAW-REGION 9X15)) 

; /v/ai/v0/novak/glisp/foo.del   23 Oct 1992 14:48:59


(SETF (GET 'RIGHT-TRIANGLE 'DRAW-DESCR)
      '(DRAW-DESC RIGHT-TRIANGLE
           ((DRAW-LINE (0 15) (144 0) NIL 0)
            (DRAW-LINE (144 15) (0 84) NIL 0)
            (DRAW-LINE (0 15) (144 84) NIL 0)
            (DRAW-BUTTON (76 13) (4 4) X 0)
            (DRAW-TEXT (76 0) (7 14) "x" 0)
            (DRAW-BUTTON (142 53) (4 4) Y 0)
            (DRAW-TEXT (151 49) (7 14) "y" 0)
            (DRAW-BUTTON (72 56) (4 4) R 0)
            (DRAW-TEXT (70 63) (7 14) "r" 0)
            (DRAW-LINE (31 32) (4 -6) NIL 0)
            (DRAW-TEXT (41 21) (35 14) "theta" 0)
            (DRAW-LINE (133 73) (11 -3) NIL 0)
            (DRAW-LINE (120 84) (8 -9) NIL 0)
            (DRAW-BUTTON (129 72) (4 4) PHI 0)
            (DRAW-TEXT (109 57) (21 14) "phi" 0)
            (DRAW-BOX (133 15) (11 11) NIL 0)
            (DRAW-BUTTON (34 22) (4 4) THETA 0)
            (DRAW-LINE (36 24) (2 -9) NIL 0))
           (0 0) (158 99))) 

(DEFUN DRAW-RIGHT-TRIANGLE (W X Y)
  (WINDOW-DRAW-LINE-XY W (+ X 0) (+ Y 15) (+ X 144) (+ Y 15))
  (WINDOW-DRAW-LINE-XY W (+ X 144) (+ Y 15) (+ X 144) (+ Y 99))
  (WINDOW-DRAW-LINE-XY W (+ X 0) (+ Y 15) (+ X 144) (+ Y 99))
  (WINDOW-PRINTAT-XY W "x" (+ X 76) (+ Y 0))
  (WINDOW-PRINTAT-XY W "y" (+ X 151) (+ Y 49))
  (WINDOW-PRINTAT-XY W "r" (+ X 70) (+ Y 63))
  (WINDOW-DRAW-LINE-XY W (+ X 31) (+ Y 32) (+ X 35) (+ Y 26))
  (WINDOW-PRINTAT-XY W "theta" (+ X 41) (+ Y 21))
  (WINDOW-DRAW-LINE-XY W (+ X 133) (+ Y 73) (+ X 144) (+ Y 70))
  (WINDOW-DRAW-LINE-XY W (+ X 120) (+ Y 84) (+ X 128) (+ Y 75))
  (WINDOW-PRINTAT-XY W "phi" (+ X 109) (+ Y 57))
  (WINDOW-DRAW-BOX-XY W (+ X 133) (+ Y 15) 11 11)
  (WINDOW-DRAW-LINE-XY W (+ X 36) (+ Y 24) (+ X 38) (+ Y 15))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'RIGHT-TRIANGLE 'PICMENU-SPEC)
      '(PICMENU-SPEC 158 99
           ((X (78 15)) (Y (144 55)) (R (74 58)) (PHI (131 74))
            (THETA (36 24)))
           T DRAW-RIGHT-TRIANGLE 9X15)) 

; glisp/draw.del   18 Feb 1999; 30 Jun 06

(SETF (GET 'UNIFORM-MOTION 'DRAW-DESCR)
      '(DRAW-DESC UNIFORM-MOTION
           ((DRAW-LINE (1 18) (150 0) NIL 0)
            (DRAW-ARROW (90 36) (34 0) NIL 0)
            (DRAW-BUTTON (100 34) (4 4) Velocity 0)
            (DRAW-TEXT (97 42) (7 14) "v" 0)
            (DRAW-BUTTON (57 16) (4 4) Distance 0)
            (DRAW-TEXT (47 24) (7 14) "d" 0)
            (DRAW-TEXT (148 0) (7 14) "t" 0)
            (DRAW-TEXT (0 2) (7 14) "0" 0)
            (DRAW-BUTTON (149 16) (4 4) time 0))
           (0 0) (155 56))) 

(DEFUN DRAW-UNIFORM-MOTION (W X Y)
  (WINDOW-DRAW-LINE-XY W (1+ X) (+ 18 Y) (+ 151 X) (+ 18 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 90 X) (+ 36 Y) (+ 124 X) (+ 36 Y))
  (WINDOW-PRINTAT-XY W "v" (+ 97 X) (+ 42 Y))
  (WINDOW-PRINTAT-XY W "d" (+ 47 X) (+ 24 Y))
  (WINDOW-PRINTAT-XY W "t" (+ 148 X) Y)
  (WINDOW-PRINTAT-XY W "0" X (+ 2 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'UNIFORM-MOTION 'PICMENU-SPEC)
      '(PICMENU-SPEC 155 56 ((Velocity (102 36)) (Distance (59 18))
			     (time (151 18)))
           T DRAW-UNIFORM-MOTION 9X15)) 


; /v/ai/v0/novak/glisp/foo.del   26 Oct 1992 16:26:39


(SETF (GET 'CENTRIFUGAL-FORCE 'DRAW-DESCR)
      '(DRAW-DESC CENTRIFUGAL-FORCE
           ((DRAW-DOT (80 80) (4 4) NIL 0)
            (DRAW-CIRCLE (0 0) (164 164) NIL 0)
            (DRAW-ARROW (82 82) (70 44) NIL 0)
            (DRAW-ARROW (152 126) (-43 66) NIL 0)
            (DRAW-BUTTON (113 100) (4 4) R 0)
            (DRAW-TEXT (113 83) (7 14) "r" 0)
            (DRAW-BUTTON (150 124) (4 4) M 0)
            (DRAW-TEXT (159 121) (7 14) "m" 0)
            (DRAW-BUTTON (122 167) (4 4) V 0)
            (DRAW-TEXT (132 165) (7 14) "v" 0)
            (DRAW-ARROW (145 137) (-53 -33) NIL 0)
            (DRAW-BUTTON (114 117) (4 4) F 0)
            (DRAW-TEXT (105 124) (7 14) "f" 0))
           (0 0) (166 192))) 

(DEFUN DRAW-CENTRIFUGAL-FORCE (W X Y)
  (WINDOW-DRAW-DOT-XY W (+ X 82) (+ Y 82))
  (WINDOW-DRAW-CIRCLE-XY W (+ X 82) (+ Y 82) 82)
  (WINDOW-DRAW-ARROW-XY W (+ X 82) (+ Y 82) (+ X 152) (+ Y 126))
  (WINDOW-DRAW-ARROW-XY W (+ X 152) (+ Y 126) (+ X 109) (+ Y 192))
  (WINDOW-PRINTAT-XY W "r" (+ X 113) (+ Y 83))
  (WINDOW-PRINTAT-XY W "m" (+ X 159) (+ Y 121))
  (WINDOW-PRINTAT-XY W "v" (+ X 132) (+ Y 165))
  (WINDOW-DRAW-ARROW-XY W (+ X 145) (+ Y 137) (+ X 92) (+ Y 104))
  (WINDOW-PRINTAT-XY W "f" (+ X 105) (+ Y 124))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'CENTRIFUGAL-FORCE 'PICMENU-SPEC)
      '(PICMENU-SPEC 166 192
           ((R (115 102)) (M (152 126)) (V (124 169)) (F (116 119))) T
           DRAW-CENTRIFUGAL-FORCE 9X15)) 

(SETF (GET 'GRAVITATION 'DRAW-DESCR)
      '(DRAW-DESC GRAVITATION
           ((DRAW-LINE (22 176) (85 -171) NIL 0)
            (DRAW-BUTTON (20 174) (4 4) M1 0)
            (DRAW-TEXT (29 171) (14 14) "m1" 0)
            (DRAW-BUTTON (105 3) (4 4) M2 0)
            (DRAW-TEXT (113 0) (14 14) "m2" 0)
            (DRAW-BUTTON (60 94) (4 4) radius 0)
            (DRAW-TEXT (71 93) (7 14) "r" 0)
            (DRAW-ARROW (0 164) (31 -61) NIL 0)
            (DRAW-BUTTON (15 128) (4 4) force 0)
            (DRAW-TEXT (21 133) (7 14) "f" 0))
           (0 0) (127 185))) 

(DEFUN DRAW-GRAVITATION (W X Y)
  (WINDOW-DRAW-LINE-XY W (+ X 22) (+ Y 176) (+ X 107) (+ Y 5))
  (WINDOW-PRINTAT-XY W "m1" (+ X 29) (+ Y 171))
  (WINDOW-PRINTAT-XY W "m2" (+ X 113) (+ Y 0))
  (WINDOW-PRINTAT-XY W "r" (+ X 71) (+ Y 93))
  (WINDOW-DRAW-ARROW-XY W (+ X 0) (+ Y 164) (+ X 31) (+ Y 103))
  (WINDOW-PRINTAT-XY W "f" (+ X 21) (+ Y 133))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'GRAVITATION 'PICMENU-SPEC)
      '(PICMENU-SPEC 127 185
           ((M1 (22 176)) (M2 (107 5)) (radius (62 96)) (force (17 130))) T
           DRAW-GRAVITATION 9X15)) 

; /v/ai/v0/novak/glisp/foo.del   11 Nov 1992 14:24:31

(SETF (GET 'MERCATOR 'DRAW-DESCR)
      '(DRAW-DESC MERCATOR
           ((DRAW-DOT (101 101) (4 4) NIL 0)
            (DRAW-CIRCLE (0 0) (206 206) NIL 0)
            (DRAW-ELLIPSE (61 0) (84 206) NIL 0)
            (DRAW-ERASE (108 123) (15 14) NIL 0)
            (DRAW-ELLIPSE (0 88) (206 30) NIL 0)
            (DRAW-ERASE (8 105) (48 18) NIL 0)
            (DRAW-ERASE (69 108) (125 15) NIL 0)
            (DRAW-ERASE (119 15) (30 69) NIL 0)
            (DRAW-ERASE (117 175) (16 23) NIL 0)
            (DRAW-ERASE (128 93) (22 85) NIL 0)
            (DRAW-ARROW (103 103) (-84 -58) NIL 0)
            (DRAW-ARROW (116 88) (0 49) NIL 0)
            (DRAW-DOT (114 135) (4 4) NIL 0)
            (DRAW-ARROW (64 137) (52 0) NIL 0)
            (DRAW-ERASE (64 116) (13 3) NIL 0)
            (DRAW-ERASE (48 115) (12 5) NIL 0)
            (DRAW-ERASE (143 82) (3 12) NIL 0)
            (DRAW-ERASE (58 115) (8 4) NIL 0)
            (DRAW-BUTTON (44 61) (4 4) R 0)
            (DRAW-TEXT (49 45) (7 14) "r" 0)
            (DRAW-BUTTON (114 107) (4 4) LATITUDE 0)
            (DRAW-TEXT (122 103) (21 14) "lat" 0)
            (DRAW-BUTTON (87 135) (4 4) LONGITUDE 0)
            (DRAW-TEXT (75 144) (28 14) "long" 0)
            (DRAW-TEXT (120 141) (7 14) "P" 0)
            (DRAW-ERASE (60 67) (5 19) NIL 0)
            (DRAW-ERASE (73 85) (16 7) NIL 0)
            (DRAW-LINE (103 103) (-50 -34) NIL 0)
            (DRAW-LINE (62 120) (-1 -7) NIL 0)
            (DRAW-LINE (140 89) (11 0) NIL 0))
           (0 0) (206 206))) 

(DEFUN DRAW-MERCATOR (W X Y)
  (WINDOW-DRAW-DOT-XY W (+ X 103) (+ Y 103))
  (WINDOW-DRAW-CIRCLE-XY W (+ X 103) (+ Y 103) 103)
  (WINDOW-DRAW-ELLIPSE-XY W (+ X 103) (+ Y 103) 42 103)
  (WINDOW-ERASE-AREA-XY W (+ X 108) (+ Y 123) 15 14)
  (WINDOW-DRAW-ELLIPSE-XY W (+ X 103) (+ Y 103) 103 15)
  (WINDOW-ERASE-AREA-XY W (+ X 8) (+ Y 105) 48 18)
  (WINDOW-ERASE-AREA-XY W (+ X 69) (+ Y 108) 125 15)
  (WINDOW-ERASE-AREA-XY W (+ X 119) (+ Y 15) 30 69)
  (WINDOW-ERASE-AREA-XY W (+ X 117) (+ Y 175) 16 23)
  (WINDOW-ERASE-AREA-XY W (+ X 128) (+ Y 93) 22 85)
  (WINDOW-DRAW-ARROW-XY W (+ X 103) (+ Y 103) (+ X 19) (+ Y 45))
  (WINDOW-DRAW-ARROW-XY W (+ X 116) (+ Y 88) (+ X 116) (+ Y 137))
  (WINDOW-DRAW-DOT-XY W (+ X 116) (+ Y 137))
  (WINDOW-DRAW-ARROW-XY W (+ X 64) (+ Y 137) (+ X 116) (+ Y 137))
  (WINDOW-ERASE-AREA-XY W (+ X 64) (+ Y 116) 13 3)
  (WINDOW-ERASE-AREA-XY W (+ X 48) (+ Y 115) 12 5)
  (WINDOW-ERASE-AREA-XY W (+ X 143) (+ Y 82) 3 12)
  (WINDOW-ERASE-AREA-XY W (+ X 58) (+ Y 115) 8 4)
  (WINDOW-PRINTAT-XY W "r" (+ X 49) (+ Y 45))
  (WINDOW-PRINTAT-XY W "lat" (+ X 122) (+ Y 103))
  (WINDOW-PRINTAT-XY W "long" (+ X 75) (+ Y 144))
  (WINDOW-PRINTAT-XY W "P" (+ X 120) (+ Y 141))
  (WINDOW-ERASE-AREA-XY W (+ X 60) (+ Y 67) 5 19)
  (WINDOW-ERASE-AREA-XY W (+ X 73) (+ Y 85) 16 7)
  (WINDOW-DRAW-LINE-XY W (+ X 103) (+ Y 103) (+ X 53) (+ Y 69))
  (WINDOW-DRAW-LINE-XY W (+ X 62) (+ Y 120) (+ X 61) (+ Y 113))
  (WINDOW-DRAW-LINE-XY W (+ X 140) (+ Y 89) (+ X 151) (+ Y 89))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'MERCATOR 'PICMENU-SPEC)
      '(PICMENU-SPEC 206 206
           ((R (46 63)) (LATITUDE (116 109)) (LONGITUDE (89 137))) T
           DRAW-MERCATOR 9X15))

; /v/ai/v0/novak/glisp/foo.del   19 Nov 1992 14:27:14

(SETF (GET 'VECTOR 'DRAW-DESCR)
      '(DRAW-DESC VECTOR
           ((DRAW-DOT (0 16) (4 4) NIL 0)
            (DRAW-ARROW (2 18) (125 82) NIL 0)
            (DRAW-LINE (16 18) (110 0) NIL 0)
            (DRAW-LINE (126 18) (0 73) NIL 0)
            (DRAW-LINE (1 30) (0 40) NIL 0)
            (DRAW-LINE (31 36) (5 -6) NIL 0)
            (DRAW-LINE (38 25) (2 -7) NIL 0)
            (DRAW-LINE (18 43) (9 -10) NIL 0)
            (DRAW-LINE (2 46) (10 -1) NIL 0)
            (DRAW-TEXT (40 24) (35 14) "theta" 0)
            (DRAW-BUTTON (12 42) (4 4) PHI 0)
            (DRAW-TEXT (6 49) (21 14) "phi" 0)
            (DRAW-BUTTON (67 16) (4 4) X 0)
            (DRAW-TEXT (66 0) (7 14) "x" 0)
            (DRAW-BUTTON (124 53) (4 4) Y 0)
            (DRAW-TEXT (132 49) (7 14) "y" 0)
            (DRAW-TEXT (50 60) (7 14) "r" 0)
            (DRAW-BUTTON (72 62) (4 4) SLOPE 0)
            (DRAW-TEXT (78 53) (35 14) "slope" 0)
            (DRAW-BUTTON (58 54) (4 4) MAGNITUDE 0)
            (DRAW-BUTTON (34 26) (4 4) ANGLE 0))
           (0 0) (139 100))) 

(DEFUN DRAW-VECTOR (W X Y)
  (WINDOW-DRAW-DOT-XY W (+ X 2) (+ Y 18))
  (WINDOW-DRAW-ARROW-XY W (+ X 2) (+ Y 18) (+ X 127) (+ Y 100))
  (WINDOW-DRAW-LINE-XY W (+ X 16) (+ Y 18) (+ X 126) (+ Y 18))
  (WINDOW-DRAW-LINE-XY W (+ X 126) (+ Y 18) (+ X 126) (+ Y 91))
  (WINDOW-DRAW-LINE-XY W (+ X 1) (+ Y 30) (+ X 1) (+ Y 70))
  (WINDOW-DRAW-LINE-XY W (+ X 31) (+ Y 36) (+ X 36) (+ Y 30))
  (WINDOW-DRAW-LINE-XY W (+ X 38) (+ Y 25) (+ X 40) (+ Y 18))
  (WINDOW-DRAW-LINE-XY W (+ X 18) (+ Y 43) (+ X 27) (+ Y 33))
  (WINDOW-DRAW-LINE-XY W (+ X 2) (+ Y 46) (+ X 12) (+ Y 45))
  (WINDOW-PRINTAT-XY W "theta" (+ X 40) (+ Y 24))
  (WINDOW-PRINTAT-XY W "phi" (+ X 6) (+ Y 49))
  (WINDOW-PRINTAT-XY W "x" (+ X 66) (+ Y 0))
  (WINDOW-PRINTAT-XY W "y" (+ X 132) (+ Y 49))
  (WINDOW-PRINTAT-XY W "r" (+ X 50) (+ Y 60))
  (WINDOW-PRINTAT-XY W "slope" (+ X 78) (+ Y 53))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'VECTOR 'PICMENU-SPEC)
      '(PICMENU-SPEC 139 100
           ((PHI (14 44)) (X (69 18)) (Y (126 55)) (SLOPE (74 64))
            (MAGNITUDE (60 56)) (ANGLE (36 28)))
           T DRAW-VECTOR 9X15))

(SETF (GET 'NVECTOR 'PICMENU-SPEC) (GET 'VECTOR 'PICMENU-SPEC))
(SETF (GET 'RVECTOR 'PICMENU-SPEC) (GET 'VECTOR 'PICMENU-SPEC))


; /v/ai/v0/novak/glisp/foo.del   16 Dec 1992; 30 Jun 06

(SETF (GET 'UNIFORM-ACCELERATION 'DRAW-DESCR)
      '(DRAW-DESC UNIFORM-ACCELERATION
           ((DRAW-LINE (3 23) (154 0) NIL 0)
            (DRAW-BUTTON (44 21) (4 4) Distance 0)
            (DRAW-TEXT (43 31) (7 14) "d" 0)
            (DRAW-TEXT (0 2) (7 14) "0" 0)
            (DRAW-BUTTON (155 21) (4 4) TIME 0)
            (DRAW-TEXT (154 0) (7 14) "t" 0)
            (DRAW-ARROW (67 38) (43 0) NIL 0)
            (DRAW-BUTTON (80 36) (4 4) Acceleration 0)
            (DRAW-TEXT (78 44) (7 14) "a" 0)
            (DRAW-ARROW (135 38) (38 0) NIL 0)
            (DRAW-BUTTON (150 36) (4 4) Velocity 0)
            (DRAW-TEXT (148 45) (7 14) "v" 0))
           (0 0) (173 59))) 

(DEFUN DRAW-UNIFORM-ACCELERATION (W X Y)
  (WINDOW-DRAW-LINE-XY W (+ X 3) (+ Y 23) (+ X 157) (+ Y 23))
  (WINDOW-PRINTAT-XY W "d" (+ X 43) (+ Y 31))
  (WINDOW-PRINTAT-XY W "0" (+ X 0) (+ Y 2))
  (WINDOW-PRINTAT-XY W "t" (+ X 154) (+ Y 0))
  (WINDOW-DRAW-ARROW-XY W (+ X 67) (+ Y 38) (+ X 110) (+ Y 38))
  (WINDOW-PRINTAT-XY W "a" (+ X 78) (+ Y 44))
  (WINDOW-DRAW-ARROW-XY W (+ X 135) (+ Y 38) (+ X 173) (+ Y 38))
  (WINDOW-PRINTAT-XY W "v" (+ X 148) (+ Y 45))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'UNIFORM-ACCELERATION 'PICMENU-SPEC)
      '(PICMENU-SPEC 173 59
           ((Distance (46 23)) (TIME (157 23)) (Acceleration (82 38))
	    (Velocity (152 38))) T
           DRAW-UNIFORM-ACCELERATION 9X15)) 

; /v/ai/v0/novak/glisp/foo.del   16 Dec 1992 16: 9:27

(SETF (GET 'FALLING 'DRAW-DESCR)
      '(DRAW-DESC FALLING
           ((DRAW-LINE (15 127) (0 -118) NIL 0)
            (DRAW-BUTTON (13 68) (4 4) H 0)
            (DRAW-TEXT (24 63) (7 14) "h" 0)
            (DRAW-TEXT (4 121) (7 14) "0" 0)
            (DRAW-BUTTON (13 7) (4 4) TIME 0)
            (DRAW-TEXT (4 4) (7 14) "t" 0)                ; 5/30/02
            (DRAW-ARROW (43 36) (0 -29) NIL 0)
            (DRAW-BUTTON (41 24) (4 4) V 0)               ; 3/22/92
            (DRAW-TEXT (30 19) (7 14) "v" 0))
           (0 0) (45 135))) 

(DEFUN DRAW-FALLING (W X Y)
  (WINDOW-DRAW-LINE-XY W (+ X 15) (+ Y 127) (+ X 15) (+ Y 9))
  (WINDOW-PRINTAT-XY W "h" (+ X 24) (+ Y 63))
  (WINDOW-PRINTAT-XY W "0" (+ X 2) (+ Y 121))
  (WINDOW-PRINTAT-XY W "t" (+ X 0) (+ Y 0))
  (WINDOW-DRAW-ARROW-XY W (+ X 43) (+ Y 36) (+ X 43) (+ Y 7))
  (WINDOW-PRINTAT-XY W "v" (+ X 30) (+ Y 19))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'FALLING 'PICMENU-SPEC)
      '(PICMENU-SPEC 45 135 ((H (15 70)) (TIME (15 9)) (V (43 26))) T
           DRAW-FALLING 9X15)) 

; /v/ai/v0/novak/glisp/foo.del   20 Dec 1992 18: 4:55

(SETF (GET 'GRAVITY-KINETIC 'DRAW-DESCR)
      '(DRAW-DESC GRAVITY-KINETIC
           ((DRAW-BUTTON (13 49) (4 4) MASS 0)
            (DRAW-TEXT (12 59) (7 14) "m" 0)
            (DRAW-ARROW (15 51) (55 0) NIL 0)
            (DRAW-BUTTON (42 49) (4 4) velocity 0)
            (DRAW-TEXT (39 59) (7 14) "v" 0)
            (DRAW-ARROW (15 51) (0 -51) NIL 0)
            (DRAW-LINE (3 0) (28 0) NIL 0)
            (DRAW-BUTTON (13 25) (4 4) height 0)
            (DRAW-TEXT (0 22) (7 14) "h" 0)
            (DRAW-BUTTON (47 18) (4 4) ENERGY 0)
            (DRAW-TEXT (46 0) (7 14) "E" 0))
           (0 0) (70 73))) 

(DEFUN DRAW-GRAVITY-KINETIC (W X Y)
  (WINDOW-PRINTAT-XY W "m" (+ X 12) (+ Y 59))
  (WINDOW-DRAW-ARROW-XY W (+ X 15) (+ Y 51) (+ X 70) (+ Y 51))
  (WINDOW-PRINTAT-XY W "v" (+ X 39) (+ Y 59))
  (WINDOW-DRAW-ARROW-XY W (+ X 15) (+ Y 51) (+ X 15) (+ Y 0))
  (WINDOW-DRAW-LINE-XY W (+ X 3) (+ Y 0) (+ X 31) (+ Y 0))
  (WINDOW-PRINTAT-XY W "h" (+ X 0) (+ Y 22))
  (WINDOW-PRINTAT-XY W "E" (+ X 46) (+ Y 0))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'GRAVITY-KINETIC 'PICMENU-SPEC)
      '(PICMENU-SPEC 70 73
           ((MASS (15 51)) (velocity (44 51)) (height (15 27))
	    (ENERGY (49 20))) T
           DRAW-GRAVITY-KINETIC 9X15)) 

; /v/ai/v0/novak/glisp/foo.del    8 Apr 1993 13:55:44

(SETF (GET 'WEIGHT 'DRAW-DESCR)
      '(DRAW-DESC WEIGHT
           ((DRAW-ARROW (2 48) (0 -48) NIL 0)
            (DRAW-BUTTON (0 46) (4 4) MASS 0)
            (DRAW-BUTTON (0 24) (4 4) WEIGHT 0)
            (DRAW-TEXT (9 42) (7 14) "m" 0)
            (DRAW-TEXT (10 19) (7 14) "w" 0))
           (0 0) (17 56))) 

(DEFUN DRAW-WEIGHT (W X Y)
  (WINDOW-DRAW-ARROW-XY W (+ X 2) (+ Y 48) (+ X 2) (+ Y 0))
  (WINDOW-PRINTAT-XY W "m" (+ X 9) (+ Y 42))
  (WINDOW-PRINTAT-XY W "w" (+ X 10) (+ Y 19))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'WEIGHT 'PICMENU-SPEC)
      '(PICMENU-SPEC 17 56 ((MASS (2 48)) (WEIGHT (2 26))) T
           DRAW-WEIGHT 9X15)) 

; /v/ai/v0/novak/glisp/foo.del   21 May 1993 15:37:36

(SETF (GET 'SPHERE 'DRAW-DESCR)
      '(DRAW-DESC SPHERE
           ((DRAW-DOT (80 80) (4 4) NIL 0)
            (DRAW-CIRCLE (0 0) (164 164) NIL 0)
            (DRAW-ELLIPSE (0 59) (164 46) NIL 0)
            (DRAW-ARROW (82 82) (-53 -17) NIL 0)
            (DRAW-BUTTON (57 72) (4 4) RADIUS 0)
            (DRAW-TEXT (63 61) (7 14) "r" 0)
            (DRAW-ARROW (82 82) (-82 0) NIL 0)
            (DRAW-ARROW (82 82) (82 0) NIL 0)
            (DRAW-BUTTON (115 80) (4 4) DIAMETER 0)
            (DRAW-TEXT (114 65) (7 14) "d" 0)
            (DRAW-BUTTON (90 57) (4 4) CIRCUMFERENCE 0)
            (DRAW-TEXT (89 41) (7 14) "c" 0)
            (DRAW-BUTTON (110 140) (4 4) AREA 0)
            (DRAW-TEXT (102 126) (28 14) "area" 0)
            (DRAW-BUTTON (63 122) (4 4) VOLUME 0)
            (DRAW-TEXT (46 108) (42 14) "volume" 0))
           (0 0) (164 164))) 

(DEFUN DRAW-SPHERE (W X Y)
  (WINDOW-DRAW-DOT-XY W (+ X 82) (+ Y 82))
  (WINDOW-DRAW-CIRCLE-XY W (+ X 82) (+ Y 82) 82)
  (WINDOW-DRAW-ELLIPSE-XY W (+ X 82) (+ Y 82) 82 23)
  (WINDOW-DRAW-ARROW-XY W (+ X 82) (+ Y 82) (+ X 29) (+ Y 65))
  (WINDOW-PRINTAT-XY W "r" (+ X 63) (+ Y 61))
  (WINDOW-DRAW-ARROW-XY W (+ X 82) (+ Y 82) (+ X 0) (+ Y 82))
  (WINDOW-DRAW-ARROW-XY W (+ X 82) (+ Y 82) (+ X 164) (+ Y 82))
  (WINDOW-PRINTAT-XY W "d" (+ X 114) (+ Y 65))
  (WINDOW-PRINTAT-XY W "c" (+ X 89) (+ Y 41))
  (WINDOW-PRINTAT-XY W "area" (+ X 102) (+ Y 126))
  (WINDOW-PRINTAT-XY W "volume" (+ X 46) (+ Y 108))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'SPHERE 'PICMENU-SPEC)
      '(PICMENU-SPEC 164 164
           ((RADIUS (59 74)) (DIAMETER (117 82))
            (CIRCUMFERENCE (92 59)) (AREA (112 142)) (VOLUME (65 124)))
           T DRAW-SPHERE 9X15)) 

; glisp/foo.del   17 Aug 1993 16:10: 0 ; 15 Apr 08

(SETF (GET 'KINETIC-energy 'DRAW-DESCR)
      '(DRAW-DESC KINETIC-energy
           ((DRAW-CIRCLE (0 28) (18 18) NIL 0)
            (DRAW-BUTTON (7 35) (4 4) MASS 0)
            (DRAW-ARROW (9 37) (64 0) NIL 0)
            (DRAW-BUTTON (37 35) (4 4) VELOCITY 0)
            (DRAW-TEXT (5 48) (7 14) "m" 0)
            (DRAW-TEXT (35 42) (7 14) "v" 0)
            (DRAW-BUTTON (25 16) (4 4) ENERGY 0)
            (DRAW-TEXT (24 0) (7 14) "E" 0))
           (0 0) (73 62))) 

(DEFUN DRAW-KINETIC-energy (W X Y)
  (WINDOW-DRAW-CIRCLE-XY W (+ X 9) (+ Y 37) 9)
  (WINDOW-DRAW-ARROW-XY W (+ X 9) (+ Y 37) (+ X 73) (+ Y 37))
  (WINDOW-PRINTAT-XY W "m" (+ X 5) (+ Y 48))
  (WINDOW-PRINTAT-XY W "v" (+ X 35) (+ Y 42))
  (WINDOW-PRINTAT-XY W "E" (+ X 24) (+ Y 0))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'KINETIC-energy 'PICMENU-SPEC)
      '(PICMENU-SPEC 73 62 ((MASS (9 37)) (VELOCITY (39 37)) (ENERGY (27 18)))
           T DRAW-KINETIC-energy 9X15))

; glisp/draw.del   20 Apr 1994 14: 1:33

(SETF (GET 'FRICTION 'DRAW-DESCR)
      '(DRAW-DESC FRICTION
           ((DRAW-LINE (0 0) (124 0) NIL 0)
            (DRAW-BOX (45 2) (31 24) NIL 0)
            (DRAW-ARROW (60 54) (0 -28) NIL 0)
            (DRAW-ARROW (114 22) (-38 0) NIL 0)
            (DRAW-BUTTON (58 44) (4 4) normal-force 0)
            (DRAW-TEXT (46 39) (7 14) "n" 0)
            (DRAW-BUTTON (101 20) (4 4) friction-force 0)
            (DRAW-TEXT (100 4) (7 14) "f" 0)
            (DRAW-ARROW (17 15) (22 -10) NIL 0)
            (DRAW-BUTTON (15 13) (4 4) MU 0)
            (DRAW-TEXT (11 20) (14 14) "mu" 0))
           (0 0) (124 54))) 

(DEFUN DRAW-FRICTION (W X Y)
  (WINDOW-DRAW-LINE-XY W X Y (+ 124 X) Y)
  (WINDOW-DRAW-BOX-XY W (+ 45 X) (+ 2 Y) 31 24)
  (WINDOW-DRAW-ARROW-XY W (+ 60 X) (+ 54 Y) (+ 60 X) (+ 26 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 114 X) (+ 22 Y) (+ 76 X) (+ 22 Y))
  (WINDOW-PRINTAT-XY W "n" (+ 46 X) (+ 39 Y))
  (WINDOW-PRINTAT-XY W "f" (+ 100 X) (+ 4 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 17 X) (+ 15 Y) (+ 39 X) (+ 5 Y))
  (WINDOW-PRINTAT-XY W "mu" (+ 11 X) (+ 20 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'FRICTION 'PICMENU-SPEC)
      '(PICMENU-SPEC 124 54 ((normal-force (60 46)) (friction-force (103 22))
			     (MU (17 15))) T
           DRAW-FRICTION 9X15)) 


(SETF (GET 'FILTER 'DRAW-DESCR)
      '(DRAW-DESC FILTER
           ((DRAW-ELLIPSE (32 37) (64 22) NIL 0)
            (DRAW-LINE (32 48) (28 -30) NIL 0)
            (DRAW-LINE (96 48) (-28 -31) NIL 0)
            (DRAW-LINE (62 7) (5 0) NIL 0)
            (DRAW-LINE (60 18) (2 -11) NIL 0)
            (DRAW-LINE (68 17) (-1 -10) NIL 0)
            (DRAW-ARROW (2 48) (30 0) NIL 0)
            (DRAW-ARROW (64 93) (0 -45) NIL 0)
            (DRAW-BUTTON (62 77) (4 4) DATA 0)
            (DRAW-BUTTON (0 46) (4 4) PREDICATE 0)
            (DRAW-BUTTON (63 0) (4 4) OUTPUT 0))
           (0 0) (96 93))) 

(DEFUN DRAW-FILTER (W X Y)
  (WINDOW-DRAW-ELLIPSE-XY W (+ 64 X) (+ 48 Y) 32 11)
  (WINDOW-DRAW-LINE-XY W (+ 32 X) (+ 48 Y) (+ 60 X) (+ 18 Y))
  (WINDOW-DRAW-LINE-XY W (+ 96 X) (+ 48 Y) (+ 68 X) (+ 17 Y))
  (WINDOW-DRAW-LINE-XY W (+ 62 X) (+ 7 Y) (+ 67 X) (+ 7 Y))
  (WINDOW-DRAW-LINE-XY W (+ 60 X) (+ 18 Y) (+ 62 X) (+ 7 Y))
  (WINDOW-DRAW-LINE-XY W (+ 68 X) (+ 17 Y) (+ 67 X) (+ 7 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 2 X) (+ 48 Y) (+ 32 X) (+ 48 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 64 X) (+ 93 Y) (+ 64 X) (+ 48 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'FILTER 'PICMENU-SPEC)
      '(PICMENU-SPEC 96 93
           ((DATA (64 79)) (PREDICATE (2 48)) (OUTPUT (65 2))) T
           DRAW-FILTER 9X15)) 

; glisp/draw.del    9 Feb 1999 17:39:16


(SETF (GET 'MAP-SCALE 'DRAW-DESCR)
      '(DRAW-DESC MAP-SCALE
           ((DRAW-LINE (60 16) (262 0) NIL 0)
            (DRAW-LINE (52 21) (0 248) NIL 0)
            (DRAW-LINE (117 56) (196 0) NIL 0)
            (DRAW-LINE (112 64) (0 196) NIL 0)
            (DRAW-BUTTON (58 14) (4 4) XMIN 0)
            (DRAW-TEXT (46 0) (28 14) "xmin" 0)
            (DRAW-BUTTON (320 14) (4 4) XMAX 0)
            (DRAW-TEXT (309 1) (28 14) "xmax" 0)
            (DRAW-BUTTON (154 14) (4 4) WIDTH 0)
            (DRAW-TEXT (141 1) (35 14) "width" 0)
            (DRAW-BUTTON (115 54) (4 4) GOALXMIN 0)
            (DRAW-TEXT (104 41) (28 14) "xmin" 0)
            (DRAW-BUTTON (311 54) (4 4) GOALXMAX 0)
            (DRAW-TEXT (301 42) (28 14) "xmax" 0)
            (DRAW-BUTTON (184 54) (4 4) GOALWIDTH 0)
            (DRAW-TEXT (170 41) (35 14) "width" 0)
            (DRAW-BUTTON (236 14) (4 4) X 0)
            (DRAW-TEXT (235 2) (7 14) "x" 0)
            (DRAW-BUTTON (243 54) (4 4) GOALX 0)
            (DRAW-TEXT (239 66) (14 14) "x'" 0)
            (DRAW-ARROW (239 22) (5 30) NIL 0)
            (DRAW-BUTTON (50 19) (4 4) YMIN 0)
            (DRAW-TEXT (14 18) (28 14) "ymin" 0)
            (DRAW-BUTTON (50 267) (4 4) YMAX 0)
            (DRAW-TEXT (13 266) (28 14) "ymax" 0)
            (DRAW-BUTTON (50 101) (4 4) HEIGHT 0)
            (DRAW-TEXT (0 99) (42 14) "height" 0)
            (DRAW-BUTTON (110 62) (4 4) GOALYMIN 0)
            (DRAW-TEXT (77 62) (28 14) "ymin" 0)
            (DRAW-BUTTON (110 258) (4 4) GOALYMAX 0)
            (DRAW-TEXT (76 257) (28 14) "ymax" 0)
            (DRAW-BUTTON (110 125) (4 4) GOALHEIGHT 0)
            (DRAW-TEXT (63 124) (42 14) "height" 0)
            (DRAW-BUTTON (50 192) (4 4) Y 0)
            (DRAW-TEXT (39 191) (7 14) "y" 0)
            (DRAW-BUTTON (110 202) (4 4) GOALY 0)
            (DRAW-TEXT (119 202) (14 14) "y'" 0)
            (DRAW-ARROW (60 196) (44 8) NIL 0)
            (DRAW-BUTTON (91 29) (4 4) XBASE 0)
            (DRAW-TEXT (99 28) (35 14) "xbase" 0)
            (DRAW-TEXT (68 48) (35 14) "ybase" 0)
            (DRAW-BUTTON (72 39) (4 4) YBASE 0)
            (DRAW-BUTTON (267 30) (4 4) XRATIO 0)
            (DRAW-TEXT (276 30) (42 14) "xratio" 0)
            (DRAW-ARROW (268 25) (5 24) NIL 0)
            (DRAW-BUTTON (80 169) (4 4) YRATIO 0)
            (DRAW-TEXT (62 153) (42 14) "yratio" 0)
            (DRAW-ARROW (67 167) (33 8) NIL 0)
            (DRAW-TEXT (157 122) (112 14) "Goal Coordinates" 0))
           (0 0) (337 280))) 

(DEFUN DRAW-MAP-SCALE (W X Y)
  (WINDOW-DRAW-LINE-XY W (+ 60 X) (+ 16 Y) (+ 322 X) (+ 16 Y))
  (WINDOW-DRAW-LINE-XY W (+ 52 X) (+ 21 Y) (+ 52 X) (+ 269 Y))
  (WINDOW-DRAW-LINE-XY W (+ 117 X) (+ 56 Y) (+ 313 X) (+ 56 Y))
  (WINDOW-DRAW-LINE-XY W (+ 112 X) (+ 64 Y) (+ 112 X) (+ 260 Y))
  (WINDOW-PRINTAT-XY W "xmin" (+ 46 X) Y)
  (WINDOW-PRINTAT-XY W "xmax" (+ 309 X) (1+ Y))
  (WINDOW-PRINTAT-XY W "width" (+ 141 X) (1+ Y))
  (WINDOW-PRINTAT-XY W "xmin" (+ 104 X) (+ 41 Y))
  (WINDOW-PRINTAT-XY W "xmax" (+ 301 X) (+ 42 Y))
  (WINDOW-PRINTAT-XY W "width" (+ 170 X) (+ 41 Y))
  (WINDOW-PRINTAT-XY W "x" (+ 235 X) (+ 2 Y))
  (WINDOW-PRINTAT-XY W "x'" (+ 239 X) (+ 66 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 239 X) (+ 22 Y) (+ 244 X) (+ 52 Y))
  (WINDOW-PRINTAT-XY W "ymin" (+ 14 X) (+ 18 Y))
  (WINDOW-PRINTAT-XY W "ymax" (+ 13 X) (+ 266 Y))
  (WINDOW-PRINTAT-XY W "height" X (+ 99 Y))
  (WINDOW-PRINTAT-XY W "ymin" (+ 77 X) (+ 62 Y))
  (WINDOW-PRINTAT-XY W "ymax" (+ 76 X) (+ 257 Y))
  (WINDOW-PRINTAT-XY W "height" (+ 63 X) (+ 124 Y))
  (WINDOW-PRINTAT-XY W "y" (+ 39 X) (+ 191 Y))
  (WINDOW-PRINTAT-XY W "y'" (+ 119 X) (+ 202 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 60 X) (+ 196 Y) (+ 104 X) (+ 204 Y))
  (WINDOW-PRINTAT-XY W "xbase" (+ 99 X) (+ 28 Y))
  (WINDOW-PRINTAT-XY W "ybase" (+ 68 X) (+ 48 Y))
  (WINDOW-PRINTAT-XY W "xratio" (+ 276 X) (+ 30 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 268 X) (+ 25 Y) (+ 273 X) (+ 49 Y))
  (WINDOW-PRINTAT-XY W "yratio" (+ 62 X) (+ 153 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 67 X) (+ 167 Y) (+ 100 X) (+ 175 Y))
  (WINDOW-PRINTAT-XY W "Goal Coordinates" (+ 157 X) (+ 122 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'MAP-SCALE 'PICMENU-SPEC)
      '(PICMENU-SPEC 337 280
           ((XMIN (60 16)) (XMAX (322 16)) (WIDTH (156 16))
            (GOALXMIN (117 56)) (GOALXMAX (313 56))
            (GOALWIDTH (186 56)) (X (238 16)) (GOALX (245 56))
            (YMIN (52 21)) (YMAX (52 269)) (HEIGHT (52 103))
            (GOALYMIN (112 64)) (GOALYMAX (112 260))
            (GOALHEIGHT (112 127)) (Y (52 194)) (GOALY (112 204))
            (XBASE (93 31)) (YBASE (74 41)) (XRATIO (269 32))
            (YRATIO (82 171)))
           T DRAW-MAP-SCALE 9X15)) 

; glisp/draw.del    9 Feb 1999 16:51:20


(SETF (GET 'LINEAR-SCALE 'DRAW-DESCR)
      '(DRAW-DESC LINEAR-SCALE
           ((DRAW-LINE (22 16) (192 0) NIL 0)
            (DRAW-LINE (47 71) (268 0) NIL 0)
            (DRAW-BUTTON (20 14) (4 4) XMIN 0)
            (DRAW-TEXT (6 1) (35 14) "x min" 0)
            (DRAW-BUTTON (212 14) (4 4) XMAX 0)
            (DRAW-TEXT (198 1) (35 14) "x max" 0)
            (DRAW-BUTTON (45 69) (4 4) GOALMIN 0)
            (DRAW-TEXT (20 82) (56 14) "goal min" 0)
            (DRAW-BUTTON (313 69) (4 4) GOALMAX 0)
            (DRAW-TEXT (287 82) (56 14) "goal max" 0)
            (DRAW-ARROW (125 20) (42 47) NIL 0)
            (DRAW-BUTTON (142 40) (4 4) RATIO 0)
            (DRAW-TEXT (154 40) (35 14) "ratio" 0)
            (DRAW-BUTTON (107 14) (4 4) WIDTH 0)
            (DRAW-TEXT (93 0) (35 14) "width" 0)
            (DRAW-BUTTON (184 69) (4 4) GOALWIDTH 0)
            (DRAW-TEXT (153 80) (70 14) "goal width" 0)
            (DRAW-BUTTON (33 41) (4 4) BASE 0)
            (DRAW-TEXT (0 39) (28 14) "base" 0)
            (DRAW-BUTTON (163 14) (4 4) X 0)
            (DRAW-TEXT (162 1) (7 14) "x" 0)
            (DRAW-BUTTON (247 69) (4 4) Y 0)
            (DRAW-TEXT (245 55) (7 14) "y" 0)
            (DRAW-ARROW (172 21) (69 44) NIL 0))
           (0 0) (343 96))) 

(DEFUN DRAW-LINEAR-SCALE (W X Y)
  (WINDOW-DRAW-LINE-XY W (+ 22 X) (+ 16 Y) (+ 214 X) (+ 16 Y))
  (WINDOW-DRAW-LINE-XY W (+ 47 X) (+ 71 Y) (+ 315 X) (+ 71 Y))
  (WINDOW-PRINTAT-XY W "x min" (+ 6 X) (1+ Y))
  (WINDOW-PRINTAT-XY W "x max" (+ 198 X) (1+ Y))
  (WINDOW-PRINTAT-XY W "goal min" (+ 20 X) (+ 82 Y))
  (WINDOW-PRINTAT-XY W "goal max" (+ 287 X) (+ 82 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 125 X) (+ 20 Y) (+ 167 X) (+ 67 Y))
  (WINDOW-PRINTAT-XY W "ratio" (+ 154 X) (+ 40 Y))
  (WINDOW-PRINTAT-XY W "width" (+ 93 X) Y)
  (WINDOW-PRINTAT-XY W "goal width" (+ 153 X) (+ 80 Y))
  (WINDOW-PRINTAT-XY W "base" X (+ 39 Y))
  (WINDOW-PRINTAT-XY W "x" (+ 162 X) (1+ Y))
  (WINDOW-PRINTAT-XY W "y" (+ 245 X) (+ 55 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 172 X) (+ 21 Y) (+ 241 X) (+ 65 Y))
  (WINDOW-FORCE-OUTPUT W)) 

(SETF (GET 'LINEAR-SCALE 'PICMENU-SPEC)
      '(PICMENU-SPEC 343 96
           ((XMIN (22 16)) (XMAX (214 16)) (GOALMIN (47 71))
            (GOALMAX (315 71)) (RATIO (144 42)) (WIDTH (109 16))
            (GOALWIDTH (186 71)) (BASE (35 43)) (X (165 16))
            (Y (249 71)))
           T DRAW-LINEAR-SCALE 9X15)) 

(SETF (GET 'CLIFF 'DRAW-DESCR)
      '(DRAW-DESC CLIFF
        ((DRAW-LINE (0 132) (46 0) NIL 0)
         (DRAW-LINE (46 132) (0 -112) NIL 0)
         (DRAW-LINE (46 20) (58 0) NIL 0)
         (DRAW-BUTTON (44 78) (4 4) HEIGHT 0)
         (DRAW-TEXT (31 78) (7 14) "h" 0)
         (DRAW-ARROW (0 151) (47 0) NIL 0)
         (DRAW-BUTTON (16 149) (4 4) HORIZONTAL-VELOCITY 0)
         (DRAW-TEXT (12 138) (14 14) "v0" 0)
         (DRAW-BUTTON (92 18) (4 4) HORIZONTAL-DISTANCE 0)
         (DRAW-TEXT (91 6) (7 14) "x" 0)
         (DRAW-BUTTON (28 18) (4 4) TIME 0)
         (DRAW-TEXT (35 20) (7 14) "t" 0)
         (DRAW-ARROW (53 49) (0 -24) NIL 0)
         (DRAW-BUTTON (51 40) (4 4) VELOCITY 0)
         (DRAW-TEXT (49 54) (7 14) "v" 0)
         (DRAW-ARROW (81 61) (10 -32) NIL 0)
         (DRAW-BUTTON (82 48) (4 4) TOTAL-VELOCITY 0)
         (DRAW-TEXT (88 49) (14 14) "vt" 0)
         (DRAW-LINE (4 174) (0 0) NIL 0)
         (DRAW-LINE (17 0) (0 0) NIL 0))
	(0 0) (104 174)) )

(SETF (GET 'CLIFF 'PICMENU-SPEC)
      '(PICMENU-SPEC 104 174
		     ((HEIGHT (46 80)) (HORIZONTAL-VELOCITY (18 151))
		      (HORIZONTAL-DISTANCE (94 20)) (TIME (30 20))
		      (VELOCITY (53 42)) (TOTAL-VELOCITY (84 50)))
		     T DRAW-CLIFF 9X15) )

(DEFUN DRAW-CLIFF (W X Y)
  (WINDOW-DRAW-LINE-XY W X (+ 132 Y) (+ 46 X) (+ 132 Y))
  (WINDOW-DRAW-LINE-XY W (+ 46 X) (+ 132 Y) (+ 46 X) (+ 20 Y))
  (WINDOW-DRAW-LINE-XY W (+ 46 X) (+ 20 Y) (+ 104 X) (+ 20 Y))
  (WINDOW-PRINTAT-XY W "h" (+ 31 X) (+ 78 Y))
  (WINDOW-DRAW-ARROW-XY W X (+ 151 Y) (+ 47 X) (+ 151 Y))
  (WINDOW-PRINTAT-XY W "v0" (+ 12 X) (+ 138 Y))
  (WINDOW-PRINTAT-XY W "x" (+ 91 X) (+ 6 Y))
  (WINDOW-PRINTAT-XY W "t" (+ 35 X) (+ 20 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 53 X) (+ 49 Y) (+ 53 X) (+ 25 Y))
  (WINDOW-PRINTAT-XY W "v" (+ 49 X) (+ 54 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 81 X) (+ 61 Y) (+ 91 X) (+ 29 Y))
  (WINDOW-PRINTAT-XY W "vt" (+ 88 X) (+ 49 Y))
  (WINDOW-DRAW-LINE-XY W (+ 4 X) (+ 174 Y) (+ 4 X) (+ 174 Y))
  (WINDOW-DRAW-LINE-XY W (+ 17 X) Y (+ 17 X) Y)
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'SPRING 'DRAW-DESCR)
      '(DRAW-DESC SPRING
	((DRAW-DOT (47 187) (4 4) NIL 0)
	 (DRAW-DOT (47 37) (4 4) NIL 0)
         (DRAW-LINE (49 189) (0 -32) NIL 0)
         (DRAW-LINE (49 39) (0 33) NIL 0)
         (DRAW-LINE (49 157) (15 -6) NIL 0)
         (DRAW-LINE (64 151) (-31 -10) NIL 0)
         (DRAW-LINE (33 141) (29 -11) NIL 0)
         (DRAW-LINE (62 130) (-28 -10) NIL 0)
         (DRAW-LINE (34 120) (26 -10) NIL 0)
         (DRAW-LINE (60 110) (-27 -9) NIL 0)
         (DRAW-LINE (33 101) (28 -9) NIL 0)
         (DRAW-LINE (61 92) (-26 -10) NIL 0)
         (DRAW-LINE (35 82) (14 -10) NIL 0)
         (DRAW-BUTTON (58 108) (4 4) SPRING-CONSTANT 0)
         (DRAW-TEXT (62 90) (7 14) "k" 0)
         (DRAW-ARROW (16 119) (0 29) NIL 0)
         (DRAW-ARROW (16 117) (0 -25) NIL 0)
         (DRAW-BUTTON (14 117) (4 4) STRETCH 0)
         (DRAW-BUTTON (15 39) (4 4) FORCE 0)
         (DRAW-ARROW (16 57) (0 -32) NIL 0)
         (DRAW-TEXT (23 39) (7 14) "f" 0)
         (DRAW-BOX (36 11) (28 26) NIL 0)
         (DRAW-BUTTON (47 18) (4 4) MASS 0)
         (DRAW-TEXT (46 26) (7 14) "m" 0)
         (DRAW-TEXT (22 116) (7 14) "s" 0)
         (DRAW-LINE (0 201) (1 0) NIL 0)
         (DRAW-LINE (1 0) (-1 0) NIL 0))
      (0 0) (69 201)) )

(SETF (GET 'SPRING 'PICMENU-SPEC)
      '(PICMENU-SPEC 69 201
        ((SPRING-CONSTANT (60 110)) (STRETCH (16 119)) (FORCE (17 41))
         (MASS (49 20)))
        T DRAW-SPRING 9X15) )

(DEFUN DRAW-SPRING (W X Y)
  (WINDOW-DRAW-DOT-XY W (+ 49 X) (+ 189 Y))
  (WINDOW-DRAW-DOT-XY W (+ 49 X) (+ 39 Y))
  (WINDOW-DRAW-LINE-XY W (+ 49 X) (+ 189 Y) (+ 49 X) (+ 157 Y))
  (WINDOW-DRAW-LINE-XY W (+ 49 X) (+ 39 Y) (+ 49 X) (+ 72 Y))
  (WINDOW-DRAW-LINE-XY W (+ 49 X) (+ 157 Y) (+ 64 X) (+ 151 Y))
  (WINDOW-DRAW-LINE-XY W (+ 64 X) (+ 151 Y) (+ 33 X) (+ 141 Y))
  (WINDOW-DRAW-LINE-XY W (+ 33 X) (+ 141 Y) (+ 62 X) (+ 130 Y))
  (WINDOW-DRAW-LINE-XY W (+ 62 X) (+ 130 Y) (+ 34 X) (+ 120 Y))
  (WINDOW-DRAW-LINE-XY W (+ 34 X) (+ 120 Y) (+ 60 X) (+ 110 Y))
  (WINDOW-DRAW-LINE-XY W (+ 60 X) (+ 110 Y) (+ 33 X) (+ 101 Y))
  (WINDOW-DRAW-LINE-XY W (+ 33 X) (+ 101 Y) (+ 61 X) (+ 92 Y))
  (WINDOW-DRAW-LINE-XY W (+ 61 X) (+ 92 Y) (+ 35 X) (+ 82 Y))
  (WINDOW-DRAW-LINE-XY W (+ 35 X) (+ 82 Y) (+ 49 X) (+ 72 Y))
  (WINDOW-PRINTAT-XY W "k" (+ 62 X) (+ 90 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 16 X) (+ 119 Y) (+ 16 X) (+ 148 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 16 X) (+ 117 Y) (+ 16 X) (+ 92 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 16 X) (+ 57 Y) (+ 16 X) (+ 25 Y))
  (WINDOW-PRINTAT-XY W "f" (+ 23 X) (+ 39 Y))
  (WINDOW-DRAW-BOX-XY W (+ 36 X) (+ 11 Y) 28 26)
  (WINDOW-PRINTAT-XY W "m" (+ 46 X) (+ 26 Y))
  (WINDOW-PRINTAT-XY W "s" (+ 22 X) (+ 116 Y))
  (WINDOW-DRAW-LINE-XY W X (+ 201 Y) (1+ X) (+ 201 Y))
  (WINDOW-DRAW-LINE-XY W (1+ X) Y X Y)
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'ITER-ACC 'DRAW-DESCR)
      '(DRAW-DESC ITER-ACC
		  ((DRAW-BUTTON (0 34) (4 4) RECORDTYPE 0)
		   (DRAW-TEXT (8 33) (14 14) "In" 0)
		   (DRAW-BUTTON (46 0) (4 4) OUTPUT 0)
		   (DRAW-BUTTON (92 28) (4 4) ACC 0)
		   (DRAW-TEXT (64 26) (21 14) "Acc" 0)
		   (DRAW-TEXT (38 8) (21 14) "Out" 0)
		   (DRAW-BOX (2 2) (92 57) NIL 0))
		  (0 0) (96 64)))

(DEFUN DRAW-ITER-ACC (W X Y)
  (WINDOW-PRINTAT-XY W "In" (+ 8 X) (+ 33 Y))
  (WINDOW-PRINTAT-XY W "Acc" (+ 64 X) (+ 26 Y))
  (WINDOW-PRINTAT-XY W "Out" (+ 38 X) (+ 8 Y))
  (WINDOW-DRAW-BOX-XY W (+ 2 X) (+ 2 Y) 92 57)
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'ITER-ACC 'PICMENU-SPEC)
      '(PICMENU-SPEC 96 59 ((RECORDTYPE (2 36)) (OUTPUT (48 2)) (ACC (94 30)))
		     T DRAW-ITER-ACC 9X15))

(SETF (GET 'FIND-UPDATE 'DRAW-DESCR)
      '(DRAW-DESC FIND-UPDATE
		  ((DRAW-BUTTON (0 27) (4 4) IN 0)
		   (DRAW-BUTTON (47 0) (4 4) STG 0)
		   (DRAW-BUTTON (100 34) (4 4) ACC 0)
		   (DRAW-TEXT (73 34) (21 14) "Acc" 0)
		   (DRAW-TEXT (26 6) (49 14) "Storage" 0)
		   (DRAW-BOX (2 1) (101 53) NIL 0))
		  (0 0) (104 54)))

(DEFUN DRAW-FIND-UPDATE (W X Y)
  (WINDOW-PRINTAT-XY W "Acc" (+ 73 X) (+ 34 Y))
  (WINDOW-PRINTAT-XY W "Storage" (+ 26 X) (+ 6 Y))
  (WINDOW-DRAW-BOX-XY W (+ 2 X) (1+ Y) 101 53)
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'FIND-UPDATE 'PICMENU-SPEC)
      '(PICMENU-SPEC 104 54 ((IN (2 29)) (STG (49 2)) (ACC (102 36))) T
		     DRAW-FIND-UPDATE 9X15))

(SETF (GET 'CHAIN 'DRAW-DESCR)
      '(DRAW-DESC CHAIN
        ((DRAW-BOX (2 0) (98 53) NIL 0)
         (DRAW-BUTTON (0 49/2) (4 4) IN 0)
         (DRAW-TEXT (8 25) (14 14) "In" 0)
         (DRAW-BUTTON (98 49/2) (4 4) ACC 0)
         (DRAW-TEXT (73 25) (21 14) "Acc" 0))
        (0 0) (102 53)) )

(SETF (GET 'CHAIN 'PICMENU-SPEC)
      '(PICMENU-SPEC 102 53 ((IN (2 53/2)) (ACC (100 53/2))) T DRAW-CHAIN
        9X15) )

(DEFUN DRAW-CHAIN  (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ 2 X) Y 98 53)
  (WINDOW-PRINTAT-XY W "In" (+ 8 X) (+ 25 Y))
  (WINDOW-PRINTAT-XY W "Acc" (+ 73 X) (+ 25 Y))
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'projectile 'DRAW-DESCR)
      '(DRAW-DESC PROJECTILE
        ((DRAW-LINE (0 29) (182 0) NIL 0)
         (DRAW-BUTTON (99 27) (4 4) DISTANCE 0)
         (DRAW-TEXT (98 11) (7 14) "d" 0)
         (DRAW-ARROW (0 29) (58 44) NIL 0)
         (DRAW-BUTTON (27 48) (4 4) V0 0)
         (DRAW-TEXT (11 57) (14 14) "v0" 0)
         (DRAW-LINE (20 44) (6 -5) NIL 0)
         (DRAW-LINE (26 39) (2 -5) NIL 0)
         (DRAW-LINE (28 34) (0 -5) NIL 0)
         (DRAW-BUTTON (24 37) (4 4) ANGLE 0)
         (DRAW-TEXT (31 37) (35 14) "angle" 0)
         (DRAW-ARROW (0 15) (55 0) NIL 0)
         (DRAW-BUTTON (23 13) (4 4) X-VELOCITY 0)
         (DRAW-TEXT (18 0) (14 14) "vx" 0)
         (DRAW-ARROW (56 29) (0 40) NIL 0)
         (DRAW-BUTTON (54 45) (4 4) Y-VELOCITY 0)
         (DRAW-TEXT (61 47) (14 14) "vy" 0)
         (DRAW-BUTTON (180 27) (4 4) TIME 0)
         (DRAW-TEXT (179 14) (7 14) "t" 0)
         (DRAW-LINE (64 76) (12 6) NIL 0)
         (DRAW-LINE (83 84) (16 3) NIL 0)
         (DRAW-LINE (108 86) (17 -2) NIL 0)
         (DRAW-LINE (133 79) (14 -6) NIL 0)
         (DRAW-LINE (153 67) (12 -10) NIL 0)
         (DRAW-LINE (171 50) (9 -12) NIL 0)
         (DRAW-BUTTON (97 85) (4 4) HEIGHT 0)
         (DRAW-TEXT (83 71) (42 14) "height" 0))
        (0 0) (186 89)))

(SETF (GET 'projectile 'PICMENU-SPEC)
      '(PICMENU-SPEC 186 89
        ((DISTANCE (101 29)) (V0 (29 50)) (ANGLE (26 39))
         (X-VELOCITY (25 15)) (Y-VELOCITY (56 47)) (TIME (182 29))
         (HEIGHT (99 87)))
        T DRAW-PROJECTILE 9X15))

(DEFUN DRAW-projectile (W X Y)
  (WINDOW-DRAW-LINE-XY W X (+ 29 Y) (+ 182 X) (+ 29 Y))
  (WINDOW-PRINTAT-XY W "d" (+ 98 X) (+ 11 Y))
  (WINDOW-DRAW-ARROW-XY W X (+ 29 Y) (+ 58 X) (+ 73 Y))
  (WINDOW-PRINTAT-XY W "v0" (+ 11 X) (+ 57 Y))
  (WINDOW-DRAW-LINE-XY W (+ 20 X) (+ 44 Y) (+ 26 X) (+ 39 Y))
  (WINDOW-DRAW-LINE-XY W (+ 26 X) (+ 39 Y) (+ 28 X) (+ 34 Y))
  (WINDOW-DRAW-LINE-XY W (+ 28 X) (+ 34 Y) (+ 28 X) (+ 29 Y))
  (WINDOW-PRINTAT-XY W "angle" (+ 31 X) (+ 37 Y))
  (WINDOW-DRAW-ARROW-XY W X (+ 15 Y) (+ 55 X) (+ 15 Y))
  (WINDOW-PRINTAT-XY W "vx" (+ 18 X) Y)
  (WINDOW-DRAW-ARROW-XY W (+ 56 X) (+ 29 Y) (+ 56 X) (+ 69 Y))
  (WINDOW-PRINTAT-XY W "vy" (+ 61 X) (+ 47 Y))
  (WINDOW-PRINTAT-XY W "t" (+ 179 X) (+ 14 Y))
  (WINDOW-DRAW-LINE-XY W (+ 64 X) (+ 76 Y) (+ 76 X) (+ 82 Y))
  (WINDOW-DRAW-LINE-XY W (+ 83 X) (+ 84 Y) (+ 99 X) (+ 87 Y))
  (WINDOW-DRAW-LINE-XY W (+ 108 X) (+ 86 Y) (+ 125 X) (+ 84 Y))
  (WINDOW-DRAW-LINE-XY W (+ 133 X) (+ 79 Y) (+ 147 X) (+ 73 Y))
  (WINDOW-DRAW-LINE-XY W (+ 153 X) (+ 67 Y) (+ 165 X) (+ 57 Y))
  (WINDOW-DRAW-LINE-XY W (+ 171 X) (+ 50 Y) (+ 180 X) (+ 38 Y))
  (WINDOW-PRINTAT-XY W "height" (+ 83 X) (+ 71 Y))
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'INCLINED-PLANE 'PICMENU-SPEC)
      '(PICMENU-SPEC 182 115
        ((X (83 2)) (Y (180 41)) (THETA (38 13)) (PHI (164 75))
         (R (72 38)) (WEIGHT (138 42)) (MASS (135 76))
         (NORMAL-FORCE (148 49)) (TANGENTIAL-FORCE (151 18))
         (MU (94 49)) (FRICTION-FORCE (150 92)) (ACCELERATION (114 85))
         (VELOCITY (14 33)) (TIME (2 15)))
        T DRAW-INCLINED-PLANE 9X15) )

(SETF (GET 'INCLINED-PLANE 'DRAW-DESCR)
      '(DRAW-DESC INCLINED-PLANE
        ((DRAW-LINE (1 2) (179 0) NIL 0)
         (DRAW-LINE (1 2) (179 90) NIL 0)
         (DRAW-DOT (136 69) (4 4) NIL 0)
         (DRAW-ARROW (138 71) (0 -60) NIL 0)
         (DRAW-ARROW (138 71) (23 -47) NIL 0)
         (DRAW-ARROW (161 24) (-23 -13) NIL 0)
         (DRAW-LINE (35 18) (3 -5) NIL 0)
         (DRAW-LINE (38 13) (1 -5) NIL 0)
         (DRAW-LINE (39 8) (0 -5) NIL 0)
         (DRAW-LINE (160 81) (4 -6) NIL 0)
         (DRAW-LINE (164 75) (7 -4) NIL 0)
         (DRAW-LINE (171 71) (9 -1) NIL 0)
         (DRAW-LINE (180 92) (0 -90) NIL 0)
         (DRAW-BUTTON (81 0) (4 4) X 0)
         (DRAW-TEXT (80 11) (7 14) "x" 0)
         (DRAW-BUTTON (178 39) (4 4) Y 0)
         (DRAW-TEXT (169 42) (7 14) "y" 0)
         (DRAW-BUTTON (36 11) (4 4) THETA 0)
         (DRAW-BUTTON (162 73) (4 4) PHI 0)
         (DRAW-BUTTON (70 36) (4 4) R 0)
         (DRAW-TEXT (61 41) (7 14) "r" 0)
         (DRAW-BUTTON (136 40) (4 4) WEIGHT 0)
         (DRAW-TEXT (126 41) (7 14) "w" 0)
         (DRAW-BUTTON (133 74) (4 4) MASS 0)
         (DRAW-TEXT (123 74) (7 14) "m" 0)
         (DRAW-BUTTON (146 47) (4 4) NORMAL-FORCE 0)
         (DRAW-BUTTON (149 16) (4 4) TANGENTIAL-FORCE 0)
         (DRAW-BUTTON (92 47) (4 4) MU 0)
         (DRAW-TEXT (88 36) (14 14) "mu" 0)
         (DRAW-ARROW (137 85) (32 16) NIL 0)
         (DRAW-BUTTON (148 90) (4 4) FRICTION-FORCE 0)
         (DRAW-TEXT (143 101) (7 14) "f" 0)
         (DRAW-ARROW (128 93) (-32 -17) NIL 0)
         (DRAW-BUTTON (112 83) (4 4) ACCELERATION 0)
         (DRAW-TEXT (107 93) (7 14) "a" 0)
         (DRAW-ARROW (21 38) (-20 -12) NIL 0)
         (DRAW-BUTTON (12 31) (4 4) VELOCITY 0)
         (DRAW-TEXT (6 41) (7 14) "v" 0)
         (DRAW-BUTTON (0 13) (4 4) TIME 0)
         (DRAW-TEXT (8 15) (7 14) "t" 0))
        (0 0) (182 115)) )

(defun DRAW-INCLINED-PLANE (W X Y)
  (WINDOW-DRAW-LINE-XY W (1+ X) (+ 2 Y) (+ 180 X) (+ 2 Y))
  (WINDOW-DRAW-LINE-XY W (1+ X) (+ 2 Y) (+ 180 X) (+ 92 Y))
  (WINDOW-DRAW-DOT-XY W (+ 138 X) (+ 71 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 138 X) (+ 71 Y) (+ 138 X) (+ 11 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 138 X) (+ 71 Y) (+ 161 X) (+ 24 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 161 X) (+ 24 Y) (+ 138 X) (+ 11 Y))
  (WINDOW-DRAW-LINE-XY W (+ 35 X) (+ 18 Y) (+ 38 X) (+ 13 Y))
  (WINDOW-DRAW-LINE-XY W (+ 38 X) (+ 13 Y) (+ 39 X) (+ 8 Y))
  (WINDOW-DRAW-LINE-XY W (+ 39 X) (+ 8 Y) (+ 39 X) (+ 3 Y))
  (WINDOW-DRAW-LINE-XY W (+ 160 X) (+ 81 Y) (+ 164 X) (+ 75 Y))
  (WINDOW-DRAW-LINE-XY W (+ 164 X) (+ 75 Y) (+ 171 X) (+ 71 Y))
  (WINDOW-DRAW-LINE-XY W (+ 171 X) (+ 71 Y) (+ 180 X) (+ 70 Y))
  (WINDOW-DRAW-LINE-XY W (+ 180 X) (+ 92 Y) (+ 180 X) (+ 2 Y))
  (WINDOW-PRINTAT-XY W "x" (+ 80 X) (+ 11 Y))
  (WINDOW-PRINTAT-XY W "y" (+ 169 X) (+ 42 Y))
  (WINDOW-PRINTAT-XY W "r" (+ 61 X) (+ 41 Y))
  (WINDOW-PRINTAT-XY W "w" (+ 126 X) (+ 41 Y))
  (WINDOW-PRINTAT-XY W "m" (+ 123 X) (+ 74 Y))
  (WINDOW-PRINTAT-XY W "mu" (+ 88 X) (+ 36 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 137 X) (+ 85 Y) (+ 169 X) (+ 101 Y))
  (WINDOW-PRINTAT-XY W "f" (+ 143 X) (+ 101 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 128 X) (+ 93 Y) (+ 96 X) (+ 76 Y))
  (WINDOW-PRINTAT-XY W "a" (+ 107 X) (+ 93 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 21 X) (+ 38 Y) (1+ X) (+ 26 Y))
  (WINDOW-PRINTAT-XY W "v" (+ 6 X) (+ 41 Y))
  (WINDOW-PRINTAT-XY W "t" (+ 8 X) (+ 15 Y))
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'Heurs 'PICMENU-SPEC)
      '(PICMENU-SPEC 127 72 ((statetype (2 37)) (stg (64 2))) T draw-heurs
                     9X15) )

(SETF (GET 'Heurs 'DRAW-DESCR)
      '(DRAW-DESC Heurs
                  ((DRAW-BOX (2 2) (125 70) NIL 0)
                   (DRAW-BUTTON (0 35) (4 4) statetype 0)
                   (DRAW-TEXT (10 33) (35 14) "State" 0)
                   (DRAW-BUTTON (62 0) (4 4) stg 0)
                   (DRAW-TEXT (47 13) (35 14) "Pri Q" 0))
                  (0 0) (127 72)))

(defun draw-heurs (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ 2 X) (+ 2 Y) 125 70)
  (WINDOW-PRINTAT-XY W "State" (+ 10 X) (+ 33 Y))
  (WINDOW-PRINTAT-XY W "Pri Q" (+ 47 X) (+ 13 Y))
  (WINDOW-FORCE-OUTPUT W))

(SETF (GET 'ARRAY-PRIORITY-QUEUE 'PICMENU-SPEC)
      '(PICMENU-SPEC 107 42 ((IN (107/2 40)) (STG (107/2 2))) T
    DRAW-ARRAY-PRIORITY-QUEUE 9X15))

(SETF (GET 'ARRAY-PRIORITY-QUEUE 'DRAW-DESCR)
      '(DRAW-DESC ARRAY-PRIORITY-QUEUE
    ((DRAW-BOX (0 2) (107 38) NIL 0)
     (DRAW-BUTTON (103/2 38) (4 4) IN 0)
     (DRAW-BUTTON (103/2 0) (4 4) STG 0)
     (DRAW-TEXT (36 10) (35 14) "Queue" 0))
    (0 0) (107 42)))

(defun  DRAW-ARRAY-PRIORITY-QUEUE (W X Y)
  (WINDOW-DRAW-BOX-XY W X (+ 2 Y) 107 38)
  (WINDOW-PRINTAT-XY W "Queue" (+ 36 X) (+ 10 Y))
  (WINDOW-FORCE-OUTPUT W))

(setf (get 'circle 'glpropmenu) 'circleprops)

(SETF (GET 'CIRCLEPROPS 'PICMENU-SPEC)
      '(PICMENU-SPEC 193 207
        ((RADIUS (56 70)) (DIAMETER (126 77)) (CIRCUMFERENCE (120 12))
         (AREA (130 51)) (CENTER (93 86)) (CENTERX (74 49))
         (CENTERY (93 65)) (INTERSECT-CIRCLE (25 137))
         (INTERSECTS-CIRCLE? (12 136)) (INTERSECT-LINE (116 170))
         (INTERSECTS-LINE? (127 179)) (TANGENT-POINTA (10 78))
         (TANGENT-POINTB (76 8)))
        T DRAW-CIRCLEPROPS 9X15) )

(SETF (GET 'CIRCLEPROPS 'DRAW-DESCR)
      '(DRAW-DESC CIRCLEPROPS
        ((DRAW-CIRCLE (10 7) (166 166) NIL 0)
         (DRAW-DOT (91 84) (4 4) NIL 0)
         (DRAW-BUTTON (54 68) (4 4) RADIUS 0)
         (DRAW-TEXT (44 69) (7 10) "r" 0)
         (DRAW-ARROW (93 86) (-80 19) NIL 0)
         (DRAW-ARROW (93 86) (79 -20) NIL 0)
         (DRAW-BUTTON (124 75) (4 4) DIAMETER 0)
         (DRAW-TEXT (126 84) (7 10) "d" 0)
         (DRAW-BUTTON (118 10) (4 4) CIRCUMFERENCE 0)
         (DRAW-TEXT (125 0) (7 10) "c" 0)
         (DRAW-BUTTON (128 49) (4 4) AREA 0)
         (DRAW-TEXT (119 38) (28 10) "area" 0)
         (DRAW-BUTTON (91 84) (4 4) CENTER 0)
         (DRAW-TEXT (73 94) (42 10) "center" 0)
         (DRAW-ARROW (93 48) (0 36) NIL 0)
         (DRAW-ARROW (62 49) (32 0) NIL 0)
         (DRAW-ARROW (93 86) (-74 -33) NIL 0)
         (DRAW-BUTTON (72 47) (4 4) CENTERX 0)
         (DRAW-TEXT (71 36) (7 14) "x" 0)
         (DRAW-BUTTON (91 63) (4 4) CENTERY 0)
         (DRAW-TEXT (101 62) (7 14) "y" 0)
         (DRAW-CIRCLE (5 133) (74 74) NIL 0)
         (DRAW-BUTTON (23 135) (4 4) INTERSECT-CIRCLE 0)
         (DRAW-BUTTON (10 134) (4 4) INTERSECTS-CIRCLE? 0)
         (DRAW-TEXT (0 133) (7 14) "?" 0)
         (DRAW-LINE (93 199) (100 -122) NIL 0)
         (DRAW-BUTTON (114 168) (4 4) INTERSECT-LINE 0)
         (DRAW-BUTTON (125 177) (4 4) INTERSECTS-LINE? 0)
         (DRAW-TEXT (133 177) (7 14) "?" 0)
         (DRAW-BUTTON (8 76) (4 4) TANGENT-POINTA 1)
         (DRAW-BUTTON (74 6) (4 4) TANGENT-POINTB 1)
         (DRAW-DOT (16 21) (4 4) NIL 1)
         (DRAW-LINE (10 78) (8 -55) NIL 1)
         (DRAW-LINE (76 8) (-58 15) NIL 1))
        (0 0) (193 207)) )

(defun DRAW-CIRCLEPROPS (W X Y)
  (WINDOW-DRAW-CIRCLE-XY W (+ 93 X) (+ 90 Y) 83)
  (WINDOW-DRAW-DOT-XY W (+ 93 X) (+ 86 Y))
  (WINDOW-PRINTAT-XY W "r" (+ 44 X) (+ 69 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 93 X) (+ 86 Y) (+ 13 X) (+ 105 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 93 X) (+ 86 Y) (+ 172 X) (+ 66 Y))
  (WINDOW-PRINTAT-XY W "d" (+ 126 X) (+ 84 Y))
  (WINDOW-PRINTAT-XY W "c" (+ 125 X) Y)
  (WINDOW-PRINTAT-XY W "area" (+ 119 X) (+ 38 Y))
  (WINDOW-PRINTAT-XY W "center" (+ 73 X) (+ 94 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 93 X) (+ 48 Y) (+ 93 X) (+ 84 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 62 X) (+ 49 Y) (+ 94 X) (+ 49 Y))
  (WINDOW-DRAW-ARROW-XY W (+ 93 X) (+ 86 Y) (+ 19 X) (+ 53 Y))
  (WINDOW-PRINTAT-XY W "x" (+ 71 X) (+ 36 Y))
  (WINDOW-PRINTAT-XY W "y" (+ 101 X) (+ 62 Y))
  (WINDOW-DRAW-CIRCLE-XY W (+ 42 X) (+ 170 Y) 37)
  (WINDOW-PRINTAT-XY W "?" X (+ 133 Y))
  (WINDOW-DRAW-LINE-XY W (+ 93 X) (+ 199 Y) (+ 193 X) (+ 77 Y))
  (WINDOW-PRINTAT-XY W "?" (+ 133 X) (+ 177 Y))
  (WINDOW-DRAW-DOT-XY W (+ 18 X) (+ 23 Y))
  (WINDOW-DRAW-LINE-XY W (+ 10 X) (+ 78 Y) (+ 18 X) (+ 23 Y))
  (WINDOW-DRAW-LINE-XY W (+ 76 X) (+ 8 Y) (+ 18 X) (+ 23 Y))
  (WINDOW-FORCE-OUTPUT W))

(setf (get 'find 'DRAW-DESCR)
      '(DRAW-DESC FIND
    ((DRAW-BOX (2 2) (107 56) NIL 1)
     (DRAW-BUTTON (0 28) (4 4) RECORDTYPE 1)
     (DRAW-BUTTON (48 0) (4 4) OUTPUT 1)
     (DRAW-BUTTON (107 43) (4 4) VALUE 1)
     (DRAW-BUTTON (107 18) (4 4) TEST 1)
     (DRAW-TEXT (9 28) (14 14) "In" 1)
     (DRAW-TEXT (39 12) (21 14) "Out" 1)
     (DRAW-TEXT (65 42) (35 14) "Value" 1)
     (DRAW-TEXT (75 17) (28 14) "Test" 1))
    (0 0) (111 58)))

(setf (get 'find 'PICMENU-SPEC)
      '(PICMENU-SPEC 111 58
    ((RECORDTYPE (2 30)) (OUTPUT (50 2)) (VALUE (109 45))
     (TEST (109 20)))
    T DRAW-FIND 9X15))

(defun DRAW-FIND (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ 2 X) (+ 2 Y) 107 56)
  (WINDOW-PRINTAT-XY W "In" (+ 9 X) (+ 28 Y))
  (WINDOW-PRINTAT-XY W "Out" (+ 39 X) (+ 12 Y))
  (WINDOW-PRINTAT-XY W "Value" (+ 65 X) (+ 42 Y))
  (WINDOW-PRINTAT-XY W "Test" (+ 75 X) (+ 17 Y))
  (WINDOW-FORCE-OUTPUT W))

(setf (get 'if 'DRAW-DESCR)
      '(DRAW-DESC IF
        ((DRAW-BOX (2 0) (37 25) NIL 1)
         (DRAW-BUTTON (37/2 23) (4 4) TEST 1)
         (DRAW-BUTTON (0 17) (4 4) TRUEVAL 1)
         (DRAW-BUTTON (0 5) (4 4) FALSEVAL 1)
         (DRAW-BUTTON (37 21/2) (4 4) OUTPUT 1))
        (0 0) (41 27)) )

(setf (get 'if 'PICMENU-SPEC)
      '(PICMENU-SPEC 41 27
        ((TEST (41/2 25)) (TRUEVAL (2 19)) (FALSEVAL (2 7))
         (OUTPUT (39 25/2)))
        T DRAW-IF 9X15) )

(defun DRAW-IF (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ 2 X) Y 37 25)
  (WINDOW-FORCE-OUTPUT W))

(defun DRAW-ITER-DO (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ 2 X) Y 96 60)
  (WINDOW-PRINTAT-XY W "In" (+ 9 X) (+ 27 Y))
  (WINDOW-PRINTAT-XY W "Action" (+ 49 X) (+ 27 Y))
  (WINDOW-FORCE-OUTPUT W))

(setf (get 'ITER-DO 'DRAW-DESCR)
      '(DRAW-DESC ITER-DO
        ((DRAW-BOX (2 0) (96 60) NIL 1)
         (DRAW-BUTTON (0 28) (4 4) RECORDTYPE 1)
         (DRAW-TEXT (9 27) (14 14) "In" 1)
         (DRAW-BUTTON (96 28) (4 4) ACTION 1)
         (DRAW-TEXT (49 27) (42 14) "Action" 1))
        (0 0) (100 60)) )

(setf (get 'ITER-DO 'PICMENU-SPEC)
      '(PICMENU-SPEC 100 60 ((RECORDTYPE (2 30)) (ACTION (98 30))) T
        DRAW-ITER-DO 9X15) )

(setf (get 'plot 'picmenu-spec)
      '(PICMENU-SPEC 87 50 ((IN (2 13)) (ACC (85 22)) (RECORDTYPE (2 34))) T
                     DRAW-PLOT 9X15))

(setf (get 'plot 'DRAW-DESCR)
      '(DRAW-DESC PLOT
                  ((DRAW-BOX (2 0) (83 50) NIL 1)
                   (DRAW-BUTTON (0 11) (4 4) IN 1)
                   (DRAW-BUTTON (83 20) (4 4) ACC 1)
                   (DRAW-TEXT (42 21) (35 14) "Icons" 1)
                   (DRAW-BUTTON (0 32) (4 4) RECORDTYPE 1))
                  (0 0) (87 50)))

(defun DRAW-PLOT (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ 2 X) Y 83 50)
  (WINDOW-PRINTAT-XY W "Icons" (+ 42 X) (+ 21 Y))
  (WINDOW-FORCE-OUTPUT W))

(setf (get 'plotb 'picmenu-spec)
      '(PICMENU-SPEC 87 50 ((IN (2 13)) (ACC (85 22)) (RECORDTYPE (2 34))) T
                     DRAW-PLOTb 9X15))

(setf (get 'plotb 'DRAW-DESCR)
      '(DRAW-DESC PLOTb
                  ((DRAW-BOX (2 0) (83 50) NIL 1)
                   (DRAW-BUTTON (0 11) (4 4) IN 1)
                   (DRAW-BUTTON (83 20) (4 4) ACC 1)
                   (DRAW-TEXT (42 21) (35 14) "Icons" 1)
                   (DRAW-BUTTON (0 32) (4 4) RECORDTYPE 1))
                  (0 0) (87 50)))

(defun DRAW-PLOTb (W X Y)
  (WINDOW-DRAW-BOX-XY W (+ 2 X) Y 83 50)
  (WINDOW-PRINTAT-XY W "Icons" (+ 42 X) (+ 21 Y))
  (WINDOW-FORCE-OUTPUT W))

