; conprop.lsp              Gordon S. Novak Jr.            ; 31 Dec 15

; Copyright (c) 2015 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 05 Sep 06; 16 Jan 07; 05 Nov 08; 07 Nov 08; 10 Nov 08; 21 Nov 08; 29 Apr 10
; 20 Sep 10; 22 Sep 10; 25 Oct 10; 01 Nov 10; 19 Nov 10; 16 Sep 11; 14 Mar 13
; 29 Mar 13; 01 Apr 13; 05 Apr 13; 08 Apr 13; 10 Apr 13; 19 Apr 13; 22 Apr 13
; 24 Apr 13; 26 Apr 13; 24 Feb 14; 21 Apr 14; 18 Sep 15

; Constraint propagation framework

; A constraint system is modeled as a set of boxes and connections;
; a connection connects a named port on a box to a named port of another box.

; status: appears to work for Waltz, equation sets
; (load "cs381k/search/waltz.lsp") ; then (ld conprop) again.
; (startwaltznet waltznet)
; (startalgnet myalgnetd)

(glispobjects

(cpset (list (nodes  (listof cpnode))
	     (conns  (listof cpconn))  ; ((port menu-name) (port menu-name))
             (actfns (listof (list (kind symbol) (fn symbol)))) )
  msg  ((node (glambda (self nm) (that (nodes self) with name == nm))
		  result cpnode)
	(port-conns   cpset-port-conns)
	(message      cpset-message)
        (add-node     cpset-add-node)
        (add-conn     cpset-add-conn)
        (remove-node  cpset-remove-node)
        (actfn        (glambda (self (node cpnode))
                               (fn (assoc (kind node) (actfns self)))))
	))

(cpnode (list (name  symbol)        ; unique name
              (kind  symbol)
              (role  symbol)        ; ? not currently used
	      (params anything)     ; data for this node
	      ) )

; menu-port = (list (port symbol) (menu-name symbol))
(cpconn (list (from menu-port)            ; add connection name
	      (to   menu-port)))

(cpevent (list (time integer)
               (from cpnode)
               (to cpnode)
               (subport (listof symbol))
               (message anything)) )

 ) ; glispobjects

(defvar *cpset-trace* nil)

(glispglobals (*cpevents* (listof cpevent))
              (*cptime* integer)
 )

(defvar *cpsaveevents*)     ; set to t to save events
(setq *cpsaveevents* nil)

(defvar *cpevents*)
(setq *cpevents* nil)

(defvar *cptime*)
(setq *cptime* 0)

; fix a list alist to be a cons alist for use with sublis
(defun sublisify (lst)
  (mapcar #'(lambda (x) (cons (first x) (second x))) lst))

(gldefun cpset-add-node ((cps cpset) (name symbol) (kind symbol) (role role)
                         (params anything) )
  ((nodes cps) _+ (a cpnode name = name  kind = kind  role = role
                            params = params)))

(gldefun cpset-add-conn ((cps cpset) (from menu-port) (to menu-port))
  ((conns cps) _+ (a cpconn  from = from  to = to)))

; 21 Nov 08
(gldefun cpset-remove-node ((cps cpset) (nm symbol))
  ((nodes cpset) = (for x in (nodes cpset)
                        when (not (eq (name x) nm))
                        collect x))
  ((conns cpset) = (for x in (conns cpset)
                        when (not (or (eq (menu-name (from x)) nm)
                                      (eq (menu-name (to x)) nm)))
                        collect x)) )

; 22 Sep 10; 22 Oct 10
; cf. menu-conns-find-conns
; Find connections of a given port of a named box
(gldefun cpset-port-conns ((cps cpset) (boxname symbol) (port symbol))
  (result (listof menu-port))      ;  = (list (port symbol) (menu-name symbol))
  (let (res)
    (for conn in (conns cps) do
      (if (and (boxname == (menu-name (to conn)))
	       (port == (port (to conn))))
	  (res _+ (from conn)))
      (if (and (boxname == (menu-name (from conn)))
	       (port == (port (from conn))))
	  (res _+ (to conn))) )
    res))

; 27 Apr 10; 22 Sep 10; 22 Oct 10; 01 Nov 10; 19 Nov 10
; Propagate a message from a port
; except = name of a box that is not to get the message
(gldefun cpset-message ((cps cpset) (boxname symbol) (port symbol)
                        (subport (listof symbol))
                        (message anything)
                        &optional (except (listof symbol)) )
  (let (targets targetnode fn)
    (targets = (port-conns cps boxname port))
    (if (and *cpset-trace* targets)
        (if subport
            (format t "Message to node ~A port ~A sub ~A: ~A~%"
                    boxname port subport message)
            (format t "Message to node ~A port ~A: ~A~%"
                    boxname port message) ) )
    (for target in targets
        when (not (member (menu-name target) except))
      (targetnode = (node cps (menu-name target)))
      (incf *cptime*)
      (if *cpsaveevents*
          (push (a cpevent  time = *cptime*
                            from = boxname
                            to = target
                            subport = subport
                            message = message)
                *cpevents*))
      (if *cpset-trace*
          (if subport
              (format t "Update port ~A subport ~A of node ~A to be ~A~%"
                        (port target) subport (menu-name target) message)
              (format t "Update port ~A of node ~A to be ~A~%"
                        (port target) (menu-name target) message)))
      (fn = (actfn cps targetnode))
      (if fn (funcall fn cps (menu-name target)
                      (port target) subport message boxname) ) ) ))

; Need a driver function to:
; load the network, initialize known values, get results, detect loops

; Example: network of principles, constants, variables

(glispobjects

(netvar (cons (name symbol) (val netval) ) ) ; e.g. (radius 5 meter)

(netval anything      ; either (value unit) or just a number
  prop ((value   (glambda (self)
                   (if (consp self) (car self) self)))
        (unit    (glambda (self)
                   (or (and (consp self) (consp (cdr self)) (cadr self))
                       'unity))) ) )

(neteqn (list (equation anything) (values (listof netvar))) )

(neteqnset (list (principle symbol) (values (listof netvar))) )

 ) ; glispobjects

; (solvobjvar eqns goalvar defined &optional objtype)
; defined is a list of items, (var (value unit)) or (var value)
; e.g. (solvobjvar '((= DIAMETER (* 2 RADIUS)) (= AREA (* PI (EXPT RADIUS 2))))
;                  'radius '((area a)) )
; 22 Sep 10; 25 Oct 10; 19 Nov 10
(gldefun netvarfn ((cps cpset) (thisname symbol) (port symbol)
                   (subport symbol) (msg netval) (from symbol))
  (let ((var netvar))
    (var = (params (node cps thisname)))
    (if *cpset-trace*
        (format t "Variable ~A updated to ~A~%" port msg))
    (if (not (equal (val var) msg))
        (progn ((val var) = msg)
               (cpset-message cps thisname port nil msg (list from))) ) ))

; 22 Sep 10; 25 Oct 10; 19 Nov 10
(gldefun neteqnfn ((cps cpset) (thisname symbol) (port symbol)
                   (subport symbol) (msg netval) (from symbol))
  (let (pair vars neweqn (thisbox neteqn))
    (thisbox = (params (node cps thisname)))
    (if *cpset-trace*
        (format t "Equation ~A  var ~A is ~A~%" (equation thisbox) port msg))
    (pair = (assoc port (values thisbox)))
    (if (or (null pair) (not (equal (val pair) msg)))
        (progn
          ((values thisbox) += (a netvar  name = port val = msg))
          (vars = (set-difference (varsin (equation thisbox))
                                  (cons port
                                        (mapcan #'(lambda (pair)
                                                    (if (constantp
                                                          (second pair))
                                                        (list (first pair))))
                                                (values thisbox)))))
          (if (and vars (null (cdr vars)))   ; exactly 1
              (progn 
                (neweqn = (glsolvefor (equation thisbox) (first vars)))
                (newval = (eqn-eval (rhs neweqn)
                                    (mapcar #'neteqnvar (values thisbox))
                                    (mapcar #'neteqnunit (values thisbox))))
; was (eval (sublis (sublisify (values thisbox)) (rhs neweqn))))
                ((values thisbox) += (a netvar  name = (first vars)
                                                val = newval))
                (if *cpset-trace*
                    (format t "   Solved for ~A = ~A~%" (first vars) newval))
                (cpset-message cps thisname (first vars) nil newval
                               (list from))))))))

; 08 Apr 13
; make alist (var . value) from (var value unit)
(defun neteqnvar (x) (cons (car x) (cadr x)))

; 08 Apr 13
; make alist (var . unit) from (var value unit)
(defun neteqnunit (x) (cons (car x) (or (caddr x) 'unity)))

; 07 Nov 08; 22 Sep 10; 25 Oct 10; 19 Nov 10; 08 Apr 13
(gldefun neteqnsetfn ((cps cpset) (thisname symbol)
                      (port symbol) (subport symbol) (msg netval) (from symbol))
  (let (pair newvals (thisbox neteqnset))
    (thisbox = (params (node cps thisname)))
    (if *cpset-trace*
        (format t "Equation set ~A  var ~A is ~A~%"
                (principle thisbox) port msg))
    (pair = (assoc port (values thisbox)))
    (if (or (null pair) (not (equal (val pair) msg)))
        (progn
          ((values thisbox) += (a netvar  name = port val = msg))
          (newvals = (solveqnset (equations (principle thisbox))
                                 (values thisbox)))
          (if newvals
              (dolist (pair newvals)
                ((values thisbox) += pair)
                (if *cpset-trace*
                    (format t "   Solved for ~A = ~A ~A~%"
                            (first pair) (second pair) (third pair)))
                (cpset-message cps thisname (first pair) nil
                               (rest pair) (list from))))))))

(gldefun makealgnet ((boxes (listof anything)) (conns (listof cpconn)))
  (let (nodes cps)
    (nodes = (for x in boxes collect
                  (case (first x)
                    (constant (a cpnode with  name = (second x)
                                              kind = 'constant
                                              params = (cdr x)))
   ; was (a netvar with name = (second x) val  = (third x))) )

                    (var (a cpnode with  name = (second x)
                                         kind = 'var
                                         params = (a netvar with
                                                    name = (second x))) )
                    (equation (a cpnode with  name = (second x)
                                              kind = 'equation
                                              params = (a neteqn with
                                                         equation = (third x))))
                    (eqnset   (a cpnode with  name = (second x)
                                              kind = 'eqnset
                                              params = (a neteqnset with
                                                         principle = (third x))))
                    ) ) )
    (cps = (a cpset  nodes = nodes  conns = conns
                     actfns = '((constant nil) (var netvarfn)
                                (equation neteqnfn) (eqnset neteqnsetfn) ) ))
    cps))

(gldefun startalgnet ((cps cpset))
    (for x in (nodes cps) when (kind x) == 'constant
         (message cps (name x) (name x) nil (cdr (params x)) nil) ) )

; boxes are (name boxtype), conns are ((leg-number name) (leg-number name))
(gldefun makewaltznet ((boxes (listof anything)) (conns (listof cpconn)))
  (let (nodes cps)
    (nodes = (for x in boxes collect
                  (a cpnode with  name = (first x)
                                  kind = (second x)
                                  params = (get (second x) 'labels) ) ) )
    (cps = (a cpset  nodes = nodes  conns = conns
                     actfns = '((a netwaltzfn) (l netwaltzfn) (t netwaltzfn)
                                (y netwaltzfn) ) ) )
    cps))

(gldefun startwaltznet ((cps cpset))
    (for x in (nodes cps)
      (if *cpset-trace*
        (format t "Starting node ~A~%" (name x)))
      (netwaltzfn cps (name x) 0 nil 'start nil) ))

; (message cps (name x) 0 'start nil)

; 22 Sep 10; 25 Oct 10; 19 Nov 10; 16 Sep 11
(gldefun netwaltzfn ((cps cpset) (thisname symbol) (port symbol)
                     (subport symbol) (msg (listof symbol)) (from symbol))
  (let (change newlabels labels targetlabels (var netvar))
    (if *cpset-trace*
        (format t "Edge ~A of ~A updated to ~A~%" port thisname msg))
    (var = (params (node cps thisname)))
    (labels = (params (node cps thisname)))
    (if (eq msg 'start)
        (setq change t)
        (dolist (label labels)
          (if (member (nth port label) msg)
              (push label newlabels)
              (progn (if *cpset-trace* (format t "   delete label ~A~%" label))
                     (setq change t))) ) )
    (if (and change (not (eq msg 'start)))
        (progn (labels = (nreverse newlabels))
               ((params (node cps thisname)) = labels)))
    (dotimes (i 3)
      (when (and change (nth i (first labels)))
        (setq targetlabels '())
        (dolist (label labels)
          (pushnew (opposite (nth i label)) targetlabels) )
        (cpset-message cps thisname i nil targetlabels)) ) ) )


; 20 Mar 01
; sublis with substitutions as lists ((old new) ...) rather than dotted pairs
(defun sublisl (alist tree)
  (if (consp tree)
      (let ((left (sublisl alist (car tree)))
            (right (sublisl alist (cdr tree))))
        (if (and (eq left (car tree))
                 (eq right (cdr tree)))
            tree
            (cons left right)))
      (let ((new (assoc tree alist)))
        (if new
            (cadr new)
            tree) ) ) )


(setq myalgnet
  (makealgnet
   '( (constant const1 3)
      (var var1) )
   '( ((const1 const1) (var1 var1)) ) ) )

(setq myalgnetb
  (makealgnet
   '( (constant const1 3)
      (equation eqn1 (= out (* 2 in)))
      (var var1) )
   '( ((const1 const1) (in eqn1))
      ((out eqn1) (var1 var1))  ) ) )

; (startalgnet myalgnetc) 
(setq myalgnetc
  (makealgnet
   '( (constant const1 3)
      (equation eqn1 (= out (* 2 in)))
      (equation eqn2 (= out (+ in1 in2)))
      (constant const2 4)
      (var var1) )
   '( ((const1 const1) (in eqn1))
      ((out eqn1) (in1 eqn2))
      ((in2 eqn2) (const2 const2))
      ((var1 var1) (out eqn2))  ) ) )

; (startalgnet myalgnetd)
(setq myalgnetd
  (makealgnet
   '( (constant const1 3)
      (equation eqn1 (= out (* 2 in)))
      (equation eqn2 (= out (+ in1 in2)))
      (constant const2 4)
      (eqnset sphere1 sphere)
      (var var1) )
   '( ((const1 const1) (in eqn1))
      ((out eqn1) (in1 eqn2))
      ((in2 eqn2) (const2 const2))
      ((diameter sphere1) (out eqn2))
      ((var1 var1) (volume sphere1))  ) ) )

; (startalgnet myalgnete)
(setq myalgnete
  (makealgnet
   '( (constant const1 3 m)
      (equation eqn1 (= out (* 2 in)))
      (equation eqn2 (= out (+ in1 in2)))
      (constant const2 4 m)
      (eqnset sphere1 sphere)
      (var var1) )
   '( ((const1 const1) (in eqn1))
      ((out eqn1) (in1 eqn2))
      ((in2 eqn2) (const2 const2))
      ((diameter sphere1) (out eqn2))
      ((var1 var1) (volume sphere1))  ) ) )

; example from Winston 1992, p. 264
(setq waltznet
  (makewaltznet
   '((A A) (B L) (C A) (D Y) (E T) (F L) (G A) (H L) (I A) (J Y) (K L) (L A))
   '(((0 A) (1 D)) ((1 A) (1 B)) ((2 A) (2 J)) ((0 B) (2 E)) ((0 C) (0 E))
     ((1 C) (0 D)) ((2 C) (1 F)) ((2 D) (1 G)) ((1 E) (2 L)) ((0 F) (0 G))
     ((2 G) (1 H)) ((0 H) (0 I)) ((1 I) (1 J)) ((2 I) (1 K)) ((0 J) (1 L))
     ((0 K) (0 L))) ))

(glispobjects

(swcode   (list (code anything) (values (listof netvar))) )

(swsubnet (list (name symbol)))
    
; model instance
(minst (list (params gltype)
             (props (listof (cons (propname symbol)
                                  (values (listof (list (vname symbol)
                                                        (val anything)))) ))))
  msg ((prop (glambda (self (nm symbol))
                      (that props with propname == nm)))
       (propval (glambda (self (nm symbol))
                         (val (that (values (prop self nm))
                                    with vname == 'value))))
       (propsubp (glambda (self (nm symbol) (subnm symbol))
                          (val (that (values (prop self nm))
                                    with vname == subnm))))
       )
)
         

 ) ; glispobjects

; need ability to add/delete components of network

(gldefun makeswnet ((boxes (listof anything)) (conns (listof cpconn)))
  (let (nodes cps)
    (nodes = (for x in boxes collect
                  (case (first x)
                    (constant (a cpnode with  name = (second x)
                                              kind = 'constant
                                              params = (cdr x)))
   ; was (a netvar with name = (second x) val  = (third x))) )

                    (var (a cpnode with  name = (second x)
                                         kind = 'var
                                         params = (a netvar with
                                                    name = (second x))) )
                    (equation (a cpnode with  name = (second x)
                                              kind = 'equation
                                              params = (a neteqn with
                                                         equation = (third x))))
                    (eqnset   (a cpnode with  name = (second x)
                                              kind = 'eqnset
                                              params = (a neteqnset with
                                                        principle = (third x))))
                    (code     (a cpnode with  name = (second x)
                                              kind = 'code
                                              params = (a swcode with
                                                        code = (third x))))

                    ) ) )
    (cps = (a cpset  nodes = nodes  conns = conns
                     actfns = '((constant nil) (var netvarfn)
                                (equation neteqnfn) (eqnset neteqnsetfn)
                                (code swcodefn)  ) ))
    cps))

; 24 Apr 13
; node that is just a snippet of code, (lambda (vars) code)
(gldefun swcodefn ((cps cpset) (thisname symbol) (port symbol)
                   (subport symbol) (msg netval) (from symbol))
  (let (pair vars newcode (thisbox swcode))
    (thisbox = (params (node cps thisname)))
    (if *cpset-trace*
        (format t "Code ~A  var ~A is ~A~%" (code thisbox) port msg))
    (pair = (assoc port (values thisbox)))
    (if (or (null pair) (not (equal (val pair) msg)))
        (progn
          ((values thisbox) += (a netvar  name = port val = msg))
          (vars = (set-difference (cadr (code thisbox))
                                  (mapcar #'car (values thisbox)) ) )
          (if (null vars)   ; all vars defined
              (progn 
                (newcode = (sublisl (values thisbox) (caddr (code thisbox))))
                (newval = (eval newcode))
                ((values thisbox) += (a netvar  name = 'result
                                                val = newval))
                (if *cpset-trace*
                    (format t "   Solved for result = ~A~%" newval))
                (cpset-message cps thisname 'result nil newval
                               (list from))))))))
