; ctr.lsp                  Gordon S. Novak Jr.            ; 19 Sep 06

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 14 Sep 99; 15 Sep 99; 21 Sep 99; 23 Sep 99; 30 Sep 99; 07 Oct 99; 14 Oct 99
; 21 Oct 99; 26 Oct 99; 04 Nov 99; 09 Nov 99; 23 Dec 99; 03 Jan 00; 22 Feb 00
; 14 Sep 00; 24 Oct 00; 26 Oct 00; 02 Nov 00; 08 Feb 01; 22 Feb 01; 27 Feb 01
; 01 Mar 01; 19 Jan 04

(glispobjects

(counter (n integer)
  prop ((initial-value (0)))
  msg  ((init    ((n = (initial-value self))))
        (update  (glambda (self (other unused)) (n _+ 1)))
        (final   (n))))

(integer+ integer      ; define integer under addition as a monoid
  prop ((identity      (0))) )

(integer* integer
  prop ((identity      (1)))
  msg  ((+             (glambda (self z) (* self z)))) )

(number+ number        ; define number under addition as a monoid
  prop ((identity      (0))) )

(number* number
  prop ((identity      (1)))
  msg  ((+             (glambda (self z) (* self z)))) )

(real+ real            ; define real under addition as a monoid
  prop ((identity      (0))) )

(real* real
  prop ((identity      (1)))
  msg  ((+             (glambda (self z) (* self z)))) )

(boolean+ boolean
  prop ((identity      (nil))) )

(boolean* boolean
  prop ((identity      (t)))
  msg  ((+             (glambda (self z) (* self z)))) )

(adder (sum integer+)
  prop ((interfaces   ('(init update final)))
	(initial-value ((identity sum))) )
  msg  ((init         ((sum = (initial-value self))))
        (update       (glambda (self (item (typeof (sum self))))
                        ((sum self) = (+ (sum self) item))))
        (final        (sum))))

(adderb (sum integer+)
  prop ((interfaces   ('(init update final)))
	(initial-value ((identity sum)) result (typeof self)) )
  msg  ((init         ((sum = (initial-value self))))
        (update       (glambda (self item)
                        (if (funcall (test self) item)
			    ((sum self) =
			      (+ (sum self) (funcall (itemview self) item))))))
        (final        (sum))))

(multiplier (sum integer*)
  prop ((identity      (1)))
  supers (adder))

(multiplierb (sum integer*)
  prop ((identity      (1)))
  supers (adderb))

(orer (sum boolean+)
  prop ((identity      (nil)))
  supers (adder))

(ander (sum boolean*)
  prop ((identity      (t)))
  supers (adder))

(average (tuple (n integer) (sum number+))
  prop ((initial-value ((identity (sum self)))) )
  msg ((init    ((n = 0) (sum = (initial-value (sum self)))))
       (update  (glambda (self item)
		  (n _+ 1)
		  ((sum self) = (sum self) + item)))
       (final   ((if (> n 0)
		     (/ sum n)
		     (identity (sum self)))))))

(occurrences (ptr (listof anything))
  msg ((init    ((ptr = nil)))
       (update  (glambda (self item) (ptr +_ item)))
       (final   ((ptr = (nreverse ptr)) ptr))))

(avl-string-count-as-counter (w avl-string-count)
  prop   ((n  ((count w))))
  supers (counter))

(myavl (list (s string) (left (^ myavl)) (right (^ myavl)) (balance integer))
  prop  ((initial-value  (nil))
	 (accview        ('avl-tree)))
  viewspecs
     ((avl-tree avl-tree (left left)    (right right)
		         (sort-value s) (balance balance)))
  supers (find-update-accumulator) )

(myalistb (listof alistelement)
  prop  ((initial-value  (nil))
	 (entry          car))   ; for element type
  supers (alist-accumulator))

; 24 Oct 00; 27 Feb 01
(alistelement (list (key symbol))
  prop  ((updates        ('())) )
  msg   ((update (glambda (self value)
		   (for upd in (updates self) do (funcall upd self value))))
	 (init (glambda (self)
		 (for upd in (updates self) do (funcall upd init)))) )
  )

) ; glispobjects

; Make AVL-STRING-COUNT:
; (ap-make-carrier-type 'avl-tree '((contents string) (count integer)) 'lisp
;  'avl-string-count '((sort-value contents)))


; (nconc (glstr 'AVL-STRING-COUNT)
;    '(views ((counter counter AVL-STRING-COUNT-AS-COUNTER))) )

(gldefun t31 ((z AVL-STRING-COUNT)) (update (counter z)))

; using file addtype.lsp:
; (glclonetype 'myavl)
; (gladdtype 'myavl1 'counter)
(gldefun t32 ((z myavl1)) (update (counter z)))

; (glclonetype 'myavl)
; (gladdtype 'myavl2 'average)
(gldefun t33 ((z myavl2) (x real)) (update (average z) x))

; (glclonetype 'myavl)
; (gladdtype 'myavl3 'occurrences)
(gldefun t34 ((z myavl3) (x symbol)) (update (occurrences z) x))
(gldefun t35 ((s myavl3) (str string)) (member (avl-tree s) str))

; (glclonetype 'myavl)
; (gladdtype 'myavl4 'adder)
(gldefun t36 ((z myavl4) (v integer)) (update (adder z) v))

; (glclonetype 'myavl)
; (gladdtype 'myavl5 'multiplier)
(gldefun t37 ((z myavl5) (v integer)) (update (multiplier z) v))

; ALISTELEMENT1 is below, augmented by hand-written additions.
; (glclonetype 'alistelement)
; (gladdtype 'alistelement1 'counter)
; (gladdtype 'alistelement1 'adder)
(gldefun t38 ((z alistelement1) (v integer)) (update z v))
(gldefun t39 ((z alistelement2) (v integer)) (update z v))

(glispobjects

; 24 Oct 00
(ALISTELEMENT1 (LIST (KEY SYMBOL) (N4 INTEGER) (SUM1 INTEGER+))
 prop   ((updates      ('(upd-counter4 upd-adder1))) )
 msg    ((upd-counter4 (glambda (self value)
			 (if (pred4 self value)
			     (update (counter4 self) (false value)))))
	 (upd-adder1   (glambda (self value)
			 (if (pred1 self value)
			     (update (adder1 self) (valview1 self value)))))
	 (valview1     (glambda (self value) (+ value 2)))
         (pred1        true)
	 (pred4        (glambda (self value) (> value 0))) )
 VIEWS  ((COUNTER4 COUNTER COUNTER4)
	 (ADDER1 ADDER ADDER1))
 SUPERS (ALISTELEMENT))

(COUNTER4 (T21 ALISTELEMENT1)
 PROP   ((N       ((N4 T21))))
 msg    ((test    (glambda (self value) (> value 0)))
	 (valuefn false))
 SUPERS (COUNTER))

(ADDER1 (T22 ALISTELEMENT1)
 PROP   ((SUM ((SUM1 T22))))
 msg    ((test    true)
	 (valuefn (glambda (self value) (+ value 2))))
 SUPERS (ADDER))

; 08 Feb 01
; put the test and value view with each accumulator
(ALISTELEMENT2 (LIST (KEY SYMBOL) (N4 INTEGER) (SUM1 INTEGER+))
 prop   ((viewnames    ('(counter4 adder1))) )
 VIEWS  ((COUNTER4 COUNTER COUNTER4)
	 (ADDER1 ADDER ADDER1))
 SUPERS (multiaccum))

(multiaccum anything
  msg   ((update    (glambda (self value)
		      (for view in (viewnames self)
			(if (test (funcall view self) value)
			    (update (funcall view self)
				    (valuefn (funcall view self) value)))))))
 )

) ; glispobjects
