;  displ.lsp             Gordon S. Novak Jr.             ; 28 May 04

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

;  Programs to produce interactive graphical displays of data.
;  from {DSK}<LISPFILES>DISPL.CL;1 21-Jul-89 14:45:11 

; 02 Sep 91; 21 Dec 93; 08 Jun 94; 05 Jan 95; 02 Jan 97; 28 Feb 02; 08 Jan 04
; 03 Mar 04

; example use:  (wdis gsn)

(defvar *displ-windispman* nil)
(defvar *displ-window*     nil)
(defvar *displ-menu*       nil)
(defvar *displ-item-menu*  nil)
(defvar *displ-alldisps*   nil)
(defvar *displ-allwds*     nil)
(defvar *displ-activeflg*  nil)


(glispglobals
(*displ-windispman* windispman)
(*displ-window*     window)
(*displ-menu*       menu)
(*displ-item-menu*  menu)
(*displ-alldisps*   (listof (list (description string)
				  (display display))))
(*displ-allwds*     (listof (cons (wdname atom)
		                  (windispman windispman))))
(*displ-activeflg*  boolean)
  ) ; glispglobals


(glispobjects

(box-print-display
    (listobject (parameters
		  (list (offset-slot       display-parameter)
			(size-slot         display-parameter)
			(input-slot        display-parameter)
			(border-width-slot display-parameter))) )
default ((size (a vector with x = 100 y = 26))
	 (border-width-slot (a display-parameter with
			       slotname  = 'border-width
			       slotvalue = 1
			       slottype  = 'integer))
	 (input-slot (a display-parameter with slotname = 'input
			slottype = 'anything
			storable = t)))
prop    ((border-width ((slotvalue border-width-slot)) result integer))
msg     ((draw          box-print-display-draw)
	 (estimate-size box-print-display-estimate-size))
supers  (display))


(circle-display
   (listobject (parameters
		 (list (offset-slot       display-parameter)
		       (size-slot         display-parameter)
		       (radius-slot       display-parameter)
		       (center-slot       display-parameter)
		       (border-width-slot display-parameter))) )
default ((size (a vector with x = 50 y = 50))
	 (radius-slot (a display-parameter with slotname = 'radius
			 slotvalue = 5 slottype = 'integer))
	 (center-slot (a display-parameter with slotname = 'input
			 slottype = 'vector
			 storable = t))
	 (border-width-slot (a display-parameter with
			       slotname = 'border-width
			       slotvalue = 1 slottype = 'integer)))
prop    ((radius        ((slotvalue radius-slot)) result integer)
	 (input         (radius))
	 (center        ((slotvalue center-slot)) result vector)
	 (radius-viewer ((viewer radius-slot))    result gltype)
	 (center-viewer ((viewer center-slot))    result gltype)
	 (border-width  ((slotvalue border-width-slot)) result integer))
msg     ((draw circle-display-draw)
	 (estimate-size circle-display-estimate-size))
supers  (display))


(composite-display
    (listobject (parameters
		  (list (offset-slot       display-parameter)
			(size-slot         display-parameter)
			(input-slot        display-parameter)
			(border-width-slot display-parameter) ))
		(subdisplays (listof display)))
default ((border-width-slot (a display-parameter with
			       slotname  = 'border-width
			       slotvalue = 1
			       slottype  = 'integer))
	 (input-slot (a display-parameter with slotname = 'input
			slottype = 'anything
			storable = t)))
prop    ((border-width ((slotvalue border-width-slot)) result integer))
msg     ((draw          composite-display-draw)
	 (move          composite-display-move)
	 (move-delta    composite-display-move-delta)
	 (shape         error)
	 (estimate-size composite-display-estimate-size))
supers  (display))


(display (listobject  (parameters (listof display-parameter)) )
default ((input-slot  (a display-parameter with slotname = 'input))
	 (offset-slot (a display-parameter with slotname = 'offset
			 slottype = 'vector))
	 (size-slot   (a display-parameter with slotname = 'size
		         slottype = 'vector)) )
prop    ((input       ((slotvalue input-slot)))
	 (viewer      ((viewer input-slot)))
         (offset      ((slotvalue offset-slot))    result vector)
         (size        ((slotvalue size-slot))      result vector)
	 (input-slot  ((assoc 'input  parameters)) result display-parameter)
	 (offset-slot ((assoc 'offset parameters)) result display-parameter)
	 (size-slot   ((assoc 'size   parameters)) result display-parameter) )
msg     ((erase         display-erase message t)
	 (mouse         display-mouse message t)
	 (update        display-update message t)
	 (contains?     (glambda (self (p vector))
			     (contains? (view self 'box) p)))
	 (abstract      display-abstract specialize t message t)
	 (move          display-move)
	 (shape         display-shape)
	 (view-slots    display-view-slots)
	 (estimate-size display-estimate-size message t)
	 (move-delta    display-move-delta)
	 (move-box      display-move-box) )
views   ((box region (start (offset)) (size (size)))))


(display-parameter (list (slotname atom)
			 (slotvalue anything)
			 (slottype gltype)
			 (storable atom)
			 (viewer anything))
msg     ((view   display-parameter-view)
	 (view\:  display-parameter-view-back)))


(print-display
   (listobject (parameters (list (offset-slot       display-parameter)
				 (size-slot         display-parameter)
				 (input-slot        display-parameter))) )
default ((size          (a vector with x = 100 y = 20))
	 (input-slot    (a display-parameter with slotname = 'input
			   slottype = 'anything storable = t)))
prop    ((input         ((slotvalue input-slot)) result vector)
	 (viewer        ((viewer input-slot)) result gltype))
msg     ((draw          print-display-draw)
	 (estimate-size print-display-estimate-size))
supers  (display))


(vector-display
   (listobject (parameters (list (offset-slot       display-parameter)
				 (size-slot         display-parameter)
				 (input-slot display-parameter)
				 (width-slot display-parameter))))
default ((size          (a vector with x = 50 y = 50))
	 (input-slot    (a display-parameter with slotname = 'input
			   slottype = 'vector storable = t))
	 (width-slot    (a display-parameter with slotname = 'width
			   slotvalue = 1 slottype = 'integer)))
prop    ((input         ((slotvalue input-slot)) result vector)
	 (viewer        ((viewer input-slot))    result gltype)
	 (width         ((slotvalue width-slot)) result integer))
msg     ((update        vector-display-update)
	 (draw          vector-display-draw)
	 (erase         vector-display-erase)
	 (mouse         vector-display-mouse)
	 (estimate-size vector-display-estimate-size))
supers  (display))


(windispman (listobject (name       symbol)
			(window     window)
			(offset     vector)
			(size       vector)
			(source     anything)
			(sourcetype gltype)
			(displays   (listof display)))
prop    ((minsize  windispman-minsize))
msg     ((repaint  windispman-repaint)
	 (create   windispman-create)
	 (abstract windispman-abstract)
	 (add-item windispman-add-item)
	 (delete   windispman-delete)))


;  Some example views of a person

; (pasvc (person person)          ; old version -- save as example of view fn
; prop  ((view ((view person
; 	       '(vector (x ((truncate (area (phone person)) 4)))
; 			(y ((truncate (area (home-phone person)) 5)))))))
;        (x ((x view)))
;        (y ((y view)))))

(pasvc (p person)
  prop ((x ((truncate (area (phone p)) 4)))
	(y ((truncate (area (home-phone p)) 5))) )
  msg  ((materialize ((a vector x (x self) y (y self))))) )

(pname (p person)
  prop  ((materialize ((name p)))))

(ppa   (p person)
  prop  ((materialize ((area (phone p))))))

(psal  (p person)
  prop  ((materialize ((truncate (salary p) 1000)))))

) ; glispobjects


; Message send where args are evaluated
; 10 Aug 89
(defmacro glsendcvm (obj class selector &rest args)
  `(glsendb ,obj ,class ,selector 'msg ,@args))

; 28 July 89
(defun askusr (msg) (princ msg) (princ " ") (read))

;  2-Jun-89
(gldefun box-print-display-draw ((self box-print-display) data (w window))
  (let (str)
    (if (input self) (erase self w))
    (draw-box w (offset self) (size self) (border-width self))
    (view-slots self data)
    (str = (gevstringify (input self)))
    (printat-xy w str
		((x (offset self)) + (truncate ((x (size self))
						- (glsend w string-width str))
					       2))
		((y (offset self)) + (truncate (y (size self)) 2) - 5) ) ))

;  9-Jun-89
(gldefun box-print-display-estimate-size ((d box-print-display) (w window))
  (a vector with
     x = (string-width w (gevstringify (input d)))
         + (border-width d) * 2 + 16
     y = (border-width d) * 2 + 26))

;  2-Jun-89
(gldefun circle-display-draw ((self circle-display) data (w window))
  (if (radius self) (erase self w))
  (view-slots self data)
  (draw-circle-xy w
		  ((x (offset self)) + (x (center self)))
		  ((y (offset self)) + (y (center self)))
		  (radius self)
		  (border-width self)) )

;  26 Sept 89
(gldefun circle-display-estimate-size ((d circle-display) (w window))
  (a vector with x = (x (center d)) + (radius d) + (border-width d) + 10
                 y = (y (center d)) + (radius d) + (border-width d) + 10 ))

(gldefun composite-display-draw ((self composite-display) data (w window)))

; 21 Dec 90
(gldefun composite-display-move ((d composite-display) data (w window))
  (let (orig delta)
    (orig = (offset d))
    (display-move-box d data w)
    (delta = (- (offset d) orig))
    (for s in (subdisplays d) do (move-delta d data w delta)) ))

; 21 Dec 90
(gldefun composite-display-move-delta
         ((d composite-display) data (w window) (delta vector))
  (erase d w)
  ((offset d) _+ delta)
  (glsend d draw data w)
  (for s in (subdisplays d) do (move-delta d data w delta)) )

; 21 Dec 90
(gldefun composite-display-estimate-size ((self composite-display) (w window))
  (let ((maxv vector) (base (offset self)) )
    (maxv = (a vector with x = 0 y = 0))
    (for s in (subdisplays d) do
	 (maxv = (max maxv ((offset s) - base) + (size s))) )
    maxv ))

;  6-Jun-89
(defun displ-add-colon (name)
  (intern (concatenate 'string (symbol-name name) ":")) )

; 19 Dec 90
(defun displ-prompt (str) (format t str))

;  6-Jun-89; 17 Dec 90; 08 Jan 04
; Make a menu to get properties of object OBJ 
(gldefun displ-propmenu (typeinflg slotname datanames propnames views)
  (prog (pnames menu)
    (if ~(datanames or propnames or views or typeinflg)
        (return))
    (if datanames
	(pnames = (cons (list "Data:") (mapcar #'car datanames))))
    (if propnames
	(pnames = (nconc pnames (list (list "Properties:"))
			          (mapcar #'car propnames))))
    (if views
	(pnames = (nconc pnames (list (list "Views:"))
			          (mapcar #'car views))))
    (if typeinflg (pnames = (cons '("TypeIn" . typein) pnames)))
    (return (select! (a menu with items = 
		     (cons (cons (concatenate 'string
					      "for slot "
					      (symbol-name slotname))
				 nil)
			   (cons '("New View" . newview) pnames)))) ) ))

(defun displ-typein () (princ "Enter value: ") (read))

(defun displ-window () (or *displ-window* (displ-initeditwindow)) )

;  8-Jun-89; 08 Jan 04
(gldefun display-abstract ((d display))
  (let ((dp display))
    (dp = (copy-tree d))
    (for p in (parameters dp) do
	 (if ~(constantp (slotvalue p)) ((slotvalue p) = nil)))
    dp))

;  1-Jun-89
; Command to a display 
(gldefun display-command ((self display) (wd windispman) data (w window))
  (case (glsend *displ-item-menu* select) 
        (delete    (erase self w)
		   (delete wd self))
	(move      (move self data w))
	(shape     (shape self data w))
	(redisplay (erase self w)
		   (glsend self draw data w))))

; 31-May-89
(gldefun display-erase ((self display) (w window))
  (erase-area w (offset self) (size self)))

;  9-Jun-89
(gldefun display-estimate-size ((d display))  (size d))

; 26 Sep 89; 19 Dec 90; 24 Jul 91; 28 Feb 02; 08 Jan 04
(gldefun display-mouse ((self display) (pos consv) data (w window))
  (let (sel slot new changed)
    (displ-prompt "Specify slot to change")
    (sel = (select (a menu with items =
		       (for p in (parameters self) collect (slotname p))) ))
    (if sel
	(progn
	(slot = (that parameter of self with slotname = sel))
        (new = (askusr (format nil
				 "Specify new value for slot ~A of type ~A:"
				 sel (slottype slot))))
	(if ~ (equal new (slotvalue slot))
	    (if (sel == 'input)
		(progn (changed = t)
		       (glsendv self 'update new data w))
		(progn (erase self w)
		       ((slotvalue slot) = new)
		       (draw self data w))))))
    changed))

;  1-Jun-89
(gldefun display-move ((d display) data (w window))
  (let (newp)
    (newp = (displ-getboxposition (width (box d)) (height (box d))
				    (left (box d))  (bottom (box d))
				    w "Specify new position"))
    (erase d w)
    ((offset d) = (a vector with x = (max 0 (x newp))
		                   y = (max 0 (y newp))))
    (glsend d draw data w)))

; 21 Dec 90
(gldefun display-move-box ((d display) data (w window))
  (let (newp)
    (newp = (displ-getboxposition (width (box d)) (height (box d))
				    (left (box d))  (bottom (box d))
				    w "Specify new position"))
    ((offset d) = (a vector with x = (max 0 (x newp))
		                   y = (max 0 (y newp)))) ))

(gldefun display-move-delta ((d display) data (w window) (delta vector))
  (erase d w)
  ((offset d) _+ delta)
  (glsend d draw data w))

; 6-Jun-89; 20 Dec 93; 28 Feb 02
(gldefun display-parameter-find-view ((source gltype) (p display-parameter))
  (let ((views (listof glviewentry)) (goaltype (slottype p))
		datanames propnames sel tmp result typeinflg vw viewname)
    (datanames = (subset #'(lambda (x) (or (eq goaltype 'anything)
					     (eq (cadr x) goaltype)))
			   (gevdatanames source t) ))
    (propnames = (subset #'(lambda (x) (or (eq goaltype 'anything)
					     (eq (cadr x) goaltype)))
			   (gevpropnames source 'prop t)) )
    (views = (subset #'(lambda (x) (or (eq goaltype 'anything)
					     (eq (cadr x) goaltype)))
		       (glget source 'views)))
    (format t "Specify source for parameter ~A of type ~A~%"
	      (slotname p) goaltype)
    (typeinflg = (and (goaltype <> 'anything)
			(member goaltype *glbasictypes*)))
    (if (or datanames propnames views typeinflg)
	(sel = (displ-propmenu typeinflg (slotname p)
				 datanames propnames views)))
    (if sel
            (if sel == 'typein
		((slotvalue p) = (displ-typein))
		(if sel == 'newview
		    ((slotvalue p) = nil)
		    (if (tmp = (or (assoc sel datanames)
				   (assoc sel propnames)))
			(progn ((storable p) = (displ-add-colon (car tmp)))
			       ((viewer p) = (list (car tmp) source)))
	                (if (tmp = (assoc sel views))
			    (progn ((storable p) = (displ-add-colon (car tmp)))
				   ((viewer p) = (list (car tmp) source))))))))
    (if ~((viewer p) or (slotvalue p))
        (if (vw = (makev goaltype source))
	    (progn (if (find goaltype (glget source 'views) :key #'cadr)
		       (viewname = (askusr "Specify name of new view:")))
		   (mkvb goaltype source vw viewname
			    (eqns-solved-equations *makev-eqns-set*)
			    (eqns-defined-vars *makev-eqns-set*))
		   ((viewer p) = (or viewname goaltype)) ) ) )))

;  5-Jun-89; 21 Dec 93; 08 Jan 04
(gldefun display-parameter-view ((p display-parameter) data)
  (let ((v (viewer p)))
    (if v
          ((slotvalue p) = (if (consp v)      ; class    selector
				 (glsendb data (cadr v) (car v) 'msg)
			        (glsendb data v 'materialize 'msg))))))
;  5-Jun-89; 21 Dec 93; 08 Jan 04
(gldefun display-parameter-view-back ((p display-parameter) data newitem)
  (let ((v (viewer p)))
    ((slotvalue p) = newitem)
    (if v (if (consp v)      ; class    selector
		 (glsendb data (cadr v) (storable p) 'msg newitem)
		 (glsendb data v 'glbuildfromview 'msg newitem)))))

;  09 Aug 89
(gldefun display-shape ((d display) data (w window))
  (let (newr)
    (newr = (displ-getregion (width (box d))
			       (height (box d))
			       (left (box d))
			       (bottom (box d))
			       w
			       "Specify new box"))		      
     (erase d w)
     ((offset d) = (start newr))
     ((size d) = (size newr))
     (glsend d draw data w) ))

;  2-Jun-89
(gldefun display-update ((self display) newitem data (w window))
  (if (input self) (erase self w))
  (glsend (input-slot self) (view  data) newitem)
  (glsend self draw data w))

;  2-Jun-89
(gldefun display-view-slots ((d display) data)
  (for p in (parameters d) do (glsend p view data)))

;  2-Jun-89
; Warning: Calling DISPLAY-PARAMETER-VIEW-BACK with wrong number of args *****
(gldefun display-view-slots-back ((d display) data)
  (for p in (parameters d) do (glsend p (view  data))))

;  2-Jun-89
(gldefun print-display-draw ((self print-display) data (w window))
  (if (input self) (erase self w))
  (glsend self view-slots data)
  (printat-xy w (input self) ((x (offset self)) + 2) ((y (offset self)) + 2)) )

;  9-Jun-89
(gldefun print-display-estimate-size ((d print-display) (w window))
  (a vector with x = (string-width w (gevstringify (input d))) + 16
                 y = 26))

; 2-Jun-89; 20 Dec 93
(gldefun vector-display-draw ((self vector-display) data (w window))
  (if (input self) (erase self w))
  (view-slots self data)
  (draw-line-xy w (x (offset self)) (y (offset self))
		  ((x (input self)) + (x (offset self)))
		  ((y (input self)) + (y (offset self)))
		  (width self)) )

; 30-May-89
(gldefun vector-display-erase ((self vector-display) (w window))
  (draw-line-xy w (x (offset self)) (y (offset self))
	          ((x (input self)) + (x (offset self)))
		  ((y (input self)) + (y (offset self)))
		  (width self)
		  'erase) )

(gldefun vector-display-estimate-size ((d vector-display) (w window))
  (a vector with x = (x (input d)) + (width d) + 10
                 y = (y (input d)) + (width d) + 10))

; 09 Aug 89; 18 Dec 90; 28 Feb 02
(gldefun vector-display-mouse
	 ((self vector-display) (pos consv) data (w window))
  (let ((newpos vector) newx newy changed (xoff (x (offset self)))
	       (yoff (y (offset self))) lastx lasty)
    (lastx = (x (input self)) + xoff)
    (lasty = (y (input self)) + yoff)
    (track-mouse window
      #'(lambda (x y code)
	  (if ((x <> lastx) or (y <> lasty))
	      (progn
		(window-draw-line-xy window xoff yoff lastx lasty 1 'xor)
		(window-draw-line-xy window xoff yoff x     y     1 'xor)
		(lastx = x)
		(lasty = y)))
	  (code <> 0)))
    (newx = lastx - xoff)
    (newy = lasty - yoff)
    (unless ((newx == (x (input self))) and
	     (newy == (y (input self))))
	    (changed = t)
	    (update self (a vector with x = newx y = newy)
		    data w))
    changed))

; 30-May-89
(gldefun vector-display-update ((self vector-display) (v vector) data (w window))
  (if (input self) (erase self w))
  ((input self) = v)
  (glsendcvm data (viewer self) '(x  (x v)))
  (glsendcvm data (viewer self) '(y  (y v)))
  (draw self data w))

;  9-Jun-89; 07 Jun 94; 28 Feb 02; 08 Jan 04; 03 Mar 04
; Display an object with a window display. 
(gldefun wdis (object)
  (prog (type (wdd windispman) wdnames wdnm)
    (type = (glclass object) or (askusr "Type of this object?"))
    (wdnames = (for d in *displ-allwds*
		      when ((sourcetype (windispman d)) == type)
		      collect (wdname d)))
    (if ~wdnames
	(progn (princ "No displays for this type") (terpri) (return))
	(if (cdr wdnames)
	    (wdnm = (glsend (a menu with items = wdnames) select))
	    (wdnm = (car wdnames))))
    (wdd = (copy-tree (car (for d in *displ-allwds*
				  when (wdnm == (wdname d))
				  collect (windispman d)))))
    (setq *displ-windispman* (glsend wdd create object (displ-window)))
    (setq *displ-activeflg* t)
    (open *displ-window*)
    (displ-mouseloop)
   ))

; 12-Jun-89; 08 Jan 04
; Make a WINDISPMAN that is an abstraction of the given one, i.e., has 
; no window or data specified. 
(gldefun windispman-abstract ((wd windispman))
  (prog (wda entry nm)
    (nm = (case (select! (a menu with items =
			     '(("Quit" . quit)
			       ("Update this display" . update)
			       ("Save new display type" . new)))  )
	      (quit (return))
	      (update (name wd))
	      (new (askusr "Name of this display?"))))
    (wda = (a windispman with  name   = nm  window = nil
		offset = (a vector with x = (left (window wd))
			                y = (bottom (window wd)))
		size = (minsize wd)
		source = nil
		sourcetype = (sourcetype wd)
		displays = (for d in (displays wd)
				collect (glsend d abstract))))
    (if (entry = (assoc (name wda) *displ-allwds*))
        ((cdr entry) = wda)
        (*displ-allwds* _+ (cons (name wda) wda)))))


;  5-Jun-89; 17 Dec 90; 20 Dec 90; 08 Jan 04
; Add a display item to a display. 
(gldefun windispman-add-item ((wd windispman))
  (prog (displaytype (d display) sel)
	(if ~(displaytype = (first (select (a menu with
					        items = *displ-alldisps*) )))
	     (return))
	(d = (glmkstr (glgetstr displaytype)
			displaytype
			(glgetdefaults displaytype nil)
			nil))
	(for p in (parameters d) do
	     (if (slotvalue p)
		 (progn
		   (sel = (select! (a menu with items =
				      (list (cons (concatenate
						   'string
						   "for slot "
						   (symbol-name (slotname p)))
						  nil)
					    '("Use default value" . default)
					    '("Get new value" . new))) ))
		   (case sel
		       (typein ((slotvalue p) = (displ-typein)) )
		       (new (display-parameter-find-view
			      (sourcetype wd) p))))
		 (display-parameter-find-view (sourcetype wd) p) )
	     (if ((viewer p) and (source wd))
		 (glsend p view (source wd))))
	((size d) = (estimate-size d (window wd)))
	((displays wd) _+ d)
	(move d (source wd) (window wd)) ))


;  04 Aug 89; 24 Jul 91; 02 Sep 91; 28 Feb 02; 08 Jan 04
; PROCESS A MOUSE CLICK IN A WINDOW 
(gldefun windispman-buttoneventfn ((w window) event (mousex integer)
					     (mousey integer))
  (prog (mp dm (wd windispman) (xm mousex) (ym mousey))
    (setq wd *displ-windispman*)
    (mp = (a vector with x = mousex y = mousey))
    (if (    (xm < 4) or (xm > (width w) - 4)           ; ****** ?
          or (ym < 4) or (ym > (height w) - 10))
        (dowindowcom w)
	(if (dm = (that display of wd with 
		            (contains? (that display) mp)))
	    (if (event == 1)             ; left mouse button
		(if (mouse dm mp (source wd) w)
		    (repaint wd))
	        (display-command dm wd (source wd) w)))
	    (windispman-command wd))))


;  04 Aug 89
; Command to a window display manager 
(gldefun windispman-command ((wd windispman))
  (case (select *displ-menu*)
	(quit      (setq *displ-activeflg* nil))
	(redisplay (repaint wd))
	(add-item  (add-item wd))
	(abstract  (abstract wd))))


; 29-May-89
(gldefun windispman-create ((wds windispman) (data anything) (w window))
  (let ((wd windispman))
    (wd = (copy-tree wds))
    ((window wd) =
        (or w (error "no window")))
    ((source wd) = data)
    (repaint wd)
    wd))


;  1-Jun-89
(gldefun windispman-delete ((wd windispman) (d display))
  ((displays wd) _- d))


; 12-Jun-89
(gldefun windispman-minsize ((wd windispman))
  (let ((xsize 0) (ysize 0) (est vector))
    (for d in (displays wd) do
	 (est   = (glsend d estimate-size (window wd)))
	 (xsize = (max xsize (x (offset d)) + (x est)))
	 (ysize = (max ysize (y (offset d)) + (y est))))
    (a vector with x = xsize + 8   y = ysize + 8)))


; 30-May-89
(gldefun windispman-repaint ((wd windispman))
  (clear (window wd))
  (for d in (displays wd)
       (glsend d draw (source wd) (window wd))))


(setq *displ-alldisps* '(("Print in box" box-print-display)
			 ("Circle"       circle-display)
			 ("Print"        print-display)
			 ("Vector"       vector-display)))

(setq *displ-allwds*
  '((pdsp windispman pdsp nil (0 0) (257 254) nil person
	  ((vector-display ((offset (0 0) vector nil nil)
			    (size  (50 50)  vector nil nil)
			    (input nil vector t pasvc)
			    (width 1 integer nil nil)) )
	   (print-display ((offset (28 232) vector nil nil)
			   (size   (156 20) vector nil nil)
			   (input nil anything t pname)) )
	   (print-display ((offset (209 201) vector nil nil)
			   (size  (28 20)  vector nil nil)
			   (input nil anything t ppa)) )
	   (box-print-display ((offset (112 56) vector nil nil)
			       (size  (32 26) vector nil nil)
			       (input nil anything t ppa)
			       (border-width 1 integer nil nil)) )
	   (circle-display ((offset (0 0) vector nil nil)
			    (size   (36 14) vector nil nil)
			    (radius nil integer nil psal)
			    (input nil vector t pasvc)
			    (border-width 1 integer nil nil)) )
	   (box-print-display ((offset (107 166) vector nil nil)
			       (size   (70 26) vector nil nil)
			       (input nil number (salary  (salary person)))
			       (border-width 1 integer nil nil)) )
	   (box-print-display ((offset (225 43) vector nil nil)
			       (size   (24 26) vector nil nil)
			       (input nil anything (age  (age person)))
			       (border-width 1 integer nil nil)) )
	   (box-print-display ((offset (154 101) vector nil nil)
			       (size   (88 26) vector nil nil)
			       (input nil anything (ssno  (ssno person)))
			       (border-width 1 integer nil nil)) ) ) )) )

