; 14 Jan 2008 17:06:14 EST

(PROCLAIM
    '(SPECIAL *GEVMOUSEAREA* *GEVWINDOW* *GEVACTIVEFLG* *GEVMENU*
              *GEVMENUWINDOW* *GEVEDITCHAIN*))

(SETQ *GEVMENUWINDOW* NIL)

(SETQ *GEVWINDOW* NIL)

(DEFVAR WINDOWCHARWIDTH 9)

(DEFVAR GEVNAMEPOS 3)

(SETF (GET 'GEVNUMBERCHARS 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVNUMBERCHARS 'GLISPORIGCONSTVAL) 0)
(SETF (GET 'GEVNUMBERCHARS 'GLISPCONSTANTVAL) 0)
(SETQ GEVNUMBERCHARS 0)
(SETF (GET 'GEVNUMBERCHARS 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'GEVNUMBERPOS 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVNUMBERPOS 'GLISPORIGCONSTVAL) 3)
(SETF (GET 'GEVNUMBERPOS 'GLISPCONSTANTVAL) 3)
(SETQ GEVNUMBERPOS 3)
(SETF (GET 'GEVNUMBERPOS 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'GEVWINDOWTOPMARGIN 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVWINDOWTOPMARGIN 'GLISPORIGCONSTVAL) 12)
(SETF (GET 'GEVWINDOWTOPMARGIN 'GLISPCONSTANTVAL) 12)
(SETQ GEVWINDOWTOPMARGIN 12)
(SETF (GET 'GEVWINDOWTOPMARGIN 'GLISPCONSTANTTYPE) 'INTEGER)


(DEFVAR *GEVWINDOW*)
(SETF (GET '*GEVWINDOW* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVWINDOW* 'GLISPGLOBALVARTYPE) 'WINDOW)


(DEFUN GEVAPPLY (FN ARGS) (APPLY FN ARGS))

(DEFUN GEVBUTTONEVENTFN (W MOUSEEVENT MOUSEX MOUSEY)
  (PROG (POS SELECTION)
    (IF (AND (< MOUSEX 12) (< MOUSEY (+ -12 (CADDDR W))))
        (RETURN (DOWINDOWCOM W)))
    (SETQ POS (LIST MOUSEX MOUSEY))
    (IF (SETQ SELECTION (GEVFINDPOS POS (CAR *GEVEDITCHAIN*)))
        (GEVITEMEVENTFN (CADR SELECTION) (CADDDR SELECTION)
            (CADDR SELECTION)))))

(DEFUN GEVCONCAT (L)
  (REDUCE #'(LAMBDA (X Y) (CONCATENATE 'STRING X Y)) L))

(DEFUN GEVENTER ())

(DEFUN GEVEXIT () (WINDOW-CLOSE *GEVWINDOW*))

(DEFUN GEVINITEDITWINDOW ()
  (SETQ *GEVWINDOW* (WINDOW-CREATE 350 500 "GEV" NIL 0 0))
  (SETQ *GEVMOUSEAREA* NIL)
  (SETQ *GEVMENU*
        (MENU-CREATE '(QUIT POP EDIT PROGRAM PROP ADJ ISA MSG) "GEV"
            *GEVWINDOW* 270 10))
  *GEVWINDOW*)
(SETF (GET 'GEVINITEDITWINDOW 'GLARGUMENTS) 'NIL)
(SETF (GET 'GEVINITEDITWINDOW 'GLFNRESULTTYPE) 'WINDOW)


(DEFUN GEVMOUSELOOP ()
  (PROG (EVENT MOUSEX MOUSEY POINT)
    LP
    (SETQ POINT (GEV-GET-POINT *GEVWINDOW*))
    (SETQ EVENT (CADDR POINT))
    (SETQ MOUSEX (CAR POINT))
    (SETQ MOUSEY (CADR POINT))
    (IF (EQ EVENT 3) (GEVCOMMANDFN (GLSEND *GEVMENU* SELECT))
        (GEVBUTTONEVENTFN *GEVWINDOW* EVENT MOUSEX MOUSEY))
    (IF *GEVACTIVEFLG* (GO LP))))

(DEFUN GEVPUTD (FN DEF) (SETF (GLORIGINALEXPR FN) DEF))

(DEFUN GEVENTERPRINT () NIL)

(DEFUN GEVEXITPRINT () NIL)

(DEFUN GEVARGLIST (FN)
  (LET ((DEF (SOURCE-CODE FN)))
    (IF (EQ (CAR DEF) 'LAMBDA) (CADR DEF)
        (PROGN (GLCC FN) (CADR (SOURCE-CODE FN))))))

(DEFUN GEV-GET-POINT (W)
  (LET (ORGX ORGY BUTTON)
    (WINDOW-TRACK-MOUSE W
        #'(LAMBDA (X Y CODE)
            (WHEN (NOT (ZEROP CODE))
              (SETQ BUTTON CODE)
              (SETQ ORGX X)
              (SETQ ORGY Y))))
    (LIST ORGX ORGY BUTTON)))

(DEFUN COMPILE-GEV ()
  (GLCOMPFILES *DIRECTORY* '("glisp/vector.lsp" "X/dwindow.lsp")
      '("glisp/gevaux.lsp" "glisp/gevtype.lsp" "glisp/gev.lsp")
      "glisp/gevtrans.lsp")
  (CF GEVTRANS))

(DEFUN INTTOHEX (N)
  (LET ((NCHARS 8) STR)
    (SETQ STR (MAKE-STRING NCHARS))
    (DOTIMES (I NCHARS)
      (SETF (SCHAR STR (- (1- NCHARS) I))
            (SCHAR (CAR (NTHCDR (LOGAND N 15)
                                '("0" "1" "2" "3" "4" "5" "6" "7" "8"
                                  "9" "A" "B" "C" "D" "E" "F")))
                   0))
      (SETQ N (ASH N -4)))
    STR))

(DEFUN INTTOINIT ()
  (GLADDTOOBJECTS
      (INTEGER PROP
               ((WORDSIZE (32)) (OCTAL INTTOOCTAL RESULT STRING)
                (OCTAL3 INTTOOCTAL3 RESULT STRING)
                (HEX INTTOHEX RESULT STRING)
                (DISPLAYPROPS ('(OCTAL HEX)))))))

(DEFUN INTTOOCTAL (N)
  (LET ((NCHARS 11) STR)
    (SETQ STR (MAKE-STRING NCHARS))
    (DOTIMES (I NCHARS)
      (SETF (SCHAR STR (- (1- NCHARS) I))
            (SCHAR (CAR (NTHCDR (LOGAND N 7)
                                '("0" "1" "2" "3" "4" "5" "6" "7")))
                   0))
      (SETQ N (ASH N -3)))
    STR))

(DEFUN INTTOOCTAL3 (N)
  (LET ((NCHARS 3) STR)
    (SETQ STR (MAKE-STRING NCHARS))
    (DOTIMES (I NCHARS)
      (SETF (SCHAR STR (- (1- NCHARS) I))
            (SCHAR (CAR (NTHCDR (LOGAND N 7)
                                '("0" "1" "2" "3" "4" "5" "6" "7")))
                   0))
      (SETQ N (ASH N -3)))
    STR))

(INTTOINIT)

(PROCLAIM
    '(SPECIAL *GLNATOM* *GEVMATCHRESULT* *GLLISPDIALECT*
              *GLUSERSTRNAMES* *GEVACTIVEFLG* *GEVEDITCHAIN*
              *GEVEDITFLG* *GEVLASTITEMNUMBER* *GEVMENUWINDOW*
              *GEVMENUWINDOWHEIGHT* *GEVMOUSEAREA* *GEVSHORTCHARS*
              *GEVWINDOW* *GEVWINDOWY* *GEVGLOBALY* *GEVUSERTYPENAMES*))

(DEFVAR *GEVGLOBALY* 0)

(DEFVAR *GEVACTIVEFLG*)
(SETF (GET '*GEVACTIVEFLG* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVACTIVEFLG* 'GLISPGLOBALVARTYPE) 'BOOLEAN)
(DEFVAR *GEVEDITCHAIN*)
(SETF (GET '*GEVEDITCHAIN* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVEDITCHAIN* 'GLISPGLOBALVARTYPE) 'EDITCHAIN)
(DEFVAR *GEVEDITFLG*)
(SETF (GET '*GEVEDITFLG* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVEDITFLG* 'GLISPGLOBALVARTYPE) 'BOOLEAN)
(DEFVAR *GEVLASTITEMNUMBER*)
(SETF (GET '*GEVLASTITEMNUMBER* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVLASTITEMNUMBER* 'GLISPGLOBALVARTYPE) 'INTEGER)
(DEFVAR *GEVMENUWINDOW*)
(SETF (GET '*GEVMENUWINDOW* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVMENUWINDOW* 'GLISPGLOBALVARTYPE) 'WINDOW)
(DEFVAR *GEVMENUWINDOWHEIGHT*)
(SETF (GET '*GEVMENUWINDOWHEIGHT* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVMENUWINDOWHEIGHT* 'GLISPGLOBALVARTYPE) 'INTEGER)
(DEFVAR *GEVMOUSEAREA*)
(SETF (GET '*GEVMOUSEAREA* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVMOUSEAREA* 'GLISPGLOBALVARTYPE) 'MOUSESTATE)
(DEFVAR *GEVSHORTCHARS*)
(SETF (GET '*GEVSHORTCHARS* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVSHORTCHARS* 'GLISPGLOBALVARTYPE) 'INTEGER)
(DEFVAR *GEVWINDOW*)
(SETF (GET '*GEVWINDOW* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVWINDOW* 'GLISPGLOBALVARTYPE) 'WINDOW)
(DEFVAR *GEVGLOBALY*)
(SETF (GET '*GEVGLOBALY* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVGLOBALY* 'GLISPGLOBALVARTYPE) 'INTEGER)
(DEFVAR *GEVWINDOWY*)
(SETF (GET '*GEVWINDOWY* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVWINDOWY* 'GLISPGLOBALVARTYPE) 'INTEGER)
(DEFVAR *GEVMATCHRESULT*)
(SETF (GET '*GEVMATCHRESULT* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVMATCHRESULT* 'GLISPGLOBALVARTYPE) 'ANYTHING)
(DEFVAR *GEVUSERTYPENAMES*)
(SETF (GET '*GEVUSERTYPENAMES* 'GLISPGLOBALVAR) T)
(SETF (GET '*GEVUSERTYPENAMES* 'GLISPGLOBALVARTYPE) '(LISTOF SYMBOL))


(SETF (GET 'GEVMOUSEBUTTON 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVMOUSEBUTTON 'GLISPORIGCONSTVAL) 4)
(SETF (GET 'GEVMOUSEBUTTON 'GLISPCONSTANTVAL) 4)
(SETQ GEVMOUSEBUTTON 4)
(SETF (GET 'GEVMOUSEBUTTON 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'GEVNAMECHARS 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVNAMECHARS 'GLISPORIGCONSTVAL) 11)
(SETF (GET 'GEVNAMECHARS 'GLISPCONSTANTVAL) 11)
(SETQ GEVNAMECHARS 11)
(SETF (GET 'GEVNAMECHARS 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'GEVVALUECHARS 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVVALUECHARS 'GLISPORIGCONSTVAL) 27)
(SETF (GET 'GEVVALUECHARS 'GLISPCONSTANTVAL) 27)
(SETQ GEVVALUECHARS 27)
(SETF (GET 'GEVVALUECHARS 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'GEVNAMEPOS 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVNAMEPOS 'GLISPORIGCONSTVAL)
      '(+ GEVNUMBERPOS
          (COND
            ((> GEVNUMBERCHARS 0)
             (* (1+ GEVNUMBERCHARS) WINDOWCHARWIDTH))
            (T 0))))
(SETF (GET 'GEVNAMEPOS 'GLISPCONSTANTVAL) 3)
(SETQ GEVNAMEPOS 3)
(SETF (GET 'GEVNAMEPOS 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'GEVTILDEPOS 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVTILDEPOS 'GLISPORIGCONSTVAL)
      '(+ GEVNAMEPOS (* (1+ GEVNAMECHARS) WINDOWCHARWIDTH)))
(SETF (GET 'GEVTILDEPOS 'GLISPCONSTANTVAL) 111)
(SETQ GEVTILDEPOS 111)
(SETF (GET 'GEVTILDEPOS 'GLISPCONSTANTTYPE) 'INTEGER)
(SETF (GET 'GEVVALUEPOS 'GLISPCONSTANTFLG) T)
(SETF (GET 'GEVVALUEPOS 'GLISPORIGCONSTVAL)
      '(+ GEVTILDEPOS (* 2 WINDOWCHARWIDTH)))
(SETF (GET 'GEVVALUEPOS 'GLISPCONSTANTVAL) 129)
(SETQ GEVVALUEPOS 129)
(SETF (GET 'GEVVALUEPOS 'GLISPCONSTANTTYPE) 'INTEGER)


(SETF (GET 'EDITCHAIN 'GLSTRUCTURE)
      '((LISTOF EDITFRAME) PROP
        ((TOPFRAME ((CAR SELF))) (TOPITEM ((CAR (PREVS TOPFRAME)))))))
(SETF (GET 'EDITFRAME 'GLSTRUCTURE)
      '((LIST (PREVS (LISTOF GSEITEM)) (SUBITEMS (LISTOF GSEITEM))
              (PROPS (LISTOF GSEITEM)))))
(SETF (GET 'GSEITEM 'GLSTRUCTURE)
      '((LIST (NAME ANYTHING) (VALUE ANYTHING) (TYPE ANYTHING)
              (SHORTVALUE ATOM) (NODETYPE ATOM)
              (SUBVALUES (LISTOF GSEITEM)) (NAMEPOS VECTOR)
              (VALUEPOS VECTOR))
        PROP
        ((NAMEAREA
             ((VIRTUAL REGION WITH START = NAMEPOS WIDTH =
                       WINDOWCHARWIDTH* (LENGTH (SYMBOL-NAME NAME))
                       HEIGHT = WINDOWLINEYSPACING)))
         (VALUEAREA
             ((VIRTUAL REGION WITH START = VALUEPOS WIDTH =
                       WINDOWCHARWIDTH* (LENGTH (SYMBOL-NAME NAME))
                       HEIGHT = WINDOWLINEYSPACING))))))
(SETF (GET 'MOUSESTATE 'GLSTRUCTURE)
      '((LIST (AREA REGION) (ITEM GSEITEM) (FLAG BOOLEAN)
              (GROUP INTEGER))))


(DEFMACRO GEV (&REST ARGS) (LIST 'GEV-EXPR (LIST 'QUOTE ARGS)))

(DEFUN GEV-EXPR (ARGS)
  (GEVA (CAR ARGS) (EVAL (CAR ARGS))
        (AND (CDR ARGS)
             (IF (OR (NOT (ATOM (CADR ARGS))) (BOUNDP (CADR ARGS)))
                 (EVAL (CADR ARGS)) (CADR ARGS)))))

(DEFUN GEVA (VAR VAL STR)
  (LET (*GLNATOM* HEADER)
    (GEVENTER)
    (IF (OR (NOT (BOUNDP '*GEVWINDOW*)) (NULL *GEVWINDOW*))
        (GEVINITEDITWINDOW))
    (WHEN *GEVMENUWINDOW*
      (XMAPWINDOW *WINDOW-DISPLAY* (CADR *GEVMENUWINDOW*))
      (XFLUSH *WINDOW-DISPLAY*)
      (WINDOW-WAIT-EXPOSURE *GEVMENUWINDOW*))
    (XMAPWINDOW *WINDOW-DISPLAY* (CADR *GEVWINDOW*))
    (XFLUSH *WINDOW-DISPLAY*)
    (WINDOW-WAIT-EXPOSURE *GEVWINDOW*)
    (SETQ *GEVACTIVEFLG* T)
    (SETQ *GEVEDITFLG* NIL)
    (SETQ *GLNATOM* 0)
    (SETQ *GEVSHORTCHARS* 27)
    (IF (AND (CONSP VAR) (EQ (CAR VAR) 'QUOTE))
        (SETQ VAR (CONCAT "'" (GEVSTRINGIFY (CADR VAR)))))
    (IF (NOT STR)
        (IF (AND (ATOM VAL) (GET VAL 'GLSTRUCTURE)) (SETQ STR 'GLTYPE)
            (OR (SETQ STR (GEVUSERSTR VAL))
                (IF (GEVGLISPP) (SETQ STR (GLCLASS VAL))))))
    (SETQ HEADER
          (LIST VAR VAL STR NIL NIL NIL (COPY-LIST '(0 0))
                (COPY-LIST '(0 0))))
    (SETQ *GEVEDITCHAIN* (LIST (LIST (LIST HEADER) NIL NIL)))
    (GEVREFILLWINDOW)
    (GEVMOUSELOOP)
    (GEVEXIT)))

(DEFUN GEVCOMMANDFN (COMMANDWORD)
  (LET (TOPITEM)
    (IF COMMANDWORD
        (CASE COMMANDWORD
          (EDIT (GEVEDIT))
          (QUIT (IF *GEVMOUSEAREA*
                    (PROGN
                      (WINDOW-INVERT-AREA-XY *GEVWINDOW*
                          (CAAAR *GEVMOUSEAREA*)
                          (CADAAR *GEVMOUSEAREA*)
                          (CAADAR *GEVMOUSEAREA*)
                          (CADR (CADAR *GEVMOUSEAREA*)))
                      (SETQ *GEVMOUSEAREA* NIL))
                    (GEVQUIT)))
          (POP (GEVPOP T 1))
          (PROGRAM (GEVPROGRAM))
          ((PROP ADJ ISA MSG) (SETQ TOPITEM (CAAAR *GEVEDITCHAIN*))
           (GEVCOMMANDPROP TOPITEM COMMANDWORD NIL))
          (T (ERROR "gevcommandf"))))))

(DEFUN GEVCOMMANDPROP (ITEM COMMANDWORD PROPNAME)
  (PROG (PROPNAMES FLG)
    (IF PROPNAME (SETQ FLG T))
    (IF (ATOM (CADDR ITEM))
        (SETQ PROPNAMES
              (GEVCOMMANDPROPNAMES (CADDR ITEM) COMMANDWORD
                  (CAR *GEVEDITCHAIN*))))
    (WHEN (OR (ATOM (CADDR ITEM)) (EQ COMMANDWORD 'PROP))
      (IF (EQ COMMANDWORD 'PROP)
          (IF (AND PROPNAMES (CDR PROPNAMES)) (PUSH 'ALL PROPNAMES))
          (PUSH 'SELF PROPNAMES))
      (IF (NOT PROPNAMES) (RETURN NIL))
      (IF (NOT PROPNAME)
          (SETQ PROPNAME
                (MENU-SELECT
                    (LIST 'MENU
                          (COPY-LIST '(WINDOW NIL NIL 0 0 "" NIL)) NIL
                          NIL 0 0 0 0 "" NIL NIL 0 0 PROPNAMES))))
      (IF PROPNAME
          (IF (EQ PROPNAME 'SELF)
              (PROGN
                (GEVENTERPRINT)
                (PRIN1 PROPNAME)
                (PRINC " = ")
                (PRIN1 (CADR ITEM))
                (TERPRI)
                (GEVEXITPRINT))
              (IF (AND (EQ COMMANDWORD 'PROP) (EQ PROPNAME 'ALL))
                  (DOLIST (X (OR (CDDR PROPNAMES) (CDR PROPNAMES)))
                    (GEVDOPROP ITEM X COMMANDWORD FLG))
                  (GEVDOPROP ITEM PROPNAME COMMANDWORD FLG)))
          (RETURN NIL))
      (WHEN (EQ COMMANDWORD 'MSG)
        (GEVREFILLWINDOW)
        (SETQ *GEVEDITFLG* T)))))

(DEFUN GEVCOMMANDPROPNAMES (OBJ PROPTYPE TOPFRAME)
  (PROG (RESULT)
    (IF (NOT (ATOM OBJ)) (RETURN NIL))
    (SETQ RESULT
          (MAPCAN #'(LAMBDA (P)
                      (AND (NOT (AND (NOT (EQ PROPTYPE 'MSG))
                                     (SOME
                                      #'(LAMBDA (GLVAR53)
                                          (IF
                                           (SETF (CAR GLVAR53) (CAR P))
                                           GLVAR53))
                                      (CADDR TOPFRAME))))
                           (NOT (AND (EQ PROPTYPE 'PROP)
                                     (MEMBER (CAR P)
                                      '(SHORTVALUE DISPLAYPROPS))))
                           (NOT (AND (EQ PROPTYPE 'MSG) (CADR P)
                                     (ATOM (CADR P))
                                     (OR (NOT (FBOUNDP (CADR P)))
                                      (> (LENGTH (GEVARGLIST (CADR P)))
                                       1))))
                           (CONS (CAR P) NIL)))
                  (CASE PROPTYPE
                    (PROP (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'PROP))
                    (ADJ (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'ADJ))
                    (ISA (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'ISA))
                    (MSG (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'MSG)))))
    (DOLIST (S (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'SUPERS))
      (SETQ RESULT
            (NCONC RESULT (GEVCOMMANDPROPNAMES S PROPTYPE TOPFRAME))))
    (DOLIST (S (GLTRANSPARENTTYPES OBJ))
      (SETQ RESULT
            (NCONC RESULT
                   (GEVCOMMANDPROPNAMES (GLXTRTYPE S) PROPTYPE
                       TOPFRAME))))
    (RETURN RESULT)))
(SETF (GET 'GEVCOMMANDPROPNAMES 'GLARGUMENTS)
      '((OBJ GLTYPE) (PROPTYPE ATOM) (TOPFRAME EDITFRAME)))
(SETF (GET 'GEVCOMMANDPROPNAMES 'GLFNRESULTTYPE) '(LISTOF ATOM))


(DEFUN GEVCOMPPROP (STR PROPNAME PROPTYPE)
  (PROG (PROPENT)
    (IF (OR (NOT (MEMBER PROPTYPE '(ADJ ISA PROP MSG)))
            (NOT (ATOM STR)))
        (RETURN 'GEVERROR))
    (IF (AND (SETQ PROPENT (GEVGETPROP STR PROPNAME PROPTYPE))
             (ATOM (CADR PROPENT)))
        (RETURN (CADR PROPENT)))
    (RETURN
      (IF (GEVGLISPP)
          (OR (CAR (GLCOMPPROP STR PROPNAME PROPTYPE NIL)) 'GEVERROR)
          'GEVERROR))))
(SETF (GET 'GEVCOMPPROP 'GLARGUMENTS)
      '((STR GLTYPE) (PROPNAME ATOM) (PROPTYPE ATOM)))
(SETF (GET 'GEVCOMPPROP 'GLFNRESULTTYPE) 'SYMBOL)


(DEFUN GEVDATANAMES (OBJ FILTER)
  (NREVERSE
      (GEVDATANAMESB
          (IF (SYMBOLP OBJ) (CAR (GET OBJ 'GLSTRUCTURE)) OBJ) FILTER
          NIL)))
(SETF (GET 'GEVDATANAMES 'GLARGUMENTS) '((OBJ GLTYPE) (FILTER ATOM)))
(SETF (GET 'GEVDATANAMES 'GLFNRESULTTYPE) '(LISTOF GLNAMETYPE))


(DEFUN GEVDATANAMESB (STR FILTER RESULT)
  (IF (CONSP STR)
      (CASE (CAR STR)
        (CONS (GEVDATANAMESB (CADDR STR) FILTER
                  (GEVDATANAMESB (CADR STR) FILTER RESULT)))
        ((ALIST PROPLIST LIST OBJECT ATOMOBJECT LISTOBJECT TUPLE)
         (DOLIST (X (CDR STR))
           (SETQ RESULT (GEVDATANAMESB X FILTER RESULT)))
         RESULT)
        ((RECORD CRECORD)
         (DOLIST (X (CDDR STR))
           (SETQ RESULT (GEVDATANAMESB X FILTER RESULT)))
         RESULT)
        (ATOM (GEVDATANAMESB (CADDR STR) FILTER
                  (GEVDATANAMESB (CADR STR) FILTER RESULT)))
        (BINDING (GEVDATANAMESB (CADR STR) FILTER RESULT))
        ((LISTOF ^ UNITS) RESULT)
        (T (IF (GEVFILTER (CADR STR) FILTER)
               (IF (AND (CONSP (CADR STR))
                        (MEMBER (CAADR STR) '(A AN)))
                   (GEVDATANAMESB (CADADR STR) FILTER
                       (CONS (LIST (CAR STR) (CADADR STR)) RESULT))
                   (GEVDATANAMESB (CADR STR) FILTER
                       (CONS (LIST (CAR STR) (CADR STR)) RESULT)))
               RESULT)))
      RESULT))

(DEFUN GEVDISPLAYNEWPROP ()
  (LET (NEWONE)
    (SETQ *GEVGLOBALY* *GEVWINDOWY*)
    (SETQ NEWONE (CAR (LAST (CADDAR *GEVEDITCHAIN*))))
    (GEVPPS NEWONE 0 *GEVWINDOW*)
    (SETQ *GEVWINDOWY* *GEVGLOBALY*)))
(SETF (GET 'GEVDISPLAYNEWPROP 'GLARGUMENTS) 'NIL)
(SETF (GET 'GEVDISPLAYNEWPROP 'GLFNRESULTTYPE) 'INTEGER)


(DEFUN GEVDOPROP (ITEM PROPNAME COMMANDWORD FLG)
  (LET (VAL)
    (SETQ VAL
          (GEVEXPROP (CADR ITEM) (CADDR ITEM) PROPNAME COMMANDWORD NIL))
    (SETF (CADDAR *GEVEDITCHAIN*)
          (NCONC (CADDAR *GEVEDITCHAIN*)
                 (CONS (LIST PROPNAME VAL
                             (GEVPROPTYPE (CADDR ITEM) COMMANDWORD
                                 PROPNAME)
                             NIL COMMANDWORD NIL (COPY-LIST '(0 0))
                             (COPY-LIST '(0 0)))
                       NIL)))
    (IF (NOT FLG) (GEVDISPLAYNEWPROP))))
(SETF (GET 'GEVDOPROP 'GLARGUMENTS)
      '((ITEM GSEITEM) (PROPNAME ATOM) (COMMANDWORD ATOM)
        (FLG BOOLEAN)))
(SETF (GET 'GEVDOPROP 'GLFNRESULTTYPE) 'INTEGER)


(DEFUN GEVEDIT ()
  (PROG (CHANGEDFLG GEVTOPITEM)
    (SETQ GEVTOPITEM (CAAAR *GEVEDITCHAIN*))
    (IF (AND (ATOM (CADDR GEVTOPITEM))
             (NOT (EQ (GEVEXPROP (CADR GEVTOPITEM) (CADDR GEVTOPITEM)
                          'EDIT 'MSG NIL)
                      'GEVERROR)))
        (SETQ CHANGEDFLG T)
        (IF (CONSP (CADR GEVTOPITEM))
            (PROGN
              (EVAL (LIST 'EDITV 'GEVEDITVAR))
              (SETQ CHANGEDFLG T))
            (IF (AND (ATOM (CADR GEVTOPITEM))
                     (GLCLASS (CADR GEVTOPITEM)))
                (PROGN
                  (EVAL (LIST 'EDITV
                              (LIST 'SYMBOL-PLIST (CADR GEVTOPITEM))))
                  (SETQ CHANGEDFLG T))
                (RETURN NIL))))
    (WHEN CHANGEDFLG
      (XMAPWINDOW *WINDOW-DISPLAY* (CADR *GEVWINDOW*))
      (XFLUSH *WINDOW-DISPLAY*)
      (WINDOW-WAIT-EXPOSURE *GEVWINDOW*)
      (GEVREFILLWINDOW))
    (SETQ *GEVEDITFLG* CHANGEDFLG)))

(DEFUN GEVEXPROP (OBJ STR PROPNAME PROPTYPE ARGS)
  (PROG (FN TMP)
    (IF (OR (NOT (MEMBER PROPTYPE '(ADJ ISA PROP MSG)))
            (AND ARGS (NOT (EQ PROPTYPE 'MSG))))
        (RETURN 'GEVERROR))
    (IF (EQ (SETQ FN (GEVCOMPPROP STR PROPNAME PROPTYPE)) 'GEVERROR)
        (RETURN FN)
        (IF (NULL FN)
            (IF (AND (ATOM STR)
                     (SETQ TMP
                           (GET (CAAR (GET STR 'GLSTRUCTURE))
                                'GEVINTERFACE)))
                (RETURN
                  (FUNCALL (CADR TMP) OBJ STR PROPNAME PROPTYPE ARGS))
                (RETURN 'GEVERROR))
            (RETURN (GLAPPLY FN (CONS OBJ ARGS)))))))
(SETF (GET 'GEVEXPROP 'GLARGUMENTS)
      '((OBJ NIL) (STR NIL) (PROPNAME ATOM) (PROPTYPE ATOM) (ARGS NIL)))
(SETF (GET 'GEVEXPROP 'GLFNRESULTTYPE) 'SYMBOL)


(DEFUN GEVFILLWINDOW ()
  (LET (TOP)
    (XCLEARWINDOW *WINDOW-DISPLAY* (CADR *GEVWINDOW*))
    (XFLUSH *WINDOW-DISPLAY*)
    (SETQ *GEVGLOBALY* (+ -12 (CADDDR *GEVWINDOW*)))
    (SETQ *GEVLASTITEMNUMBER* 0)
    (SETQ TOP (CAR *GEVEDITCHAIN*))
    (DOLIST (X (REVERSE (CAR TOP))) (GEVPPS X 0 *GEVWINDOW*))
    (GEVHORIZLINE *GEVWINDOW*)
    (DOLIST (X (CADR TOP)) (GEVPPS X 0 *GEVWINDOW*))
    (GEVHORIZLINE *GEVWINDOW*)
    (DOLIST (X (CADDR TOP)) (GEVPPS X 0 *GEVWINDOW*))
    (SETQ *GEVWINDOWY* *GEVGLOBALY*)))
(SETF (GET 'GEVFILLWINDOW 'GLARGUMENTS) 'NIL)
(SETF (GET 'GEVFILLWINDOW 'GLFNRESULTTYPE) 'INTEGER)


(DEFUN GEVFILTER (TYPE FILTER)
  (LET (XTYPE)
    (SETQ XTYPE (GEVXTRTYPE TYPE))
    (CASE FILTER
      ((NUMBER INTEGER REAL)
       (NOT (OR (MEMBER XTYPE '(BOOLEAN ANYTHING))
                (AND (CONSP XTYPE) (EQ (CAR XTYPE) 'LISTOF))
                (AND (CONSP TYPE) (EQ (CAR TYPE) '^)))))
      (LIST (AND (CONSP XTYPE) (EQ (CAR XTYPE) 'LISTOF)))
      (^ (GLPOINTERP TYPE))
      (T T))))

(DEFUN GEVFINDITEMPOS (POS ITEM N)
  (OR (GEVPOSTEST POS (SEVENTH ITEM) (CAR ITEM) ITEM NIL N)
      (GEVPOSTEST POS (EIGHTH ITEM) (CADDDR ITEM) ITEM T N)
      (AND (OR (EQ (FIFTH ITEM) 'STRUCTURE) (EQ (FIFTH ITEM) 'SUBTREE)
               (EQ (FIFTH ITEM) 'LISTOF))
           (GEVFINDLISTPOS POS (SIXTH ITEM) N))))
(SETF (GET 'GEVFINDITEMPOS 'GLARGUMENTS)
      '((POS VECTOR) (ITEM GSEITEM) (N INTEGER)))
(SETF (GET 'GEVFINDITEMPOS 'GLFNRESULTTYPE) 'MOUSESTATE)


(DEFUN GEVFINDITEMTYPE (ITEM)
  (LET (VAL)
    (WHEN (OR (NULL (CADDR ITEM)) (EQ (CADDR ITEM) 'ANYTHING))
      (SETQ VAL (CADR ITEM))
      (SETF (CADDR ITEM)
            (IF (FLOATP VAL) 'REAL
                (IF (INTEGERP VAL) 'INTEGER
                    (IF (STRINGP VAL) 'STRING
                        (OR (GEVUSERSTR VAL)
                            (IF (ATOM VAL) 'ATOM (CADDR ITEM))))))))))
(SETF (GET 'GEVFINDITEMTYPE 'GLARGUMENTS) '((ITEM GSEITEM)))
(SETF (GET 'GEVFINDITEMTYPE 'GLFNRESULTTYPE) 'ANYTHING)


(DEFUN GEVFINDLISTPOS (POS ITEMS N)
  (IF ITEMS
      (OR (GEVFINDITEMPOS POS (CAR ITEMS) N)
          (GEVFINDLISTPOS POS (CDR ITEMS) N))))
(SETF (GET 'GEVFINDLISTPOS 'GLARGUMENTS)
      '((POS VECTOR) (ITEMS (LISTOF GSEITEM)) (N NIL)))
(SETF (GET 'GEVFINDLISTPOS 'GLFNRESULTTYPE) 'MOUSESTATE)


(DEFUN GEVFINDPOS (POS FRAME)
  (LET (TMP N ITEMS)
    (SETQ N 0)
    (WHILE (AND FRAME (NOT TMP)) (INCF N) (SETQ ITEMS (POP FRAME))
           (SETQ TMP (GEVFINDLISTPOS POS ITEMS N)))
    TMP))
(SETF (GET 'GEVFINDPOS 'GLARGUMENTS) '((POS VECTOR) (FRAME EDITFRAME)))
(SETF (GET 'GEVFINDPOS 'GLFNRESULTTYPE) 'MOUSESTATE)


(DEFUN GEVGETNAMES (OBJ FILTER)
  (LET (DATANAMES PROPNAMES)
    (WHEN (ATOM OBJ)
      (SETQ DATANAMES (GEVDATANAMES OBJ FILTER))
      (SETQ PROPNAMES (GEVPROPNAMES OBJ 'PROP FILTER))
      (NCONC DATANAMES PROPNAMES))))
(SETF (GET 'GEVGETNAMES 'GLARGUMENTS) '((OBJ GLTYPE) (FILTER ATOM)))
(SETF (GET 'GEVGETNAMES 'GLFNRESULTTYPE) '(LISTOF GLNAMETYPE))


(DEFUN GEVGETPROP (STR PROPNAME PROPTYPE)
  (LET (PL SUBPL)
    (IF (NOT (MEMBER PROPTYPE '(ADJ ISA PROP MSG)))
        (ERROR "gevgetprop"))
    (AND (ATOM STR) (SETQ PL (GET STR 'GLSTRUCTURE))
         (SETQ SUBPL (GETF (CDR PL) PROPTYPE)) (ASSOC PROPNAME SUBPL))))

(DEFUN GEVGLISPP () (BOUNDP '*GLBASICTYPES*))

(DEFUN GEVHORIZLINE (W)
  (IF (> *GEVGLOBALY* 17)
      (LET ((GLVAR54 (LIST 1 (+ 17/2 *GEVGLOBALY*)))
            (GLVAR55 (LIST (1- (FIFTH W)) (+ 17/2 *GEVGLOBALY*))))
        (WINDOW-DRAW-LINE-XY W (CAR GLVAR54) (CADR GLVAR54)
            (CAR GLVAR55) (CADR GLVAR55) NIL))
      (INCF *GEVGLOBALY* -17)))
(SETF (GET 'GEVHORIZLINE 'GLARGUMENTS) '((W WINDOW)))
(SETF (GET 'GEVHORIZLINE 'GLFNRESULTTYPE) 'INTEGER)


(DEFUN GEVINIT ()
  (SETQ *GLNATOM* 0)
  (UNLESS (BOUNDP '*GLLISPDIALECT*)
    (SETQ *GLLISPDIALECT* 'COMMONLISP))
  (SETQ *GEVWINDOW* NIL))

(DEFUN GEVINTERFACE (STROP GETFN PROPFN CLASSFN)
  (UNLESS (MEMBER STROP *GEVUSERTYPENAMES*)
    (SETQ *GEVUSERTYPENAMES* (CONS STROP *GEVUSERTYPENAMES*)))
  (SETF (GET STROP 'GEVINTERFACE) (LIST GETFN PROPFN CLASSFN)))

(DEFUN GEVITEMEVENTFN (ITEM GROUP FLAG)
  (LET (TMP N)
    (IF FLAG
        (IF (= GROUP 1)
            (PROGN
              (SETQ TMP (CAAR *GEVEDITCHAIN*))
              (SETQ N 0)
              (WHILE (AND TMP (NOT (EQUAL (POP TMP) ITEM))) (INCF N))
              (GEVPOP NIL N))
            (PROGN (GEVFINDITEMTYPE ITEM) (GEVPUSH ITEM)))
        (PROGN
          (GEVFINDITEMTYPE ITEM)
          (GEVENTERPRINT)
          (PRIN1 (CAR ITEM))
          (PRINC " is ")
          (PRIN1 (CADDR ITEM))
          (TERPRI)
          (GEVEXITPRINT)))))

(DEFUN GEVLENGTHBOUND (VAL NCHARS)
  (SETQ VAL (GEVSTRINGIFY VAL))
  (IF (> (LENGTH VAL) NCHARS) (CONCAT (SUBSEQ VAL 0 (1- NCHARS)) "-")
      VAL))
(SETF (GET 'GEVLENGTHBOUND 'GLARGUMENTS) '((VAL NIL) (NCHARS NIL)))
(SETF (GET 'GEVLENGTHBOUND 'GLFNRESULTTYPE) 'STRING)


(DEFUN GEVMAKENEWFN (OPERATION INPUTTYPE SET PATH)
  (PROG (LASTPATH VIEWSPEC)
    (SETQ LASTPATH (CAR (LAST PATH)))
    (RETURN
      (LIST (LIST 'GLAMBDA (LIST (LIST 'GEVNEWFNTOP INPUTTYPE))
                  (LIST 'PROG
                        (CONS 'GEVNEWFNVALUE
                              (CASE OPERATION
                                (COLLECT '(GEVNEWFNRESULT))
                                ((MAXIMUM MINIMUM)
                                 '(GEVNEWFNTESTVAL GEVNEWFNINSTANCE))
                                (TOTAL '((GEVNEWFNSUM 0)))
                                (AVERAGE '((GEVNEWFNSUM 0.0)
                                           (GEVNEWFNCOUNT 0)))
                                (T (ERROR "gevmakenewfn"))))
                        (NCONC (LIST 'FOR 'GEVNEWFNLOOPVAR 'IN
                                     (LIST (CAR SET) 'GEVNEWFNTOP) 'DO
                                     (LIST 'GEVNEWFNVALUE '=
                                      (PROGN
                                        (SETQ VIEWSPEC
                                         'GEVNEWFNLOOPVAR)
                                        (DOLIST (X PATH)
                                          (SETQ VIEWSPEC
                                           (LIST (CAR X) VIEWSPEC)))
                                        VIEWSPEC)))
                               (COPY-TREE
                                   (CASE OPERATION
                                     (COLLECT
                                      '((GEVNEWFNRESULT +_
                                         GEVNEWFNVALUE)))
                                     (MAXIMUM
                                      '((IF ~ GEVNEWFNINSTANCE OR
                                         (GEVNEWFNVALUE >
                                          GEVNEWFNTESTVAL)
                                         (PROGN
                                           (GEVNEWFNTESTVAL =
                                            GEVNEWFNVALUE)
                                           (GEVNEWFNINSTANCE =
                                            GEVNEWFNLOOPVAR)))))
                                     (MINIMUM
                                      '((IF ~ GEVNEWFNINSTANCE OR
                                         (GEVNEWFNVALUE <
                                          GEVNEWFNTESTVAL)
                                         (PROGN
                                           (GEVNEWFNTESTVAL =
                                            GEVNEWFNVALUE)
                                           (GEVNEWFNINSTANCE =
                                            GEVNEWFNLOOPVAR)))))
                                     (AVERAGE
                                      '((GEVNEWFNSUM _+ GEVNEWFNVALUE)
                                        (GEVNEWFNCOUNT _+ 1)))
                                     (TOTAL
                                      '((GEVNEWFNSUM _+ GEVNEWFNVALUE))))))
                        (LIST 'RETURN
                              (CASE OPERATION
                                (COLLECT '(NREVERSE GEVNEWFNRESULT))
                                ((MAXIMUM MINIMUM)
                                 '(LIST GEVNEWFNTESTVAL
                                        GEVNEWFNINSTANCE))
                                (AVERAGE '(/ GEVNEWFNSUM
                                           (FLOAT GEVNEWFNCOUNT)))
                                (TOTAL 'GEVNEWFNSUM)))))
            (CASE OPERATION
              (COLLECT (LIST 'LISTOF (CADR LASTPATH)))
              ((MAXIMUM MINIMUM)
               (LIST 'LIST (COPY-TREE LASTPATH)
                     (LIST 'WINNER (CADADR SET))))
              (AVERAGE 'REAL)
              (TOTAL (CADR LASTPATH)))))))
(SETF (GET 'GEVMAKENEWFN 'GLARGUMENTS)
      '((OPERATION ATOM) (INPUTTYPE ATOM) (SET GLNAMETYPE)
        (PATH (LISTOF GLNAMETYPE))))
(SETF (GET 'GEVMAKENEWFN 'GLFNRESULTTYPE)
      '(LIST (LIST SYMBOL (LIST (LIST SYMBOL ATOM))
                   (LIST SYMBOL (CONS SYMBOL NIL)
                         (LIST SYMBOL SYMBOL SYMBOL
                               (LIST SYMBOL SYMBOL) SYMBOL
                               (LIST SYMBOL SYMBOL ANYTHING))
                         (LIST SYMBOL NIL)))
             NIL))


(DEFUN GEVMATCH (STR VAL FLG)
  (LET (*GEVMATCHRESULT*)
    (GEVMATCHB STR VAL NIL FLG)
    (NREVERSE *GEVMATCHRESULT*)))
(SETF (GET 'GEVMATCH 'GLARGUMENTS) '((STR NIL) (VAL NIL) (FLG NIL)))
(SETF (GET 'GEVMATCH 'GLFNRESULTTYPE) '(LISTOF GSEITEM))


(DEFUN GEVMATCHA (STR VAL FLG)
  (LET (RES)
    (SETQ RES (GEVMATCH STR VAL FLG))
    (IF (CDR RES)
        (LIST NIL VAL STR NIL 'SUBTREE RES (COPY-LIST '(0 0))
              (COPY-LIST '(0 0)))
        (CAR RES))))
(SETF (GET 'GEVMATCHA 'GLARGUMENTS) '((STR NIL) (VAL NIL) (FLG NIL)))
(SETF (GET 'GEVMATCHA 'GLFNRESULTTYPE) 'GSEITEM)


(DEFUN GEVMATCHATOM (STR VAL NAME)
  (PROG (L STRB TMP)
    (IF (OR (NOT (ATOM VAL)) (NULL VAL)) (RETURN NIL))
    (SETQ STRB (CADR STR))
    (IF (NOT (EQ (CAR STRB) 'PROPLIST)) (RETURN NIL))
    (SETQ L (CDR STRB))
    (DOLIST (X L)
      (IF (SETQ TMP (GET VAL (CAR X))) (GEVMATCHB X TMP NIL NIL)))))

(DEFUN GEVMATCHALIST (STR VAL NAME)
  (LET (L TMP)
    (SETQ L (CDR STR))
    (DOLIST (X L)
      (IF (SETQ TMP (ASSOC (CAR X) VAL))
          (GEVMATCHB X (CDR TMP) NIL NIL)))))

(DEFUN GEVMATCHB (STR VAL NAME FLG)
  (PROG (STRB XSTR TOP TMP)
    (SETQ XSTR (GEVXTRTYPE STR))
    (IF (ATOM STR)
        (PROGN
          (IF (AND FLG (SETQ STRB (CAR (GET STR 'GLSTRUCTURE))))
              (PUSH (LIST NAME VAL STR NIL 'STRUCTURE
                          (GEVMATCH STRB VAL NIL) (COPY-LIST '(0 0))
                          (COPY-LIST '(0 0)))
                    *GEVMATCHRESULT*)
              (PUSH (LIST NAME VAL STR NIL NIL NIL (COPY-LIST '(0 0))
                          (COPY-LIST '(0 0)))
                    *GEVMATCHRESULT*))
          (RETURN NIL))
        (CASE (CAR STR)
          (CONS (GEVMATCHB (CADR STR) (CAR VAL) NIL NIL)
                (GEVMATCHB (CADDR STR) (CDR VAL) NIL NIL))
          (LIST (DOLIST (X (CDR STR))
                  (IF VAL (GEVMATCHB X (CAR VAL) NIL NIL)
                      (SETQ VAL (CDR VAL)))))
          (ATOM (GEVMATCHATOM STR VAL NAME))
          (ALIST (GEVMATCHALIST STR VAL NAME))
          (PROPLIST (GEVMATCHPROPLIST STR VAL NAME))
          (LISTOF (GEVMATCHLISTOF STR VAL NAME))
          (RECORD (GEVMATCHRECORD STR VAL NAME))
          ((OBJECT ATOMOBJECT LISTOBJECT)
           (GEVMATCHOBJECT STR VAL NAME))
          (TRANSPARENT (GEVMATCHB (CADR STR) VAL NIL T))
          (T (IF (GET (CAR STR) 'GEVINTERFACE)
                 (GEVMATCHUOBJ STR VAL NAME)
                 (IF NAME
                     (PROGN
                       (SETQ TMP (GEVMATCH STR VAL NIL))
                       (SETQ TOP (CAR TMP))
                       (PUSH (IF (AND (NOT (CDR TMP)) (NOT (CAR TOP)))
                                 (PROGN (SETF (CAR TOP) NAME) TOP)
                                 (LIST NAME VAL XSTR NIL 'SUBTREE TMP
                                       (COPY-LIST '(0 0))
                                       (COPY-LIST '(0 0))))
                             *GEVMATCHRESULT*))
                     (IF (ATOM (SETQ STRB (GEVXTRTYPE (CADR STR))))
                         (GEVMATCHB STRB VAL (CAR STR) NIL)
                         (IF (SETQ TMP (GEVMATCH (CADR STR) VAL NIL))
                             (PROGN
                               (SETQ TOP (CAR TMP))
                               (PUSH (IF
                                      (AND (NOT (CDR TMP))
                                       (NOT (CAR TOP)))
                                      (PROGN
                                        (SETF (CAR TOP) (CAR STR))
                                        TOP)
                                      (LIST (CAR STR) VAL (CADR STR)
                                       NIL 'SUBTREE TMP
                                       (COPY-LIST '(0 0))
                                       (COPY-LIST '(0 0))))
                                     *GEVMATCHRESULT*))
                             (PROGN
                               (PRIN1 "GEVMATCHB Failed")
                               (TERPRI)))))))))))

(DEFUN GEVMATCHLISTOF (STR VAL NAME)
  (PUSH (LIST NAME VAL STR NIL NIL NIL (COPY-LIST '(0 0))
              (COPY-LIST '(0 0)))
        *GEVMATCHRESULT*))

(DEFUN GEVMATCHOBJECT (STR VAL NAME)
  (LET ((OBJECTTYPE (CAR STR)) TMP N)
    (SETQ *GEVMATCHRESULT*
          (NCONC *GEVMATCHRESULT*
                 (CONS (LIST 'CLASS
                             (CASE OBJECTTYPE
                               (OBJECT (SETQ TMP (POP VAL)))
                               (LISTOBJECT (SETQ TMP (POP VAL)))
                               (ATOMOBJECT (GET VAL 'CLASS)))
                             'GLTYPE NIL NIL NIL (COPY-LIST '(0 0))
                             (COPY-LIST '(0 0)))
                       NIL)))
    (SETQ N 0)
    (DOLIST (X (CDR STR))
      (INCF N)
      (CASE OBJECTTYPE
        (OBJECT (IF VAL (GEVMATCHB X (SETQ TMP (POP VAL)) NIL NIL)))
        (LISTOBJECT
            (IF VAL (GEVMATCHB X (SETQ TMP (POP VAL)) NIL NIL)))
        (ATOMOBJECT
            (IF (SETQ TMP (GET VAL (CAR X))) (GEVMATCHB X TMP NIL NIL)))))))

(DEFUN GEVMATCHPROPLIST (STR VAL NAME)
  (LET (L TMP)
    (SETQ L (CDR STR))
    (DOLIST (X L)
      (IF (SETQ TMP (GETF VAL (CAR X))) (GEVMATCHB X TMP NIL NIL)))))

(DEFUN GEVMATCHRECORD (STR VAL NAME)
  (LET (FIELDS N)
    (IF (ATOM (CADR STR)) (SETQ FIELDS (CDDR STR))
        (SETQ FIELDS (CDR STR)))
    (SETQ N 0)
    (DOLIST (X FIELDS)
      (INCF N)
      (GEVMATCHB X (ERROR "gevmatchrecord") (CAR X) NIL))))

(DEFUN GEVMATCHUOBJ (STR VAL NAME)
  (DOLIST (X (CDR STR))
    (GEVMATCHB X
        (FUNCALL (CAR (GET (CAR STR) 'GEVINTERFACE)) VAL STR (CAR X))
        NIL NIL)))

(DEFUN GEVNEWFN (X) NIL)

(DEFUN GEVPOP (FLG N)
  (PROG (TMP TOP TMPITEM)
    (IF (< N 1) (RETURN NIL))
    LP
    (SETQ TMP (POP *GEVEDITCHAIN*))
    (IF (NOT *GEVEDITCHAIN*) (RETURN (GEVQUIT)))
    (SETQ TOP (CAAAR *GEVEDITCHAIN*))
    (SETQ TMPITEM (CAAR TMP))
    (IF (AND FLG (EQ (FIFTH TMPITEM) 'FORWARD)) (GO LP))
    (IF (PLUSP (DECF N)) (GO LP))
    (IF (AND (CONSP (CADDR TOP)) (EQ (CAADDR TOP) 'LISTOF)
             (NOT (CDADR TOP)))
        (GO LP))
    (IF (AND *GEVEDITFLG*
             (NOT (MEMBER (CADDDR TMPITEM) '("(...)" "---") :TEST
                          #'EQUAL)))
        (GEVREFILLWINDOW)
        (PROGN (SETQ *GEVEDITFLG* NIL) (GEVFILLWINDOW)))))

(DEFUN GEVPOSTEST (POS TPOS NAME ITEM FLG N)
  (IF (AND (>= (CADR POS) (CADR TPOS))
           (<= (CADR POS) (+ 17 (CADR TPOS))) (>= (CAR POS) (CAR TPOS))
           (< (CAR POS) (+ 99 (CAR TPOS))))
      (LIST (LIST (LIST (CAR TPOS) (1- (CADR TPOS)))
                  (LIST (* 9 (LENGTH (GEVSTRINGIFY NAME))) 17))
            ITEM FLG N)))
(SETF (GET 'GEVPOSTEST 'GLARGUMENTS)
      '((POS VECTOR) (TPOS VECTOR) (NAME STRING) (ITEM GSEITEM)
        (FLG NIL) (N INTEGER)))
(SETF (GET 'GEVPOSTEST 'GLFNRESULTTYPE) 'MOUSESTATE)


(DEFUN GEVPPS (ITEM COL WINDOW)
  (PROG (NAMEX)
    (IF (< *GEVGLOBALY* 17) (RETURN NIL))
    (GEVFINDITEMTYPE ITEM)
    (SETQ NAMEX (+ 3 (* 9 COL)))
    (SETF (CAR (SEVENTH ITEM)) NAMEX)
    (SETF (CADR (SEVENTH ITEM)) *GEVGLOBALY*)
    (IF (EQ (FIFTH ITEM) 'FULLVALUE)
        (PROGN
          (LET ((SSTR (STRINGIFY "(expanded)")))
            (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR WINDOW)
                (CADDR WINDOW) NAMEX (- (CADDDR WINDOW) *GEVGLOBALY*)
                (GET-C-STRING SSTR) (LENGTH SSTR)))
          (INCF *GEVGLOBALY* -17))
        (WHEN (CAR ITEM)
          (WHEN (NUMBERP (CAR ITEM))
            (LET ((SSTR (STRINGIFY "#")))
              (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR WINDOW)
                  (CADDR WINDOW) NAMEX (- (CADDDR WINDOW) *GEVGLOBALY*)
                  (GET-C-STRING SSTR) (LENGTH SSTR)))
            (INCF NAMEX 9))
          (LET ((SSTR (STRINGIFY (GEVLENGTHBOUND (CAR ITEM) 11))))
            (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR WINDOW)
                (CADDR WINDOW) NAMEX (- (CADDDR WINDOW) *GEVGLOBALY*)
                (GET-C-STRING SSTR) (LENGTH SSTR)))))
    (IF (OR (NOT (FIFTH ITEM))
            (MEMBER (FIFTH ITEM) '(FORWARD BACKUP PROP ADJ MSG ISA)))
        (PROGN
          (SETF (CAR (EIGHTH ITEM)) 129)
          (SETF (CADR (EIGHTH ITEM)) *GEVGLOBALY*)
          (LET ((SSTR (STRINGIFY
                          (OR (CADDDR ITEM)
                              (SETF (CADDDR ITEM)
                                    (GEVSHORTVALUE (CADR ITEM)
                                     (CADDR ITEM)
                                     (- *GEVSHORTCHARS* COL)))))))
            (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR WINDOW)
                (CADDR WINDOW) 129 (- (CADDDR WINDOW) *GEVGLOBALY*)
                (GET-C-STRING SSTR) (LENGTH SSTR)))
          (IF (NOT (STRING= (CADDDR ITEM) (GEVSTRINGIFY (CADR ITEM))))
              (LET ((SSTR (STRINGIFY "~")))
                (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR WINDOW)
                    (CADDR WINDOW) 111 (- (CADDDR WINDOW) *GEVGLOBALY*)
                    (GET-C-STRING SSTR) (LENGTH SSTR))))
          (INCF *GEVGLOBALY* -17))
        (IF (EQ (FIFTH ITEM) 'FULLVALUE)
            (PROGN
              (LET ((SSTR (STRINGIFY (CADR ITEM))))
                (XDRAWIMAGESTRING *WINDOW-DISPLAY* (CADR WINDOW)
                    (CADDR WINDOW) 9 (- (CADDDR WINDOW) *GEVGLOBALY*)
                    (GET-C-STRING SSTR) (LENGTH SSTR)))
              (INCF *GEVGLOBALY* -34))
            (IF (EQ (FIFTH ITEM) 'DISPLAY)
                (GEVEXPROP (CADR ITEM) (CADDR ITEM) 'GEVDISPLAY 'MSG
                    (LIST WINDOW *GEVGLOBALY*))
                (PROGN
                  (INCF *GEVGLOBALY* -17)
                  (DOLIST (VSUB (SIXTH ITEM))
                    (GEVPPS VSUB (+ 2 COL) WINDOW))))))))

(DEFUN GEVPROGRAM ()
  (PROG (TOPITEM COMMAND SET PATH DONE NEXT NXT Z TYPE NEWFN RESULT
                 LAST ABORTFLG)
    (SETQ TOPITEM (CAAAR *GEVEDITCHAIN*))
    (IF (OR (EQ (SETQ COMMAND
                      (MENU-SELECT
                          (LIST 'MENU
                                (COPY-LIST
                                    '(WINDOW NIL NIL 0 0 "" NIL))
                                NIL NIL 0 0 0 0 "" NIL NIL 0 0
                                '(QUIT COLLECT TOTAL AVERAGE MAXIMUM
                                       MINIMUM))))
                'QUIT)
            (NOT COMMAND))
        (RETURN NIL))
    (IF (OR (EQ (SETQ SET (GEVPROPMENU (CADDR TOPITEM) 'LIST NIL))
                'QUIT)
            (EQ SET 'POP) (NOT SET))
        (RETURN NIL))
    (SETQ PATH (LIST SET (LIST (CAR TOPITEM) (CADDR TOPITEM))))
    (SETQ NEXT SET)
    (SETQ TYPE (CADADR SET))
    (WHILE (AND (NOT DONE) (NOT ABORTFLG))
           (SETQ NEXT
                 (GEVPROPMENU TYPE
                     (AND (NOT (EQ COMMAND 'COLLECT)) 'NUMBER)
                     (EQ COMMAND 'COLLECT)))
           (IF (ATOM NEXT)
               (CASE NEXT
                 ((NIL)
                  (IF (EQ COMMAND 'COLLECT) (SETQ DONE T)
                      (SETQ ABORTFLG T)))
                 (QUIT (SETQ ABORTFLG T))
                 (POP (IF (CDDR PATH)
                          (PROGN
                            (SETQ Z (POP PATH))
                            (SETQ NXT (CAR PATH))
                            (SETQ TYPE (CADR NXT))
                            (IF (CONSP TYPE) (SETQ TYPE (CADR TYPE)))
                            (SETQ LAST (CAR NXT)))
                          (SETQ ABORTFLG T)))
                 (DONE (SETQ DONE T)))
               (PROGN
                 (PUSH NEXT PATH)
                 (SETQ TYPE (CADR NEXT))
                 (SETQ LAST (CAR NEXT))))
           (IF (OR (NOT TYPE)
                   (AND (NOT (EQ COMMAND 'COLLECT))
                        (MEMBER TYPE '(INTEGER REAL NUMBER))))
               (SETQ DONE T)))
    (IF ABORTFLG (RETURN NIL))
    (SETQ PATH (NREVERSE PATH))
    (SETQ NEWFN (GEVMAKENEWFN COMMAND (CADDR TOPITEM) SET (CDDR PATH)))
    (GEVPUTD 'GEVNEWFN (CAR NEWFN))
    (GLCC 'GEVNEWFN)
    (SETQ RESULT (GEVNEWFN (CADR TOPITEM)))
    (GEVENTERPRINT)
    (PRIN1 COMMAND)
    (SPACES 1)
    (DOLIST (X (CDDR PATH)) (PRIN1 (CAR X)) (SPACES 1))
    (PRINC "of ")
    (PRIN1 (CAAR PATH))
    (SPACES 1)
    (PRIN1 (CAADR PATH))
    (PRINC " = ")
    (PRIN1 RESULT)
    (TERPRI)
    (GEVEXITPRINT)
    (SETF (CADDAR *GEVEDITCHAIN*)
          (NCONC (CADDAR *GEVEDITCHAIN*)
                 (CONS (LIST (CONCAT (GEVSTRINGIFY COMMAND)
                                     (CONCAT " " (GEVSTRINGIFY LAST)))
                             RESULT (CADR NEWFN) NIL 'MSG NIL
                             (COPY-LIST '(0 0)) (COPY-LIST '(0 0)))
                       NIL)))
    (GEVDISPLAYNEWPROP)))

(DEFUN GEVPROPMENU (OBJ FILTER FLG)
  (PROG (PROPS SEL PNAMES)
    (SETQ PROPS (GEVGETNAMES OBJ FILTER))
    (IF PROPS
        (PROGN
          (SETQ PNAMES (MAPCAR #'CAR PROPS))
          (SETQ SEL
                (MENU-SELECT
                    (LIST 'MENU
                          (COPY-LIST '(WINDOW NIL NIL 0 0 "" NIL)) NIL
                          NIL 0 0 0 0 "" NIL NIL 0 0
                          (CONS 'QUIT
                                (CONS 'POP
                                      (IF FLG (CONS 'DONE PNAMES)
                                       PNAMES))))))
          (RETURN
            (CASE SEL ((QUIT POP DONE NIL) SEL) (T (ASSOC SEL PROPS)))))
        (RETURN NIL))))
(SETF (GET 'GEVPROPMENU 'GLARGUMENTS)
      '((OBJ GLTYPE) (FILTER ATOM) (FLG BOOLEAN)))
(SETF (GET 'GEVPROPMENU 'GLFNRESULTTYPE) 'GLNAMETYPE)


(DEFUN GEVPROPNAMES (OBJ PROPTYPE FILTER)
  (LET (RESULT TYPE)
    (WHEN (SYMBOLP OBJ)
      (SETQ RESULT
            (MAPCAN #'(LAMBDA (P)
                        (AND (SETQ TYPE
                                   (GEVPROPTYPES OBJ PROPTYPE (CAR P)))
                             (GEVFILTER TYPE FILTER)
                             (CONS (LIST (CAR P) TYPE) NIL)))
                    (CASE PROPTYPE
                      (PROP (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'PROP))
                      (ADJ (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'ADJ))
                      (ISA (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'ISA))
                      (MSG (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'MSG)))))
      (DOLIST (S (GETF (CDR (GET OBJ 'GLSTRUCTURE)) 'SUPERS))
        (SETQ RESULT (NCONC RESULT (GEVPROPNAMES S PROPTYPE FILTER))))
      RESULT)))
(SETF (GET 'GEVPROPNAMES 'GLARGUMENTS)
      '((OBJ GLTYPE) (PROPTYPE SYMBOL) (FILTER SYMBOL)))
(SETF (GET 'GEVPROPNAMES 'GLFNRESULTTYPE) '(LISTOF GLNAMETYPE))


(DEFUN GEVPROPTYPE (STR PROPTYPE PROPNAME)
  (LET (PL SUBPL PROPENT)
    (WHEN (SYMBOLP STR)
      (SETQ PROPENT (GEVGETPROP STR PROPNAME PROPTYPE))
      (OR (AND (CONSP PROPENT) (GETF (CDDR PROPENT) 'RESULT))
          (AND (CONSP PROPENT) (SYMBOLP (CADR PROPENT))
               (GLRESULTTYPE (CADR PROPENT) NIL))
          (AND (CONSP PROPENT) (CONSP (CADR PROPENT))
               (CONSP (CAADR PROPENT)) (EQ (CAAADR PROPENT) 'VIRTUAL)
               (CADR (CAADR PROPENT)))
          (AND (SETQ PL (GET STR 'GLPROPFNS))
               (SETQ SUBPL (ASSOC PROPTYPE PL))
               (SETQ PROPENT (ASSOC PROPNAME (CDR SUBPL)))
               (CADDR PROPENT))
          (AND (GLCOMPPROP STR PROPNAME PROPTYPE NIL)
               (SETQ PL (GET STR 'GLPROPFNS))
               (SETQ SUBPL (ASSOC PROPTYPE PL))
               (SETQ PROPENT (ASSOC PROPNAME (CDR SUBPL)))
               (CADDR PROPENT))
          (AND (EQ PROPTYPE 'ADJ) 'BOOLEAN)))))
(SETF (GET 'GEVPROPTYPE 'GLARGUMENTS)
      '((STR SYMBOL) (PROPTYPE SYMBOL) (PROPNAME SYMBOL)))
(SETF (GET 'GEVPROPTYPE 'GLFNRESULTTYPE) 'GLTYPE)


(DEFUN GEVPROPTYPES (OBJ PROPTYPE NAME)
  (OR (GEVPROPTYPE OBJ PROPTYPE NAME)
      (AND (GEVCOMPPROP OBJ NAME PROPTYPE)
           (GEVPROPTYPE OBJ PROPTYPE NAME))))

(DEFUN GEVPUSH (ITEM)
  (PROG (NEWITEMS LSTITEM ACTUALTYPE)
    (WHEN (EQ (FIFTH ITEM) 'BACKUP) (GEVPOP NIL 1) (RETURN))
    (SETQ ACTUALTYPE (GEVTYPE NIL (CADR ITEM)))
    (IF (EQ (FIFTH ITEM) 'FORWARD)
        (SETQ NEWITEMS (GEVPUSHLISTOF ITEM T))
        (IF (AND (ATOM (CADDR ITEM))
                 (MEMBER (CADDR ITEM)
                         '(ATOM NUMBER REAL INTEGER STRING ANYTHING))
                 (NOT ACTUALTYPE))
            (SETQ NEWITEMS
                  (LIST (LIST (CAR ITEM) (CADR ITEM) (CADDR ITEM)
                              (CADDDR ITEM) 'FULLVALUE NIL
                              (COPY-LIST '(0 0)) (COPY-LIST '(0 0)))))
            (IF (AND (ATOM (CADDR ITEM))
                     (NOT (GET (CADDR ITEM) 'GLSTRUCTURE))
                     (NOT ACTUALTYPE))
                (RETURN NIL)
                (IF (AND (CONSP (CADDR ITEM))
                         (EQ (CAADDR ITEM) 'LISTOF))
                    (SETQ NEWITEMS (GEVPUSHLISTOF ITEM NIL))))))
    (PUSH (LIST (CONS ITEM (CAAR *GEVEDITCHAIN*)) NEWITEMS NIL)
          *GEVEDITCHAIN*)
    (GEVREFILLWINDOW)
    (WHEN (AND (CONSP (CADDR ITEM)) (EQ (CAADDR ITEM) 'LISTOF)
               (CONSP (CADR ITEM)) (NOT (CDADR ITEM)))
      (SETQ LSTITEM (CAADAR *GEVEDITCHAIN*))
      (GEVPUSH (CAR (SIXTH LSTITEM)))
      (RETURN NIL))))

(DEFUN GEVPUSHLISTOF (ITEM FLG)
  (PROG (ITEMTYPE LISTTYPE TOPFRAME N NROOM LST VALS)
    (IF (AND (NOT (CADR ITEM)) (NOT (EQ (FIFTH ITEM) 'FORWARD)))
        (RETURN NIL))
    (SETQ TOPFRAME (CAR *GEVEDITCHAIN*))
    (SETQ LISTTYPE (CADDR ITEM))
    (SETQ ITEMTYPE (CADR LISTTYPE))
    (SETQ NROOM
          (- (+ -4 (/ (CADDDR *GEVWINDOW*) 17))
             (LENGTH (CAR TOPFRAME))))
    (IF FLG
        (PROGN
          (PUSH (LIST NIL NIL LISTTYPE "(..." 'BACKUP NIL
                      (COPY-LIST '(0 0)) (COPY-LIST '(0 0)))
                LST)
          (SETQ N (CAR ITEM))
          (DECF NROOM)
          (SETQ VALS (SIXTH ITEM)))
        (PROGN (SETQ N 1) (SETQ VALS (CADR ITEM))))
    (WHILE (AND VALS
                (OR (> NROOM 1) (AND (= NROOM 1) (NOT (CDR VALS)))))
           (PUSH (LIST N (POP VALS) ITEMTYPE NIL NIL NIL
                       (COPY-LIST '(0 0)) (COPY-LIST '(0 0)))
                 LST)
           (DECF NROOM) (INCF N))
    (IF VALS
        (PUSH (LIST N NIL LISTTYPE "...)" 'FORWARD VALS
                    (COPY-LIST '(0 0)) (COPY-LIST '(0 0)))
              LST))
    (RETURN
      (LIST (LIST "expanded" NIL LISTTYPE NIL 'LISTOF (NREVERSE LST)
                  (COPY-LIST '(0 0)) (COPY-LIST '(0 0)))))))
(SETF (GET 'GEVPUSHLISTOF 'GLARGUMENTS)
      '((ITEM GSEITEM) (FLG BOOLEAN)))
(SETF (GET 'GEVPUSHLISTOF 'GLFNRESULTTYPE) '(LIST GSEITEM))


(DEFUN GEVQUIT ()
  (SETQ *GEVACTIVEFLG* NIL)
  (XUNMAPWINDOW *WINDOW-DISPLAY* (CADR *GEVWINDOW*))
  (XFLUSH *WINDOW-DISPLAY*)
  (WINDOW-WAIT-UNMAP *GEVWINDOW*)
  (WHEN *GEVMENUWINDOW*
    (XUNMAPWINDOW *WINDOW-DISPLAY* (CADR *GEVMENUWINDOW*))
    (XFLUSH *WINDOW-DISPLAY*)
    (WINDOW-WAIT-UNMAP *GEVMENUWINDOW*)))

(DEFUN GEVREDOPROPS (TOP)
  (LET (ITEM L)
    (SETQ ITEM (CAAR TOP))
    (IF (AND (NOT (CADDR TOP))
             (NOT (EQ (SETQ L
                            (GEVEXPROP (CADR ITEM) (CADDR ITEM)
                                'DISPLAYPROPS 'PROP NIL))
                      'GEVERROR)))
        (IF (ATOM L) (GEVCOMMANDPROP ITEM 'PROP 'ALL)
            (IF (CONSP L) (DOLIST (X L) (GEVCOMMANDPROP ITEM 'PROP X))))
        (DOLIST (X (CADDR TOP))
          (UNLESS (EQ (FIFTH X) 'MSG)
            (SETF (CADR X)
                  (GEVEXPROP (CADR ITEM) (CADDR ITEM) (CAR X) (FIFTH X)
                      NIL))
            (SETF (CADDDR X) NIL))))))

(DEFUN GEVREFILLWINDOW ()
  (LET (TOP TOPITEM SUBS TOPSUB)
    (SETQ TOP (CAR *GEVEDITCHAIN*))
    (SETQ TOPITEM (CAAAR *GEVEDITCHAIN*))
    (IF (CADR TOP) (SETQ TOPSUB (CAADR TOP)))
    (IF (OR (NOT TOPSUB)
            (AND (NOT (EQ (FIFTH TOPSUB) 'FULLVALUE))
                 (NOT (EQ (FIFTH TOPSUB) 'LISTOF))))
        (IF (GEVGETPROP (CADDR TOPITEM) 'GEVDISPLAY 'MSG)
            (SETF (CADR TOP)
                  (LIST (LIST NIL (CADR TOPITEM) (CADDR TOPITEM) NIL
                              'DISPLAY NIL (COPY-LIST '(0 0))
                              (COPY-LIST '(0 0)))))
            (PROGN
              (SETQ SUBS
                    (GEVMATCH (GEVTYPE (CADDR TOPITEM) (CADR TOPITEM))
                        (CADR TOPITEM) T))
              (SETQ TOPSUB (CAR SUBS))
              (SETF (CADR TOP)
                    (IF (AND (NOT (CDR SUBS))
                             (EQ (FIFTH TOPSUB) 'STRUCTURE)
                             (EQUAL (CADR TOPSUB) (CADR TOPITEM))
                             (EQUAL (CADDR TOPSUB) (CADDR TOPITEM)))
                        (SIXTH TOPSUB) SUBS)))))
    (GEVREDOPROPS TOP)
    (GEVFILLWINDOW)))
(SETF (GET 'GEVREFILLWINDOW 'GLARGUMENTS) 'NIL)
(SETF (GET 'GEVREFILLWINDOW 'GLFNRESULTTYPE) 'INTEGER)


(DEFUN GEVSHORTATOMVAL (ATM NCHARS)
  (IF (SYMBOLP ATM)
      (IF (> (LENGTH (SYMBOL-NAME ATM)) NCHARS)
          (CONCAT (SUBSEQ (SYMBOL-NAME ATM) 0 (1- NCHARS)) "-")
          (GEVSTRINGIFY ATM))
      (GEVSHORTSTRINGVAL (GEVSTRINGIFY ATM) NCHARS)))

(DEFUN GEVSHORTCONSVAL (VAL STR NCHARS)
  (LET (NLEFT RES TMP NC)
    (PUSH "(" RES)
    (SETQ NLEFT (+ -5 NCHARS))
    (SETQ TMP (GEVSHORTVALUE (CAR VAL) (CADR STR) (+ -3 NLEFT)))
    (SETQ NC (LENGTH (SYMBOL-NAME TMP)))
    (WHEN (> NC (+ -3 NLEFT)) (SETQ TMP "---") (SETQ NC 3))
    (PUSH (GEVSTRINGIFY TMP) RES)
    (PUSH " . " RES)
    (DECF NLEFT NC)
    (SETQ TMP (GEVSHORTVALUE (CDR VAL) (CADDR STR) NLEFT))
    (SETQ NC (LENGTH (SYMBOL-NAME TMP)))
    (WHEN (> NC NLEFT) (SETQ TMP "---") (SETQ NC 3))
    (PUSH (GEVSTRINGIFY TMP) RES)
    (PUSH ")" RES)
    (GEVCONCAT (NREVERSE RES))))

(DEFUN GEVSHORTLISTVAL (VAL STR NCHARS)
  (LET (NLEFT RES TMP QUIT NC NCI REST RSTR)
    (PUSH "(" RES)
    (SETQ REST 4)
    (SETQ NLEFT (+ -2 NCHARS))
    (SETQ RSTR (CDR STR))
    (WHILE (AND VAL (CONSP VAL) (NOT QUIT)
                (> (SETQ NCI (IF (CDR VAL) (- NLEFT REST) NLEFT)) 2))
           (SETQ TMP
                 (GEVSHORTVALUE (CAR VAL)
                     (IF (EQ (CAR STR) 'LISTOF) (CADR STR)
                         (IF (EQ (CAR STR) 'LIST) (CAR RSTR)))
                     NCI))
           (SETQ QUIT
                 (MEMBER TMP '(GEVERROR "(...)" "---" "???") :TEST
                         #'EQUAL))
           (SETQ NC (LENGTH (GEVSTRINGIFY TMP)))
           (IF (AND (> NC NCI) (CDR RES)) (SETQ QUIT T)
               (PROGN
                 (WHEN (> NC NCI)
                   (SETQ TMP "---")
                   (SETQ NC 3)
                   (SETQ QUIT T))
                 (PUSH (GEVSTRINGIFY TMP) RES)
                 (DECF NLEFT NC)
                 (SETQ VAL (CDR VAL))
                 (IF (EQ (CAR STR) 'LIST) (SETQ RSTR (CDR RSTR)))
                 (WHEN VAL (PUSH " " RES) (DECF NLEFT)))))
    (IF VAL (PUSH "..." RES))
    (PUSH ")" RES)
    (GEVCONCAT (NREVERSE RES))))

(DEFUN GEVSHORTSTRINGVAL (VAL NCHARS)
  (IF (STRINGP VAL) (GEVLENGTHBOUND VAL NCHARS) "???"))

(DEFUN GEVSHORTVALUE (VAL STR NCHARS)
  (LET (TMP)
    (SETQ STR (GEVXTRTYPE STR))
    (COND
      ((AND (ATOM STR) (MEMBER STR '(ATOM INTEGER REAL)))
       (GEVSHORTATOMVAL VAL NCHARS))
      ((EQ STR 'STRING) (GEVSHORTSTRINGVAL VAL NCHARS))
      ((AND (ATOM STR)
            (SETQ TMP (GEVEXPROP VAL STR 'SHORTVALUE 'PROP NIL))
            (NOT (EQ TMP 'GEVERROR)))
       (GEVLENGTHBOUND TMP NCHARS))
      ((OR (ATOM VAL) (NUMBERP VAL)) (GEVSHORTATOMVAL VAL NCHARS))
      ((STRINGP VAL) (GEVSHORTSTRINGVAL VAL NCHARS))
      ((CONSP STR)
       (CASE (CAR STR)
         ((LISTOF LIST)
          (IF (CONSP VAL) (GEVSHORTLISTVAL VAL STR NCHARS) "???"))
         (CONS (IF (CONSP VAL) (GEVSHORTCONSVAL VAL STR NCHARS) "???"))
         (T "---")))
      ((CONSP VAL) (GEVSHORTLISTVAL VAL '(LISTOF ANYTHING) NCHARS))
      (T "---"))))

(DEFUN GEVTYPE (TYPE VALUE) (OR (GLCLASS VALUE) TYPE))

(DEFUN GEVUSERSTR (OBJ)
  (SOME #'(LAMBDA (X) (FUNCALL (CADDR (GET X 'GEVINTERFACE)) OBJ))
        *GEVUSERTYPENAMES*))

(DEFUN GEVXTRTYPE (TYPE)
  (COND
    ((ATOM TYPE) TYPE)
    ((NOT (CONSP TYPE)) NIL)
    ((AND (MEMBER (CAR TYPE) '(A AN TRANSPARENT)) (CDR TYPE)
          (ATOM (CADR TYPE)))
     (CADR TYPE))
    ((MEMBER (CAR TYPE) *GLTYPENAMES*) TYPE)
    ((AND (BOUNDP *GLUSERSTRNAMES*)
          (ASSOC (CAR TYPE) *GLUSERSTRNAMES*))
     TYPE)
    ((AND (ATOM (CAR TYPE)) (CDR TYPE)) (GEVXTRTYPE (CADR TYPE)))
    (T (ERROR " ~S is an illegal type specification. ~S " TYPE
              'GEVXTRTYPE)
       NIL)))

(SETQ *GEVUSERTYPENAMES* NIL)
