; glisp.lsp           Gordon S. Novak Jr.                 ; 21 Sep 12
;                     Department of Computer Sciences
;                     University of Texas at Austin  78712-1188
;                     novak@cs.utexas.edu      (512) 471-9569

; Copyright (c) 2011 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

;  derived from {DSK}<LISPFILES>GLISP.CL;1  8-May-89 12:52:15 
; 02 Jan 97; 24 Jan 97; 28 Jan 97; 11 Mar 97; 14 Mar 97; 30 Sep 97; 29 Jan 98
; 10 Feb 98; 20 Mar 98; 11 May 98; 28 May 98; 16 Jul 98; 30 Jul 98; 10 Sep 98
; 23 Dec 98; 24 Dec 98; 28 Dec 98; 29 Dec 98; 30 Dec 98; 07 Jan 99; 13 Jan 99
; 15 Jan 99; 09 Feb 99; 18 Feb 99; 04 Mar 99; 05 Mar 99; 16 Mar 99; 17 Mar 99
; 18 Mar 99; 23 Mar 99; 01 Apr 99; 02 Apr 99; 20 May 99; 03 Jan 00; 05 Jan 00
; 07 Jan 00; 11 Feb 00; 15 Feb 00; 24 Feb 00; 03 Mar 00; 06 Mar 00; 08 Mar 00
; 12 Oct 00; 02 Nov 00; 28 Dec 00; 29 Dec 00; 01 Feb 01; 20 Feb 01; 31 Jan 02
; 26 Feb 02; 08 Mar 02; 12 Mar 02; 28 May 02; 08 Oct 02; 17 Oct 02; 22 Oct 02
; 24 Oct 02; 29 Oct 02; 19 Nov 02; 20 Nov 02; 26 Nov 02; 03 Dec 02; 04 Dec 02
; 23 Dec 02; 30 Dec 02; 08 Jan 03; 11 Jan 03; 04 Feb 03; 18 Feb 03; 20 Feb 03
; 11 Mar 03; 31 Mar 03; 22 Apr 03; 14 May 03; 15 May 03; 05 Jun 03; 23 Sep 03
; 17 Oct 03; 28 Oct 03; 30 Oct 03; 04 Nov 03; 24 May 04; 01 Jun 04; 10 Jun 04
; 01 Jul 04; 10 Aug 04; 11 Aug 04; 16 Aug 04; 20 Aug 04; 02 Sep 04; 22 Sep 04
; 23 Sep 04; 28 Sep 04; 26 Oct 04; 09 Nov 04; 10 Nov 04; 04 Jan 05; 24 Feb 05
; 01 Mar 05; 02 Mar 05; 05 Apr 06; 30 Jun 06; 17 Jul 06; 21 Jul 06; 12 Sep 06
; 14 Sep 06; 20 Sep 06; 21 Sep 06; 26 Sep 06; 05 Oct 06; 19 Oct 06; 26 Oct 06
; 06 Nov 06; 07 Nov 06; 15 Feb 07; 16 Feb 07; 20 Feb 07; 21 Feb 07; 23 Feb 07
; 06 Mar 07; 05 Apr 07; 20 Apr 07; 26 Apr 07; 25 Jul 07; 13 Sep 07; 27 Sep 07
; 28 Sep 07; 02 Oct 07; 25 Oct 07; 13 Nov 07; 20 Nov 07; 29 Nov 07; 04 Dec 07
; 02 Jan 08; 09 Jan 08; 10 Jan 08; 17 Jan 08; 22 Jan 08; 05 Feb 08; 18 Feb 08
; 19 Feb 08; 10 Mar 08; 25 Mar 08; 27 Mar 08; 02 Apr 08; 07 Apr 08; 07 May 08
; 15 May 08; 30 May 08; 15 Jul 08; 05 Dec 08; 18 Dec 08; 29 Dec 08; 30 Dec 08
; 31 Dec 08; 12 Jan 09; 28 Jan 09; 28 Jan 09; 10 Feb 09; 19 Feb 09; 31 Mar 09
; 09 Apr 09; 16 Apr 09; 21 Apr 09; 08 May 09; 12 May 09; 04 Jun 09; 04 Sep 09
; 08 Sep 09; 28 Sep 09; 12 Nov 09; 13 Nov 09; 16 Nov 09; 18 Nov 09; 20 Nov 09
; 08 Dec 09; 23 Dec 09; 05 Jan 10; 14 Jan 10; 15 Jan 10; 15 Feb 10; 24 Mar 10
; 14 Apr 10; 22 Apr 10; 23 Apr 10; 28 May 10; 14 Sep 10; 15 Sep 10; 29 Nov 10
; 01 Dec 10; 07 Dec 10; 22 Dec 10; 27 Dec 10; 29 Dec 10; 31 Dec 10; 05 Jan 11
; 13 Jan 11; 14 Jan 11; 20 Jan 11; 25 Jan 11; 27 Jan 11; 08 Feb 11; 11 Feb 11
; 25 Mar 11; 07 Apr 11; 12 Apr 11; 09 Nov 11; 16 Nov 11; 12 Sep 12

(dolist (x '( glptmatchbindings *glfn* *gl* *glval*

             *gladdisatype* *glcontext* *glexpr* *glexprstack* 
             *glfirst* *gldomainname* *glfnsubs* *glnatom* 
             *glnrecursions* *glproglst* *glsepatom* *glsepptr* 
             *gltopctx* *glparsopers* *glparsopnds* 
             *glprogresulttype* *glvalbusy* *glselfasglst*

             *glgevusertypenames* *glbasictypes* *glbreakonerror* 
             *glcautiousflg* *glglsendflg* *gllastfncompiled* 
             *gllaststredited* *gllispdialect* *glnosplitatoms* 
             *globjectnames* *glquietflg* *glsepbittbl*
             *glsepminus* *gltypenames* *gltypesused* *gltypesdefined*
             *glunitpkgs* *gluserstrnames* *glspecfncompiled*
             *glspecfnscompiled*

             *gllastpropcode* *gllastproparg* *gllastpropname*
             *glstrproptype* *glmaxinline* *glsilenceerrors*
             *glfounderror*))
  (eval (list 'defvar x nil))
  (setf (glispglobalvar x) t) )

(defvar *gldoexpr-trace* nil)
(defvar *glnull* nil)
(defvar *gltrue* t)
(defvar *glfalse* nil)
(defvar *glgensymnumber* 0)
(defvar *glmaxrecursions* 10)

(setq *glbasictypes* '(atom symbol integer real number string boolean
                            character anything))

(setq *gltypenames* '(cons list record crecord listof arrayof alist atom symbol
                           object proplist listobject atomobject tuple))

; Turn off undefined function warning for some names:
(defvar *glnoudfwarning*)
(setq *glnoudfwarning*
      '(stream dereference implementation known units declare ignore))

(defvar *glnounitunitywarning*)
(setq *glnounitunitywarning* nil)

(setq *globjectnames* nil)    ; list of all defined types
(setq *glspecfncompiled* nil)
(setq *glspecfnscompiled* nil)
(setq *glmaxinline* 50)       ; max size specialized fn to inline

(setq *glsilenceerrors* nil)
(setq *glfounderror* nil)

(setf (glstructure 'gltype)
      '((atom (proplist
               (glstructure (cons (strdes anything)
                                  (proplist
                                    (prop (listof glpropentry))
                                    (adj (listof glpropentry))
                                    (isa (listof glpropentry))
                                    (msg (listof glpropentry))
                                    (doc anything)
                                    (supers (listof gltype))) ))
               (glispatomnumber integer)
               (glpropfns (alist (str (listof glpropfnentry))
                                 (prop (listof glpropfnentry))
                                 (adj (listof glpropfnentry))
                                 (isa (listof glpropfnentry))
                                 (msg (listof glpropfnentry))))
               (glfnsusedin (listof glfunction))
               (glcluster glcluster)))
        default ((self nil))
        prop
         ((props          (prop))
          (adjs           (adj))
          (isas           (isa))
          (msgs           (msg))
          (propnames      ((for x in props collect (name x))))
          (components     glgetfields)
          (cluster        glcluster))))

(setf (glstructure 'glpropentry)
      '((cons (name atom)
              (cons (code anything)
                    (proplist (result gltype)
                              (open boolean))))
        prop ((shortvalue (name)))))

(setf (glstructure 'glpropfnentry)
      '((list (name atom)
              (code anything)
              (result gltype))))

(setf (glstructure 'glfunction)
      '((atom (proplist (gloriginalexpr anything)
                        (glcompiled anything)
                        (glfnresulttype anything)
                        (glarguments (listof glnametype))
                        (gltypesused (listof gltype))))))

(setf (glstructure 'viewer)
      '((cons (viewerflag atom)
              (cons (inputs (listof glnametype))
                    (cons (outputs (listof glnametype))
                          (cons (xfers (listof
                                        (list (xfername atom)
                                              (translation anything))))
                                (rest anything)))))))

(setf (glstructure 'glnametype) '((list (name symbol) (type gltype))) )

(setf (glstructure 'glcodetype) '((list (code anything) (type gltype))) )

(setf (glstructure 'glcluster)
      '((atom (proplist
               (glclusterdef (proplist
                              (roles (listof glnametype))
                              (supers (listof glcluster))))
               (glsubclusters (listof glcluster))))))

(setf (glstructure 'generic-pointer)
      '((anything
          adj     ((null          (self == (null-value self))))
          prop    ((dereference   (self) result (clustertype (typeof self)
                                                             'record))
                   (null-value    (nil))
                   (contents      (self))
                   (copy-contents (contents)) )
          default ((self nil))  )))

(setf (glstructure 'generic-c-pointer)
      '((anything prop ((null-value ('cnull))) supers (generic-pointer))))

(setf (get 'glispconstants 'glinfo)
      '("(glispconstants (var val [type])* )"
        "  e.g. (glispconstants (two 2 integer))"))

(setf (get 'glispglobals 'glinfo)
      '("(glispglobals (var type)* )"
        "  e.g. (glispglobals (earth planet))"))

 
#| didn't work
; 18-NOV-82; 19 Feb 09
(defmacro a (&rest l)
  (let (tp res)
    (setq tp (pop l))
    (if (eq (car l) 'with) (pop l))
    (while l
      (push (list 'quote (pop l)) res)
      (if (member (car l) '(= \:=))
          (pop l))
      (push (kwote (eval (pop l))) res) )
    (list 'glainterpreter 
          (cons 'list (cons (list 'quote tp) (nreverse res)))) ))

(setf (symbol-function 'an) (symbol-function 'a))
|#

; edited: 18-NOV-82
(defmacro a (&rest l) `(glainterpreter ',l))

; edited: 18-NOV-82
(defmacro an (&rest l) `(glainterpreter ',l))

(defun gl-a-an? (x) (or (eq x 'a) (eq x 'an)))

; 10 Nov 92
(defun gladdcolon (sym)
  (intern (concatenate 'string (symbol-name sym) ":")))

; 29 Dec 94
; Add a fact to the context
(defun gladdfact (fact context)  (push fact (first context)) )

; edited: 14-Aug-87; 20 Apr 07
; Add a PROPerty entry of type PROPTYPE to structure STRNAME. 
(defun gladdprop (strname proptype lst)
  (let (pl subpl ent)
    (cond ((not (and (symbolp strname)
                     (setq pl (glstr strname))))
            (error " ~S  has no structure definition." strname))
          ((setq subpl (getf (cdr pl) proptype))
            (if (setq ent (gladdpropmatch lst subpl))
                (setf (cdr ent) (cdr lst))
                (nconc subpl (list lst))))
          ((setq subpl (member proptype (cdr pl)))
            (setf (cadr subpl) (list lst)))
          (t (nconc pl (list proptype (list lst))))) ))


; edited: 16-Mar-89
; Add the Lisp CODE for the property PROPNAME whose type is PROPTYPE 
;   to the class definition TYPE 
; CODE is a list (code type) 
(defun gladdpropcode (type propname proptype code)
  (let (pl subpl propent)
    (cond ((consp type)
            (error "Bad type name"))
          ((not (member proptype '(str adj isa prop msg)))
            (error "Bad prop type"))
          ((setq pl (glpropfns type)))
          ((setf (glpropfns type)
                 (setq pl (copy-tree '((str) (prop) (adj) (isa) (msg)))))))
    (setq subpl (assoc proptype pl))
    (setq propent (assoc propname (cdr subpl)))
    (if propent (setf (cdr propent) code)
                (nconc subpl (list (cons propname code))))
    (car code)))

; 20 Apr 07; 04 Jun 09
; Look for an entry matching a prop/msg list lst in a list of entries, subpl.
; If an entry has argtypes, those must also match.
(defun gladdpropmatch (lst subpl)
  (let (done ent)
    (while (and subpl (not done))
      (setq ent (pop subpl))
      (if (and (eq (car ent) (car lst))
               (if (getf (cddr lst) 'specialization)
                   (getf (cddr ent) 'specialization)
                   t)
               (or (not (getf (cddr lst) 'argtypes))
                   (not (getf (cddr ent) 'argtypes))
                   (equal (getf (cddr lst) 'argtypes)
                          (getf (cddr ent) 'argtypes))))
          (setf done ent)) )
    done))

; edited: 17-Mar-89
; Add the type SDES to *GLPROGRESULTTYPE* in GLCOMP 
(defun gladdresulttype (sdes)
  (cond ((null *glprogresulttype*)
          (setq *glprogresulttype* sdes))
        ((and (consp *glprogresulttype*)
              (eq (car *glprogresulttype*) 'or))
          (unless (member sdes (cdr *glprogresulttype*) :test #'equal)
                  (nconc1 *glprogresulttype* sdes)))
        ((not (equal sdes *glprogresulttype*))
          (setq *glprogresulttype* (list 'or *glprogresulttype* sdes)))))


; 2-Jan-81; 05 Dec 89; 09 Oct 90; 26 Mar 91; 02 Nov 92; 21 Dec 94; 22 Dec 94
; 27 Dec 94
; Add an entry to the current context for a variable or code CODE,
; whose NAME in context is given, and which has type TYPE.
; The entry is pushed onto the front of the list at the head of the context.
; Changed representation of context, 21 Dec 94.
(defun gladdstr (code name type context)
  (if (and code (symbolp code))
      (if (and name (not (eq name code)))
          (push (list 'alias name code type) (first context))
          (push (list 'type code type) (first context)))
      (if name
          (push (list 'alias name code type) (first context))
          (glerror 'gladdstr "~A ~A ~A~%" code name type) ) ) )


; 20 Dec 90
(defun gladdstrb (atm name str context)
  (gladdstr atm name (gldeclfixstr str context) context))

; edited: 30-APR-83 15:43 
; Add properties to an object description which already exists. 
(defun gladdtoobject (lst)
(prog (objname propname propl tmp objdes props)
      (setq objname (car lst))
      (pop lst)
      lp
      (cond ((null lst)
             (return))
            ((or (consp (setq propname (car lst)))
                 (not (member propname '(prop adj isa msg))))
             (error "Improper args to GLADDTOOBJECT ~S " objname))
            ((null (setq objdes (glstr objname)))
             (error "No object description exists for  ~S " objname)))
      
; find or make a list for this property name. 

      (unless (setq propl (getf (cdr objdes)
                                propname))
              (nconc objdes (list propname (cadr lst)))
              (setq lst (cddr lst))
              (go lp))
      (setq props (cadr lst))
      (setq lst (cddr lst))
      lpb
      (cond ((null props)
             (go lp))
            ((setq tmp (assoc (caar props)
                              propl))
             (setf (cdr tmp)
                   (cdar props)))
            (t (nconc1 propl (car props))))
      (pop props)
      (go lpb)))


; edited: 30-APR-83
; Add properties to an already-existing object description. 
(defmacro gladdtoobjects (&rest args) `(gladdtoobjects-expr ',args))
(defun gladdtoobjects-expr (args) (mapc #'gladdtoobject args))


; edited: 16-Mar-89; 28 Dec 89; 24 Jan 90
; Compile code to test if SOURCE is PROPERTY. 
(defun gladj (source property adjwd)
  (prog (adjl trans tmp fetchcode res notflg)
    (cond ((eq adjwd 'isaself)
            (if (setq adjl (glstrprop property 'isa 'self nil))
                (go a)
                (return)))
          ((glviewerp (cadr source))
            (return (glviewervalue (car source) property adjwd (cadr source))))
          ((setq adjl (glstrprop (cadr source) adjwd property nil))
            (go a)))
      
; see if the adjective can be found in a transparent substructure. 

      (setq trans (gltransparenttypes (cadr source)))
  b   (cond ((null trans) (return))
            ((setq tmp (gladj (list '*gl* (glxtrtype (car trans)))
                              property adjwd))
              (if (and (setq fetchcode (glstrfn (car trans) (cadr source) nil))
                       (car fetchcode))
                  (glstrval tmp (car fetchcode)))
              (glstrval tmp (car source))
              (return tmp))
            (t (pop trans)
               (go b)))
  a   (when (and (consp (cadr adjl))
                 (eq (caadr adjl) 'not)
                 (symbolp (cadadr adjl))
                 (null (cddadr adjl))
                 (setq tmp (glstrprop (cadr source)
                                      adjwd
                                      (cadadr adjl)
                                      nil)))
            (setq adjl tmp)
            (setq notflg (not notflg))
            (go a))
      (setq res (glcompmsgl source adjwd adjl nil *glcontext*))
      (return (if notflg (list (glbuildnot (car res))
                               'boolean)
                  res))))


; 14 Nov 06
(defun gladjnames (obj)
  (append (glpropnames obj 'adj) (glpropnames obj 'isa)) )


; 24-Jan-89; 08 Jan 91; 21 Apr 91; 06 Nov 92; 26 Mar 93; 29 Mar 93; 26 Oct 93
; 03 Jan 95; 08 Oct 02
; Interpret code of the form (A <type> with prop = val ...) at runtime.
(defun glainterpreter (*glexpr*)
  (prog (*glnatom* *glfn* *glcontext* *glvalbusy* *glsepatom* *glsepptr* 
                 *glexprstack* *gltopctx* *glnrecursions*
                 *glselfasglst* type str pairs unitrec tmp
                 *gltypesdefined* newstr
                  datanames proppairs)
    (setq *glnatom* 0)
    (setq *glnrecursions* 0)
    (setq *glselfasglst* nil)
    (setq *glfn* 'glainterpreter)
    (setq *glvalbusy* t)
    (setq *glsepptr* 0)
    (setq *glcontext* (setq *gltopctx* (list nil)))
    (setq type (car *glexpr*))
    (cond ((setq str (glgetstr type))
            (pop *glexpr*))
          ((and (consp type) (glokstr? type))
            (pop *glexpr*)
            (setq str type))
          ((and (setq unitrec (glunit? type))
                (setq tmp (assoc 'a (caddr unitrec))))
            (return (funcall (cdr tmp) (cons 'a *glexpr*))))
          (t (glerror 'glainterpreter
                      "The type  ~A  is not defined." type)))
    (if (eq (car *glexpr*) 'with)
        (pop *glexpr*))
    (setq pairs (glgetdefaults type (glgetpairs *glexpr*)))
    (setq newstr (glmkstr str type pairs nil))
    (setq datanames (gldatanames type))
    (if (setq proppairs
              (subset #'(lambda (x) (and (not (member (car x) '(self)))
                                         (not (assoc (car x) datanames))))
                      pairs))
        (dolist (prop proppairs)
          (if (glpropdef type 'prop (car prop))
              (glsendb newstr type (gladdcolon (car prop)) 'msg (cadr prop))
              (glerror 'glainterpreter "The property ~A is not defined for ~A"
                       (car prop) type)) ) )
    (return newstr)))


; 15 Feb 07
(defun glallequations (obj)
  (let (result)
    (setq result (equations obj))
    (if (glclassp obj)
      (dolist (s (glget obj 'supers))
        (setq result (append result (glallequations s)))))
    result))


; 23 Apr 02; 15 Feb 07
; Get names and types of both record fields and computed props
(setf (glfnresulttype 'glallnames) '(listof glnametype))
(defun glallnames (type)
  (union (gldatanames type)
         (glpropnametypes type 'prop)
         :test #'(lambda (x y) (eq (car x) (car y))) ) )


; 14 Jan 10
; Get names and types of both record fields and computed props,
; but does not compile any props to get types
(setf (glfnresulttype 'glallnamesb) '(listof glnametype))
(defun glallnamesb (type)
  (union (gldatanames type)
         (glpropnametypesb type 'prop)
         :test #'(lambda (x y) (eq (car x) (car y))) ) )


; edited: 26-DEC-82
; AND operator 
(defun glandfn (lhs rhs)
  (cond ((null lhs) rhs)
        ((null rhs) lhs)
        ((and (consp (car lhs))
              (eq (caar lhs) 'and)
              (consp (car rhs))
              (eq (caar rhs) 'and))
          (list (append (car lhs) (cdar rhs))
                (cadr lhs)))
        ((and (consp (car lhs))
              (eq (caar lhs) 'and))
          (list (append (car lhs) (list (car rhs)))
                (cadr lhs)))
        ((and (consp (car rhs))
              (eq (caar rhs) 'and))
          (list (cons 'and (cons (car lhs) (cdar rhs)))
                (cadr lhs)))
        ((and (consp (cadr rhs))
              (eq (caadr rhs) 'listof)
              (equal (cadr lhs) (cadr rhs)))
          (list (list 'intersection (car lhs) (car rhs))
                (cadr rhs)))
        ((gldomsg lhs 'and (list rhs)))
        ((gluserstrop lhs 'and rhs))
        (t (list (list 'and (car lhs) (car rhs))
                 (cadr rhs)))) )

(defun glandorresulttypefn (fn argtypes)   (declare (ignore fn))
  (let (types)
    (setq types (list (car argtypes)))
    (dolist (type (cdr argtypes))
            (unless (member type types :test #'equal)
                    (push type types)) )
    (if (cdr types) (cons 'or types) (car types)) ))


; edited: 19-MAY-82; 12 Oct 90; 04 Feb 91; 11 Apr 91
; Test if ATM is the name of any CAR/CDR combination. If so, the value 
; is a list of the intervening letters in reverse order. 
(defun glanycarcdr? (atm)
  (prog (res n nmax tmp)
    (unless (symbolp atm) (return))
    (if (setq tmp (assoc atm '((car a)    (cdr d)    (cadr d a) (cdar a d)
                               (caar a a) (cddr d d) (caddr d d a)
                               (cadddr d d d a) (first a) (rest d)
                               (second d a) (third d d a) (fourth d d d a)
                               (fifth d d d d a))))
        (return (copy-list (cdr tmp))))
    (or (and (char= (nthchar atm 1) #\C)
             (char= (nthchar atm -1) #\R))
        (return))
    (setq nmax (1- (length (symbol-name atm))))
    (setq n 2)
 a  (cond ((> n nmax) (return res))
          ((char= (setq tmp (nthchar atm n)) #\D)
            (push 'd res) (incf n) (go a))
          ((char= tmp #\A) (push 'a res) (incf n) (go a))
          (t (return)))))


; edited: 10-Sep-86
; Acquire an instance of a data type based on its description. 
(defun glaqr (str) (glaqrb str nil 0 nil t))


; 10-Sep-86; 03 Nov 92
; Acquire an instance of a data type based on its description. str is 
;   the structure description of the data, name is the name of the 
;   structure, or nil, level is the depth level in the structure tree. 
(defun glaqrb (str name level prev dupok)
  (let (res new n)
    (push str prev)
    (cond ((and (member str (cdr prev))
                (not dupok))
            nil)
          ((null str) nil)
          ((symbolp str)
            (princ "(") (prin1 str) (princ ")")
            (if (glbasictypep str)
                (glaqrrd str)
                (glaqrstr str level prev)))
          ((atom str) (error "Invalid structure: ~S " str))
          ((member (car str) *gltypenames*)
            (cond ((member (car str) '(atom symbol))
                    (setq new (glmkatom (or name 'glaqr)))
                    (dolist (y (cdr str))
                      (cond ((eq (car y) 'proplist)
                              (dolist (x (cdr y))
                                (setf (get new (car x))
                                      (glaqrb x nil (1+ level) prev nil))))
                            ((eq (car y) 'binding)
                              (set new (glaqrb (cadr y) nil (1+ level)
                                               prev nil)))))
                    new)
                  ((eq (car str) 'listof)
                    (glaqrlistof (cadr str) (1+ level) prev))
                  (t (dolist (x (if (and (eq (car str) 'record)
                                         (symbolp (cadr str)))
                                    (cddr str)
                                    (cdr str)))
                       (push (cons (and (consp x) (car x))
                                   (glaqrb x nil (1+ level) prev nil))
                             res))
                     (setq res (nreverse res))
                     (case (car str)
                       (cons (cons (cdar res) (cdadr res)))
                       (list (mapcar #'cdr res))
                       (alist res)
                       (proplist (mapcan #'(lambda (x)
                                             (list (car x) (cdr x)))
                                         res))
                       (atomobject (setq new (glmkatom (or name 'glaqr)))
                                   (setf (globjclass new) name)
                                   (dolist (x res)
                                     (setf (get new (car x)) (cdr x)))
                                   new)
                       ((object record)
                         (setq new (glmkrecord
                                     (cond ((eq (car str) 'object)
                                             (1+ (length (cdr str))))
                                           ((symbolp (cadr str))
                                             (length (cddr str)))
                                           (t (length (cdr str))))
                                     (and (symbolp (cadr str)) (cadr str))))
                         (setq n 0)
                         (when (eq (car str) 'object)
                           (setf (aref new 0) name)
                           (incf n))
                         (dolist (x res)
                           (setf (aref new n) (cdr x))
                           (incf n))
                         new)
                       (listobject (cons name (mapcar #'cdr res)))))))
          ((eq (car str) 'transparent)
            (glaqrb (cadr str) nil (1+ level) prev nil))
          (t (spaces (+ level level))
             (prin1 (car str))
             (princ ": ")
             (glaqrb (cadr str) (car str) (1+ level) prev nil)))))


; edited: 10-Sep-86; 27 Nov 89
; Acquire a list of items. 
(defun glaqrlistof (str level prev)    (declare (ignore prev))
  (let (res)
    (format t "(listof ~A)~%" str)
    (while (y-or-n-p "More?")
           (push (glaqrb str nil level nil t) res))
    (nreverse res) ))


; Read in a single item 
(defun glaqrrd (str)  (declare (ignore str))  (read))


; edited: 10-Sep-86; 27 Nov 89
(defun glaqrstr (str level prev)    (declare (ignore prev))
  (terpri)
  (if (or (eql level 0)
          (y-or-n-p "Acquire a new value?"))
      (glaqrb (car (glstr str)) str (1+ level) nil t)
      (progn (princ "Enter existing value:")
             (eval (read)))))


; 13 Dec 89; 01 Oct 91; 30 Oct 03
(defun glarefresulttypefn (fn argtypes)    (declare (ignore fn))
  (let ((arrtype (glxtrtypeb (car argtypes))))
    (and (consp arrtype)
         (eq (car arrtype) 'arrayof)
         (cadr arrtype) ) ))


; 26 May 95; 29 May 95; 16 Jul 98; 03 Mar 00; 20 Feb 01
; Parse an argument list. Each element of the list is of the form:
; <var>, <var>\:<type>, or (var type) or (var value).
; If letflg = t, a sublist is assumed to be (var value), else (var type).
; The result is a list (var value type omit).
(defun glarglist (lst &optional letflg)
  (let (result first second third top item var value type)
    (while lst
      (setq type nil)
      (if (consp (setq top (pop lst)))
          (if (and (eq (car top) 'omit) (not letflg) (consp (cdr top)))
              (setq item (if (consp (cadr top))
                             (list (caadr top) nil (cadadr top) t)
                             (list (cadr top) nil nil t)))
              (setq item
                    (if letflg (list (car top) (cadr top) nil)
                               (list (car top) nil (cadr top)))))
          (progn
            (glsepinit top)
            (setq first (glsepnxt))
            (setq second (glsepnxt))
            (when (and (eq first '*) second)   ; fix for globals e.g. *var*
              (setq first top)
              (setq second nil))
            (setq var first)
            (if (eq second '\:)
                (if (and (setq third (glsepnxt))
                         (glokstr? third)
                         (null (glsepnxt)))
                    (setq type third)
                    (if (and (null third)
                             (glokstr? (car lst)))
                        (setq type (pop lst))
                        (glerror 'glarglist "Bad arg list ~A" lst))))
            (setq item (list var value type))))
      (push item result) )
    (nreverse result) ))

(setf (glfnresulttype 'glargs) '(listof glnametype))

; 13 Nov 07; 15 Sep 10
; get argument list ((name type) ...) for a function
(defun glargs (fn)
  (let (names res optionalflag)
    (or (glargsb fn)
        (and (glarity fn)
             (setq names
                   (or (and (fboundp fn)
                            (consp (symbol-function fn))
                            (if (eq (car (symbol-function fn)) 'lambda)
                                (second (symbol-function fn))
                                (if (eq (car (symbol-function fn)) 'lambda-block)
                                    (third (symbol-function fn)))))
                       *conn-default-args*))
             (dotimes (i (glarity fn) (reverse res))
               (if (eq (car names) '&optional) (setq optionalflag t))
               (if (not optionalflag)
                   (push (list (pop names)
                               (if (glargsnumberp fn) 'number 'anything))
                         res)))) ) ))

; 15 Sep 10
(defun glargsb (fn)
  (or (glarguments fn)
      (and (glgetd fn)
           (mapcar #'(lambda (x)
                       (if (eq (car x) '&optional)
                           (car x)
                           (list (first x) (third x))))
                   (glarglist (second (glgetd fn)))))) )


; 13 Nov 07; 23 Dec 09; 15 Sep 10
; ***** GCL dependent
(defun glarity (fn)
  (let (args)
    (setq args
          (or (glargsb fn)
              (and (fboundp fn)
                   (consp (symbol-function fn))
                   (if (eq (car (symbol-function fn)) 'lambda)
                       (second (symbol-function fn))
                       (if (eq (car (symbol-function fn)) 'lambda-block)
                           (third (symbol-function fn)) ) ) ) ) )
    (or (and args (consp args)
             (if (member '&optional args)
                 (1- (length args))
                 (length args)) )
        (and (fboundp fn)
             (get fn 'compiler::arg-types)
             (if (eq (car (get fn 'compiler::arg-types)) '*)
                 2
                 (length (get fn 'compiler::arg-types))) )
        2) ))  ; if all else fails

; edited:  1-FEB-83
; Test whether STR is a legal ATOM structure. 
(defun glatmstr? (str)
  (prog (tmp)
      (if (or (and (cdr str)
                   (or (symbolp (cadr str))
                       (and (cddr str)
                            (or (symbolp (caddr str))
                                (cdddr str))))))
          (return))
      (if (setq tmp (assoc 'binding (cdr str)))
          (if (or (cddr tmp)
                  (null (glokstr? (cadr tmp))))
              (return)))
      (if (setq tmp (assoc 'proplist (cdr str)))
          (return (every #'(lambda (x)
                             (and (symbolp (car x))
                                  (glokstr? (cadr x))))
                         (cdr tmp))))
      (return t)))


; edited: 16-Mar-89
; Try to get indicator IND from an ATOM structure. 
(defun glatomstrfn (ind des deslist)
  (let (tmp)
    (or (and (setq tmp (assoc 'proplist (cdr des)))
             (glpropstrfn ind tmp deslist t))
        (and (setq tmp (assoc 'binding (cdr des)))
             (glstrvalb ind (cadr tmp) deslist '(eval *gl*))))))


; edited: 23-DEC-82
; Test whether TYPE is implemented as an ATOM structure. 
(defun glatomtypep (type)
  (let (typeb)
    (or (member type '(atom symbol))
        (and (consp type)
             (member (car type) '(atom symbol atomobject)))
        (and (not (eq (setq typeb (glxtrtypeb type))
                      type))
             (glatomtypep typeb)))))

; 01 Nov 91; 29 May 92; 13 Oct 92; 03 Nov 92; 29 Sep 93
; Find the base type, i.e., actual data structure, from a view type.
(defun glbasetype (type)
  (let (rec str)
    (if type
        (if (setq rec (glpointsto type))
            (if (and (symbolp type)
                     (setq str (glxtrtype (car (glstructure type))))
                     (glbasictypep str))
                str
                (glbasetype rec))
            (if (or (consp type)
                    (glbasictypep (setq str (glxtrtype
                                             (car (glstructure type)))))
                    (equal str type))
                type
                (glbasetype str)))) ))

; 03 May 91; 03 Nov 92; 05 Nov 92; 07 Apr 08
; Test for basic data types: either a member of *glbasictypes*
; or (units <stored-type> <unit> <substance>)
(defun glbasictypep (x)
  (or (and (symbolp x)
           (member x *glbasictypes*))
      (and (glunittypep x)
           (if (consp x)
               (member (cadr x) *glbasictypes*)
               (and (consp (car (glstr x)))
                    (eq (caar (glstr x)) 'units)
                    (member (cadar (glstr x)) *glbasictypes*))) ) ) )

; 07 Nov 06
; Test for basic data type as stored form
(defun glbasictypexp (x)
  (or (glbasictypep x)
      (glbasictypep (glxtrtypeb x))))

; 2-Mar-88; 21 Dec 94; 22 Dec 94
; Make a binding list BL ((name code type) ...) into a CONTEXT structure 
(defun glbindingtocontext (bl)
  (mapcar #'(lambda (x) (cons 'alias x))
          (cdr bl)))

; 06 Oct 92
; Make a binding list BL into code 
(defun glbindingtocode (bl)
  (if (symbolp (cadadr bl))
      (list 'prog1 (cadadr bl))
      (cadadr bl)) )

; 09 Oct 92; 07 Sep 93
(defun glbindingtocodetype (bl)
  (list (if (symbolp (cadadr bl))
            (list 'prog1 (cadadr bl))
            (cadadr bl))
        (caddr (cadr bl)) ) )

; 17 Nov 93
; Make a bit mask n bits wide
(defun glbitmask (n) (if (> n 0) (1- (expt 2 n)) 0))

; 10 Jun 04
; Test if code returns a boolean value
(defun glboolean (c)
  (or (null c) (eq c t)
      (and (consp c)
           (or (member (car c) '(eq eql equal = equalp numberp zerop
                                    floatp fixp < <= > >= string=
                                    string< string<= string> string>=
                                    char= char< char<= char> char>=
                                    null not consp symbolp))
               (and (member (car c) '(and or))
                    (every #'glboolean (cdr c)))))))

; edited: 16-Mar-89; 17 Oct 03
(defun glbuildalist (alist pairlist prevlst)
  (prog (lis alistpair substr)
 a  (unless alist (return (and lis (glbuildlist lis nil))))
    (setq alistpair (pop alist))
    (if (setq substr (glbuildstr alistpair pairlist prevlst))
        (setq lis (nconc1 lis (glbuildcons (kwote (car alistpair))
                                           substr nil))))
    (go a)))


; edited:  9-DEC-82; 05 Apr 90
; Generate code to build a CONS structure. OPTFLG is true iff the 
;   structure does not need to be a newly created one. 
(defun glbuildcons (x y optflg)
  (cond ((null y) (glbuildlist (list x) optflg))
        ((and (consp y)
              (eq (car y) 'list))
          (glbuildlist (cons x (cdr y)) optflg))
        ((and optflg (glconstantp x)
              (glconstantp y))
          (kwote (cons (glconstval x) (glconstval y))))
        ((and (glconststr? x)
              (glconststr? y))
          (list 'copy-tree
                (kwote
                      (cons (glconstval x)
                            (glconstval y)))))
        (t (list 'cons x y))))


; edited:  9-DEC-82; 17 Oct 89; 05 Apr 90; 09 Oct 90
; Build a LIST structure, possibly doing compile-time constant 
;   folding. OPTFLG is true iff the structure does not need to be a 
;   newly created copy. 
(defun glbuildlist (lst optflg)
  (cond ((every #'glconstantp lst)
          (if optflg (kwote (mapcar #'glconstval lst))
                     (glgencode (if (cdr lst) 
                                    (list 'copy-list
                                          (kwote
                                                (mapcar #'glconstval lst)))
                                    (list 'cons (kwote (glconstval (car lst)))
                                          nil)))))
        ((every #'glconststr? lst)
          (glgencode (list 'copy-tree
                           (kwote (mapcar #'glconstval lst)))))
        (t (cons 'list lst))))


; edited:  8-Aug-86; 30 Nov 89
; Build code to do (NOT CODE) , doing compile-time folding if possible. 
(defun glbuildnot (code)
  (let (tmp)
    (cond ((glconstantp code) (not (glconstval code)))
          ((symbolp code) (list 'not code))
          ((eq (car code) 'not) (cadr code))
          ((consp (car code)) nil)
          ((setq tmp (assoc (car code) '((> <=) (< >=) (<= >) (>= <))))
             (cons (cadr tmp) (cdr code)))
          (t (list 'not code)))))


; edited: 16-Mar-89; 30 Nov 89; 19 Jan 90; 22 Apr 03
(defun glbuildproplist (plist pairlist prevlst)
  (let (lis tmp)
    (dolist (str plist)
      (if (and (assoc (car str) pairlist)  ; only do it if prop specified
               (setq tmp (glbuildstr str pairlist prevlst)))
        ; was  (push (list (kwote (car str)) tmp) lis)
          (progn (push (kwote (car str)) lis) (push tmp lis)) ) )
    (if lis (glbuildlist (nreverse lis) nil)) ))

; edited: 28-Feb-89; 19 Jan 90; 09 Apr 92
; Build a RECORD structure. 
(defun glbuildrecord (str pairlist prevlst)
  (let (items recordname)
    (if (symbolp (cadr str))
        (progn (setq recordname (cadr str))
               (setq items (cddr str)))
        (setq items (cdr str)))
    (if (eq (car str) 'object)
        (push '(class atom) items))
    (if (eq (car str) 'crecord)
        (list 'glmakecrecord (kwote recordname)
              (glbuildalist items pairlist prevlst))
        (list 'make-array
              (length items)
              ':initial-contents
              (glbuildlist (mapcar #'(lambda (x)
                                       (glbuildstr x pairlist prevlst))
                                   items)
                           t)))))


; 20 Apr 92; 21 Apr 92; 09 Nov 92; 14 Sep 06; 04 Sep 09
; Make code to build a representation if one is defined.
; goal is (<name> <type>), contents is (<name> <value> <type>).
(defun glbuildrep (goal contents)
  (let ((type (cadr goal)) propl tmp code putcode lhs)
    (if (and (symbolp type)
             (glnonbasictypep type)
             (not (eq type (caddr contents))))
        (if (or (setq code
                      (gldomsg (setq lhs (list (glgensym 'glvar) type))
                               'representation\:
                               (list (list (cadr contents) (caddr contents)))))
                (and (setq propl (glstrprop type 'prop 'representation nil))
                     (setq lhs (list (glgensym 'glvar) type))
                     (setq tmp (glcompmsgl lhs 'prop propl nil nil))
                     (setq putcode (glputfn (list (list 'glrepresentation
                                                        (car tmp) lhs)
                                                  (cadr tmp))
                                            (list (cadr contents)
                                                  (caddr contents))
                                            nil))
                     (setq code (list (if (eq (caar putcode) 'setq)
                                          (caddar putcode)
                                          (if (and (eq (caar putcode) 'progn)
                                                   (eq (caadar putcode) 'setq))
                                              (caddr (cadar putcode))
                                              (glerror 'glbuildrep
                                                       "bad put code ~A"
                                                       putcode)))
                                      (cadr putcode)))))
            (if (glconstantb (cadr contents))
                (glkwote (eval (car code)))
                (car code))
            (glcoercestr (cadr goal) (cdr contents)))
        (if (equal type (caddr contents))
            (cadr contents)
            (or (car (glcoercedata type (cdr contents)))
                (cadr contents))) ) ))


; 27 Sep 89; 17 Oct 89; 30 Nov 89; 04 Dec 89; 13 Dec 89; 01 Jun 90
; 19 Jul 90; 03 Oct 90; 09 Oct 90; 24 Oct 90; 21 Nov 90; 31 Jan 91; 09 Apr 92
; 20 Apr 92; 23 Apr 92; 03 Nov 92; 09 Nov 92; 27 Mar 93; 30 Mar 93; 26 Oct 93
; 27 Jan 94; 22 Sep 04; 14 Sep 06
; Generate code to build a structure according to the structure 
;   description STR. PAIRLIST is a list of elements of the form 
;   (SLOTNAME CODE TYPE) for each named slot to be filled in in the 
;   structure. 
(defun glbuildstr (str pairlist prevlst)
(let (temp progg tmpcode ptr tmp)
  (if (symbolp str)
      (cond ((null str) nil)
            ((glbasictypep str)
               (if (and (null (cdr pairlist))
                        (eq (caar pairlist) 'self)
                        (gltypematch (caddar pairlist) str))
                   (cadar pairlist)
                   (gldefaultvalue str)))
            ((member str prevlst) nil)
            ((glbuildview str pairlist prevlst))
            ((setq temp (glgetstr str))
              (if prevlst (glbuildstr temp nil (cons str prevlst))
                          (glbuildstr temp pairlist (cons str prevlst))))
            ((and (not (and (setq tmp (glpointerp str))      ; 19 Jul 90
                            (member tmp prevlst)))
                  (glpropdef str 'msg 'new)
                  (setq temp (gldomsg (list nil str) 'new nil)))
              (car temp))
            ((setq temp (glgetdefault str 'self))
              (cadr temp))
            (t nil))
      (case (car str)
          (cons (glbuildcons (glbuildstr (cadr str) pairlist prevlst)
                             (glbuildstr (caddr str) pairlist prevlst)
                             nil))
          (list (glbuildlist (mapcar #'(lambda (x)
                                         (glbuildstr x pairlist prevlst))
                                     (cdr str))
                             nil))
          (listobject (glbuildlist
                       (cons (kwote (car prevlst))
                             (mapcar #'(lambda (x)
                                         (glbuildstr x pairlist prevlst))
                                     (cdr str)))
                       nil))
          (alist (glbuildalist (cdr str) pairlist prevlst))
          (tuple (glbuildlist (cons 'tupleobject
                                    (cons (kwote (car prevlst))
                                          (mapcar #'(lambda (x)
                                            (glbuildstr x pairlist prevlst))
                                                  (cdr str))))
                              nil))
          (proplist (glbuildproplist (cdr str) pairlist prevlst))
          ((atom symbol)
                (setq progg
                      (list 'let
                            (list (list 'atomname
                                        (if (and prevlst
                                                 (symbolp (car prevlst)))
                                            (list 'glgensym
                                                  (kwote (car prevlst)))
                                            (list 'gensym))))))
                (when (setq temp (assoc 'binding (cdr str)))
                      (setq tmpcode (glbuildstr (cadr temp)
                                                pairlist prevlst))
                      (nconc1 progg (list 'set 'atomname tmpcode)))
                (if (setq temp (assoc 'proplist (cdr str)))
                    (nconc progg (list (glputprops (cdr temp)
                                                   pairlist prevlst))))
                (nconc progg (list 'atomname))
                progg)
          (atomobject (setq progg
                        (list 'let
                              (list (list 'atomname
                                          (if (and prevlst
                                                   (symbolp (car prevlst)))
                                              (list 'glgensym
                                                    (kwote (car prevlst)))
                                              (list 'gensym))))))
                      (nconc progg (list (glputprops (cdr str)
                                                     pairlist prevlst)))
                      (nconc1 progg (glgencode
                                     (list 'setf
                                           (list 'get 'atomname
                                                 (kwote 'class))
                                           (kwote (car prevlst)))))
                      (nconc progg (list 'atomname)) )
          (transparent (and (symbolp (cadr str))
                            (not (member (cadr str) prevlst))
                            (glgetstr (cadr str))
                            (glbuildstr (glgetstr (cadr str)) pairlist
                                        (cons str prevlst))))
          (listof nil)
          (arrayof (append '(make-array) (or (cddr str) (list 1))
                           (list ':element-type (kwote (cadr str)))))
          ((record crecord) (glbuildrecord str pairlist prevlst))
          (object (glbuildrecord str (cons (list 'class
                                                 (kwote (car prevlst))
                                                 'atom)
                                           pairlist)
                                 prevlst))
          (^ (setq ptr (glgetpointer (cadr str)))
             (if (or (null ptr)
                     (and (setq tmp (car (glstr ptr)))
                          (consp tmp)
                          (eq (car tmp) '^)
                          (eq (cadr tmp) (cadr str))))
                 nil
                 (if (setq tmp (glvalue nil 'null-value ptr nil))
                     (car tmp))))
          (t (if (symbolp (car str))
                 (cond ((setq temp (assoc (car str) pairlist))
                         (if (glvvct (cdr temp))                ; 24 Oct 90
                             (car (glmaterialize (cdr temp)
                                                  (glxtrtype (cadr str)) nil)) 
                             (glbuildrep str temp)))
                       ((setq temp (assoc (car str) *gluserstrnames*))
                        (funcall (nth 5 temp)
                                 str pairlist prevlst))
                       ((and (symbolp (cadr str))
                             (not (glbasictypep (cadr str))))
                        (glbuildstr (cadr str) nil prevlst))
                       (t (glbuildstr (cadr str)
                                      pairlist prevlst)))))) )))


; 09 Nov 92
; Build a structure through a view: given a view V, T1 --> V --> T2,
; build a T1 structure from the parameters of a T2.  Returns NIL if
; the appropriate parameters are not defined.
(defun glbuildview (str pairlist prevlst)     (declare (ignore prevlst))
  (let (tmp argnames newargs)
    (when (and (symbolp str)
               (glnonbasictypep str)
               (setq tmp (glstrprop str 'prop 'glbasisvars nil))
               (glstrprop str 'msg 'glbuildfromview nil))
      (setq argnames (cadr (caadr tmp)))
      (setq newargs (mapcar #'(lambda (x) (cdr (assoc x pairlist)))
                            argnames))
      (first (gldomsg (list nil str) 'glbuildfromview newargs)) ) ))

; edited: 27-Sep-88
; Build a virtual structure given a list of slot/value pairs. 
; The structure will be materialized later if necessary. 
(defun glbuildvstr (type pairlist)
  (list (cons 'glvirtual (cons type pairlist))
        (list 'virtual type)))


; edited: 13-JAN-82; 01 Aug 91
; Test if X is a CAR or CDR combination up to 3 long.  Result is length.
(defun glcarcdr? (x)
  (cadr (assoc x '((car 1) (cdr 1) (caar 2) (cadr 2) (cdar 2) (cddr 2)
                   (caaar 3) (caadr 3) (cadar 3) (cdaar 3) (caddr 3)
                   (cdadr 3) (cddar 3) (cdddr 3) (first 1) (rest 1)
                   (second 2) (third 3)) )) )


; edited: 14-MAR-83; 31 Dec 91; 17 Jan 08; 22 Dec 10
; Find the result type for a CAR/CDR function applied to a structure 
;   whose description is STR. LST is a list of A and D in application 
;   order. 
(defun glcarcdrresulttype (lst str)
  (cond ((null lst) (glxtrtype str))
        ((null str) nil)
        ((glbasictypep str) nil)
        ((symbolp str) (glcarcdrresulttype lst (glgetstr str)))
        ((and (consp str) (eq (car str) '^))
          (glcarcdrresulttype lst (cadr str)))
        ((and (consp str) (eq (car str) 'arrayof)) (cadr str))
        (t (glcarcdrresulttypeb lst (glxtrtype str)))))


; edited: 22-Aug-86
; Find the result type for a CAR/CDR function applied to a structure 
;   whose description is STR. LST is a list of A and D in application 
;   order. 
(defun glcarcdrresulttypeb (lst str)
  (cond ((null str) nil)
        ((symbolp str) (glcarcdrresulttype lst str))
        ((and (symbolp (car str))
              (not (member (car str) *gltypenames*))
              (cdr str)
              (null (cddr str)))
          (glcarcdrresulttype lst (cadr str)))
        ((eq (car lst) 'a)
          (if (member (car str) '(listof cons list))
              (glcarcdrresulttype (cdr lst) (cadr str))))
        ((eq (car lst) 'd)
          (cond ((eq (car str) 'cons)
                 (glcarcdrresulttype (cdr lst) (caddr str)))
                ((eq (car str) 'list)
                  (if (cddr str)
                      (glcarcdrresulttype (cdr lst)
                                          (cons 'list (cddr str)))))
                ((eq (car str) 'listof)
                  (glcarcdrresulttype (cdr lst) str))))
        (t (error "NOMSG"))))

; 26 Oct 93
; Compute result type for cbrt (cube root)
(defun glcbrtresulttypefn (fn argtypes)     (declare (ignore fn))
  (let (unittp)
    (if (glunittypep (setq unittp (first argtypes)))
        (list 'units 'real (glcbrtunit (third unittp)))
        'real) ))     ; was (glnumresulttypefn fn argtypes).  Why???

; edited:  5-Sep-86
(defun glcc (&optional fn)
  (or fn (setq fn *gllastfncompiled*))
  (if (glgetd fn)
      (glcompile fn)
      (format t "~A ?~%" fn) ) )

; 03 Jan 94; 04 Jan 94
; Compile if not already compiled; silent if undefined.
(defun glcc? (fn) (or (glcompiled fn)
                      (and (glgetd fn)
                           (fboundp fn)
                           (consp (symbol-function fn))
                           (glcompile fn))))

; 09 Apr 92
; Get a field from an ersatz C record at runtime
; C record is (CRECORD type fields), e.g. (CRECORD MYLLREC (FOO . 7))
(defun glcfield (rec prop) (cdr (assoc prop (cddr rec))))

; 29 Oct 02
(defun glcfield-setf (rec prop value)
  (if (and (consp rec) (eq (car rec) 'crecord))
      (let ((pair (assoc prop (cddr rec))))
        (if pair
            (setf (cdr pair) value)
            (nconc rec (list (cons prop value))))
        value)
      (error "Bad data for GLCFIELD: ~A~%" rec)))

(defsetf glcfield glcfield-setf)

; edited:  6-Mar-89; 27 Dec 91; 09 Apr 92; 28 Oct 03
; Get the Class of object OBJ. 
(defun glclass (obj)
  (let (class str)
    (and (setq class (cond ((arrayp obj) (aref obj 0))
                           ((symbolp obj)
                             (if (glstr obj) 'gltype (globjclass obj)))
                           ((consp obj)
                             (if (eq (car obj) 'crecord)
                                 (cadr obj)
                                 (and (symbolp (car obj))
                                      (consp (car (glstr (car obj))))
                                      (member (caar (glstr (car obj)))
                                              '(object listobject))
                                      (car obj))))
                           ((and (fboundp 'glusergetclass)
                                 (glusergetclass obj)))
                           (t nil)))
         (glclassp class)
         (or (not (consp obj))
             (and (setq str (glxtrtypec class))
                  (consp str)
                  (member (car str) '(listobject crecord))))
         class)))


; edited: 11-NOV-82
; Test whether the object OBJ is a member of class CLASS. 
(defun glclassmemp (obj class)
  (gldescendantp (glclass obj) class))


; edited: 22-JUL-83
; See if CLASS is a Class name. 
(defun glclassp (class) (and (symbolp class) (glstr class)))


; edited: 26-Oct-87; 21-Feb-89
; Execute a message to CLASS with selector SELECTOR and arguments 
;   ARGS. PROPNAME is one of MSG, ADJ, ISA, PROP. 
(defun glclasssend (class selector args propname)
  (let (fncode)
    (if (setq fncode (car (glcompprop class selector propname nil)))
        (apply fncode args)
        'glsendfailure)))


; 21 May 90; 18 Jan 96
(defun glclusterrole (cluster-name role-name)
  (cadr (assoc role-name (glclusterroles cluster-name))) )


; 2-Jan-81; 31 Aug 90; 21 Dec 94; 22 Dec 94; 31 May 95
; Find the (code type) for a VAR in a CONTEXT structure.
(setf (glinfo 'glcodetype)
      '("Looks up VAR in CONTEXT to see if it has a type or is an alias."
        "Returns (code type)."))
(defun glcodetype (var context)
  (let (tmp)
    (and context
         (if (setq tmp (find-if #'(lambda (l)
                                    (and (member (first l) '(type alias))
                                         (eq (second l) var)))
                                (car context)))
             (if (eq (first tmp) 'type)
                 (cdr tmp)
                 (cddr tmp))
             (glcodetype var (cdr context))) ) ))


; 5-Aug-88; 16-Mar-89; 03 Nov 92
; Coerce an item RHS into the desired type. cf. GLVIEWERPUT.
; RHS must be quoted data, e.g. (v + '(3 4)) where v is a VECTOR will
; call glcoerce to coerce '(3 4) into a vector.
(defun glcoerce (rhs goaltype)
  (let (fields val tmp pairlist parts parttypes rhstp rhsop)
    (setq fields (glgetfields goaltype))
    (when (quotep (car rhs))
      (setq rhsop (caar rhs))
      (setq parts (cadar rhs))
      (setq rhstp (cadr rhs))
      (setq parttypes (cond ((consp rhstp) (cdr rhstp))
                            ((symbolp rhstp)  (cdr (glstr rhstp)))
                            (t (error "NOMSG"))))
      (setq pairlist
            (mapcan #'(lambda (field)
                        (if (setq val (if rhsop
                                          (list (if (eq rhsop 'quote)
                                                    (kwote (pop parts))
                                                    (pop parts))
                                                (cond ((eq (caadr rhs) 'listof)
                                                        (cadadr rhs))
                                                      ((eq (caadr rhs) 'list)
                                                        (pop parttypes))
                                                      (t (glconstanttype
                                                          tmp))))
                                          (glvalue (car rhs) field (cadr rhs)
                                                   nil)))
                            (list (cons field val))))
                    fields))
      (glbuildvstr goaltype pairlist) ) ))


; 16 Nov 09; 18 Nov 09; 20 Nov 09; 14 Jan 10
; Test whether type 'from' can be coerced to type 'to'
; because all data elements of 'to' are defined for 'from'
(defun glcoerceablep (from to)
  (let (nametypes)
    (and from to (symbolp from)
         (symbolp to)
         (not (eq from to))
         (not (glbasictypep from))
         (not (glbasictypep to))
         (setq nametypes (glallnamesb from))
         (every #'(lambda (x) (assoc (car x) nametypes))
                (gldatanames to)) ) ))


; 13 Feb 96; 16 Nov 09; 14 Sep 10; 15 Sep 10; 27 Jan 11
; Coerce arguments of a function call to meet either:
;   specified units, e.g. (sin x) requires radians
;   requirement that all units be the same, as in (max x y)
; argl = ((code type) ...)
(defun glcoerceargs (fnname argl)
  (let ((argtypes (glarguments fnname))
        (argssame (glargssame fnname)) optflg res)
    (if argtypes
        (progn
          (while (and argl argtypes)
            (if (eq (car argtypes) '&optional)
                (progn (setq optflg t)
                       (pop argtypes)) )
            (when (and argl argtypes)
              (setq codetype (pop argl))
              (setq goal (pop argtypes))
              (push (if (and (glunittypep (cadr codetype))
                             (glunittypep (cadr goal)))
                        (glcoercedata (cadr goal) codetype)
                        (if (glcoerceablep (cadr codetype) (cadr goal))
                            (list (glcoercestr (cadr goal) codetype)
                                  (cadr goal))
                            (if (glcoercepropl (cadr goal) (cadr codetype))
                                (list (car codetype) (cadr goal))
                                codetype)))
                    res) ) )
          (if (and argl (null argtypes))
              (glerror 'glcoerceargs "Too many args for ~A" fnname))
          (if (and argtypes (null argl) (not optflg)
                   (consp argtypes) (not (eq (car argtypes) '&optional)))
              (glerror 'glcoerceargs "Not enough args for ~A" fnname))
          (reverse res) )
        (if argssame
            (mapcar #'(lambda (codetype)
                        (if (and (glunittypep (cadr codetype))
                                 (glunittypep (cadar argl)))
                            (glcoercedata (cadar argl) codetype)
                            codetype))
                    argl)
            argl)) ))

; 15-Aug-88; 30 May 90; 02 May 91; 07 May 91; 03 Nov 92; 05 Nov 92; 06 Nov 92
; 30 Nov 92; 03 Dec 92; 29 Sep 93
; Try to coerce one operand so an arithmetic expression will work. 
(defun glcoercearith (op lhs rhs)
  (let (newopnd lhstp rhstp)
    (setq lhstp (glxtrtypee lhs))
    (setq rhstp (glxtrtypee rhs))
    (and lhstp rhstp
         (or (glcoerceop op lhs rhs)
             (and (or (glunittypep lhstp) (glunittypep rhstp))
                  (if (and (numberp (car lhs)) (zerop (car lhs)))
                      (glcoerceunits op (list (car lhs) rhstp) rhs)
                      (if (and (numberp (car rhs)) (zerop (car rhs)))
                          (glcoerceunits op lhs (list (car rhs) lhstp))
                          (glcoerceunits op lhs rhs))))
             (and (glqconstantp (car rhs))
                  (setq newopnd (glcoerce rhs lhstp))
                  (glreducearith op lhs newopnd))
             (and (glqconstantp (car lhs))
                  (setq newopnd (glcoerce lhs rhstp))
                  (glreducearith op newopnd rhs))) ) ))

; 09 Nov 92; 11 Nov 92; 19 Nov 92; 03 Dec 92; 21 Aug 95; 05 Oct 95; 20 Mar 98
; 08 Jan 03; 25 Oct 07; 07 Apr 08; 19 Nov 09; 20 Nov 09; 08 Dec 09; 14 Jan 10
; Coerce rhs so it matches lhstp , e.g. fix, or convert feet to meters
; Result is a new rhs or nil.
(defun glcoercedata (lhstp rhs)
  (let (rhstp factor rhsunit lhsunit rhstpb lhstpb)
    (if (glunittypep lhstp) (setq lhstp (glxtrtypeu lhstp)))
    (setq rhstp (glxtrtypee rhs))
    (if (glunittypep rhstp) (setq rhstp (glxtrtypeu rhstp)))
    (cond ((or (equal lhstp rhstp)
               (equal (glxtrtypec lhstp) rhstp))
            rhs)
          ((and (eq lhstp 'integer) (eq rhstp 'real))
            (list (if (constantp (car rhs))
                      (round (car rhs))
                      (list 'round (car rhs)))
                  'integer))  ; was truncate *****
          ((and (eq lhstp 'real) (eq rhstp 'integer))
            (list (if (constantp (car rhs))
                      (float (car rhs))
                      (list 'float (car rhs)))
                  'real))
          ((and (or (glunittypep lhstp) (glunittypep rhstp))
                (or (glunittypep lhstp)
                    (member lhstp '(integer real number)))
                (or (glunittypep rhstp)
                    (member rhstp '(integer real number))))
            (if (member lhstp '(integer real number))
                (progn (setq lhsunit 'unity)
                       (setq lhstpb lhstp))
                (progn (setq lhsunit (caddr lhstp))
                       (setq lhstpb (cadr lhstp))))
            (if (member rhstp '(integer real number))
                (progn (setq rhsunit 'unity)
                       (setq rhstpb rhstp))
                (progn (setq rhsunit (caddr rhstp))
                       (setq rhstpb (cadr rhstp))))
            (if (equal lhsunit rhsunit)
                (list (car (glcoercedata lhstpb
                                         (list (car rhs) rhstpb)))
                      lhstp)
                (if (eq rhsunit 'unity)     ; if rhs is just a number
                    (list (car rhs) lhstp)  ; assume it is okay, no msg
                    (progn (or (setq factor (glconvertunit rhsunit lhsunit))
                               (progn (glerror 'glcoercedata
                                               "Cannot convert ~A to ~A"
                                               rhsunit lhsunit)
                                      (setq factor 1)))
                           (list (car
                                  (glcoercedata lhstpb
                                    (glreducearith '* (list factor 'real)
                                                   (list (car rhs) rhstpb))))
                                 lhstp)))))
          ((and (null lhstp)
                (glunittypep rhstp)
                (consp (setq rhsunit (caddr rhstp)))
                (eq (car rhsunit) '*)
                (numberp (cadr rhsunit)))
            (list (list '* (cadr rhsunit) (car rhs))
                  (list 'units (cadr rhstp) (caddr rhsunit)))  )
          ((and (consp lhstp)
                (eq (car lhstp) 'listof)
                (consp rhstp)
                (eq (car rhstp) 'list)
                (every #'(lambda (x) (equal x (cadr lhstp))) (cdr rhstp)))
            (list (car rhs) lhstp))
          ((glcoerceablep rhstp lhstp)
            (list (glcoercestr lhstp rhs) lhstp))
          ) ))

; 02 May 91; 03 Nov 92; 03 Dec 92
; When an op is on two different types that are instances of a common super,
; try converting both to the super and doing the op there.
(defun glcoerceop (op lhs rhs)
  (let (lhstp rhstp inter stdpropl std)
    (setq lhstp (glxtrtypee lhs))
    (setq rhstp (glxtrtypee rhs))
    (and (not (equal lhstp rhstp))
         (not (glbasictypep lhstp))
         (not (glbasictypep rhstp))
         (setq inter (gltypeint lhstp rhstp))
         (setq stdpropl (glgetprop inter 'prop 'std-prop))
         (consp (cadr stdpropl))
         (quotep (caadr stdpropl))
         (setq std (cadr (caadr stdpropl)))
         (glreduceb op (glvalue (car lhs) std (cadr lhs) nil)
                       (glvalue (car rhs) std (cadr rhs) nil)) ) ))


; 27 Jan 11
; Test whether the actual type matches an alist or proplist goal.
(defun glcoercepropl (goal type)
  (and (consp goal)
       (consp type)
       (member (car type) '(list listof))
       (or (and (eq (car goal) 'alist)
                (every #'(lambda (x) (and (consp x)
                                          (eq (car x) 'cons)
                                          (eq (cadr x) 'symbol)))
                       (cdr type)))
           (and (eq (car goal) 'proplist)
                (eq (cadr type) 'symbol))) ) )

; 04 Sep 09; 08 Sep 09
; Coerce the given code/type to build an instance of goaltype
(defun glcoercestr (goaltype codetype)
  (let (code type var buildcode)
    (setq code (car codetype))
    (setq type (cadr codetype))
    (if (or (equal type goaltype) (eq type 'anything) (null type))
        code
        (if (or (gldescendantp type goaltype)
                (gldescendantp goaltype type)
                (intersection (glsupers type) (glsupers goaltype)))
            (progn 
              (setq var (if (symbolp code) code (glgensym 'gltmp)))
              (setq buildcode
                    (glbuildstr goaltype
                                (mapcar #'(lambda (x)
                                            (cons (car x)
                                                  (glvalue var (car x)
                                                           type nil)))
                                        (gldatanames goaltype))
                                nil))
              (if (symbolp code)
                  buildcode
                  (list 'let (list (list var code)) buildcode)) )
            code) ) ))


; 20 May 93; 08 Jan 03
; Coerce a given code/type pair to be of a desired type, if possible.
; e.g. coerce (B BOX) to BOX-AS-LL-POINTER
(defun glcoercetype (codetype goaltype)
  (let (type ptype)
    (setq type (cadr codetype))
    (if (or (equal type goaltype)
            (and (symbolp type)
                 (equal (glxtrtype (car (glstr type))) goaltype)))
        codetype
        (if (or (and (symbolp type)
                     (setq ptype (car (glstr type)))
                     (consp ptype)
                     (eq (car ptype) '^)
                     (equal (glxtrtype (car (glstr (cadr ptype)))) goaltype))
                (and (symbolp goaltype)
                     (setq ptype (car (glstr goaltype)))
                     (consp ptype)
                     (eq (car ptype) '^)
                     (equal (glxtrtype (car (glstr (cadr ptype)))) type)) )
            (list (car codetype) goaltype)
            (or (glcoercedata goaltype codetype)
                (progn (glerror 'glcoercetype
                                "cannot coerce ~A to ~A~%" codetype goaltype)
                       codetype) ) )) ))

; 05 Nov 92; 03 Dec 92; 26 Apr 94; 29 Sep 94; 27 Mar 95; 31 May 95; 08 Dec 95
; 05 Mar 99; 26 Feb 02; 10 Mar 08; 07 Apr 08; 13 Nov 09; 14 Apr 10
; Coerce units as necessary for an operation, e.g. convert feet to meters
(defun glcoerceunits (op lhs rhs)
  (let (lhstp rhstp res factor rhsb expunit exponent result nres restp)
    (setq lhstp (glxtrtypee lhs))
    (if (glunittypep lhstp)
        (setq lhstp (glxtrtypeu lhstp))
        (setq lhstp (list 'units lhstp 'unity)))
    (setq rhstp (glxtrtypee rhs))
    (if (glunittypep rhstp)
        (setq rhstp (glxtrtypeu rhstp))
        (setq rhstp (list 'units rhstp 'unity)))
    (setq result
     (case op ((* /)
               (setq res (glreducearith op (list (car lhs) (cadr lhstp))
                                        (list (car rhs) (cadr rhstp))))
               (glfixmulunits op (car res) (cadr res) (caddr lhstp) (caddr rhstp)))
              ((\:= = + - < <= == <> >= >)
               (if (equal (caddr lhstp) (caddr rhstp))
                   (setq rhsb (list (car rhs) (cadr rhstp)))
                   (progn (or (setq factor (glconvertunit (caddr rhstp)
                                                          (caddr lhstp)))
                              (if (or (and (eq (caddr rhstp) 'unity) ; suppress msg for
                                           (or *glnounitunitywarning*
                                               (numberp (car rhs))))
                                      (and (eq (caddr lhstp) 'unity) ; unity case
                                           (or *glnounitunitywarning*
                                               (numberp (car lhs)))))
                                  (setq factor 1))
                              (progn (glerror 'glcoerceunits
                                              "Cannot apply op ~A to ~A and ~A"
                                              op (caddr lhstp) (caddr rhstp))
                                     (setq factor 1)))
                          (setq rhsb (glreducearith '* (list (car rhs)
                                                             (cadr rhstp))
                                                    (list factor 'number)))))
               (setq res (if (member op '(\:= =))
                             (glputfn lhs (list (car rhsb) (cadr lhs)) nil)
                             (glreducearith op (list (car lhs) (cadr lhstp))
                                            rhsb)))
               (if (member op '(\:= = + -))
                   (list (car res)
                         (if (floatp (car res))
                             (if (eq (cadr lhstp) 'real)
                                 lhstp
                                 (list 'units 'real (third lhstp)))
                             lhstp))
                   res))
              ((^ expt) (if (and (integerp (car rhs))
                         (< (setq exponent (abs (car rhs))) 6)
                         (eq (caddr rhstp) 'unity))
                    (progn (setq expunit 'unity)
                           (while (> exponent 0)
                             (decf exponent)
                             (setq expunit
                                   (if (minusp (car rhs))
                                       (glsimplunit
                                        (gldivunits expunit (caddr lhstp)))
                                       (glsimplunit
                                        (glmultunits expunit (caddr lhstp))))))
                           (setq res (glreducearith op
                                        (list (car lhs) (cadr lhstp))
                                        (list (car rhs) (cadr rhstp))))
                           (list (car res)
                                 (list 'units (cadr res) expunit)))
                    (glerror 'glcoerceunits "Cannot apply ^ to ~A and ~A"
                             (caddr lhstp) (caddr rhstp))))
              (t nil)))
    (if (numberp (car result))
        (progn (setq restp (cadr result))
               (if (numberp (caddr restp))
                   (progn (setq nres (* (car result) (caddr restp)))
                          (list nres (if (integerp nres) 'integer 'real)))
                   (if (and (consp (caddr restp))
                            (eq (caaddr restp) '*)
                            (numberp (cadr (caddr restp))))
                       (progn (setq nres (* (car result) (cadr (caddr restp))))
                              (list nres (list 'units
                                               (if (integerp nres) 'integer
                                                                   'real)
                                               (if (cdddr (caddr restp))
                                                   (cons '* (cddr (caddr restp)))
                                                   (caddr (caddr restp))))))
                       result)))
        result) ))


; 16 Aug 89; 29 Dec 89; 13 Mar 97
; This list of fns is being cut down as the compiler
; is modified to generate Common Lisp directly.
; Transform a function name FN for COMMON LISP dialect. 
(defun glcommonlispfn (fn)
  (cadr (assoc fn '( (copy copy-tree) ))) )


; 22-Mar-89; 29 Dec 89; 03 Nov 92; 10 Nov 95; 06 Mar 97; 13 Mar 97
; Transform an expression X for COMMON LISP dialect. 
; This function is being cut down as the compiler
; is modified to generate Common Lisp directly.
(defun glcommonlisptransfm (x)
  (prog (tmp tmpb fn)

; first do argument reversals. 

    (cond ((atom x) (return x))
          ((member (car x) '(mapc mapcar mapcan maplist mapcon
                                  push some every subset))
             (unless (and (consp (cadr x))
                          (eq (caadr x) 'function))
               (setq x (list (car x) (caddr x) (cadr x))))
             (if (and (eq (car x) 'mapc)
                      (consp (cadadr x))
                      (eq (car (cadadr x)) 'lambda))
                 (setq x (cons 'dolist
                               (cons (list (caadr (cadadr x)) (caddr x))
                                     (cddr (cadadr x))))))))
      
; now see if the result will be negated.

    (case (car x)
      (prin1 (if (stringp (cadr x))
                 (setq x (cons 'princ (cdr x)))))
      (equal (if (or (numberp (cadr x))
                     (numberp (caddr x)))
                 (setq x (cons 'eql (cdr x)))))
      (append (unless (cddr x) (setq x (list (car x) (cadr x) nil))))
      (nchars (setq x (list 'length (list 'symbol-name (cadr x)))))
      ((member)
        (setq fn (car x))
        (setq x (cons 'member (copy-tree (cdr x))))
        (cond ((and (quotep (setq tmp (caddr x)))
                    (consp (cadr tmp))
                    (every #'atom (cadr tmp)))
               (setq tmpb (copy-tree (cadr tmp)))
               (setf (cadr tmp) (remove-duplicates tmpb))
               (unless (cdadr tmp)
                 (setq x (list (cond ((symbolp (caadr tmp)) 'eq)
                                     ((numberp (caadr tmp)) 'eql)
                                     (t 'equal))
                               (cadr x)
                               (kwote (caadr tmp))))))
              ((eq fn 'member)
                (setq x (append x (list ':test '#'equal))))))
      (t (if (setq tmp (glcommonlispfn (car x)))
             (setq x (cons tmp (cdr x))))))
    (return  x)))


; 17-Mar-89; 13 Apr 93
; Translate a cond into if, when, or unless for common lisp 
(defun glcommontranscond (x)
  (cond ((null (cddr x))
          (cond ((and (consp (caadr x))
                      (member (caaadr x) '(not null)))
                  (cons 'unless (cons (cadr (caadr x)) (cdadr x))))
                ((null (cddadr x))
                  (if (cdadr x)
                      (cons 'if (cadr x))
                      (caadr x)))
                (t (cons 'when (cadr x)))))
        ((and (null (cdddr x))
              (eq (caaddr x) t))
          (cons 'if
                (cons (caadr x)
                      (cons (if (cddadr x)
                                (cons 'progn (cdadr x))
                                (cadadr x))
                            (cond ((null (cadr (caddr x))) nil)
                                  ((null (cddr (caddr x)))
                                    (list (cadr (caddr x))))
                                  (t (list (cons 'progn (cdaddr x)))))))))
        (t x)))


; 17-Mar-89; 20 May 96
; Translate a prog for common lisp, turning it into a let if appropriate.
; Eliminates NIL's, expands in-line progn's, changes (setq x (cdr x)) to (pop x)
(defun glcommontransprog (x)
  (let ((lastex (car (last x))) nret res tmp)
    (setq res
          (if (and (consp lastex)
                   (setq nret (glnoccurs 'return x))
                   (or (and (eq (car lastex) 'return)
                            (eql nret 1))
                       (eql nret 0))
                   (not (some #'atom (cddr x)))
                   (not (gloccurs 'go x)))
              (cons 'let (mapcon #'(lambda (y)
                                     (if (or (cdr y) (eql nret 0))
                                         (list (car y))
                                         (list (cadar y))))
                                 (cdr x)))
              x))
    (mapl #'(lambda (y)
              (cond ((null (cdr y)))
                    ((null (setq tmp (cadr y)))
                      (setf (cdr y) (cddr y))
                      (setq tmp (cadr y)))
                    ((atom tmp))
                    ((and (eq (car tmp) 'setq)
                          (consp (caddr tmp))
                          (eq (caaddr tmp) 'cdr)
                          (eq (cadr tmp) (cadr (caddr tmp))))
                      (rplaca (cdr y) (list 'pop (cadr tmp))))
                    ((eq (car tmp) 'progn)
                      (rplacd y (nconc (cdr tmp) (cddr y))))))
          (cdr res))
    res))


; 10 Oct 89; 06 Nov 92; 22 Dec 93; 29 May 95; 02 Apr 99; 15 Feb 00; 08 Oct 02
; 23 Dec 09
; GLISP compiler function. GLAMBDAFN is the symbol whose function 
;   definition is being compiled; *GLEXPR* is the GLAMBDA expression 
;   to be compiled. The compiled function is saved on the property 
;   list of GLAMBDAFN under the indicator GLCOMPILED. The property 
;   GLRESULTTYPE is the RESULT declaration, if specified; GLGLOBALS is 
;   a list of global variables referenced and their types. 
(defun glcomp (glambdafn *glexpr* argtypes)
  (let (newargs newexpr *glnatom* *gltopctx* resulttype res
                result *glsepatom* *glsepptr* *glvalbusy* *glexprstack*
                gltu *glnrecursions* *glselfasglst* *gltypesdefined*)
     (setq *glsepptr* 0)
     (setq *glnrecursions* 0)
     (setq *glselfasglst* nil)
     (when (and glambdafn (symbolp glambdafn))
       (setq *gllastfncompiled* glambdafn)
       (unless *glquietflg* (prin1 (list 'glcomp glambdafn)) (terpri)) )
     (setq *glexprstack* (list *glexpr*))
     (setq *glnatom* 0)
     (setq *gltopctx* (list nil))
     (setq gltu *gltypesused*)
     (setq *gltypesused* nil)
     
; Process the argument list of the glambda. 

     (setq newargs (gldecl (cadr *glexpr*) nil *gltopctx*
                           glambdafn argtypes))
     
; see if there is a result declaration. 

     (setq *glexpr* (cddr *glexpr*))
     (setq resulttype (glresglobal glambdafn))
     (setq resulttype (or resulttype (glresglobal glambdafn)))
     (setq *glvalbusy* t)
     (setq newexpr (glmatn (glprogn *glexpr* (cons nil *gltopctx*))))
     (setq result (glunwraptop (cons 'lambda
                                     (cons newargs (car newexpr)))
                               t))
     (cond ((symbolp glambdafn)
            (setq res (glfixresulttype resulttype (cadr newexpr)))
            (setf (glfnresulttype glambdafn) res)
            (if (and res (symbolp res) (not (glbasictypep res)))
                (pushnew glambdafn (glresultof res)))
            (setf (gltypesused glambdafn) *gltypesused*)
            (setf (gltypesdefined glambdafn) *gltypesdefined*)
            (glsavefntypes glambdafn *gltypesused*))
           ((and (consp glambdafn)
                 (eq (car glambdafn)
                     'glambdaform))
            (rplaca (cddr glambdafn)
                    (car newexpr))
            (rplaca (cdddr glambdafn)
                    (glfixresulttype resulttype (cadr newexpr)))))
            
; add something like glsavefntypes so the code can be recompiled 
;   automatically if types change 

     (setq *gltypesused* gltu)
     result))


; edited:  2-FEB-83; 08 Oct 02
; Compile an abstract function into an instance function given the 
;   specified set of type substitutions and function substitutions. 
(defun glcompabstract (fn instfn argtypes)
  (let (code)
    (or instfn
        (setq instfn (glinstancefnname fn)))
; compile the abstract function with the specified type substitutions. 
    (setq *glfnsubs* (list (cons fn instfn)))        ; temporary *****
    (setq code (glcomp instfn (glgetd fn) argtypes))
    (setf (symbol-function instfn) code)
    (setf (glcompiled instfn) code)
    (setq *glfnsubs* nil)           ; temporary *****
    instfn))


; 4-May-89; 04 Sep 92; 06 Nov 92; 03 Jan 95
; Compile a GLISP expression. CODE is a GLISP expression. VARLST is a 
;   list of lists (VAR TYPE) . The result is a list (OBJCODE TYPE) 
;   where OBJCODE is the Lisp code corresponding to CODE and TYPE is 
;   the type of the value returned by OBJCODE. 
(defun glcompexpr (code varlst)
(prog (objcode *glnatom* *glcontext* *glvalbusy* *glsepatom* *glsepptr* 
               *glexprstack* *gltopctx*
               *glfn* *glnrecursions* *glselfasglst* *gltypesdefined*)
      (setq *glfn* 'glcompexpr)
      (setq *glnrecursions* 0)
      (setq *glnatom* 0)
      (setq *glselfasglst* nil)
      (setq *glvalbusy* t)
      (setq *glsepptr* 0)
      (setq *glcontext* (setq *gltopctx* (list nil)))
      (dolist (x varlst)
        (gladdstr (car x) nil (cadr x) *glcontext*))
      (if (setq objcode (glpushexpr code t *glcontext* t))
          (return (list (glunwraptop (car objcode) t)
                        (cadr objcode))))))

; 21-Feb-89
; Compile code to get either a part of a structure or a PROPerty. 
(defun glcompgetcode (type slotname storeflg)
  (or (glcompprop type slotname 'str storeflg)
      (glcompprop type slotname 'prop storeflg)))


; 27-MAY-82; 03 Jan 95
; Compile the function definition stored for the atom *GLFN* using 
;   the GLISP compiler. 
(defun glcompile (*glfn*)
  (glambdatran (glgetd *glfn*))
  *glfn*)

; 4-MAY-82
; Compile FN if not already compiled. 
(defun glcompile? (fn)
  (or (glcompiled fn)
      (glcompile fn)))


; 10-FEB-83; 05 Feb 08
; Compile a Message. MSGLST is the Message list, consisting of message 
; selector, code, and properties defined with the message. 
(defun glcompmsg (object msglst arglist *glcontext*)
  (let (result)
    (if (> (incf *glnrecursions*) *glmaxrecursions*)
        (glerror 'glcompmsg
        "Infinite loop detected in compiling ~A for object of type ~A "
                                 (car msglst)
                                 (cadr object))
        (progn
          (setq result (glcompmsgb object msglst arglist *glcontext*))
          (decf *glnrecursions*)
          result) ) ))

; 31 Dec 10; 05 Jan 11
; Produce arg list for a function call: list of (code type)
; may need to materialize args and omit some
(defun glcompmsgargs (fn args)
  (let (fnargs)
    (if (setq fnargs (glarguments fn))
        (mapcan #'(lambda (arg)
                    (if (pop fnargs)   ; omit extra args
                        (list (if (glvvct arg)
                                  (glmaterialize arg nil nil)
                                  arg))))
                args)
        args) ))


; 22-Apr-88; 21-Jan-89; 23 Mar 90; 06 Apr 90; 09 Sep 90; 10 Oct 90
; 11 Mar 92; 18 Mar 99; 29 Oct 02; 08 May 09; 22 Apr 10; 28 May 10
; 29 Dec 10; 31 Dec 10
; Compile a Message. MSGLST is the Message list, consisting of message 
; selector, code, and properties defined with the message. 
(defun glcompmsgb (object msglst arglist *glcontext*)
  (prog (*glproglst* resulttype method result vtype args selfvar)
    (setq resulttype (getf (cddr msglst) 'result))
    (setq method (cadr msglst))
    (cond ((or (symbolp method)
               (and (consp method)
                    (member (car method) '(glambda lambda))))
             
; function name is specified.

            (return
              (if (or (consp method)
                      (getf (cddr msglst) 'open))
                  (glcompopen method
                              (cons object
                                    (mapcar #'(lambda (x)   ; 08 May 09
                                                (glevalcode x *glcontext*))
                                            arglist))
                              (cons (cadr object)
                                    (getf (cddr msglst) 'argtypes))
                              resulttype
                              nil)
                  (progn
                    (setq args (glcompmsgargs method
                                              (cons object arglist)))
                    (list (cons method (mapcar #'car args))
                          (glevalstr
                            (or resulttype
                                (glresulttype method
                                              (mapcar #'cadr args)))
                            *glcontext*)) ) ) ))
            ((atom method)
              (return (glerror 'glcompmsg
                       "The form of Response is illegal in message ~A "
                                     msglst)))
            ((and (consp (car method))
                  (eq (caar method) 'virtual))
             (setq vtype (glmakevtype (cadr object) (car method)))
             (return (list (glmakeblfor object vtype) vtype))))
      
; the method is a list of stuff to be compiled open. 

    (setq *glcontext* (list nil))
    (cond ((symbolp (car object))
            (gladdstr (list 'prog1 (car object))
                      'self (cadr object) *glcontext*))
          ((and (consp (car object))
                (eq (caar object) 'prog1)
                (symbolp (cadar object))
                (null (cddar object)))
            (gladdstr (car object) 'self (cadr object) *glcontext*))
          ((glviewerct object)
            (gladdstr (car object) 'self  ; 29 Dec 10 was (caadar object)
                      (cadr object) *glcontext*))
          ((or (glvirtualct object)
               (glvirtualbp (car object) (cadr object)))
            (gladdstr (car object) 'self (cadr object) *glcontext*))
          (t (setq selfvar (glgensym 'self))
             (push (list selfvar (car object)) *glproglst*)
             (gladdstr selfvar nil (cadr object) *glcontext*)
             (gladdstr (list 'prog1 selfvar)                  ; 28 May 10
                       'self (cadr object) *glcontext*)
             (glnotetype selfvar (cadr object))
             (if (glconstantp (car object))
                 (gladdfact (list '= selfvar (kwote (glconstval (car object))))
                            *glcontext*) ) ))
    (setq result (glprogn method *glcontext*))

; if more than one expression resulted, embed in a progn. 

    (setf (car result)
          (if (cdar result)
              (cons 'progn (car result))
              (caar result)))
    (return (list (if *glproglst*
                      (glgenlet *glproglst* (list (car result)))
                      (car result))
                  (glevalstrc (or resulttype (cadr result))
                                 *glcontext*))) ))


; 26-Oct-87; 28 Nov 89; 28 Dec 89; 24 Jan 90; 06 Apr 90; 13 May 93; 06 May 95
; 06 Feb 96; 08 Oct 02; 20 Apr 07; 19 Feb 08; 04 Jun 09
; Attempt to compile code for a message list for an object. OBJECT is 
;   the destination, in the form (<code> <type>) , PROPTYPE is the 
;   property type (ADJ etc.) , MSGLST is the message list, and ARGS is 
;   a list of arguments of the form (<code> <type>) . The result is of 
;   the form (<code> <type>) , or NIL if failure. 
(defun glcompmsgl (object proptype msglst args *glcontext*)
  (let (type selector newfn newmsglst str propl msgl)
     (setq type (glxtrtype (cadr object)))
     (setq selector (car msglst))
     (cond ((eq (cadr msglst) 'error)
             (glerror 'glcompmsgl "Error to apply ~A to ~A" selector type))
           ((getf (cddr msglst) 'message)
            (setq *glcontext* (list nil))
            (gladdstr (car object) 'self type *glcontext*)
            (list (if (eq proptype 'msg)
                      (cons 'glsend
                            (cons (car object)
                                  (cons selector (mapcar #'car args))))
                      (cons 'sendprop
                            (cons (car object)
                                  (cons selector (cons proptype
                                                       (mapcar #'car args))))))
                  (glevalstr (getf (cddr msglst) 'result) *glcontext*)))
           ((and (getf (cddr msglst) 'specialize)
                 (symbolp (cadr msglst)))
            (when (glvvct object)
                  (setq object (glmaterialize object nil nil))
                  (setq type (cadr object)))
            (setq str (glstr type))
            (setq propl (getf (cdr str) proptype))
            (setq msgl (glstrpropb selector propl args t))
            (if (or (eq msgl msglst)
                    (getf (cddr msgl) 'specialization))
                (glcompmsg object msgl args *glcontext*)
                (progn (setq newfn (glinstancefnname (cadr msglst)))
                       (setq *glspecfncompiled* newfn)
                       (push newfn *glspecfnscompiled*)
                       (setq newmsglst (list (car msglst) newfn
                                             'specialization t))
                       (if args
                           (nconc newmsglst
                                  (list 'argtypes (mapcar #'cadr args))))
                       (if (symbolp type)
                           (gladdprop type proptype newmsglst))
                       (glcompabstract (cadr msglst) newfn
                                       (cons type (mapcar #'cadr args)))
                       (push (list (cadr msglst) type proptype selector)
                             (glspecialization newfn))
                       (nconc newmsglst (list 'result
                                              (glfnresulttype newfn)))
                       (glcompmsg object newmsglst args *glcontext*))))
           (t (glcompmsg object msglst args *glcontext*)))))


; 22 Apr 88; 16-Mar-89; 05 July 90; 09 Sep 90; 20 Dec 90; 12 Sep 91
; 30 Dec 91; 11 Mar 92; 23 Dec 94; 27 Dec 94; 28 Dec 94; 15 Mar 95; 29 May 95
; 01 Oct 96; 17 Mar 99; 02 Nov 00; 08 Oct 02; 29 Oct 02; 14 May 03; 14 Sep 06
; 05 Dec 08; 29 Jan 09; 09 Apr 09
; Compile the function FN in-line, given as arguments ARGS: (code type)* 
; with argument types ARGTYPES. Types may be defined in the definition 
; of function FN (which may be either a GLAMBDA or LAMBDA function) 
; or by ARGTYPES; ARGTYPES takes precedence.
; If args = t, take args from the function definition and produce a lambda
(defun glcompopen (fn args argtypes resulttype cntxt)
  (let (ptr fndef *glproglst* newexpr *glcontext* newargs newvar result
             optionalflg declres)
; put a new level on top of context. 
    (setq *glcontext* (cons nil cntxt))         ; 30 Dec 91
    (setq fndef (if (symbolp fn)
                    (or (glgetd fn)
                        (and (glerror 'glcompopen
                             "No definition exists for open-compiled fn ~A" fn)
                             nil))
                    fn))
      
; get the parameter declarations and add to context. 
          ; 02 Nov 00; 29 Jan 09
    (setq declres (gldecl (cadr fndef) nil *glcontext* nil argtypes))

; make the function parameters into names and put in the values, 
;   hiding any which are simple variables. 

    (setq ptr (nreverse (car *glcontext*)))
    (setf (car *glcontext*) nil)
    (dolist (ctxent ptr)
      (or argtypes (setq argtypes '(nil)))
      (if (and (consp args) (consp (car args)))
          (setf (car args) (glunstoretrap (car args))))           ; 01 Oct 96
      (if (eq (car declres) '&optional)
          (progn (pop declres) (setq optionalflg t)))
      (cond ((or (eq args t) (and (not optionalflg) (null args)))
              (if (null args)               ; 17 Mar 99
                  (glerror 'glcompopen "Missing argument in compiling ~A" fn))
              (gladdstrb (cadr ctxent) nil (or (car argtypes) (caddr ctxent))
                         *glcontext*)
              (push (cadr ctxent) newargs))
            ((and optionalflg (null args))      ; 12 Sep 91
             (gladdstrb (list 'prog1 nil) (cadr ctxent)
                        (or (car argtypes)
                            (caddr ctxent))
                        *glcontext*))
            ((symbolp (caar args))
; wrap the atom in a prog1 so it won't match as a name; the prog1 will 
;   generally be stripped later. 
              (gladdstrb (list 'prog1 (caar args))
                         (cadr ctxent)
                         (or (cadar args) (car argtypes) (caddr ctxent))
                         *glcontext*))
            ((and (consp (caar args))
                  (or (and (eq (caaar args) 'prog1)
                           (symbolp (cadaar args))
                           (null (cddaar args)))
                      (gllvaluep (caar args))))           ; 14 May 03
              (gladdstrb (caar args) (cadr ctxent)
                         (or (cadar args) (car argtypes) (caddr ctxent))
                         *glcontext*))
            ((or (glvvct (car args))
                 (glvirtualct (car args))
                 (glconstantp (caar args)))
              (gladdstrb (caar args) (cadr ctxent) (cadar args) *glcontext*))
            (t   ; since the actual arg is not atomic, make a prog var for it. 
              (setq newvar (glgensym 'glvar))
              (push (list newvar (caar args)) *glproglst*)
              (push (car *glproglst*) *glselfasglst*)
              (gladdstrb newvar (cadr ctxent)
                         (or (cadar args) (car argtypes) (caddr ctxent))
                         *glcontext*)) )
      (if (consp args) (pop args))       ; 29 Jan 09; 10 Feb 09
      (pop declres)    ; 29 Jan 09
      (pop argtypes)  )   ; dolist
    (setq fndef (cddr fndef))
; get rid of comments at start of function. 
    (while (and fndef (consp (car fndef))
                (member (caar fndef) '(result global)))
      (if (and (null resulttype) (eq (caar fndef) 'result))
          (setq resulttype (glevalstr (cadar fndef) *glcontext*))) ; 29 Oct 02
      (pop fndef))
    (setq newexpr (glprogn fndef *glcontext*))
; get rid of atomic result if it isnt busy outside. 
    (if (and (not *glvalbusy*)
             (cdar newexpr)
             (or (atom (cadr (setq ptr (nleft (car newexpr) 2))))
                 (and (consp (cadr ptr))
                      (eq (caadr ptr) 'prog1)
                      (atom (cadadr ptr))
                      (null (cddadr ptr)))))
        (setf (cdr ptr) nil))
    (setq result (list (if *glproglst*
                           (glgencode (glgenlet (nreverse *glproglst*)
                                                (car newexpr)))
                           (glgenprogn (car newexpr)))
                       (glevalstrc
                        (or resulttype
                            (glresulttype fn
                              (reverse (mapcan #'(lambda (x)   ; 09 Apr 09
                                          (if (eq (car x) 'alias)
                                              (list (fourth x))))
                                               (first *glcontext*))))
                            (cadr newexpr))
                        *glcontext*)))
    (if (eq args t)
        (progn (if (glvvct result)
                   (setq result (glmaterialize result nil nil)))
               (list (list 'lambda (nreverse newargs) (car result))
                     (cadr result)))
        result) ))


; Edited 2-Nov-87; 21-Feb-89; 29 May 90
; Compile a LAMBDA expression to compute the property PROPNAME of type 
;   PROPTYPE for structure STR. The property type STR is allowed for 
;   structure access. 
(defun glcompprop (str propname proptype storeflg)
  (let (code pl subpl propent vw)
    (cond ((consp str) (error "Bad type spec ~A" str))
          ((not (member proptype '(str adj isa prop msg)))
            (error "Bad prop type ~A" proptype))
      
; see if the property has already been compiled. 

          ((and (not storeflg)
                (setq pl (glpropfns str))
                (setq subpl (assoc proptype pl))
                (setq propent (assoc propname (cdr subpl))))
            (cdr propent))
      
; compile code for this property and save it. 

          ((setq code (glcomppropl str propname proptype storeflg))
            (unless storeflg (gladdpropcode str propname proptype code))
            code)
          ((and (eq proptype 'prop)
                (setq vw (glfindview str propname))
                (setq code
                      (if (symbolp vw)
                          (list (copy-tree '(lambda (self) self))
                                vw)
                          (glcomppropl str propname 'views storeflg))))
            (unless storeflg (gladdpropcode str propname 'prop code))
            code)) ))


; 29-Jul-88; 6-Mar-89; 29 May 90; 09 Sep 90; 25 Oct 91; 30 Oct 91; 01 May 92
; 04 Sep 92; 06 Nov 92; 03 Jan 95; 29 Oct 02; 30 Dec 02; 01 Jun 04; 14 Sep 06
; 22 Jan 08; 28 Jan 08; 15 Sep 10
; Compile a message as a closed form, i.e., function name or LAMBDA form. 
(defun glcomppropl (str propname proptype storeflg)
  (prog (code msgl trans tmp fetchcode newvar (args '(self))
         *glnatom* *glcontext* *glvalbusy* *glsepatom* *glsepptr*
         *glexprstack* *gltopctx* *glfn*
         *glnrecursions* *glselfasglst* *gltypesdefined*)
      (setq *glfn* 'glcomppropl)
      (setq *glnrecursions* 0)
      (setq *glnatom* 0)
      (setq *glselfasglst* nil)
      (setq *glvalbusy* t)
      (setq *glsepptr* 0)
      (setq *glcontext* (setq *gltopctx* (list nil)))
      (cond ((eq proptype 'str)
              (return
               (if (setq code (glstrfn propname str nil))
                   (glmakelambda '(self)
                                 (glrepvalue
                                   (list (nsubst 'self '*gl* (car code))
                                         (cadr code)))
                                 storeflg))))
            ((setq msgl (glstrprop str proptype propname nil))
              (cond ((and (glispcp)
                          (eq proptype 'views)
                          (setq tmp (glfindview str propname)))
                      (unless (consp tmp) (error "internal err"))
                      (setq newvar (glgensym 'glvar))
                      (setq code (list (list 'glbinding
                                             (list newvar 'self str))
                                       (list 'viewer
                                             (list (list newvar str))
                                             (list (list 'out (car tmp)))
                                             (cdr tmp)))))
                    ((symbolp (cadr msgl))
                      (setq args
                            (or (mapcan #'(lambda (x)
                                            (and (consp x)
                                                 (list (car x))))
                                        (glargs (cadr msgl)))
                                '(self)))
                      (setq code (if (and (glispcp)
                                          (getf (cddr msgl) 'open))
                                     (glcompopen (cadr msgl) t
                                                 (list str) nil nil)
                                     (if (getf (cddr msgl) 'specialize)
                                         (progn
                                           (setq tmp (glspecialize (cadr msgl)
                                                                   (list str)))
                                           (list (cons (car tmp) args)
                                                 (cadr tmp)))
                                         (list (cons (cadr msgl)
                                                     (mapcan
                                                      #'(lambda (x)
                                                          (and (not (member x
                                                                     '(&optional)))
                                                               (list x)))
                                                      args))
                                                ; 02 Aug 89; 01 Jun 04
                                               (or (getf (cddr msgl) 'result)
                                                   (glresulttype (cadr msgl)
                                                                 nil))))) ))
                    ((and (glispcp)
                          (consp (cadr msgl))
                          (member (caadr msgl) '(glambda lambda)))
                      (setq code (glcompopen (cadr msgl) t
                                             (list str) nil nil)))
                    ((and (glispcp)
                          (setq code (gladj (list 'self str)
                                            propname proptype))))))
            ((setq trans (gltransparenttypes str))
              (go b))
            (t (return)))
      (return (cond ; commented out 30 Dec 02: glcompprop needs a function
                    ; ((and (symbolp (car code))                ; 28 Aug 89
                    ;       (not (member (car code) '(t nil))))
                    ;   code)
                    ((and (consp (car code))
                          (eq (caar code) 'lambda))
                       (if storeflg (glputlambda code) code))    ; 30 Oct 91
                    (t (glmakelambda args code storeflg))))
      
; look for the message in a contained transparent type. 

  b   (cond ((null trans) (return))
            ((setq tmp (glcomppropl (glxtrtype (car trans))
                                    propname proptype storeflg))
              (when (symbolp (car tmp))
                    (glerror 'glcomppropl
 "GLISP cannot currently handle inheritance of the property  ~A
 which is specified as a function name in a TRANSPARENT subtype.  Sorry."
                                  propname)
                    (return))
              (setq fetchcode (glstrfn (car trans) str nil))
              (setq newvar (glgensym 'glvar))
              (glstrval fetchcode newvar)
              (return (list (glunwrapc
                             (list 'lambda (cons newvar (cdadar tmp))
                                   (glgenlet (list (list (caadar tmp)
                                                         (car fetchcode)))
                                             (list (caddar tmp))))
                             t)
                            (cadr tmp))))
            (t (pop trans)
               (go b)))))

; 23 Dec 91
; Determine the type of array contents
(defun glconstantarray (arr n)
  (let (dim type)
    (setq dim (array-dimensions arr))
    (if (cdr dim)
        (setq arr (make-array (array-total-size arr) :displaced-to arr)))
    (dotimes (i (min 16 (array-total-size arr)))
      (setq type (if type (glconstanttpmatch type
                                             (glconstanttypeb (aref arr i)
                                                              (1+ n)))
                          (glconstanttypeb (aref arr i) (1+ n)))) )
    (list 'arrayof type)))


; 20 Apr 92
; Test if argument is constant when evaluated
(defun glconstantb (x)
  (or (glconstantp x)
      (and (consp x)
           (member (first x) '(copy-list copy-tree))
           (consp (cdr x))
           (glconstantp (cadr x)))))


; 15-Feb-89; 29 Sep 92; 10 Feb 94; 10 Nov 95; 26 May 98; 22 Oct 02
; Test X to see if it represents a compile-time constant value. 
(defun glconstantp (x)
  (or (constantp x)
      (and (consp x) (eq (car x) 'function))
      (and (symbolp x) (glispconstantflg x))
      (and (consp x)
           (symbolp (car x))
           (gloktoeval (car x))
           (or (member (car x) '(known true false))
               (if (glargsnumberp (car x))
                   (every #'glnumberp (cdr x))
                   (every #'glconstantp (cdr x)))))))

; 13 Dec 91; 23 Dec 91; 08 Apr 93
; Determine type of a given expression if it is a simple type.
(defun glconstanttp (expr)
  (cond ((integerp expr) 'integer)
        ((floatp expr)   'real)
        ((numberp expr)  'number)
        ((stringp expr)  'string)
        ((or (eq expr t) (null expr)) 'boolean)
        ((arrayp expr) nil)
        ((glclass expr))
        ((symbolp expr)  (if (glstr expr) 'gltype 'symbol))
        ((and (consp expr) (eq (car expr) 'q)
              (consp (cdr expr)) (constantp (cadr expr))
              (numberp (eval (cadr expr)))
              (consp (cddr expr)) (glunitp (caddr expr)))
          (list 'units (if (integerp (eval (cadr expr))) 'integer 'real)
                (caddr expr)))
        (t nil)) )

; 13 Dec 91
; Match types for equality or common node in type lattice
(defun glconstanttpmatch (typea typeb)
  (if (equal typea typeb) typea
      (case typea
        ((integer real number) (if (member typeb '(integer real number))
                                   'number))
        (symbol (if (eq typeb 'boolean) 'symbol))
        (boolean (if (eq typeb 'symbol) 'symbol)) ) ) )

; 13 Dec 91
; Determine type of cons structure.  n is depth so far.
(defun glconstanttree (expr n)
  (let (type exprest)
    (if (consp (cdr expr))
        (progn (setq type (glconstanttypeb (car expr) (1+ n)))
               (setq exprest (rest expr))
               (while (and type exprest)
                 (setq type (glconstanttpmatch type
                              (glconstanttypeb (pop exprest) (1+ n)))))
               (if (and type (null exprest))
                   (list 'listof type)
                   (cons 'list (mapcar #'(lambda (x)
                                           (glconstanttypeb x (1+ n)))
                                       expr))) )
        (if (null (cdr expr))
            (list 'list (glconstanttypeb (car expr) (1+ n)))
            (list 'cons (glconstanttypeb (car expr) (1+ n))
                        (glconstanttypeb (cdr expr) (1+ n)))) ) ))

; 14-MAR-83; 04 Apr 91; 07 May 91; 13 Dec 91; 23 Dec 91; 06 Nov 92
; Attempt to infer the type of a constant expression.  n is depth so far.
(defun glconstanttype (expr) (glconstanttypeb expr 0))
(defun glconstanttypeb (expr n)
  (or (glconstanttp expr)
      (if (> n 4) 'anything
          (if (consp expr) (glconstanttree expr (1+ n))
              (if (arrayp expr) (glconstantarray expr (1+ n))
                  'anything))) ) )

; 17 Jan 92; 08 Aug 95; 10 Nov 95; 22 Oct 02; 19 Nov 02
; Test whether an expression is a function call that should be evaluated
; at compile time
(defun glconstfnp (x)
  (and (consp x)
       (symbolp (car x))
       (gloktoeval (car x))
       (or (member (car x) '(true false known))
           (every #'glconstantp (cdr x))) ) )

; 17 Jan 92; 28 Apr 94; 10 Nov 95; 12 Nov 96; 11 Mar 97
; Evaluate a function call at compile time
(defun glconstfnval (x)
  (let (args)
    (unless (eq (car x) 'known)
      (setq args (mapcar #'(lambda (z) (if (constantp z)
                                           z
                                           (kwote (glconstval z))))
                         (cdr x))))
    (if (eq (car x) 'known)
        (glknown (cadr x))
        (if (glargsnumberp (car x))
            (if (every #'numberp args)
                (apply (car x) args)
                (glevalunits (cons (car x) args)))
            (eval (cons (car x) args)) ) ) ))     ; apply breaks on AND in GCL

; edited:  9-DEC-82; 05 Apr 90
; Test to see if X is a constant structure. 
(defun glconststr? (x)
  (or (glconstantp x)
      (and (consp x)
           (or (eq (car x) 'quote)
               (and (member (car x) '(copy-tree append))
                    (quotep (cadr x))
                    (or (not (eq (car x) 'append))
                        (null (cddr x))
                        (null (caddr x))))
               (and (eq (car x) 'list)
                    (every #'glconststr? (cdr x)))
               (and (eq (car x) 'cons)
                    (glconststr? (cadr x))
                    (glconststr? (caddr x)))))))


; 15-Feb-89; 05 Apr 90; 12 Sep 91; 18 Sep 91; 19 Sep 91; 17 Jan 92; 03 Nov 92
; 10 Nov 95; 26 Jul 96
; Get the value of a compile-time constant 
(defun glconstval (x)
  (cond ((or (null x)
             (eq x t)
             (numberp x)
             (characterp x)
             (stringp x))
          x)
        ((and (symbolp x) (constantp x)) (eval x))
        ((quotep x) (cadr x))
        ((consp x)
          (cond ((and (member (car x) '(copy-tree append))
                      (quotep (cadr x))
                      (or (null (cddr x))
                          (null (caddr x))))
                  (cadadr x))
                ((eq (car x) 'function) (cadr x))
                ((eq (car x) 'list)
                  (mapcar #'glconstval (cdr x)))
                ((eq (car x) 'cons)
                  (cons (glconstval (cadr x))
                        (glconstval (caddr x))))
                ((glconstfnp x) (glconstfnval x))
                (t (error "NOMSG"))))
        ((and (symbolp x)
              (glispconstantflg x))
          (glispconstantval x))
        (t (error "NOMSG"))))

; 03 Jan 95; 04 Jan 95; 09 May 95
; Find a context entry that describes the value of a variable, if one exists.
; Result will be the first entry (= v value), (not (null v)), or (changed v).
(defun glcontextentry (v context stoponlabel)
  (if (or (eq v t) (eq v nil) (glglobalvarp v))
      nil
      (dolist (clist context)
        (dolist (x clist)
          (if (or (and (eq (car x) '=)
                       (eq (cadr x) v))
                  (and (eq (car x) 'changed)
                       (eq (cadr x) v))
                  (and (eq (car x) 'not)
                       (consp (cdr x))
                       (eq (caadr x) 'null)
                       (eq (cadadr x) v)) )
              (return-from glcontextentry x)
              (if (and stoponlabel (eq (car x) 'label))
                  (return-from glcontextentry nil))) ) ) ) )

; 29 Dec 94; 02 Jan 95; 03 Jan 95; 04 Jan 95
; Test whether a variable is NIL from context if possible.
; Result is (= v value) or T if found, else NIL.
; If value is returned as T, it means "non-NIL".
(defun glcontextnull (v context)
  (let (entry)
    (setq entry (glcontextentry v context t))
    (if entry
        (if (eq (car entry) '=)
            entry
            (if (and (eq (car entry) 'not)
                     (consp (cdr entry))
                     (consp (cadr entry))
                     (eq (caadr entry) 'null)
                     (eq (cadadr entry) v))
                (list '= v t)) ) ) ))

; 29 Dec 94; 02 Jan 95; 03 Jan 95; 04 Jan 95
; Find the value of a variable from context if possible.
; Result is (= v value) if found.
(defun glcontextval (v context)
  (let (entry)
    (setq entry (glcontextentry v context t))
    (if (and entry (eq (car entry) '=))
        entry)))

; 29 Sep 92
(defun glcopy-treeresulttypefn (fn argtypes)    (declare (ignore fn))
  (first argtypes) )

; Edited 17 July 89; 27 Feb 98
(defun glcpfn ( &optional fn)
  (or fn (setq fn *gllastfncompiled*))
  (if (glgetd fn)
      (progn (gluncompile fn)
             (glcompile fn)
             (glprintcompiled fn))
      (format t "~A ?~%" fn) ) )


; 23 May 90; 06 Feb 92; 02 Sep 93; 07 Jan 00
; Get a flattened list of names and types from a given structure description.
; cf. GEVDATANAMES
(defun gldatanames (str)
  (nreverse (gldatanamesb (if (consp str) str (glxtrtypecb str)) nil)) )

(setf (glfnresulttype 'gldatanames) '(listof glnametype))

; 23 May 90; 29 May 90; 09 Apr 92; 09 Nov 92; 28 Mar 93; 17 Jan 94; 27 Jan 94
; 05 May 94
; Get a flattened list of names and types from a given structure description. 
(defun gldatanamesb (str result)
  (let ()
    (if (consp str)
        (case (car str)
          (cons (gldatanamesb (caddr str)
                              (gldatanamesb (cadr str) result)))
          ((alist proplist list object atomobject listobject tuple)
            (dolist (x (cdr str) result)
              (setq result (gldatanamesb x result))) )
          ((record crecord)
            (dolist (x (cddr str) result)
                    (setq result (gldatanamesb x result))))
          ((atom symbol) (gldatanamesb (caddr str) 
                                       (gldatanamesb (cadr str) result)))
          (binding (gldatanamesb (cadr str) result))
          (transparent (gldatanamesb (glgetstr (cadr str)) result))
          ((listof ^ units) result)
          (t (cons (list (car str) (cadr str))
                   (nconc (gldatanamesb (cadr str) nil) result))) )
        result) ))

; 24 Feb 05
(setf (glfnresulttype 'gldatanamesonly) '(listof symbol))
(setf (glevalwhenconst 'gldatanamesonly) t)
(defun gldatanamesonly (str) (mapcar #'car (gldatanames str)))

; 17 Jan 94
; Find the data type of field whose name is name within the structure str
(defun gldatatype (str name)
  (gldatatypeb (if (consp str) str (glxtrtypec str)) name) )

(setf (glfnresulttype 'gldatatype) 'gltype)

; 17 Jan 94
; Get type of field name from structure str
(defun gldatatypeb (str name)
  (if (consp str)
      (case (car str)
        ((cons atom symbol)
          (or (gldatatypeb (cadr str) name)
              (gldatatypeb (caddr str) name)))
        ((alist proplist list object atomobject listobject tuple)
          (some #'(lambda (x) (gldatatypeb x name)) (cdr str)) )
        ((record crecord)
          (some #'(lambda (x) (gldatatypeb x name)) (cddr str)))
        (binding (gldatatypeb (cadr str) name))
        ((listof ^ units transparent) nil)
        (t (if (eq (car str) name)
               (cadr str)
               (gldatatypeb (cadr str) name)) ) ) ) )


; 2-Oct-87; 17-Mar-89; 24 May 93; 03 Nov 92; 29 May 95; 30 May 95; 31 May 95
; 10 Jan 96; 16 Jul 98; 20 Feb 01; 08 Oct 02; 03 Dec 02; 28 Jan 09; 15 Sep 10
; 07 Dec 10; 28 Dec 10
; Process a declaration list from a GLAMBDA expression.
; Each element of the list is <var>, <var>:<type>, or (<var> <type>).
; If VALOK is true, a LET form (variable value) is allowed.
; types are added to the *gltopctx* list
; The result is a list of var or (var val).
(defun gldecl (lst valok *gltopctx* fn argtypes)
  (let (arglist tmp result var *glexpr* types str rs tp res omitflg
                compriseflg )
    (setq arglist (glarglist lst valok))                 ; parse the arg list
    (dolist (triple arglist)    ; triple is (var value type [omit])
      (setq compriseflg nil)
      (setq var (car triple))
  ; patch for (var type) in a let
      (if (and valok
               (or (gltypep (cadr triple))
                   (and (consp (cadr triple))
                        (eq (caadr triple) 'comprise)
                        (setq compriseflg t)))
               (null (caddr triple)))
          (setq triple (list (car triple) nil (cadr triple))) )
      (if (and valok
               (cadr triple)
               (not (gltypep (cadr triple))))
          (progn (setq *glexpr* (list (cadr triple)))
                 (setq tmp (gldoexpr nil *gltopctx* t))
                 (if *glexpr*
                     (glerror 'gldecl "Bad argument structure  ~A " triple))
                 (if (glvvct tmp)
                     (setq tmp (glmaterialize tmp nil nil)))     ; 03 Nov 93
                 (gladdstr var nil (cadr tmp) *gltopctx*)
                 (push (list var (car tmp)) result))
          (if (or (null (caddr triple))
                  compriseflg
                  (glokstr? (caddr triple)))
              (if (member (car triple) '(&optional &omit))
                  (if (eq (car triple) '&omit)
                      (setq omitflg t)
                      (if (not omitflg) (push (car triple) result) ) )
                  (progn (setq str (caddr triple))
                         (if (setq tmp (pop argtypes))
                             (setq str tmp))
                         (if compriseflg
                             (gladdstr (car triple) nil
                                       (gldocomprise str *gltopctx*)
                                       *gltopctx*)
                             (progn
                               (gladdstr (car triple) nil
                                         (gldeclfixstr str *gltopctx*)
                                         *gltopctx*)
                               (unless (or (fourth triple) omitflg)
                                 (push var result)))) ) )
              (glerror 'gldecl "Bad argument structure  ~A " triple))) )
    (setq *glcontext* *gltopctx*)
    (dolist (s (car *gltopctx*))
      (push (glevalstr (caddr s) *gltopctx*)
            types)
      (rplaca (cddr s) (car types)))
    (setq result (nreverse result))
    (when (and fn (symbolp fn))
      (setq rs result)
      (setq tp types)
      (while rs
        (push (if (eq (car rs) '&optional)
                  (pop rs)
                  (progn (glnotetype (car rs) (car tp))
                         (list (pop rs) (pop tp)) ) )
              res) )

      (setf (glarguments fn) (reverse res)) )
    result))


; 20 Dec 90; 13 Jan 92; 14 Jan 92; 29 Jan 92; 16 Jul 98; 10 Sep 98; 28 Dec 98
; 18 Feb 99
; Fix a structure description that may be relative to another
(defun gldeclfixstr (str context)
  (if (and (consp str)
           (not (member (car str) *gltypenames*)))
      (case (car str)
        ((typeof clustertype) (glevalstr str context))
        (eval (glevaltype str))
        (^.     (list '^. (glxtrtype (cadr str))))
        (^      (glget-or-make-pointer (cadr str)))
        ((virtual viewer units) str)          ; 14 Jan 92; 28 Dec 98; 18 Feb 99
        (t      (glevaltype str)))
      (glxtrtype str)) )


; edited: 24-Jan-89; 13 Dec 89
; Find the default value to use for an item of type STR. 
(defun gldefaultvalue (str)
  (if (symbolp str)
      (case str
            ((integer number) 0)
            (real 0.0)
            (string "")
            (t (cadr (glgetdefault str 'self))))))


; edited: 19-MAY-82
; Define the result types for a list of functions. The format of the 
;   argument is a list of dotted pairs, (FN . TYPE) 
(defun gldeffnresulttypes (lst)
  (dolist (x lst)
     (dolist (y (cadr x)) (setf (glfnresulttype y) (car x)))))

; 26 Apr 07
; version for glputarithpatterns: ( (= (op ...   index by op
(defun gldefpapatterns (patwd l)
  (dolist (pat l)
    (unless (member pat (get (caar pat) patwd) :test #'equal)
      (setf (get (caadar pat) patwd)
            (nconc (get (caadar pat) patwd) (list pat))) ) ) )

; 4-May-89; 07 Feb 91; 18 Nov 91; 25 Feb 92; 21 Apr 92
; Store rewriting patterns for use in optimization etc.
; Note that order of pattern definitions must be maintained;
; otherwise, some patterns could cause an infinite loop.
(defun gldefpatterns (patwd l)
  (dolist (pat l)
    (if (or (not (eq patwd 'glpatterns)) (glpattest pat))
        (unless (member pat (get (caar pat) patwd) :test #'equal)
          (setf (get (caar pat) patwd)
                (nconc (get (caar pat) patwd) (list pat))))) ) )


; edited:  2-MAR-83; 28 Nov 90; 29 Mar 91; 08 Oct 91; 12 Apr 93; 22 Apr 93
; 11 May 98
; Define properties for an object type. Each property is of the form 
;   (<propname> (<definition>) <properties>) 
(defun gldefprop (object prop lst)
  (let ()
    (if (some #'null lst)
        (setq lst (mapcan #'(lambda (x) (if x (list x))) lst)))
    (if (consp lst)
        (dolist (x lst)
          (unless (or (eq prop 'doc)
                      (and (eq prop 'supers)
                           (symbolp x))
                      (and (consp x)
                           (symbolp (car x))
                           (or (cdr x) (eq prop 'viewspecs))))
            (format t "GLDEFPROP: For ~A the ~A property ~A has bad form.~%"
                    object prop x) ) )
        (unless (null lst)
          (format t "GLDEFPROP: For ~A the ~A spec should be a list.~%"
                  object prop)))
    (if lst (nconc (glstr object) (list prop lst))) ))


; 1-JUN-83; 19 May 92; 03 Nov 92
; Process a Structure Description. The format of the argument is the 
; name of the structure followed by its structure description, 
; followed by other optional arguments. 
(defun gldefstr (lst systemflg)
  (prog (strname str oldstr)
    (unless (and (consp lst)
                 (symbolp (setq strname (pop lst))))
      (format t "gldefstr: ~A is a bad structure spec~%" lst)
      (return))
    (cond ((and (not systemflg)
                (glbasictypep strname))
            (format t "The GLISP type ~A may not be redefined by the user.~%"
                    strname)
             (return))
          ((setq oldstr (glstr strname))
            (cond ((equal oldstr lst) (return))
                  ((not *glquietflg*)
                    (format t "~A structure redefined.~%" strname)))
            (glstrchanged strname)))
    (setq str (pop lst))
    (setf (glstructure strname) (list str))
    (unless (glokstr? str)
      (format t "~A has faulty structure specification.~%" strname))
    (pushnew strname *globjectnames*)
      
; process the remaining specifications, if any. each additional 
;   specification is a list beginning with a keyword. 

  lp  (unless lst (return))
      (gldefprop strname (car lst) (cadr lst))
      (setq lst (cddr lst))
      (go lp)))


; edited: 27-APR-82 11:01 
(defmacro gldefstrnames (&rest lst) `(gldefstrnames-expr ',lst))
(defun gldefstrnames-expr (lst)
(dolist (x lst)
        (let (tmp)
             (if (setq tmp (assoc (car x)
                                  *gluserstrnames*))
                 (setf (cdr tmp)
                       (cdr x))
                 (setq *gluserstrnames* (nconc1 *gluserstrnames* x))))))


; 10-FEB-83; 07 May 91
; Define named structure descriptions. The descriptions are of the 
; form (<name> <description>) . Each description is put on the 
; property list of <name> as GLSTRUCTURE 
(defmacro gldefstrq (&rest args) `(gldefstrq-expr ',args))
(defun gldefstrq-expr (args)
  (dolist (arg args) (gldefstr (copy-tree arg) nil)))


; 10-FEB-83; 07 May 91
; Define system structure descriptions.
(defun gldefsysstr (args)
  (dolist (arg args) (gldefstr (copy-tree arg) t) ) )


; edited: 27-MAY-82 13:00 
; This function is called by the user to define a unit package to the 
;   GLISP system. The argument, a unit record, is a list consisting of 
;   the name of a function to test an entity to see if it is a unit of 
;   the units package, the name of the unit package's runtime GET 
;   function, and an ALIST of operations on units and the functions to 
;   perform those operations. Operations include GET, PUT, ISA, ISADJ, 
;   NCONC, REMOVE, PUSH, and POP. 
(defun gldefunitpkg (unitrec)
(prog (lst)
      (setq lst *glunitpkgs*)
      a
      (cond ((null lst)
             (setq *glunitpkgs* (nconc1 *glunitpkgs* unitrec))
             (return))
            ((eq (caar lst)
                 (car unitrec))
             (setf (car lst)
                   unitrec)))
      (pop lst)
      (go a)))


; 10 Mar 92
; If a code-type pair has a (^. record) type, dereference it.
(defun gldereference (codetype)
  (let (tmp)
    (or (and (consp (cadr codetype))
             (eq (caadr codetype) '^.)
             (glpointerp (cadadr codetype))
             (or (and (setq tmp (glpointstosimply (cadadr codetype)))
                      (glstoragestrp tmp)
                      (list (car codetype) tmp))
                 (glvalue (car codetype) 'dereference (cadadr codetype) nil)
                 (and tmp (list (car codetype) tmp))))
        codetype) ))


; 10 Oct 89; 26 Oct 06; 06 Nov 06
; Test if one type has another as a super
(defun gldescendantp (subtype supertype)
  (let (tp)
    (and subtype supertype (symbolp subtype) (symbolp supertype)
         (not (eq subtype 'anything))
         (or (eq subtype supertype)
             (eq supertype 'anything)
             (and (symbolp subtype)
                  (not (eq (setq tp (glxtrtypeg subtype))
                           subtype))
                  (symbolp tp)
                  (gldescendantp tp supertype))
             (some #'(lambda (x) (gldescendantp x supertype))
                   (glsupers subtype))) ) ))


; 10 Oct 89
; Get all types that have TYPE as a super
; very inefficient implementation: 1.6 sec with 200 types defined     *****
; (defun gldescendants (type)
;   (mapcan #'(lambda (x) (if (gldescendantp x type) (list x)))
;         *globjectnames*))


; edited: 03 Oct 89; 30 Nov 89; 20 Sep 90; 08 Jan 91; 07 Feb 91; 03 Jan 92
; 23 Apr 98; 30 May 08
; Function to compile an expression of the form (A <type> ...) 
(defun gldoa (*glexpr*)
  (let ((type (cadr *glexpr*)) unitrec tmp)
    (cond ((and (consp type)
                (not (or (member (car type) *gltypenames*)
                         (eq (car type) 'units))))
                                       ; was '(typeof clustertype or)
            (setq type (glevaltype type))
            (if (and (consp type) (eq (car type) '^.))
                (setq type (glpointsto (cadr type))))
            (glnoticetype type)
            (glmakestr type (cddr *glexpr*)))
          ((glgetstr type)
            (glnoticetype type)
            (glmakestr type (cddr *glexpr*)))
          ((glokstr? type)
            (glmakestr type (cddr *glexpr*)))
          ((and (setq unitrec (glunit? type))
                (setq tmp (assoc 'a (caddr unitrec))))
            (funcall (cdr tmp) *glexpr*))
          (t (glerror 'gldoa "The type  ~A  is not defined." type)))))


; 10 Jun 04; 23 Sep 04; 17 Jul 06
; Process (and ...) as a special form as in Lisp
(defun gldoand (*glexpr* *glcontext*)
  (let (res item type done tmp oldcontext)
    (setq oldcontext *glcontext*)
    (pop *glexpr*)
    (setq *glcontext* (cons nil oldcontext))
    (while (and *glexpr* (not done))
      (setq item (gldoexpr nil *glcontext* t))
      (setq type (cadr item))      ; *** or with other types
      (if (glconstantp (car item))
          (progn (setq tmp (glconstval (car item)))
                 (if (eq tmp nil)
                     (progn (setq done t) (setq res nil))
                     (if (null *glexpr*)
                         (if (not (and res
                                       (glboolean (car res))
                                       (eq tmp t)))
                             (push (car item) res)))))
          (push (car item) res)) )
    (if (cdr res)
        (list (cons 'and (reverse res)) type)
        (list (car res) type) ) ))


; 6-JUN-83; 20 July 89; 19 Oct 93; 30 Nov 93; 28 Dec 93; 04 Jan 95; 08 May 09
; Compile code for Case statement. 
; Modified 6 June 83 to allow GLISP constants as CASE selectors as 
;   suggested by Jed Marti of Rand.
; Modified to select the right case directly if selector is constant 28 Dec 93
(defun gldocase (*glexpr*)
  (let (selector result sels tmp resulttype typeok tmpb done newcontext)
    (setq typeok t)
    (setq selector (glpushexpr (list (cadr *glexpr*)) nil *glcontext* t))
    (setq selector (glevalcode selector *glcontext*))
    (setq *glexpr* (cddr *glexpr*))
    (if (eq (car *glexpr*) 'of) (pop *glexpr*))    ; get rid of "of" if present
    (while (and *glexpr* (not done))
      (setq newcontext (cons nil *glcontext*))
      (if (atom (car *glexpr*))
          (if (eq (car *glexpr*) 'else)
              (progn (setq sels t)
                     (setq *glexpr* (list *glexpr*)))
              (progn (glerror 'gldocase "Bad item ~A in Case" (car *glexpr*))
                     (setq sels nil)
                     (setq *glexpr* nil)))
          (setq sels        
                (if (atom (caar *glexpr*))
                    (or (and (setq tmpb (glstrprop (cadr selector) 'values
                                                   (caar *glexpr*)
                                                   nil))
                             (cadr tmpb))
                        (and (glconstantp (caar *glexpr*))
                             (glconstval (caar *glexpr*)))
                        (caar *glexpr*))
                    (mapcar
                     #'(lambda (x)
                         (or (and (setq tmpb (glstrprop (cadr selector)
                                                        'values x nil))
                                  (cadr tmpb))
                             (and (glconstantp x)
                                  (glconstval x))
                             x))
                     (caar *glexpr*)))) )
      (if (and sels                             ; if this case is possible
               (if (constantp (car selector))
                   (and (if (consp sels)
                            (member (glconstval (car selector)) sels)
                            (or (eq sels t)
                                (eql (glconstval (car selector)) sels)))
                        (setq done t))
                   t))
          (progn (setq tmp (glprogn (cdar *glexpr*) newcontext))
                 (push (cons sels (car tmp)) result)
; if all result types are the same, then the result type is known
                 (if typeok
                     (cond ((null resulttype) (setq resulttype (cadr tmp)))
                           ((equal resulttype (cadr tmp)))
                           (t (setq typeok nil)
                              (setq resulttype nil)))) ) )
      (pop *glexpr*) ) ; end while
    (unless result
      (glerror 'gldocase "Warning: no case defined for ~A"
               (car selector)) )
    (list (glgencode (cons 'case (cons (car selector) (nreverse result))))
          resulttype) ))

; 27 Dec 10; 28 Dec 10
; process a 'comprise' declaration in a let:
; (let ( ... (<var> (comprise <goaltype> (<goalvar> <code>)*)) ...)
; <var> is not made a let var, but is put in context as an alias.
; all vars used in <code> parts must be defined at this point.
(defun gldocomprise (form context)
  (let (goaltype invars ct vlist)
    (setq goaltype (cadr form))
    (dolist (pair (cddr form))    ; pair is (<goalvar> <code>)
      (setq invars (union invars (glvarsin (cadr pair)))) )
    (dolist (var invars)
      (if (setq ct (glcodetype var context))
          (push ct vlist)
          (glerror 'gldocomprise "Var ~A not defined at this point" var) ) )
    (list 'viewer vlist (list (list 'out goaltype))
          (mapcar #'(lambda (x) (list (car x) (list (cadr x))))
                  (cddr form)) ) ))

; 23-APR-82
; Compile a COND expression. 
(defun gldocond (condexpr)
  (prog (result tmp typeok resulttype)
    (setq typeok t)
  a (unless (setq condexpr (cdr condexpr))
      (go b))
    (setq tmp (glprogn (car condexpr) *glcontext*))
    (unless (eq (caar tmp) nil)
      (setq result (nconc1 result (car tmp)))
      (if typeok (cond ((null resulttype)
                         (setq resulttype (cadr tmp)))
                       ((equal resulttype (cadr tmp)))
                       (t (setq resulttype nil)
                          (setq typeok nil)))))
    (unless (eq (caar tmp) t)
      (go a))
  b (return (list (if (and (null (cdr result))
                           (eq (caar result) t))
                      (cons 'progn (cdar result))
                      (cons 'cond result))
                  (and typeok resulttype))) ))


; 26-Feb-88; 14-Feb-89; 19 Jan 90; 14 May 90; 10 Oct 90; 01 May 91
; 05 Mar 92; 12 Mar 92; 05 Nov 92; 27 Oct 93; 02 May 95; 12 Mar 98
; 20 Feb 03; 10 Jun 04; 17 Jul 06; 05 Oct 06; 29 Jan 09
; Compile a single expression. START is set if *GLEXPR* is the start 
;   of a new expression, i.e., if *GLEXPR* might be a function call. 
;   The global variable *GLEXPR* is the expression, *GLCONTEXT* the 
;   context in which it is compiled. *GLVALBUSY* is T if the value of 
;   the expression is needed outside the expression. The value is a 
;   list of the new expression and its value-description. 
(defun gldoexpr (start *glcontext* *glvalbusy*)
  (prog (*glfirst* tmp result)
    (push *glexpr* *glexprstack*)
    (if *gldoexpr-trace* (format t "gldoexpr: ~A~%" *glexpr*))
    (cond ((atom *glexpr*)
            (glerror 'gldoexpr "Expression is not a list.")
            (go out))
          ((and (not start)
                (stringp (car *glexpr*)))
            (go a))
          ((or (not (symbolp (car *glexpr*)))
               (not start))
            (go a)))
      
; test the initial atom to see if it is a function name. it is assumed 
;   to be a function name if it doesnt contain any glisp operators and 
;   the following atom doesnt start with a glisp binary operator. 

    (cond ((member (car *glexpr*) '(quote function))
            (setq *glfirst* (car *glexpr*))
            (go b)))
    (glsepinit (car *glexpr*))
      
; see if the initial atom contains an expression operator. 

    (cond ((not (eq (setq *glfirst* (glsepnxt))
                    (car *glexpr*)))
            (if (or (fboundp (car *glexpr*))
                    (glmacro (car *glexpr*))
                    (and (not (eq *glfirst* '~))
                         (gloperator? *glfirst*)))
                (progn (glsepclr)
                       (setq *glfirst* (car *glexpr*))
                       (go b))
                (progn (glsepclr)
                       (go a))))
; **** Commented out by GSN  10 Nov 89
;           ((or (eq *glfirst* '~) (eq *glfirst* '-)) (glsepclr) (go a))
; **** Added back 19 Jan 90
          ((eq *glfirst* '~) (glsepclr) (go a))
          ((or (atom (cdr *glexpr*))
               (not (symbolp (cadr *glexpr*))))
            (go b)))
      
; see if the initial atom is followed by an expression operator. 

    (glsepinit (cadr *glexpr*))
    (setq tmp (glsepnxt))
    (glsepclr)
    (if (gloperator? tmp) (go a))
      
; the *glexpr* is a function reference. test for system functions. 

 b  (setq result
          (case *glfirst*
            (quote (gldoquote *glexpr*))
            (go (list *glexpr* nil))
            ((prog let let*) (gldoprog *glexpr* *glcontext*))
            (function (gldofunction *glexpr* nil *glcontext* t))
            (setq (gldosetq *glexpr*))
            (cond (gldocond *glexpr*))
            (return (gldoreturn *glexpr*))
            ((dotimes dolist) (gldolist *glexpr*))
            (for (gldofor *glexpr*))
            (that (gldothat *glexpr*))
            (those (gldothose *glexpr*))
            (if (gldoif *glexpr* *glcontext*))
            (and (gldoand *glexpr* *glcontext*))
            (or (gldoor *glexpr* *glcontext*))
            ((a an) (gldoa *glexpr*))
            ((send glsend glsendv) (gldosend *glexpr*))
            ((progn prog2) (gldoprogn *glexpr*))
            (prog1 (gldoprog1 *glexpr* *glcontext*))
            (while (gldowhile *glexpr* *glcontext*))
            (repeat (gldorepeat *glexpr*))
            (case (gldocase *glexpr*))
            ((map mapl maplist mapcon mapc mapcar mapcan some every)
              (gldomap *glexpr*))
            (view (gldoview *glexpr* *glcontext*))
            (viewas (gldoviewas *glexpr* *glcontext*))
            (virtual (gldovirtual *glexpr* *glcontext*))
            (^. (gldopointdot *glexpr*))
            (t (gluserfn *glexpr*))))
    (go out)
     
; the current *glexpr* is possibly a glisp expression. parse the next 
;   subexpression using glparsexpr. 

 a  (setq result (glparsexpr))
    (if (and start *glexpr*)
        (glerror 'gldoexpr "Expression not fully parsed: ~A" *glexpr*))
out (pop *glexprstack*)
    (return result)))


; edited: 22-JUL-83 14:34 
; Parse an expression if the compiler is present, else just return it. 
(defun gldoexprc (start *glcontext* *glvalbusy*)
(cond ((glispcp)
       (gldoexpr start *glcontext* *glvalbusy*))
      (start (list *glexpr* 'anything))
      (t (list (pop *glexpr*)
               'anything))))


(defvar *gldofor-debug*)

; edited: 16-Mar-89; 31 Aug 90; 17 Sep 90; 20 Sep 90; 26 Nov 90; 21 Feb 91;
; 22 Feb 91; 26 Feb 91; 28 Feb 91; 12 March 91; 28 Mar 91; 02 Apr 91;
; 04 Apr 91; 11 Apr 91; 01 Oct 91; 05 Oct 91; 27 Dec 91; 30 Dec 91; 03 Jan 92;
; 29 Jan 92; 18 May 93; 28 May 93; 19 Oct 93; 03 Nov 93; 10 Nov 93; 03 May 94;
; 07 Jun 94; 10 Nov 94; 17 Nov 94; 01 Mar 05; 02 Mar 05; 14 Sep 06; 30 Dec 08
; 12 May 09
; Compile code for a FOR loop. 
(defun gldofor (*glexpr*)
  (prog (domain cdomain *gldomainname* dtype dtypeb dtmp origexpr
                loopvar newcontext singflag loopcond condition
                collectcode saveexpr iterator-macro tmp ittype
                loopverb loopfn collecttype result restype stopcond)
    (setq origexpr *glexpr*)
    (pop *glexpr*)
  
; parse the forms (for each <set> ...) and (for <var> in <set> ...) 
    (cond ((eq (car *glexpr*) 'each)
             (setq singflag t)
             (pop *glexpr*))
          ((and (symbolp (car *glexpr*))    ; (for <var> in ...) 
                (eq (cadr *glexpr*) 'in))
             (setq loopvar (pop *glexpr*))
             (pop *glexpr*))
          (t (go x)))
  
; now get the <set> 
    (unless (setq domain (gldomain singflag))
            (go x))
    (setq dtype (glxtrtype (cadr domain)))
    (if (glviewerp dtype) (setq dtype (glvvct domain)))
    (cond ((or (null dtype)
               (eq dtype 'anything))
             (setq dtype '(listof anything)))
          ((and (consp dtype)
                (member (car dtype) '(listof list))))
          ((or (and (consp (setq dtmp (glxtrtype (glgetstr dtype))))
                    (eq (car dtmp) 'listof))
               (null dtmp))
             (setq dtype dtmp))
          ((and (setq tmp (glstrprop dtype 'msg 'iterator nil))
                (glmacro (cadr tmp)))
             (setq iterator-macro (cadr tmp)))
          ((and (setq tmp (glstrprop dtmp 'msg 'iterator nil))
                (glmacro (cadr tmp)))
             (setq domain (list (car domain) dtmp))  ; 29 Jan 92
             (setq iterator-macro (cadr tmp)))
          ((and (symbolp dtype)                      ; 19 Oct 93
                (setq tmp (assoc 'iterator (glmacrodefs dtype))))
             (setq iterator-macro (cadr tmp)))
          ((and (symbolp dtmp)                       ; 19 Oct 93
                (setq tmp (assoc 'iterator (glmacrodefs dtmp))))
             (setq iterator-macro (cadr tmp)))
;    Infer view to use if some view has an iterator defined.   17 Sept 90
          ((and (setq ittype
                      (some #'(lambda (x)
                                (if (setq tmp (glstrprop (cadr x)
                                                'msg 'iterator nil))
                                    (cadr x)))
                            (glviews dtype)))
                (glmacro (cadr tmp)))
             (setq iterator-macro (cadr tmp))
             (setq dtype ittype)
             (setq domain (list (car domain) ittype)))
          ((and (consp dtype)
                (consp (setq dtmp (glconstanttree dtype 1)))
                (eq (car dtmp) 'listof))
            (setq dtype dtmp))
          (t (glerror 'gldofor
               "Warning: Domain of FOR loop, of type ~A, is not a LISTOF type."
               dtype)
             (setq dtype '(listof anything))))
    (setq saveexpr *glexpr*)

; add a level onto the context for the inside of the loop. 

    (setq newcontext (cons nil *glcontext*))
    (gladdfact (list 'label nil) *glcontext*)
; if a loop variable was not specified, make one. 

    (or loopvar (setq loopvar (glgensym 'glvar)))
    (gladdstr loopvar (and singflag *gldomainname*)
                      (setq dtypeb
                            (or (glloopitemtype dtype)
                                (if (glpointerp dtype)
                                    (list '^. dtype)   ; 12 Mar 91
                       ; vs.  (glxtrtype (car (glstr (glpointerp dtype))))
                                    (or (and (symbolp dtype)
                                             (glxtrtypec (glclusterrole
                                                           (glcluster dtype)
                                                           'item)))
                                        dtype))))
                      newcontext)
  
; see if a condition is specified. if so, add it to loopcond. 

    (cond ((eq (car *glexpr*) 'with)
            (pop *glexpr*)
            (setq loopcond (glpredicate (list loopvar dtypeb)
                                        newcontext nil nil)))
          ((member (car *glexpr*) '(which who that))
            (pop *glexpr*)
            (setq loopcond (glpredicate (list loopvar dtypeb)
                                        newcontext t t))))
    (if (and *glexpr* (eq (car *glexpr*) 'when))
        (progn
          (pop *glexpr*)
          (if iterator-macro
              (setq condition (pop *glexpr*))
              (setq loopcond
                    (if loopcond
                        (glandfn loopcond (gldoexpr nil newcontext t))
                        (gldoexpr nil newcontext t)))) ) )
    (if (and *glexpr* (eq (car *glexpr*) 'until))
        (progn
          (pop *glexpr*)
          (setq stopcond (gldoexpr nil newcontext t)) ) )
    (case (car *glexpr*)
          (do (pop *glexpr*))
          (collect
            (setq loopverb (pop *glexpr*))
            (if (eq (car *glexpr*) 'as)
                (progn (pop *glexpr*)
                       (setq collecttype (pop *glexpr*))
                       (if (consp collecttype)
                           (if (member (car collecttype) '(typeof clustertype))
                               (setq collecttype (glevaltype collecttype))
                               (if (setq tmp
                                         (glfindview (cadr collecttype)
                                                     (car collecttype)))
                                   (setq collecttype tmp))))
                       (setq collecttype (or (glfindcollection collecttype)
                                             collecttype))
                       (when (and (consp collecttype)
                                (eq (car collecttype) 'listof))
                         (setq restype collecttype)
                         (setq collecttype 'lisp-linked-list-pointer)
                         (setq iterator-macro 'lisp-linked-list-collector))
                       (glnoticetype collecttype)
                       (setq iterator-macro
                             (glfindmacro collecttype 'collect)) )
                (unless (and (consp dtype)
                             (eq (first dtype) 'listof))
                  (setq collecttype 'lisp-linked-list-pointer)
                  (setq restype (list 'listof dtypeb))
                  (setq iterator-macro 'lisp-linked-list-collector))))
          (reduce (pop *glexpr*) (setq loopfn (gldoexpr nil newcontext t)) )
          (t (when (and (symbolp (first *glexpr*))
                        (glmacrodef (first *glexpr*)))
                   (setq loopverb (pop *glexpr*))
                   (setq iterator-macro (glmacrodef loopverb)))))

    (cond (iterator-macro
            (setq result (glmacroexpand iterator-macro
                           (if collecttype
                               (list domain (list nil collecttype))
                               (list domain))
                           (list loopvar
                                 (or condition (first loopcond) t) ; ???? both?
                                 *glexpr*
                                 (first stopcond)))))
          ((eq loopverb 'collect)
            (setq collectcode (gldoexpr nil newcontext t))
            (setq collectcode (glmatn (list (list (car collectcode))
                                            (cadr collectcode))))
            (setq collectcode (list (caar collectcode) (cadr collectcode)))
            (setq result (glmakeforloop loopvar domain nil
                                        loopcond collectcode stopcond)))
          ((and (glconstantp (car domain))
                (setq cdomain (glconstval (car domain)))
                (consp cdomain)
                (<= (length cdomain) 50))
            (setq result (glunrollforloop loopvar cdomain dtype loopcond
                                            *glexpr* newcontext
                                            (or (and (consp loopfn)
                                                     (member (caar loopfn)
                                                             '(quote function))
                                                     (symbolp (cadar loopfn))
                                                     (cadar loopfn))
                                                'progn))))
          (t (setq result (glmakeforloop loopvar domain
                                         (car (glprogn *glexpr* newcontext))
                                         loopcond collectcode stopcond))))
    (setq *gldofor-debug*
          (list 'domain domain 'cdomain cdomain '*gldomainname* *gldomainname*
                'dtype dtype 'dtypeb dtypeb 'dtmp dtmp 'origexpr origexpr
                'loopvar loopvar 'newcontext newcontext 'singflag singflag
                'loopcond loopcond 'condition condition 'stopcond stopcond
                'collectcode collectcode
                'saveexpr saveexpr 'iterator-macro iterator-macro 'tmp tmp
                'ittype ittype 'loopverb loopverb 'collecttype collecttype
                'result result 'restype restype))
  
    (return (if restype
                (list (first result) restype)
                result))
 x  (return (gluserfn origexpr)) ))


; 26-JAN-83; 19 Jan 90; 27 Dec 94; 15 Mar 95; 29 May 95; 08 Oct 02
; Compile a function expression,  (function (lambda ... ))
; TYPES is a list of argument types which is sent in from outside,
; e.g. when a mapping function is compiled. 
(defun gldofunction (*glexpr* argtypes *glcontext* *glvalbusy*)
  (prog (newcode ptr args)
    (cond ((not (and (consp *glexpr*)
                     (member (car *glexpr*) '(quote function))))
            (return (glpushexpr *glexpr* t *glcontext* t)))
          ((symbolp (cadr *glexpr*))
            (return (list *glexpr* (glresulttype (cadr *glexpr*) argtypes))))
          ((not (member (caadr *glexpr*) '(glambda lambda)))
            (glerror 'gldofunction "Bad functional form.")))
    (push nil *glcontext*)
    (setq args (gldecl (cadadr *glexpr*) nil *glcontext* nil nil))
    (setq ptr (nreverse (car *glcontext*)))
    (setf (car *glcontext*) nil)
    (dolist (ctxent ptr)
      (gladdstr (cadr ctxent) nil (or (caddr ctxent) (car argtypes))
                *glcontext*)
      (pop argtypes))
    (push nil *glcontext*)              ; add a label since this may be in loop
    (gladdfact (list 'label nil) *glcontext*)
    (setq newcode (glprogn (cddadr *glexpr*) *glcontext*))
    (return (list (list 'function
                        (cons 'lambda (cons args (car newcode))))
                  (cadr newcode)))))


; edited: 11-Feb-84; 11 Mar 91; 06 May 04; 01 Jun 04; 26 Sep 06
; New version: (if <expr> <then> <else>)
; Process an IF ... THEN expression. 
(defun gldoif (*glexpr* *glcontext*)
  (let (pred oldcontext tmp thenpart elsepart)
    (setq oldcontext *glcontext*)
    (pop *glexpr*)
    (setq *glcontext* (cons nil oldcontext))
    (setq pred (glpredicate nil *glcontext* nil t))
    (if (or (member 'then *glexpr*)
            (member 'else *glexpr*)
            (member 'elseif *glexpr*)
            (not (consp *glexpr*))
            (> (length *glexpr*) 2))
        (glerror 'gldoif "Bad IF statement ~A~%" *glexpr*))
    (if (glconstantp (car pred))        ; if predicate value is constant
        (if (setq tmp (glconstval (car pred)))
            (gldoexpr nil *glcontext* t)  ; if true: reduce to then part
            (progn (pop *glexpr*)   ; if false: reduce to else
                   (if *glexpr*
                       (gldoexpr nil *glcontext* t)
                       (list nil nil))))
        (progn (setq thenpart (gldoexpr nil *glcontext* t))
               (if (glvvct thenpart)
                   (setq thenpart (glmaterialize thenpart nil nil)))
               (if *glexpr*
                   (progn (setq elsepart (gldoexpr nil *glcontext* t))
                          (if (glvvct elsepart)
                              (setq elsepart (glmaterialize elsepart nil nil)))
                          (list (list 'if (car pred) (car thenpart)
                                                     (car elsepart))
                                (or (cadr thenpart) (cadr elsepart))))
                   (list (list 'if (car pred) (car thenpart))
                         (cadr thenpart)))) ) ))


; 16-DEC-81; 27 Dec 94
; Compile a LAMBDA expression for which the ARGTYPES are given. 
(defun gldolambda (*glexpr* argtypes *glcontext*)
  (let (args newexpr *glvalbusy*)
    (setq args (cadr *glexpr*))
    (push nil *glcontext*)
    (dolist (arg args)
      (gladdstr arg nil (pop argtypes) *glcontext*))
    (setq *glvalbusy* t)
    (setq newexpr (glprogn (cddr *glexpr*) *glcontext*))
    (list (cons 'lambda (cons (cadr *glexpr*) (car newexpr)))
          (cadr newexpr))))


; 27 Oct 93; 02 Jan 95
; Process dolist and dotimes special forms
(defun gldolist (doexpr)
  (let (args loopvar loopvartype loopover loopval code newcontext)
    (unless (and (consp (setq args (second doexpr)))
                 (symbolp (setq loopvar (pop args))))
      (glerror "Bad form of dolist/dotimes" nil))
    (setq *glexpr* args)
    (setq loopover (gldoexpr nil *glcontext* t))
    (setq loopvartype
          (if (eq (first doexpr) 'dotimes)
              'integer
              (if (and (eq (first doexpr) 'dolist)
                       (consp (cadr loopover))
                       (eq (caadr loopover) 'listof))
                  (cadadr loopover))))
    (setq newcontext (cons nil *glcontext*))
    (gladdstr loopvar nil loopvartype newcontext)
    (gladdfact (list 'label nil) *glcontext*)
    (if *glexpr* (setq loopval (gldoexpr nil *glcontext* t)))
    (setq code (glprogn (cddr doexpr) newcontext))
    (list (cons (first doexpr)                         ; dolist / dotimes
                (cons (cons loopvar                    ; var
                            (cons (first loopover)     ; set
                                  (if loopval (list (first loopval)))))
                      (first code)))
          (second loopval)) ))


; 16-Mar-89
; Get a domain specification from the EXPR. If SINGFLAG is set and the 
; top of *GLEXPR* is a simple atom, the atom is made plural and used 
; as a variable or field name. 
(defun gldomain (singflag)         ; singflag = nil in new gldofor
  (prog (name *glfirst*)
    (cond ((eq (car *glexpr*) 'the)
            (setq *glfirst* (car *glexpr*))
            (return (glparsfld nil)))
          ((symbolp (car *glexpr*))
            (glsepinit (car *glexpr*))
            (if (eq (setq name (glsepnxt)) (car *glexpr*))
                (progn (pop *glexpr*)
                       (setq *gldomainname* name)
                       (return (if singflag
                                   (if (eq (car *glexpr*) 'of)
                                       (progn (setq *glfirst* 'the)
                                              (push (glplural name) *glexpr*)
                                              (glparsfld nil))
                                       (glidname (glplural name) nil))
                                   (glidname name nil))))
                (progn (glsepclr)
                       (return (gldoexpr nil *glcontext* t)))))
          (t (return (gldoexpr nil *glcontext* t))))))


; 10-Sep-86; 27 Dec 94; 28 Dec 94; 02 Jan 95
; Fast fix by GSN on 8 June 83 to include CDR function for maps. 
; Compile code for MAP functions. MAPs are treated specially so that 
; types can be propagated.
(defun gldomap (*glexpr*)
  (let (mapfn mapset settype mapcode newcode resulttype itemtype mapsets types
              newcontext)
    (setq mapfn (pop *glexpr*))    ; ***** CL fn MAP not handled *****
    (if (eq mapfn 'map) (glerror 'gldomap "MAP is not handled properly"))
    (setq mapcode (pop *glexpr*))
    (while *glexpr*
      (setq mapset (gldoexpr nil *glcontext* t))
      (setq settype (glxtrtypeb (cadr mapset)))
      (if (and (consp settype)
               (member (car settype) '(listof list)))
          (setq itemtype
                (if (member mapfn '(mapl maplist mapcon))
                    (cons 'listof (cadr settype))
                    (cadr settype))))
      (push (car mapset) mapsets)
      (push itemtype types) )
    (setq types (nreverse types))
    (setq newcontext (cons nil *glcontext*))
    (gladdfact (list 'label nil) newcontext)
    (setq newcode (gldofunction mapcode types newcontext
                                (member mapfn '(maplist mapcon mapcar mapcan))))
    (setq resulttype (case mapfn
                       ((mapl mapc) nil)
                       ((maplist mapcon mapcar mapcan)
                         (list 'listof (cadr newcode)))
                       (subset (first types))
                       (some   (cadr newcode))
                       ((every notany notevery) 'boolean)
                       (t nil)))
    (list (cons mapfn (cons (car newcode) (nreverse mapsets)))
          resulttype)))


; Edited 22-Apr-88; 21 Nov 90; 01 Apr 99; 05 Jan 00; 05 Mar 02
; Attempt to compile code for the sending of a message to an object. 
;   OBJECT is the destination, in the form (<code> <type>) , SELECTOR 
;   is the message selector, and ARGS is a list of arguments of the 
;   form (<code> <type>) . The result is of the form (<code> <type>),
;   or NIL if failure. 
(defun gldomsg (object selector args)
  (prog (unitrec type tmp method trans fetchcode res sel)
    (setq type (glxtrtypef object))
    (cond ((setq method (glstrprop type 'msg selector args))
            (return (glcompmsgl object 'msg method args *glcontext*)))
          ((and (null args)
                (setq res (glvalue (car object) selector (cadr object) nil)))
            (return res))
          ((and args (null (cdr args))
                (char= (lastchar selector) #\:)
                (setq sel (subatom selector 1 -2))
                (setq res (glvalue (car object) sel (cadr object) nil)))
            (return (glputfn res (car args) nil)))
          ((and (null args)
                (setq method (or (glstrprop type 'adj selector args)
                                 (glstrprop type 'isa selector args))))
            (return (glcompmsgl object 'msg method args *glcontext*)))
          ((and (setq unitrec (glunit? type))
                (setq tmp (assoc 'msg (caddr unitrec))))
            (return (funcall (cdr tmp) object selector args)))
          ((setq trans (gltransparenttypes type)))
          ((and (member type '(number real integer))
                (member selector '(+ - * / ^ > < >= <= == !=))
                args
                (null (cdr args))
                (member (glxtrtype (cadar args)) '(number real integer)))
            (return (glreducearith selector object (car args))))
          (t (return)))
      
; see if the message can be handled by a transparent subobject. 

 b  (cond ((null trans) (return))
          ((setq tmp (gldomsg (list '*gl* (glxtrtype (car trans)))
                              selector args))
            (setq fetchcode (glstrfn (car trans) (cadr object) nil))
            (if (car fetchcode) (glstrval tmp (car fetchcode)))
            (glstrval tmp (car object))
            (return tmp))
          ((setq trans (cdr trans))
            (go b))) ))

; 10 Jun 04; 17 Jul 06
; Process (or ...) as a special form as in Lisp
(defun gldoor (*glexpr* *glcontext*)
  (let (res item type done tmp oldcontext)
    (setq oldcontext *glcontext*)
    (pop *glexpr*)
    (setq *glcontext* (cons nil oldcontext))
    (while (and *glexpr* (not done))
      (setq item (gldoexpr nil *glcontext* t))
      (setq type (cadr item))      ; *** or with other types
      (if (glconstantp (car item))
          (progn (setq tmp (glconstval (car item)))
                 (if (not (eq tmp nil))
                     (progn (push (car item) res)
                            (setq done t))))
          (push (car item) res)) )
    (if (cdr res)
        (list (cons 'or (reverse res)) type)
        (list (car res) type) ) ))


; 14 May 90; 17 May 90; 22 May 90
; Process a function call of the form (^. <arg>).
; If <arg> is a pointer type, return <arg> with the type (^. <arg-type>).
(defun gldopointdot (*glexpr*)
  (let ((svglexpr *glexpr*) arg argtp argtpb)
    (pop *glexpr*)
    (setq arg (gldoexpr nil *glcontext* t))
    (if (glpointerp (cadr arg))
        (list (car arg) (list '^. (cadr arg)))
        (if (and (setq argtp (car (glstr (cadr arg))))
                 (setq argtpb (glxtrtype argtp))
                 (glpointerp argtpb))
            (list (car arg) (list '^. argtpb))
            (gluserfn svglexpr))) ))


; 17-Mar-89; 05 Mar 92; 10 Apr 92; 29 Dec 94; 02 Jan 95; 04 Jan 95; 06 Jan 95
; 29 May 95; 18 Mar 99; 08 Oct 02; 20 Aug 04; 14 Sep 06
; Compile a PROG expression. 
(defun gldoprog (*glexpr* *glcontext*)
  (prog (proglst newexpr result nextexpr tmp *glprogresulttype* progwd
         lasttype newp pl)
    (setq progwd (pop *glexpr*))
    (push nil *glcontext*)
    (setq proglst (gldecl (pop *glexpr*) t *glcontext* nil nil))
    (setq pl proglst)
; gensym new names for any that may conflict with names in context
    (while pl
      (if (and (symbolp (car pl)) (glusedinctx (car pl) *glcontext*))
          (progn (setq newp (glgensym (car pl)))
                 (setq *glexpr* (subst newp (car pl) *glexpr*))
                 (setf (car pl) newp))
        (if (and (consp (car pl)) (symbolp (caar pl))
                 (glusedinctx (caar pl) *glcontext*))
            (progn (setq newp (glgensym (caar pl)))
                   (setq *glexpr* (subst newp (caar pl) *glexpr*))
                   (setf (caar pl) newp))))
      (setq pl (cdr pl)) )
    (dolist (p proglst)
      (if (and (symbolp p) (not (glspecialp p)))
          (gladdfact (list '= p nil) *glcontext*)
          (if (and (consp p)
                   (and (symbolp (car p)) (not (glspecialp (car p))))
                   (consp (cdr p))
                   (glconstantp (cadr p)))
              (gladdfact (list '= (car p) (kwote (glconstval (cadr p))))
                         *glcontext*) ) ) )
    (push nil *glcontext*)
    (cond ((member progwd '(let let*))
            (setq tmp (glprogn *glexpr* *glcontext*))
            (glnotetypes *glcontext*)
            (return (list (cons progwd (cons proglst (car tmp)))
                          (cadr tmp)))))
; compile the contents of the prog onto newexpr 
  l (unless *glexpr*                ; compile the next expression in a prog. 
      (setq result (cons progwd (cons proglst (nreverse newexpr))))
      (glnotetypes *glcontext*)
      (return (list result (if (eq progwd 'prog)
                               *glprogresulttype*
                               lasttype))))
    (setq nextexpr (pop *glexpr*))
    (cond ((and (eq progwd 'prog) (symbolp nextexpr))
            (push nextexpr newexpr)
      ; set up the context for the label we just found. 
            (gladdfact (list 'label nextexpr) *glcontext*)
            (go l))
          ((and (eq progwd 'prog) (not (consp nextexpr)))
            (glerror 'gldoprog "PROG contains bad stuff:  ~A " nextexpr)
            (go l)))
    (if (setq tmp (glpushexpr nextexpr t *glcontext*
                              (and (eq progwd 'let) (null (cdr nextexpr)))))
        (progn (push (car tmp) newexpr)
               (setq lasttype (cadr tmp))))
    (go l) ))


; edited: 25-JAN-82 17:34 
; Compile a PROG1, whose result is the value of its first argument. 
(defun gldoprog1 (*glexpr* *glcontext*)
(prog (result tmp type typeflg)
      (pop *glexpr*)
      a
      (cond ((null *glexpr*)
             (return (list (cons 'prog1
                                 (nreverse result))
                           type)))
            ((setq tmp (gldoexpr nil *glcontext* (not typeflg)))
             (push (car tmp)
                   result)
             
; get the result type from the first item of the prog1. 

             (unless typeflg (setq type (cadr tmp))
                     (setq typeflg t))
             (go a))
            (t (glerror 'gldoprog1 "PROG1 contains bad subexpression.")
               (pop *glexpr*)
               (go a)))))


; edited:  5-NOV-81
; Compile a PROGN in the source program. 
(defun gldoprogn (*glexpr*)
  (let (res)
    (setq res (glprogn (cdr *glexpr*) *glcontext*))
    (list (cons (car *glexpr*)
                (car res))
          (cadr res))))


; 05 Nov 92
; Process a quoted expression
(defun gldoquote (expr)
  (let ((val (cadr expr)) newval)
    (if (and (consp val)
             (eq (car val) 'q)
             (consp (cdr val))
             (glconstantp (cadr val))
             (consp (cddr val))
             (glunitp (caddr val)))
        (progn (setq newval (glconstval (cadr val)))
               (list newval
                     (list 'units (glconstanttype newval) (caddr val))))
        (list expr (glconstanttype (cadr expr))) ) ))


; 26-MAY-82; 02 Jan 95; 14 Sep 06
(defun gldorepeat (*glexpr*)
  (prog (actions tmp label newcontext)
    (pop *glexpr*)
    (setq newcontext (cons nil *glcontext*))
    (gladdfact (list 'label nil) newcontext)
 a  (cond ((eq (car *glexpr*) 'until)
            (pop *glexpr*))
          ((and *glexpr* (setq tmp (gldoexpr nil newcontext t)))
            (setq actions (nconc1 actions (car tmp)))
            (go a))
          (*glexpr* (return
                  (glerror 'gldorepeat "REPEAT contains bad subexpression."))))
    (when (or (null *glexpr*)
              (null (setq tmp (glpredicate nil newcontext nil nil)))
              *glexpr*)
          (glerror 'gldorepeat "REPEAT contains no UNTIL or bad UNTIL clause")
          (setq tmp (list t 'boolean)))
    (setq label (glgensym 'gllabel))
    (return
     (list (cons 'prog
                 (cons nil (cons label
                                 (nconc1 actions
                                         (list 'cond
                                               (list (glbuildnot
                                                      (car tmp))
                                                     (list 'go label)))))))
           nil))))


; edited: 17-Mar-89
; Compile a RETURN, capturing the type of the result as a type of the 
;   function result. 
(defun gldoreturn (*glexpr*)
  (prog (tmp)
    (pop *glexpr*)
    (return (if *glexpr*
                (progn (setq tmp (gldoexpr nil *glcontext* t))
                       (if (glvvct tmp)
                           (setq tmp (glmaterialize tmp nil nil)))
                       (gladdresulttype (cadr tmp))
                       (list (list 'return (car tmp))
                             (cadr tmp)))
                (progn (gladdresulttype nil)
                       (copy-tree '((return) nil)))))))


; edited: 22-JUL-83; 15 May 90; 17 May 90; 14 Feb 91; 20 Feb 03
; Compile code for the sending of a message to an object. The syntax 
; of the message expression is (glsend <object> <selector> <arg1>...<argn>) ,
; where the glsend may optionally be send.
(defun gldosend (exprr)
  (prog (*glexpr* object selector args tmp fnname)
    (setq fnname (if *glglsendflg* 'glsend (car exprr)))
    (setq *glexpr* (cdr exprr))
    (setq object (glpushexpr (list (pop *glexpr*)) nil *glcontext* t))
    (setq selector (pop *glexpr*))
    (if (and (eq fnname 'glsendv)
             (setq tmp (glevalcodeb (list selector nil) *glcontext*))
             (glconstantp (car tmp)))
        (setq selector (glconstantval (car tmp))))
    (if (or (null selector)
            (not (symbolp selector)))
        (return (glerror 'gldosend
                  " ~A  is an illegal message Selector." selector)) )

; if object is a pointer, dereference it.             ; 15 May 90
    (if (and (consp (cadr object))
             (eq (caadr object) '^.)
             (glpointerp (cadadr object)))
        (setq object
              (or (and (setq tmp (glpointstosimply (cadadr object)))
                       (glstoragestrp tmp)
                       (list (car object) tmp))
                  (glvalue (car object) 'dereference (cadadr object) nil)
                  (and tmp (list (car object) tmp)))))
 
; collect arguments of the message, if any. 

 a (cond
     ((null *glexpr*)
      (if (setq tmp (gldomsg object selector args))
          (return tmp)
          (progn 
; no message was defined, so just pass it through and hope one will be 
;   defined by runtime. 

             (return
               (list (glgencode (cons fnname
                                      (cons (car object)
                                            (cons selector
                                                  (mapcar #'car args)))))
                     (cadr object))))))
     ((setq tmp (gldoexpr nil *glcontext* t))
       (setq args (nconc1 args tmp))
       (go a))
     (t (glerror 'gldosend "A message argument is bad.")))))


; 7-Apr-81; 28 Jul 97; 29 Jul 97; 21 Apr 09
; Compile a SETQ expression 
(defun gldosetq (*glexpr*)
  (let (var lhs rhs)
    (pop *glexpr*)
    (glsepinit (pop *glexpr*))
    (setq var (glsepnxt))
    (setq lhs (glidname var t))
    (setq rhs (gldoexpr nil *glcontext* t))
    (or (and (cadr lhs) (cadr rhs)
             (not (equal (cadr lhs) (cadr rhs)))
             (glcoercearith '= lhs rhs))
        (gldovarsetq var rhs)) ))

; edited: 20-MAY-82; 01 May 91
; Process a THAT expression in a list.  (changed since Common Lisp uses THE)
(defun gldothat (*glexpr*)
  (let (result)
    (setq result (glthe nil))
    (if *glexpr*
        (glerror 'gldothat "Stuff left over at end of That expression.  ~A "
                 *glexpr*))
    result))


; edited: 20-MAY-82
; Process a THOSE expression in a list. 
(defun gldothose (*glexpr*)
  (let (result)
    (pop *glexpr*)
    (setq result (glthe t))
    (if *glexpr* (glerror 'gldothose
                          "Stuff left over at end of expression.  ~A "
                          *glexpr*))
    result))


; 5-MAY-82; 01 Jun 90; 30 Dec 94; 02 Apr 08
; Compile code to do a SETQ of VAR to the RHS. If the type of VAR is 
; unknown, it is set to the type of RHS. 
(defun gldovarsetq (var rhs)
  (if (glvirtualbp (car rhs) (cadr rhs))
      (setq rhs (glmaterialize rhs nil nil)))
  (glupdatevartype var (cadr rhs))
  (glupdatevarvalue var rhs *glcontext*)
  (list (list (if (eq var '*gl*) 'setf 'setq) var (car rhs))
        (cadr rhs)) )


; 28-Jan-89; 29 May 90; 03 Nov 92
(defun gldoview (*glexpr* *glcontext*)
  (let (code view vlist)
    (pop *glexpr*)
    (setq code (gldoexpr nil *glcontext* t))
    (setq view (gldoexpr nil *glcontext* t))
    (cond ((and (quotep (car view))
                (symbolp (cadar view)))
            (or (setq vlist (glfindview (cadr code) (cadar view)))
                (glerror 'gldoview
                         "Cannot find view  ~A  for type  ~A "
                         (cadar view)
                         (cadr code))))
           ((quotep (car view))
             (setq vlist (cadar view)))
           (t (glerror 'gldoview "Cannot find view  ~A  for type  ~A "
                       view (cadr code))))
    (if (symbolp vlist)
        (list (car code) vlist)
        (list (list 'glbinding (cons 'self code))
              (list 'viewer (list (list 'self (cadr code)))
                            (list (list 'out (car vlist)))
                            (cdr vlist))) ) ))


; 4-MAY-82; 02 Jan 95; 03 Jan 95; 07 Jan 00
(defun gldowhile (*glexpr* *glcontext*)
  (prog (actions tmp newcontext)
    (setq newcontext (push nil *glcontext*))
    (gladdfact (list 'label nil) newcontext)
    (pop *glexpr*)
    (setq actions (list (car (glpredicate nil newcontext nil t))))
    (if (eq (car *glexpr*) 'do)
        (pop *glexpr*))
 a  (cond ((and *glexpr* (setq tmp (gldoexpr nil newcontext t)))
            (setq actions (nconc1 actions (car tmp)))
            (go a))
          (*glexpr* (glerror 'gldowhile "Bad stuff in While statement:  ~A " 
                               *glexpr*)
                    (pop *glexpr*)
                    (go a)))
    (return (list (cons 'while actions) nil)) ))


; edited: 23-DEC-82; 24 Jan 90; 17 Mar 94; 11 Nov 94; 11 Aug 95; 26 Feb 02
; 02 Mar 05
; Produce code to test the two sides for equality. 
(defun glequalfn (lhs rhs)
  (let (lhstp rhstp)
    (or (gldomsg lhs '== (list rhs))
        (gluserstrop lhs '== rhs)
        (progn
          (if (glvvct lhs) (setq lhs (glmaterialize lhs nil nil)))
          (if (glvvct rhs) (setq rhs (glmaterialize rhs nil nil)))
          (setq lhstp (glxtrtypec (cadr lhs)))
          (setq rhstp (glxtrtypec (cadr rhs)))
          (list (cond ((null (car rhs))
                        (list 'null (car lhs)))
                      ((null (car lhs))
                        (list 'null (car rhs)))
                      (t (glgencode
                           (list (cond ((and (eq lhstp 'integer)
                                             (eq rhstp 'integer))
                                         '=)
                                       ((or (eq lhstp 'integer)
                                            (eq rhstp 'integer))
                                         'eql)
                                       ((or (glatomtypep lhstp)
                                            (glatomtypep rhstp)
                                            (eq lhstp 'boolean)
                                            (eq rhstp 'boolean))
                                         'eq)
                                       ((and (eq lhstp 'string)
                                             (eq rhstp 'string))
                                         'string=)
                                       ((or (glpointerp lhstp)
                                            (glpointerp rhstp))
                                         'eql)
                                       (t 'equal))
                                 (car lhs)
                                 (car rhs)))))
                'boolean) ) ) ))


; 15 Feb 07; 20 Feb 07; 21 Feb 07; 23 Feb 07; 06 Mar 07; 25 Jul 07
; Make a formula to compute a property of an object type based on equations
; result is (expression units)
(defun glequationprop (obj propname)
  (let (eqns vars allnames defined sol nm)
    (when (glstr obj)
      (setq eqns (glallequations obj))
      (setq vars (glvarsin (cons 'foo eqns)))
      (if (and eqns vars)
          (setq allnames (union (gldatanames obj)
                                (glpropnametypesb obj 'prop)
                                :test #'(lambda (x y) (eq (car x) (car y))))))
      (when (member propname vars)
        (setq defined (mapcar #'(lambda (nt)
                                  (setq nm (glgensym (car nt)))
                                  (list (car nt)
                                        (if (and (consp (cadr nt))
                                                 (eq (caadr nt) 'units))
                                            (list nm (caddr (cadr nt)))
                                            nm)))
                              allnames))
        (setq sol (solvobjvar eqns propname defined nil t)))
      (if sol
          (sublis (mapcar #'(lambda (x)
                              (cons (if (consp (cadr x))
                                        (caadr x)
                                        (cadr x))
                                    (car x)))
                          defined)
                  sol)) )))

; 13 Jan 11; 14 Jan 11
; version of glequationprop for virtual
(defun glequationpropv (binding vtype propname)
  (let (obj eqns vars allnames defined sol tmp)
    (setq obj (cadar (third vtype)))     ; virtual type
    (when (glstr obj)
      (setq eqns (glallequations obj))
      (setq vars (glvarsin (cons 'foo eqns)))
      (if (and eqns vars)
          (setq allnames (if (fourth vtype)
                             (mapcar #'car (fourth vtype))
                             (glpropnames obj 'prop)) ) )              
      (when (member propname vars)
        (setq defined (mapcar #'(lambda (x) (list x (glgensym x)))
                              allnames))
        (setq sol (solvobjvar eqns propname defined nil t)) )
      (if sol
          (sublis (mapcar #'(lambda (x)
                              (if (setq tmp (assoc (car x) (fourth vtype)))
                                  (cons (cadr x)
                                        (if (and (consp (cadr tmp))
                                                 (symbolp (caadr tmp))
                                                 (null (cdadr tmp)))
                                            (caadr tmp)
                                            (cadr tmp)))
                                  (cons (cadr x)
                                        (car (glvalue binding (car x)
                                                      vtype nil)))))
                          defined)
                  sol)) ) ))

; edited: 23-SEP-82; 23 Mar 90
(defmacro glerr (&rest errexp) `(glerr-expr ',errexp))
(defun glerr-expr (errexp)
  (error "Execution of GLISP error expression: ~A~%" errexp))


; 18 Feb 03
; Evaluate args of a function call if constant
(defun glevalargs (codetype context)
  (if (and (consp codetype)
           (consp (car codetype))
           (not (macro-function (caar codetype)))
           (not (eq (caar codetype) 'setq)))
      (cons (cons (caar codetype)
                  (mapcar #'(lambda (x)
                              (car (glevalcodeb (list x nil) context)))
                          (cdar codetype)))
            (cdr codetype))
      codetype))


; 30 Dec 94; 03 Jan 95; 07 June 95; 17 May 96; 26 May 98; 28 Dec 00; 22 Oct 02
; Evaluate a compile-time expression if possible, replacing the code portion
; of a code-type pair with the value.
(defun glevalcode (codetype context)
  (let (var val (code (car codetype)))
    (if (and (setq var (if (symbolp code)
                           code
                           (if (and (consp code)
                                    (eq (car code) 'prog1)
                                    (symbolp (cadr code)))
                               (cadr code))))
             (setq val (glcontextval var context)))
        (cons (caddr val) (cdr codetype))
        (if (and (consp code)

                 (cdr code)              ; don't eval function of no args
                 (or (member (car code) '(known true false))
                     (every #'glconstantp (cdr code)))
                 (or (not (glargsnumberp (car code)))
                     (every #'numberp (cdr code)))
                ;  (or (format t "glevalcode: would eval ~a~%" code) t)
                 (gloktoeval (car code)))
            (list (kwote (if (member (car code) '(known true false))
                             (case (car code)
                               (known (glknown (cadr code)))
                               (true t)
                               (false nil))
                             (eval code)))
                  (cadr codetype))
            codetype) ) ))


; 20 Nov 02
; This version of glevalcode does not replace a var with a value of nil.
; This avoids problems temporarily.
(defun glevalcodeb (codetype context)
  (let ((val (glevalcode codetype context)))
    (if (and (consp val) (null (car val))
             (symbolp (car codetype)))
        codetype
        val) ))
    

; edited: 15 Feb 89
(defun glevalifconst (codetype)
  (let ((code (car codetype)) tmp)
    (if (glconstantp code)
        (list (kwote (setq tmp (glconstval code)))
              (or (cadr codetype)
                  (glconstanttype tmp)))
        codetype)))


; 29 Dec 94; 03 Jan 95
; Evaluate a predicate at compile time if possible
(defun glevalpred (p context)
  (let (tmp)
    (if (consp p)
        (case (first p)
          (glclassmemp (if (and (symbolp (cadr p))
                                (quotep (caddr p))
                                (setq tmp (glcodetype (cadr p) context))
                                (equal (cadr tmp) (cadr (caddr p))))
                           t p))
          ((null not) (setq tmp (glevalpred (second p) context))
                      (if (constantp tmp)
                          (not tmp)
                          p))
          (t p))
        (if (symbolp p)
            (if (setq tmp (glcontextnull p context))
                (caddr tmp)
                p)
            p) ) ))

; 17 Mar 89; 23 Mar 90
; Look through a structure to see if it involves evaluating other 
;   structures to produce a concrete type. 
(defun glevalstr (str *glcontext*)
  (let (glevalsubs)
    (if (setq glevalsubs (glevalstrb str nil))
        (sublis glevalsubs str :test #'equal)
        str)))


; 17 Mar 89; 23 Mar 90; 28 Mar 90; 13 Apr 90; 17 May 90; 18 May 90
; 21 May 90; 23 May 90; 24 May 90; 07 Feb 91; 12 Feb 91; 18 Jan 96
; 12 Nov 96; 14 Nov 96; 28 Dec 00
; Find places where substructures need to be evaluated and collect 
; substitutions for them. 
(defun glevalstrb (str subs)
  (let (tmp *glexpr* ptr res)
    (if (consp str)
        (cond ((assoc str subs :test #'equal))
              ((eq (car str) 'typeof)
                (setq *glexpr* (cdr str))
                (setq tmp (gldoexpr nil *glcontext* t))
                (if (cadr tmp)
                    (push (cons str (cadr tmp)) subs)
                    (glevalstrerr str)))
              ((eq (car str) 'eval)
                (setq *glexpr* (cdr str))
                (setq tmp (gldoexpr nil *glcontext* t))
                (if (and (car tmp) (eq (cadr tmp) 'gltype))
                    (push (cons str (car tmp)) subs)
                    (glevalstrerr str)))
              ((eq (car str) 'clustertype)
                (setq *glexpr* (cdr str))
                (setq tmp (gldoexpr nil *glcontext* t))
                (if (eq (cadr tmp) 'gltype)
                    (push (cons str 
                                (if (and (quotep (car tmp))
                                         (quotep (caddr str)))
                                    (clustertype (cadar tmp)
                                                 (cadr (caddr str)))))
                          subs)
                    (glevalstrerr str)))
              ((eq (car str) 'strof)
                (if (and (setq tmp (glevalstr (cadr str) *glcontext*))
                         (setq res (glxtrtypec tmp)))
                    (push (cons str res) subs)
                    (glevalstrerr str)))
              ((eq (car str) '^.)
                (if (and (setq tmp (glevalstr (cadr str) *glcontext*))
                         (setq ptr (glpointsto tmp)))
                    (push (cons str ptr) subs)
                    (glevalstrerr str)))
              ((eq (car str) '^)
                (if (symbolp (cadr str))
                    (push (cons str (glget-or-make-pointer (cadr str))) subs)
                    (glevalstrerr str)))
              (t (dolist (x (cdr str))
                         (setq subs (glevalstrb x subs))))))
    subs))

; 11 Mar 92
; Evaluate a structure.  However, if the top of the structure is (^. ...),
; it is left for lazy dereferencing.
(defun glevalstrc (str *glcontext*)
  (if (and (consp str)
           (eq (car str) '^.))
      (list '^. (glevalstr (cadr str) *glcontext*))
      (glevalstr str *glcontext*)) )

; 17 May 90
; Do we need this error message?  Commented out.
(defun glevalstrerr (str)         (declare (ignore str))
;  (glerror 'glevalstrb (list "The cluster type ~A was not found." str))
 )

; 03 Oct 89; 03 Jan 92; 29 Jan 92; 23 Apr 98; 08 Oct 02
; Evaluate a structure expression.  An expression can be:
; The name of a defined type.
; (TYPEOF <variable>)     (CLUSTERTYPE <role> <exp>)     (OR <exp> ... <exp>)
(defun glevaltype (exp)
  (let ()
    (if (symbolp exp)
        (if (glstr exp) exp)
        (if (consp exp)
            (case (car exp)
                  (typeof (glgettypeof exp))
                  (clustertype (glevalstr exp *glcontext*))
                  (or (some #'glevaltype (cdr exp)))
                  (eval (glevaltypeexp exp))
                  (t (glevaltypeb exp)) ) ) ) ))

; 23 Apr 98
; Evaluate an expression to get a type
(defun glevaltypeb (exp)
  (let (tmp)
    (if (and (setq tmp (glpushexpr (list exp) nil *glcontext* t))
             (quotep (car tmp))
             (or (member (cadr tmp) '(gltype symbol))
                 (glokstr? (cadar tmp))))
        (cadar tmp)
        (glerror 'glevaltypeb
                 "The type ~A could not be evaluated." exp ) ) ))

; 29 Jan 92; 15 Oct 92; 16 Oct 92; 05 Jun 03
; Evaluate an expression to get a type, as in (EVAL (VIEWTYPE <arg>)).
(defun glevaltypeexp (exp)
  (let (tmp)
    (if (and (setq tmp (glpushexpr (cdr exp) nil *glcontext* t))
             (or (member (cadr tmp) '(gltype symbol))
                 (and (quotep (car tmp))
                      (glokstr? (cadar tmp)))))
        (cadar tmp)
        (glerror 'glevaltypeexp
                 "The type ~A could not be evaluated." (cadr exp) ) ) ))


; edited: 17-Sep-88 14:26; 04 Jan 05; 12 Jan 09
; If a PROGN occurs within a PROGN, expand it by splicing its contents 
;   into the top-level list. 
(defun glexpandprogn (lst busy progwd)
  (mapcon #'(lambda (x)
            (let ((busyflg (and busy (case progwd
                                           (prog1 (eq x lst))
                                           ((progn let let*) (null (cdr x)))
                                           (prog2 (eq x (cdr lst)))
                                           ((prog while) nil)
                                           (t (error "NOMSG"))))))
                 (glexpandprognitem (if (and (symbolp (car x))
                                             (eq progwd 'prog))
                                        (car x)
                                        (glunwrap (car x)
                                                  busyflg))
                                    busyflg progwd)))
        lst))


; edited: 17-Sep-88 15:22 
; Expand a PROGN item by splicing its contents into the top-level list 
;   when appropriate. Returns a list of the result. 
(defun glexpandprognitem (item busy progwd)
(cond ((atom item)
       
; eliminate non-busy atomic items. 

       (if (or (and item (eq progwd 'prog))
               busy)
           (list item)))
      ((or (eq (car item)
               'progn)
           (and (eq (car item)
                    'prog2)
                (null (cdddr item))))
       
; expand contained progns in-line. 

       (glexpandprogn (cdr item)
                      busy
                      'progn))
      ((and (eq (car item) 'prog)
            (null (cadr item))
            (every #'(lambda (y) (consp y))
                   (cddr item))
            (not (gloccurs 'return (cddr item))))
       
; expand contained simple progs. 

       (glexpandprogn (cddr item)
                      nil
                      'progn))
      (t (list item))))


; edited:  9-JUN-82
; Test if *GLEXPR* is expensive to compute. 
(defun glexpensive? (*glexpr*)
  (cond ((atom *glexpr*) nil)
        ((member (car *glexpr*)
                 '(cdr cddr cdddr cddddr car caar cadr caadr caddr cadddr))
          (glexpensive? (cadr *glexpr*)))
        ((and (eq (car *glexpr*) 'prog1)
              (null (cddr *glexpr*)))
          (glexpensive? (cadr *glexpr*)))
        (t t)))


; 30 Nov 92
; Compute result for expt
(defun glexptfn (args)
  (let (unittp unit (newunit 1) power)
    (if (and (glunittypep (setq unittp (cadr (first args))))
             (integerp (setq power (car (second args)))))
        (progn (setq unit (third unittp))
               (if (minusp power)
                   (progn (setq unit (glinvertunit unit))
                          (setq power (- power))))
               (while (> power 0)
                 (setq newunit (glmultunits newunit unit))
                 (decf power))
               (list (list 'expt (caar args) (caadr args))
                     (list 'units (cadr unittp) newunit)))
        (list (cons 'expt (mapcar #'car args))
              (glnumresulttypefn 'expt (mapcar #'cadr args))))  ))

; 27 Mar 08
; extract a type from a 'virtual' type
(defun glextractvirttype (type)
  (if (and (consp type)
           (eq (car type) 'virtual)
           (gltypep (cadr type)))
      (cadr type)
      type) )

; 27 May 93; 05 Aug 93
; Find a "collection" type from a given type.
(defun glfindcollection (type)
  (let ()
    (if type
        (if (consp type)
            (if (member (car type) '(listof arrayof))
                type)
            (if (symbolp type)
                (if (gldescendantp type 'linked-list-pointer)
                    type
                    (glfindcollection (glxtrtype (glgetstr type))))))) ))

; 20 Sep 06
; See if it is possible to find a field of a crecord in code to make one
(defun glfindmakefield (qtype qfield how)
  (and (consp qfield)
       (eq (car qfield) 'quote)
       (symbolp (cadr qfield))
       (consp how)
       (or (and (eq (car how) 'list)
                (some #'(lambda (group)
                          (and (consp group) (eq (car group) 'cons)
                               (equal (cadr group) qfield)))
                      (cdr how)))
           (and (eq (car how) 'copy-tree)
                (consp (cadr how)) (eq (caadr how) 'quote)
                (some #'(lambda (group)
                          (and (consp group)
                               (eq (car group) (cadr qfield))))
                      (cadadr how)))) ) )

; 28 Dec 98
; find a setq of a var in a list of code statements.
(defun glfindsetq (var code)
  (and (consp code)
       (consp (car code))
       (or (and (eq (caar code) 'setq)
                (eq (cadar code) var)
                code)
           (glfindsetq var (cdr code)))))

; 04 May 90
; Find variables referenced (read) in an expression
(defun glfindvars (exp)
  (if (atom exp)
      (if (and (symbolp exp)
               (not (constantp exp)))
          (list exp))
      (glfindvarsb exp)))


; 01 Jun 90
(defun glfindvarsb (exp)
  (case (car exp)
    (setq (glfindvars (caddr exp)))
    (setf (if (symbolp (cadr exp))
              (glfindvars (caddr exp))
              (glfindvarsl (cdr exp) nil)))
    ((let prog) (glfindvarslet exp))
    (quote nil)
    (t (glfindvarsl (cdr exp) nil)) ) )


(defun glfindvarsl (exp vars)
  (if exp
      (glfindvarsl (rest exp) (union vars (glfindvars (first exp))))
      vars))


(defun glfindvarslet (exp)
  (let (letvars)
    (dolist (letvar (cadr exp))
      (if (consp letvar)
          (setq letvars (union letvars (glfindvars (cadr letvar))))))
    (glfindvarsl (cddr exp) letvars) ))


; 28-Jan-89; 29 May 90; 20 Nov 90; 30 Nov 90; 29 Mar 91; 21 Oct 92
; 16 Dec 93; 20 Oct 94; 16 May 95
(defun glfindview (type viewname)
  (let (tmp tmpb)
    (or (glfindviewb type viewname)
        (if (and (get viewname 'equations)
                 (get viewname 'basis-vars))
            (if (and (makev-get-view-choices type viewname)
                     (remakeview type viewname))
                (glfindviewb type viewname))
            (and (setq tmp (glgetviewspecs type viewname nil))
                 (setq tmpb (glviewas (or (cadr tmp) viewname)
                                      type nil viewname))
                 (glclmaintype tmpb) ) )
        (some #'(lambda (x) (glfindview x viewname))
              (glsupers type)) ) ))

; 20 Oct 94; 11 Nov 94
(defun glfindviewb (type viewname)
  (let (views tmp)
    (setq views (glget type 'views))
    (setq tmp (or (assoc viewname views)
                  (find viewname views :key #'cadr)))
    (if (consp tmp)
        (if (and (consp (cdr tmp))
                 (symbolp (cadr tmp))
                 (null (cddr tmp))
                 (glcluster (cadr tmp)))
            (cadr tmp)
            (if (and (consp (cdr tmp))
                     (consp (cddr tmp))
                     (symbolp (caddr tmp))
                     (null (cdddr tmp)) )
                (cddr tmp)
                (cdr tmp))) ) ))

; 13 Nov 09
; Fix multiplied or divided units.  op must be * or /
(defun glfixmulunits (op expr numtp lhstp rhstp)
  (let (newunit un )
    (setq newunit (if (eq op '*)
                      (glmultunits lhstp rhstp)
                      (gldivunits lhstp rhstp)))
    (setq un (glsimplifyunit newunit))
    (if (numberp un)
        (list (list '* un expr) (list 'units numtp 'unity))
        (if (and (consp un)
                 (eq (car un) '*)
                 (numberp (cadr un)))
            (list (list '* (cadr un) expr)
                  (list 'units numtp (caddr un)))
            (if (and (consp un)
                     (eq (car un) '/)
                     (numberp (cadr un)))
                (list (list '* (cadr un) expr)
                      (list 'units numtp (list '/ 1 (caddr un))))
                (list expr (list 'units numtp un))))) ))


; 24-Sep-88; 04 June 90; 17 Oct 91; 06 Mar 00
; Check declared result type against compiled result type, remove any
; type "wrappers".
(defun glfixresulttype (declaredtype actualtype)
  (let (type conv)
    (setq type (or declaredtype actualtype))
    (if (and (glunittypep declaredtype)
             (glunittypep actualtype)
             (not (and (setq conv (glconvertunit (caddr declaredtype)
                                                 (caddr actualtype)))
                       (< (abs (- conv 1.0)) 1.0e-6))))
        (glerror 'glfixresulttype
                 "Warning: Declared type ~A differs from result ~A"
                 declaredtype actualtype))
    (if (and (consp type) (member (car type) '(transparent virtual)))
        (cadr type)
        (glxtrtype type)) ))


; 28 Jan 97
; Eliminate a float if the arg is already a float
(defun glfloatfn (arg)
  (let (unittp)
    (if (or (eq (cadr arg) 'real)
            (and (glunittypep (setq unittp (cadr arg)))
                 (eq (cadr unittp) 'real)))
        arg
        (list (list 'float (car arg))
              (if (glunittypep unittp)
                  (cons (car unittp) (cons 'real (cddr unittp)))
                  'real)) ) ))

; 29 Sep 93
; Compute result type for float
(defun glfloatresulttypefn (fn argtypes)     (declare (ignore fn))
  (let (unittp)
    (if (glunittypep (setq unittp (first argtypes)))
        (list 'units 'real (third unittp))
        'real) ))

; 23 Dec 98; 30 Dec 98
; Process a funcall of a lambda form by changing it to a let,
; thus allowing partial evaluation.
(defun glfuncalllambda (lambdafn args)
  (let (varlist letlist newcode)
    (unless (equal (length (cadr lambdafn)) (length args))
      (glerror 'glfuncalllambda "arg list mismatch ~A ~A" lambdafn args))
    (setq varlist (mapcar #'(lambda (var codetype) (list var (cadr codetype)))
                          (cadr lambdafn) args))
    (setq letlist (mapcar #'(lambda (var codetype) (list var (car codetype)))
                          (cadr lambdafn) args))
    (setq newcode (glcompexpr (cons 'progn (cddr lambdafn)) varlist))
    (list (list 'let letlist (car newcode)) (cadr newcode)) ))

; edited: 22-Aug-86
; Generate code of the form X. The code generated by the compiler is 
;   transformed, if necessary, for the output dialect. 
(defun glgencode (x) (glcommonlisptransfm x))


; 15 Jan 10
; test whether type is a generic, i.e. has no specific storage structure
(defun glgenericstrp (type)
  (let (str)
      (setq str (glxtrtypeb type))
      (or (eq str 'anything)
          (and (consp str)
               (eq (car str) 'tuple)) ) ))


; edited:  4-Oct-88; 06 Apr 90
; Generate LET/PROG code when required. VARVALS is a list of 
;   variable-value pairs. CODELST is a list of expressions, the last 
;   of which is the value to be returned. 
(defun glgenlet (varvals codelst)
  (if (and (consp (car varvals))
           (null (cdr varvals))
           (< (glnoccurs (caar varvals) codelst) 2))
      (glgenprogn (subst (cadar varvals)
                         (caar varvals)
                         codelst))
      (cons 'let (cons varvals codelst))))


; edited:  4-Oct-88
; Generate a PROGN if needed. 
(defun glgenprogn (codelst)
  (if (cdr codelst)
      (cons 'progn codelst)
      (car codelst)))

; 12 Oct 00; 14 Sep 06
; version of gensym that interns the symbol.  Arg is symbol or string.
(defun glgensym (sym)
  (let (newsym pkg)
    (incf *glgensymnumber*)
    (multiple-value-setq (newsym pkg)
      (intern (concatenate 'string (stringify sym)
                                   (princ-to-string *glgensymnumber*))))
    (if pkg (glgensym sym) newsym)))

; edited: 20-Mar-81; 13 Dec 89
; Get the value for the entry KEY from the a-list ALST. GETASSOC is 
; used so that the corresponding PUTASSOC can be generated by GLPUTFN. 
(defun glgetassoc (key alst) (cdr (assoc key alst)))


; 30-AUG-82; 21 Feb 95; 14 Mar 95
(defun glgetconstdef (sym)
  (let (val)
    (if (glispconstantflg sym)
        (list (kwote (glispconstantval sym))
              (glispconstanttype sym))
        (if (and (constantp sym)
                 (constantp (setq val (eval sym))))
            (list val (glconstanttype val)))) ))

; 13 Dec 89
(defun glgetdefault (type name)
  (or (assoc name (gldefaults type))
      (some #'(lambda (s) (glgetdefault s name)) (glsupers type))))


; 24-Jan-89; 13 Dec 89; 03 Nov 92
(defun glgetdefaults (type pairs)
  (dolist (l (gldefaults type))
    (unless (assoc (car l) pairs)
            (push (list (car l)
                        (copy-tree (cadr l))
                        (or (caddr l)
                            (and (quotep (cadr l))
                                 (glconstanttype (cadadr l)))
                            (and (symbolp (cadr l))
                                 (glconstantp (cadr l))
                                 (glconstanttype (cadr l)))))
                  pairs)))
  (dolist (s (glsupers type)) (setq pairs (glgetdefaults s pairs)))
  pairs)


; 5-Aug-87; 21 Dec 94; 22 Dec 94; 23 Dec 94; 28 Dec 94; 06 June 95
; Find a way to retrieve the FIELD from the structure pointed to by 
; SOURCE (which may be a variable name, NIL, or a list (CODE DESCR)) 
; relative to CONTEXT.
; The result is a list of code to get the field and the type of the result. 
(defun glgetfield (source field *glcontext*)
  (let (tmp)
    (if source
        (if (symbolp source)
            (cond ((setq tmp (glcodetype source *glcontext*))
                    (or (glvalue (car tmp) field (cadr tmp) nil)
                        (glerror 'glgetfield
                             "Property ~A cannot be found for ~A of type ~A "
                             field source (cadr tmp))))
                  ((setq tmp (glgetfield nil source *glcontext*))
                    (glgetfield tmp field *glcontext*))
                  ((setq tmp (glgetglobaldef source))
                    (glgetfield tmp field nil))
                  ((setq tmp (glgetconstdef source))
                    (glgetfield tmp field nil))
                  (t (glerror 'glgetfield "The name ~A cannot be found." 
                                          source)))
            (or (and (consp source)
                     (glvalue (car source) field (cadr source) nil))
                (glerror 'glgetfield
                         "Property ~A cannot be found for ~A"
                         field source) ) )
; no source is specified. look for a source in the context. 
      (some #'(lambda (ctxlist)
                (some #'(lambda (ctxentry)
                          (if (and (eq (car ctxentry) 'alias)
                                   (eq field (cadr ctxentry)))
                              (cddr ctxentry)
                              (if (eq (car ctxentry) 'alias)
                                  (glvalue (caddr ctxentry) field
                                           (cadddr ctxentry) nil)
                                  (if (eq (car ctxentry) 'type)
                                      (glvalue
                                        (car (glevalcode
                                                (list (cadr ctxentry)
                                                      (caddr ctxentry))
                                                *glcontext*))
                                        field (caddr ctxentry) nil)))))
                      ctxlist))
                 *glcontext*) ) ))


; 11-May-88
(defun glgetfields (type)
  (nreverse (glgetfieldsb (if (consp type)
                              type
                              (car (glstructure type)))
                          nil)))

; 27 Sep 89; 12 Feb 91; 11 Dec 91; 09 Apr 92; 13 Oct 92; 23 Dec 93
(defun glgetfieldsb (lst prev)
  (cond ((atom lst) prev)
        ((member (car lst) *gltypenames*)
          (case (car lst)
            ((cons list alist object listobject atomobject tuple proplist)
              (dolist (x (cdr lst))
                      (setq prev (glgetfieldsb x prev)))
              prev)
            ((record crecord)
              (dolist (x (cddr lst))
                      (setq prev (glgetfieldsb x prev)))
              prev)
            ((listof units) prev)
            ((atom symbol) (if (and (consp (cadr lst))
                                    (eq (caadr lst) 'proplist))
                               (dolist (x (cdadr lst))
                                 (setq prev (glgetfieldsb x prev))))
              prev)
            (t (error "NOMSG"))))
        ((member (car lst) '(^)) prev)
        (t (glgetfieldsb (cadr lst) (cons (car lst) prev)))))


; edited: 22-Aug-86
; Call the appropriate function to compile code to get the indicator 
;   (QUOTE IND') from the item whose description is DES, where DES 
;   describes a unit in a unit package whose record is UNITREC. 
(defun glgetfromunit (unitrec ind des)
  (let (tmp)
    (if (setq tmp (assoc 'get (caddr unitrec)))
        (funcall (cdr tmp) ind des))))


; edited: 23-APR-82
(defun glgetglobaldef (atm)
  (if (glispglobalvar atm)
      (list atm (glispglobalvartype atm))))


; 20 Sep 06
; Extract code for a field of a crecord in code to make one
(defun glgetmakefield (qtype qfield how)
  (let (find)
    (and (consp qfield)
         (eq (car qfield) 'quote)
         (symbolp (cadr qfield))
         (consp how)
         (or (and (eq (car how) 'list)
                  (some #'(lambda (group)
                            (and (consp group) (eq (car group) 'cons)
                                 (equal (cadr group) qfield)
                                 (setq find group)))
                        (cdr how))
                  (caddr find))
             (and (eq (car how) 'copy-tree)
                  (consp (cadr how)) (eq (caadr how) 'quote)
                  (some #'(lambda (group)
                            (and (consp group)
                                 (eq (car group) (cadr qfield))
                                 (setq find group)))
                        (cadadr how))
                  (kwote (cdr find))))) ))


; edited: 25-JUL-83; 09 Oct 90; 28 Dec 94
; Get pairs of <field> = <value>, where the = and , are optional.
; Value is a list of triples, (<field> <code> <type>) .
(defun glgetpairs (*glexpr*)
  (prog (prop val pairlist)
 a  (cond ((null *glexpr*)
            (return (nreverse pairlist)))
          ((not (symbolp (setq prop (pop *glexpr*))))
            (glerror 'glgetpairs " ~A  is not a legal property name." prop))
          ((eq prop '\,) (go a)))
    (if (member (car *glexpr*) '(= \:=))
        (pop *glexpr*))
    (setq val (gldoexprc nil *glcontext* t))
    (push (cons prop val) pairlist)
    (go a)))


; 13 Apr 90; 21 May 90; 24 May 90; 11 Jun 90; 18 Jan 96
; Get the pointer type associated with a given type
(defun glgetpointer (type)
  (or (glpointer type)
      (glclusterrole (glcluster type) 'pointer)))
      

; 24 May 90
(defun glget-or-make-pointer (type)
  (or (glgetpointer type)
      (glmakepointer type)) )


; edited: 23-DEC-81
(defun glgetstr (des)
  (let (type tmp)
    (and (setq type (glxtrtype des))
         (symbolp type)
         (setq tmp (glstr type))
         (car tmp))))


; edited: 9-FEB-83; 04 Apr 91; 17 Feb 94
; Get the type of an expression, as in (TYPEOF <code>).
(defun glgettypeof (exp)
  (let (tmp type view)
    (when (setq tmp (glpushexpr (cdr exp) nil *glcontext* t))
      (setq type (cadr tmp))
      (if (and (consp type)
               (eq (car type) 'viewer)
               (glviewtypep (setq view (cadar (caddr type)))))
          view
          type) ) ))
          

; 15 Dec 93; 16 Dec 93; 19 May 94
; Get view specifications if they are defined.  A view spec is:
; (<name> <cluster> (<param> <choices> ...) ...)
(defun glgetviewspecs (type viewname goal-cluster)
  (let (vc)
    (if (setq vc (glviewspecs type))
        (if viewname
            (assoc viewname vc)
            (find goal-cluster vc :key #'cadr))
        (some #'(lambda (super) (glgetviewspecs super viewname goal-cluster))
              (glsupers type)) ) ))


; 21-MAY-82; 25 Feb 92; 21 Dec 94; 22 Dec 94; 27 Dec 94; 31 May 95; 28 Dec 10
; 25 Mar 11
; Identify a name either as a variable name or as an implicit field reference.
; ***** Mods made 28 Dec 10 in glidname caused other problems in stuff that
; used to work.  Don't recall why this modification was made.  In some cases
; (cvhb-test in cvhe.lsp) this mod resulted in a binding (self self ...)
; where the binding to an actual variable was lost.  The fix
; made 25 Mar 11 is also problematic because its test is probably never
; false, therefore it probably just undoes the earlier fix.
(defun glidname (name defaultflg)
  (let (tmp)
    (if (atom name)
        (cond ((null name)
                (list nil nil))
              ((symbolp name)
                (cond ((eq name t)
                        (list name 'boolean))
                      ((setq tmp (glcodetype name *glcontext*))
                        (if (and (consp (cadr tmp))          ; 28 Dec 10
                                 (eq (caadr tmp) 'viewer))
                            (list
                              (if (and (consp (car tmp)) ; is this ever false?
                                       (eq (caar tmp) 'glbinding))
                                  (car tmp)  ; 25 Mar 11
                                             ; use binding if already have one
                                  (cons 'glbinding
                                        (mapcar
                                         #'(lambda (codetype)
                                             (cons (car codetype) codetype))
                                         (cadr (cadr tmp)))))
                              (cadr tmp))
                            (glrepvalue tmp) ) )
                      ((glgetfield nil name *glcontext*))
                      ((setq tmp (glidtype name *glcontext*))
                        (glrepvalue (list (car tmp) (cadr tmp))))
                      ((glgetconstdef name))
                      ((glgetglobaldef name))
                      (t (if (or (not defaultflg)
                                 *glcautiousflg*)
                             (glerror 'glidname
                        "The name  ~A  cannot be found in this context."
                                            name))
                         (list name nil))))
               ((integerp name) (list name 'integer))
               ((floatp name) (list name 'real))
               (t (glerror 'glidname " ~A  is an illegal name." name)))
        name)))


; 27-MAY-82; 22 Dec 94; 23 Dec 94; 28 Dec 94
; Try to identify a name by either its referenced name or its type. 
(defun glidtype (name context)
  (let ()
    (and context
         (or (some #'(lambda (ctxentry)
                       (or (and (eq (first ctxentry) 'type)
                                (eq (third ctxentry) name)
                                (cdr ctxentry))
                           (and (eq (first ctxentry) 'alias)
                                (eq (second ctxentry) name)
                                (cddr ctxentry))
                           (and (eq (first ctxentry) 'alias)
                                (eq (fourth ctxentry) name)
                                (cddr ctxentry))
                           (and (eq (first ctxentry) 'alias)
                                (consp (third ctxentry))
                                (gl-a-an? (car (third ctxentry)))
                                (eq name (cadr (third ctxentry)))
                                (cddr ctxentry))))
                   (car context))
             (glidtype name (rest context)))) ))


; 12-Jun-87; 20 Nov 89; 29 Dec 89; 06 Apr 90; 23 Aug 90; 18 Sep 90
; 05 Oct 90; 15 Mar 91; 07 May 91; 01 Oct 91; 23 Jan 92; 25 Feb 92
; 29 Sep 92; 18 Oct 92; 21 Oct 92; 12 Nov 92; 19 Nov 92; 30 Nov 92
; 17 Dec 92; 08 Apr 93; 10 May 93; 11 Oct 93; 18 Oct 93; 19 Oct 93
; 16 Nov 93; 17 Nov 93; 24 Dec 93; 27 Dec 93; 21 Dec 94; 01 Jun 95
; 08 Aug 95; 26 Oct 95; 11 Jan 96; 13 Feb 96; 23 Apr 96; 10 Oct 96
; 28 May 98; 30 Jul 98; 18 Mar 99; 01 Apr 99; 26 Feb 02; 22 Oct 02
; 24 Oct 02; 24 May 04; 11 Aug 04; 23 Sep 04; 30 Jun 06; 20 Sep 06
; 26 Apr 07; 12 Nov 09
; Initialize things for GLISP 
(defun glinit nil
  (prog nil
    (setq *glnosplitatoms* nil)
    (setq *glsepbittbl*
          (makebittable '(\: _ + - \' = \~ < > * / \, ^)))
    (setq *glunitpkgs* nil)
    (setq *glsepminus* nil)
    (setq *glquietflg* nil)
    (setq *glsepatom* nil)
    (setq *glsepptr* 0)
    (setq *glnatom* 0)
    (setq *glnrecursions* 0)
    (setq *glbreakonerror* nil)
    (setq *gluserstrnames* nil)
    (setq *gltypesused* nil)
    (setq *gllastfncompiled* nil)
    (setq *gllaststredited* nil)
    (setq *glcautiousflg* nil)
    (setq *glglsendflg* nil)
    (setq *glprogresulttype* nil)
    (glpatinit)
; Functions to evaluate at compile time when their args are constants:
    (dolist (x '(and or not member assoc max min abs coerce float
                    mod rem floor truncate floor ceiling round gcd
                    expt log exp sin cos tan prog1
                    atan asin acos boole ash + * / - 1+ 1- sqrt cbrt
                    car cdr caar cadr cdar cddr caaar caadr cadar
                    caddr cdaar cdadr cddar cdddr
                    caaaar caaadr caadar caaddr cadaar cadadr caddar cadddr
                    cdaaar cdaadr cdadar cdaddr cddaar cddadr cdddar cddddr
                    first second third fourth fifth sixth seventh eighth
                    ninth tenth glgetfields rest char-int int-char get
                    glbitmask logand logior logxor leftshift rightshift ash
                    eq eql equal = <= >= < > /= null consp integerp stringp
                    floatp known true false glbasictypep glxtrtypeb glxtrtypec
                    glpropdef glbasictypexp getf glgetassoc
                    ))
              (setf (glevalwhenconst x) t))
; Predicates
    (dolist (x '(eq eql not equal equalp zerop null numberp integerp
                 characterp stringp listp rationalp complexp
                 bit-vector-p vectorp simple-vector-p simple-string-p
                 simple-bit-vector-p functionp compiled-function-p commonp
                 floatp atom symbolp consp arrayp plusp minusp oddp evenp
                 < > <= >= = /= boundp fboundp known))
      (setf (glpure x) t)
      (setf (glfnresulttype x) 'boolean) )
; Functions that have no side effects
    (dolist (x '(quote car cdr caar cadr cdar cddr caaar caadr cadar
                       caddr cdaar cdadr cddar cdddr
                       caaaar caaadr caadar caaddr cadaar cadadr caddar cadddr
                       cdaaar cdaadr cdadar cdaddr cddaar cddadr cdddar cddddr
                       first second third fourth
                       fifth sixth seventh eighth ninth tenth rest
                       1+ 1- + - * / min max abs log
                       sin cos tan atan asin acos expt sqrt cbrt get assoc
                       aref not ldb byte cons list truncate round glcfield))
            (setf (glpure x) t))
; Functions whose args must be numbers
    (dolist (x '(> = < >= <= /= + * / - 1+ 1- sqrt cbrt expt
                   plusp minusp oddp max min abs mod rem floor truncate
                   gcd log exp sin cos tan cis atan asin acos boole ash round
                   ))
            (setf (glargsnumberp x) t))
    (dolist (x '(sin cos tan cis))
      (setf (glarguments x) '((x (units real radians)))))
    (dolist (x '(min max))
      (setf (glargssame x) t))
    (gldeffnresulttypes
        '((integer (length floor ceiling truncate round array-total-size
                           1+ 1- mod rem gcd boole ash ldb))
          (real (log exp sin cos tan))
          ((units real radians) (atan asin acos))
          (symbol (gensym glgensym intern))
          (string (symbol-name read-line))
          (character (char code-char)) (ascii (char-code))
          ((listof integer) (array-dimensions))  ))
      (dolist (x '(+ - * / rem mod min max abs))
              (setf (glresulttypefn x) 'glnumresulttypefn))
      (setf (glresulttypefn 'sqrt) 'glsqrtresulttypefn)
      (setf (glresulttypefn 'cbrt) 'glcbrtresulttypefn)
      (setf (glresulttypefn 'float) 'glfloatresulttypefn)
      (dolist (x '(cons list nconc tuple))
              (setf (glresulttypefn x) 'gllistresulttypefn))
      (dolist (x '(nthcdr nth first second third fourth fifth sixth
                          seventh eighth ninth tenth rest assoc))
              (setf (glresulttypefn x) 'glnthresulttypefn))
      (setf (glresulttypefn 'pop)    'glpopresulttypefn)
      (setf (glresulttypefn 'push)   'glpushresulttypefn)
      (setf (glresulttypefn 'and)    'glandorresulttypefn)
      (setf (glresulttypefn 'or)     'glandorresulttypefn)
      (setf (glresulttypefn 'setf)   'glsetfresulttypefn)
      (setf (glresulttypefn 'aref)   'glarefresulttypefn)
      (setf (glresulttypefn 'progn)  'glprognresulttypefn)
      (setf (glresulttypefn 'prog1)  'glprog1resulttypefn)
      (setf (glresulttypefn 'identity)  'glprog1resulttypefn)
      (setf (glresulttypefn 'copy-tree)   'glcopy-treeresulttypefn)
      (setf (glresulttypefn 'copy-list)   'glcopy-treeresulttypefn)
      (setf (glresulttypefn 'copy)   'glcopy-treeresulttypefn)
      (setf (glresulttypefn 'last)   'gllastresulttypefn)
      (setf (glresulttypefn 'make-array)   'glmake-arrayresulttypefn)
      (gldefsysstr
        '((string string
                prop ((length length result integer)
                      (zero  (""))
                      (chars string-chars open t result (listof character))
                      (charcodes string-char-codes open t
                                 result (listof ascii) ) )
                isa  ((string (t)))
                msg  ((+  concat   result string argtypes (string))
                      (+  (glambda (s c) (concat s (string c)))
                                                 argtypes (character))
                      (>  string>  result boolean)
                      (== string=  result boolean)
                      (>= string>= result boolean)
                      (<= string<= result boolean)
                      (<> string/= result boolean)
                      (<  string<  result boolean)))
          (character character
             prop   ((code char-code result ascii))
             msg    ((==   char=  result boolean)
                     (>    char>  result boolean)
                     (>=   char>= result boolean)
                     (<=   char<= result boolean)
                     (<>   char/= result boolean)
                     (<    char<  result boolean)))
          (ascii   integer
             prop ((char code-char result character)
                         (wordsize (8)) )
                   adj  ((nonnegative (gltrue))) )
          (boolean boolean
                   prop ((zero (*glfalse*)) (one (t)))
                   msg ((+ or  result boolean)
                        (* and result boolean)
                        (~ not result boolean)))
          (integer integer
                   prop ((zero (0)) (one (1)))
                   adj ((integer (t)))
                   isa ((integer (t)))
                   supers (number))
          (number number
                  prop ((zero (0)))
                  adj ((numeric (t)))
                  isa ((number (t)))
                  msg ((distance (glambda (self other) (abs (- self other))))
                       (lowpass  (glambda (self other f) (+ (* self (- 1 f))
                                                            (* other f)))) ))
          (symbol symbol
                  prop ((pname symbol-name result string))
                  msg  ((>  symbol>  result boolean)
                        (>= symbol>= result boolean)
                        (<= symbol<= result boolean)
                        (<  symbol<  result boolean)))
          (atom atom
                prop ((pname symbol-name result string))
                  msg  ((>  symbol>  result boolean)
                        (>= symbol>= result boolean)
                        (<= symbol<= result boolean)
                        (<  symbol<  result boolean)))
          (real real
                prop ((zero (0.0))
                      (one (1.0)))
                adj ((real (t)))
                supers (number)) ) )
      (gldefpapatterns
        'glputarithpatterns                  ; for glputarith
        '( ((= (+ ?n ?x) ?val)      (= ?x (- ?val ?n)) (numberp ?n))
           ((= (+ ?x ?n) ?val)      (= ?x (- ?val ?n)) (numberp ?n))
           ((= (- ?n ?x) ?val)      (= ?x (- ?n ?val)) (numberp ?n))
           ((= (- ?x ?n) ?val)      (= ?x (+ ?n ?val)) (numberp ?n))
           ((= (- ?x) ?val)         (= ?x (- ?val))   )
           ((= (sqrt ?x) ?val)      (= ?x (expt ?val 2)))
           ((= (cbrt ?x) ?val)      (= ?x (expt ?val 3)) )
           ((= (expt ?x 2) ?val)    (= ?x (sqrt ?val)) )
           ((= (expt ?x 3) ?val)    (= ?x (cbrt ?val)) )
           ((= (expt ?x ?n) ?val)   (= ?x (expt ?val (/ 1 ?n))) (numberp ?n))
           ((= (* ?x ?n) ?val)      (= ?x (/ ?val ?n)) (numberp ?n))
           ((= (* ?n ?x) ?val)      (= ?x (/ ?val ?n)) (numberp ?n))
           ((= (/ ?x ?n) ?val)      (= ?x (* ?n ?val)) (numberp ?n))
           ((= (/ ?n ?x) ?val)      (= ?x (/ ?n ?val)) (numberp ?n))
           ((= (truncate ?x ?n) ?val)  (= ?x (* ?n ?val)) (numberp ?n))
           ((= (truncate (/ ?x ?n)) ?val) (= ?x (* ?n ?val)) (numberp ?n))
           ((= (* ?x ?x) ?val)      (= ?x (sqrt ?val)))
           ((= (1+ ?x) ?val)        (= ?x (1- ?val)))
           ((= (1- ?x) ?val)        (= ?x (1+ ?val)))
           ((= (round ?x) ?val)     (= ?x (float ?val)))
           ((= (ldb ?b ?x) ?val)    (= ?x (dpb ?val ?b ?x)))
           ))
; Special macros that modify some of their arguments
; t indicates an arg that is modified
      (dolist (pair '((push (nil t)) (decf (t)) (incf (t))))
        (setf (glmodifiedargs (first pair)) (second pair)) )
    ))


; 22 Oct 02
; In-line a function call at the level of Lisp code
(defun glinlinefn (fn actuals)
  (let ((lambdaexpr (symbol-function fn)))
    (if (and (set-equal (cadr lambdaexpr) actuals)
             (glnosetq (cddr lambdaexpr) actuals))
        (if (cdddr lambdaexpr)
            (cons 'progn (cddr lambdaexpr))
            (caddr lambdaexpr))
        (cons 'let
              (cons (mapcar #'(lambda (formal actual)
                                (list formal actual))
                            (cadr lambdaexpr) actuals)
                    (cddr lambdaexpr))) ) ))


; 13 Jan 99; 23 Dec 02; 11 Jan 03
; Test whether var appears in a loop or is side-effected in code
(defun glinloop (var code)
  (and (consp code)
       (or (and (member (car code) '(dotimes dolist loop while tagbody))
                (gloccurs var (cdr code)))
           (and (member (car code) '(setq setf rplaca rplacd pop incf decf))
                (gloccurs var (cadr code)))
           (and (member (car code) '(push))
                (gloccurs var (caddr code)))
           (and (listp (cdr code))
                (some #'(lambda (x) (glinloop var x)) code)))))


; 26-JUL-82; 10 Jan 96; rewritten 17 Oct 02; 22 Oct 02
; Look up or create an instance of an abstract function that 
;   takes arguments matching the specified actual args.
; Returns instance fn or nil.
(defun glinstancefn (fn actuals)
  (let (spec)
    (or (some #'(lambda (instance)   ; find existing specialization
                  (and (glmatchargsp (glarguments instance) actuals)
                       instance))
              (glinstancefns fn))
; glspecializep can be t, (t/nil ...) for args which must be constant, or fn
        (and (setq spec (glspecializep fn))
             (or (eq spec t)
                 (and (consp spec)
                      (every #'(lambda (formal actual)
                                 (or (null formal)
                                     (glconstantp (car actual))))
                             spec actuals) )
                 (and (symbolp spec) (fboundp spec)
                      (funcall spec actuals)))
             (glspecializefn fn actuals) ) ) ))


; edited:  3-FEB-83; 11 Oct 89; 27 Oct 94; 24 Jan 97
; Make a new name for an instance of a generic function. 
(defun glinstancefnname (fn)
  (let (instfn)
    (setq instfn
          (gentemp (if (glinstancename fn)
                       (symbol-name (glinstancename fn))
                       (if (and (> (length (symbol-name fn)) 8)
                                (string-equal (symbol-name fn)
                                              "generic-" :end1 8))
                           (subseq (symbol-name fn) 8)
                           (symbol-name fn)))))
    (push instfn (glinstancefns fn))
    instfn))

; 04 Mar 99
; Fix a (code type) pair to have integral units if it has
; fractional units such as (units real (* 0.5 m)).
; The code is a list of forms, i.e. an implicit progn.
(defun glintegralunits (codetype)
  (let ((code (caar codetype)) (type (cadr codetype)))
    (if (and (consp type)
             (eq (car type) 'units)
             (consp (caddr type))
             (eq (caaddr type) '*)
             (numberp (cadr (caddr type)))
             (null (cdar codetype)))
        (list (list
                (cons '* (if (and (consp code)
                                  (eq (car code) '*)
                                  (numberp (cadr code)))
                             (cons (* (cadr code)
                                      (cadr (caddr type)))
                                   (cddr code))
                             (list (cadr (caddr type))
                                   code))))
              (list 'units (cadr type) (caddr (caddr type))))
        codetype) ))


; 25-JUL-83; 15 Aug 91; 06 Apr 94; 03 Jan 95; 17 Mar 95; 03 Oct 95
; Define compile-time constants.  (glispconstants (<var> <val> [<type>]) ...)
(defmacro glispconstants (&rest args)
  (let (tmp *glexpr* *glexprstack* *glfn* val)
    (cons 'progn
          (mapcan #'(lambda (arg)
                      (list
                       `(setf (glispconstantflg ',(car arg)) t)
                       `(setf (glisporigconstval ',(car arg))
                              ,(kwote (cadr arg)))
                       `(setf (glispconstantval ',(car arg))
                              ,(progn (setq *glexpr* (list (cadr arg)))
                                      (glsepclr)
                                      (setq tmp (gldoexprc nil nil t))
                                      (setq val (kwote
                                                   (set (car arg)
                                                        (eval (car tmp)))))))
                       `(setq ,(car arg) ,val)
                       `(setf (glispconstanttype ',(car arg))
                              ,(kwote (or (caddr arg) (cadr tmp))))))
                  args)) ))

; 25-JUL-83; 03 Jan 95
; Test whether the GLISP compiler is present. 
(defun glispcp () (fboundp 'gldoexpr))


; 8-Aug-86; 15 Aug 91
; Define compile-time constants.   (glispglobals (var type) ...)
(defmacro glispglobals (&rest args)
  (cons 'progn
        (mapcan #'(lambda (arg)
                    (list `(defvar ,(car arg))
                          `(setf (glispglobalvar ',(car arg)) t)
                          `(setf (glispglobalvartype ',(car arg))
                                 ',(cadr arg))))
                args)))


; 5-Sep-86; 22 Apr 92
; Define named structure descriptions. The descriptions are of the 
;   form (<name> <description>) . Each description is put on the 
;   property list of <name> as GLSTRUCTURE 
(defmacro glispobjects (&rest args) `(glispobjects-expr ',args))
(defun glispobjects-expr (args)
  (mapcar #'(lambda (arg)
              (if (and (consp arg) (symbolp (car arg)))
                  (progn (gldefstr arg nil)
                         (car arg))
                  (error "Bad arg to glispobjects ~A" arg)))
          args))


; 03 Jan 95; 04 Jan 95
; Kill a context value entry due to redefinitiaon of a variable
; Destructively alters the context entry.
(defun glkillcontextentry (v context)
  (let (entry)
    (if (setq entry (glcontextentry v context nil))
        (if (not (eq (first entry) 'changed))
            (progn (setf (first entry) 'changed)
                   (setf (second entry) v)
                   (setf (cddr entry) nil)))) ))

; 04 May 90
; Test if code value is killed within a list of other code.
(defun glkilled (val codelist)
  (let (vars)
    (setq vars (glfindvars val))
    (some #'(lambda (x) (glkills x vars)) codelist) ))


; 04 May 90; 30 Jan 98
; Test if code kills any vars on a list.
; ***** Note that the last nil assumes that user functions don't have
; side-effects on variable values -- something to fix later.
; also (glkilled 'l '((let ((w (cdr l))) (rplaca w 3)))) = NIL, should be T.
(defun glkills (code vars)
  (if (consp code)
      (if (symbolp (car code))
          (if (glpure (car code))
              nil
              (case (car code)
                ((setq setf rplaca rplacd incf decf)
                 (intersection (glfindvars (cadr code)) vars))
                (t (some #'(lambda (x) (glkills x vars)) (cdr code)))))
          (or (glkills (car code) vars)
              (some #'(lambda (x) (glkills x vars)) (cdr code))))))


; 10 Nov 95
; Test whether something is known to be true at compile time.
; If so, returns T, else NIL.
(defun glknown (x)
  (if (constantp x)
      (not (null x))))

; 21 Apr 92
; Make new structure for quoted contents
(defun glkwote (x)
  (if (atom x)
      (kwote x)
      (if (every #'atom x)
          (list 'copy-list (kwote x))
          (list 'copy-tree (kwote x))) ) )

; 01 Dec 94
(defun gllastresulttypefn (fn argtypes)    (declare (ignore fn))
  (if (consp (first argtypes))
      (if (eq (caar argtypes) 'listof)
          (list 'list (cadar argtypes))
          (if (eq (caar argtypes) 'list)
              (cons 'list (last (cdar argtypes)))))))

; edited:  4-MAR-83; 30 Nov 89; 26 Mar 91
; Test the word ADJ to see if it is a LISP adjective. If so, return the
; CONS of the name of the function to test it and the type of the result. 
(defun gllispadj (adj)
  (cdr (assoc adj '((atomic   atom     symbol)
                    (null     null     boolean)
                    (nil      null     boolean)
                    (integer  integerp integer)
                    (real     floatp   real)
                    (bound    boundp   symbol)
                    (zero     zerop    number)
                    (numeric  numberp  number)
                    (negative minusp   number)
                    (minus    minusp   number)) )) )


; 8-Aug-86; 30 Nov 89; 26 Mar 91
; Test to see if ISAWORD is a LISP ISA word. If so, return the CONS of the
; name of the function to test for it and the type of the result if true. 
(defun gllispisa (isaword)
  (cdr (assoc isaword '((atom    symbolp  symbol)
                        (symbol  symbolp  symbol)
                        (list    consp    (listof anything))
                        (number  numberp  number)
                        (integer integerp integer)
                        (real    floatp   real)
                        (array   arrayp   (arrayof anything))
                        (string  stringp  string) ))) )


; edited: 12-NOV-82; 14 Dec 89; 06 Apr 90; 14 Nov 94
; Compute result types for Lisp functions CONS, LIST, NCONC, TUPLE
(defun gllistresulttypefn (fn argtypes)
  (let (arg1 arg2 tmp)
    (setq arg1 (glxtrtype (car argtypes)))
    (if (cdr argtypes)
        (setq arg2 (glxtrtype (cadr argtypes))))
    (case fn (cons (or (and (consp arg2)
                            (cond ((eq (car arg2) 'list)
                                    (cons 'list
                                          (cons arg1 (cdr arg2))))
                                   ((and (eq (car arg2) 'listof)
                                         (equal arg1 (cadr arg2)))
                                     arg2)))
                       (and (consp (setq tmp (car (glstr arg2))))
                            (eq (car tmp) 'listof)
                            (equal arg1 (cadr tmp))
                            arg2)
                       (cons fn argtypes)))
             (nconc (cond ((equal arg1 arg2) arg1)
                          ((and (consp arg1)
                                (consp arg2)
                                (eq (car arg1) 'listof)
                                (eq (car arg2) 'list)
                                (null (cddr arg2))
                                (equal (cadr arg1)
                                       (cadr arg2)))
                           arg1)
                          (t (or arg1 arg2))))
             ((list tuple) (cons fn (mapcar #'glxtrtype argtypes)))
             (t (error "Bad fn arg ~A" fn))) ))


; edited: 11-JAN-83; 30 Nov 89; 23 Aug 90; 06 Sep 91
; Create a function call to retrieve the field IND from a LIST structure. 
(defun glliststrfn (ind des deslist)
  (prog (tmp (n 0) fnlst)
    (setq fnlst '(car cadr caddr cadddr fifth sixth
                      seventh eighth ninth tenth))
    (if (eq (car des) 'listobject) (incf n))
  c (pop des)
    (cond ((null des) (return))
          ((atom (car des)))
          ((setq tmp (glstrfn ind (car des) deslist))
            (return (glstrval tmp
                              (if (< n 10)
                                  (list (nth n fnlst) '*gl*)
                                  (list 'nth n '*gl*))))))
    (incf n)
    (go c)))


; 01 Oct 91; 17 Oct 91; 19 Oct 93; 10 Nov 93; 29 Dec 98; 05 Apr 06
; Get the type of the loop item when iterating through a set of type dtype.
(defun glloopitemtype (dtype)
  (let (pointsto tmp)
    (if (symbolp dtype)
        (setq dtype
              (if (eq dtype 'string)
                  'character
                  (if (setq pointsto (glpointerp dtype))
                      (glxtrtypec pointsto)
                      (or (glitemtype dtype)
                          (some #'(lambda (x)
                                    (if (and (setq tmp (glstrprop (cadr x)
                                                                  'msg
                                                                  'iterator
                                                                  nil))
                                             (glmacro (cadr tmp)))
                                        (glxtrtypec (glpointerp (cadr x)))))
                                (glviews dtype))
                          (car (glstr dtype)))))))
    (if (consp dtype)
        (if (member (car dtype) '(listof arrayof))
            (cadr dtype)
            (if (and (eq (car dtype) 'list)
                     (every #'(lambda (x) (equal x (cadr dtype)))
                            (cddr dtype)))
                (cadr dtype)))
        dtype) ))

; 14 May 03
; Test whether a form is an Lvalue, i.e. something that can be stored into.
(defun gllvaluep (form)
  (or (symbolp form)
      (and (consp form)
           (member (car form)
                   '(aref nth elt rest first second third fourth fifth sixth
                     seventh eighth ninth tenth car cdr caar cadr cdar cddr
                     caaar caadr cadar caddr cdaar cdadr cddar cdddr
                     caaaar caaadr caadar caaddr cadaar cadadr caddar cadddr
                     cdaaar cdaadr cdadar cdaddr cddaar cddadr cdddar cddddr
                     get symbol-plist glcfield)))
      (and (consp form)
           (eq (car form) 'prog1)
           (gllvaluep (cadr form)))))

; edited: 25-Feb-89; 09 Sep 90; 29 Oct 02
(defun glmacroexp (form args)
  (glcompopen form args (mapcar #'cadr args) nil nil))


; edited: 24-Jan-89
; Make a structure of the specified type at runtime. 
(defun glmake (type)
  (glmkstr (glgetstr type) type (glgetdefaults type nil) nil))


; 10 Oct 96
; Compute result type of make-array -- kind of a kludge.
(defun glmake-arrayresulttypefn (fn argtypes)   (declare (ignore fn))
  (let (tail)
    (setq tail (member 'symbol argtypes))
    (if (and tail (cdr tail))
        (if (and (consp (cadr tail))
                 (eq (caadr tail) 'listof))
            (list 'arrayof (cadadr tail))
            (if (gltypep (cadr tail))
                (list 'arrayof (cadr tail))
                (list 'arrayof 'anything)) )
        (list 'arrayof 'anything)) ))

; Edited 15-Apr-88
; Make a binding list for a single object give its viewer 
(defun glmakeblfor (codetype viewer)
  (list 'glbinding
        (list (caaadr viewer)
              (car codetype)
              (cadr codetype))))


; Oct 89
; Make a car/cdr from a list of symbols, e.g., '(a d d) => CADDR
(defun glmakecarcdr (lst)
  (glmakecarcdrb lst
                 '(nil (car (caar (caaar (caaaar) (caaadr))
                                  (caadr (caadar) (caaddr)))
                            (cadr (cadar (cadaar) (cadadr))
                                  (caddr (caddar) (cadddr))))
                       (cdr (cdar (cdaar (cdaaar) (cdaadr))
                                  (cdadr (cdadar) (cdaddr)))
                            (cddr (cddar (cddaar) (cddadr))
                                  (cdddr (cdddar) (cddddr))))) ) )

(defun glmakecarcdrb (lst str)
  (if lst (if (eq (car lst) 'a)
              (glmakecarcdrb (rest lst) (second str))
              (glmakecarcdrb (rest lst) (third str)))
          (first str)) )

; 09 Apr 92
; Make an ersatz C record at runtime.
(defun glmakecrecord (recname props) (cons 'crecord (cons recname props)))
                         
; edited: 24-AUG-82; 30 Dec 08
; Compile code for a FOR loop over a Lisp list
(defun glmakeforloop (loopvar domain loopcontents loopcond collectcode stopcond)
(if stopcond
    (if collectcode
        (let ((list (glgensym 'glvar)) (result (glgensym 'glvar)) )
          (or loopcond (setq loopcond '(*gltrue* boolean)))
          (list (glgencode
                 `(let (,list ,result)
                    (setq ,list ,(car domain))
                    (while ,list
                      (setq ,loopvar (pop ,list))
                      (if ,(car loopcond) (push ,(car collectcode) ,result))
                      (if ,(car stopcond) (return)))
                    (nreverse ,result)))
                `(listof ,(cadr collectcode))))
        (list (progn
                (or loopcond (setq loopcond '(*gltrue* boolean)))
                (glgencode
               `(dolist (,loopvar ,(car domain))
                  (if ,(car loopcond) (progn . ,loopcontents))
                  (if ,(car stopcond) (return)))))
              nil))
 (if collectcode
  (list (cond (loopcond
                (glgencode (list 'mapcan
                                 (car domain)
                                 (list 'function
                                       (list 'lambda
                                             (list loopvar)
                                             (list 'and
                                                   (car loopcond)
                                                   (list 'cons
                                                        (car collectcode)
                                                         nil)))))))
              ((and (consp (car collectcode))
                    (symbolp (caar collectcode))
                    (cdar collectcode)
                    (eq (cadar collectcode)
                        loopvar)
                    (null (cddar collectcode)))
               (glgencode (list 'mapcar
                                (car domain)
                                (list 'function
                                      (caar collectcode)))))
              (t (glgencode (list 'mapcar
                                  (car domain)
                                  (list 'function
                                        (list 'lambda
                                              (list loopvar)
                                              (car collectcode)))))))
        (list 'listof
              (cadr collectcode)))
  (list (glgencode
          (list 'mapc
                (car domain)
                (list 'function
                      (list 'lambda
                            (list loopvar)
                            (cond (loopcond (list 'cond
                                                  (cons (car loopcond)
                                                        loopcontents)))
                                  ((null (cdr loopcontents))
                                   (car loopcontents))
                                  (t (cons 'progn
                                           loopcontents)))))))
        nil))))


; edited: 21-Feb-89; 14 Sep 06
(defun glmakelambda (arglist codetype storeflg)
  (if storeflg
      (progn (or (cdr arglist)
                 (setq arglist (append arglist (list (glgensym 'glvar)))))
             (setq codetype (glputfn codetype
                                     (list (cadr arglist)
                                           (or (glviewerct codetype)
                                               (cadr codetype)))
                                     nil)))
      (if (glvvct codetype)
          (setq codetype (glmaterialize codetype nil nil))))
  (list (list 'lambda
              (copy-tree arglist)
              (glunwrapc (car codetype) t))
        (cadr codetype)) )


; 12 Apr 90; 21 May 90; 11 Jun 90
; Make a pointer object for a given type
(defun glmakepointer (type)
  (let (pointer-name)
    (setq pointer-name
          (intern (concatenate 'string (symbol-name type) "-POINTER")))
    (unless (glstructure pointer-name)
      (setf (glstructure pointer-name)
            (list (list '^ type) 'supers (list 'generic-pointer))))
    (setf (glpointer type) pointer-name)
    pointer-name))


; edited: 17-Sep-88
; Make a PROGN form. 
(defun glmakeprogn (lst progwd)
  (if (cdr lst)
      (cons progwd lst)
      (car lst)))


; edited: 17-Jan-89; 12 Nov 89; 04 Dec 89; 13 Dec 89; 19 Jan 90; 08 Jan 91
; 08 Nov 91; 15 Jul 08
; Compile code to create a structure in response to a statement 
;   (A <structure> WITH <field> = <value> ...) 
(defun glmakestr (type *glexpr*)
  (prog (pairlist strdes (origtype type))
    (if (eq (car *glexpr*) 'with)
        (pop *glexpr*))
    (if (and (consp type)
             (eq (car type) 'viewer))
        (setq type (glviewertype type)))
    (unless (or (and (consp type)
                     (glokstr? type)
                     (setq strdes type))
                (setq strdes (glgetstr type)))
            (glerror 'glmakestr "The type name  ~A  is not defined." type))
    (if (and (consp strdes) (eq (car strdes) 'listof))
        (return (list (cons 'list
                            (mapcar #'(lambda (*glexpr*)
                                        (gldoexpr nil *glcontext* t))
                                    *glexpr*))
                      type)))
    (setq pairlist (glgetdefaults type (glgetpairs *glexpr*)))
    (dolist (l (gldefaults type))
            (unless (assoc (car l) pairlist)
                    (push (list (car l)
                                (copy-tree (cadr l))
                                (or (caddr l)
                                    (glconstanttype (cadr l))))
                          pairlist)))
    (return (if (and (consp type) (eq (car type) 'virtual))
                (glbuildvstr (cadr type) pairlist)
              (if (and (consp origtype) (eq (car origtype) 'viewer))
                  (glbuildvstr type pairlist)
                  (glmakestrb type strdes pairlist) ) ) ) ))


; 08 Nov 91; 18 Nov 91; 26 Mar 93; 29 Mar 93; 21 May 93; 17 Feb 94
; 06 June 95; 14 Sep 06
; Make a structure, adding properties at the end if needed.
(defun glmakestrb (type strdes pairlist)
  (let (makecode datanames var proppairs savecontext getcode putcode any)
    (setq makecode
          (if (glviewtypep type)
              (glbuildstr type pairlist nil)
              (glbuildstr strdes pairlist (list type))))      ; old version
  ;   26 Mar 93
  ;  the following code was tried but causes problems.  In genll.lsp,
  ;  linked-list-record defines a new message as (a (typeof self)),
  ;  which causes a loop because glbuildstr calls the new msg.
  ;  (setq makecode (glbuildstr type pairlist nil))
    (setq datanames (gldatanames (or (glviewtypep type) type)))
    (if (setq proppairs
              (subset #'(lambda (x) (and (not (member (car x) '(self)))
                                         (not (assoc (car x) datanames))))
                      pairlist))
        (progn                                 ; there are some props
          (setq var (glgensym 'glvar))                 ; make a temp var
          (setq savecontext *glcontext*)
          (setq *glcontext* (list nil))
          (gladdstr var nil type *glcontext*)
          (glnotetype var type)
          (dolist (prop proppairs)
            (if (and (glpropdef type 'prop (car prop))
                     (setq getcode (glpushexpr (list (car prop) var)
                                               t *glcontext* t)))
                (progn (push (car (glputfn getcode (rest prop) nil)) putcode)
                       (setq any t))
                (glerror 'glmakestrb "The property ~A is not defined for ~A"
                         (car prop) type)))
          (setq *glcontext* savecontext)
          (if any (list (cons 'let (cons (list (list var makecode))
                                         (nreverse (cons var putcode))))
                        type)
                  (list makecode type)) )
        (list makecode type) ) ))


; 15-Apr-88; 14-Mar-89; 23 Mar 95
; Make a virtual type for a view of the original type.
; vlist = (VIRTUAL <type> with param = value ...)
; "with" is optional.  "=" is required.
(defun glmakevtype (origtype origvlist)
  (let ((vlist origvlist) super pl pname tmp)
    (setq super (cadr vlist))
    (setq vlist (cddr vlist))
    (if (eq (car vlist) 'with) (pop vlist))
    (while vlist
      (unless (symbolp (setq pname (pop vlist)))
        (glerror 'glmakevtype "Bad virtual spec ~A~%" origvlist))
      (if (eq (car vlist) '=) (pop vlist))
      (setq tmp nil)
      (while (and vlist
                  (not (eq (car vlist) '\,))
                  (not (and (symbolp (car vlist))
                            (cdr vlist)
                            (eq (cadr vlist) '=))))
        (push (pop vlist) tmp))
      (push (list pname (nreverse tmp)) pl)
      (if (eq (car vlist) '\,) (pop vlist)))
    (list 'viewer (list (list 'self origtype))
                  (list (list 'out  super))
                  pl)  ))


; 22 Dec 93
; Materialize a code/type pair if it is virtual
(defun glmat (codetype)
  (if (glvvct codetype)
      (glmaterialize codetype nil nil)
      codetype))

; 25-FEB-83; 04 May 91
; Test whether an item of type TNEW could be stored into a slot of type TINTO. 
(defun glmatch (tnew tinto)
  (let (tmp res)
    (cond ((or (eq tnew tinto)
               (null tinto)
               (eq tinto 'anything)
               (and (member tnew '(integer real number))
                    (member tinto '(number atom symbol)))
               (and (member tnew '(atom symbol))
                    (member tinto '(atom symbol)))
               (and (member tnew '(atom symbol))
                    (consp tinto)
                    (member (car tinto) '(atom symbol))))
            tnew)
          ((and (setq tmp (glxtrtypec tnew))
                (setq res (glmatch tmp tinto)))
            res)
          ((and (setq tmp (glxtrtypec tinto))
                (setq res (glmatch tnew tmp)))
            res)
          (t nil))))


; 15 Oct 02; 22 Oct 02; 15 Sep 10
; Test whether an arg list matches that of a specialized function
; formals is (name type constantp value facts)  ; last 3 may be omitted
(defun glmatchargsp (formals actuals)
  (let (optflg formal actual (ok t))
    (while (and formals actuals ok)
      (if (eq (car formals) '&optional)
          (progn (pop formals)
                 (setq optflg t)))
      (setq formal (pop formals))
      (setq actual (pop actuals))
      (or (and (gltypematch (cadr actual) (cadr formal))
               (or (not (caddr formal))
                   (equal (fourth formal) (first actual))))
          (setq ok nil)) )
    (and ok
         (or (and (or (null formals)
                      optflg
                      (and (consp formals)
                           (eq (car formals) '&optional)))
                  (null actuals))) ) ))


; edited: 25-FEB-83; 19 Jan 90; 08 Jan 92
; Test whether two types match as an element type and a list type. The 
;   result is the resulting element type. 
(defun glmatchl (telem tlist)
  (let (tmp)
    (if (and (consp tlist)
             (eq (car tlist) 'listof)
             (glmatch telem (cadr tlist)))
        telem
        (and (not (equal telem tlist))
             (setq tmp (glxtrtypec tlist))
             (not (equal tmp tlist))
             (glmatchl telem tmp))) ))



; 20-Apr-88; 16-Mar-89; 24 Jan 90; 10 Oct 90; 12 Oct 90; 15 Feb 94; 11 Nov 94
; Materialize the data represented by CODETYPE as an item of type 
;   GOALTYPE. If GOALTYPE is NIL and CODETYPE is a binding and viewer, 
;   the default type of the viewer is used.
; If VFLAG is true, a virtual materialization is made. 
(defun glmaterialize (codetype goaltype vflag)
  (prog ((code (car codetype)) (type (cadr codetype))
          fields val pairlist tmp)
    (unless goaltype
      (if (and vflag (glvirtualbp (car codetype) (cadr codetype)))
          (return codetype))
      (unless (setq goaltype (and (consp type)
                                  (if (eq (car type) 'viewer)
                                      (glviewertype type)
                                      (if (eq (car type) 'virtual)
                                          (cadr type)))))
              (error "Can't find type")))
    (if (and (not vflag)
             (eq (car code) 'glvirtual)
             (glstrprop goaltype 'msg 'materialize nil))
        (return (gldomsg codetype 'materialize nil)))
    (or (setq fields (glgetfields goaltype))
        (if (setq tmp (assoc 'self (cdr code)))
            (return (list (cadr tmp) goaltype))
            (glerror "Can't materialize ~A ~A ~A" codetype goaltype vflag)))
    (dolist (field fields)
      (if (setq val (glvalue code field type nil))
          (push (cons field val) pairlist) ) )
    (return (if vflag
                (list (cons 'glvirtual (cons goaltype pairlist))
                      (list 'virtual goaltype))
                (list (glbuildstr (if (symbolp goaltype)
                                      (glgetstr goaltype) goaltype)
                                  pairlist
                                  (if (symbolp goaltype) (list goaltype)))
                      goaltype)) ) ))


; 22 Dec 93; 23 Dec 93; 15 Feb 94; 10 Nov 94; 04 Mar 99
; Materialize last thing in a code list / type pair if it is virtual.
; Also fixes units if the result is a factional unit.
; The code is assumed to be list of code forms, i.e. an implicit progn.
; The result is in the same form.
(defun glmatn (codetype)
  (let (tmp rev lastcode tmpb)
    (if (and (consp (cadr codetype))
             (eq (caadr codetype) 'virtual)
             (glvirtualcodep (car codetype) t))
        (progn (setq rev (nreverse (car codetype)))
               (setq lastcode (car rev))
               (setq tmp
                     (if (and (consp lastcode)
                              (eq (car lastcode) 'list)
                              (quotep (cadr lastcode))
                              (consp (cadadr lastcode))
                              (eq (car (cadadr lastcode)) 'virtual))
                         (glmaterialize (list lastcode (cadr codetype))
                                        nil nil)
                         (case (first lastcode)
                           (progn (setq tmpb (glmatn (list (rest lastcode)
                                                           (cadr codetype))))
                                  (list (if (cdar tmpb)
                                            (cons 'progn (car tmpb))
                                            (caar tmpb))
                                        (cadr tmpb)))
                           (let (setq tmpb (glmatn (list (cddr lastcode)
                                                         (cadr codetype))))
                                (list (cons (first lastcode)
                                            (cons (second lastcode)
                                                  (car tmpb)))
                                      (cadr tmpb)))
                           (glvirtual (glmaterialize
                                       (list lastcode (cadr codetype))
                                       nil nil))
                           (t (list lastcode (cadr codetype)))) ) )
               (list (nreverse (cons (car tmp) (cdr rev)))
                     (cadr tmp)))
        (glintegralunits codetype)) ))


; edited: 22-JUL-83
; Construct the negative of the argument LHS. 
(defun glminusfn (lhs)
  (or (gldomsg lhs 'minus nil)
      (gluserstrop lhs 'minus nil)
      (list (glgencode (if (numberp (car lhs))
                           (- (car lhs))
                           (list '- (car lhs))))
            (cadr lhs)) ) )


; 10-Sep-86; 07 May 91; 23 Sep 91; 20 Dec 92
; Make a variable name for GLCOMP functions.
(setf (glfnresulttype 'glmkatom) 'symbol)
(defun glmkatom (name)
  (prog (newatom n)
    (unless (symbolp name)
      (setq name (intern (concatenate 'string (stringify name) "-"))))
 lp (setf (glispatomnumber name)
          (setq n (1+ (or (glispatomnumber name) 0))))
    (setq newatom (intern (concatenate 'string (symbol-name name)
                                               (princ-to-string n))))
; if an atom with this name has something on its proplist, try again. 
    (if (symbol-plist newatom)
        (go lp)
        (return newatom))))


; edited:  8-Aug-86
; Make a record with a given length or datatype. 
(defun glmkrecord (n name)   (declare (ignore name))   (make-array n))


; 22-Aug-86; 13 Dec 89; 15 Dec 89; 01 June 90; 09 Apr 92; 21 Apr 92; 03 Nov 92
; 05 Apr 07
; Make a structure at runtime. STR is the structure description, and 
;   PAIRS is an ALIST of field names and values. The values are 
;   unevaluated, in GLISP code form, i.e., a list of code and type. 
(defun glmkstr (str name pairs prevlst)
  (let (tmp new n ptr)
    (cond ((symbolp str)
            (cond ((member str prevlst) nil)       ; prevent loop
                  ((or (null str)
                       (glbasictypep str))
                    (cond ((and name (setq tmp (glgetdefault name 'self)))
                            (cadr tmp))
                          ((and name
                                (setq tmp (gldomsg (list nil name) 'new nil)))
                            (eval (car tmp)))
                          (t (gldefaultvalue str))))
                  ((setq tmp (glgetdefault str 'self))
                    (cadr tmp))
                  ((setq tmp (gldomsg (list nil str) 'new nil))
                    (eval (car tmp)))
                  (t (glmkstr (glgetstr str) str nil (cons str prevlst)))))
          (t (case (car str)
                   (cons (cons (glmkstr (cadr str) nil pairs prevlst)
                               (glmkstr (caddr str) nil pairs prevlst)))
                   (list (mapcar #'(lambda (x) (glmkstr x nil pairs prevlst))
                                 (cdr str)))
                   ((listof arrayof) nil)
                   (alist (mapcan
                           #'(lambda (x)
                               (cond ((assoc (car x) pairs)
                                       (list (cons (car x)
                                                   (eval (cadr (assoc
                                                                (car x)
                                                                pairs))))))
                                     ((if (setq tmp (glmkstr (cadr x)
                                                             nil pairs
                                                             prevlst))
                                          (list (cons (car x) tmp))))))
                           (cdr str)))
                   (crecord (cons 'crecord
                                  (cons (cadr str)
                                        (glmkstr (cons 'alist (cddr str))
                                                 name pairs prevlst))))
                   (proplist
                     (mapcan
                       #'(lambda (x)
                           (cond ((assoc (car x) pairs)
                                   (list (car x)
                                         (eval (cadr (assoc (car x) pairs)))))
                                 ((if (setq tmp (glmkstr (cadr x)
                                                         nil pairs prevlst))
                                      (list (car x) tmp)))))
                       (cdr str)))
                   (transparent (if (member (cadr str) prevlst)
                                    nil
                                  (glmkstr (glgetstr (cadr str))
                                           nil pairs (cons (cadr str)
                                                           prevlst))))
                   ((atom symbol)
                         (setq new (glmkatom (or name 'glatom)))
                         (dolist (y (cdr str))
                                 (cond ((eq (car y) 'proplist)
                                        (dolist (x (cdr y))
                                                (setf (get new (car x))
                                                      (glmkstr x nil pairs
                                                               prevlst))))
                                       ((eq (car y) 'binding)
                                        (set new (glmkstr (cadr y)
                                                          nil pairs
                                                          prevlst)))))
                         new)
                   (atomobject (setq new (glmkatom (or name 'glatom)))
                               (setf (globjclass new) name)
                               (dolist (x (cdr str))
                                       (setf (get new (car x))
                                             (glmkstr x nil pairs prevlst)))
                               new)
                   (listobject (cons name
                                     (mapcar #'(lambda (x)
                                                 (glmkstr x nil pairs prevlst))
                                             (cdr str))))
                   ((object record)
                    (setq new (glmkrecord (cond ((eq (car str) 'object)
                                                 (1+ (length (cdr str))))
                                                ((symbolp (cadr str))
                                                 (length (cddr str)))
                                                (t (length (cdr str))))
                                          (and (symbolp (cadr str))
                                               (cadr str))))
                    (setq n 0)
                    (when (eq (car str) 'object)
                          (setf (aref new 0) name)
                          (incf n))
                    (dolist (x (cdr str))
                            (setq tmp (glmkstr x nil pairs prevlst))
                            (setf (aref new n) tmp)
                            (incf n))
                    new)
                   (^ (setq ptr (glgetpointer (cadr str)))
                      (if (or (null ptr)
                              (and (setq tmp (car (glstr ptr)))
                                   (consp tmp)
                                   (eq (car tmp) '^)
                                   (eq (cadr tmp) (cadr str))))
                          nil
                          (if (setq tmp (glvalue nil 'null-value ptr nil))
                              (eval (car tmp)))))
                   (t (cond ((setq tmp (assoc (car str) pairs))
                              (eval (glbuildrep str tmp)))
                            ((glmkstr (cadr str) nil pairs prevlst)))))))))


; 26 Mar 91; 31 Dec 91; 30 Jan 92
; Test whether a new type is more specific than the old one.
; BOOLEAN is not considered more specific than (LISTOF <type>).
(defun glmorespecificp (newtype oldtype)
  (cond ((null oldtype) newtype)
        ((null newtype) nil)
        ((equal newtype oldtype) nil)
        ((eq oldtype 'anything) t)
        ((member newtype '(anything boolean)) nil)
        ((and (eq oldtype 'number)
              (member newtype '(integer real)))
          t)
        ((and (eq newtype 'number)
              (member oldtype '(integer real)))
          nil)
        ((and (consp oldtype)
              (member (first oldtype) '(listof arrayof))
              (consp newtype)
              (eq (first newtype) (first oldtype)))
          (glmorespecificp (second newtype) (second oldtype)))
        ((and (consp oldtype)
              (eq (first oldtype) 'listof)
              (eq newtype 'boolean))
          nil)
        (t t)) )


; 15-Aug-88; 11 Mar 03
; Produce a function to implement the _+ operator. Code is produced to 
;   append the right-hand side to the left-hand side. Note: parts of 
;   the structure provided are used multiple times. 
(defun glnconcfn (lhs rhs)
  (prog (lhscode lhsdes nccode tmp str)
    (setq lhscode (car lhs))
    (setq lhsdes (glxtrtype (cadr lhs)))
    (cond ((eq lhsdes 'integer)
            (cond ((eql (car rhs) 1)
                    (setq nccode (list '1+ lhscode)))
                  ((or (integerp (car rhs))
                       (eq (cadr rhs) 'integer))
                    (setq nccode (list '+ lhscode (car rhs))))
                  (t (setq nccode (list '+ lhscode (car rhs))))))
          ((or (eq lhsdes 'number)
               (eq lhsdes 'real))
            (setq nccode (list '+ lhscode (car rhs))))
          ((eq lhsdes 'boolean)
            (setq nccode (list 'or lhscode (car rhs))))
          ((null lhsdes)
            (setq nccode (list 'nconc1 lhscode(car rhs)))
            (if (and (symbolp lhscode)
                     (cadr rhs))
                (glupdatevartype lhscode (list 'listof (cadr rhs)))))
          ((and (consp lhsdes)
                (eq (car lhsdes) 'listof)
                (not (equal lhsdes (cadr rhs))))
            (setq nccode (list 'nconc1 lhscode (car rhs))))
          ((setq tmp (glunitop lhs rhs 'nconc))
            (return tmp))
          ((setq tmp (gldomsg lhs '_+ (list rhs)))
            (return tmp))
          ((setq tmp (gldomsg lhs '+ (list rhs)))
            (setq nccode (car tmp)))
          ((setq tmp (gluserstrop lhs '_+ rhs))
            (return tmp))
          ((and (setq str (glgetstr lhsdes))
                (setq tmp (glnconcfn (list (car lhs) str)
                                     rhs)))
            (return (list (car tmp) (cadr lhs))))
          ((setq tmp (glreducearith '+ lhs rhs))
            (return (glputfn lhs tmp t)))
          (t (return)))
    (return (glputfn lhs (list (glgencode nccode) lhsdes) t))))


; edited: 23-DEC-82; 29 Dec 89; 19 Jan 90; 26 Feb 02
; Produce code to test the two sides for inequality. 
(defun glnequalfn (lhs rhs)
  (let ()
    (or (gldomsg lhs '!= (list rhs))
        (gluserstrop lhs '!= rhs)
        (list (glgencode (list 'not
                               (if (or (glatomtypep (cadr lhs))
                                       (glatomtypep (cadr rhs)))
                                   (list 'eq (car lhs) (car rhs))
                                   (car (glequalfn lhs rhs)))))
              'boolean)) ))


; 14 Dec 89; 26 Mar 91; 19 Nov 92
; Determine if code can never return NIL (and is side-effect free).
(defun glnevernil (x)
  (and x
       (or (constantp x)
           (and (consp x)
                (cdr x)
                (member (first x)
                        '(cons list + - * / truncate round 1+ 1-))))) )


; 15 Oct 02; 15 Sep 10
; Make a new arg list for calling a specialized function.
; formals is (name type constantp value facts)  ; last 3 may be omitted
; returns a new argument list (without types)
(defun glnewarglist (formals actuals)
  (let (res formal actual)
    (while (and formals actuals)
      (if (and (consp formals)
               (eq (car formals) '&optional))
          (pop formals))
      (setq formal (pop formals))
      (setq actual (pop actuals))
      (if (not (third formal))
          (push (car actual) res)) )
    (reverse res) ))


; Edited 14-Sep-87; 29 Dec 89
; Count occurrences of ATM in STR 
(defun glnoccurs (atm str)
  (if (atom str)
      (if (eq atm str) 1 0)
      (+ (glnoccurs atm (car str))
         (glnoccurs atm (cdr str)))) )


; 25 Feb 92; 03 Nov 92
; Test if a type is a defined, non-basic type.
(defun glnonbasictypep (type)
  (and (symbolp type)
       (not (glbasictypep type))) )


; 29 Dec 08
; Test whether code contains no setq of any member of vars.
(defun glnosetq (code vars)
  (or (not (consp code))
      (if (member (car code) '(setq setf))
          (and (or (not (consp (cdr code)))
                   (not (member (cadr code) vars)))
               (every #'(lambda (x) (glnosetq x vars))
                      (cdr code)))
          (every #'(lambda (x) (glnosetq x vars))
                 code)) ) )


; 07 Jan 99; 22 Oct 02
; Test whether code is free of side-effects.
; This is a conservative test since it only allows the functions we
; know to be free of side effects such as + etc.
(defun glnosideeffects (code)
  (or (atom code)
      (and (glpure (car code))
           (or (member (car code) '(quote function))
               (every #'glnosideeffects (cdr code))))))


; 7-MAR-83; 26 Mar 91; 22 Dec 94    ; glmorespecificp (newtype oldtype)
; If SOURCE represents a variable name, add the TYPE of SOURCE to the CONTEXT. 
(defun glnotesourcetype (source type doit)
  (let (var tmp)
    (when (and doit
               (setq var (cond ((symbolp (car source)) (car source))
                               ((and (consp (car source))
                                     (member (caar source) '(setq prog1))
                                     (symbolp (cadar source)))
                                 (cadar source))))
               (setq tmp (glcodetype var *glcontext*))
               (glmorespecificp type (cadr tmp)))
      (gladdstr var (car tmp) type *glcontext*) ) ))


; 21 May 93
; Note the type of a single var
(defun glnotetype (var type)
  (unless (assoc var *gltypesdefined*)
    (push (cons var type) *gltypesdefined*)) )

; 10 Apr 92; 22 Dec 94
; Note types that have been defined by type inference in compiling the
; current function.  ctx is a context structure; result is an alist
; of (name . type) on gltypesdefined.
(defun glnotetypes (ctx)
  (let ()
    (dolist (clist ctx)
      (dolist (item clist)
        (if (and (consp item)
                 (eq (first item) 'type)
                 (third item)
                 (not (assoc (second item) *gltypesdefined*)))
            (push (cons (second item) (third item)) *gltypesdefined*)) ) ) ))


; edited:  3-MAY-82
; Construct the NOT of the argument LHS. 
(defun glnotfn (lhs)
  (or (gldomsg lhs '~ nil)
      (gluserstrop lhs '~ nil)
      (list (glbuildnot (car lhs)) 'boolean)))


; edited: 11-Sep-87; 29 Dec 89
; Add TYPE to the global variable *GLTYPESUSED* if not already there. 
(defun glnoticetype (type)
  (if (symbolp type) (pushnew type *gltypesused*)))


; 30 Dec 94; 04 Jan 95; 20 May 96; 31 Jul 96; 10 Oct 96; 08 Feb 11; 11 Feb 11
; Test whether a variable is unused in code.  T = var is not used.
; Assignment by SETQ is not counted as a use.
(defun glnotused (var code)
  (if (atom code)
      (not (eq var code))
      (case (car code)
        ((setq setf)
          (if (consp (cdr code))
              (if (symbolp (cadr code))
                  (glnotused-setq var (cdr code))
                  (and (glnotused var (cadr code))
                       (or (not (consp (cddr code)))
                           (glnotused var (caddr code)))))) )        
        ((quote go) t)
        ((let let* prog lambda)
          (and (consp (cdr code))
               (not (member var (cadr code)
                            :test #'(lambda (x y) (if (consp y)
                                                      (eql x (car y))
                                                      (eql x y)))))
               (glnotused var (cdr code))))
        ((the return-from)
          (and (consp (cdr code))
               (consp (cddr code))
               (glnotused var (caddr code))))
        (cond (every #'(lambda (clause)
                         (every #'(lambda (x) (glnotused var x)) clause))
                     (cdr code)))
        (t (every #'(lambda (x) (glnotused var x))
                  (if (and (symbolp (car code)) (cdr code))
                      (cdr code)
                      code)) ) ) ) )

; 30 Dec 94
; Test whether a variable is unused in SETQ code.
; code arg will be (var value ...)
(defun glnotused-setq (var code)
  (or (null code)
      (not (consp code))
      (not (consp (cdr code)))
      (and (glnotused var (cadr code))
           (glnotused-setq var (cddr code)))))

; 25 Mar 11
; a private nreverse to trace it in gluserfnb
(defun glnreverse (lst) (nreverse lst))

; edited:  8-Aug-86; 23 Aug 90; 17 Oct 91; 13 May 93
; Compute the result type for the function NTH, NTHCDR, FIRST etc., REST
(defun glnthresulttypefn (fn argtypes)
  (let (tmp type listoftype lst)
    (setq type (if (member fn '(nth nthcdr assoc))
                   (cadr argtypes)
                   (car argtypes)))
    (setq tmp (glxtrtypeb type))
    (if (setq listoftype (and (consp tmp)
                              (or (eq (car tmp) 'listof)
                                  (and (eq (car tmp) 'list)
                                       (every #'(lambda (x)
                                                  (equal x (cadr tmp)))
                                              (cddr tmp))))
                              tmp))
        (if (member fn '(nthcdr rest))
            type
            (cadr listoftype))
        (if (setq lst (cdr (assoc fn '((rest    d)
                                       (first   a)
                                       (second  d a)
                                       (third   d d a)
                                       (fourth  d d d a)
                                       (fifth   d d d d a)
                                       (sixth   d d d d d a)
                                       (seventh d d d d d d a)
                                       (eighth  d d d d d d d a)
                                       (ninth   d d d d d d d d a)
                                       (tenth   d d d d d d d d d a)))))
            (glcarcdrresulttype lst type))) ))

; 01 Nov 89; 28 Jan 92; 26 Apr 94; 28 Apr 94; 29 Apr 94
(defun glnumberp (x)
  (let (v)
    (or (numberp x)
        (and (symbolp x) (constantp x) (numberp (eval x)))
        (and (consp x)
             (member (car x) '(+ - * / 1+ 1- sin cos tan sqrt cbrt expt))
             (every #'glnumberp (rest x)))
        (and (glconstantp x)
             (setq v (glconstval x))
             (or (numberp v)
                 (and (consp v) (eq (car v) 'q)
                      (consp (cdr v))
                      (numberp (cadr v))
                      (consp (cddr v)))))) ))

; 01 Nov 89; 28 Jan 92
(defun glnumberval (x)
  (if (numberp x) x
      (if (and (symbolp x) (constantp x) (numberp (eval x)))
          (eval x)
          (if (glconstantp x)
              (glconstval x)
              (error "~A is not a numeric constant" x)))))

; 25 Oct 91; 21 Jan 93; 13 Feb 96
; Compute result types for numeric Lisp functions, e.g. + max abs
(defun glnumresulttypefn (fn argtypes)      (declare (ignore fn))
  (let (restype (prec '(nil integer number real)) pa pb)
    (if (or (symbolp (first argtypes))
            (and (consp (first argtypes))
                 (eq (caar argtypes) 'units)))
        (setq restype (first argtypes)))
    (dolist (tp (rest argtypes))
      (if (and (not (consp restype))
               (symbolp tp)
               (setq pa (position tp prec))
               (setq pb (position restype prec))
               (> pa pb))
          (setq restype tp)))
    (or restype 'number) ))

; 02 Jan 08
; Test whether a type is a number
(defun glnumtypep (type)
  (or (member type '(integer real number))
      (and (consp type)
           (eq (car type) 'units)
           (glnumtypep (cadr type))
           (symbolp (caddr type))
           (eq (glsimplifyunit (caddr type)) 'unity) ) ) )

; edited:  3-JUN-82
; See if X occurs in STR, using EQ. 
(defun gloccurs (x str)
  (cond ((eq x str) t)
        ((atom str) nil)
        (t (or (gloccurs x (car str))
               (gloccurs x (cdr str))))))


; 19-Oct-87; 26 Dec 89; 28 Mar 90; 03 Apr 90; 13 Jan 92; 09 Apr 92; 05 Nov 92
; 09 Aug 95; 10 Oct 96
; Check a structure description for legality. 
(defun glokstr? (str)
  (cond
    ((null str) nil)
    ((symbolp str) t)
    ((and (consp str)
          (symbolp (car str)))
      (case (car str)
            ((a an)
              (cond ((cddr str) nil)
                    ((or (glgetstr (cadr str))
                         (glunit? (cadr str))
                         (if *glcautiousflg* 
                             (format t 
                      "The structure ~A is not currently defined.  Accepted.~%"
                                         (cadr str)))
                         t))))    
            (cons (and (cdr str)
                       (cddr str)
                       (null (cdddr str))
                       (glokstr? (cadr str))
                       (glokstr? (caddr str))))
            ((list object atomobject listobject)
              (and (cdr str)
                   (every #'glokstr? (cdr str))))
            ((record crecord)
              (if (and (cdr str)
                       (symbolp (cadr str)))
                  (pop str))
              (and (cdr str)
                   (every #'(lambda (x)
                              (and (consp x)
                                   (symbolp (car x))
                                   (glokstr? (cadr x))))
                          (cdr str))))
            ((listof arrayof) (and (cdr str)
                                   (null (cddr str))
                                   (glokstr? (cadr str))))
            ((alist proplist tuple)
              (and (cdr str)
                   (every #'(lambda (x)
                              (and (symbolp (car x))
                                   (glokstr? (cadr x))))
                          (cdr str))))
            (symbolp (glatmstr? str))
            ((typeof clustertype) t)
            (units (glunittypep str))
            (t (cond ((and (cdr str)
                           (null (cddr str)))
                       (glokstr? (cadr str)))
                     ((assoc (car str) *gluserstrnames*))
                     ((and (boundp '*glgevusertypenames*)
                           (member (car str) *glgevusertypenames*))
                      (and (cdr str)
                           (every #'(lambda (x)
                                      (and (symbolp (car x))
                                           (glokstr? (cadr x))))
                                  (cdr str))))
                     ((glclusterspec (car str)) (glfindclustertype str))
                     (t nil)))))
    (t nil)))

; 22 Oct 02
; Test whether it is okay to eval a function with constant args
(defun gloktoeval (fn) (glevalwhenconst fn))
#|  (not (member fn '(random error setf setq rplaca rplacd nconc nreverse
                    print princ prin1 terpri read write printf open close
                    defvar proclaim in-package catch throw go ignore
                    import intern psetf window-create menu-create
                    copy-tree copy-list return push pop incf eval funcall
                    gevpop
|#

; 10 Aug 04; 26 Oct 06
; Test whether an operator is defined for a type
(defun glopdef (type op)
  (or (and (some #'(lambda (x) (gldescendantp type x))
                 '(integer real number))
           (member op '(+ - * / zerop plusp minusp = /= > >= < <=
                        max min 1+ 1- exp expt log sqrt abs signum
                        sin cos tan asin acos atan truncate floor
                        ceiling round mod rem)))
      (glpropdef type 'msg op)))

; 30-DEC-81; 24 Dec 93; 20 Oct 94
; Get the next operand from the input list, *GLEXPR* (global) . The 
; operand may be an atom (possibly containing operators) or a list. 
(defun gloperand ()
  (cond ((setq *glfirst* (glsepnxt)) (glparsnfld))
        ((null *glexpr*) nil)
        ((stringp (car *glexpr*)) (list (pop *glexpr*) 'string))
        ((characterp (car *glexpr*)) (list (pop *glexpr*) 'character))
        ((integerp (car *glexpr*)) (list (pop *glexpr*) 'integer))
        ((floatp (car *glexpr*)) (list (pop *glexpr*) 'real))
        ((numberp (car *glexpr*)) (list (pop *glexpr*) 'number))
        ((symbolp (car *glexpr*))
          (glsepinit (pop *glexpr*))
          (setq *glfirst* (glsepnxt))
          (glparsnfld))
        (t (glpushexpr (pop *glexpr*) t *glcontext* t)) ) )


; 4-MAR-83; 28 Dec 94; 26 Feb 02; 12 Mar 02
; Test if an atom is a GLISP operator 
(defun gloperator? (atm)
  (member atm '(\:= = __ + - * / > < >= <= ^ _+ +_ _- -_ =+ += =- -=
                == != <> and or  __+ __- _+_)))


; 26-DEC-82; 04 Aug 93
; OR operator 
(defun glorfn (lhs rhs)
  (cond ((and (consp (cadr lhs))
              (eq (caadr lhs) 'listof)
              (equal (cadr lhs) (cadr rhs)))
         (list (list 'union (car lhs) (car rhs))
               (cadr lhs)))
        ((gldomsg lhs 'or (list rhs)))
        ((gluserstrop lhs 'or rhs))
        (t (list (list 'or (car lhs) (car rhs))
                 (glandorresulttypefn 'or (list (cadr lhs) (cadr rhs))))) ) )


; 22-SEP-82; 28 Dec 94; 26 Feb 02
; Subroutine of GLDOEXPR to parse a GLISP expression containing field 
;   specifications and/or operators. The global variable *GLEXPR* is 
;   used, and is modified to reflect the amount of the expression 
;   which has been parsed. 
(defun glparsexpr ()
  (prog (*glparsopnds* *glparsopers* *glfirst* lhsp rhsp)
  
; get the initial part of the expression, i.e., variable or field 
;   specification. 

 l  (push (gloperand) *glparsopnds*)
 m  (cond ((null *glfirst*)
           (if (or (null *glexpr*)
                   (consp (car *glexpr*)))
               (go b))
           (glsepinit (car *glexpr*))
           (cond ((gloperator? (setq *glfirst* (glsepnxt)))
                   (pop *glexpr*)
                   (go a))
                 ((member *glfirst* '(is has))
                   (if (and *glparsopers*
                            (> (glprec (car *glparsopers*)) 5))
                       (progn (glreduce)
                              (setq *glfirst* nil)
                              (go m))
                       (progn (push (glpredicate (pop *glparsopnds*)
                                                 *glcontext* t
                                                 (and (boundp '*gladdisatype*)
                                                      *gladdisatype*))
                                    *glparsopnds*)
                              (setq *glfirst* nil)
                              (go m))))
                 (t (glsepclr)
                    (go b))))
          ((gloperator? *glfirst*) (go a))
          (t (glerror 'glparsexpr
                      " ~A  appears illegally or cannot be interpreted." 
                            *glfirst*)))
  
; *glfirst* now contains an operator 

 a
  
; while top operator < top of stack in precedence, reduce. 

    (unless (or (null *glparsopers*)
                (< (setq lhsp (glprec (car *glparsopers*)))
                   (setq rhsp (glprec *glfirst*)))
                (and (eql lhsp rhsp)
                   (member *glfirst* '(^ \:= =))))
            (glreduce)
            (go a))
  
; push new operator onto the operator stack. 

    (push *glfirst* *glparsopers*)
    (go l)
 b (when *glparsopers* (glreduce) (go b))
   (return (car *glparsopnds*)) ))


; edited: 30-DEC-82 10:55 
; Parse a field specification of the form var:field:field... Var may 
;   be missing, and there may be zero or more fields. The variable 
;   *GLFIRST* is used globally; it contains the first atom of the 
;   group on entry, and the next atom on exit. 
(defun glparsfld (prev)
(prog (field tmp)
      (unless prev (cond ((eq *glfirst* '\')
                          (cond ((setq tmp (glsepnxt))
                                 (setq *glfirst* (glsepnxt))
                                 (return (list (kwote tmp)
                                               'atom)))
                                (*glexpr* (setq *glfirst* nil)
                                          (setq tmp (pop *glexpr*))
                                         (return (list (kwote tmp)
                                                  (glconstanttype tmp))))
                                (t (return))))
                         ((eq *glfirst* 'the)
                          (setq tmp (glthe nil))
                          (setq *glfirst* nil)
                          (return tmp))
                         ((not (eq *glfirst* '\:))
                          (setq prev *glfirst*)
                          (setq *glfirst* (glsepnxt)))))
      a
      (if (eq *glfirst* '\:)
          (when (setq field (glsepnxt))
                (setq prev (glgetfield prev field *glcontext*))
                (setq *glfirst* (glsepnxt))
                (go a))
          (return (if (eq prev '*nil*)
                      (list nil nil)
                      (glidname prev t))))))


; edited: 20-MAY-82 11:30 
; Parse a field specification which may be preceded by a ~. 
(defun glparsnfld nil
(prog (tmp uop)
      (if (or (eq *glfirst* '~)
              (eq *glfirst* '-))
          (progn (setq uop *glfirst*)
                 (cond ((setq *glfirst* (glsepnxt))
                        (setq tmp (glparsfld nil)))
                       ((and *glexpr* (atom (car *glexpr*)))
                        (glsepinit (pop *glexpr*))
                        (setq *glfirst* (glsepnxt))
                        (setq tmp (glparsfld nil)))
                       ((and *glexpr* (consp (car *glexpr*)))
                        (setq tmp (glpushexpr (pop *glexpr*)
                                              t *glcontext* t)))
                       (t (return (list uop nil))))
                 (return (if (eq uop '~)
                             (glnotfn tmp)
                             (glminusfn tmp))))
          (return (glparsfld nil)))))


; 4-May-89; 14 Nov 89; 07 Feb 91; 14 Aug 92; 20 Dec 92; 20 Dec 96
; 27 Dec 96; 20 Sep 06; 21 Sep 06
; Initialize patterns for use in code optimization. 
; Note that pattern variables K, L, M and N are numeric constants. 
(defun glpatinit nil
(gldefpatterns 'glpatterns
               '(((if (not ?x) ?a ?b)     (if ?x ?b ?a))
             ;   ((if (null ?x) ?a ?b)    (if ?x ?b ?a))   ; commented out
                 ((equal ?x nil)        (null ?x))
                 ((equal nil ?x)        (null ?x))
                 ((eq ?x nil)           (null ?x))
                 ((eq nil ?x)           (null ?x))
                 ((eql ?x nil)          (null ?x))
                 ((eql nil ?x)          (null ?x))
                 ((equal ?x 0)          (zerop ?x))
                 ((eql ?x 0)            (zerop ?x))
                 ((equal 0 ?x)          (zerop ?x))
                 ((eql 0 ?x)            (zerop ?x))
                 ((not (not ?x))        ?x)
             ;   ((not (null ?x))       ?x) ; okay for Lisp, but a problem in
                                            ; translating to other languages
                 ((null (not ?x))       ?x)
             ;   ((null (null ?x))      ?x)   ; commented out
                 ((+ ?x 0)              ?x) 
                 ((+ 0 ?x)              ?x)
                 ((- ?x 0)              ?x)
                 ((- 0 ?x)              (- ?x))
                 ((+ ?x 0.0)            ?x) 
                 ((+ 0.0 ?x)            ?x)
                 ((- ?x 0.0)            ?x)
                 ((- 0.0 ?x)            (- ?x))
                 ((* ?x 1)              ?x)
                 ((* ?x 1.0)            ?x)
                 ((* 1 ?x)              ?x)
                 ((* 1.0 ?x)            ?x)
                 ((* ?x 0)              0)
                 ((* 0 ?x)              0)
                 ((* ?x 0.0)            0)
                 ((* 0.0 ?x)            0)
                 ((- (- ?x))            ?x)
                 ((car (list ?x ?y))     (prog1 ?x ?y))
                 ((cdr (list ?x ?y))     (progn ?x (list ?y)))
                 ((cadr (list ?x ?y))    (progn ?x ?y))
                 ((car (list ?x ?y ?z))   (prog1 ?x ?y ?z))
                 ((cdr (list ?x ?y ?z))   (progn ?x (list ?y ?z)))
                 ((caddr (list ?x ?y ?z)) (progn ?x ?y ?z))
                 ((cadddr (list ?x ?y ?z ?w))  (progn ?x ?y ?z ?w))
                 ((car (cons ?x ?y))     (prog1 ?x ?y))
                 ((cdr (cons ?x ?y))     (progn ?x ?y))
                 ((+ ?x ?n)              (+ ?n ?x)    (numberp ?n))
                 ((+ ?n (- ?x ?m))        (+ (- ?n ?m) ?x)
                                            (and (numberp ?n) (numberp ?m)))
                 ((+ ?n (+ ?m ?x))        (+ (+ ?n ?m) ?x)
                                            (and (numberp ?n) (numberp ?m)))
                 ((+ (/ ?x ?y) (/ ?z ?y))  (/ (+ ?x ?z) ?y))
                 ((+ (* ?x ?y) (* ?z ?y))  (* (+ ?x ?z) ?y))
                 ((+ (* ?y ?x) (* ?y ?z))  (* ?y (+ ?x ?z)))
                 ((- (+ ?n ?x) (+ ?m ?y))  (+ (- ?n ?m) (- ?x ?y))
                                            (and (numberp ?n) (numberp ?m)))
                 ((- (+ ?n ?x) (+ ?m ?y))  (+ (- ?n ?m) (- ?x ?y))
                                            (and (numberp ?n) (numberp ?m)))
                 ((- (- ?x ?y) (- ?x ?z))  (- ?z ?y))
                 ((- (- ?y ?x) (- ?z ?x))  (- ?y ?z))
                 ((* ?x ?n)              (* ?n ?x)    (numberp ?n))
                 ((- (/ ?x ?n) (/ ?y ?n))  (/ (- ?x ?y) ?n)    (numberp ?n))
                 ((* ?n (* ?m ?x))        (* (* ?n ?m) ?x)
                                            (and (numberp ?n) (numberp ?m)))
                 ((* ?n (/ ?x ?m))        (* (/ ?n ?m) ?x)
                                            (and (numberp ?n) (numberp ?m)))
                 ((> (+ ?n ?x) ?m)        (> ?x (- ?m ?n))
                                            (and (numberp ?n) (numberp ?m)))
                 ) ))


; 11 Nov 91; 18 Nov 91; 12 Dec 91; 06 Jan 92; 18 Feb 92; 27 Feb 94; 29 Apr 94
; 21 Sep 06
; Test an arithmetic pattern by running on examples
(defun glpattest (pat)
  (let (vars bindings bad before after rnum)
    (if (member (caar pat) '(+ - * / expt sqrt cbrt < <= = >= > \=))
        (progn
          (setq vars (glvarsin (car pat)))
          (dotimes (i 10)
            (setq bindings nil)
            (dolist (var vars)
              (setq rnum (random 100))
              (push (cons var
                          (if (member var '(?ll))
                            (> rnum 49)         ; use boolean value for ?ll
                            (if (= rnum 50) 1 (- rnum 50)))) ; avoid / 0 -Sayrs
                    bindings))
            (if (or (null (third pat))
                    (eval (sublis bindings (third pat))))
                (progn
                  (setq before (eval (sublis bindings (first pat))))
                  (setq after (eval (sublis bindings (second pat))))
                  (when (not (or (equal before after)
                                 (and (or (floatp before) (floatp after)
                                          (complexp before) (complexp after))
                                      (< (abs (- before after)) 0.000001))))
                    (unless bad
                      (format t "Bad pattern: ~A ~%   bindings: ~A~%"
                              pat bindings))
                    (setq bad t))) ) )
          (not bad))
        t) ))


; 27-MAY-82; 27 Oct 94
; Form the plural of a given word. 
(defun glplural (word)
  (let (front n ending)
    (or (glgetplural word)
        (progn
          (setq front (symbol-name word))
          (setq n (length front))
          (cond ((and (char= (char front (1- n)) #\Y)
                      (not (member (char front (- n 2))
                                   '(#\A #\E #\O #\U) :test #'char=)))
                  (setf front (subseq front 0 (1- n)))
                  (setq ending "IES"))
                ((member (char front (1- n))
                         '(#\S #\X) :test #'char=)
                  (setq ending "ES"))
                (t (setq ending "S")))
          (intern (concatenate 'string front ending)) ) ) ))


; 15 May 90; 11 Jun 90
; Test if a type is a pointer type.
(defun glpointerp (pointertype)
  (let (str)
    (or (glpointsto pointertype)
        (and (symbolp pointertype)
             (setq str (glstructure pointertype))
             (some #'glpointerp (glsupers str)) )) ))


; 13 Apr 90; 27 Apr 90; 15 May 90; 18 May 90; 21 May 90; 24 May 90; 07 Feb 91
; 15 Nov 93; 12 Nov 96
; Get the type associated with a given pointer type
(defun glpointsto (pointertype)
  (let (str lst dtype)
    (or (and (consp pointertype)
             (eq (car pointertype) '^)
             (cadr pointertype))
        (and (symbolp pointertype)
             (setq str (glstructure pointertype))
             (consp (car str))
             (or (and (eq (caar str) '^)
                      (symbolp (cadar str))
                      (cadar str))
                 (and (eq (caar str) 'listof)
                      pointertype)))
        (and (glstr pointertype)
             (setq lst (glstrprop pointertype 'prop 'dereference nil))
             (setq dtype (getf (cddr lst) 'result))
             (if (symbolp dtype)
                 dtype
                 (if (and (consp dtype)
                          (eq (car dtype) 'clustertype)
                          (equal (cadr dtype) '(typeof self))
                          (quotep (caddr dtype)) )
                     (glclusterrole (glcluster pointertype) (cadadr dtype))
                     t)))
        (and lst (consp (cadr lst)) (consp (caadr lst))
             (eq (caaadr lst) 'virtual)
             (cadr (caadr lst))) ) ))


; 18 May 90
; Get the type directly pointed to, i.e., if the storage structure
; is (^ <record>), return <record>.
(defun glpointstosimply (pointertype)
  (let (str)
    (and (symbolp pointertype)
         (setq str (glstructure pointertype))
         (consp (car str))
         (or (and (eq (caar str) '^)
                  (symbolp (cadar str))
                  (cadar str))
             (and (eq (caar str) 'listof)
                  pointertype))) ))


; 29-DEC-82; 19 Jan 90; 03 Nov 92; 18 Jan 94; 15 Feb 10
; Produce a function to implement the -_ (pop) operator. Code is 
;   produced to remove one element from the right-hand side and assign 
;   it to the left-hand side. 
(defun glpopfn (lhs rhs)
  (prog (rhsdes popcode getcode tmp str)
    (setq rhsdes (glxtrtype (cadr rhs)))
    (cond ((member rhsdes '(integer number real))
            (return (glremovefn lhs rhs)) )
          ((and (consp rhsdes)
                (eq (car rhsdes) 'listof))
            (setq getcode (glputfn lhs (list (list 'pop (car rhs))
                                             (cadr rhsdes))
                                   nil)))
          ((eq rhsdes 'boolean)
            (setq popcode (glputfn rhs '(nil nil) nil))
            (setq getcode (glputfn lhs rhs nil)))
          ((setq tmp (gldomsg rhs '-_ (list lhs)))
            (return tmp))
          ((and (setq str (glgetstr rhsdes))
                (not (equal str (cadr rhs)))
                (setq tmp (glpopfn lhs (list (car rhs) str))))
            (return tmp))
          ((setq tmp (gluserstrop rhs '-_ lhs))
            (return tmp))
          ((or (glatomtypep rhsdes)
               (and (not (eq rhsdes 'anything))
                    (glbasictypep (glxtrtypeb rhsdes))))
            (return))
; if all else fails, assume a list. 
          (t (setq getcode (glputfn lhs (list (list 'pop (car rhs))
                                              (cadr rhsdes))
                                    nil))))
    (return (list (if popcode (list 'prog1 (car getcode) (car popcode))
                      (car getcode))
                  (cadr getcode))) ))

;  Result type for POP  09 Aug 89; 05 Jan 00
(defun glpopresulttypefn (fn argtypes)     (declare (ignore fn))
  (let (tmp)
    (if (and (consp (setq tmp (glxtrtypeb (car argtypes))))
             (member (car tmp) '(listof list)))
        (cadr tmp)) ))


; 30-OCT-82; 28 Dec 94; 26 Feb 02; 12 Mar 02
; Precedence numbers for operators 
(defun glprec (op)
  (or (cdr (assoc op '((\:= . 1) (= . 1) (__ . 1)  (_+ . 2) (__+ . 2)
                       (+_ . 2)  (_+_ . 2) (_- . 2) (__- . 2)
                       (-_ . 2)  (=+ . 2) (+= . 2)  (=- . 2)  (-= . 2)
                       (== . 5)   (!= . 5) (<> . 5)
                       (and . 4) (or . 3)  (/ . 7)  (* . 7)
                       (+ . 6)   (- . 6)   (> . 5)  (< . 5)
                       (>= . 5)  (<= . 5)  (^ . 8))))
      10))

; 17-Mar-89; 14 Oct 92; 29 Dec 94; 06 Nov 06
; Get a predicate specification from the *GLEXPR* (referenced globally)
; and return code to test the SOURCE for that predicate.
; VERBFLG is true if a verb is expected as the top of EXPR. 
(defun glpredicate (source *glcontext* verbflg *gladdisatype*)
  (let (newpred setname property tmp notflg descen str)
    (cond ((null verbflg)
            (setq newpred (gldoexpr nil *glcontext* t)))
          ((null source)
             (glerror 'glpredicate
              "The object to be tested was not found.  EXPR =  ~A " *glexpr*))
          ((eq (car *glexpr*) 'has)
            (pop *glexpr*)
            (when (eq (car *glexpr*) 'no)
                  (setq notflg t)
                  (pop *glexpr*))
            (setq newpred (gldoexpr nil *glcontext* t)))
          ((member (car *glexpr*) '(is are))
            (pop *glexpr*)
            (when (eq (car *glexpr*) 'not)
                  (setq notflg t)
                  (pop *glexpr*))
            (if (gl-a-an? (car *glexpr*))
                (progn (pop *glexpr*)
                       (setq setname (pop *glexpr*))
                       
; the condition is to test whether source is a setname. 

                       (cond ((setq newpred (gladj source setname 'isa)))
                             ((setq newpred (gladj (list (car source) setname)
                                                   setname 'isaself))
                              (glnotesourcetype source setname *gladdisatype*))
                             ((setq tmp (gllispisa setname))
                               (setq newpred (list (glgencode
                                                     (list (car tmp)
                                                           (car source)))
                                                   'boolean))
                               (glnotesourcetype source (cadr tmp)
                                                 *gladdisatype*))
                             ((glclassp setname)
                              ;  (setq descen (gldescendants setname))
                               (if (and ; (or (null descen)
                                        ;     (and (null (cdr descen))
                                        ;        (eq (car descen) setname)))
                                        (setq str (car (glstr setname)))
                                        (consp str)
                                        (member (first str)
                                          '(object listobject atomobject)))
                                   (setq newpred
                                     (list (case (first str)
                                             (object
                                               `(eq (aref ,(car source) 0)
                                                    ', setname) )
                                             (listobject
                                               `(eq (first ,(car source))
                                                    ', setname) )
                                             (atomobject
                                               `(eq (get ,(car source) 'class)
                                                    ',setname) ))
                                           'boolean))
                                   (setq newpred (list (list 'glclassmemp
                                                             (car source)
                                                             (kwote setname))
                                                       'boolean)))
                               (glnotesourcetype source setname
                                                 *gladdisatype*))
                             (t (glerror 'glpredicate
    "IS A adjective  ~A  could not be found for  ~A  whose type is  ~A "
                                 setname (car source) (cadr source))
                                (setq newpred
                                      (list (list 'glerr (car source)
                                                  'is 'a setname)
                                            'boolean)))))
                (progn (setq property (car *glexpr*))
                       
; the condition to test is whether source is property. 

                       (cond ((setq newpred (gladj source property 'adj))
                               (pop *glexpr*))
                             ((setq tmp (gllispadj property))
                               (pop *glexpr*)
                               (setq newpred (list (glgencode
                                                     (list (car tmp)
                                                           (car source)))
                                                   'boolean))
                               (glnotesourcetype source (cadr tmp)
                                                 *gladdisatype*))
                             (t (glerror 'glpredicate
     "The adjective  ~A  could not be found for  ~A  whose type is  ~A "
                                   property (car source) (cadr source))
                                (pop *glexpr*)
                                (setq newpred
                                      (list (list 'glerr (car source)
                                                  'is property)
                                            'boolean))))))))
    (setq newpred (cons (glevalpred (car newpred) *glcontext*)
                        (cdr newpred)))
    (if notflg (list (glbuildnot (car newpred)) 'boolean)
               newpred)))


; edited: 24-Sep-88; 12 Oct 90; 24 Oct 90; 26 Feb 91; 14 Jan 92; 11 Mar 92
; 01 Oct 96
; Compile an implicit PROGN, that is, a list of items. 
(defun glprogn (*glexpr* *glcontext*)
  (let (result tmp type *glsepatom* *glsepptr*)
    (setq *glsepptr* 0)
    (while *glexpr*
      (if (setq tmp (gldoexpr nil *glcontext* *glvalbusy*))
          (unless (eq tmp '*nil*) (push (glunstoretrap tmp) result))
          (progn (glerror 'glprogn
                      "Illegal item appears in implicit PROGN.  EXPR =  ~A "
                      *glexpr*)
                 (setq *glexpr* nil))))
    (if (and *glvalbusy* (glvvct (car result)))      ; was glviewerct
        (setf (car result)
              (glmaterialize (car result) nil t))) ; 14 Jan 92  was nil t
    (setq type (cadar result))                     ; 11 Mar 92 changed back
    (list (mapcar #'car (nreverse result)) type) ))

; 11 Oct 93
(defun glprognresulttypefn (fn argtypes)     (declare (ignore fn))
  (glxtrtype (car (last argtypes))) )

; 11 Oct 93
(defun glprog1resulttypefn (fn argtypes)     (declare (ignore fn))
  (glxtrtype (car argtypes)) )


; 1-Oct-86; 26 Mar 93
; Get the definition of a glisp object property if defined.  See also glopdef
(defun glpropdef (type proptype propname)
  (let (pl subpl)
    (and (symbolp type)
         (setq pl (glstr type))
         (or (and (setq subpl (getf (cdr pl) proptype))
                  (assoc propname subpl))
             (some #'(lambda (super) (glpropdef super proptype propname))
                   (getf (cdr pl) 'supers))))))


; 15 Aug 96
; Get a list of prop names for a given type
(defun glpropnames (obj proptype)
  (let (result)
    (when (glclassp obj)
      (setq result (mapcar #'car (glget obj proptype)))
      (dolist (s (glget obj 'supers))
        (setq result (nconc result (glpropnames s proptype))))
      result) ))


; 17 Jul 90; 09 Mar 94; 15 Aug 96; 09 Jan 08; 15 Jan 10
; Get a list of prop names and types from a given structure description.
; cf. gevpropnames
(setf (glfnresulttype 'glpropnametypes) '(listof glnametype))
(defun glpropnametypes (obj proptype)
  (if (glclassp obj)
    (let (result)
      (when (not (glgenericstrp obj))
        (setq result
              (mapcar #'(lambda (p) (list (car p)
                                          (gevproptypes obj proptype (car p))))
                      (glget obj proptype)))
        (dolist (s (glget obj 'supers))
          (setq result (nconc result (glpropnametypes s proptype))))
        result) ) ) )


; 17 Jul 90; 09 Mar 94; 15 Aug 96; 20 Feb 07; 06 Mar 07; 09 Jan 08
; Get a list of prop names and types from a given structure description.
; same as glpropnametypes, but does not use gevproptypes (which compiles
; a prop to get its type), avoiding a loop in glequationprop.
; cf. gevpropnames
(defun glpropnametypesb (obj proptype)
  (if (glclassp obj)
    (let (result)
      (setq result
            (mapcar #'(lambda (p) (list (car p)
                                        (glproptype obj proptype (car p))))
                    (glget obj proptype)))
      (dolist (s (glget obj 'supers))
        (setq result (nconc result (glpropnametypesb s proptype))))
      result)))


; Edited 19-Oct-87; 19 Jan 90; 09 Apr 92; 20 Nov 07; 05 Jan 10
; Create a function call to retrieve the field IND from a property-list type
; structure DES.  FLG is true if a PROPLIST is inside an ATOM structure.
; For tuples, the form is (tuple (ind (code type))*) and it will not
; search below ind, but just return (code type) if ind matches.
(defun glpropstrfn (ind des deslist flg)
  (prog (desind tmp recname n)
  
; handle a proplist by looking inside each property for ind. 

  (if (and (member (setq desind (pop des)) '(record crecord))
           (symbolp (car des)))
      (setq recname (pop des)))
  (setq n 0)
 p
  (cond ((null des) (return))
        ((and (consp (car des))
              (symbolp (caar des))
              (cdar des)
              (setq tmp
                    (if (eq desind 'tuple)
                        (if (eq (caar des) ind)
                            (return (list (glgencode
                                           (list 'tupleget '*gl*
                                                 (kwote (caar des))))
                                          (cadar des))))
                        (glstrfn ind (car des) deslist))))
          (setq tmp
                (glstrval tmp
                          (case desind
                                (alist (list 'glgetassoc
                                             (kwote (caar des))
                                             '*gl*))
                                ((record object)
                                  (if (eq desind 'object) (incf n))
                                  (list 'aref '*gl* n))
                                (crecord
                                  (list 'glcfield '*gl* (kwote (caar des))))
                                ((proplist atomobject)
                                 (glgencode
                                  (list (if (or flg (eq desind 'atomobject))
                                            'get 'getf)
                                        '*gl*
                                        (kwote (caar des))))))))
          (return tmp))
        (t (pop des) (incf n) (go p)))))


; 20 Feb 07; 29 Nov 07; 04 Dec 07; 09 Jan 08
; Find the type of a computed property, without compiling it.  cf. gevproptype
(defun glproptype (str proptype propname)
  (let (pl subpl propent tmp)
    (when (symbolp str)
      (setq propent (glgetprop str proptype propname))
      (or (and (consp propent)
               (getf (cddr propent) 'result))
          (and (consp propent)
               (symbolp (cadr propent))
               (glresulttype (cadr propent) nil))
          (and (consp propent)
               (consp (cadr propent))
               (consp (caadr propent))
               (eq (caaadr propent) 'virtual)
               (cadr (caadr propent)))
          (and (consp propent)
               (consp (cadr propent))
               (consp (caadr propent))
               (symbolp (caaadr propent))
               (fboundp (caaadr propent))
               (glresulttype (caaadr propent) nil))  ; argtypes nil ?
          (and (setq pl (get str 'glpropfns))
               (setq subpl (assoc proptype pl))
               (setq propent (assoc propname (cdr subpl)))
               (caddr propent))
          (and (eq proptype 'adj)
               'boolean) ) ) ))


; edited:  16 Aug 89; 09 Nov 89; 14 Nov 89; 30 Apr 91; 11 Mar 92; 20 Sep 06
; Try to match INP against optimization patterns. If a match is found, 
;   the right-hand side of the pattern is returned with appropriate 
;   substitutions.  Pattern vars k, l, m, n match only numbers.
; A pattern has the form (pattern new-pattern substitutions)
;   e.g.  ((not (not x)) x)
(defun glptmatch (inp patwd)
  (let (res)
    (if (and (consp inp)
             (symbolp (car inp))
             (some #'(lambda (pat)
                       (not (eq (setq res (transf pat inp))
                                'match-failure)))
                   (get (car inp) patwd)))
        res
        inp) ))


; 07 Apr 92; 15 Oct 92; 20 Sep 06; 21 Sep 06
; Match an input against patterns.  If a match is found, returns a list
; of the bindings and the second half of the pattern.
(defun glptmatchc (inp patwd)
  (let (bindings respat)
    (if (and (consp inp)
             (symbolp (car inp))
             (some #'(lambda (pat)
                       (if (and (setq bindings (match (car pat) inp))
                                (or (null (third pat))
                                    (eval (sublisq bindings (third pat)))))
                           (setq respat pat)))
                   (get (car inp) patwd)))
        (list bindings (cadr respat)) ) ))


; 26 Apr 94
(defun glptnumberval (x)
  (let (v)
    (setq v (glnumberval x))
    (if (and (consp v) (eq (car v) 'q))
        (kwote v)
        v)))

; edited: 25-MAY-82 16:10 
; This function serves to call GLDOEXPR with a new expression, 
;   rebinding the global variable EXPR. 
(defun glpushexpr (*glexpr* start *glcontext* *glvalbusy*)
(let (*glsepatom* *glsepptr*)
     (setq *glsepptr* 0)
     (gldoexpr start *glcontext* *glvalbusy*)))


; 25-JAN-83; 19 May 93
; Produce a function to implement the +_ operator. Code is produced to 
; push the right-hand side onto the left-hand side. Note: parts of 
; the structure provided are used multiple times. 
(defun glpushfn (lhs rhs)
  (prog (lhscode lhsdes nccode tmp str)
    (setq lhscode (car lhs))
    (setq lhsdes (glxtrtype (cadr lhs)))
    (cond ((eq lhsdes 'integer)
             (cond ((eql (car rhs) 1) (setq nccode (list '1+ lhscode)))
                   ((or (integerp (car rhs))
                        (eq (cadr rhs) 'integer))
                    (setq nccode (list '+ lhscode (car rhs))))
                   (t (setq nccode (list '+ lhscode (car rhs))))))
          ((or (eq lhsdes 'number)
               (eq lhsdes 'real))
            (setq nccode (list '+ lhscode (car rhs))))
          ((eq lhsdes 'boolean) (setq nccode (list 'or lhscode (car rhs))))
          ((null lhsdes)
            (setq nccode (list 'cons (car rhs) lhscode))
            (if (and (symbolp lhscode)
                     (cadr rhs))
                (glupdatevartype lhscode (list 'listof (cadr rhs)))))
          ((and (consp lhsdes)
                (member (car lhsdes) '(list cons listof)))
            (setq nccode (list 'cons (car rhs) lhscode)))
          ((setq tmp (glunitop lhs rhs 'push))
            (return tmp))
          ((setq tmp (gldomsg lhs '+_ (list rhs)))
            (return tmp))
          ((setq tmp (gldomsg lhs '+ (list rhs)))
            (setq nccode (car tmp)))
          ((and (setq str (glgetstr lhsdes))
                (not (and (consp str) (eq (car str) '^)))
                (setq tmp (glpushfn (list (car lhs) str) rhs)))
            (return (list (car tmp) (cadr lhs))))
          ((setq tmp (gluserstrop lhs '+_ rhs))
            (return tmp))
          ((setq tmp (glreducearith '+ rhs lhs))
            (setq nccode (car tmp)))
          (t (return)))
    (return (glputfn lhs (list (glgencode nccode) lhsdes) t))))

; 09 Aug 89
; Result type for POP
(defun glpushresulttypefn (fn argtypes)     (declare (ignore fn))
  (let (itemtype placetype)
    (setq itemtype (glxtrtype (car argtypes)))
    (setq placetype (glxtrtype (cadr argtypes)))
    (if (and (consp placetype)
             (eq (car placetype) 'listof)
             (eq itemtype (cadr placetype)))
        placetype
        (if (null placetype)
            (list 'listof itemtype)
            placetype)) ))


; 29-Dec-87; 6-Mar-89; 25 Feb 92; 11 Mar 92; 19 Nov 92; 29 Apr 94; 20 Sep 06
; 26 Apr 07; 13 Sep 07
; Process a store into a value which is computed by an arithmetic expression.
; Each pattern is of the form:  (lhspattern (var rhspattern))
; where var is the variable for the new lhs and rhspattern is the
; pattern for the new rhs, with ?VAL representing the old rhs. 
(defun glputarith (lhs rhs)
  (let (op asg newasg)
    (when (consp (car lhs))
      (setq op (caar lhs))
      (setq asg (list '= (car lhs) (car rhs)))
      (or (and (member op '(+ - * / truncate round expt sqrt cbrt 1+ 1-))
               (glputarithb lhs rhs))
          (some #'(lambda (rule)
                    (and (setq newasg (transf rule asg))
                         (not (eq newasg 'match-failure))
                         (glputfn (list (cadr newasg) (cadr lhs))
                                  (list (caddr newasg) (cadr rhs))
                                  nil)))
                (get op 'glputarithpatterns))) ) ))


; Edited 6-May-88; 14-Mar-89; 02 May 91
; Do a store into an arithmetic expression 
(defun glputaritha (lhs rhs)
  (let (res)       ;       must do a let if rhs has side-effects ******* 
    (if (setq res (glputarith lhs rhs))
        (list (list 'progn
                    (car res)
                    (if (glconstantp (car rhs))
                        (car rhs)
                        (car lhs)))
              (cadr rhs))) ))


; edited: 3-Oct-88
; Perform a store where LHS and RHS are arithmetic expressions of similar
; form.  To be strictly correct, we should verify that the equivalent parts 
; of the expressions are free of side-effects. 
(defun glputarithb (lhs rhs)
  (if (and (consp (car lhs))
           (consp (car rhs))
           (eq (caar lhs) (caar rhs)))
      (cond ((or (and (null (cdar lhs))
                      (null (cdar rhs)))
                 (equal (caddar lhs) (caddar rhs)))
             (glputfn (list (cadar lhs) (cadr lhs))
                      (list (cadar rhs) (cadr rhs))
                      nil))
            ((equal (cadar lhs) (cadar rhs))
             (glputfn (list (caddar lhs) (cadr lhs))
                      (list (caddar rhs) (cadr rhs))
                      nil)))))


; 19-Oct-87; 19 July 89; 18 Oct 89; 08 Nov 89; 06 Apr 90; 19 Jul 90
; 02 May 91; 09 Sep 91; 09 Apr 92; 16 Apr 92; 17 Apr 92; 30 Apr 92; 11 Oct 92
; 12 Oct 92; 05 Nov 92; 09 Nov 92; 10 Nov 92; 07 Sep 93; 27 Dec 93; 05 Oct 95
; 30 Nov 95; 02 Apr 99; 01 Jul 04; 21 Apr 09
; Create code to put the right-hand side datum RHS into the left-hand 
;   side, whose access function and type are given by LHS. 
(defun glputfn (lhs rhs optflg)
  (prog ((lhscode (car lhs)) (lhstype (cadr lhs)) newrhs
         (rhscode (car rhs)) (rhstype (cadr rhs)) lname tmp result tmpb)
    (cond ((glviewerct lhs)      (return (glviewerput lhs rhs)))
          ((glvirtualct lhs)     (return (glvirtualput lhs rhs)))
          ((gltupletest lhs rhs) (return (glputtuple lhs rhs))) )
    (if (or (glvvct rhs)
            (and (glviewtypep rhstype)
                 (equal lhstype (glviewtypep rhstype))))
        (setq rhs (glmaterialize rhs
                                 (or lhstype
                                     (glviewtypegoal (glviewtypep rhstype)))
                                 nil)))
    (if (and (consp lhstype)                                ; 19 Jul 90
             (eq (car lhstype) '^.)
             (glpointerp (cadr lhstype)))
        (return (glputfn (or (and (setq tmpb (glpointstosimply (cadr lhstype)))
                                  (glstoragestrp tmpb)
                                  (list lhscode tmpb))
                             (glvalue lhscode 'dereference (cadr lhstype) nil)
                             (and tmpb (list lhscode tmpb)))
                          rhs optflg)))
    (if (and (consp rhstype)                                ; 19 Jul 90
             (eq (car rhstype) '^.)
             (glpointerp (cadr rhstype)))
        (return (glputfn lhs (or (and (setq tmpb (glpointstosimply
                                                  (cadr rhstype)))
                                      (glstoragestrp tmpb)
                                      (list rhscode tmpb))
                                 (glvalue rhscode 'dereference
                                          (cadr rhstype) nil)
                                 (and tmpb (list rhscode tmpb)))
                         optflg)))
    (if (and (not (equal lhstype rhstype))
             (setq newrhs (glcoercedata lhstype rhs)))
        (progn (setq rhs newrhs)
               (setq rhscode (car rhs))
               (setq rhstype (cadr rhs)) ) )
    (if (symbolp lhscode)
        (cond ((setq tmp (or (and (glispcp)
                                  (gldomsg lhs '_ (list rhs)))
                             (gluserstrop lhs '_ rhs)
                             (and (null lhstype)
                                  rhstype
                                  (gluserstrop (list lhscode rhstype) '_ rhs))
                             (and (not (equal lhstype rhstype))
                                  (glcoercearith '= lhs rhs))))
                (return tmp))
; This code causes problems: e.g. in drawtrans.lsp (new = (draw-box-get dd w))
; where new is a draw-object and draw-box-get returns a draw-box, which is a
; subclass of draw-object.  The following generates transfer code, although the
; structure new does not exist.
; Note: could use the following code to transfer structures in parts
; rather than just copying pointers, for languages other than Lisp.
;             ((and (glispcp)
;                   (not (or (glbasictypep lhstype)
;                            (glbasictypep rhstype)
;                            (equal (glxtrtype lhstype)
;                                   (glxtrtype rhstype))))
;                   (setq tmp (gltypeint lhstype rhstype))
;                   (consp (glgetfields tmp)))
;               (return (glmacroexp '(glambda (tp u v)
;                                      (for p in (components tp)
;                                        ((funcall p u) = (funcall p v))))
;                                   (list (list (kwote tmp) 'gltype)
;                                         lhs rhs))))
              (t (return (gldovarsetq lhscode rhs)))))
    (if (or (constantp lhscode)
            (not (consp lhscode)))
        (return (glerror 'glputfn "Illegal assignment.  LHS =  ~A  RHS =  ~A "
                         lhs rhs)))
    (setq lname (car lhscode))
    (if (or (and (eq lname 'prog1)
                 (null (cddr lhscode)))
            (and (eq lname 'prog)
                 (setq lhscode (glunwraptop lhscode t))
                 (not (eq lhscode (car lhs)))))
        (return (glputfn (cons (cadr lhscode) (cdr lhs)) rhs optflg)) )     
    (cond ((eq lname 'glstoretrap)
            (return (gldomsg (list (third lhscode) (fourth lhscode))
                             (fifth lhscode) (list rhs))))
          ((and (not (equal lhstype rhstype))
                (setq tmp (glcoercearith '= lhs rhs)))
            (return tmp))
          ((glsetfable lname)
            (setq result (list 'setf lhscode rhscode)))
          ((eq lname 'glgetassoc)
            (setq result (list 'putassoc (cadr lhscode) rhscode
                               (caddr lhscode))))
          ((eq lname 'eval) (setq result (list 'set (cadr lhscode) rhscode)))
          ((eq lname 'glsendp)
            (setq result
                  (list 'glsendps (cadr lhscode)
                        (kwote (intern (concatenate 'string
                                  (symbol-name (cadr (caddr lhscode))) ":")))
                        rhscode)))
          ((eq lname 'glrepresentation)
            (return (if (and (consp rhscode)
                             (eq (car rhscode) 'glrepresentation) ; if same reps
                             (equal (cadr (caddr lhscode))     ; transfer as is
                                    (cadr (caddr rhscode))))
                        (glputfn (caddr lhscode) (caddr rhscode) optflg)
                        (if (setq tmp
                              (gldomsg (caddr lhscode) 'representation\:
                                       (list rhs)))
                            (glputfn (caddr lhscode) tmp optflg)
                            (glputfn (list (cadr lhscode) lhstype)
                                     rhs optflg)))))
          ((setq tmp (glunitop lhs rhs 'put)) (return tmp))
          ((and (glispcp)
                (setq tmp (or (gldomsg lhs '_ (list rhs))
                              (gluserstrop lhs '_ rhs)
                              (glputaritha lhs rhs))))
            (return tmp))
; Test if what is being compiled is ((p x) = ...) and a p: msg is defined
          ((and (eq lhscode *gllastpropcode*)               ; 10 Nov 92
                (setq result (gldomsg *gllastproparg*
                                      (gladdcolon *gllastpropname*)
                                      (list rhs))))
            (return result))
;   Maybe this should be commented out, but since the alternative
;   is an error, it is left in.     GSN     19 July 89     *****
          ((setq tmp (gltypeint lhstype rhstype))
            (return (glmacroexp '(glambda (tp u v)
                                          (for p in (components tp)
                                            ((funcall p u) = (funcall p v))))
                                (list (list (kwote tmp) 'gltype) lhs rhs))))
          (t (glerror 'glputfn "Illegal assignment.  LHS =  ~A  RHS =  ~A "
                      lhs rhs)))
    (if result
        (return (list (glgencode result) (or lhstype rhstype)))) ))


; 30 Oct 91; 14 Sep 06
; Modify code, expressed as a lambda function to get a property from an
; object, so that it stores a value for the property instead.
(defun glputlambda (codetype)
  (let (code type lastcode valvar putcode)
    (setq code (copy-tree (car codetype)))
    (setq type (cadr codetype))
    (setq lastcode (last code))
    (setq valvar (glgensym 'glvar))
    (when (setq putcode (glputfn (list (car lastcode) type)
                                 (list valvar type) t))
          (rplaca lastcode (car putcode))
          (nconc (cadr code) (list valvar))
          (list code type)) ))


; edited: 16-Mar-89; 03 Oct 90
; This function builds the property list for ATOMNAME
(defun glputprops (proplis pairlist prevlst)
  (let (tmpcode puts)
     (dolist (prop proplis)
       (if (setq tmpcode (glbuildstr prop pairlist prevlst))
           (setq puts (cons (kwote (car prop))
                            (cons tmpcode puts))) ) )
     (glgencode (list 'setf (list 'symbol-plist 'atomname)
                            (cons 'list puts))) ))


; 08 Nov 89; 06 Apr 90; 04 Feb 91; 05 Feb 91; 14 Sep 06
; Move data from one tuple to another by components.
; Expected form is ((TUPLE <code1> ...) (TUPLE (<name1> <type1>) ...))
(defun glputtuple (lhs rhs)
  (let (res varvals (lhscode (first lhs)) (lhstype (second rhs))
                    (rhscode (first rhs)) (rhstype (second lhs))
                    pos rc rt)
    (if (eq (car lhscode) 'let)
        (progn (setq varvals (second lhscode))
               (setq lhscode (third lhscode))) )
    (if (eq (car rhscode) 'let)
        (progn
          (if (eq (caar (second rhscode))
                  (caar varvals))
              (setq rhscode (subst (glgensym 'glvar) (caar (second rhscode))
                                   rhscode)))
          (push (car (second rhscode)) varvals) 
          (setq rhscode (third rhscode))) )
    (unless (and (eq (car lhscode) 'tuple)
                 (eq (car rhscode) 'tuple))
      (error "Bad args to glputtuple ~%~A~%~A~%" lhs rhs))
    (if (equal lhstype rhstype)
        (setq res (mapcar #'(lambda (lc lt rc rt)
                              (car (glputfn (list lc lt) (list rc rt) nil)))
                          (cdr lhscode) (cdr lhstype)
                          (cdr rhscode) (cdr rhstype)))
 ; match up tuples by corresponding names.
        (do ((lc (cdr lhscode) (cdr lc))
             (lt (cdr lhstype) (cdr lt)))
          ((null lc) (setq res (nreverse res)))
          (when (setq pos (position (car lt) (cdr rhstype)
                                    :test #'(lambda (x y)
                                              (and (consp x) (consp y)
                                                   (eq (first x) (first y))))))
                (setq rc (nth pos (cdr rhscode)))
                (setq rt (nth pos (cdr rhstype)))
                (push (car (glputfn (list (car lc) (car lt)) (list rc rt) nil))
                      res))) )    
    (list (if varvals
              (list 'let varvals (glgenprogn res))
              (glgenprogn res))
          nil) ))


; edited: 12-Jun-87; 05 Dec 89; 11 Feb 00; 01 Jul 04
; This function implements the __ operator, which is interpreted as 
;   assignment to the source of a variable (usually self) outside an 
;   open-compiled function. Any other use of __ is illegal. 
; ***** The __- operator probably does not work properly with this 
;   code. ***** 
(defun glputupfn (op lhs rhs)
  (let (tmp tmpop)
    (or (setq tmpop (assoc op '((__ . \:=) (__+ . _+) (__- . _-) (_+_ . +_))))
        (error " ~S  Illegal operator." (list 'glputupfn op)))
    (cond ((and (symbolp (car lhs))
                (boundp '*glselfasglst*)
                (setq tmp (assoc (car lhs) *glselfasglst*)))
           (glreduceop (cdr tmpop)
                       (list (cadr tmp) (cadr lhs))
                       rhs))
          ((and (consp (car lhs))
                (eq (caar lhs) 'prog1)
                (symbolp (cadar lhs)))
             (if (setq tmp (assoc (cadar lhs) *glselfasglst*))
                 (glreduceop (cdr tmpop)
                             (list (cadr tmp) (cadr lhs))
                             rhs)

               (glreduceop (cdr tmpop)
                           (list (cadar lhs) (cadr lhs))
                           rhs)))
          ((and (consp (car lhs))
                (glsetfable (caar lhs)))
            (glreduceop (cdr tmpop) lhs rhs))
          (t (glerror 'glputupfn
           "A self-assignment __ operator is used improperly.  LHS =  ~A "
           lhs)))))


; 05 Dec 92
; Test for '(q <number> <unit>) form of constant
(defun glqconstantp (x)
  (and (consp x)
       (eq (car x) 'quote)
       (consp (cadr x))
       (eq (caadr x) 'q)
       (consp (cdadr x))
       (numberp (cadadr x)) ) )


; 30-OCT-82; 02 May 91; 07 May 91
; Reduce the operator on *GLPARSOPERS* and the operands on 
; *GLPARSOPNDS* (in GLPARSEXPR) and put the result back on *GLPARSOPNDS* 
(defun glreduce nil
  (let ( (op (pop *glparsopers*)) (rhs (pop *glparsopnds*)) )
    (push (glreduceb op
                     (if (not (member op '(minus ~)))
                         (pop *glparsopnds*))
                     rhs)
          *glparsopnds*) ))

; 02 May 91; 28 Dec 94; 03 Jan 95; 07 Jun 95; 26 Feb 02; 28 Feb 02; 12 Mar 02
(defun glreduceb (op lhs rhs)
  (unless (member op '(\:= = _+ +_ _- -_ =+ += =- -= __+ __ _+_ __-))
    (setq lhs (glevalcode lhs *glcontext*)))
  (if rhs (setq rhs (glevalcode rhs *glcontext*)))
  (case op ((\:= _+ +_ _- -_ =+ += =- -= = == != <> and or __+ __ _+_ __-)
             (glreduceop op lhs rhs))
           ((+ - * / > < >= <= ^) (glreducearith op lhs rhs))
           (minus (glminusfn rhs))
           (~ (glnotfn rhs))
           (t (list (glgencode (list op (car lhs) (car rhs))) nil)) ) )
         

; 15-Aug-88; 19 Sep 90; 08 Jan 92; 01 Oct 93; 05 Oct 95; 09 Feb 99
; 01 Apr 99; 26 Feb 02; 27 Sep 07; 31 Dec 08
; Reduce an arithmetic operator in an expression. 
(defun glreducearith (op lhs rhs)
 (prog
  (tmp oplist ioplist predlist numbertypes lhstp rhstp strtp strtpb)
  (setq oplist '((+ . +) (- . -) (* . *) (/ . /) (> . >) (< . <)
                 (>= . >=) (<= . <=) (^ . expt) (== . =) (<> . /=) (!= . /=)))
  (setq ioplist '((+ . +) (- . -) (* . *) (/ . /) (> . >) (< . <)
                  (>= . >=) (<= . <=) (== . =) (!= . /=) (<> . /=)))
  (setq predlist '(> < >= <= = <> !=))
  (setq numbertypes '(integer real number))
  (setq lhstp (glxtrtype (cadr lhs)))
  (setq rhstp (glxtrtype (cadr rhs)))
  (if (or (and (eq lhstp 'integer)
               (eq rhstp 'integer)
               (setq tmp (assoc op ioplist)))
          (and (member lhstp numbertypes)
               (member rhstp numbertypes)
               (setq tmp (assoc op oplist))))
      (return (list (if (and (numberp (car lhs))
                             (numberp (car rhs)))
                        (eval (glgencode (list (cdr tmp)
                                               (car lhs)
                                               (car rhs))))
                        (glgencode (cond ((and (eq (cdr tmp) '+)
                                               (eql (car rhs) 1))
                                          (list '1+ (car lhs)))
                                         ((and (eq (cdr tmp) '-)
                                               (eql (car rhs) 1))
                                          (list '1- (car lhs)))
                                         (t (list (cdr tmp)
                                                  (car lhs)
                                                  (car rhs))))))
                    (cond ((member (cdr tmp) predlist) 'boolean)
                          ((or (eq lhstp 'integer)
                               (eq rhstp 'real))
                            rhstp)
                          (t lhstp)))))
  (cond
    ((and (eq lhstp 'string)
          (eq rhstp 'string))
     (if (setq tmp (assoc op '((+  concatenate string)
                               (>  string>     boolean)
                               (>= string>=    boolean)
                               (<  string<     boolean)
                               (<= string<=    boolean))))
         (return (list (if (eq op '+)
                           (glgencode (list (cadr tmp)
                                            (kwote 'string)
                                            (car lhs)
                                            (car rhs)))
                           (glgencode (list (cadr tmp)
                                        (car lhs)
                                        (car rhs))))
                       (caddr tmp)))
         (return (glerror 'glreducearith
                           " ~A  is an illegal operation for strings." op))))
    ((eq lhstp 'boolean)
     (cond ((not (eq rhstp 'boolean))
            (return (glerror 'glreducearith
                             "Operation on Boolean and non-Boolean")))
           ((member op '(+ * -))
            (return (list (glgencode (case op (+ (list 'or
                                                       (car lhs)
                                                       (car rhs)))
                                           (* (list 'and
                                                    (car lhs)
                                                    (car rhs)))
                                           (- (list 'and
                                                    (car lhs)
                                                    (list 'not
                                                          (car rhs))))))
                          'boolean)))
           (t (return (glerror 'glreducearith
                           " ~A  is an illegal operation for Booleans."
                                     op)))))
    ((and (consp lhstp)
          (eq (car lhstp) 'listof))
     (cond ((and (consp rhstp)
                 (eq (car rhstp) 'listof))
            (unless (equal (cadr lhstp)
                           (cadr rhstp))
                    (return (glerror 'glreducearith
                    "Operations on lists of different types  ~A   ~A "
                                           (cadr lhstp)
                                           (cadr rhstp))))
            (if (setq tmp (assoc op '((+ union)
                                      (- set-difference)
                                      (* intersection))))
                (return (list (glgencode (list (cadr tmp)
                                               (car lhs)
                                               (car rhs)))
                              (cadr lhs)))
                (return (glerror 'glreducearith
                                 "Illegal operation  ~A  on lists." op)) ))
           ((and (glmatch rhstp (cadr lhstp))
                 (member op '(+ - >= )))
            (setq tmp (list (case op (+  'cons)
                                     (-  'remove)
                                     (>= 'member))
                            (car rhs)
                            (car lhs)))
            (if (and (eq (car tmp) 'member)
                     (not (glatomtypep rhstp)))
                (nconc tmp (list :test #'equal)))
            (return (list (glgencode tmp) (cadr lhs))))
           ((setq tmp (glcoercearith op lhs rhs))
            (return tmp))
           (t (return (glerror 'glreducearith "Illegal operation on list.")))))
    ((and (member op '(+ <=))
          (glmatchl lhstp rhstp))
     (return (cond ((eq op '+)
                    (list (glgencode (list 'cons
                                           (car lhs)
                                           (car rhs)))
                          (cadr rhs)))
                   ((eq op '<=)
                    (list (glgencode (if (glatomtypep lhstp)
                                         (list 'member (car lhs) (car rhs))
                                         (list 'member (car lhs) (car rhs)
                                               :test #'equal)))
                          'boolean)))))
    ((and (member op '(+ - >=))
          (setq tmp (glmatchl lhstp rhstp)))
     (return (glreducearith (list (car lhs) (list 'listof tmp))
                            op
                            (list (car rhs) tmp))))
    ((setq tmp (glcoercearith op lhs rhs))
     (return tmp))
    ((setq tmp (gldomsg lhs op (list rhs)))
     (return tmp))
    ((setq tmp (gluserstrop lhs op rhs))
     (return tmp))
    ((or (and (setq strtp (glxtrtypec lhstp))  ; see if op works on reps
              (not (equal strtp lhstp)))
         (and (setq strtpb (glxtrtypec rhstp))
              (not (equal strtpb rhstp))))
     (setq tmp (glreducearith op (list (car lhs) (or strtp lhstp))
                                 (list (car rhs) (or strtpb rhstp))))
     (return (list (car tmp)
                   (if (and (equal (cadr tmp) strtp)    ; 19 Sep 90; 27 Sep 07
                            (not (equal strtp lhstp)))
                       lhstp
                       (if (equal (cadr tmp) strtpb)
                           rhstp
                           (cadr tmp))))))
    ((setq tmp (assoc op oplist))
     (and lhstp rhstp (glerror 'glreducearith
       "Warning: Arithmetic operation on non-numeric args of types:  ~A   ~A "
                                     lhstp rhstp))
     (return (list (glgencode (list (cdr tmp)
                                    (car lhs)
                                    (car rhs)))
                   (if (member (cdr tmp) predlist)
                       'boolean
                       'number))))
    (t (error " ~S  ~S  ~S  ~S " 'glreducearith
              op lhs rhs))) ))


; edited:  8-Oct-88; 01 Jun 90; 02 May 91; 28 Dec 94; 26 Feb 02; 12 Mar 02
; Reduce the operator OP with operands LHS and RHS. 
(defun glreduceop (op lhs rhs)
  (let (tmp)
      (cond ((member op '(\:= =)) (glputfn lhs rhs nil))
            ((setq tmp (assoc op '((_+ . glnconcfn)
                                   (+_ . glpushfn)
                                   (_- . glremovefn)
                                   (-_ . glpopfn)
                                   (=+ . glnconcfn)
                                   (+= . glpushfn)
                                   (=- . glremovefn)
                                   (-= . glpopfn)
                                   (== . glequalfn)
                                   (!= . glnequalfn)
                                   (<> . glnequalfn)
                                   (and . glandfn)
                                   (or . glorfn))))
              (or (funcall (cdr tmp) lhs rhs)
                  (glerror 'glreduceop
  "The operator ~A could not be interpreted for arguments ~A  and ~A "
                                op lhs rhs)))
            ((member op '(__ __+ __- _+_))
              (glputupfn op lhs rhs))
            (t (error " ~S  ~S  ~S  ~S " 'glreduceop op lhs rhs))) ))


; edited: 15-Aug-88 15:50 
; Produce a function to implement the _- operator. Code is produced to 
;   remove the right-hand side from the left-hand side. Note: parts of 
;   the structure provided are used multiple times. 
(defun glremovefn (lhs rhs)
(prog (lhscode lhsdes nccode tmp str)
      (setq lhscode (car lhs))
      (setq lhsdes (glxtrtype (cadr lhs)))
      (cond ((eq lhsdes 'integer)
             (setq nccode (if (eql (car rhs)
                                   1)
                              (list '1-
                                    lhscode)
                              (list '-
                                    lhscode
                                    (car rhs)))))
            ((or (eq lhsdes 'number)
                 (eq lhsdes 'real))
             (setq nccode (list '-
                                lhscode
                                (car rhs))))
            ((eq lhsdes 'boolean)
             (setq nccode (list 'and
                                lhscode
                                (list 'not
                                      (car rhs)))))
            ((or (null lhsdes)
                 (and (consp lhsdes)
                      (eq (car lhsdes)
                          'listof)))
             (setq nccode (list 'remove
                                (car rhs)
                                lhscode)))
            ((setq tmp (glunitop lhs rhs 'remove))
             (return tmp))
            ((setq tmp (gldomsg lhs '_-
                                (list rhs)))
             (return tmp))
            ((setq tmp (gldomsg lhs '-
                                (list rhs)))
             (setq nccode (car tmp)))
            ((setq tmp (glreducearith '-
                                      lhs rhs))
             (return (glputfn lhs tmp t)))
            ((setq tmp (gluserstrop lhs '_-
                                    rhs))
             (return tmp))
            ((and (setq str (glgetstr lhsdes))
                  (setq tmp (glremovefn (list (car lhs)
                                              str)
                                        rhs)))
             (return (list (car tmp)
                           (cadr lhs))))
            (t (return)))
      (return (glputfn lhs (list (glgencode nccode)
                                 lhsdes)
                       t))))

; 30 Dec 94; 03 Jan 95
; Remove SETQ's of a variable from code.
; Assumes only a single var-value pair in SETQ.
(defun glremovesetq (var code)
  (let (tmp)
    (if (atom code)
        code
        (if (symbolp (car code))
            (if (and (member (car code) '(setq setf))
                     (consp (cdr code))
                     (or (eq (cadr code) var)
                         (and (consp (cadr code))
                              (eq (caadr code) 'prog1)
                              (consp (cdadr code))
                              (eq (cadadr code) var))))
                (glremovesetq var (caddr code))
                (progn (setq tmp (glremovesetql var (rest code)))
                       (if (eq tmp (cdr code))
                           code
                           (cons (car code) tmp))))
            (glremovesetql var code))) ))

; 30 Dec 94
; Remove SETQ's of a variable from list of code.  Avoids conses if possible.
(defun glremovesetql (var code)
  (let (firstpart restpart)
    (if code
        (if (atom code)
            code
            (progn (setq firstpart (glremovesetq var (first code)))
                   (setq restpart (glremovesetql var (rest code)))
                   (if (and (eq firstpart (first code))
                            (eq restpart (rest code)))
                       code
                       (cons firstpart restpart))))) ))

; 01 May 92
; Get the 'public' type of a representation if one is defined.
(defun glreptype (reptype)
  (let (propl tmp)
    (if (and (symbolp reptype)
             (glnonbasictypep reptype)
             (setq propl (glstrprop reptype 'prop 'representation nil))
             (setq tmp (glcompprop reptype 'representation 'prop nil)))
        (or (cadr tmp)
            (and (symbolp (car tmp))
                 (glresulttype (car tmp) (list reptype))))
        reptype) ))


; 25 Feb 92; 16 Apr 92
; Get a value from a representation if one is defined.
(defun glrepvalue (res)
  (let (propl tmp)
    (if (and res
             (glnonbasictypep (cadr res))
             (setq propl (glstrprop (cadr res) 'prop 'representation nil))
             (setq tmp (glcompmsgl res 'prop propl nil nil)))
        (list (list 'glrepresentation (car tmp) res)
              (cadr tmp))
        res) ))


; 10 Oct 89; 29 May 95; 08 Oct 02; 25 Mar 08
; Get GLOBAL and RESULT declarations for the GLISP compiler. The 
; property GLRESULTTYPE is the RESULT declaration, if specified; 
; GLGLOBALS is a list of global variables referenced and their types. 
(defun glresglobal (glambdafn)
  (let (resulttype)
    (if (consp (car *glexpr*))
        (cond ((eq (caar *glexpr*) 'result)
                (if (and (glokstr? (cadar *glexpr*))
                         (null (cddar *glexpr*)))
                    (progn (setq resulttype (glevalstr (cadar *glexpr*)
                                                       *gltopctx*))
                           (setf (glfnresulttype glambdafn) resulttype)
                           (pop *glexpr*))
                    (if (and (consp (cadar *glexpr*))
                             (eq (caadar *glexpr*) 'virtual)
                             (glokstr? (cadr (cadar *glexpr*))))
                        (progn
                          (setq resulttype (cadr (cadar *glexpr*)))
                          (setf (glfnresulttype glambdafn) resulttype)
                          (pop *glexpr*))
                        (progn (glerror 'glcomp
                                  "Bad RESULT structure declaration:  ~A "
                                  (car *glexpr*))
                               (pop *glexpr*))))
                (glresglobal glambdafn)
                resulttype)
              ((eq (caar *glexpr*) 'global)
                (setf (glglobals glambdafn)
                      (gldecl (cdar *glexpr*) nil *gltopctx* nil nil))
                (pop *glexpr*)
                (glresglobal glambdafn)))) ))


; 26-MAY-82; 30 Nov 92; 04 Feb 03; 04 Nov 03; 19 Oct 06
; Get the result type for a function which has a GLAMBDA definition. 
(defun glresulttype (fn argtypes)
  (prog (type fndef tmp cntxt done result)
; see if this function has a known result type. 
    (if (symbolp fn)
; if there exists a function to compute the result type, let it do so. 
        (cond ((setq tmp (glresulttypefn fn))
                (return (funcall tmp fn argtypes)))
              ((setq type (glfnresulttype fn)) (return type))
              ((setq tmp (glanycarcdr? fn))
                (return (glcarcdrresulttype tmp (car argtypes))))
              (t (setq fndef (glgetd fn))))
        (setq fndef fn))
    (if (or (symbolp fndef) (not (member (car fndef) '(lambda glambda))))
        (return))
    (setq cntxt (list nil))
    (gldecl (cadr fndef) nil cntxt fn argtypes)
    (setq fndef (cddr fndef))
    (while (and (not done) (consp fndef))
      (if (and (consp (car fndef))
               (eq (caar fndef) 'result)
               (glokstr? (cadar fndef)))
          (progn (setq done t)
                 (setq result (gldeclfixstr (cadar fndef) cntxt)) )
          (if (and (consp (car fndef))
                   (eq (caar fndef) 'global))
              (pop fndef)
              (setq done t)) ) )
    (return result) ))


; 20-Jan-88; 06 June 90; 03 Nov 92
(defun glsavefntypes (glfn typelst)
   (dolist (type typelst)
     (unless (glbasictypep type)
       (pushnew glfn (glfnsusedin type))) ) )


; edited:  04 Aug 89 
(defmacro glsend (object selector &rest glispsendargs)
  `(glsendb ,object nil ',selector 'msg ,@glispsendargs))
; (defun glsend-expr (glispsendargs)
; (glsendb (eval (car glispsendargs))
;        nil
;        (cadr glispsendargs)
;        'msg
;        (mapcar #'eval
;                (cddr glispsendargs))))


; Edited 26-Oct-87;04 Aug 89; 19 Jan 90; 03 Jan 95
; Send a runtime message to OBJ. 
(defvar *glsendbcons* (cons nil nil))    ; a local temporary cons

(defun glsendb (obj class selector proptype &rest args)
  (prog (result putcode *gl* *glval* sel (*glfn* 'glsendb))
      (cond (class)
            ((setq class (glclass obj)))
            (t (error "Object ~S has no Class." obj)))
      (setf (car *glsendbcons*) obj)
      (setf (cdr *glsendbcons*) args)
      (cond ((not (eq (setq result (glclasssend class selector *glsendbcons*
                                                proptype))
                      'glsendfailure))
             (return result))
            ((and (eq selector 'class)
                  (member proptype '(prop msg)))
             (return class))
            ((not (eq proptype 'msg))
             (go err))
            ((and args (null (cdr args))
                  (char= (lastchar selector) #\:)
                  (setq sel (subatom selector 1 -2))
                  (setq putcode (glcompgetcode class sel t)))
             (gladdpropcode class selector 'msg
                            putcode)
             (return (funcall (car putcode)
                              obj
                              (car args))))
            (args (go err))
            ((not (eq (setq result (glclasssend class selector *glsendbcons*
                                                'str))
                      'glsendfailure))
             (return result))
            ((not (eq (setq result (glclasssend class selector *glsendbcons*
                                                'prop))
                      'glsendfailure))
             (return result))
            ((not (eq (setq result (glclasssend class selector *glsendbcons*
                                                'adj))
                      'glsendfailure))
             (return result))
            ((not (eq (setq result (glclasssend class selector *glsendbcons*
                                                'isa))
                      'glsendfailure))
             (return result)))
      err
      (error "Message ~S to object ~S of class ~S not understood."
             selector obj class)))


; edited:  9-FEB-83 16:48 
(defmacro glsendc (object class selector &rest glispsendargs)
  `(glsendb ,object ',class ',selector 'msg ,@glispsendargs))
; (defun glsendc-expr (glispsendargs)
; (glsendb (eval (car glispsendargs))
;        (cadr glispsendargs)
;        (caddr glispsendargs)
;        'msg
;        (mapcar #'eval
;                (cdddr glispsendargs))))

; 23 Oct 91
(defmacro glsendd (object class selector &rest glispsendargs)
  `(glsendb ,object ,class ,selector 'msg ,@glispsendargs))

; edited:  9-FEB-83 16:46 
(defmacro glsendprop (object selector prop &rest glispsendargs)
  `(glsendb ,object nil ',selector ',prop ,@glispsendargs))
; (defun glsendprop-expr (glispsendpropargs)
; (glsendb (eval (car glispsendpropargs))
;        nil
;        (cadr glispsendpropargs)
;        (caddr glispsendpropargs)
;        (mapcar #'eval
;                (cdddr glispsendpropargs))))


; edited:  9-FEB-83 16:48 
(defmacro glsendpropc (object class selector prop &rest glispsendargs)
  `(glsendb ,object ',class ',selector ',prop ,@glispsendargs))
; (defun glsendpropc-expr (glispsendpropargs)
; (glsendb (eval (car glispsendpropargs))
;        (cadr glispsendpropargs)
;        (caddr glispsendpropargs)
;        (cadddr glispsendpropargs)
;        (mapcar #'eval
;                (cddddr glispsendpropargs))))


; edited:  3-Jan-89 13:35 
(defmacro glsendv (object selector &rest glispsendargs)
  `(glsendb ,object nil ,selector 'msg ,@glispsendargs))
; (defun glsendv-expr (glispsendargs)
; (glsendb (eval (car glispsendargs))
;        nil
;        (eval (cadr glispsendargs))
;        'msg
;        (mapcar #'eval
;                (cddr glispsendargs))))


; edited: 30-DEC-81
(defun glsepclr nil (setq *glsepptr* 0))


; edited:  9-FEB-83
; Initialize the scanning function which breaks apart atoms containing 
;   embedded operators. 
(defun glsepinit (atm)
  (if (and (atom atm)
           (not (stringp atm)))
      (progn (setq *glsepatom* atm)
             (setq *glsepptr* 1))
      (progn (setq *glsepatom* nil)
             (setq *glsepptr* 0))))


; edited:  6-JUN-83; 26 Feb 02; 12 Mar 02
; Get the next sub-atom from the atom which was previously given to 
; GLSEPINIT. Sub-atoms are defined by splitting the given atom at 
; the occurrence of operators. Operators which are defined are
; : _ _+ __ +_ _- -_ (QUOTE =) != <> > < 
(defun glsepnxt nil
  (prog (end tmp foundslash)
    (cond ((zerop *glsepptr*) (return))
          ((null *glsepatom*)
            (setq *glsepptr* 0)
            (return '*nil*))
          ((or (numberp *glsepatom*)
               (glglobalvarp *glsepatom*)
               *glnosplitatoms*)
            (setq tmp *glsepatom*)
            (setq *glsepptr* 0)
            (return tmp)))
    (setq end (strposl *glsepbittbl* *glsepatom* *glsepptr*))
 a
    (cond ((null end)
            (return (prog1 (cond ((and (eql *glsepptr* 1)
                                       foundslash)
                                   (glsubatom *glsepatom* 1 -1))
                                 ((eql *glsepptr* 1)
                                   *glsepatom*)
                                 ((> *glsepptr*
                                     (length (symbol-name *glsepatom*)))
                                   nil)
                                 (t (glsubatom *glsepatom* *glsepptr*
                                               (length (symbol-name
                                                        *glsepatom*)))))
                      (setq *glsepptr* 0))))
          ((setq tmp (some #'(lambda (x)
                               (glmatchsubatom *glsepatom* *glsepptr* 3 x))
                           '(__+ __- _+_)))
            (incf *glsepptr* 3)
            (return tmp))
          ((setq tmp (some #'(lambda (x)
                               (glmatchsubatom *glsepatom* *glsepptr* 2 x))
                           '(\:= == __ _+ +_ _- -_ =+ += =- -= != <> >= <=)))
            (incf *glsepptr* 2)
            (return tmp))
          ((and (not *glsepminus*)
                (char= (nthchar *glsepatom* end) #\-)
                (not (char= (nthchar *glsepatom* (1+ end)) #\_)))
            (setq end (strposl *glsepbittbl* *glsepatom* (1+ end)))
            (go a))
          ((and (> end 1)
                (char= (nthchar *glsepatom* (1- end)) #\\))
            (setq end (strposl *glsepbittbl* *glsepatom* (1+ end)))
            (setq foundslash t)
            (go a))
          ((> end *glsepptr*)
            (return (prog1 (glsubatom *glsepatom* *glsepptr* (1- end))
                           (setq *glsepptr* end))))
          (t (return (prog1 (glsubatom *glsepatom* *glsepptr* *glsepptr*)
                            (incf *glsepptr*)))))))

; 01 Jul 04
; Test whether a form (lname ...) could be lhs for setf
(defun glsetfable (lname)
  (or (glanycarcdr? lname)
      (member lname '(aref get first second third fourth fifth sixth
                           seventh eighth ninth tenth getf nth glcfield))) )

; 13 Dec 89
(defun glsetfresulttypefn (fn argtypes)   (declare (ignore fn))
  (glxtrtype (cadr argtypes)) )

; 27 Apr 93
; Calculate size of an expression tree
(defun glsize (expr)
  (if (null expr) 0
      (if (atom expr) 1
          (if (eq (car expr) 'quote) 1
              (+ (glsize (car expr)) (glsize (cdr expr)))))))

; 22 Oct 02
; Calculate size of an expression tree, up to a specified limit
(defun glsizeupto (expr maxsize) (glsizeuptob expr 0 maxsize))
(defun glsizeuptob (expr size maxsize)
  (if (>= size maxsize)
      size
    (if (null expr) size
      (if (atom expr) (1+ size)
        (if (eq (car expr) 'quote) (1+ size)
          (glsizeuptob (cdr expr) (glsizeuptob (car expr) size maxsize)
                       maxsize))))))

; 26 Oct 89; 25 Oct 91; 08 Oct 02
; ***** better to write this in terms of (glcompopen fn args argtypes ...)
; where args is (arg type)*, so that constant args (including functions)
; as well as types can be part of the specialization.
(defun glspecialize (fn argtypes)
  (let (specfn)
    (setq specfn (glcompabstract fn nil argtypes))
    (list specfn (glfnresulttype specfn)) ))

; 16 Oct 02; 17 Oct 02; 22 Oct 02; 29 Oct 02; 23 Sep 03; 11 Aug 04; 10 Nov 04
; 07 May 08; 15 May 08; 01 Dec 10
; Specialize a function for a given set of arguments
; The specialization includes both types and constant argument values
; Actuals = (name type)*, may exceed the length of formals
(defun glspecializefn (fn actuals &optional newfn useactuals resulttp)
  (let (fndef arglist formals args codetp newcode gltu arg subs tmp new
              *glnatom* *gltopctx* *glsepatom* *glsepptr* *glvalbusy*
              *glexprstack* *glnrecursions* *glselfasglst* *gltypesdefined*)
    (setq fndef (glgetd fn))
    (setq arglist (glarglist (cadr fndef) nil))   ; (var value type)*
    (or newfn (setq newfn (glinstancefnname fn)))
    (when useactuals      ; names in actuals should be used
      (setq tmp arglist)
      (dolist (x actuals)
        (when (and (symbolp (car x)) tmp)
          (setq new (if (gloccurs (car x) fndef)
                        (glgensym (car x))
                        (car x)))
          (push (cons (caar tmp) new) subs))
        (setq tmp (cdr tmp)))
      (setq arglist (sublis subs arglist))
      (setq fndef (sublis subs fndef)) )
    (setq *glsepptr* 0)
    (setq *glnrecursions* 0)
    (setq *glselfasglst* nil)
    (when (and newfn (symbolp newfn))
      (setq *gllastfncompiled* newfn)
      (unless *glquietflg* (prin1 (list 'glcomp newfn)) (terpri)) )
    (setq gltu *gltypesused*)
    (setq *gltypesused* nil)
    (setq formals
          (mapcar
            #'(lambda (actual)
                (if (setq arg (pop arglist))
                    (if (glconstantp (car actual))
                        (list (car arg) (or (cadr actual) (caddr arg))
                              t (car actual))
                        (list (car arg) (or (cadr actual) (caddr arg))))
                    actual))
            actuals))
    (setf (glarguments newfn) formals)
    (setq args (mapcar #'(lambda (formal)
                           (list (if (caddr formal)
                                     (fourth formal)
                                     (first formal))
                                 (cadr formal)))
                       formals))
    (setq *gltypesdefined*
          (mapcar #'(lambda (x) (cons (car x) (cadr x))) args))
    (setq codetp (glcompopen fn args (mapcar #'cadr args) nil nil))
    (setq newcode (list 'lambda (mapcan #'(lambda (formal)
                                            (and (not (third formal))
                                                 (list (car formal))) )
                                        formals)
                        (glunwraptop (car codetp) t) ) )
    (setf (symbol-function newfn) newcode)
    (setf (glcompiled newfn) newcode)
    (setf (glfnresulttype newfn) (or resulttp (glxtrtype (cadr codetp))))
    (pushnew newfn (glinstancefns fn))
    (setf (glinstanceof newfn) fn)
    (setf (gltypesused newfn) *gltypesused*)
    (setf (gltypesdefined newfn) *gltypesdefined*)
    (glsavefntypes newfn *gltypesused*)
    (setq *gltypesused* gltu)
    newfn ))

; 03 Jan 95
; Test if a variable is special: either a glispglobal or has *var*
; Need a way to test for (proclaim '(special ...)) in Lisp!
(defun glspecialp (var)
  (let (pname)
    (and (symbolp var)
         (or (glispglobalvar var)
             (and (setq pname (symbol-name var))
                  (char= (char pname 0) #\*)
                  (char= (char pname (1- (length pname))) #\*)))) ))

; 30 Nov 92; 07 Dec 92; 17 Dec 92; 20 Dec 92; 23 Jul 93; 05 Aug 93; 26 Oct 93
; Compute result type for sqrt
(defun glsqrtresulttypefn (fn argtypes)    (declare (ignore fn))
  (let (unittp)
    (if (glunittypep (setq unittp (first argtypes)))
        (list 'units 'real (glsqrtunit (third unittp)))
        'real) ))     ; was (glnumresulttypefn fn argtypes).  Why???


; 31 May 90; 03 Nov 92
; Test if a structure involves actual storage
(defun glstoragestrp (type)
  (let ((str (glxtrtypeb type)))
    (if (or (and (symbolp str)
                 (not (eq str 'anything)))
            (glbasictypep str)
            (and (consp str)
                 (not (eq (car str) 'tuple))
                 (member (car str) *gltypenames*)))
        str) ))


; 21-Jan-89; 27 Nov 89; 19 Oct 92
; Get the GLISP structure specification for S 
(defun glstr (s)
  (cond ((symbolp s) (glstructure s))
        ((and (consp s)
              (eq (car s) 'glstructure))
          (cdr s))
        ((and (consp s)
              (eq (car s) 'virtual)
              (symbolp (cadr s)))
          (glstructure (cadr s)) ) ) )


; edited: 25-JUL-83; 27 Nov 89
; This function is called when the structure STR has been changed. 
; It uncompiles code that depends on STR. 
(defun glstrchanged (str)
  (let (fns)
    (when (glstr str)
          (if (glpropfns str) (setf (glpropfns str) nil))
          (when (setq fns (glfnsusedin str))
                (setf (glfnsusedin str) nil)
                (if (glispcp) (mapc #'gluncompile fns)) ) ) ))


; edited: 6-Jan-88; 16-Mar-89; 13 Apr 90; 24 May 90; 31 Jan 91; 09 Apr 92
; 08 Mar 00
; Create a function call to retrieve the field IND from a structure 
;   described by the structure description DES. The value is NIL if 
;   failure, (NIL DESCR) if DES equals IND, or (FNSTR DESCR) if IND 
;   can be gotten from within DES. In the latter case, FNSTR is a 
;   function to get the IND from the atom *GL*. GLSTRFN only does 
;   retrieval from a structure, and does not get properties of an 
;   object unless they are part of a TRANSPARENT substructure. DESLIST 
;   is a list of structure descriptions which have been tried already; 
;   this prevents a compiler loop in case the user specifies circular 
;   TRANSPARENT structures. 
(defun glstrfn (ind des deslist)
  (prog (desind tmp str unitrec)
; if this structure has already been tried, quit to avoid a loop. 
    (if (member des deslist) (return))
    (push des deslist)
    (cond ((or (null des) (null ind))
            (return))
          ((or (symbolp des)
               (and (consp des)
                    (symbolp (cadr des))
                    (gl-a-an? (car des))
                    (setq des (cadr des))))
            (return (cond ((setq str (glgetstr des))
                            (glnoticetype des)
                            (glstrfn ind str deslist))
                          ((setq unitrec (glunit? des))
                            (glgetfromunit unitrec ind des))
                          ((eq ind des)
                            (list nil (cadr des)))
                          (t nil))))
          ((atom des)
            (glerror 'glstrfn "Bad structure specification  ~A " des)))
    (setq desind (car des))
    (if (and (or (eq ind des)
                 (eq desind ind))
             (not (member ind *gltypenames*)))
        (return (list nil
                      (if (and (consp (cadr des))
                               (eq (caadr des) '^))
                          (glget-or-make-pointer (cadadr des))
                          (cadr des)))))
    (return (case desind
              (cons (or (glstrvalb ind (cadr des) deslist '(car *gl*))
                        (glstrvalb ind (caddr des) deslist '(cdr *gl*))))
              ((list listobject) (glliststrfn ind des deslist))
              ((proplist alist record crecord atomobject object tuple)
                (glpropstrfn ind des deslist nil))
              ((atom symbol) (glatomstrfn ind des deslist))
              (transparent (glstrfn ind (cadr des) deslist))
              (t (cond ((and (setq tmp (assoc desind *gluserstrnames*))
                             (cadr tmp))
                         (funcall (cadr tmp) ind des deslist))
                       ((or (null (cdr des))
                            (symbolp (cadr des))
                            (and (consp (cadr des))
                                 (gl-a-an? (caadr des))))
                         nil)
                       (t (glstrfn ind (cadr des) deslist)))))) ))


; edited: 11-Sep-87; 16 May 90; 11 Jun 90; 27 Jan 92; 15 Oct 92; 07 Mar 97
; If STR is a structured object, i.e., either a declared GLISP 
;   structure or a Class of Units, get the property PROP from the 
;   GLISP class of properties GLPROP. 
(defun glstrprop (str glprop prop args)
    (glstrpropa str glprop prop args str) )


; 08 Nov 93; 19 Nov 93; 11 Nov 94; 07 Mar 97
(defun glstrpropa (str glprop prop args origstr)
  (let (strb unitrec glprops propl tmp)
    (setq strb (glxtrtype str))
    (when (setq glprops (glstr strb))
      (glnoticetype strb)
      (or (and (setq propl (getf (cdr glprops) glprop))
               (setq tmp (glstrpropb prop propl args))
               (or (eq str origstr)           ; (eq glprop 'views) before ???
                   (not (getf (cddr tmp) 'specialization)))
               (setq *glstrproptype* str)     ; save type where found
               tmp)
          (some #'(lambda (x) (glstrpropa x glprop prop args origstr))
                (gltransparenttypes strb))
          (some #'(lambda (x) (glstrpropa x glprop prop args origstr))
                (glsupers strb))
          (and (setq unitrec (glunit? strb))
               (funcall (cadddr unitrec) strb glprop prop)) ) ) ))

; Edited 22-Apr-88; 20 Apr 07; 19 Feb 08; 02 Feb 09; 31 Mar 09; 04 Jun 09
; See if the property PROP can be found within the list of properties 
;   PROPL. If ARGS is specified and ARGTYPES are specified for a 
;   property entry, ARGS are required to match ARGTYPES.
; If strict = t, require type match and reject a specialize entry
(defun glstrpropb (prop propl args &optional strict)
  (prog (propent argtypes largs matchsupers optional)
 lp  (unless propl (return))
     (setq propent (pop propl))
     (unless (eq (car propent) prop)
             (go lp))
     (or (and args (setq argtypes (getf (cddr propent) 'argtypes)))
         (and strict (getf (cddr propent) 'specialize))
         (return propent))
     (setq largs args)
     (setq matchsupers (or (and (not strict)
                                (getf (cddr propent) 'specialize))
                           (getf (cddr propent) 'open)))
 lpb (cond ((and (null largs)
                 (null argtypes))
             (return propent))
           ((eq (car argtypes) '&optional)
             (pop argtypes)
             (setq optional t)
             (go lpb))
           ((null largs)
             (if optional (return propent) (go lp)))
           ((null argtypes) (go lp))
           ((gltypematchc (glxtrtyped (car largs))
                          (car argtypes) matchsupers)
             (pop largs)
             (pop argtypes)
             (go lpb))
           (t (go lp)))))


; 5-Jan-89; 03 Nov 92
; GLSTRVAL is a subroutine of GLSTRFN. Given an old partial retrieval 
; function, in which the item from which the retrieval is made is 
; specified by *GL*, and a new function to compute *GL*, a composite 
; function is made.  oldfn is (<code> <type>), new is <code>.
(defun glstrval (oldfn new)
  (let (place part ind)
    (if (and (consp new)
             (eq (car new) 'list)
             (quotep (cadr new))
             (eq (cadadr new) 'tupleobject)
             (or (and (eq (caar oldfn) 'glsendp)
                      (setq place oldfn))
                 (setq place (glfindglsendp oldfn)))
             (setq ind (cadr (caddar place)))
             (setq part (car (some #'(lambda (x)
                                       (and (consp x)
                                            (eq (car x) 'list)
                                            (quotep (cadr x))
                                            (eq (cadadr x) ind)))
                                   (cdddr new)))))
        (rplaca place (caddr part))
        (rplaca oldfn (if (car oldfn)
                          (subst new '*gl* (car oldfn))
                          new)))))


; edited: 16-Mar-89
; If the indicator IND can be found within the description DES, make a 
; composite retrieval function using a copy of the function pattern NEW. 
(defun glstrvalb (ind des deslist new)
  (let (tmp)
    (if (setq tmp (glstrfn ind des deslist))
        (glstrval tmp (copy-tree new)))))


; edited: 30-DEC-81
(defun glsubatom (x y z)
  (or (subatom x y z) '*nil*))


; edited: 16-Mar-89; 14 Oct 91; 13 Mar 97; 14 Mar 97; 14 Sep 06
; *GLEXPR* begins with THE. Parse the expression and return code. 
(defun glthe (pluralflg)
  (prog (source specs name origname qualflg dtype newcontext loopvar
                loopcond tmp thespecs)
      
; now trace the path specification. 

    (setq source (car (setq thespecs (glthespecs))))
    (setq specs (cadr thespecs))
    (setq qualflg (and *glexpr* (member (car *glexpr*)
                                        '(with who which that))))
 b  (cond ((null specs)
            (cond ((member (car *glexpr*) '(is has are))
                    (return (glpredicate source *glcontext* t nil)))
                  (qualflg (go c))
                  (t (return source))))
          ((and qualflg (not pluralflg)
                (null (cdr specs)))
             
; if this is a definite reference to a qualified entity, make the name 
;   of the entity plural.      ; changed 9/13/89
            (if source (progn (setq name (car specs))
                              (setq origname name)
                              (rplaca specs (glplural name)))
                (progn
                  (or (and (setq source (glidname (setq name (pop specs)) t))
                           (cadr source))            ; 14 Oct 91
                      (and (setq origname name)
                           (setq source (glidname (glplural name) t)))
                      (return (glerror 'glthe
                                       "The group ~A could not be found."
                                             name)))
                  (go c)))) )
      
; try to find the next name on the list of specs from source. 

    (cond ((null source)
            (or (setq source (glidname (setq name (pop specs)) nil))
                (return (glerror 'glthe
                          "The definite reference to  ~A  could not be found."
                          name))))
          (specs (setq source (glgetfield source (pop specs)
                                          *glcontext*))))
    (go b)
 c  (if (symbolp (setq dtype (glxtrtype (cadr source))))
        (setq dtype (glxtrtype (glgetstr dtype))))
    (if (or (symbolp dtype)
            (not (eq (car dtype) 'listof)))
          (glerror 'glthe
    "The group name  ~A  has type  ~A  which is not a legal group type."
                         name dtype))
    (setq newcontext (cons nil *glcontext*))
    (gladdstr (setq loopvar (glgensym 'glvar))
              (or origname name)
              (cadr dtype)
              newcontext)
    (setq loopcond (glpredicate (list loopvar (cadr dtype))
                                newcontext
                                (member (pop *glexpr*) '(who which that))
                                nil))
    (setq tmp 
          (if pluralflg
              (list (list 'subset
                          (list 'function
                                (list 'lambda (list loopvar)
                                      (car loopcond)))
                          (car source))
                    (cadr source))
              (list (list 'some
                          (list 'function
                                (list 'lambda (list loopvar)
                                      (list 'if (car loopcond) loopvar)))
                          (car source))
                    (cadr dtype))))
    (return tmp) ))


; 16-Mar-89; 03 May 91
; *GLEXPR* begins with THE. Parse the expression and return code in 
; SOURCE and path names in SPECS. 
(defun glthespecs nil
  (prog (source specs)
 a  (when (eq (car *glexpr*) 'that)
          (pop *glexpr*)
          (unless *glexpr* (glerror 'glthe "Nothing following THE")
                           (go out)))
    (if (atom (car *glexpr*))
        (progn (glsepinit (car *glexpr*))
               (if (eq (glsepnxt) (car *glexpr*))
                   (progn (push (pop *glexpr*) specs)
                          (when (eq (car *glexpr*) 'of)
                                (pop *glexpr*)
                                (if *glexpr* (go a)
                                    (glerror 'glthe "Nothing following OF"))) )
                   (progn (glsepclr)
                          (setq source (gldoexpr nil *glcontext* t)))))
        (setq source (gldoexpr nil *glcontext* t)))
out (return (list source specs))))


; edited: 16-Mar-89
; Return a list of all transparent types defined for STR 
(defun gltransparenttypes (str)
  (gltranspb (if (symbolp str) (glgetstr str) str)))


; edited:  4-May-89
; Look for TRANSPARENT substructures for GLTRANSPARENTTYPES. 
(defun gltranspb (str)
  (if (consp str)
      (case (car str)
        (transparent (list str))
        (listof nil)
        (t (mapcan #'gltranspb (cdr str)) ) )) )


; 06 Apr 90; 05 Feb 91
; Test whether two expressions, lhs and rhs, are compatible tuples
; for assignment.
(defun gltupletest (lhs rhs)
  (let (tmp)
    (and (consp (cadr lhs))
         (eq (caadr lhs) 'tuple)
         (consp (cadr rhs))
         (eq (caadr rhs) 'tuple)
         (or (equal (cadr lhs) (cadr rhs))
             (every #'(lambda (x)
                        (and (consp x)
                             (setq tmp (assoc (car x) (cdadr rhs)))
                             (gltypematch x tmp)))
                    (cdadr lhs))) ) ))


; edited: 15-Feb-89; 20 Nov 89
; Find a type intersection, e.g., (gltypeint 'integer 'real) = NUMBER
(defun gltypeint (typea typeb)
  (let (tmp)
    (cond ((or (eq typea typeb)
               (gltypeintb typea typeb))
             typea)
          ((setq tmp (some #'(lambda (x) (gltypeint x typeb))
                           (glsupers typea)))
             tmp)) ))


; edited: 15-Feb-89
(defun gltypeintb (typea typeb)
  (if (or (eq typea typeb)
          (some #'(lambda (x) (gltypeintb typea x))
                (glsupers typeb)))
      typea))

; edited: 10-FEB-83; 29 Nov 89; 11 Jun 90; 06 Jul 90; 10 Sep 90; 04 Feb 91
; 25 Mar 97; 30 Sep 97; 31 Jan 02; 21 Jul 06; 16 Apr 09; 08 Sep 09
; See if the type SUBTYPE matches the type TYPE, either directly or 
;   because TYPE is a SUPER of SUBTYPE. 
(defun gltypematch (subtype type) (gltypematchb subtype type nil))

(defun gltypematchb (subtype type prev)
 (let (str newprev)
    (setq type (glxtrtype type))
    (setq subtype (glxtrtype subtype))
    (and type subtype
         (or (eq type 'anything)
             (equal subtype type)
             (and (not (member subtype prev))
                  (setq newprev (cons subtype prev))
                  (or (and (symbolp subtype)
                           (setq str (glxtrtype (car (glstr subtype))))
                           (symbolp str)
                           (not (eq str subtype))
                           (gltypematchb str type newprev))
                      (and (symbolp subtype)
                           (consp (setq str (car (glstr subtype))))
                           (eq (car str) '^)
                           (not (eq (cadr str) subtype))
                           (gltypematchb (cadr str) type newprev))
                      (and (consp type)
                           (member (car type) '(setof sequence))
                           (consp subtype)
                           (member (car subtype) '(listof arrayof))
                           (or (gltypematchb (cadr subtype)
                                             (cadr type) newprev)
                               (and (symbolp (cadr subtype))
                                    (eq (glgetpointer (cadr subtype))
                                        (cadr type)))))
                      (and (consp subtype)
                           (eq (car subtype) 'units)
                           (gltypematchb (cadr subtype) type prev))
                      (and (symbolp subtype)
                           (some #'(lambda (y)
                                     (gltypematchb y type newprev))
                                 (glsupers subtype)))
                      (and (symbolp subtype)
                           (some #'(lambda (y)
                                     (gltypematchb (cadr y) type newprev))
                                 (gltransparenttypes subtype)))
                      (and (symbolp subtype)
                           (some #'(lambda (y)
                                     (gltypematchb (cadr y) type newprev))
                                 (glviews subtype))) )))) ))

; 20 Apr 07; 02 Jan 08; 18 Feb 08; 19 Feb 08
; Match types for arg type restrictions in a message.
(defun gltypematchc (actual formal matchsupers)
  (let ((xactual (glxtrtype actual)) (xformal (glxtrtype formal)))
    (or (equal xactual xformal)
        (and (glnumtypep xactual) (glnumtypep xformal))
        (and (eq xactual 'vector) (member xformal '(rvector nvector)))
        (and (eq xformal 'vector) (member xactual '(rvector nvector)))
        (and matchsupers
             (some #'(lambda (super) (gltypematchc super formal t))
                   (glsupers actual))) ) ))

; 17 Dec 08
; Find out the type of prop named sel for type typ.
; (gltypeofprop 'circle 'diameter)  =  (PROP DIAMETER REAL)
(defun gltypeofprop (typ sel)
  (let (seltp proptype)
    (if (setq seltp (assoc sel (glpropnametypes typ 'prop)))
        (setq proptype 'prop)
        (if (setq seltp (assoc sel (glpropnametypes typ 'adj)))   ; ? isa ?
            (setq proptype 'adj)
            (if (setq seltp (assoc sel (glpropnametypes typ 'msg)))
                (setq proptype 'msg)
                (if (setq seltp (assoc sel (gldatanames typ)))
                    (setq proptype 'str)))))
    (if seltp (cons proptype seltp)) ))

; 31 May 95
; Test whether something is (apparently) a GLISP type description
(defun gltypep (x)
  (if (consp x)
      (or (member (car x) '(typeof clustertype units glstructure))
          (member (car x) *gltypenames*))
      (and x (symbolp x) (not (eq x t))
           (or (member x *glbasictypes*)
               (glstr x)))))


; Edited 7-Oct-87; 28 Dec 89; 08 Jan 90; 25 Jan 90; 24 Jan 92; 15 Dec 93
; 10 Jan 96; 21 May 96
; Remove the GLISP-compiled definition and properties of GLAMBDAFN 
(defun gluncompile (glambdafn)
  (let (specs str props typesused)
    (when (glcompiled glambdafn)
          (setq specs (glspecialization glambdafn))
          (setq typesused (gltypesused glambdafn))
          (unless *glquietflg* (format t "uncompiling ~a~%" glambdafn))
          (dolist (prop '(glcompiled glfnresulttype glarguments gltypesused
                          glspecialization glpure glsideeffects))
            (remprop glambdafn prop))
          (if specs
              (setf (symbol-function glambdafn) nil)
              (glunsavedef glambdafn))
          (dolist (y typesused)
            (setf (glfnsusedin y)
                  (delete glambdafn (glfnsusedin y)))))
      
; uncompile specializations of a generic function.
; speclst is (specialized-fn type-specialized-for proptype selector)

    (dolist (speclst specs)
      (setf (glinstancefns (car speclst))
            (delete glambdafn (glinstancefns (car speclst))))
      
; remove the specialization entry in the datatype where it was created. 

      (when (and (symbolp (cadr speclst))
                 (setq str (glstructure (cadr speclst)))
                 (setq props (getf (cdr str) (third speclst))))
            (setf (getf (cdr str) (third speclst))
                  (delete-if #'(lambda (l)
                                 (and (eq (car l) (fourth speclst))
                                      (eq (cadr l) glambdafn)))
                             props))
; delete from glpropfns also if used there             ; 24 Jan 92
            (if (setq props (assoc (third speclst)
                                   (glpropfns (second speclst))))
                (setf (cdr props)
                      (delete-if #'(lambda (l) (eq (cadr l) glambdafn))
                                 (cdr props))))
; and note that this structure has changed to uncompile anything that
; might depend on the specialization that was just deleted.  ; 15 Dec 93
            (glstrchanged (cadr speclst)) ) ) ))


; edited: 27-MAY-82
; GLUNIT? tests a given structure to see if it is a unit of one of the 
;   unit packages on GLUNITPKGS. If so, the value is the unit package 
;   record for the unit package which matched. 
(defun glunit? (str)
  (dolist (ups *glunitpkgs*)
    (if (funcall (caar ups) str) (return (car ups)) ) ) )


; edited: 27-MAY-82
; GLUNITOP calls a function to generate code for an operation on a 
;   unit in a units package. UNITREC is the unit record for the units 
;   package, LHS and RHS the code for the left-hand side and right-hand
;   side of the operation (in general, the GET code for each side) , and
;   OP is the operation to be performed. 
(defun glunitop (lhs rhs op)
  (prog (tmp lst unitrec)
    (setq lst *glunitpkgs*)
  a (cond ((null lst) (return))
          ((not (member (caar lhs) (cadar lst)))
            (pop lst)
            (go a)))
    (setq unitrec (car lst))
    (if (setq tmp (assoc op (caddr unitrec)))
        (return (funcall (cdr tmp) lhs rhs)))
    (return)))


; 04 Nov 92; 06 Nov 92; 07 Apr 08
; Test if type is a unit specifier, e.g. (units real meter)
(defun glunittypep (type)
  (or (and (consp type)
           (eq (car type) 'units)
           (consp (cdr type))
           (consp (cddr type))
           (glunitp (caddr type)))
      (and (symbolp type)
           (setq type (car (glstr type)))
           (consp type)
           (eq (car type) 'units)
           (consp (cdr type))
           (consp (cddr type))
           (glunitp (caddr type))) ) )

; 16-Oct-87
; Remove the GLISP-compiled definition of GLAMBDAFN 
(defun glunsavedef (glambdafn) (glputhook glambdafn))


; edited: 15-Feb-89; 19 Jan 90; 22 Dec 94; 28 Dec 94; 01 Apr 95; 31 May 95
; 20 Feb 03; 01 Mar 05; 12 May 09
; Unroll a loop at compile time.  fn is the function to apply to items.
(defun glunrollforloop (loopvar cdomain dtype loopcond *glexpr* context fn)
  (let (codetype code newcode)
    (dolist (item cdomain)
      (setq codetype
            (glprogn *glexpr* (cons (list (list '= loopvar (kwote item)))
      ; was (list 'alias loopvar (kwote item) (cadr dtype))
                                    context)))
      (setq code (if (cdr (car codetype))
                     (cons 'progn (car codetype))
                     (caar codetype)))
      (push (if loopcond
                (list 'if (subst (kwote item) loopvar (car loopcond)) code)
                code)
            newcode) )
    (list (if (cdr newcode)
              (cons fn (nreverse newcode))
              (car newcode))
          (cadr newcode)) ))


; 01 Oct 96
; Remove a glstoretrap wrapping of code.
(defun glunstoretrap (codetype)
  (let ((code (car codetype)))
    (if (and (consp code)
             (eq (car code) 'glstoretrap))
        (list (cadr code) (cadr codetype))
        codetype) ))


; 11-May-88; 9-Feb-89; 22 Nov 89; 14 Dec 89; 01 Aug 91; 16 Apr 92; 12 Nov 92
; 07 Sep 93; 06 Mar 95; 10 Nov 95; 14 Mar 97; 07 Jan 00; 24 Feb 00; 01 Feb 01
; 22 Oct 02; 10 Nov 04; 26 Oct 06; 12 Jan 09; 07 Apr 11
; Unwrap an expression X by removing extra stuff inserted during compilation. 
(defun glunwrap (x busy)
  (cond ((atom x) (if busy x))
        ((consp (car x)) (error " ~S  ~S " 'glunwrap x))
        ((case (car x)
           (go x)
           (quote (if busy
                      (if (and (consp (cdr x)) (constantp (cadr x)))
                          (cadr x) x)))
           (setq (glunwrappt (glunwrapsetq x busy) busy))
           ((prog1 prog2 progn)
             (if (cddr x)
                 (glunwrappt (glmakeprogn (glexpandprogn (cdr x) busy (car x))
                                          (car x))
                             busy)
                 (glunwrap (cadr x)
                           (and busy (not (eq (car x) 'prog2))))))
           (while (glunwrappt
                    (cons 'while (cons (glunwrap (cadr x) t)
                                       (glexpandprogn (cddr x) busy (car x))))
                    busy))
           (function                            ; 26 Oct 06; 06 Nov 06
             (if (consp (cadr x))
                 (list (car x) (glunwrap (cadr x) busy))
                 x))
           ((mapl mapc mapcar mapcan subset some every)
              (glunwrappt (glunwrapmap x busy) busy))
           (lambda (cons (car x) (cons (cadr x)
                                       (glexpandprogn (cddr x) busy 'progn))))
           ((prog let let*) (glunwrappt (glunwrapprog x busy) busy))
           (cond (glunwrappt (glunwrapcond x busy) busy))
           (case (glunwrapselectq x busy))
           (do (glunwrapdo x busy))
           ((union intersection set-difference) (glunwrapintersect x))
           (glvirtual (glunwrapvirtual x busy))
           ((glrepresentation glstoretrap) (glunwrap (cadr x) busy))
           (glbinding (glunwrap (glbindingtocode x) busy))
           (t (cond ((and (not busy)
                          (or (glpure (car x))
                              (member (car x)
                                      '(cons list copy-list copy-tree))))
                      (if (cddr x)
                          (glunwrap (cons 'progn (cdr x)) nil)
                          (glunwrap (cadr x) nil)))
                    (t (mapl #'(lambda (y) (rplaca y (glunwrap (car y) t)))
                             (cdr x))
                       (cond ((and (cdr x)
                                   (null (cddr x))
                                   (consp (cadr x))
                                   (glcarcdr? (car x))
                                   (glcarcdr? (caadr x))
                                   (< (+ (glcarcdr? (car x))
                                         (glcarcdr? (caadr x)))
                                      5))
                               (setf (car x)
                                     (glmakecarcdr
                                      (nreverse (nconc
                                                 (glanycarcdr? (caadr x))
                                                 (glanycarcdr? (car x))))))
                               (setf (cadr x) (cadadr x))
                               (glunwrap x busy))
                             ((and 
                                   (cdr x)   ; don't eval fn of no args
                                   (every #'glconstantp (cdr x))
                                   (or (not (glargsnumberp (car x)))
                                       (every #'numberp (cdr x)))
                                ;  (or (format t "glunwrap: would eval ~A~%" x)
                                ;      t)
                                   (gloktoeval (car x)) )
                               (kwote (eval x)))
                             ((and (eq (car x) 'known)
                                   (consp (cdr x))
                                   (null (cddr x)))
                                (glknown (cadr x)))
                             ((member (car x) '(and or)) (glunwrapandor x))
                             ((and (get (car x) 'glinstanceof)
                                   (< (glsizeupto
                                        (cddr (symbol-function (car x)))
                                        *glmaxinline*)
                                      *glmaxinline*))
                               (glunwrap (glinlinefn (car x) (cdr x)) busy))
                             (t (glunwrappt x busy))))))))))


; edited: 16-MAR-83; 14 Dec 89; 19 Jan 90
; Optimize a logical expression (AND or OR) by performing constant
;  transformations and splicing in sublists of the same type, e.g.,
; (AND X (AND Y Z))   ->   (AND X Y Z) . 
(defun glunwrapandor (x)
  (prog (y last)
    (setq y (cdr x))
    (setq last x)
 lp (cond ((null y) (return (cond ((null (cdr x)) (eq (car x) 'and))
                                  ((null (cddr x)) (cadr x))
                                  (t x))))
          ((or (and (eq (car x) 'and)
                    (null (car y)))
               (and (eq (car x) 'or)
                    (or (eq (car y) t)
                        (glnevernil (car y)))))     
           (setf (cdr y) nil))
          ((or (and (null (car y))
                    (eq (car x) 'or))
               (and (eq (car x) 'and)
                    (or (eq (car y) t)
                        (glnevernil (car y)))
                    (cdr y)))          
            (pop y)
            (setf (cdr last) y)
            (go lp))
          ((and (consp (car y))
                (eq (caar y) (car x)))
           (setf (cdr (last (car y)))
                 (cdr y))
           (setf (cdr y) (cddar y))
           (setf (car y) (cadar y))))
    (pop y)
    (pop last)
    (go lp) ))


; edited: 22-JUL-83
; Unwrap and optimize an expression if the compiler is present. 
(defun glunwrapc (x busy)
  (if (glispcp) (glunwrap x busy) x))


; edited: 30-Dec-88; 29 Oct 02
; Unwrap a COND expression. 
(defun glunwrapcond (x busy)
  (prog ((result x))
 a  (unless (cdr result) (go b))
    (setf (car (cadr result))
          (glunwrap (caadr result) t))
    (if (or (eq (caadr result) nil) (eq (caadr result) '*glfalse*))
        (progn (setf (cdr result) (cddr result))
               (go a))
        (setf (cdr (cadr result))
              (glexpandprogn (cdadr result) busy 'progn)))
    (if (or (eq (caadr result) t) (eq (caadr result) '*gltrue*))
        (setf (cdr (cdr result)) nil))
    (pop result)
    (go a)
  b (return (if (cdr x)
                (if (and (null (cddr x))
                         (or (eq (caadr x) t) (eq (caadr x) '*gltrue*)))
                    (if (cddadr x)
                        (cons 'progn (cdadr x))
                        (cadadr x))
                    (glcommontranscond x)))) ))


; 07 Apr 11; 12 Apr 11
; unwrap a (do ...) macro
; must be done separately since do is a special form with unusual syntax
(defun glunwrapdo (x busy)
  (append
    (list 'do
          (mapcar #'(lambda (z)
                      (cons (car z)
                            (if (cdr z)
                                (cons (glunwrap (cadr z) t)
                                      (if (cddr z)
                                          (list (glunwrap (caddr z) t)))))))
                  (second x))
          (cons (glunwrap (first (third x)) t)
                (if (cdr (third x))
                    (glunwrap (cons 'progn (cdr (third x))) busy))) )
    (if (cdddr x)
        (cdr (glunwrap (cons 'progn (cdddr x)) nil)))) )


; edited:  8-Aug-86
; Optimize intersections and unions of subsets of the same set: 
;   (INTERSECT (SUBSET S P) (SUBSET S Q)) -> (SUBSET S (AND P Q)) 
(defun glunwrapintersect (code)
  (prog (lhs rhs p q qq sa sb)
    (setq lhs (glunwrap (cadr code) t))
    (setq rhs (glunwrap (caddr code) t))
    (or (and (consp lhs)
             (consp rhs)
             (eq (car lhs) 'subset)
             (eq (car rhs) 'subset))
        (go out))
    (setq sa (glunwrap (caddr lhs) t))
    (setq sb (glunwrap (caddr rhs) t))
  
; make sure the sets are the same. 

    (or (equal sa sb) (go out))
    (setq p (glxtrfn (cadr lhs)))
    (setq q (glxtrfn (cadr rhs)))
    (setq qq (subst (car p) (car q) (cadr q)))
    (return
      (glgencode
        (list 'subset sa
              (list 'function
                    (list 'lambda (list (car p))
                          (glunwrap (case (car code)
                                      (intersection (list 'and (cadr p) qq))
                                      (union (list 'or (cadr p) qq))
                                      (set-difference
                                        (list 'and (cadr p)
                                                   (list 'not qq)))
                                      (t (error "NOMSG")))
                                    t))))))
 out
    (mapl #'(lambda (y) (rplaca y (glunwrap (car y) t)))
          (cdr code))
    (return code)))


; 30 Dec 94
; Remove atoms from the middle of a LET form
(defun glunwrapletatoms (code)
  (let (tmp)
    (if (null (cdr code))
        code
        (progn (setq tmp (glunwrapletatoms (rest code)))
               (if (atom (car code))
                   tmp
                   (if (eq tmp (cdr code))
                       code
                       (cons (car code) tmp))))) ))


; 8-Aug-86; 28 Dec 94; 14 Sep 06; 16 Sep 07
; Unwrap and optimize mapping-type functions. 
(defun glunwrapmap (x busy)
  (prog (lsts lst fn outside inside outfn infn newfn newmap tmpvar newlst)
    (setq lsts (mapcar #'(lambda (l) (glunwrap l t)) (cddr x)))
    (setq lst (first lsts))
    (setq fn (glunwrap (cadr x) (not (eq (car x) 'mapc))))
    (if (cdr lsts)
        (return (cons (car x) (cons fn lsts)))
        (if (or (not (member (setq outfn (car x)) '(subset mapcar mapc mapcan)))
                (not (and (consp lst)
                          (member (setq infn (car lst)) '(subset mapcar)))) )
            (go out)) )
      
; optimize compositions of mapping functions to avoid construction of 
;   lists of intermediate results. 
; these optimizations are not correct if the mapping functions have 
;   interdependent side-effects. however, these are likely to be very 
;   rare, so we do it anyway. 

      (setq outside (glxtrfn fn))
      (setq inside (glxtrfn (progn (setq newlst (caddr lst))
                                   (cadr lst))))
      (case infn
            (subset (case outfn ((subset mapcan)
                           (setq newmap outfn)
                           (setq newfn (list 'and
                                             (cadr inside)
                                             (subst (car inside)
                                                    (car outside)
                                                    (cadr outside)))))
                          (mapcar (setq newmap 'mapcan)
                                  (setq newfn
                                        (list 'and
                                              (cadr inside)
                                              (list 'cons
                                                  (subst (car inside)
                                                         (car outside)
                                                         (cadr outside))
                                                    nil))))
                          (mapc (setq newmap 'mapc)
                                (setq newfn (list 'and
                                                (cadr inside)
                                                (subst (car inside)
                                                       (car outside)
                                                       (cadr outside)))))
                          (t (error "NOMSG"))))
            (mapcar (setq newfn (list 'prog
                                      (list (setq tmpvar (glgensym 'glvar)))
                                      (list 'setq
                                            tmpvar
                                            (cadr inside))
                                      (list 'return
                                            '*glcode*)))
                    (case outfn
                          (subset (setq newmap 'mapcan)
                                  (setq newfn
                                        (subst (list 'and
                                                   (subst tmpvar
                                                          (car outside)
                                                          (cadr outside))
                                                     (list 'cons
                                                           tmpvar nil))
                                               '*glcode*
                                               newfn)))
                          ((mapc mapcar mapcan)
                            (setq newmap outfn)
                            (setq newfn (subst (subst tmpvar
                                                      (car outside)
                                                      (cadr outside))
                                               '*glcode*
                                               newfn)))
                          (t (error "NOMSG"))))
            (t (error "NOMSG")))
      (return (glunwrap (glgencode (list newmap newlst
                                         (list 'function
                                               (list 'lambda
                                                     (list (car inside))
                                                     newfn))))
                        busy))
      out
      (return (glgencode (list outfn lst fn))) ))


; 18 July 89; 09 May 90; 29 May 90; 06 Jan 94; 30 Dec 94; 20 May 96
; Optimize a PROG or LET expression. 
(defun glunwrapprog (x busy)
  (prog (last (progwd (car x)) nreturns tmp (xorig x) code)
; substitute in prog vars that are only used once 
    (setq x (glunwrapprogvars x))
    (if (member progwd '(let let*))
        (progn (setq tmp (glunwrapletatoms (cddr x)))
               (if (not (eq tmp (cddr x)))
                   (setq x (cons (car x) (cons (cadr x) tmp))))))
    (setq last (last x))
    (setq nreturns (glnoccurs 'return (cddr x)))
; if possible, eliminate the LET or PROG
    (if (and (eq progwd 'let)  ; (let (v) (setq v ...) v)  --> ,,,
             (cadr x)
             (null (cdadr x))
             (consp (caddr x))
             (eq (caaddr x) 'setq)
             (eq (cadr (caddr x)) (caadr x))
             (eq (cadddr x) (caadr x))
             (null (cddddr x)))
         (return (glunwrap (caddr (caddr x)) busy)))
    (unless (cadr x) 
      (cond ((eq progwd 'let)
              (return (glunwrap (if (cdddr x)
                                    (cons 'progn (cddr x))
                                    (caddr x))
                                busy)))
            ((and (null (cdddr x))
                  (consp (caddr x))
                  (eq (caaddr x) 'return)
                  (<= nreturns 1))
              (return (glunwrap (cadr (caddr x)) busy)))
            ((and (null (cdddr x))
                  (<= nreturns 0))
              (return (glunwrap (caddr x) nil)))
            ((and (consp (car last))
                  (eq (caar last) 'return)
                  (not (some #'symbolp (cddr x)))
                  (<= nreturns 1))
              (setf (car last) (cadar last))
              (return (glunwrap (cons 'progn (cddr x))
                                busy)))
            ((<= nreturns 0)
              (return (glunwrap (cons 'tagbody (cddr x))
                                busy))) ) )
      
; first see if the prog is not busy and ends with a return. 
    (when (and (not busy)
               (eq progwd 'prog)
               (consp (car last))
               (eq (caar last) 'return))
            ; remove the return. if atomic, remove the atom also. 
      (if (atom (cadar last))
          (setf (cdr (nleft x 2)) nil)
          (setf (car last) (cadar last))))
      
; do any initializations of prog variables. 
    (dolist (y (cadr x))
      (if (consp y)
          (setf (cadr y) (glunwrap (cadr y) t))))
    (setq code (glexpandprogn (cddr x) busy progwd))
    (if (not (eq code (cddr x)))
        (setq x (cons (car x) (cons (cadr x) code))))
; If it got smaller, hit it again.
    (while (< (glsize x) (glsize xorig))
      (setq xorig x)
      (setq x (glunwrap x busy)) )
    (return (if (eq progwd 'prog) (glcommontransprog x) x)) ))


; 30-Dec-88; 04 May 90; 06 Nov 92; 26 Mar 93; 29 Dec 94; 30 Dec 94; 02 Jan 95
; 03 Jan 95; 13 Apr 95; 20 May 96; 29 Jan 98; 24 Dec 98; 28 Dec 98; 07 Jan 99
; 13 Jan 99; 11 Feb 00; 26 Nov 02; 23 Dec 02
; Substitute PROG variables into code and remove them when appropriate. 
(defun glunwrapprogvars (x)
  (let (subs newprogvars newcode nocc tmp)
    (if (and (member (car x) '(let prog))
             (cadr x))
        (progn        
          (setq newcode (cddr x))
          (dolist (progvar (cadr x))
            (if (and (consp progvar)
                     (not (glspecialp (car progvar)))
                     (or (<= (setq nocc (glnoccurs (car progvar) newcode)) 1)
                         (symbolp (cadr progvar)))
                     (not (and (consp (cadr progvar))
                               (member (caadr progvar)
                                       '(random get-decoded-time sleep
                                                get-universal-time
                                                get-internal-run-time
                                                get-internal-real-time))))
                     (not (glinloop (car progvar) newcode))
                     (or (= nocc 0)
                         (and (not (glkilled (car progvar) newcode))
                              (or (not (glkilled (cadr progvar) newcode))
                                  (and (consp newcode)
                                       (consp (car newcode))
                                       (null (cddr newcode))
                                       (member (caar newcode) '(setq setf))
                                       (gloccurs (car progvar)
                                                 (cddar newcode)) ) ) )))
                (progn (setq subs t)
                       (if (glnotused (car progvar) (cons 'progn newcode))
                           (setq newcode (glremovesetq (car progvar) newcode))
                           (setq newcode (subst (cadr progvar)
                                                (car progvar) newcode))))
                (if (and (symbolp progvar)
                         (not (glspecialp progvar))
                         (glnotused progvar newcode))
                    (progn (setq subs t)
                           (setq newcode (glremovesetq progvar newcode)))
                    (if (and (symbolp progvar)
                             (not (glspecialp progvar))
                             (= (glnoccurs progvar newcode) 2)
                             (setq tmp (glfindsetq progvar newcode))
                             (= (glnoccurs progvar (cdr tmp)) 1)
                             (not (glkilled (cadar tmp) (cdr tmp)))
                             (not (glkilled (caddar tmp) (cdr tmp)))
                             (glnosideeffects (caddar tmp))
                             (not (glinloop progvar newcode)))
                        (progn
                          (setq subs t)
                          (setq newcode
                                (subst (caddar tmp) progvar
                                       (glremovesetq progvar newcode))))                               
                        (push progvar newprogvars)))))
          (if subs (cons (car x)
                         (cons (nreverse newprogvars) newcode))
              x))
        x) ))


; edited:  4-May-89
; Optimize code X using the pattern matcher. 
(defun glunwrappt (x busy)
  (let (xp)
    (setq xp (glptmatch x 'glpatterns))
    (if (eq x xp) x (glunwrap xp busy))))


; edited: 17-Sep-88; 29 Dec 89
; Unwrap a SELECTQ or CASE expression. 
(defun glunwrapselectq (x busy)
(prog (l selector)
      
; first unwrap the component expressions. 

      (setf (cadr x)
            (glunwrap (cadr x)
                      t))
      (mapl #'(lambda (y)
                (if (or (cdr y)
                        (eq (car x) 'case))
                    (rplacd (car y)
                            (glexpandprogn (cdar y)
                                           busy
                                           'progn))
                    (rplaca y (glunwrap (car y)
                                        busy))))
            (cddr x))
      
; test if the selector is a compile-time constant. 

      (unless (glconstantp (cadr x))
              (return x))
      
; evaluate the selection at compile time. 

      (setq selector (glconstval (cadr x)))
      (setq l (cddr x))
      lp
      (cond ((null l)
             (return nil))
            ((and (eq (car x) 'case)
                  (eq (caar l) t))
             (return (glunwrap (cons 'progn
                                     (cdar l))
                               busy)))
            ((or (eq selector (caar l))
                 (and (consp (caar l))
                      (member selector (caar l))))
             (return (glunwrap (cons 'progn
                                     (cdar l))
                               busy))))
      (pop l)
      (go lp)))


; edited:  4-Feb-87 15:29 ; 11 Feb 00
(defun glunwrapsetq (x busy)
  (let ((res (glunwrap (caddr x) t)))
     (cond ((eq (cadr x) res) (if busy (cadr x)))
           ((eq res (caddr x))
              (if (symbolp (cadr x))
                  x
                  (cons 'setf (cdr x))))    ; kind of a kludge
           (t (list (if (symbolp (cadr x))
                        (car x)
                        'setf)              ; kind of a kludge
                    (cadr x)
                    res)))))


; edited:  4-May-89 16:05 
; Top-level call to GLUNWRAP, to make tracing easier. 
(defun glunwraptop (x busy)
(glunwrap x busy))


; 27 Sep 89; 09 Nov 92; 04 Jun 96
; Perform lazy materialization of a virtual object. 
(defun glunwrapvirtual (x busy)
  (glunwrap (car (glmaterialize (list x (list 'virtual (cadr x))) nil nil))
            busy))

; was: (glbuildstr (cadr x) ; was (if (consp (cadr x)) (cadr x)
;                                ;         (glgetstr (cadr x)))
;                       (cddr x)
;                       nil)     ;   (list (cadr x))


; 03 Aug 93; 04 Aug 93; 03 Sep 93; 23 Sep 93; 25 Oct 93; 20 Dec 93; 27 Jan 94
; 24 Oct 94; 25 Mar 97; 10 Feb 98; 28 Apr 98; 16 Mar 99; 04 Dec 02; 16 Aug 04
; Test whether updating a type from old to new is legitimate
(defun glupdatetypematch (old new)
  (let (str pointsto)
    (or (null old)
        (eq old 'anything)
        (eq new 'anything)
        (gltypematch new old)
        (and (or (eq old 'atom)
                 (and (consp old) (eq (car old) 'atom)))
             (member new '(atom symbol gltype number integer real)))
        (and (or (eq old 'symbol)
                 (and (consp old) (eq (car old) 'symbol)))
             (member new '(atom symbol gltype)))
        (and (eq old 'boolean)    ; since nil is both boolean and empty list
             (consp new) (member (car new) '(listof list)))
        (and (glpointerp old)
             (not (equal old (setq pointsto (glpointsto old))))
             (glupdatetypematch pointsto new))
        (and (glpointerp new)
             (not (equal new (setq pointsto (glpointsto new))))
             (glupdatetypematch old pointsto))
        (and (consp old) (member (car old) '(listof arrayof list))
             (consp new) (member (car new) '(listof arrayof list))
             (glupdatetypematch (cadr old) (cadr new)))
        (and (consp old) (eq (car old) 'or)
             (some #'(lambda (x) (glupdatetypematch x new))
                   (cdr old)))
        (and (consp old) (eq (car old) 'transparent)
             (glupdatetypematch (cadr old) new))
        (and (symbolp old)
             (not (member old *glbasictypes*))
             (setq str (glstructure old))
             (glupdatetypematch (car str) new))
        (and (consp old)
             (not (member (car old) *gltypenames*))
             (glupdatetypematch (cadr old) new))
        (and (consp new)
             (not (member (car new) *gltypenames*))
             (glupdatetypematch  old (cadr new))) ) ))


; 5-MAY-82; 02 Nov 92; 03 Aug 93; 04 Aug 93; 22 Dec 94; 22 Dec 10
; Update the type of VAR to be TYPE, destructively.
(defun glupdatevartype (var type)
  (let (ctxent oldtype)
    (cond ((or (null type)
               (and (symbolp var) (get var 'glispglobalvar))))
          ((setq ctxent (glcodetype var *glcontext*))
            (setq oldtype (cadr ctxent))
            (unless (or (glupdatetypematch oldtype type)
                        (eq type 'anything)
                        (and (member oldtype '(integer real))
                             (member type '(integer real number))))
                          ; this will be okay for Lisp and should not
                          ; happen in other languages
              (glerror 'glupdatevartype
                       "Type of ~A changed from ~A to ~A~%"
                       var oldtype type))
            (unless (or oldtype (eq type 'anything))
              (setf (cadr ctxent) type)))              ; destructive
          (t (gladdstr var nil type *glcontext*)))))


; 30 Dec 94; 02 Jan 95; 03 Jan 95
; Update the value of a variable at compile time.
; If the value is a constant, it is saved in the context.
; Otherwise, if a value exists in context, a notation that the value has
; changed is added to prevent the old value from being used.
(defun glupdatevarvalue (var codetype context)
  (when (symbolp var)
    (glkillcontextentry var context)
    (if (constantp (car codetype))
        (gladdfact (list '= var (car codetype)) context)
        (if (and (consp (car codetype))
                 (symbolp (caar codetype))
                 (glnevernull (caar codetype)) )
            (gladdfact (list 'not (list 'null var)) context) ) ) ) )

; 20 Aug 04
; test whether a var is use din context structure ctx
; This is a somewhat crude test
; also does not work with atoms that must be split
(defun glusedinctx (var ctx)
  (some #'(lambda (ctxlist)
            (some #'(lambda (ctxentry)
                      (and (eq (car ctxentry) 'alias)
                           (gloccurs var (caddr ctxentry))))
                  ctxlist))
        ctx))

; edited: 23-JAN-83; 12 Oct 89
; Process a user-function, i.e., any function which is not specially 
;   compiled by GLISP. The function is tested to see if it is one 
;   which a unit package wants to compile specially; if not, the 
;   function is compiled by GLUSERFNB. 
(defun gluserfn (*glexpr*)
(prog (fnname tmp ups)
      (setq fnname (car *glexpr*))
      
; first see if a user structure-name package wants to intercept this 
;   function call. 

      (setq ups *gluserstrnames*)
      lpa
      (cond ((null ups)
             (go b))
            ((setq tmp (assoc fnname (car (cddddr (car ups)))))
             (return (funcall (cdr tmp)
                              *glexpr* *glcontext*))))
      (pop ups)
      (go lpa)
      b
      
; test the function name to see if it is a function which some unit 
;   package would like to intercept and compile specially. 

      (setq ups *glunitpkgs*)
      lp
      (cond ((null ups)
             (go c))
            ((and (member fnname (car (cddddr (car ups))))
                  (setq tmp (assoc 'unitfn
                                   (caddr (car ups)))))
             (return (funcall (cdr tmp)
                              *glexpr* *glcontext*))))
      (pop ups)
      (go lp)
      c
      (return (gluserfnb (if (and (boundp '*glfnsubs*)
                                  (setq tmp (assoc fnname *glfnsubs*)))
                             (cons (cdr tmp) (cdr *glexpr*))
                             *glexpr*))) ))


; 25-Feb-89; 12 Oct 89; 15 May 90; 17 May 90; 18 May 90; 25 May 90
; 31 May 90; 06 Jun 90; 14 Feb 91; 30 Sep 91; 03 Jan 92; 07 Jan 92
; 17 Jan 92; 20 Jan 92; 10 Mar 92; 11 Mar 92; 03 Nov 92; 06 Nov 92
; 10 Nov 92; 30 Nov 92; 25 Mar 93; 30 Mar 93; 08 Apr 93; 13 May 93
; 20 May 93; 11 Oct 93; 13 Oct 93; 22 Dec 94; 29 Dec 94; 30 Dec 94
; 07 Jun 95; 10 Nov 95; 10 Jan 96; 18 Jan 96; 13 Feb 96; 17 Sep 96
; 12 Nov 96; 23 Dec 98; 29 Dec 00; 17 Oct 02; 19 Nov 02; 20 Nov 02
; 08 Jan 03; 18 Feb 03; 31 Mar 03; 12 Sep 06; 29 Nov 07; 25 Mar 11
; Parse an arbitrary function by getting the function name and then 
;   calling GLDOEXPR to get the arguments. 
(defun gluserfnb (*glexpr*)
  (let (argl fnname fnnameb tmp clus tp result arglb)
    (setq fnname (pop *glexpr*))
    (while *glexpr*
      (push (or (gldoexpr nil *glcontext* t)
                (progn (glerror 'gluserfnb
                                "Function call contains bad item.  EXPR =  ~A "
                                *glexpr*)
                       (setq *glexpr* nil)))
            argl))
; dereference any args that are pointers
    (setq argl (glnreverse argl))
    (mapl #'(lambda (argg) (rplaca argg (gldereference (car argg))))
          argl)
    (setq result
          (cond ((and argl (null (cdr argl))        ; fn form of prop
                      (not (member fnname *gltypenames*))
                      (glevalargs
                        (or (glvalue (caar argl) fnname (cadar argl) nil)
                            (gladj (car argl) fnname 'adj)
                            (gladj (car argl) fnname 'isa))
                        *glcontext*)))
                ((and argl (glevalargs (gldomsg (car argl) fnname (cdr argl))
                                       *glcontext*)))
                ((and (eq fnname 'funcall)        ; funcall form of prop
                      argl (cdr argl)
                      (setq arglb (mapcar #'(lambda (x)
                                              (glevalcode x *glcontext*))
                                          argl))
                      (consp (caar arglb))
                      (member (caaar arglb) '(quote function))
                      (symbolp (setq fnnameb (cadaar arglb)))
                      (or (and (null (cddr arglb))
                               (or (glvalue (caadr arglb) fnnameb
                                            (cadadr arglb) nil)
                                   (gladj (cadr arglb) fnnameb 'adj)
                                   (gladj (cadr arglb) fnnameb 'isa)))
                          (gldomsg (cadr arglb) fnnameb (cddr arglb))
                          (gluserfnc fnnameb (cdr arglb)) ) ) )
                ((and (eq fnname 'funcall)        ; funcall form of prop
                      argl (cdr argl)
                      (setq arglb (mapcar #'(lambda (x)
                                              (glevalcode x *glcontext*))
                                          argl))
                      (consp (caar arglb))
                      (member (caaar arglb) '(quote function))
                      (consp (setq tmp (cadaar arglb)))
                      (member (car tmp) '(lambda glambda)))
                  (glfuncalllambda tmp (cdr arglb)))
                ((and argl (null (cdr argl)) (eq fnname 'typeof))
                  (list (kwote (or (glviewerct (car argl))
                                   (cadar argl)))
                        'gltype))
                ((and (eq fnname 'cast)
                      argl (cdr argl) (null (cddr argl))
                      (quotep (caadr argl))
                      (setq tp (cadr (caadr argl)))
                      (or (eq (cadadr argl) 'gltype)
                          (gltypep tp)))
                  (if (and (setq tmp (glcodetype (caar argl) *glcontext*))
                           (null (second tmp)))
                      (setf (second tmp) tp))     ; set type in context also
                  (list (caar argl) tp))
                ((and (eq fnname 'coercetype)
                      argl (cdr argl) (null (cddr argl))
                      (quotep (caadr argl))
                      (setq tp (cadr (caadr argl)))
                      (or (eq (cadadr argl) 'gltype)
                          (glclassp tp)
                          (glunittypep tp)))
                  (glcoercetype (car argl) tp))
;               ((and (eq fnname 'clustertype)
;                     argl (cdr argl) (null (cddr argl)) )
;                 (setq tmp (cadr argl))
;                 (if (and (cadr tmp)
;                          (symbolp (cadr tmp))
;                          (setq clus (glcluster (cadr tmp)))
;                          (setq tp (glclusterrole clus (caar argl))))
;                     (list (kwote tp) 'gltype)))
                ((and (eq fnname 'cluster) argl (null (cdr argl)))
                  (list (kwote (glcluster
                                 (if (eq (cadar argl) 'gltype)
                                     (car argl)
                                     (or (glviewerct (car argl))
                                         (cadar argl)))))
                        'glcluster))
                ((and argl (null (cdr argl))
                      (eq fnname 'metatypeof))
                  (list (glmetatype (cadar argl)) 'gltype))
                (t (cond ((or (macro-function fnname)
                              (member fnname '(declare))))
                         ((eq fnname 'setq)     ; don't eval lhs of a setq
                          (setq argl (cons (car argl)
                             (mapcar #'(lambda (x) (glevalcodeb x *glcontext*))
                                     (cdr argl)))))
                         (t (setq argl (mapcar #'(lambda (x)
                                                   (glevalcodeb x *glcontext*))
                                               argl))))
                   (cond
                    ((and (some #'glconstantp argl)
                          (setq tmp (glinstancefn fnname argl)))
                      (list (cons tmp (glnewarglist (glarguments tmp) argl))
                            (glfnresulttype tmp)))
                    (t (setq argl (glcoerceargs fnname argl))
                       (gluserfnc fnname argl))))))
    (when (and argl (null (cdr argl)))
      (setq *gllastpropname* fnname)
      (setq *gllastproparg* (first argl))
      (setq *gllastpropcode* (car result)))        ; 10 Nov 92
    (glevalcode result *glcontext*) ))


; 11 Oct 93; 24 May 94; 26 Oct 95; 17 May 96; 28 Jan 97; 20 May 99; 26 Feb 02
; 29 Oct 02; 21 Sep 12
; Make function call given function name and arg list
(defun gluserfnc (fnname argl)
  (let (mods)
    (mapl #'(lambda (x)
              (if (glvvct (car x))
                  (rplaca x (glmaterialize (car x) nil nil))))
          argl)
    (cond ((and (eq fnname 'identity) argl (null (cdr argl)))
            (car argl))
          ((and argl (cdr argl) (null (cddr argl))   ; 30 Nov 92
                (member fnname '(+ - * / > < >= <= == != <> ^)))
            (glreducearith fnname (first argl) (second argl)))
          ((and argl
                (null (cdr argl))
                (eq fnname '-))
            (glminusfn (first argl)))
          ((and argl
                (null (cdr argl))
                (eq fnname 'float))
            (glfloatfn (first argl)))
          ((and argl (cdr argl) (null (cddr argl))
                (eq fnname 'expt))
            (glexptfn argl))
          (t (if (and (not *glquietflg*)
                      (not (or (fboundp fnname)
                               (get fnname 'gloriginalexpr)
                               (eq fnname *glspecfncompiled*)
                               (member fnname *glnoudfwarning*)
                               *glsilenceerrors*)))
                 (format t
                   "GLISP Warning: no function ~A is defined.  Arg ~A type ~A~%"
                   fnname (caar argl) (cadar argl)))
             (if (setq mods (glmodifiedargs fnname))
                 (dolist (arg argl)
                   (if (and (car mods) (symbolp (car arg)))
                       (glkillcontextentry (car arg) *glcontext*) )
                   (pop mods)))
             (if (glinline fnname)
                 (glcompopen fnname argl nil nil *glcontext*)
                 (list (cons fnname (mapcar #'car argl))
                       (glresulttype fnname (mapcar #'cadr argl))))) ) ))


; edited: 24-AUG-82
; Get the arguments to an function call for use by a user compilation 
;   function. 
(defun glusergetargs (*glexpr* *glcontext*)
  (prog (args tmp)
    (pop *glexpr*)
 a  (cond ((null *glexpr*)
            (return (nreverse args)))
          ((setq tmp (or (gldoexpr nil *glcontext* t)
                         (prog1 (glerror 'gluserfnb
                    "Function call contains illegal item.  EXPR =  ~A "
                                         *glexpr*)
                           (setq *glexpr* nil))))
            (push tmp args)
            (go a)))))

; 28 May 02; 09 Nov 04
; Print a message to user unless *glquietflg* is set
(defun glusermsg (str &optional noterpri)
  (unless *glquietflg*
    (princ str)
    (if (not noterpri) (terpri))))

; edited:  8-Aug-86 15:55 
; Try to perform an operation on a user-defined structure, which is 
;   LHS. The type of LHS is looked up on GLUSERSTRNAMES, and if found, 
;   the appropriate user function is called. 
(defun gluserstrop (lhs op rhs)
  (prog (tmp des tmpb lst unitrec)
    (setq des (cadr lhs))
      (cond ((null des)
             (go b))
            ((symbolp des)
             (if (eq (setq tmp (glgetstr des))
                     des)
                 (go b)
                 (return (gluserstrop (list (car lhs)
                                            tmp)
                                      op rhs))))
            ((atom des)
             (go b))
            ((and (setq tmp (assoc (car des)
                                   *gluserstrnames*))
                  (setq tmpb (assoc op (cadddr tmp))))
             (return (funcall (cdr tmpb)
                              lhs rhs))))
      b
      (setq lst *gluserstrnames*)
      a
      (cond ((or (atom (car lhs))
                 (null lst))
             (return))
            ((not (eq (caar lhs)
                      (caddar lst)))
             (pop lst)
             (go a)))
      (setq unitrec (car lst))
      (if (setq tmp (assoc op (cadddr unitrec)))
          (return (funcall (cdr tmp)
                           lhs rhs)))
      (return)))


; 7-Mar-88; 16-Mar-89; 24 Jan 90; 09 May 90; 29 May 90; 10 Oct 90; 25 Feb 92
; 07 Sep 93; 19 Nov 93; 23 Dec 93; 15 Feb 94; 10 Nov 94; 08 Jan 96; 05 Jun 96
; 06 Nov 06; 15 Feb 07; 20 Feb 07; 30 May 08; 05 Jan 10; 20 Jan 11
; Get the value of the property PROP from SOURCE, whose type is given
; by TYPE. The property may be a field in the structure, or may be a 
; PROP virtual field.  DESLIST is a list of object types which have
; previously been tried, so that a compiler loop can be prevented. 
(defun glvalue (source prop type deslist)
  (let (tmp propl fetchcode vlist res storemsg vtp eqprop)
   (glrepvalue
    (progn
      (setq res
            (cond ((member type deslist) nil)
                  ((and (consp source) (eq (car source) 'glstoretrap))
                    (glvalue (cadr source) prop type deslist))
                  ((glviewerp type) (glviewervalue source prop 'prop type))
                  ((glvirtualbp source type)
                    (if (eq (car source) 'list)
                        (glvirtualvalueb source prop type)
                        (if (and (eq (car source) 'progn)
                                 (consp (cdr source))
                                 (null (cddr source))
                                 (consp (cadr source))
                                 (eq (caadr source) 'list))
                            (glvirtualvalueb (cadr source) prop type)
                            (progn (setq tmp (glmatn (list (list source) type)))
                                   (glvalue (caar tmp) prop (cadr tmp)
                                            deslist)))))
                  ((and (consp type)
                        (eq (car type) 'virtual))
                   (cond ((and (consp source)
                               (eq (car source) 'glvirtual))
                           (glvirtualvalue source prop type))
                         ((and (consp source)
                               (eq (car source) 'prog)
                               (eq (caaddr source) 'return)
                               (eq (caadr (caddr source)) 'glvirtual)
                               (setq tmp (glvirtualvalue (cadr (caddr source))
                                                         prop type)))
                          (list (list (car source)
                                      (cadr source)
                                      (list 'return (car tmp)))
                                (cadr tmp)))
                         ((and (consp source)
                               (eq (car source) 'let)
                               (eq (caaddr source) 'glvirtual)
                               (setq tmp (glvirtualvalue (caddr source)
                                                         prop type)))
                          (list (list (car source)
                                      (cadr source)
                                      (car tmp))
                                (cadr tmp)))
                         ((or (symbolp source)
                              (not (glvirtualcodep source)))
                              (glvalue source prop (cadr type) deslist))
                         (t (glerror 'glvalue "Cant do a virtual") nil)))
                  ((and (consp type)
                        (eq (car type) 'units))
                    (glvalue source prop (cadr type) deslist))
                  ((setq tmp (glstrfn prop type deslist))
                    (glstrval tmp source))
                  ((setq propl (glstrprop type 'prop prop nil))
                    (glcompmsgl (list source type) 'prop propl nil *glcontext*))
                  ((setq vlist (glfindview type prop))
                   (if (symbolp vlist)
                       (list source vlist)
                       (list (list 'glbinding
                                   (cons 'self (list source type)))
                             (list 'viewer
                                   (list (list 'self type))
                                   (list (list 'out (car vlist)))
                                   (cdr vlist)))))
                  ((and (gltypep prop) (gldescendantp type prop))
                    (list source type))    ; moved to here 1/05/10
; see if the value can be found in a transparent subobject. 
                  ((some #'(lambda (ttype)
                             (and (setq tmp (glvalue '*gl* prop
                                                     (glxtrtype ttype)
                                                     (cons ttype deslist)))
                                  (setq fetchcode (glstrfn ttype type nil))))
                         (gltransparenttypes type))
                    (if (car fetchcode) (glstrval tmp (car fetchcode)))
                    (glstrval tmp source)
                    tmp)
                  ((setq eqprop (glequationprop type prop))
                    (glcompmsgl (list source type) 'prop
                                (list prop (list (car eqprop)) )
; following commented out 20 Jan 2011: does the units twice
; 'result (list 'units 'real (cadr eqprop))
                                nil *glcontext*)) ) )
; See if a "store" message, with the name of the prop suffixed by :,
; is defined.  If so, put in a trap so a store will use that message
; rather than inversion of the "get" code.   07 Sep 93
      (setq storemsg (gladdcolon prop))
      (setq vtp (if (glviewerp type) (glviewertype type) type))
      (if (glstrprop vtp 'msg storemsg nil)
          (cons (list 'glstoretrap (car res) source vtp storemsg)
                (cdr res))
          res)
     ) ) ))


; 11 Nov 91; 18 Nov 91; 28 Feb 94; 28 Apr 94; 20 Sep 06; 02 Oct 07
; Find variables in an expression
(defun glvarsin (x) (glvarsinb x nil))
(defun glvarsinb (x vars)
  (if (null x)
      vars
      (if (symbolp x)
          (if (or (member x vars) (eq x 'pi))
              vars
              (cons x vars))
          (if (and (consp x)
                   (not (member (car x) '(quote function))))
              (glvarsinl (cdr x) vars)
              vars) )))
(defun glvarsinl (l vars)
  (if (null l)
      vars
      (if (consp l)
          (glvarsinl (cdr l) (glvarsinb (car l) vars))
          (if (symbolp l)
              (if (member l vars) vars (cons l vars))
              vars))))


; 22-Apr-88
; Test whether a code-type pair represents a viewer.
; Returns the type of the view if true, else NIL 
(defun glviewerct (codetype)
  (and (consp (car codetype))
       (eq (caar codetype) 'glbinding)
       (glviewertype (cadr codetype))))


; 2-Mar-88; 08 Oct 90
(defun glviewerp (x)
  (and (consp x) (eq (car x) 'viewer)))


; 11-May-88; 28-Jan-89; 24 Jan 90; 09 Oct 92; 03 Nov 92; 23 Mar 99; 02 Apr 99
; 14 Sep 06
; Store into a left-hand side which is a viewer. 
(defun glviewerput (lhs rhs)
  (prog (vt goaltype goalstr goalfields props goalfield goallhs
           fields val tmp code parts rhsop rhstp parttypes newvar)
    (setq vt (cadr lhs))
    (setq goaltype (glviewertype vt))
    (setq goalstr (car (glstr goaltype)))
    (if (and (setq rhstp (cadr rhs))
             (eq rhstp (glviewtypep goaltype))
             (glstrprop goaltype 'msg 'glstorefromview nil))
        (return (gldomsg lhs 'glstorefromview (list rhs))) )
; If rhs is already of the viewer type of lhs, just store it
    (if (and (eq goaltype rhstp)
             (null (cddar lhs)))  ; i.e. only a self binding
        (return (glputfn (list (cadadr (car lhs)) goaltype) rhs nil)))
    (if (and (consp goalstr)
             (eq (cadr goalstr) (cadar (cadr vt)))
             (setq tmp (glvalue nil 'gltransfernames goaltype nil))
             (quotep (car tmp)))
        (progn (setq fields (cadar tmp))
               (setq props (getf (cdr (glstr goaltype)) 'prop))
               (dolist (field fields)
                 (setq tmp (assoc field props))
                 (push (and tmp (consp (cadr tmp)) (consp (caadr tmp))
                            (caaadr tmp))
                       goalfields))
               (setq goalfields (nreverse goalfields))
               (setq goallhs (glbindingtocodetype (car lhs))) )
        (setq fields (or (glgetfields goaltype)
                         (list 'self))) )
    (setq rhstp (cadr rhs))
    (cond ((quotep (car rhs))
            (setq rhsop (caar rhs))
            (setq parts (cadar rhs))
            (setq parttypes (if (consp rhstp) (cdr rhstp)
                                              (cdr (glstr rhstp)) ) ))
          ((and (cdr fields)
                (not (or (symbolp (car rhs))
                         (and (consp (car rhs))
                              (eq (caar rhs) 'prog1)
                              (symbolp (cadar rhs)))
                         (glvvct rhs)
                         (glvirtualct rhs))))
            (setq newvar (glgensym 'glvar))))
    (dolist (field fields)
      (setq goalfield (or (pop goalfields) field))
      (when (setq val (cond (rhsop (setq tmp (kwote (pop parts)))
                                   (list tmp
                                         (cond ((eq (car rhstp) 'listof)
                                                 (cadr rhstp))
                                               ((eq (car rhstp) 'list)
                                                 (pop parttypes))
                                               (t (glconstanttype tmp)))))
                            ((and (eq field 'self)
                                  (null (cdr fields)))
                              rhs)
                            (t (glvalue (or newvar (car rhs))
                                        field rhstp nil))))
            (setq tmp (glputfn (if goallhs
                                   (glvalue (car goallhs) goalfield 
                                            (cadr goallhs) nil)
                                   (glviewervalue (car lhs) goalfield
                                                  'prop (cadr lhs)))
                               val nil))
            (push (car tmp) code)))
    (setq code
          (cond (newvar (cons 'let
                              (cons (list (list newvar (car rhs)))
                                    (nreverse (cons newvar code)))))
                ((and (eq (car fields) 'self)
                      (null (cdr fields)))
                  (cons 'progn (nreverse code)))
                (t (cons 'progn
                         (nreverse (cons
                                    (if (glviewerct rhs)
                                        (glbindingtocode (car rhs))
                                        (car rhs))
                                    code))))))
    (return (list code (cadr rhs)) ) ))


; Edited 7-Mar-88; 08 Oct 90
(defun glviewertype (x)
  (and (consp x)
       (eq (car x) 'viewer)
       (cadr (caaddr x))))


; 9-Mar-88; 24 Jan 90; 06 Oct 92; 07 Oct 92; 12 Nov 92; 07 Sep 93; 13 Oct 93
; 13 Jan 11; 20 Jan 11
; Get the property PROP from SOURCE, which is described by the viewer VTYPE 
(defun glviewervalue (source prop proptype vtype)
  (let (vl propl tmp (viewtype (glviewertype vtype)) eqprop)
; first look for prop as a defined property of the vtype 
     (cond ((and (eq proptype 'prop)
                 (setq tmp (glstr viewtype))
                 (consp (car tmp))
                 (eq (caar tmp) prop))
             (list (if (and (consp source) (eq (car source) 'glbinding))
                       (glbindingtocode source)
                       (if (symbolp source)
                           (list 'prog1 source)
                           source))
                   (cadar tmp)) )
           ((and (eq proptype 'prop)
                 (setq vl (assoc prop (cadddr vtype))))
             (setq tmp (glprogn (cadr vl)
                                (list (glbindingtocontext source))))
             (list (caar tmp) (cadr tmp)))
           ((and (setq propl (glstrprop viewtype proptype prop nil))
                 (setq tmp (glcompmsgl (list source vtype)
                                       proptype propl nil nil)))
              tmp)
           ((and (eq proptype 'prop)
                 (null (fourth vtype))
                 (setq tmp (glstrfn prop viewtype nil)))
             (glstrval tmp (glbindingtocode source)))
           ((and (eq proptype 'prop)
                 (setq propl (glstrprop viewtype 'views prop nil)))
             (setq tmp (glmaterialize (list source vtype) nil nil))
             (glvalue (car tmp) prop (cadr tmp) nil) )
           ((setq eqprop (glequationpropv source vtype prop))
             (glcompmsgl (cdadr source) 'prop
                         (list prop (list (car eqprop)) )
; following commented out 20 Jan 2011: does the units twice
; 'result (list 'units 'real (cadr eqprop))
                         nil *glcontext*) ) ) ))

; 07 Jan 94
; Get names and types of views of type.
(defun glviewnames (type)
  (mapcan #'(lambda (x) (list (list (first x) (second x))))
          (glget type 'views)) )

; 17 Jan 94
; Get the result type of a named view
(defun glviewtype (type viewname)
  (let (tmp)
    (if (setq tmp (glgetprop type 'views viewname))
        (cadr tmp) ) ))

; 02 Apr 99
; Get the goal type from a view type
(defun glviewtypegoal (type)
  (getf (cddr (glstrprop type 'msg 'materialize nil)) 'result) )


; 13 Feb 94; 17 Feb 94; 02 Apr 99
; Test if a type is a view type.  If so, return the destination view type.
(defun glviewtypep (type)
  (or (and (symbolp type)
           (glnonbasictypep type)
           (glstrprop type 'prop 'glbasisvars nil)
           (glstrprop type 'msg 'glbuildfromview nil)
           (first (getf (cdr (glstr type)) 'supers)) )
      (glviewertype type)) )

; 10 Oct 90; 03 Nov 92; 23 Dec 93
; Test whether a code-type pair represents a virtual object, of the form:
; Code = (LIST (QUOTE <type>) (QUOTE <fieldname>) <value> ...)
; Type = (VIRTUAL <type> (<fieldname> <fieldtype>) ...)
(defun glvirtualbp (code type)
  (and (consp type)
       (eq (car type) 'virtual)
       (cddr type)
       (glstr (cadr type))
       (glvirtualcodep code)
       (cadr type)) )

; 23 Dec 93; 15 Feb 94; 01 Oct 96
; Test if code constructs a virtual object, either directly or inside
; a let or progn.
; prognflg = t if code is contents of implicit progn, i.e. a list of code items
(defun glvirtualcodep (code &optional prognflg)
  (and (consp code)
       (or (eq (car code) 'glvirtual)
           (and (eq (car code) 'glstoretrap)
                (glvirtualcodep (cadr code)))
           (if (eq (car code) 'list)
               (and (quotep (cadr code))
                    (consp (cadadr code))
                    (eq (car (cadadr code)) 'virtual) )
               (if (or prognflg
                       (member (car code) '(let progn)))
                   (glvirtualcodep (car (last code)) nil) ) ) )) )

; Edited 22-Apr-88; 24-Sep-88; 11 Mar 92
; Test whether a code-type pair represents a viewer.
(defun glvirtualct (codetype)
  (and (consp (car codetype))
       (eq (caar codetype) 'glvirtual)))
    ;   (consp (cadr codetype))
    ;   (eq (caadr codetype) 'virtual)


; edited: 29-Sep-88
; Perform a store into a LHS which is a virtual object. 
(defun glvirtualput (lhs rhs)
  (let (code tmp)
    (dolist (pair (cddar lhs))
      (setq tmp (glputfn (cdr pair)
                         (glvalue (car rhs) (car pair) (cadr rhs) nil)
                         nil))
      (push (car tmp) code))
     (list (cons 'progn (nreverse (cons (car lhs) code)))
           (cadr lhs))))


; edited: 9-Mar-88; 24-Sep-88
; Get property PROP from SOURCE, which is described by the virtual type VTYPE
(defun glvirtualvalue (source prop vtype)
  (prog (vl propl tmp)
; first look for prop as a defined field of the vtype 
    (cond ((setq vl (assoc prop (cddr source)))
            (return (cdr vl)))
          ((and (setq propl (glstrprop (cadr vtype) 'prop prop nil))
                (setq tmp (glcompmsgl (list source vtype)
                                      'prop
                                      propl nil nil)))
            (return tmp)))))


; 10 Oct 90
; Test for a viewer or second form of virtual
(defun glvvct (codetype)
  (or (glviewerct codetype)
      (glvirtualbp (car codetype) (cadr codetype)) ) )
       

; 03 Nov 92; 05 Nov 92
; Extract a basic type from a units type description
(defun glxtrbasictype (type)
  (if (symbolp type)
      type
      (if (glunittypep type) (cadr type))) )


; 3-DEC-82; 14 Sep 06
; Extract the code and variable from a FUNCTION list.  If there is no variable,
; a new one is created. The result is a list of the variable and code.
(defun glxtrfn (fnlst)
  (let (tmp)
     
; if only the function name is specified, make a lambda form. 

    (if (symbolp (cadr fnlst))
        (setf (cadr fnlst)
              (list 'lambda
                    (list (setq tmp (glgensym 'glvar)))
                    (list (cadr fnlst) tmp))))
    (if (cdddr (cadr fnlst))
        (setf (cdr (cdadr fnlst))
              (list (cons 'progn (cddadr fnlst)))))
    (list (caadr (cadr fnlst))
          (caddr (cadr fnlst)))))

; 7-Mar-88; 27 Nov 89; 28 Mar 90; 03 Apr 90; 24 May 90; 18 Mar 92; 15 Oct 92
; 05 Nov 92; 10 Oct 96; 15 May 03
; Extract an atomic type name from a type spec which may be either 
;   <type> or (A <type>) . 
(defun glxtrtype (type)
  (cond ((symbolp type) type)
        ((atom type) nil)
        ((or (member (car type) '(glstructure viewer units setof sequence))
             (and (member (car type) *gltypenames*)
                  (not (eq (car type) 'arrayof)))
             (assoc  (car type) *gluserstrnames*))
          type)
        ((and (symbolp (car type))
              (glclusterspec (car type)))
          (glfindclustertype type))
        ((eq (car type) '^) (or (glgetpointer (cadr type))
                                type))
        ((eq (car type) '^.) (or (glpointsto (cadr type))
                                 type))
        ((and (symbolp (car type))
              (consp (cdr type)))
          (glxtrtype (cadr type)))
        (t (glerror 'glxtrtype " ~A  is an illegal type spec." type)
           nil)))


; 11-Sep-87; 27 Nov 89; 03 Nov 92; 13 May 93; 01 Oct 93
; Extract a -real- type from a type spec. 
(defun glxtrtypeb (type)
  (cond ((null type) nil)
        ((symbolp type)
         (if (glbasictypep type)
             type
             (glxtrtypeb (glgetstr type))))
        ((atom type) nil)
        ((or (member (car type) '(glstructure viewer units arrayof))
             (member (car type) *gltypenames*)
             (assoc (car type) *gluserstrnames*))
          type)
        ((and (symbolp (car type)) (cdr type))
          (glxtrtypeb (cadr type)))
        (t (glerror 'glxtrtypeb " ~A  is an illegal type spec." type)
           nil)))


; 11-Sep-87; 27 Nov 89; 03 Nov 92; 14 Mar 97; 28 Sep 04
; Extract a -real- type from a type spec. 
(defun glxtrtypec (type)
  (and (or (symbolp type)
           (and (consp type)
                (or (eq (car type) 'glstructure)
                    (eq (car type) (cadr type)))))
       (if (glbasictypep type)
           type
           (glxtrtype (glgetstr type)))))

; 07 Jan 00
; modified glxtrtypec for gldatanames
(defun glxtrtypecb (type)
  (let (str)
    (and (or (symbolp type)
             (and (consp type)
                  (eq (car type) 'glstructure)))
         (if (glbasictypep type)
             type
             (progn (setq str (glgetstr type))
                    (if (and (consp str)
                             (not (member (car str) *gltypenames*)))
                        str
                        (glxtrtype str))))) ))

; Edited 22-Apr-88; 5-May-89
; Given a code-type pair, get the type from which to get messages. 
(defun glxtrtyped (codetype)
  (or (glviewerct codetype)
      (and (consp (cadr codetype))
           (eq (caadr codetype) 'virtual)
           (cadadr codetype))
      (glxtrtype (cadr codetype))))

; 03 Dec 92
(defun glxtrtypee (codetype)
  (or (glxtrtyped codetype)
      (and (glconstantp (car codetype))
           (glconstanttype (glconstval (car codetype))))))

; 01 Apr 99
(defun glxtrtypef (codetype)
  (or (and (consp (cadr codetype))
           (eq (caadr codetype) 'units)
           (cadadr codetype))
      (glxtrtyped codetype) ) )

; 26 Oct 06
(defun glxtrtypeg (type)
  (let ((tp (glxtrtypeb type)))
    (if (and (consp tp) (eq (car tp) 'units))
        (cadr tp)
        tp) ))

; 29 Nov 10; 25 Jan 11
; Extract a -real- type from a type spec, recursively.
(defun glxtrtyper (type)
  (cond ((null type) nil)
        ((symbolp type)
         (if (glbasictypep type)
             type
             (glxtrtyper (glgetstr type))))
        ((atom type) nil)
        ((eq (car type) '^) type)
        ((or (member (car type) *gltypenames*)
             (member (car type) '(sequence arrayof))
             (assoc (car type) *gluserstrnames*) )
          (if (eq (car type) 'crecord)
              (cons (car type)
                    (cons (cadr type)
                          (mapcar #'glxtrtyper (cddr type))))
              (cons (car type) (mapcar #'glxtrtyper (cdr type))) ) )
        ((eq (car type) 'units)
          (list (car type) (glxtrtyper (cadr type)) (caddr type)) )
        ((member (car type) '(glstructure viewer))
          type)       ; ***** not implemented
        ((and (symbolp (car type)) (cdr type))
          (if (ciwrappernamep (car type))
              (glxtrtyper (cadr type))
              (list (car type) (glxtrtyper (cadr type)) ) ) )
        (t (glerror 'glxtrtyper " ~A  is an illegal type spec." type)
           nil)))

; 07 Apr 08
; Get a (units ...) type from a given type, assumed to be glunittypep.
(defun glxtrtypeu (type)
  (if (and (consp type)
           (eq (car type) 'units))
      type
      (car (glstr type))))

; 09 Nov 11
; roll our own so it can by optimized by patterns
(gldefun string-chars ((s string))
  (nreverse (let (res)
              (dotimes (i (length s) res)
                (setq res (cons (char s i) res))))))

; 09 Nov 11
; roll our own so it can by optimized by patterns
(gldefun string-char-codes ((s string))
  (nreverse (let (res)
              (dotimes (i (length s) res)
                (setq res (cons (char-code (char s i)) res))))))

(setq *gllispdialect* 'commonlisp)
(glispglobals (*gltrue* boolean) (*glfalse* boolean))

; (glinit) must be executed before glisp is used.
