; heap.lsp             Gordon S. Novak Jr.         ; 21 Nov 11

; Copyright (c) 2011 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 19 Sep 07; 20 Sep 07; 20 Jan 09; 03 Feb 09; 05 Feb 09; 10 Feb 09; 12 Feb 09
; 19 Feb 09; 24 Feb 09; 10 Mar 09; 26 Mar 09; 02 Apr 09; 20 Jul 09; 12 Aug 09
; 28 Aug 09

; a generic heap should have a mapping, item -> value
; as well as a comparison function to compare values.

; (makecspec 'heap '((item part)) '((sort-value name) (sort-direction max)))
; (setq myh (a heaptype1))
; (gldefun t116 ((h heaptype1) itm) (insert-item h itm))
; (t116 myh (a part name "foo"))
; (gldefun t117 ((h heaptype1)) (remove-item h))

; some problems:
; 1. We might like for a heap to be an expandable array,
;    but to put the filled-size in arr[0].
;    That's a bit flakey due to possible type error if heap item not int.
; 2. Props such as size of exparr turn into a loop if subclass does not
;    define size and thearray == self.
(glispobjects

; expandable array with fill pointer
(exparr (crecord exparr (thearray (arrayof anything))
                        (filled-size integer))
 prop ((size      ((if (null (thearray self)) 0 (size (thearray self)))))
       (minsize   (10)))
  msg ((aref      (glambda (self i) (aref (thearray self) i)) )
       (expand    exparr-expand specialize t)
       (expand?   exparr-expand? specialize t)
       (add       exparr-add specialize t)
       )
  )

(heap  (self anything)
  prop ((heapsize ((filled-size self)) result heapindex)
        (length   ((1- (heapsize self))) ) )
  adj  ((empty    ((zerop (heapsize self)))))
  msg  ((heapify  heap-heapify specialize t)
        (exchange (glambda (self i j)
                    (let (tmp)
                      (tmp = (aref self i))
                      ((aref self i) = (aref self j))
                      ((aref self j) = tmp) )) )
        (new      (glambda (self siz)
                    (expand (a (typeof self)) siz))
                         result (typeof self))
        (initialize (glambda (self) ((filled-size self) = 0) self) )
        (insert-item   heap-insert-item specialize t)
        (remove-item   heap-remove-item specialize t) )
 supers (exparr) )

(heapitem anything
  prop ((sort-value      (self))
        (sort-before-fn  ('<))
        (sort-direction  ('min))     ; default
        (implementation  (self)  result (strof (typeof self)) ) )
  msg  ((sort-before     heap-item-sort-before open t) ) )

; 21 Nov 11
; heap item that has an explicit priority field
(heapitempri anything
  prop ((sort-value      (priority)))
 supers (heapitem))

(heapindex integer
  prop ((parent   ((truncate self 2)) result heapindex)
        (left     ((* self 2)) result heapindex)
        (right    ((+ 1 (* self 2))) result heapindex) )
  )

(myheap (list (filled-size integer)
              (thearray (arrayof heapint)))
  supers (heap))

(heapint (arrayof integer)
  prop ((sort-value     identity))      ; these should go on a view of the item
  msg  ((sort-before-fn <))
  supers (heapitem) )

(heapcity (arrayof astar)           ; route-finding a* example
  msg  ((sort-before-fn astar))
  supers (heapitem) )

) ; glispobjects

; dummy for Lisp
(defun free-memory (ptr size) nil)

; Expand an expandable array if there is no more room
(gldefun exparr-expand? ((self exparr))
  (if (>= (filled-size self) (size self))
      (expand self (+ (truncate (* (size self) 3) 2) 2)) ) )

; Expand an expandable array to at least size n
(gldefun exparr-expand ((self exparr) (n integer))
  (let (newarr oldsize newsize)
    (oldsize = (size self))
    (newsize = (max (minsize self) n))
    (if (> newsize oldsize)
        (progn (newarr = (make-array newsize))
               (dotimes (i oldsize)
                 ((aref newarr i) = (aref self i)) )
               (free-memory (thearray self) oldsize)
               ((thearray self) = newarr) ) )
    self))

; Add a new item at the end of an expandable array
(gldefun exparr-add ((self exparr) (item anything))
  (expand? self)
  ((aref self (filled-size self)) = item)
  ((filled-size self) += 1)
  self)

; Heap, cf. Cormen
(gldefun heap-heapify ((self heap) (i heapindex))
  (let (l r largest)
    (l = (left i))
    (r = (right i))
    (if (and (<= l (heapsize self))
             (sort-before (aref self l) (aref self i)))
        (largest = l)
        (largest = i))
    (if (and (<= r (heapsize self))
             (sort-before (aref self r) (aref self largest)))
        (largest = r))
    (if (largest != i)
        (progn (exchange self i largest)
               (heapify self largest) ) ) ))

(gldefun heap-insert-item ((self heap) (new (typeof (aref self 1))))
  (let (i)
    ((heapsize self) += 1)
    (i = (heapsize self))
    (expand? self)
    (while (and (> i 1)
                (sort-before (cast new (typeof (aref self 1)))
                             (aref self (parent i))) )
      ((aref self i) = (aref self (parent i)))
      (i = (parent i)) )
    ((aref self i) = new)
    self))

; remove the next element from a heap
(gldefun heap-remove-item ((self heap))
  (let (themax (i heapindex))
    (if (> (heapsize self) 0)
        (progn (themax = (aref self 1))
               (setf (aref self 1)
                     (aref self (heapsize self)))
               (setf (aref self (heapsize self)) *glnull*) ; to allow GC
               ((heapsize self) _- 1)
               (i = 1)
               (heapify self i)
               (cast themax (datatype self)) )) ))

(gldefun heap-item-sort-before ((self heapitem) (other heapitem))
  (result boolean)
  (if ((sort-direction self) == 'min)
      (funcall (sort-before-fn self) (sort-value self)
               (sort-value other))
      (funcall (sort-before-fn self) (sort-value other)
               (sort-value self)) ) )

; edit the numbers in the following function
; (setq myh (testheap))
; (gldefun t117 ((h heaptype25)) (remove-item h))
; (dotimes (i 20) (print (t117 myh)))
(gldefun testheap ()
  (let ((h (a heaptype25)))
    (dolist (nm '("foo" "bar" "baz" "bat" "bam" "bamboole" "del" "epi"
                  "bus" "buzzard" "banana" "zebra" "mule" "fish" "horse"
                  "rabbit"))
      (insert-item h (cast (a part name nm) 'item25)) )
    h))
