; info.lsp                  Gordon S. Novak Jr.              21 Sep 16

; Copyright (c) 2016 Gordon S. Novak Jr. and The University of Texas at Austin
; All rights reserved.

; 11 Sep 92; 03 Nov 93; 29 Dec 94; 19 Apr 95; 19 Sep 95; 26 Sep 95
; return information about a function, glisp object, etc.
; To add doc for a function:
;   1. Put arg list under 'info-args
;   2. Put list of doc strings under 'glinfo
(defmacro info (&rest args) `(infob (unq ',(first args))))
(defun infob (arg)
  (let (fndef str args res)
    (if (null arg) (setq arg (conn-tree-select *lisp-fn-tree*)))
    (when (symbolp arg)
	(cond ((setq fndef (glgetd arg))
	        (princ (cons arg (cadr fndef)))
		(when (setq res (glfnresulttype arg))
		  (princ " : ") (princ res))
		(terpri))
	      ((fboundp arg)
		 (if (and (consp (setq fndef (symbol-function arg)))
			  (not (eq (car fndef) 'macro)))
		     (progn (princ (cons arg (caddr fndef)))
			    (when (setq res (glfnresulttype arg))
			      (princ " : ") (princ res))
			    (terpri))
		     (if (setq args (or 
; (get arg 'system:debug)  ; 21 Sep 16 causes trouble in new GCL
					(get arg 'info-args)))
			 (progn (princ (cons arg
					     (subset #'symbol-package args)))
				(when (setq res (glfnresulttype arg))
				  (princ " : ") (princ res))
				(terpri))
			 (progn (help arg) (terpri)))) )
	      ((boundp arg) (format t "~a = ~A~%" arg (eval arg)))
	      ((setq str (glstr arg)) (pprint (car str)) ) )
	(if (setq str (get arg 'glinfo))
	    (if (stringp (car str))
		(dolist (s str) (princ s) (terpri))
	        (progn (princ str) (terpri))) ) ) ))

(setf (get 'nth 'info-args) '(n lst))
(setf (get 'nth 'glinfo)
      '("Get the nth element from a list.  First element is 0."))
