;  transb.lsp            Gordon S. Novak Jr.         ; 25 Feb 09

; Copyright (c) 2009 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.


; 28 Sep 97; 25 May 01; 16 Dec 01; 27 May 02; 28 Jul 02; 02 Sep 02; 04 Nov 02
; 29 Sep 03; 12 Oct 03; 03 Jun 04; 22 Jun 04; 28 Jan 05; 01 Feb 05; 20 Jan 07

(defvar *zp* "")
(defvar *zpp* "")
(defvar *zn* 0)
(defvar *zf* "")
(defvar *zs* nil)
(defun sf (str) (progn (setq *zp* (concatenate 'string *zpp* str)) nil))
(defun sn (n) (progn (setq *zn* (* n 1000)) nil))

;
(defun fnm (x &optional (prefix *trprefix*) (suffix ""))
  (concatenate 'string prefix (stringify x) suffix))


(defun zz (nlist &optional (n 1))
  (let (line start nextstart beginline line2 line1 lng from nlines quit nbad)
    (unless (consp nlist) (setq nlist (list nlist)))
    (if (> n 1)
	(progn (dotimes (i (1- n)) (setq nlist (cons (1+ (car nlist)) nlist)))
	       (setq nlist (nreverse nlist))))
    (setq nlist (mapcar #'(lambda (x) (if (and (numberp x) (< x 1000))
					  (+ x *zn*) x))
			nlist))
    (with-open-file (outfile (file-name "a.c" *directory* "")
			     :direction :output
			     :if-exists :supersede)
      (setq beginline nil)
      (setq line2 nil)
      (setq line1 nil)
      (dolist (nm nlist)
	(with-open-file (infile (fnm nm *zp* "") :direction :input
				:if-does-not-exist nil)
	  (setq start nil)
	  (setq quit nil)
	  (setq nlines 0)
	  (setq nbad 0)
	  (while (not (or quit (null infile)
			  (eq (setq line (read-line infile nil 'zzeofvalue))
			      'zzeofvalue)
			  (and (> (length line) 4)
			       (string= line "END " :end1 4)) ))
	    (setq nextstart start)
	    (incf nlines)
	    (if (or (and (not start) (> nlines 200))
		    (> nbad 100))
		(progn (setq quit t)
		       (system (concatenate 'string "cp "
					    (fnm nm *zp* "") " a.c"))
		       (princ "Base 64") (terpri)))
	    (if (> (setq lng (length line)) 5)
		(if (or (and (string= line "begin" :end1 5)
			     (setq beginline t))
			(string= line "table" :end1 5)
			(and (>= lng 61)
			     (string= line "M" :end1 1)))
		    (setq start (setq nextstart t))
		    (if (string= line "BEGIN" :end1 5)
			(setq nextstart t)
		        (if (string= line "END" :end1 3)
			    (setq start (setq nextstart nil))))))
	    (when start
	      (if (and (> lng 7)
		       (string= line "begin " :end1 6))
		  (progn (princ "begin 600 a.out" outfile) (terpri outfile))
		  (if (bdl line)
		      (if (and (>= lng 3) (string= line "end" :end1 3))
			  (progn
			    (if line2 (progn (princ line2 outfile)
					     (terpri outfile)))
			    (if line1 (progn (princ line1 outfile)
					     (terpri outfile)))
			    (princ "end" outfile) (terpri outfile))
			  (if (and (>= lng 1) (not (string= line "M" :end1 1)))
			      (progn (setq line2 line1)
				     (setq line1 line)
				     (incf nbad)) ))
		      (progn (princ line outfile)
			     (terpri outfile))))
	      (setq start nextstart)) ) ) ) )
    (when (not quit)
      (system "uudecode a.c")
      (system "xv a.out")) ))

(defun bdl (line)
  (let ((lng (length line)))
    (or (< lng 1)
	(not (string= line "M" :end1 1))
	(and (>= lng 7) (string= line "Message" :end1 7))
	(and (>= lng 5) (string= line "Mime " :end1 5))
	(and (>= lng 5) (string= line "Mime-" :end1 5)) ) ))

(defun zm (st n &optional (delta 1) (nn 1))
 (dotimes (i n) (eval (list 'zz (+ st (* delta i)) nn))))

(defun zh (nlist &optional (n 10))
  (let (line nlines done fname strm lng)
    (unless (consp nlist) (setq nlist (list nlist)))
    (if (> n 1)
	(progn (dotimes (i (1- n)) (setq nlist (cons (1+ (car nlist)) nlist)))
	       (setq nlist (nreverse nlist))))
    (setq nlist (mapcar #'(lambda (x) (if (and (numberp x) (< x 1000))
					  (+ x *zn*) x))
			nlist))
    (dolist (nm nlist)
      (setq fname (fnm nm *zp* ""))
      (when (setq strm (open fname :direction :probe))
	(close strm)
        (with-open-file (infile (fnm nm *zp* "") :direction :input
			      :if-does-not-exist nil)
	  (setq done nil)
	  (setq nlines 0)
	  (while (not (or done (null infile)
			  (eq (setq line (read-line infile nil 'zzeofvalue))
			      'zzeofvalue)
			  (> (incf nlines) 50)))
	    (setq lng (length line))
	    (if (and (< nlines 30)
		     (> (setq lng (length line)) 5)
		     (string= line "From:" :end1 5))
		(progn
		  (setq *zf* (subseq line 6))
		  (if (member *zf* *zs* :test #'string=)
		      (setq done t))))
	    
	    (when (and (> lng 9)
		       (string= line "Subject: " :end1 9))
	      (format t "~D  ~A~%" nm (subseq line 8 (length line)))
	      (setq done t)) ) ) ))
    ))

(defun spam (n)
  (zh n 1)
  (push *zf* *zs*))


; (vv "d/")
(defun vv (dirstring &optional flag)
  (let (line stream quit)
    (system (cstr "ls " dirstring " | cat >qqzdirfile"))
    (setq stream (open "qqzdirfile" :direction :input :if-does-not-exist nil))
    (while (not (eq (setq line (read-line stream nil 'zzeofvalue))
		    'zzeofvalue))
      (print line)
      (if flag
	  (progn (system (cstr "uudecode " dirstring line))
		 (system "xv a.out"))		 
	  (system (cstr "xv " dirstring line))) )
    (system "rm qqzdirfile") ))

(defun string-subst (new old str)
  (let (pos)
    (if (string= str "")
	""
        (if (setq pos (string-find old str))
	    (concatenate 'string (subseq str 0 pos) new
			 (string-subst new old
				       (subseq str (+ pos (length old))
					       (length str))))
	    str))))

(defun string-find (item str)
  (string-findb item str 0))

(defun string-findb (item str n)
  (if (>= (length str) (+ n (length item)))
      (if (string= item str :start2 n :end2 (+ n (length item)))
	  n
	  (string-findb item str (1+ n)))
      nil))

; perform a set of unix commands on the files in a directory.
; commands is a list of strings, with $ for the file name.
(defun mapdir (dirstring commands &optional grepstring)
  (let (line stream quit)
    (system (cstr "ls " dirstring
		   (if grepstring
		       (cstr " | grep '" grepstring "' | cat >qqzdirfile")
		       " | cat >qqzdirfile")))
    (setq stream (open "qqzdirfile" :direction :input :if-does-not-exist nil))
    (while (not (eq (setq line (read-line stream nil 'zzeofvalue))
		    'zzeofvalue))
      (dolist (command commands)
	(system (string-subst line "$" command)) ) )
    (system "rm qqzdirfile") ))

; perform a unix command on the files in a directory.
; fn is called with a file name string and returns a command string.
; if test is non-nil, prints rather than executes
(defun mapdirb (dirstring fn &optional grepstring test)
  (let (line stream quit command)
    (system (cstr "ls " dirstring
		   (if grepstring
		       (cstr " | grep '" grepstring "' | cat >qqzdirfile")
		       " | cat >qqzdirfile")))
    (setq stream (open "qqzdirfile" :direction :input :if-does-not-exist nil))
    (while (not (eq (setq line (read-line stream nil 'zzeofvalue))
		    'zzeofvalue))
      (setq command (funcall fn line))
      (if command (if test (print command) (system command))))
    (system "rm qqzdirfile") ))

; perform a unix command on the files in a directory.
; fn is called with filename and dir strings and returns a command string.
; if test is non-nil, prints rather than executes
(defun mapdirc (dirstring fn &optional grepstring test)
  (let (line stream quit command)
    (system (cstr "ls " dirstring
		   (if grepstring
		       (cstr " | grep '" grepstring "' | cat >qqzdirfile")
		       " | cat >qqzdirfile")))
    (setq stream (open "qqzdirfile" :direction :input :if-does-not-exist nil))
    (while (not (eq (setq line (read-line stream nil 'zzeofvalue))
		    'zzeofvalue))
      (setq command (funcall fn line dirstring))
      (if command (if test (print command) (system command))))
    (system "rm qqzdirfile") ))

; Make a lot of files by copying a set of source lines.
; (ww "rmnp/" "d6" ".html" 99 picdata)
(defun ww (dirstring prefix suffix n source)
  (let (filename stream)
    (dotimes (i n)
      (setq filename (concatenate 'string prefix
				  (string-subst "0" " " (format nil "~2d" i))))
      (setq stream (open (concatenate 'string dirstring filename suffix)
			 :direction :output
			 :if-does-not-exist :create))
      (dolist (line source)
	(if (not (consp line)) (setq line (list line)))
	(dolist (item line)
	  (princ (if (eq item '*) filename item) stream) )
	(terpri stream) )
      (close stream) ) ))

(setq picdata '(
"<HTML>"
("<!--  " * ".html    Gordon S. Novak Jr.    Jan 2007 -->")
"<HEAD><TITLE></TITLE></HEAD>"
"<BODY>"
"<H3></H3>"
("<IMG SRC=\"picsdir/" * "b.jpg\"> <P>")
("")
("<P><A href=\"picsdir/" * ".jpg\">[Large version (" + " KB)]</A>")
"<P><SMALL>Nikon D200, AF-S Nikkor 18-200mm 1:3.5-5.6 G ED DX VR Lens, f/8, 1/ sec, mm.</SMALL></P>"
"<P><A href=\"../rmnp.html\">"
"Rocky Mountain National Park: The High Peaks</A>"
"</BODY>"
"</HTML>"
))

; Make a lot of files by copying a set of source lines.
; (wwf "piczdir" picdata)  ; where file piczdir is from ls -l
(defun wwf (dirfile source)
  (let (line filename stream done kbytes prefix (suffix ".html"))
    (with-open-file (indirfile dirfile :direction :input
			      :if-does-not-exist nil)
      (while (not (or (null indirfile)
		      (eq (setq dirline (read-line indirfile nil 'zzeofvalue))
			  'zzeofvalue)))
	(setq prefix (subseq dirline 46 50))
	(setq kbytes (subseq dirline 25 29))
	(setq stream (open (concatenate 'string prefix suffix)
			   :direction :output
			   :if-does-not-exist :create))
	(dolist (line source)
	  (if (not (consp line)) (setq line (list line)))
	  (dolist (item line)
	    (princ (if (eq item '*) prefix
		       (if (eq item '+) kbytes item))
		   stream) )
	  (terpri stream) )
	(close stream)) ) ))

; move image files to start with given prefix
; (mvimg "c/" "c")
(defun mvimg (dir prefix)
  (mapdirb dir
    (function (lambda (file)
      (concatenate 'string "mv " dir file " " dir prefix
		   (subseq file	(- (length file) 7) (- (length file) 4))
		   ".jpg")))))

(defvar xreflinea
  "<P><A href=\"http://www.cs.utexas.edu/users/novak/rmnp.html\">")
(defvar xreflineb
  "Rocky Mountain National Park: The High Peaks</A>")

; 16 Dec 01
; Fix a set of files by copying them with some changes
; dirfile is a list of file names produced by ls
; dir should be e.g. "rmnp/"
(defun fixfiles (dirfile dir)
  (let (line filename done)
    (with-open-file (indirfile dirfile :direction :input
			      :if-does-not-exist nil)
      (while (not (or (null indirfile)
		      (eq (setq filename (read-line indirfile nil 'zzeofvalue))
			  'zzeofvalue)))
	(with-open-file (outfile "temp.del" :direction :output
				 :if-exists :supersede)
	  (setq done nil)
	  (with-open-file (infile (concatenate 'string dir filename)
				  :direction :input
				:if-does-not-exist nil)
	    (while (not (or (null infile) done))
	      (setq line (read-line infile nil 'zzeofvalue))
	      (if (eq line 'zzeofvalue)
		  (setq done t)
		(if (and (> (length line) 6)
			 (string= (string-upcase line) "</BODY>" :end1 7))
		    (progn
		      (princ xreflinea outfile) (terpri outfile)
		      (princ xreflineb outfile) (terpri outfile))))
	      (if (not done)
		  (progn (princ line outfile) (terpri outfile)))
	      )))
	(system (concatenate 'string "mv temp.del "
			     (concatenate 'string dir filename))) ) ) ))

; Make a list of files in a directory, ((dir file length) ...)
(defun lsfiles (dir)
  (let (line files)
    (system (cstr "ls -l " (stringify dir) ">temp.del"))
    (with-open-file (indirfile "temp.del" :direction :input
			      :if-does-not-exist nil)
      (while (not (or (null indirfile)
		      (eq (setq line (read-line indirfile nil 'zzeofvalue))
			  'zzeofvalue)))
	(if (> (length line) 45)
	    (push (list dir (subseq line 46 (length line))  ; file name
			(read-from-string (subseq line 21 32)))  ; length
		  files) ) ) )
    (nreverse files)))

; (setq allfiles nil)
; (dolist (file '("dir" ...))
;   (setq allfiles (nconc (lsfiles (cstr "dsc3/" file)) allfiles)) )
; (car (setq sfiles (sort allfiles #'< :key #'caddr)))

; find duplicated files from a list as above
(defun dupfiles (lst)
  (let (samel same dif res one)
    (while lst
      (setq lng (caddr (car lst)))  ; length
      (setq samel nil)
      (while (eql (caddr (car lst)) lng)
	(push (car lst) samel)
	(setq lst (cdr lst)))
      (while (> (length samel) 1)
	  (progn
	    (setq samel (sort samel #'string< :key #'car))
	    (setq one (car samel))
	    (setq same nil)
	    (setq dif nil)
	    (dolist (file (cdr samel))
	      (if (eql 0 (system
			   (cstr "cmp -s "
				  (cstr (car one) "/" (cadr one))
				  " "
				  (cstr (car file) "/" (cadr file)))))
		  (push file same)
		  (push file dif)) )
	    (if same (push (cons one same) res))
	    (setq samel dif))) )
    (nreverse res) ))

; convert files from .PCD to .jpg
; (mapdirb "/u/novak/x200/" #'convfile)
(defun convfile (filename)
  (concatenate 'string
	       "(convert -size 2880x1920 -modulate 25 -contrast /u/novak/x200/"
	       filename
	       " /u/novak/x200/x2" (subseq filename 5 7)
	       ".jpg ; rm /u/novak/x200/" filename " )"))

; convert files from .PCD to .jpg
; (mapdirb "/u/novak/y200/" #'convfile)
(defun convfileb (filename)
  (concatenate 'string
	       "(convert -size 2880x1920 -modulate 25 -contrast /u/novak/y200/"
	       filename
	       " /u/novak/y200/y2" (subseq filename 5 7)
	       ".jpg ; rm /u/novak/y200/" filename " )"))

; rename files
; (mapdirb "edited" #'munge77 "c.jpg")
(defun munge77 (str)
  (if (char= (char str 0) #\w) 
      (cstr "mv edited/" str (cstr " edited/" (subseq str 0 5) "g.jpg"))))

(defun nfilenm (n)
  (let ((thous (truncate n 1000)) str)
    (setq str (format nil "~A~3D" (code-char (+ thous (char-code #\a)))
		      (- n (* thous 1000))))
    (dotimes (i 4) (if (char= (char str i) #\Space)
		       (setf (char str i) #\0)))
    str))

(defvar *filenumber* 0)
; (mapdirc "ss/" #'convfilec)
(defun convfilec (filename dir)
  (let (filenm)
    (incf *filenumber*)
    (setq filenm (nfilenm *filenumber*))
    (format t "~A  -->  ~A~%" filename filenm)
    (concatenate 'string "( uudecode " dir filename " ; mv a.out " dir filenm
		 ".jpg ; rm " dir filename " )" )))

; find possible duplicates from list of ((length name) ...)
(defun dupfilesb (lst)
  (let (samel res lng)
    (while lst
      (setq lng (car (car lst)))  ; length
      (setq samel nil)
      (while (eql (car (car lst)) lng)
	(push (cadar lst) samel)
	(setq lst (cdr lst)))
      (if (> (length samel) 1)
	  (push (cons lng samel) res)) )
    (nreverse res)))

; convert a file name such as a123 to a number
(defun filetonum (sym)
  (let ((str (symbol-name sym)) firstchar)
    (setq firstchar (char str 0)) 
    (if (and (= (length str) 8)
	     (char>= firstchar #\A)
	     (char<= firstchar #\E)
	     (digit-char-p (char str 1))
	     (digit-char-p (char str 2))
	     (digit-char-p (char str 3)))
	(+ (* 1000 (- (char-code firstchar) (char-code #\A)))
	   (* 100 (- (char-code (char str 1)) (char-code #\0)))
	   (* 10 (- (char-code (char str 2)) (char-code #\0)))
	   (- (char-code (char str 3)) (char-code #\0))))))

(defun numtodir (n)
  (let ((lst '(("bc/" 0) ("bf/" 31) ("d00/" 73) ("d01/" 117) ("d02/" 165)
	       ("d03/" 240) ("d04/" 303) ("d05/" 402) ("d06/" 605) ("d07/" 856)
	       ("d08/" 1016) ("d09/" 1187) ("d10/" 1295) ("d11/" 1442)
	       ("d12/" 1536) ("d13/" 1654) ("d14/" 1771) ("d15/" 1960)
	       ("d16/" 2140) ("d17/" 2305) ("d18/" 2553) ("d19/" 2726)
	       ("d20/" 2882) ("d21/" 3030) ("d22/" 3247) ("d23/" 3442)
	       ("d24/" 3707) ("d25/" 3883) ("d26/" 4127) ("ss/" 4357)
	       ("end/" 4500)) ))
    (if (numberp n)
	(progn
	  (while (and (cdr lst) (>= n (cadadr lst))) (setq lst (cdr lst)))
	  (caar lst) )
      "ssa/") ))
    
; find duplicated files from a list
(defun dupfilesb (lst)
  (let (one two onen twon tmp tmpn)
    (dolist (group lst)
      (setq one (cadr group))
      (dolist (x (cddr group))
	(setq two x)
	(setq onen (filetonum one))
	(setq twon (filetonum two))
	(when (or (null onen) (and onen twon (> onen twon)))
	  (setq tmp one) (setq one two) (setq two tmp)
	  (setq tmp onen) (setq onen twon) (setq twon tmp) )
	(if (eql 0 (system
		    (cstr "cmp -s "
			   (cstr (numtodir onen)
				 (string-downcase (symbol-name one)))
			   " "
			   (cstr (numtodir twon)
				 (string-downcase (symbol-name two))) )))
	    (progn (format t "deleting ~a~%"
			   (cstr (numtodir twon)
				 (string-downcase (symbol-name two))))
		   (system (cstr "rm "
				 (cstr (numtodir twon)
				       (string-downcase (symbol-name two)))))))
	) ) ))

; 03 Jun 04
; Compare files of Lisp code
; If flag = nil, read the definitions and save; if T, compare to saved def.
(defun comparelisp (filename flag)
  (let (def)
    (with-open-file (infile filename :direction :input :if-does-not-exist nil)
      (while (not (or (null infile)
		      (eq (setq def (read infile nil 'zzeofvalue))
			  'zzeofvalue)))
	(if (and (consp def) (eq (car def) 'defun))
	    (if (null flag)
		(setf (get (cadr def) 'savedef) def)
	        (if (not (equal def (get (cadr def) 'savedef)))
		    (if (get (cadr def) 'savedef)
			(progn (format t "Not equal: ~A~%" (cadr def))
			       (print (unequal def (get (cadr def) 'savedef)))
			       (terpri))
		        (format t "Undefined: ~A~%" (cadr def))  )))) )) ))

; 03 Jun 04; 25 Feb 09
; Compare two structures, returning a list of alternating unequal parts
(defun unequal (x y)
  (if (and (consp x) (consp y))
      (if (equal (car x) (car y))
	  (unequal (cdr x) (cdr y))
	  (if (equal (cdr x) (cdr y))
	      (unequal (car x) (car y))
	      (if (< (tree-size x) 60)
		  (list x y)
		  (append (unequal (car x) (car y))
			  (unequal (cdr x) (cdr y))))))
      (if (equal x y) nil (list x y))))

; 03 Jun 04; 25 Feb 09
; size of a tree
(defun tree-size (x)
  (if (consp x)
      (+ 1 (tree-size (car x)) (tree-size (cdr x)))
      (if x 1 0)))

; Extract files by copying a set of source lines.
; (wwfh "rmnp/" 'a391)
(defun wwfh (dirstring sym)
  (let (filename stream line i)
      (setq filename
	    (concatenate 'string dirstring
			 (string-downcase (symbol-name sym))
			 ".html"))
      (with-open-file (infile filename :direction :input
			      :if-does-not-exist nil)
	(setq i 0)
	(while (not (or (> i 4)
			(null infile)
			(eq (setq line (read-line infile nil 'zzeofvalue))
			    'zzeofvalue)))
	  (incf i)) )
      (print (list sym line)) ))

; 28 Jan 05
; make a list of functions in a file of Lisp code
; (subset #'fboundp (fnsinfile "file.lsp"))   ; fns already defined
(defun fnsinfile (filename)
  (let (def fns)
    (with-open-file (infile filename :direction :input :if-does-not-exist nil)
      (while (not (or (null infile)
		      (eq (setq def (read infile nil 'zzeofvalue))
			  'zzeofvalue)))
	(if (and (consp def)
		 (member (car def) '(defun gldefun defmacro)))
	    (pushnew (cadr def) fns))))
    (dolist (fn fns) (setf (get fn 'sourcefile) filename))
    (nreverse fns) ))
