; vac.lsp               Gordon S. Novak Jr.            ; 21 Apr 14

; Copyright (c) 2014 Gordon S. Novak Jr. and The University of Texas at Austin.

; 27 Mar 03; 03 Apr 03; 08 Apr 03; 10 Apr 03; 15 Apr 03; 16 Apr 03; 17 Apr 03
; 22 Apr 03; 29 Apr 03; 01 May 03; 05 May 03; 06 May 03; 07 May 03; 13 May 03
; 14 May 03; 15 May 03; 16 May 03; 19 May 03; 20 May 03; 21 May 03; 23 May 03
; 27 May 03; 28 May 03; 30 May 03; 02 Jun 03; 03 Jun 03; 04 Jun 03; 05 Jun 03
; 06 Jun 03; 16 Jul 03; 22 Jul 03; 23 Jul 03; 24 Jul 03; 28 Jul 03; 30 Jul 03
; 31 Jul 03; 08 Aug 03; 12 Aug 03; 13 Aug 03; 14 Aug 03; 21 Aug 03; 04 Sep 03
; 11 Sep 03; 16 Sep 03; 18 Sep 03; 23 Sep 03; 25 Sep 03; 30 Sep 03; 02 Oct 03
; 03 Oct 03; 09 Oct 03; 14 Oct 03; 16 Oct 03; 17 Oct 03; 20 Oct 03; 21 Oct 03
; 23 Oct 03; 28 Oct 03; 30 Oct 03; 31 Oct 03; 04 Nov 03; 06 Nov 03; 11 Nov 03
; 13 Nov 03; 18 Nov 03; 20 Nov 03; 21 Nov 03; 25 Nov 03; 26 Nov 03; 08 Dec 03
; 09 Dec 03; 10 Dec 03; 11 Dec 03; 12 Dec 03; 24 May 04; 25 May 04; 26 May 04
; 27 May 04; 28 May 04; 29 May 04; 01 Jun 04; 02 Jun 04; 02 Aug 04; 03 Aug 04
; 04 Aug 04; 05 Aug 04; 06 Aug 04; 09 Aug 04; 10 Aug 04; 11 Aug 04; 12 Aug 04
; 13 Aug 04; 16 Aug 04; 17 Aug 04; 20 Aug 04; 26 Aug 04; 31 Aug 04; 02 Sep 04
; 03 Sep 04; 07 Sep 04; 08 Sep 04; 09 Sep 04; 14 Sep 04; 15 Sep 04; 16 Sep 04
; 20 Sep 04; 21 Sep 04; 23 Sep 04; 24 Sep 04; 27 Sep 04; 28 Sep 04; 29 Sep 04
; 30 Sep 04; 01 Oct 04; 04 Oct 04; 05 Oct 04; 06 Oct 04; 07 Oct 04; 26 Oct 04
; 28 Oct 04; 02 Nov 04; 04 Nov 04; 11 Nov 04; 16 Nov 04; 18 Nov 04; 23 Nov 04
; 22 Nov 04; 25 Jan 05; 01 Feb 05; 03 Feb 05; 08 Feb 05; 10 Feb 05; 17 Feb 05
; 22 Feb 05; 24 Feb 05; 01 Mar 05; 02 Mar 05; 08 Mar 05; 14 Mar 05; 15 Mar 05
; 03 Nov 05; 28 Mar 06; 13 Jul 06; 14 Jul 06; 28 Aug 06; 29 Aug 06; 17 Oct 06
; 07 Nov 06; 22 Nov 06; 12 Dec 06; 14 Dec 06; 28 Dec 06; 29 Dec 06; 02 Jan 07
; 03 Jan 07; 04 Jan 07; 05 Jan 07; 08 Jan 07; 09 Jan 07; 10 Jan 07; 11 Jan 07
; 16 Jan 07; 17 Jan 07; 22 Jan 07; 23 Jan 07; 25 Jan 07; 30 Jan 07; 01 Feb 07
; 15 Feb 07; 01 Mar 07; 13 Mar 07; 14 Mar 07; 15 Mar 07; 20 Mar 07; 22 Mar 07
; 27 Mar 07; 29 Mar 07; 30 Mar 07; 03 Apr 07; 05 Apr 07; 12 Apr 07; 17 Apr 07
; 24 Apr 07; 01 May 07; 02 May 07; 03 May 07; 07 May 07; 08 May 07; 09 May 07
; 10 May 07; 11 May 07; 15 May 07; 16 May 07; 04 Oct 07; 08 Oct 07; 11 Oct 07
; 16 Oct 07; 18 Oct 07; 25 Oct 07; 01 Nov 07; 09 Jan 08; 05 Mar 08; 24 Apr 08
; 06 May 08; 07 May 08; 15 May 08; 23 May 08; 27 May 08; 28 May 08; 29 May 08
; 31 Dec 08; 02 Jan 09; 14 Jan 09; 22 Jan 09; 03 Feb 09; 19 Feb 09; 26 Feb 09
; 02 Apr 09; 07 Apr 09; 30 Apr 09; 05 May 09; 13 May 09; 15 May 09; 20 May 09
; 21 May 09; 27 May 09; 28 May 09; 29 May 09; 22 Jul 09; 23 Jul 09; 30 Jul 09
; 04 Aug 09; 05 Aug 09; 06 Aug 09; 07 Aug 09; 10 Aug 09; 28 Aug 09; 01 Sep 09
; 08 Sep 09; 09 Sep 09; 14 Oct 09; 28 Jan 10; 29 Jan 10; 01 Feb 10; 02 Feb 10
; 04 Feb 10; 15 Feb 10; 16 Feb 10; 25 Feb 10; 02 Mar 10; 04 Mar 10; 11 Mar 10
; 15 Mar 10; 17 Mar 10; 18 Mar 10; 23 Mar 10; 25 Mar 10; 26 Mar 10; 30 Mar 10
; 02 Jun 10; 15 Jul 10; 16 Jul 10; 20 Jul 10; 13 Sep 10; 14 Sep 10; 16 Sep 10
; 29 Sep 10; 01 Oct 10; 08 Oct 10; 11 Oct 10; 13 Oct 10; 20 Oct 10; 27 Oct 10
; 02 Nov 10; 03 Nov 10; 05 Nov 10; 08 Nov 10; 22 Nov 10; 23 Nov 10; 24 Nov 10
; 29 Nov 10; 01 Dec 10; 14 Dec 10; 16 Dec 10; 17 Dec 10; 25 Jan 11; 03 Feb 11
; 08 Feb 11; 09 Mar 11; 15 Mar 11; 17 Mar 11; 18 Mar 11; 22 Mar 11; 05 Oct 11
; 14 Oct 11; 28 Oct 11; 31 Oct 11; 11 Nov 11; 14 Nov 11; 16 Nov 11; 18 Nov 11
; 21 Nov 11; 23 Nov 11; 28 Nov 11; 30 Nov 11


; New version of viewas for components

; Need to show:
;    GUI
;    views and interfaces as objects to be edited; add predicate
;    chaining of acc's:  IT/ACC -> FU -> FU -> ...
;    multiple languages
;    interface chaining:  mydata -> person -> app
;             mydata -> person includes myaddress -> address
;    Need a way to make a group into a component.

; (setq myinst (instcspec nil 'sorted-linked-list '((record part))))
;    (cidoprop myinst 'link)
;    (cidoprop myinst 'sort-value)
;    (cidoprop myinst 'sort-direction)
;    (cidoprop myinst 'copy-contents-names)
;    (cioutprops myinst)
; (cidoprops myinst)        ; select name, ascending
; (t71 mypart)
; (setq myinstb (instcspec nil 'sum '((item part))))
; (cidoprops myinstb)
; (glcp 't74)
; (setq myinstc (instcspec nil 'average '((item part))))
; (cidoprops myinstc)
; (glcp 't75)
; (setq myinstd (instcspec nil 'iterate-accumulate '((recordtype assembly))))
; (cidoprops myinstd)
; (setq mygroup (instcigroup 'iter-acc '((arg assembly))))   ; select PARTS
; (cigsels mygroup)               ; select AVERAGE
; (ciselect 'ITAC2 'ACC) ; to add an acc (fill in the ITAC): select SUM
; (cgspecialize mygroup 't79)
; (t79 myasm)
; (setq myinste (instcspec nil 'alist '((key symbol) (data (sum sumd1)))))
; (cidoprops myinste)
; (glcp 't78)
; (setq mygroupb (instcigroup 'iter-acc '((arg assembly))))   ; select PARTS
; (cigsels mygroupb)              ; select find-update, name
; (ciselect 'FU1 'ACC)            ; fill in the right FUi ; select SUM
; (ciselect 'FU1 'stg)            ; select ALIST
; (cgspecialize mygroupb 't80)
; (t80 myasmb)
; (setq myinstf (instcspec nil 'polygon '((recordtype mypolyk))))
; (cidoprops myinstf)             ; choose v -> y, u -> x
; (glspecializefn 'poly-area '((poly RECORDTYPE4)))
; (POLY-AREA2 mypolykd)           ; 118.0
; (setq myinstg (instcspec nil 'listof '((item part))))
; (cidoprops myinstg)             ; select NAME
; (glcp 't81)
; (setq mygroupc (instcigroup 'iter-acc '((arg assembly))))
; (cigsels mygroupc)              ; select LISTOF, NAME
; (cgspecialize mygroupc 't82)
; (t82 myasm)
; (setq mygroupd (instcigroup 'iter-acc '((arg assembly))))
; (cigsels mygroupd)              ; select find-update, size
; (ciselect 'FU2 'ACC)            ; fill in the right FUi ; select SUM
; (ciselect 'FU2 'stg)            ; select ARRAY, 10
; (cgspecialize mygroupd 't83)
; (t83 myasmb)   ;  = #(NIL 1 NIL 6 4 5 NIL 7 NIL NIL)
; (setq mygroupe (instcigroup 'iter-acc '((arg assembly))))
; (cigsels mygroupe)  ; select Histogram, 400, 100, 12
; (cgspecialize mygroupe 't84)
; (t84 myasmc)  ;  = (#(2 0 0 0 1 1 3 0 0 4 0 0 0 3))
; (setq mygroupi (instcigroup 'iter-acc '((arg assembly))))
; (cigsels mygroupi)              ; select FIND-UPDATE, NAME
; (ciselect 'FU3 'ACC)            ; fill in the right FUi ; select COUNT
; (ciselect 'FU3 'stg)            ; select avl-tree
; (cgspecialize mygroupi 't95)
; (t95 myasmc)
; (setq mygroupm (instcigroup 'iter-acc '((str string))))    ; select WORDS
; (cigsels mygroupm)              ; select MAX, LENGTH
; (cgspecialize mygroupm 't85)
; (t85 "zoo zebra hippopotamus lion giraffe")
; (setq mygroupn (instcigroup 'iter-acc '((fl file-of-words-generator)))) ; IDENTITY
; (cigsels mygroupn)              ; select FIND-UPDATE, KEY = LOWER-CASE
; (ciselect 'FU4 'ACC)            ; fill in the right FUi, choose COUNT
; (ciselect 'FU4 'stg)            ; fill in the right FUi, choose AVL-TREE
; (cgspecialize mygroupn 't86)
; (car (setq decindwc (t86 "admin/pers/decind.txt")))  ; wd count Decl. of Ind.
; (t90 decindwc)                  ; print results where word count > 2
; (viewas 'linked-list 'partc)
; (setq mygroupo (instcigroup 'iter-acc '((arg assemblyc))))   ; select PARTS
; (cigsels mygroupo)              ; select SUM
; (cgspecialize mygroupo 't97)
; (t97 mybasm)
; (gltolang 't97 'c)
; (setq mygroupp (instcigroup 'iter-acc '((fl file-of-words-generator))))
; (cigsels mygroupp)              ; select HISTOGRAM, LENGTH, 1, 1, 15
; (cgspecialize mygroupp 't88)    ; histogram of word lengths
; (t88 "admin/pers/decind.txt")
;    #(0 17 270 270 171 140 114 99 72 62 56 35 13 9 7 2 0)
; (setq mygroupq (instcigroup 'iter-acc '((fl file-of-words-generator))))
; (cigsels mygroupq)              ; select ARGMAX, LENGTH
; (cgspecialize mygroupq 't89)    ; find longest word
; (t89 "admin/pers/decind.txt")
; (setq mygroupr (instcigroup 'iter-acc '((arg assembly))))     ; select PARTS
; (cigsels mygroupr)              ; select SUM
; (ciredoprop 'ADD6 'test)        ; fill in right ADDi    (oddp (size self))
; (ciredoprop 'ADD6 'summand)     ; fill in right ADDi    (expt (size self) 2)
; (cgspecialize mygroupr 't105)
; (t105 myasm)                    ; = 34
; KWIC example:
;  make *noisedict*:
; (setq mygroupw (instcigroup 'iter-acc '((fl file-of-words-generator)))) ; IDENTITY
; (cigsels mygroupw)              ; FIND-UPDATE, Key = LOWER-CASE
; (ciselect 'FU5 'ACC)            ; use the right FUi; ACC = COUNT
; (ciselect 'FU5 'stg)            ; = AVL-TREE
; (cgspecialize mygroupw 'avlcount)
; (setq *noisedict* (avlcount "glisp/noise.txt"))
; (glispglobals (*noisedict* PTR3))
; (glispobjects (myrec1 (CRECORD MYREC1 (STR STRING) (COL INTEGER)) ) )
; (setq mygroupx (instcigroup 'iter-acc '((fl file-of-words-generator)))) ; IDENTITY
; (cigsels mygroupx)              ; FIND-UPDATE, KEY = LOWER-CASE
; (ciselect 'FU6 'ACC)            ; use the right FUi
;      ACC = TPQOF   SUMMAND = Specify fn, RECORD, myrec1
;      do Expand OUT, then COL = COLUMN, STR = ORIG-STRING
; (ciselect 'FU6 'stg)            ; STG = AVL-TREE
; (ciredoprop 'FU6 'test)         ; How to specify fn for TEST  = CODE
; Specify code for TEST =  (not (member *noisedict* (lower-case self)))
; (cgspecialize mygroupx 'mykwic)
; (car (setq kwicres (mykwic "admin/pers/decind.txt")))
; (t91 kwicres)    ; first edit t91 to use the correct types


; variations of data structures for non-Lisp languages:
(defvar *vac-lang*)
(setq *vac-lang* '((alist alistc) (listof listofc) (tpqof tpqofc)))
(defvar *vac-newtypes* nil)
(defvar *vac-trace* nil)
(defvar *vac-alltrace* nil)
(defmacro cioffers            (x) `(get ,x 'cioffers))
(defvar *vac-cspecs* nil)

(glispobjects

; 11 Sep 03; 25 Nov 03; 14 Dec 06; 06 Aug 09
; component specification
(cspec (symbol (proplist (glclspec (proplist
                                    (abbrev     symbol)
                                    (interfaces (listof cintfc))
                                    (types      (listof cstype))
                                    (fnspecs    (listof csfnspec))
                                    (vwspecs    (listof anything))  ; viewspecs
                                    (instn      integer)            ; instance number
                                    )) ))
  msg  ((fnspec   (glambda (spec nm) (that (fnspecs spec) with name == nm))
                  result csfnspec)
        (type     (glambda (spec nm) (that (types spec) with name == nm))
                  result cstype)
        (interface (glambda (spec nm) (that (interfaces spec) with name == nm))
                   result cintfc)
        (interfaced (glambda (spec nm dir)
                      (that (interfaces spec)
                            with name == nm and direction == dir))
                    result cintfc)
        (interfacek (glambda (spec knd)
                      (that (interfaces spec)
                            with kind == knd and direction == 'offers))
                    result cintfc) ) )

(cintfc (list (name symbol)
              (direction symbol)  ; uses or offers
              (kind symbol)
              (items (listof cintfcitem))
              (args  (listof (list (name symbol) (value anything))) ) )
  msg  ((item     (glambda (self nm) (that (items self) with name == nm)))) )

(cintfcitem (list (name symbol) (typename symbol) (direction symbol)))

; component instance type spec
; typespec can be: used in matching (match, hasop) or used to infer types
;   (match type)            ; ***** was   anything
;   (hasop +)                    ; to match, arg must have a + op
;   (^ type)                     ; pointer to type
;   (typeof parm)                ; type of a parameter
;   (element collection)         ; element of collection type
;   (typecon pattern)    ; construct type from parms using pattern
;   (cluster pattern)    ; construct cluster from parms using pattern
;   (component pattern)  ; construct a component
;     pattern is (componentname ((type value)*) ((prop value)*))
;   (single  pattern)    ; single item: basic type or pointer
; could have (eval (parms) code) to e.g. compute performance or test
; could have (rules (parms) rules...)
(cstype (list (name symbol)
              (typespec (cons (typehow symbol) (typeargs anything)))
              (super gltype)
              (arity symbol))  )

; specification of a property of a type
(csfnspec (list (name      symbol)
                (signature csfnsig)
                (howspec   csfnhow)        ; (partof) etc.
                (condition anything) )     ; must eval true to activate
  prop ((excls  ((excls (howspec self))))
        (howfn  ((howfn (howspec self))))
        (inputs ((inputs (signature self))))
        (input1 ((input1 (signature self))))
        (output ((output (signature self))))  ) )

; specification of a function signature, e.g. (item -> boolean)
; input, output can be a single symbol or list of symbols
; a symbol that is not a type variable is assumed to be a constant type
(csfnsig (list (input anything) (arrow symbol) (output anything))
  prop  ((inputs  ((if (symbolp input)  (list input)  input)))
         (input1  ((if (consp input) (car input) input)))
         (output  ((if (consp output) (car output) output))) ) )

; how to infer a property
; 
; (prop () (link))
; (constant)
; (eval code)
; (partof)
; (names () (link))
; (oneof (ascending descending))
; (default #'<)
; (viewtype itemtype)
; (type itemtype)
; (choice sum)
(csfnhow (list (howfn symbol)
               (arg         anything)
               (excls (listof symbol))    ; excluded choices
               (used  (listof symbol))    ; types used besides source
               (prompt string)))

; instance of a component
(cinst (symbol (proplist
         (spec  cspec)
         (group cigroup)
         (args  (listof ciarg))  ))
  msg  ((arg      (glambda (inst nm) (that (args inst) with name == nm)))
        (type     (glambda (inst nm) (that (args inst) with name == nm)))
        (actual   (glambda (inst nm) (actual (type inst nm))))
        (viewtype (glambda (inst nm) (viewtype (type inst nm))))
        (addprop  ciaddprop)) )

; argument of a cinst: includes both types and functions
(ciarg  (list (name symbol)
              (kind symbol)
              (props (proplist
                       (type    gltype)          ; actual type
                       (choice  anything)        ; menu selection or path
                       (code    anything)        ; in form for a GLISP prop
                       (cltype  gltype)          ; type within the cluster
                       (source  symbol)          ; user, inference, default
                       (depend  (listof symbol)) ; dependencies
                       (sequence integer)        ; sequence number of choice
                       (actual anything)    ; from citype
                       (viewtype gltype)    ; from citype
                       )))
  msg  ((prop     (glambda (self nm) (getf (props self) nm))) ) )


; (citype (list (name symbol) (actual anything) (viewtype gltype)
;             (depend (listof symbol)) )) ;storagesubs?

; Specification of a group of connected components
(cgspec (symbol (proplist
          (comps   (listof (list (name symbol)   ; role name
                                 (spec cspec)    ; component spec
                                 (fn   symbol)
                                 (args (listof glnametype)))))
                   ; where the type is type name within the cinst
          (formals (listof menu-set-conn))       ; where the input connects to
            ; each is ((arg-name nil) (port boxname))
          (conns   (listof menu-set-conn))       ; connections of components
          (instn      integer) ))         ; instance number
  msg  ((findconn  cgspec-findconn)
        ) )


; Group of component instances
(cigroup (symbol (proplist
                  (spec     cgspec)
                  (actuals  (listof glnametype))
                  (bindings (listof (cons (actual symbol) (formal symbol))))
                  (cpset    cpset)
              ;    (insts    (listof (list (role symbol) (inst cinst))))
              ;    (conns    (listof cpconn))
                  (synopsis anything)
                  (allfns   (listof symbol))
                  (result   gltype)
                  ))
  prop ((conns    ((conns (cpset self))) )
        (insts    ((nodes (cpset self))) ) )
  msg  ((addinst    cigroup-addinst)
        (addconn    (glambda (self (in cpconn)) ((conns self) _+ in)) )
        (findconns  cigroup-findconns)
        (inst       (glambda (self nm)
                             (params (that (insts self) with role == nm)))
                    result cinst)
        (role       (glambda (self in)
                             (role (that (insts self) with params == in)))) ) 
  )


) ; glispobjects

; fns for debugging
(gldefun viewtype ((inst cinst) (name symbol)) (viewtype inst name))


; 07 Aug 09; 02 Nov 10
(gldefun cigroup-addinst ((self cigroup) (name symbol) (in cinst))
  ((group in) = self)
  (add-node (cpset self) in 'software (or name in) in) )
 ; was ((insts self) _+ (list (or name in) in)) )

; 27 Mar 03; 20 May 03; 27 May 03; 04 Jun 03; 02 Mar 05; 03 Feb 11
; define a cluster specification, storing items on prop list
(defun defcspec (cspec)
  (let ((specs (cdr cspec)))
    (pushnew (car cspec) *vac-cspecs*)
    (while specs
      (setf (getf (get (car cspec) 'glclspec) (car specs)) (cadr specs))
      (if (eq (car specs) 'interfaces)
          (dolist (intfc (cadr specs))
            (if (eq (cadr intfc) 'offers)
                (pushnew (car cspec) (cioffers (caddr intfc))))))
      (setq specs (cddr specs)) )
    (or (get (car cspec) 'instn)                    ; instance number
        (setf (get (car cspec) 'instn) 0))
    (car cspec)
    ))

(defun cspecp (name) (get name 'glclspec))

; 02 Jun 03; 03 Jun 03; 04 Jun 03
; define a cluster specification, storing items on prop list
(defun defcgspec (cspec)
  (let ((specs (cdr cspec)))
    (while specs
      (setf (get (car cspec) (car specs)) (cadr specs))
      (setq specs (cddr specs)) )
    (or (get (car cspec) 'instn)                    ; instance number
        (setf (get (car cspec) 'instn) 0))
    (car cspec)
    ))

; 04 Sep 03; 25 Nov 03; 28 Mar 06; 13 Jul 06; 10 Jan 07; 17 Jan 07
(defcspec
 '(sorted-linked-list  abbrev sll
   interfaces ((sll offers sorted-sequence ((record record in))))
   types
    ((record  (match anything)      sll-record)
     (pointer (^ record)            sll-pointer)
     (key     (typeof sort-value)) )
   fnspecs
    ((link                (record -> pointer)         (partof))
     (copy-contents-names (record -> (listof symbol)) (names () (link)))
     (sort-value          (record -> anything)        (prop () (link)))  ; type = ordered ?
     (sort-direction      (record -> symbol)       (oneof (ascending descending)))
     (sort-before         ((key key) -> boolean)      (default #'<) ) ) ))

; 02 Apr 09; 30 Jul 09; 28 Aug 09
(defcspec
 '(heap  abbrev heap
   interfaces ((heap offers priority-queue ((item itemtype in)
                                            (priq heaptype out)) ) )
   types
    ((itemtype  (match anything)      heapitem)
     (heaptype  (typecon (list (thearray (arrayof itemtype))
                               (filled-size integer)))       heap)
     (key       (typeof sort-value) t) )
   fnspecs
    ((sort-value        (itemtype -> key)        (prop () ()))
     (dataview          (itemtype -> gltype)     (viewtype key))
     (datatype          (heaptype -> gltype)     (type itemtype))
     (sort-direction    (itemtype -> symbol)     (oneof (min max)))
     (sort-before-fn    ((key key) -> boolean)   (default #'<) ) ) ) )

; 11 Nov 11; 14 Nov 11; 17 Nov 11; 18 Nov 11
; priority queue as accumulator
(defcspec
 '(heappqacc  abbrev priq
   interfaces ((heap offers accumulator ((item itemtype in)
                                         (acc  sumtype out)
                                         (outt sumtype out) ) ) )
   types
    ((itemtype  (match anything)  t)     ; input item ***** ? heapitem
     (conttype  (match anything)  nil)   ; contents held in priority queue
     (rectype   (typecon (list (priority keytype)
                               (item     conttype))) heapitempri)
     (sumtype   (typecon (list (filled-size integer)
                               (thearray (arrayof rectype))))  myheapacc)
     (keytype   (typeof sort-value) t) )
   fnspecs
    ((test            (itemtype -> boolean)  (default #'true) )
     (summand         (itemtype -> conttype) (prop) (default #'identity))
     (sort-value      (itemtype -> keytype)  (prop () ()))
     (dataview        (sumtype -> gltype)   (viewtype itemtype))
     (datatype        (sumtype -> gltype)   (type conttype))
     (sort-direction  (sumtype -> symbol)   (oneof (min max)))
     (sort-before-fn  ((keytype keytype) -> boolean) (default #'<))
     (accum           (sumtype -> conttype)  (choice thearray))
     ) ) )

; 27 Mar 03; 06 May 03; 07 May 03; 13 May 03; 04 Sep 03; 25 Nov 03; 09 Aug 04
; 10 Aug 04; 11 Aug 04; 12 Aug 04; 17 Feb 05; 22 Feb 05; 10 Jan 07; 25 Jan 07
(defcspec
 '(sum   abbrev sum
         interfaces ((accout offers accumulator
                             ((item itemtype in)
                              (acc  sumtype out)
                              (outt conttype out))))
         types ((itemtype (match anything) t)
                (conttype (hasop +) nil)
                (sumtype  (typecon (sum conttype)) myadder) )
         fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                  (summand       (itemtype -> conttype) (prop) )
                  (initial-value (sumtype -> conttype)  (default
                                                          (zero (a conttype))
                                                          () (conttype)))
                  (dataview      (sumtype -> gltype)    (viewtype itemtype))
                  (accum         (sumtype -> conttype)  (choice sum)))
         ))

(setf (get 'sum 'gpdisplayspecs) '((summand (4 4)) (test (0 -12) " ?")
                                   (initial-value (-30 4))))

; 11 Aug 04; 12 Aug 04; 10 Jan 07; 25 Jan 07
(defcspec
 '(product   abbrev prod
             interfaces ((accout offers accumulator
                                 ((item itemtype in)
                                  (acc  sumtype out)
                                  (outt conttype out))))
             types ((itemtype (match anything) t)
                    (conttype (hasop *) nil)
                    (sumtype  (typecon (sum conttype)) mymulter) )
             fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                      (summand       (itemtype -> conttype) (prop) )
                      (initial-value (sumtype -> conttype)  (default
                                                              (one (a conttype))
                                                              () (conttype)))
                      (dataview      (sumtype -> gltype)    (viewtype itemtype))
                      (accum         (sumtype -> conttype)  (choice sum)))
         ))

; 14 May 03; 04 Sep 03; 25 Nov 03; 10 Dec 03; 11 Aug 04; 12 Aug 04; 14 Sep 04
; 01 Feb 05; 11 Jan 07; 25 Jan 07; 01 Feb 07
#| commented out
(defcspec
   '(average   abbrev avg
               interfaces ((accout offers accumulator
                                   ((item itemtype in)
                                    (acc  avgtype  out)
                                    (outt conttype out))))
               types ((itemtype (match anything) t)
                      (conttype (hasop (+ /)) nil)
                      (avgtype  (typecon (crecord avgrec (sum conttype)
                                                         (n integer)))
                                myavger) )
               fnspecs ((test        (itemtype -> boolean)    (default #'true) )
                        (summand       (itemtype -> conttype) (prop) )
                        (initial-value (avgtype -> conttype) (default
                                                              (zero (a conttype))
                                                              () (conttype)))
                        (initial-count (avgtype -> integer)  (default 0))
                        (dataview      (avgtype -> gltype)    (viewtype itemtype))
                        (accum         (avgtype -> conttype)  (choice sum))
                        (count         (avgtype -> integer)   (choice n))) ))
|#

; 09 Mar 11; 15 Mar 11
; This version combines average, weighted average, and center of gravity.
(defcspec
   '(average   abbrev avg
               interfaces ((accout offers accumulator
                                   ((item itemtype in)
                                    (acc  cgtype  out)
                                    (outt conttype out))))
               types ((itemtype (match anything) t)
                      (conttype (hasop (+ *)) nil)
                      (cgtype  (typecon (crecord cgrec (sum conttype)
                                                       (mass number)))
                                mycger) )
               fnspecs ((test        (itemtype -> boolean)  (default #'true) )
                        (summand     (itemtype -> conttype) (prop) )
                        (weight      (itemtype -> number)   (default 1.0) )
                        (initial-value (cgtype -> conttype) (default
                                                             (zero (a conttype))
                                                             () (conttype)))
                        (dataview      (cgtype -> gltype)   (viewtype itemtype))
                        (accum         (cgtype -> conttype) (choice sum))
                        (count         (cgtype -> number)   (choice mass))) ))

; 06 Nov 03; 25 Nov 03; 11 Aug 04; 16 Aug 04; 14 Sep 04; 11 Jan 07
(defcspec
   '(statistics   abbrev stats
                  interfaces ((accout offers accumulator
                                      ((item itemtype  in)
                                       (acc  statstype out)
                                       (outt statstype out))))
                  types ((itemtype (match anything) t)
                         (conttype (hasop (+ /)) nil)
                         (statstype (typecon (crecord statstype (sum conttype)
                                                                (sumsq conttype)
                                                                (n integer)))
                                    mystats) )
                  fnspecs ((test     (itemtype -> boolean)   (default #'true) )
                           (summand  (itemtype -> conttype)  (prop))
                           (dataview (statstype -> gltype)   (viewtype itemtype))
; no sumsq here -- do we need accum and count ??? *****
                           (accum    (statstype -> conttype) (choice sum))
                           (count    (statstype -> integer)  (choice  n))) ))

; 23 Oct 03; 25 Nov 03; 11 Aug 04; 16 Aug 04; 11 Jan 07
(defcspec
   '(min   abbrev min
           interfaces ((accout offers accumulator
                               ((item itemtype in)
                                (acc  mind  out)
                                (outt conttype out))))
           types ((itemtype (match anything) t)
                  (conttype (hasop <) nil)
                  (mind (typecon (crecord mind (val conttype) (valid boolean)))
                        myminner) )
           fnspecs ((test        (itemtype -> boolean)  (default #'true) )
                    (summand     (itemtype -> conttype) (prop))
                    (dataview    (mind -> gltype)       (viewtype itemtype))
                    (accum       (mind -> conttype)     (choice val))
                    (okay        (mind -> conttype)     (choice valid)) ) ))

; 28 Oct 03; 25 Nov 03; 11 Aug 04; 16 Aug 04; 11 Jan 07
(defcspec
   '(max   abbrev max
           interfaces ((accout offers accumulator
                               ((item itemtype in)
                                (acc  maxd  out)
                                (outt conttype out))))
           types ((itemtype (match anything) t)
                  (conttype (hasop >) nil)
                  (maxd (typecon (crecord maxd (val conttype) (valid boolean)))
                        mymaxer) )
           fnspecs ((test        (itemtype -> boolean)  (default #'true) )
                    (summand     (itemtype -> conttype) (prop))
                    (dataview    (maxd -> gltype)       (viewtype itemtype))
                    (accum       (maxd -> conttype)     (choice val))
                    (okay        (maxd -> conttype)     (choice valid)) ) ))

; 06 Nov 03; 25 Nov 03; 11 Aug 04; 16 Aug 04; 22 Feb 05; 11 Jan 07; 25 Jan 07
; 01 Feb 07
; same as sum except summand
(defcspec
 '(count   abbrev count
           interfaces ((accout offers accumulator
                               ((item itemtype in)
                                (acc  sumtype  out)
                                (outt sumtype out))))
           types ((itemtype   (match anything) t)
                  (sumtype    (typecon (sum integer)) myadder))
           fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                    (summand       (itemtype -> integer)  (default 1))
                    (initial-value (sumtype  -> integer)  (default 0) )
                    (dataview      (sumtype  -> gltype)   (viewtype itemtype))
                    (accum         (sumtype  -> integer)  (choice sum)) ) ))

; ***** histo should really have a summation plug-in, default = count
; 06 Nov 03; 25 Nov 03; 11 Aug 04; 16 Aug 04; 11 Jan 07
(defcspec
 '(histogram   abbrev histo
               interfaces ((accout offers accumulator
                                   ((item itemtype in)
                                    (acc  histotype  out)
                                    (outt histotype out))))
               types ((itemtype  (match anything) t)
                      (conttype  (match number) nil)
                      (histotype (typecon (sum (arrayof integer))) myhisto))
               fnspecs ((test          (itemtype -> boolean)   (default #'true))
                        (summand       (itemtype -> conttype)  (default 1))
                        (initial-value (histotype -> integer)  (default 0))
                        (index         (itemtype -> conttype)  (prop))
                        (minval        (histotype -> conttype) (constant))
                        (binwidth      (histotype -> conttype) (constant))
                        (nbins         (histotype -> integer)  (constant))
                        (dataview      (histotype -> gltype)   (viewtype itemtype))
                        (accum         (histotype -> conttype) (choice sum)) )))

(setf (get 'histogram 'gpdisplayspecs) '((index (4 4)) (test (0 -12) " ?")))

; 06 Nov 03; 25 Nov 03; 11 Aug 04; 16 Aug 04; 11 Nov 04; 11 Jan 07; 17 Jan 07
(defcspec
   '(argmax   abbrev argmax
              interfaces ((accout offers accumulator
                                  ((item itemtype in)
                                   (acc  maxd     out)
                                   (outt itemtype out))))
              types ((itemtype (match anything) t)
                     (conttype (hasop >) nil)
                     (maxd (typecon (crecord maxd (val conttype)
                                                  (best (^ itemtype))
                                                  (valid boolean)))
                           myargmaxer) )
              fnspecs ((test      (itemtype -> boolean)  (default #'true) )
                       (comparand (itemtype -> conttype) (prop))
                       (dataview  (maxd -> gltype)       (viewtype itemtype))
                       (accum     (maxd -> conttype)     (choice val))
                       (okay      (maxd -> boolean)      (choice valid))) ))

(setf (get 'argmax 'gpdisplayspecs) '((comparand (4 4)) (test (0 -12) " ?")))

; 06 Nov 03; 25 Nov 03; 11 Aug 04; 16 Aug 04; 11 Nov 04; 11 Jan 07; 17 Jan 07
(defcspec
   '(argmin   abbrev argmin
              interfaces ((accout offers accumulator
                                  ((item itemtype in)
                                   (acc  maxd     out)
                                   (outt itemtype out))))
              types ((itemtype (match anything) t)
                     (conttype (hasop <) nil)
                     (maxd (typecon (crecord maxd (val conttype)
                                                  (best (^ itemtype))
                                                  (valid boolean)))
                           myargminer) )
              fnspecs ((test      (itemtype -> boolean)  (default #'true) )
                       (comparand (itemtype -> conttype) (prop))
                       (dataview  (maxd -> gltype)       (viewtype itemtype))
                       (accum     (maxd -> conttype)     (choice val))
                       (okay      (maxd -> boolean)      (choice valid))) ))

(setf (get 'argmin 'gpdisplayspecs) '((comparand (4 4)) (test (0 -12))))

; 18 Mar 10; 14 Oct 11; 31 Oct 11
; generic program
(defcspec
 '(action   abbrev action
         interfaces ((pgmout offers program
                             ((item itemtype in)
                              (acc  sumtype out))))
         types ((itemtype (match anything) t)
                (conttype (match anything) nil)
                (sumtype  (typecon (sum integer)) mypgm) )
         fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                  (action        (itemtype -> anything) (msg) )
                  (dataview      (sumtype -> gltype)    (viewtype itemtype)) )
         ))

(setf (get 'action 'gpdisplayspecs) '((summand (4 4)) (test (0 -12) " ?")
                                      (initial-value (-30 4))))

; 02 Sep 04; 11 Jan 07; 17 Jan 07
; listof for Lisp
(defcspec
 '(listof  abbrev lst
           interfaces ((accout offers accumulator
                               ((item itemtype in)
                                (acc  lstp out)
                                (outt lstp out))))
           types ((itemtype (match anything) t)
                  (conttype (match anything) nil)
                  (lstp     (typecon lstd) mylisplistptr)
                  (lstd     (typecon (listof (contents conttype)))) )
           fnspecs ((test      (itemtype -> boolean)  (default #'true) )
                    (summand   (itemtype -> conttype) (prop))
                    (dataview  (lstp     -> gltype)   (viewtype itemtype)))))

; 09 Oct 03; 14 Oct 03; 16 Oct 03; 17 Oct 03; 20 Oct 03; 25 Nov 03; 16 Aug 04
; 02 Sep 04; 03 Sep 04; 07 Sep 04; 10 Jan 07; 11 Jan 07
(defcspec
 '(listofc abbrev lst
           interfaces ((accout offers accumulator
                               ((item itemtype in)
                                (acc  lstp out)
                                (outt lstp out))))
           types ((itemtype  (match anything) t)
                  (conttype  (match anything) nil)
                  (conttypes (single conttype))
                  (lstp (typecon (^ lstd)) mylistptr)
                  (lstd (typecon (crecord lstof (contents conttypes)
                                                (link lstp)))
                        mylistof)
                  (clus (cluster (roles ((pointer lstp) (record lstd))
                                        supers (linked-list)))) )
           fnspecs ((test      (itemtype -> boolean)    (default #'true) )
                    (summand   (itemtype -> conttype)   (prop))
                    (dataview  (lstp     -> gltype)     (viewtype itemtype)) )
   vwspecs ((lstd linked-list linked-list (link link))) ))

; 22 Jul 03; 23 Jul 03; 24 Jul 03; 04 Sep 03; 30 Sep 03; 25 Nov 03; 20 Aug 04
; 24 Sep 04; 11 Jan 07; 16 Jan 07
(defcspec
   '(alist   abbrev alst
          interfaces  ((stg offers storage
                            ((key keytype in)
                             (data datatype in)
                             (root alist out))))
          types ((keytype    (match anything) nil)
                 (datatype   (match anything) nil)
                 (record (typecon (cons (alkey keytype) datatype))
                         mystgrec)
                 (alist  (typecon (listof record))    myalist) )
          fnspecs ((accfields  (record -> (listof gltype))  (fields datatype)) )))

; 26 Aug 04; 24 Sep 04; 11 Jan 07; 01 Mar 07
; general alist
(defcspec
   '(alistc   abbrev alstc
          interfaces  ((stg offers storage
                            ((key keytype in)
                             (data datatype in)
                             (root ptrtype out))))
          types ((keytype    (match anything) nil)
                 (datatype   (match anything) nil) 
                 (record (typecon (crecord alstr (sort-value keytype)
                                                 (contents datatype)
                                                 (link ptrtype)))
                         alist-record)
                 (ptrtype (typecon (^ record)) alist-pointer)
                 )
          fnspecs ((accfields  (record -> (listof gltype))  (fields datatype))
                   (memberp    (ptrtype -> boolean)         (default #'true)) ) ))
;      ????? is memberp ever used?
; memberp appears in myfu, appears to be true if we need to test whether
; a key appears in a lookup structure and insert the key if absent.
; But this test only appears to happen for arrays.

; 11 Nov 03; 13 Nov 03; 18 Nov 03; 20 Nov 03; 25 Nov 03; 16 Aug 04; 20 Aug 04
; 24 Sep 04; 05 Oct 04; 11 Jan 07
(defcspec
   '(avl-tree   abbrev avl
          interfaces  ((stg offers storage
                            ((key keytype in)
                             (data datatype in)
                             (root ptr out))))
          types ((keytype    (match anything) nil)
                 (datatype   (match anything) nil)
                 (record     (typecon (crecord avltr (sort-value keytype)
                                                     (contents datatype)
                                                     (balance integer)
                                                     (left ptr) (right ptr)))
                               avl-tree-record)
                 (ptr (typecon (^ record)) avl-tree-pointer)  )
          fnspecs ((accfields (record -> (listof gltype))  (fields datatype))
                   (memberp   (ptr -> boolean)             (default #'true)) ) ))
;      ????? is memberp ever used?   ; see above

; 26 May 04; 16 Aug 04; 14 Sep 04; 16 Jan 07
(defcspec
 '(tpqof  Abbrev tpq
          interfaces ((accout offers accumulator
                              ((item itemtype in)
                               (acc  pairptrs out)
                               (outt pairptrs out))))
          types ((itemtype (match anything) t)
                 (conttype (match anything) nil)
                 (lstd     (typecon (listof (contents conttype))))
                 (pairptrs (typecon (list (qstart lstd) (qend lstd)))
                             mylisptpqof) )
          fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                   (summand       (itemtype -> conttype) (prop))
                   (dataview      (pairptrs -> gltype)   (viewtype itemtype)) ) ))

; 16 Jan 07
(defcspec
 '(tpqofc  Abbrev tpq
           interfaces ((accout offers accumulator
                               ((item itemtype in)
                                (acc  pairptrs out)
                                (outt pairptrs out))))
           types ((itemtype (match anything) t)
                  (conttype (match anything) nil)
                  (lstp (typecon (^ lstd)) mylistptr)
                  (lstd (typecon (crecord lstof (contents conttype)
                                                (link lstp)))
                        mylistof)
                  (pairptrs (typecon (crecord tpqof (qstart lstp)
                                                    (qend lstp)))
                            mytpqof)
                  (clus (cluster (roles ((pointer lstp) (record lstd))
                                        supers (linked-list)))) )
           fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                    (summand       (itemtype -> conttype) (prop))
                    (dataview      (pairptrs -> gltype)   (viewtype itemtype)) ) ))

; 28 Oct 03; 30 Oct 03; 31 Oct 03; 13 Nov 03; 25 Nov 03; 20 Aug 04; 24 Sep 04
; 08 Mar 05; 16 Jan 07
(defcspec
   '(array   abbrev arr
          interfaces  ((stg offers storage
                            ((key keytype in)
                             (data datatype in)
                             (root arrtype out))))
          types ((keytype    (match integer) nil)
                 (datatype   (match anything) nil)
                 (record     (typecon datatype) mystgrec)
                 (arrtype    (typecon (arrayof record))  myarrayof) )
          fnspecs ((accfields  (record  -> (listof gltype))  (fields datatype))
                   (size       (arrtype -> integer)          (constant) nil)
                   (memberp    (arrtype -> boolean)          (default #'false))) ))
'
; 15 Sep 04; 16 Sep 04; 24 Sep 04; 16 Jan 07
; Note: it would be good to have histo do a general accumulation,
; as opposed to the present default accumulation (count)
(defcspec
   '(histo   abbrev histo
          interfaces  ((stg offers storage
                            ((key  keytype in)
                             (data datatype in)
                             (root arr out))))
          types ((keytype     (match anything) t)
                 (datatype    (match anything) nil)
                 (conttype    (match number)   nil)
                 (record      (typecon datatype)  mystgrec)
                 (arr         (typecon (arrayof record))  myhistoarr) )
          fnspecs ((accfields (record  -> (listof gltype))   (fields data))
                   (minval    (arr -> conttype)  (constant))
                   (binwidth  (arr -> conttype)  (constant))
                   (nbins     (arr -> integer)   (constant))
                   (index     (key -> conttype)  (prop))
                   (dataview  (arr -> gltype)    (viewtype keytype))
                   (memberp   (arr -> boolean)   (default #'false)) ) ))

; 04 Oct 07; 08 Oct 07; 16 Oct 07; 18 Oct 07; 25 Oct 07; 01 Nov 07
; to use, load cvhg.lsp, select convh and mycvh, (gpfn4 testcvh).
(defcspec
   '(convex-hull   abbrev cvh
           interfaces ((cvhin  offers nil    ((record recordtype in)
                                              (hull   lstp       out))))
   types
    ((recordtype (match anything) cvhg)               ; t to force view type
     (seqtype    (match (sequence anything)))
     (itemtype   (element seq) t)
     (pointtype  (match nvector))
     (lstp       (typecon (^ lstd)) circular-linked-list-pointer)
     (lstd       (typecon (crecord lstof (contents itemtype)
                                         (points lstp)
                                         (link lstp)))
                        circular-linked-list-record) )
   fnspecs
    ((seq        (recordtype -> seqtype)
                   (prop () () () "sequence over which to iterate"))
     (point      (itemtype -> pointtype) (prop) )
     (itemtp     (recordtype -> gltype)              (viewtype itemtype))
     (listrectp  (recordtype -> gltype)              (viewtype lstd))
     (listptrtp  (recordtype -> gltype)              (viewtype lstp)) )
   vwspecs ((lstd linked-list linked-list (link link))) ))

(defcgspec    ; uses cvhg.lsp
 '(convh
    comps ((main convex-hull convex-hull ((arg recordtype))) )
    conns ()
    formals (((arg nil) (recordtype main))) ))

; 04 Sep 03; 08 Dec 03; 05 Aug 04; 12 Aug 04; 13 Aug 04; 17 Feb 05; 22 Nov 06
; 16 Jan 07; 22 Jan 07
(defcspec
 '(iterate-accumulate  abbrev itac  
   interfaces ((itac   offers itacc  ((record recordtype in)))
               (output offers data   ((acc    accumtype out)))
               (acc uses accumulator ((item   itemtype out)
                                      (initdata recordtype out)
                                      (acc      accumtype in)
                                      (outt     outputtype in))) )
   types
    ((recordtype (match anything) t)               ; t to force view type
     (seqtype    (match (sequence anything)))
     (itemtype   (element seq))
     (accumtype  (match anything) nil *)
     (outputtype (match anything) nil *))
   fnspecs
    ((seq        (recordtype -> seqtype)
                   (prop () () () "sequence over which to iterate"))
     (accumtp    (recordtype -> gltype)          (type accumtype))
     (accfields  (recordtype -> (listof gltype)) (fields accumtype)) ) ))
; following does not appear to be used; 2 args for (type ...) no longer works.
;     (outputtp  (recordtype -> gltype)          (type outputtype accumtype))

(setf (get 'iterate-accumulate 'gpdisplayspecs) '((seq (4 20))))

(defcgspec
 '(iter-acc
    comps ((iterator iterate-accumulate itaccfn ((arg recordtype)))
           (accumulator))
    conns (((acc iterator) (accout accumulator)))
    formals (((arg nil) (recordtype iterator))) ))

; 25 Feb 10; 11 Mar 10; 15 Mar 10; 14 Oct 11
; Iterate over a set of items and do something with each
(defcspec
 '(iterate-do  abbrev itdo  
   interfaces ((itdo   offers itdo    ((record recordtype in)))
               (action uses   program ((item   itemtype out)
                                       (acc      accumtype in) )) )
   types
    ((recordtype  (match anything) t)               ; t to force view type
     (seqtype     (match (sequence anything)))
     (itemtype    (element seq))
     (accumtype   (match anything) nil *)  )
   fnspecs
    ((seq        (recordtype -> seqtype)
                   (prop () () () "sequence over which to iterate"))
     (accumtp    (recordtype -> gltype)          (type accumtype))
     (accfields  (recordtype -> (listof gltype)) (fields accumtype)) ) ))
;     (test       (itemtype -> boolean)           (default #'true) ) )
;     (itemview   (recordtype -> gltype)          (viewtype itemtype)) )
;     (argsfn     (itemtype -> anything)          (prop)   )

(setf (get 'iterate-do 'gpdisplayspecs) '((seq (4 20))))

(defcgspec
 '(iter-do
    comps ((iterator iterate-do itdofn ((arg recordtype)))
           (action))
    conns ()
    formals (((arg nil) (recordtype iterator))) ))

; 31 Dec 08; 02 Jan 09
(defcspec
 '(iterate-find  abbrev find
   interfaces ((find   offers finder  ((record recordtype in)))
               (output offers data    ((acc    valuetype out))) )
   types
    ((recordtype (match anything) t)               ; t to force view type
     (seqtype    (match (sequence anything)))
     (itemtype   (element seq) t)
     (valuetype  (typeof value) ) )
   fnspecs
    ((seq        (recordtype -> seqtype)
                   (prop () () () "sequence over which to iterate"))
     (valuetp    (recordtype -> gltype)          (type valuetype))
     (itemview   (recordtype -> gltype)          (viewtype itemtype))
     (test       (itemtype -> boolean) (prop)   )
     (value      (itemtype -> valuetype) (default #'identity) ) )
    ))

(setf (get 'iterate-find 'gpdisplayspecs) '((seq (4 20))))

(defcgspec
 '(find
    comps ((iterator iterate-find findfn ((arg recordtype))) )
    conns ()
    formals (((arg nil) (recordtype iterator))) ))


; 23 Mar 10; 25 Mar 10
(defcspec
 '(iterate-plot  abbrev plot
   interfaces ((plot   offers plotter  ((record recordtype in)))
               (acc uses itemplot ((item   itemtype out)
                                   (acc      accumtype in))) )
   types
    ((recordtype (match anything) t)               ; t to force view type
     (seqtype    (match (sequence anything)))
     (itemtype   (element seq) t)
     (accumtype  (match anything) nil *)
     (valuetype  (typeof value) ) )
   fnspecs
    ((seq        (recordtype -> seqtype)
                   (prop () () () "sequence over which to iterate"))
     (valuetp    (recordtype -> gltype)          (type valuetype))
     (itemview   (recordtype -> gltype)          (viewtype itemtype))
     (accumtp    (recordtype -> gltype)          (type accumtype))
     (accfields  (recordtype -> (listof gltype)) (fields accumtype))
     (test       (itemtype -> boolean)           (default #'true) )
     (position   (itemtype -> vector)            (prop)   )
     (value      (itemtype -> valuetype)         (default #'identity) ) )
    ))

(setf (get 'iterate-plot 'gpdisplayspecs) '((seq (4 20))))

(defcgspec
 '(plot
    comps ((iterator iterate-plot ipplotfn ((arg recordtype))) )
    conns ()
    formals (((arg nil) (recordtype iterator))) ))

; 17 Dec 10; 08 Feb 11
; second version of plot
(defcspec
 '(iterate-plotb  abbrev plotb
   interfaces ((plot   offers plotter  ((record recordtype in)))
               (acc uses itemplot ((item   itemtype out)
                                   (acc    accumtype in))) )
   types
    ((recordtype (match anything) t)               ; t to force view type
     (seqtype    (match (sequence anything)))
     (itemtype   (element seq) t)
     (accumtype  (match anything) nil *)
     (valuetype  (typeof value) ) )
   fnspecs
    ((seq        (recordtype -> seqtype)
                   (prop () () () "sequence over which to iterate"))
     (valuetp    (recordtype -> gltype)          (type valuetype))
     (itemview   (recordtype -> gltype)          (viewtype itemtype))
     (accumtp    (recordtype -> gltype)          (type accumtype))
     (accfields  (recordtype -> (listof gltype)) (fields accumtype))
     (test       (itemtype   -> boolean)         (default #'true) )
     (autoscale  (recordtype -> boolean)         (default #'true) )
     (generatex  (recordtype -> boolean)         (default #'false) )
     (connected  (recordtype -> boolean)         (default #'false) )
     (minx       (recordtype -> number)          (default 0) )
     (maxx       (recordtype -> number)          (default 100) )
     (miny       (recordtype -> number)          (default 0) )
     (maxy       (recordtype -> number)          (default 100) )
     (x          (itemtype   -> number)          (prop)   )
     (y          (itemtype   -> number)          (prop)   )
     (value      (itemtype   -> valuetype)       (default #'identity) ) )
    ))

(setf (get 'iterate-plotb 'gpdisplayspecs) '((seq (4 20))))

(defcgspec
 '(plotb
    comps ((iterator iterate-plotb ipplotfnb ((arg recordtype))) )
    conns ()
    formals (((arg nil) (recordtype iterator))) ))

; 25 Mar 10
(defcspec
 '(circleplot   abbrev cirplot
         interfaces ((accout offers itemplot
                             ((item itemtype in)
                              (acc  sumtype out)
                              (outt conttype out))))
         types ((itemtype (match anything) t)
                (conttype (match number) nil)
                (sumtype  (typecon (radius conttype)) mycirplot) )
         fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                  (radiusval     (itemtype -> conttype) (prop) )
                  (dataview      (sumtype -> gltype)    (viewtype itemtype))
                  (accum         (sumtype -> conttype)  (choice radius)))
         ))

(setf (get 'circleplot 'gpdisplayspecs) '((radius (4 4)) (test (0 -12) " ?")
                                   (initial-value (-30 4))))

; 25 Mar 10
(defcspec
 '(squareplot   abbrev sqrplot
         interfaces ((accout offers itemplot
                             ((item itemtype in)
                              (acc  sumtype out)
                              (outt conttype out))))
         types ((itemtype (match anything) t)
                (conttype (match number) nil)
                (sumtype  (typecon (side conttype)) mysqrplot) )
         fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                  (sideval       (itemtype -> conttype) (prop) )
                  (dataview      (sumtype -> gltype)    (viewtype itemtype))
                  (accum         (sumtype -> conttype)  (choice side)))
         ))

(setf (get 'squareplot 'gpdisplayspecs) '((side (4 4)) (test (0 -12) " ?")
                                   (initial-value (-30 4))))


; 23 Jul 03; 31 Jul 03; 12 Aug 03; 13 Aug 03; 04 Sep 03; 23 Sep 03; 05 Aug 04
; 16 Aug 04; 17 Aug 04; 16 Jan 07; 25 Jan 07
(defcspec
 '(find-update  abbrev fu
   interfaces ((accout offers accumulator
                       ((item itemtype in)
                        (acc  wrapstg  out)
                        (outt wrapstg  out)))
               (stg uses storage
                    ((key  keytype     out)
                     (data accumtype   out)
                     (root storagetype in)))
               (acc uses accumulator
                ((item itemtype  out)
                 (acc  accumtype in)
                 (outt footype   in))) )
   types
    ((itemtype    (match anything) t)           ; t listed to force view type
     (keytype     (match (or symbol string integer boolean)) nil)   ; ?????
     (storagetype (match anything) nil)
     (wrapstg     (typecon (thestg storagetype)) myfu)
     (accumtype   (match anything) nil *)
     (footype     (match anything) nil))    ; F-U stores only the accumtype
   fnspecs
    ((key         (itemtype -> keytype)
                                 (prop () () () "index of item in storage") )
     (test        (itemtype -> boolean)       (default #'true) )
     (dataview    (wrapstg -> gltype)         (viewtype itemtype))
     (accum       (wrapstg -> storagetype)    (choice thestg)) ) ))

(setf (get 'find-update 'gpdisplayspecs) '((key (0 20)) (test (0 -25))))

; 22 Nov 06
(defcspec
 '(variable   abbrev var
              interfaces ((varin offers variable
                                 ((item mytype in)))
                       (varout offers data
                        ((item mytype out))) )
              types ((mytype (match anything) t) )
              fnspecs () ))

; 08 Feb 05; 22 Feb 05; 16 Jan 07
; chain code, cf. sum
(defcspec
 '(chain   abbrev chn
           interfaces ((accout offers accumulator
                               ((item     itemtype  in)
                                (initdata inittype  in)
                                (acc      sumd      out)
                                (outt     accumtype out)))
                       (acc uses accumulator
                            ((item conttype  out)
                             (acc  accumtype in)
                             (outt footype   in))) )
           types ((itemtype (match anything) t)
                  (inittype (match anything) t)
                  (conttype (hasop +) nil)
                  (sumd (typecon (crecord lstof (sum conttype)
                                                (accumdata accumtype)))
                        mychain)
                  (accumtype   (match anything) nil )   ; * ?
                  (footype     (match anything) nil) )  ; stores only the accumtype
           fnspecs ((test          (itemtype -> boolean)  (default #'true) )
                    (summand       (itemtype -> conttype) (prop))
                    (initial-value (inittype -> conttype) (prop))
                    (dataview      (sumd -> gltype )      (viewtype itemtype))
                    (initview      (sumd -> gltype)       (viewtype inittype))
                    (accum         (sumd -> conttype)     (choice)) ) ))

(setf (get 'chain 'gpdisplayspecs) '((summand (4 4)) (test (0 -12) " ?")
                                     (initial-value (-30 4))))

; 02 Oct 03; 16 Jan 07
(defcspec
 '(polygon  abbrev poly  
   interfaces ((poly offers polyg ((record recordtype in)) ) )
   types
    ((recordtype (match anything) t)               ; t to force view type
     (seqtype    (match (sequence anything)))
     (itemtype   (element seq) t) )
   fnspecs
    ((seq        (recordtype -> seqtype) (partof))
     (vecview    (itemtype -> vector)    (prop))
     (dataview   (recordtype -> gltype)  (viewtype itemtype))   ) ))

; 13 Mar 07; 14 Mar 07; 05 Apr 07; 17 Apr 07; 03 May 07; 04 May 07; 07 May 07
; 10 May 07; 11 May 07; 15 May 07; 30 Apr 09; 05 May 09; 23 Jul 09; 06 Aug 09
; 10 Aug 09
; to test: load hs8p.lsp, do (gp), enter board8p as state, select cost, manhat
;          (gpfn2 *easy* *goal*)
; heuristic-search
; types:  statetype:  state in the application domain
;         succtype:   successor of state: state, op, cost
;         recordtype: record used by the heuristic search function
;         opentype:   priority queue of recordtype used as the open list
(defcspec
 '(heuristic-search  abbrev hsearch
   interfaces ((hsearch offers hsearchg
                        ((state statetype in)
                         (priq  opentype  out)) )
               (stg uses priority-queue
                    ((item recordtype out)
                     (priq opentype   in))
                    ((sort-value f)
                     (sort-direction min)) )  )
   types
    ((statetype  (match anything) t)               ; t to force view type
     (succtype   (match anything))
     (optype     (match anything))
     (recordp    (typecon (^ recordtype)) linked-list-pointer)
     (recordtype (typecon (crecord hsrec (state statetype)
                                         (f number)
                                         (g number)
                                         (parent recordp)
                                         (op optype) ) ) t)
     (opentype   (match anything) t)
;     (opentype   (component (priority-queue ((item recordtype))
;                                            ((sort-value f)
;                                             (sort-direction min)) ) ) )

     )
   fnspecs
    ((successors (statetype -> (sequence succtype))   (prop))
     (recordtp   (statetype -> gltype)                (viewtype recordtype))
     (opentp     (statetype -> gltype)                (type opentype))
     (nextstate  ((statetype succtype)  -> statetype) (prop))
     (op         ((statetype succtype)  -> optype)    (prop))
     (applicable ((statetype succtype)  -> boolean)   (prop))
     (cost       ((statetype succtype)  -> number)    (prop))
     (estimate   ((statetype statetype) -> number)    (prop))
     (stateequal ((statetype statetype) -> boolean)   (default #'equalp))
   ) ))

; 12 Apr 07; 17 Apr 07; 02 May 07; 03 May 07; 07 May 07; 10 May 07; 07 May 08
(defcgspec
 '(heurs
    comps ((main heuristic-search heursfn ((arg statetype) (goal statetype))) )
    conns ()
    formals (((arg nil)  (statetype main))
             ((goal nil) (statetype main))) ))

; 14 Mar 07; 16 Mar 07; 27 Mar 07; 29 Mar 07; 03 Apr 07; 17 Apr 07; 28 Jul 09
; 30 Jul 09l 07 Aug 09; 11 Aug 09
(defcspec
 '(array-priority-queue  abbrev apq
   interfaces ((apq offers priority-queue ((item itemtype in)
                                           (priq roottype out)))
               (stg uses queue ((data  itemtype  out)
                                (queue queuetype in)) ) )
   types ((itemtype  (match anything) t)
          (queuetype (component (two-pointer-queue ((data itemtype)) ())))
          (roottype  (typecon (crecord arrpq (lowest integer)
                                             (queues (arrayof queuetype))))
                     myarrtpq)
          (key       (typeof sort-value) t) )
   fnspecs
    ((nbins             (roottype -> integer)    (constant))
     (itemtp            (roottype -> gltype)     (viewtype itemtype))
     (sort-value        (itemtype -> integer)    (prop () ())) )
  ))

; 14 Mar 07; 22 Mar 07; 27 Mar 07; 03 Apr 07
(defcspec
 '(two-pointer-queue  abbrev tpq
   interfaces ((tpq offers queue ((data datatype in)
                                  (root roottype out)) ) )
   types ((datatype  (match anything))
          (lstp (typecon (^ lstd)) linked-list-pointer)
          (lstd (typecon (crecord lstof (contents datatype)
                                        (link lstp)))
                linked-list-record)
          (roottype  (typecon (crecord tpqptrs (qstart lstp) (qend lstp)))
                     two-pointer-queue-record)
          (clus (cluster (roles ((pointer lstp) (record lstd))
                                supers (linked-list)))) )
   vwspecs ((lstd linked-list linked-list (link link))) ))

; 22 Mar 07; 03 Apr 07
(defcspec
 '(listofb abbrev lst
           interfaces ((accout offers accumulator
                               ((data itemtype in)
                                (outt lstp out))))
           types ((itemtype  (match anything) nil)
                  (lstp (typecon (^ lstd)) lisp-linked-list-pointer)
                  (lstd (typecon (cons (contents itemtype)
                                       (link lstp)))
                        lisp-linked-list-record)
                  (clus (cluster (roles ((pointer lstp) (record lstd))
                                        supers (lisp-linked-list)))) )
   vwspecs ((lstd linked-list linked-list (link link))) ))

; 26 Feb 09; 18 Mar 09; 02 Apr 09
(defcspec
 '(dijkstra-sp  abbrev dijkstra
   interfaces ((dijkstra offers shortest-path
                        ((graph   graphtype  in)
                         (result  tabletype  out)) )
               (pq uses priority-queue
                    ((key  keytype     out)
                     (data priqrectype out)
                     (priq fringetype    in)))
               (stg uses storage
                    ((key  keytype     out)
                     (data priqrectype out)
                     (root tabletype in)))
  )
   types
    ((graphtype   (match anything) t)               ; t to force view type
     (nodetype    (match anything) t)               ; t to force view type
     (priqrectype (typecon (crecord priqrec (node nodetype)
                                            (parent nodetype)
                                            (cost number))) t)
     (keytype     (match anything) )
     (edgetype    (match anything) t)
     (tabletype   (match anything) )     ; table of finished nodes
     (fringetype  (match anything) )     ; priority queue of recordtype
     )
   fnspecs
    ((key        (nodetype -> keytype)             (prop))
     (successors (nodetype -> (sequence edgetype)) (prop))
;(vertices   (graphtype -> (sequence nodetype)) (prop))
     (recordtp   (nodetype -> gltype)              (type recordtype))
     (fringetp   (nodetype -> gltype)              (type fringetype))
     (tabletp    (nodetype -> gltype)              (type tabletype))
     (cost       ((nodetype nodetype) -> number)   (prop))
     (estimate   ((nodetype nodetype) -> number)   (prop))
     (stateequal ((nodetype nodetype) -> boolean)  (prop))
   ) ))

; 26 Feb 09; 02 Apr 09
(defcgspec
 '(dijk
    comps ((main dijkstra-search dijkstrafn
                 ((graph graphtype) (start nodetype) (goal nodetype))) )
    conns ()
    formals (((graph nil)  (graphtype main))
             ((start nil)  (nodetype main))
             ((goal nil)   (nodetype main))) ))


; 22 Jan 09
; Note: not called from anywhere.
; Make a cluster with parameters
; (makecspec 'sorted-linked-list '((record part))
;            '((sort-value name) (sort-direction ascending)))

; (gldefun t161 ((p POINTER3)) (sort p))   ; the pointer type of cluster
; (t161 (copy-tree mypart))

; (makecspec 'heap '((item part)) '((sort-value name) (sort-direction max)))
; (gldefun t116 ((h heaptype2) (itm item2)) (insert-item h itm))
; (gldefun t117 ((h heaptype2)) (remove-item h))
; (setq myh (a heaptype2))
; (t116 myh (a part name "foo"))
(gldefun makecspec ((spec cspec) (args (listof glnametype))
                    &optional (propvals (listof (list (name symbol)
                                                      (choice symbol)))))
  (let ((inst cinst))
    (inst = (instcspec nil spec args propvals))
    (ciinferprops inst)
    (cioutprops inst)
    inst))

; 27 Mar 03; 03 Apr 03; 15 Apr 03; 24 Apr 03; 10 Feb 05; 17 Feb 05; 22 Feb 05
; 15 Mar 05; 05 Aug 09; 02 Jun 10; 19 Jul 10; 13 Sep 10
; Instantiate a cluster spec to make a cluster instance
; propvals is as in a synopsis, alist of (propname value)
; (instcspec nil 'sorted-linked-list '((record part)))
; (instcspec nil 'sum '((item box)))
; (instcspec nil 'sorted-linked-list '((record part))
                 '((sort-value name) (sort-direction ascending)))
(gldefun instcspec ((group cigroup) (spec cspec) (args (listof glnametype))
                    &optional (propvals (listof (list (name symbol)
                                                      (choice anything)))))
  (let ((inst cinst) typ itm)
    (inst = (glmkatom (abbrev spec)))
    ((spec inst) = spec)
    (if group ((group inst) = group) )
    (for int in (interfaces spec)
         when (eq (direction int) 'offers)
         (for itm in (items int)
              when (eq (direction itm) 'in)
              (ciaddtype inst (typename itm)
                         (if (setq arg (assoc (name itm) args))
                             (type arg)
                           'anything)
                         nil nil)))
    (ciinfertypes inst)
    (instcspecvals inst propvals)
    inst))

; 13 Sep 10
; process values from a synopsis
(gldefun instcspecvals ((inst cinst)
                        (propvals (listof (list (name symbol)
                                                (choice anything)))))
  (let (spec newinst group)
    (spec = (spec inst))
    (group = (group inst))
    (for propval in propvals do
         (if (fnspec spec (name propval))   ; test fnspec, vs. interface
             (cidoprop inst (name propval) t nil (choice propval))
             (if (and  (int = (that (interfaces (spec inst))
                                    with (and (name == (name propval))
                                              (direction == 'uses))))
                       (or (null (findconns (cigroup group) inst
                                            (name propval)))
                           (gp-arity-multi (spec inst) (name propval))))
                 (newinst = (ciselect inst (name propval)
                                      (choice propval))) ) ) )
    ))

                                  
; 28 May 03; 30 May 03; 10 Feb 05; 07 May 07
; Add types to an instance
; intnm is the name of the interface
; args use the 'external' name in the interface, e.g. item
(gldefun ciaddtypes ((inst cinst) (args (listof glnametype)) (intnm symbol))
  (let ((int (interface (spec inst) intnm)) itm)
    (for arg in args
         when (glstoragestrp (type arg))
         (itm = (item int (name arg)))
         (if itm
             (ciaddtype inst (typename itm) (type arg) nil nil)) )
    (ciinfertypes inst)
    (ciinferprops inst) ))

; 03 Apr 03; 10 Apr 03; 15 Apr 03; 24 Apr 03; 28 May 03; 30 May 03; 05 Jun 03
; 06 Jun 03; 16 Sep 03; 30 Sep 03; 09 Oct 03; 20 Oct 03; 21 Oct 03; 10 Dec 03
; 29 May 04; 03 Aug 04; 10 Aug 04; 12 Aug 04; 04 Nov 04; 10 Feb 05; 28 Aug 06
; 28 Dec 06; 02 May 07
; add a type value to an instance.
; nm = name of type role
; type = new value
; str, if present, will override type as the 'actual' type value
; dep = list of dependencies (props it depends on)
; view type is made only if there is a super
(gldefun ciaddtype ((inst cinst) (nm symbol) (type gltype) (str gltype)
                    (dep (listof symbol)) )
  (let (typspec (viewtp gltype) newtp tp)
    (typspec = (type (spec inst) nm))
    (if (null typspec) (error "No type spec ~A ~A~%" inst nm))
    (or (arg inst nm)
        ((args inst) _+ (a ciarg with name = nm kind = 'type)))
    (newtp = (arg inst nm))
    (if (and (super typspec) (null (viewtype newtp)))
        (progn (viewtp = (if (and (consp type)
                                  (eq (car type) 'crecord))
                             (cadr type)   ; use name of crecord
                           (glmkatom nm)))
               ((viewtype newtp) = viewtp) ))
    (tp = (or str type))
    (if ((arity typspec) == '*)
        ((actual newtp) = (cons 'tuple
                                (append (cdr (actual newtp))
                                        (list (cinametype (ciunwrap tp))))))
        ((actual newtp) = (ciunwrap tp)))
    (viewtp = (viewtype newtp))
    (if viewtp
        ((glstructure viewtp) = (if (ciwrapperp viewtp)  ; reuse wrapper name
                                    (list (list (caar (glstr viewtp)) type))
                                  (list (ciwrapper type)))))
    (if (and ((super typspec) != t) (glstructure viewtp))
        ((supers (glstructure viewtp)) = (list (super typspec))) )
    (if (and (consp type)
             (eq (car type) 'crecord)
             viewtp)
        (pushnew viewtp *vac-newtypes*))
    (if dep ((depend newtp) = dep))
    (if *vac-trace*
        (format t "ciaddtype: ~A of ~A is ~A~%" nm inst tp))
    (cipropatype inst newtp)
    (ciinfertypes inst)      ; Oct 21 2003
 ))

; 30 Sep 03; 29 May 04
; Make a wrapper for a given type.
; If type is already a wrapper, wrap its contents.
(gldefun ciwrapper ((type gltype))
  (if (cipointerp type)
      type
      (if (ciwrapperp type)
          (list (glmkatom 'z) (cadar (glstr type)))
        (list (glmkatom 'z) type)) ) )

; 17 Mar 11
; Test if a type is a pointer type.
(defun cipointerp (pointertype)
  (let (str)
    (if (symbolp pointertype)
        (setq str (glstructure pointertype)))
    (or (and (consp pointertype)
             (eq (car pointertype) '^)
             (cadr pointertype))
        (and (consp str)
             (eq (car str) '^)
             (cadr str))
        (some #'cipointerp (glsupers str)) ) ))

; 30 Sep 03; 20 Oct 03; 23 Oct 03; 09 Dec 03; 29 Nov 10
; Test whether a given type is a wrapper of a named type
(gldefun ciwrapperp ((type gltype))
  (let (str)
    (str = (car (glstr type)))
    (and (consp str)
         (ciwrappernamep (car str))
         (symbolp (cadr str))
         (gltypep (cadr str))
         (null (cddr str)) ) ))

; 29 Nov 10
; test a symbol to see if it is a wrapper name
(gldefun ciwrappernamep ((sym symbol))
  (and (symbolp sym)
       (char= (char (symbol-name sym) 0) #\Z)
       (> (length (symbol-name sym)) 1)
       (every #'digit-char-p (cdr (coerce (symbol-name sym) 'list))) ))

; 30 Sep 03; 29 May 04
; remove wrapper from type if present
(gldefun ciunwrap ((type gltype))
  (if (ciwrapperp type)
      (cadar (glstr type))
      type) )

; 08 Oct 10
; get name to use to remove wrapper from type if present
(gldefun ciunwrapname ((type gltype))
  (if (ciwrapperp type)
      (caar (glstr type))) )

; 27 Oct 10; 05 Nov 10; 08 Nov 10; 22 Oct 10
; new version
;       cpset-message finds the opposites using cpset-port-conns
;       perhaps not use conprop.lsp, but roll our own version for vac.
; Propagate a type through a connection to other components
(gldefun cipropatype ((inst cinst) (newtp ciarg) &optional remove)
  (let ()
    (for int in (interfaces (spec inst))
      (for itm in (items int)
           when (and ((typename itm) == (name newtp))
                     ((direction itm) == 'out))
           (message (cpset (group inst)) inst (name int)
                    (list (name itm))
                    (list (if remove 'remove 'type)
                          (or (viewtype newtp) (actual newtp)))
                    (list inst) ) ) ) ) )


#|   above (message ...) code was:
           (for opp in (cpset-port-conns (cpset (group inst))
                                         inst (name int))
                (cgconnoppb (menu-name opp) (port opp)
                            (name itm) newtp remove) ))) ))
|#

; ***** no longer used
; 05 Nov 10; 08 Nov 10
; propagate a type to opposite box across a connection
(gldefun cgconnoppb ((otherinst cinst) (intname symbol) (itmname symbol)
                     (newtp ciarg) (remove boolean))
  (let (otherint otheritm)
    (otherint = (interface (spec otherinst) intname))
    (otheritm = (item otherint itmname))
    (if remove
        (ciremtype otherinst (typename otheritm)
                          (or (viewtype newtp) (actual newtp)))
        (progn
          (ciaddtype otherinst (typename otheritm)
                     (or (viewtype newtp) (actual newtp)) nil nil)
          (ciinfertypes otherinst)
          (ciinferprops otherinst) ) ) ))

; 22 Nov 10; 23 Nov 10; 24 Nov 10
; respond to a type message
(gldefun citypemsgfn ((cps cpset) (inst cinst) (port symbol)
                      (subport symbol) (msg anything) (from symbol))
  (let (int intf)
    (if *vac-trace*
        (format t "citypemsgfn: ~A  ~A  ~A~%" inst port msg))
    (int = (interface (spec inst) port))
    (intf = (item int (first subport)))
    (if intf
        (case (car msg)
          (type (ciaddtype inst (typename intf) (second msg) nil nil)
                (ciinfertypes inst)
                (ciinferprops inst) )
          (remove (ciremtype inst (typename intf) (second msg)) ) )
        (error "No port interface ~A  ~A  ~A~%" inst port msg) )
      ))

; 22 Nov 10
; respond to a remove message
(gldefun ciremovemsgfn ((cps cpset) (inst cinst) (port symbol)
                      (subport symbol) (msg anything) (from symbol))
  (let ()
    (if *vac-trace*
        (format t "ciremovemsgfn: ~A  ~A  ~A~%" inst port msg))

))

; 10 Feb 05; 28 Dec 06
; Remove a type from an instance, if the arity is *
(gldefun ciremtype ((inst cinst) (nm symbol) (type gltype))
  (let (typspec newtp)
    (typspec = (type (spec inst) nm))
    (if (null typspec) (error "No type spec ~A ~A~%" inst nm))
    (newtp = (type inst nm))
    (if (and newtp ((arity typspec) == '*))
        ((actual newtp) = (ciremfrom (actual newtp) (ciunwrap type))) ) ))

; 10 Feb 05
; remove a type from a tuple
(defun ciremfrom (whole part)
  (let (hits)
  (if (and (consp whole)
           (not (eq (car whole) 'tuple))
           (equal (cadr whole) part))
      nil
      (if (and (consp whole)
               (eq (car whole) 'tuple))
          (progn (setq hits (subset #'(lambda (x) (equal (cadr x) part))
                                    (cdr whole)))
                 (if (= (length hits) 1)
                     (if (cddr whole)
                         (cons (car whole) (remove (car hits) (cdr whole)))
                       nil)
                   (error "ciremfrom ambiguous~%") ) ) ) ) ))

; 03 Apr 03; 15 Apr 03; 22 Apr 03; 24 Apr 03; 07 May 03; 15 May 03; 05 Jun 03
; 06 Jun 03; 24 Jul 03; 23 Sep 03; 09 Oct 03; 16 Oct 03; 23 Oct 03; 09 Dec 03
; 29 May 04; 02 Jun 04; 12 Aug 04; 02 Sep 04; 09 Sep 04; 14 Sep 04; 10 Feb 05
; 28 Aug 06; 29 Dec 06; 09 Jan 07; 16 Mar 07; 27 Mar 07; 29 Mar 07; 01 May 07
; 22 Jul 09; 30 Jul 09; 04 Aug 09; 04 Feb 10; 17 Dec 10; 28 Nov 11
; Infer types of a cinst when possible
; (ciinfertypes 'sll5)
(gldefun ciinfertypes ((inst cinst))
  (let (prop tp new newtp subs typspec pattern tmp newcomp cname args)
    (if *vac-trace*
        (format t "ciinfertypes: ~A~%" inst))
    (for formal in (types (spec inst))                     ; for each type
         when (or (not (tp = (type inst (name formal))))   ; if unknown
                  (and (member (typehow formal)           ;   or bookkeeping
                               '(type typecon cluster single))))
         (typspec = (typespec formal))
         (case (typehow formal)
           (^  (if (actual inst (cadr typspec))   ; if pointer to known type
                   (progn
                     (setq newtp (glvfindtype
                                  (list '^ (viewtype inst (cadr typspec)))))
                     (ciinftrace (name formal) inst newtp)
                     (ciaddtype inst (name formal)  ;    infer the pointer type
                              newtp
                              (list '^ (actual inst (cadr typspec)))
                              (list (cadr typspec)) ) ) ) )
           (typeof (if (prop = (arg inst (cadadr formal)))
                       (or (equal (type prop) (actual tp))
                           (ciaddtype inst (name formal) (type prop) nil
                                      (list (name prop)) )) ) )
           (element
             (if (prop = (arg inst (cadadr formal)))
                 (if (and (consp (type prop))
                          (member (car (type prop)) '(listof arrayof)))
                ; 28 Nov 11 replaced cadr below with cioverloaditem
                     (ciaddtype inst (name formal) (cioverloaditem (type prop))
                                nil (list (name prop)) )
                     (if (tmp = (glloopitemtype (type prop)))
                         (ciaddtype inst (name formal) tmp nil
                                    (list (name prop))))) ) )
           ((typecon cluster component single)
             (if (and (pattern = (cadr typspec))  ; check if args are defined
                      (or (args = (citypesusedb inst pattern)) t)
                      (or (and (consp pattern)
                               (eq (car pattern) '^))
                          (every #'(glambda (nm) (actual (type inst nm)))
                                 args) ))
                 (progn (subs = (for nm in args collect
                                     (cons nm
                                           (ciremtuple inst nm
                                                       (actual (type inst nm))
                                                       (viewtype (type inst nm))))))
                        (if (and (consp pattern)
                                 (eq (car pattern) 'crecord))
                            (if (eq *gp-language* 'lisp)
                                (setq pattern (cons
                                                (if (eql (length pattern) 4)
                                                    'cons 'list)
                                                (cddr pattern)))
                                (push (cons (cadr pattern)
                                            (if (and (consp (actual tp))
                                                     (eq (car (actual tp))
                                                         'crecord))
                                                (cadr (actual tp))
                                                (glmkatom (cadr pattern))))
                                      subs)))
                        (new = (if (eq (car typspec) 'single)
                                   (if (glbasictypep (cdar subs))
                                       (cdar subs)
                                       (list '^ (cdar subs)))
                                   (sublis subs pattern)))
                        (if (eq (car typspec) 'component)
                            (progn
                              (setq cname (car new))
                              (if (not (cspecp cname))
                                  (setq cname (menu (cioffers cname)
                                                    (name formal))) )
                              (setq newcomp (instcspec (group inst) cname
                                                       (second new) (third new)))
                              (addinst (group inst) (name formal) newcomp)
                              (ciaddtype inst (name formal)
                                         (cioutputtype newcomp) nil args))
                            (if (not (citypeequal new (actual tp)))
                                (progn
                                  (if (eq (car typspec) 'cluster)
                                      (progn
                                        (newtp = (glmkatom 'clus))
                                        (setf (glclusterdef newtp) new)
                                        (for x in subs when (symbolp (cdr x))
                                             (setf (glcluster (cdr x)) newtp)) ))
                                  (ciaddtype inst (name formal) new nil
                                             args)))) ) ) ) ) ) ))
; ???      (t (if (glconcrete? typspec (citypesubs inst))
;                  (progn (newtp = (cimaketype typspec (citypesubs inst)))
;                         (ciaddtype inst (name formal) newtp newtp
;                                    (citypesused typspec (citypesubs inst)))))) ) ) ))

; 01 May 07
; Trace operation of ciinfertypes
(gldefun ciinftrace ((inst cinst) (name symbol) (value gltype))
  (if *vac-trace*
      (format t "ciinfertypes: ~A of ~A = ~A~%" name inst value)))

; 27 Mar 07
; Find the output type of a component instance
(gldefun cioutputtype ((inst cinst))
  (let (res)
    (for int in (interfaces (spec inst))
         when (eq (direction int) 'offers)
         (for itm in (items int)
              when (eq (direction itm) 'out)
              (res +_ itm)))
    (if (and res (null (cdr res)))
        (viewtype inst (typename (car res))) ) ))

; 28 Nov 11
; Overload the type of a loop item of an array with an "index" property.
; This is a cheap hack because it relies on the variable name 'indx'
; that is used in iter.lsp; there needs to be a better way to do this.
(defun cioverloaditem (type)
  (let (elttype wraptype)
    (setq elttype (cadr type))
    (if (eq (car type) 'arrayof)
        (progn (setq wraptype (glgensym 'loopitem))
               (setf (glstructure wraptype)
                             (if (and (symbolp elttype)
                                      (glstructure elttype))
                                 (list elttype 'prop
                                       '((index (indx) result integer))
                                       'supers (list elttype))
                                 (list elttype 'prop
                                       '((index (indx) result integer)))))
               wraptype)
        elttype) ))

; 30 Sep 03; 17 Aug 04; 07 Sep 04; 09 Sep 04; 05 Oct 04; 04 Feb 10
; remove 'tuple' prior to type substitution:
; if only one item in the tuple, reduce to that item;
;    else, make it a list or crecord
(gldefun ciremtuple ((inst cinst) (name symbol) (actual anything) (viewtp gltype))
  (let (nm newtp)
    (if (and (consp actual)
             (eq (car actual) 'tuple))
        (if (null (cddr actual))
            (cadr actual)
            (if (eq *gp-language* 'lisp)
                (cons 'list (cdr actual))
                (progn (setq nm (or viewtp (glmkatom 'crec)))
                       (setq newtp (cons 'crecord (cons nm (cdr actual))))
                       (setf (glstructure nm) (list newtp))
                       ((viewtype inst name) = (cadr newtp))
                       newtp)))
        (or viewtp actual) ) ))

; 30 Mar 07
; useful in debugging cidoprop:
(gldefun cifnspec+ ((inst cinst) (propname symbol))
  (let (fnspec how insig outsig goaltp choices)
    (fnspec = (fnspec (spec inst) propname))
    (how = (howspec fnspec))
    (insig = (input1 fnspec))
    (outsig = (output fnspec))
    (goaltp = (or (actual inst outsig)
                  (and (gltypep outsig) outsig)))
    (choices = (cidopropchoices inst fnspec))
    (list 'fnspec fnspec 'how how 'insig insig 'outsig outsig
          'goaltp goaltp 'choices choices) ))


; new version of cidoprop that splits inference and asking user

; 03 Apr 03; 08 Apr 03; 10 Apr 03; 15 Apr 03; 16 Apr 03; 29 Apr 03; 06 May 03
; 13 May 03; 20 May 03; 30 May 03; 06 Jun 03; 24 Jul 03; 28 Jul 03; 08 Aug 03
; 30 Oct 03; 04 Nov 03; 06 Nov 03; 27 May 04; 29 May 04; 05 Aug 04; 11 Aug 04
; 16 Aug 04; 08 Sep 04; 09 Sep 04; 10 Feb 05; 17 Feb 05; 22 Feb 05; 03 Nov 05
; 28 Aug 06; 14 Dec 06; 02 Jan 07; 05 Jan 07; 08 Jan 07; 09 Jan 07; 23 Jan 07
; 25 Jan 07; 30 Jan 07; 01 Feb 07; 15 Mar 07; 20 Mar 07; 30 Mar 07; 07 May 07
; 16 Oct 07; 02 Jan 09; 19 Feb 09; 30 Apr 09; 27 May 09; 28 May 09; 29 May 09
; 02 Jun 10; 24 Sep 10; 28 Sep 10; 04 Oct 10; 06 Oct 10
; Infer or ask for prop selection
; suggestion is a symbol or (symbol props) giving suggested choice
; (cidoprop 'sll1 'sort-value)
; (cidoprop 'sll1 'link)
(gldefun cidoprop ((inst cinst) (propname symbol)
                   &optional noask nodefault suggestion)
  (let (infer prop fnspec how outsig)
    (if *vac-trace*
        (format t "cidoprop: ~A of ~A~%" propname inst))
    (fnspec = (fnspec (spec inst) propname))
    (how = (howspec fnspec))
    (outsig = (output fnspec))
    (if (not nodefault)
        (infer = (ciinferprop inst propname suggestion)))
    (if (or (first infer) (second infer))    ; if inference succeeded
        (progn (prop = (cimakeprop inst propname (car infer)
                                   (cadr infer)))
               ((depend prop) = (third infer))         ; dep
               ((source prop) = (fourth infer)) )      ; howw
      ; else: need to ask
        (if (not noask)
            (prop = (ciaskprop inst propname)) ) )
    (if *vac-alltrace*
        (format t "cidoprop: ~A = ~A~%~A~%" propname prop
                (list 'fnspec fnspec 'prop prop 'outsig outsig)))
    (when prop
        (addprop inst prop)
        (if (member (howfn how) '(prop partof default))     ; prop implies type
            (ciupdatetype inst outsig prop) )
        (if *vac-trace*
            (format t "cidoprop: ~A = ~A~%" propname prop))
        (ciinfertypes inst)) ))


; for testing
(gldefun citest ((inst cinst) (propname symbol) suggestion)
  (let (res)
    (res = (ciinferprop inst propname suggestion))
    (cimakeprop inst propname (first res) (second res)) ))


; 29 Sep 10; 01 Oct 10; 04 Oct 10; 16 Dec 10; 31 Oct 11
; Infer choice for a prop if possible.
; adapted from old cidoprop.
; result is (choice (code type) dependencies howw)
; if a symbol, code is a fn name
(gldefun ciinferprop ((inst cinst) (propname symbol) suggestion)
  (let (fnspec how goaltp choice choices (howw 'inference)
        dep insig1 outsig choiceval sugg codetyp vars arg alist cd (ok t))
    (fnspec = (fnspec (spec inst) propname))
    (how = (howspec fnspec))
    (insig1 = (input1 fnspec))
    (outsig = (output fnspec))
    (goaltp = (glxtrtype (ciactualtype inst outsig)))
    (choices = (cidopropchoices inst fnspec))
    (if (eq (howfn how) 'default)
        (progn (howw = 'default)
               (if (and (consp (arg how))
                        (eq (car (arg how)) 'function))
                   (codetyp = (list (cadr (arg how)) goaltp)) ; fn name
                   (progn (codetyp = (list (arg how) goaltp))
                          (if (actual inst insig1)
                              (dep = (list insig1)))) ) )
        (if (or choices (member (howfn how) '(constant eval)))
            (progn
              (dep = (case (howfn how)
                       (oneof (list insig1) )
                       ((type viewtype) (list (cadr how)) )
                       ((prop msg partof default)
                         (if (not (gltypep outsig)) (list outsig)) )
                       (eval (varsin (arg how)) )  ) )
              (sugg = (if (consp suggestion) (first suggestion) suggestion))
              (choiceval = (and sugg
                                (if (eq (howfn how) 'oneof)
                                    (and (member sugg choices)
                                         sugg)  ; ***** ??? symbol vs cons
                                    (if choices
                                        (assoc sugg choices)
                                        (if (eq (howfn how) 'constant)
                                            sugg)))))
              (if choiceval (setq choices (list choiceval)))
              (choice =
                (case (howfn how) of
                  ((prop msg partof oneof type fields viewtype choice default)
                    (if (null (cdr choices))
                        (car choices)) )           ; only one choice
                  (names (howw = 'inference) choices)
                  (constant choiceval)
                  (eval (vars = (varsin (arg how)))
                        (for var in vars
                             (if (and (arg = (arg inst var))
                                      (eq (kind arg) 'fn)
                                      (member 'code (props arg)))
                                 (progn (cd = (code (props arg)))
                                        (if (eq cd 'true)
                                            (cd = t)
                                            (if (eq cd 'false)
                                                (cd = nil)))
                                        (push (cons var cd) alist) )
                                 (ok = nil)) )
                        (and ok (eval (sublis alist (arg how)))) ) ) ) ) ) )
    (list choice codetyp dep howw) ))

; 06 Oct 10; 16 Dec 10; 31 Oct 11
; fill a prop by asking the user
; derived from the old cidoprop
(gldefun ciaskprop ((inst cinst) (propname symbol))
  (let (fnspec how insig1 outsig goaltp choices dep ch prop
         choice choiceval sugg codetyp)
    (fnspec = (fnspec (spec inst) propname))
    (how = (howspec fnspec))
    (insig1 = (input1 fnspec))
    (outsig = (output fnspec))
    (goaltp = (glxtrtype (ciactualtype inst outsig)))
    (choices = (cidopropchoices inst fnspec))
    (when (or choices (member (howfn how) '(constant default prop msg)))
      (if (not (member (howfn how) '(oneof)))
          (dep = (list insig1)) )
      (if (member (howfn how) '(type viewtype))
          (dep = (cons (cadr how) dep)) )
      (if (and (member (howfn how) '(prop msg partof default))
               (not (gltypep outsig)))
          (dep = (cons outsig dep)) )
      (choice =
        (case (howfn how) of
          ((prop msg partof oneof type fields viewtype choice default)
             (setq ch (cimenu (cstr "Specify choice for ~A of ~A: "
                                     (or (prompt how) ""))
                               (list propname inst)
                               (if (member (howfn how) '(prop msg default))
                                   (cons "Specify fn"
                                         (mapcar
                                          #'(lambda (x)
                                              (if (and (consp x)
                                                       (consp (car x)))
                                                  (list (caar x)
                                                        (cadr x))
                                                  x))
                                          choices))
                                   (mapcar #'(lambda (x)
                                               (if (and (consp x)
                                                        (consp (car x)))
                                                   (list (caar x) (cadr x))
                                                   x))
                                           choices))
                                 nil))
             (dolist (x choices)
               (if (and (consp x) (consp (car x))
                        (eq (car ch) (caar x))
                        (eq (cadr ch) (cadr x)))
                   (setq ch x)))
             ch)
          (constant (howw = 'user)
                    (ttyinp "Specify value for ~A: "
                            (list propname)
                            (or (actual inst outsig)
                                outsig)) ) ) )
      (if (and (stringp choice) (string= choice "Specify fn"))
          (prop = (cipropfn inst fnspec))
          (prop = (cimakeprop inst propname choice nil) ) ) )
    prop))

; 31 Oct 11
; Choose first item if only one, else call glvmenu
(defun cimenu (prompt-string prompt-parms choices ch)
  (if (and (consp choices)
           (null (cdr choices)))
      (first choices)
      (glvmenu prompt-string prompt-parms choices ch) ) )


; 28 Sep 10; 01 Oct 10; 04 Oct 10; 20 Oct 10; 31 Oct 11
; make the prop output form
; derived from the old cidoprop
(gldefun cimakeprop ((inst cinst) (propname symbol) choice codetyp)
  (result ciarg)
  (let (fnspec fn how insig1 outsig)
    (fnspec = (fnspec (spec inst) propname))
    (how = (howspec fnspec))
    (insig1 = (input1 fnspec))
    (outsig = (output fnspec))
    (if (and (consp codetyp)
             (symbolp (car codetyp))
             (fboundp (car codetyp)))
        (setq fn (car codetyp)) )
    (a ciarg with
       name = propname
       kind = 'fn
       choice = (case (howfn how) of
                  ((prop msg partof choice default)
                    (or (car codetyp)
                        (and (consp choice) (car choice))))
                  ((oneof names constant type fields viewtype)
                    choice))
       code = (case (howfn how) of
                ((prop msg partof choice default) ; choice is (name type)
                  (or fn
                      (and codetyp
                           (if (and (symbolp (car codetyp))
                                    (fboundp (car codetyp)) )
                                (car codetyp)
                             (list (sublis
                                   (mapcan
                                    #'(lambda (tp)
                                        (if (setq act (actual inst tp))
                                            (list (cons tp act))))
                                    (append (inputs fnspec) (used how)))
                                   (car codetyp)))))
                      (and (consp choice)
                           (cifncode inst fnspec choice))))
                ((names oneof) (list (kwote choice)))
                (constant (list (subst (actual inst outsig)
                                       outsig choice)))
                ((viewtype type)
                  (list (kwote (cixtrtype (cadr choice)))))
                ((fields)
                  (if (and (consp (cadr choice))
                           (eq (caadr choice) 'z))
                      (setq choice (cadr choice)))
                  (list (kwote (if (and (consp (cadr choice))
                                        (member (caadr choice)
                                                '(list tuple)))
                                   (mapcar #'car (cdadr choice))
                                   (list (caadr choice)))))) )
       type = (case (howfn how) of
                ((prop msg partof choice default)
                  (if codetyp
                      (if (constantp (car codetyp))
                          (glconstanttype (car codetyp))
                          (ciactualtype inst outsig))
                      (if (consp choice)
                          (cadr choice)
                          (if (eq fn 'identity)   ; ??? can it ever get here?
                              (actual inst insig1)
                              (if (gltypep outsig)
                                  outsig
                                  (or (glfnresulttype fn)
                                      (progn (if (glgetd fn)
                                                 (glcc fn))
                                             (glfnresulttype fn))))))))
                ((viewtype type) 'gltype)
                ((fields) '(listof symbol))
                ((constant) (actual inst outsig)))
       cltype = (case (howfn how) of
                  ((prop partof default) (viewtype inst outsig))
                  (type (cixtrtype (cadr choice)))) ) ))


; for testing:
(gldefun cidopropchoicesb  ((inst cinst) (propname symbol))
   (cidopropchoices inst (fnspec (spec inst) propname)) )

; 24 Sep 10
; for testing:
(gldefun cifnspecstuff ((spec cspec) (propname symbol))
  (let (fnspec)
    (fnspec = (fnspec spec propname))
    (list (list 'fnspec fnspec)
          (list 'how    (howspec fnspec))
          (list 'howfn  (howfn fnspec))
          (list 'excls  (excls fnspec))
          (list 'insig1 (input1 fnspec))
          (list 'insig  (inputs fnspec))
          (list 'outsig (output fnspec)) ) ))


; 29 Apr 03; 06 May 03; 13 May 03; 15 May 03; 30 May 03; 06 Jun 03; 02 Oct 03
; 03 Oct 03; 09 Oct 03; 14 Oct 03; 13 Nov 03; 26 Nov 03; 08 Dec 03; 29 May 04
; 01 Jun 04; 13 Aug 04; 14 Jul 06; 02 Jan 07; 05 Jan 07; 08 Jan 07; 09 Jan 07
; 10 Jan 07; 17 Jan 07; 22 Jan 07; 01 Feb 07; 20 Mar 07; 17 Apr 07; 24 Apr 07
; 02 May 07; 03 May 07; 31 Dec 08; 12 Feb 09; 09 Sep 09; 25 Mar 10; 29 Sep 10
; 31 Oct 11
; Get choices for a function spec for inst
; Result is a list of ((name type) ...)
(gldefun cidopropchoices ((inst cinst) (fnspec csfnspec))
  (let ((nametypes (listof glnametype)) how goaltp excepts actualtp
         actualtps tp res insig outsig)
    (how = (howspec fnspec))
    (insig = (inputs fnspec))
    (outsig = (output fnspec))
    (if ((howfn how) == 'oneof)
        (arg how)
        (progn
          (actualtps = (for x in insig collect (ciactualtype inst x)))
          (actualtp =  (first actualtps))
          (goaltp = (and (not (member (howfn how) '(choice type names)))
                         (or (ciproptype inst outsig)
                             (and (gltypep outsig) outsig)
                             (and (consp outsig)
                                  (member (car outsig) '(sequence))
                                  (gltypep (cadr outsig))
                                  outsig)
                             (and (ciundeftypeok inst (name fnspec) outsig)
                                  'anything) ) ) )
          (if (and (consp goaltp) (eq (car goaltp) 'match))
              (setq goaltp (cadr goaltp)) )
          (if (member (howfn how) '(prop msg partof names))
              (excepts = (for x in (excls how) collect (choice (arg inst x)))))
          (nametypes = (case (howfn how) of
                         (msg (ciallnames actualtps goaltp 'msg))
                         ((prop default) (ciallnames actualtps goaltp))
                         ((partof names) (cidatanames actualtp goaltp))
                         (choice (if (eq outsig 'identity)
                                     (list (list 'identity actualtp))
                                     (list (assoc (arg how)
                                                  (gldatanames actualtp)))))
                         (viewtype (list (a glnametype name 'z
                                            type (viewtype inst (arg how)))))
                         (fields (list (a glnametype name 'z
                                          type (actual inst (arg how)))))
                         (type (citypechoices inst (actual inst (arg how))
                                              (name fnspec) nil) ) ) )
;                                           old version had last arg
;                                    (and (cddr how) (actual inst (caddr how)))
          (res = (for nt in nametypes
                      when (and (not (member (name nt) excepts))
                                (or (null goaltp)
                                    (eq (howfn how) 'msg)
                                    (citypematch (type nt) goaltp)))
                      collect nt))
          (if (goaltp == 'boolean)
              (res = (append '((true boolean) (false boolean)) res)) )
          (if *vac-alltrace*
              (format t "cidopropchoices: ~A  ~A~%~A~%" inst fnspec
                      (list 'nametypes nametypes 'how how 'goaltp goaltp
                             'excepts excepts 'actualtp actualtp
                             'actualtps actualtps
                             'tp tp 'res res 'insig insig 'outsig outsig)))
          (or res (and (eq (howfn how) 'prop)   ; look for or make a view
                                                ;  (not (default fnspec))
                       (null (cdr actualtps))   ; single argument
                       (if (gldescendantp actualtp goaltp)
                           (list (list 'identity goaltp))
                           (if (and goaltp (symbolp goaltp)
                                    (not (glbasictypep goaltp))
                                    (glfindview actualtp goaltp))
            ;  was   (or (glfindview actualtp goaltp)  (progn
            ;                              (cioutmsg (format nil
            ;                                                "Make view ~A"
            ;                                                (name fnspec)))
            ;                              (mkv goaltp actualtp))))
                               (list (list goaltp goaltp))))) ) ) )))

; 13 Nov 03; 29 May 04; 13 Aug 04; 07 Sep 04; 25 Jan 05; 09 Jan 07
; Get type choices for a prop.
; if goaltp is specified, use its field names.
(gldefun citypechoices ((inst cinst) (tp anything) (nm symbol)
                        (goaltp anything))
  (let ((ntp tp) prp nam)
    (if (and (consp tp) (consp goaltp)
             (eq (car tp) 'tuple) (eq (car goaltp) 'tuple))
        (setq tp (cons (car tp)
                       (mapcar #'(lambda (x y) (cons (car y) (cdr x)))
                               (cdr tp) (cdr goaltp)))))
    (if (and (consp tp)
             ((car tp) == 'tuple))
        (if (cddr tp)   ; if more than one field
            (case *gp-language*
              (lisp (setq ntp (cons 'list (cdr tp))) )
              (t (setq prp (arg inst nm))
                 (setq nam (if (and prp (consp (choice prp))
                                    (member (caadr (choice prp)) '(crecord)))
                               (cadadr (choice prp))    ; reuse the old name
                             (glmkatom nm)))
                 (setq ntp (cons 'crecord (cons nam (cdr tp))))
                 (eval (list 'glispobjects (list nam ntp)))
                 (pushnew nam *vac-newtypes*) ) )
            (setq ntp (cadr tp))))
    (list (a glnametype name 'z type ntp)) ))


; 01 May 03; 06 May 03; 13 May 03; 30 May 03; 06 Jun 03; 14 Dec 06; 03 Jan 07
; 09 Jan 07; 10 Jan 07; 17 Jan 07; 22 Jan 07; 23 Jan 07; 25 Jan 07; 30 Jan 07
; 02 Jan 09; 16 Dec 10; 31 Oct 11
; Test whether a prop is ready to be processed
; typeok = consider ready if goal type is unknown
(gldefun cipropready ((inst cinst) (propname symbol) (typeok boolean))
  (let (fnspec how outsig arg)
    (fnspec = (fnspec (spec inst) propname))
    (how = (howspec fnspec))
    (outsig = (output (signature fnspec)))
    (and (or (eq (howfn how) 'default)
             (every #'(glambda (type) (choice (arg inst type)))
                    (excls how)))
         (case (howfn how)
           ((oneof constant) t)
           (default (if (and (consp (arg how))  ; defer until type known
                             (eq (car (arg how)) 'function)
                             (eq (cadr (arg how)) 'identity))
                        (actual inst (input1 (signature fnspec)))
                        (or (constantp (arg how))
                            (and (consp (arg how))
                                 (glconstantp (arg how)))
                            (and (consp (arg how))
                                 (every #'(lambda (type) (actual inst type))
                                        (used how))) )) )
           ((viewtype type fields) (actual inst (arg how)) )
           ((names choice) (actual inst (input1 fnspec)))
           ((prop msg partof)
              (and (every #'(glambda (type) (actual inst type))
                          (inputs (signature fnspec)))
                   (or typeok
                       (glbasictypep outsig)
                       (actual inst outsig))) )
           (eval (every #'(glambda (var)
                            (and (arg = (arg inst var))
                                 (eq (kind arg) 'fn)
                                 (member 'code (props arg))) )
                        (varsin (arg how))) )  ) ) ))

; 16 Dec 10
; Test a condition specified with a prop (true if no condition)
(gldefun cipropcond ((inst cinst) (propname symbol))
  (let (fnspec code vars arg alist (ok t) cd)
    (fnspec = (fnspec (spec inst) propname))
    (code = (condition fnspec))
    (vars = (varsin code))
    (for var in vars
         (if (and (arg = (arg inst var))
                  (eq (kind arg) 'fn)
                  (member 'code (props arg)))
             (progn (cd = (code (props arg)))
                    (if (eq cd 'true)
                        (cd = t)
                        ((if (eq cd 'false)
                             (cd = nil))))
                    (push (cons var cd) alist) )
             (ok = nil)) )
    (or (null code)
        (and ok (eval (sublis alist code)))) ))

; 12 Feb 09
; See if it is okay that a type is undefined because it is the type
; of this property
(gldefun ciundeftypeok ((inst cinst) (name symbol) (outsig symbol))
  (let (ts)
    (ts = (typespec (type (spec inst) outsig)))
    (and (eq (typehow ts) 'typeof)
         (eq (first (typeargs ts)) name))))

; 30 May 03; 06 Jun 03; 25 Sep 03; 28 Aug 06; 12 Dec 06; 04 Jan 07; 16 Mar 07
; 22 Jan 09; 05 Oct 11
; Infer prop's that are derived from types that may have become defined
(gldefun ciinferprops ((inst cinst))
  (let (choices)
    (if *vac-trace*
        (format t "ciinferprops: ~A~%" inst))
    (for pr in (fnspecs (spec inst))
         when (or (and (member (howfn pr) '(type viewtype fields choice
                                                 default))
                       (actual inst (input1 pr))
                       (not (and (eq (howfn pr) 'default)
                                 (arg inst (name pr)))) )
                  (and (eq (howfn pr) 'partof)
                       (actual inst (input1 pr))
                       (eql (length (cidopropchoices inst pr)) 1)) )                       
         (cidoprop inst (name pr))
         (cioutprop inst (viewtype inst (input1 pr)) (name pr))) ))

; 15 May 03; 21 Oct 03; 29 May 04; 05 Jan 07; 11 May 07; 12 Feb 09; 22 May 09
; 09 Sep 09
; Determine type to be used for satisfaction of a prop spec.
; For basic types, just return the type; otherwise, look it up in the cluster
(gldefun ciproptype ((inst cinst) (tp anything))  (result gltype)
  (let (tpb)
    (if (or (glbasictypep tp)
            (member tp '(gltype)))
        tp
        (if (symbolp tp)
            (or (actual inst tp)
                (and (setq tpb (typespec (type (spec inst) tp)))
                     (consp tpb)
                     (if (eq (car tpb) 'match)
                         (cadr tpb)
                         (if (eq (car tpb) 'hasop) tpb))))
            (if (and (consp tp) (member (car tp) '(^ listof arrayof sequence)))
                (list (car tp) (ciproptype inst (cadr tp))) ) ) ) ))

; 30 Apr 09
; Update types of instance based on type found for a prop
(gldefun ciupdatetype ((inst cinst) (outsig anything) (prop ciarg))
  (let (elttype)
    (if (and (symbolp outsig)                     ; direct match of outsig type
             (type (spec inst) outsig)
             (not (actual inst outsig)))
        (ciaddtype inst outsig (type prop) (cltype prop)
                       (list (name prop)))
        (if (and (consp outsig)                   ; element type of sequence
                 (eq (car outsig) 'sequence)
                 (type (spec inst) (cadr outsig))
                 (not (actual inst (cadr outsig)))
                 (setq elttype (glsequencep (type prop))))
            (ciaddtype inst (cadr outsig) elttype nil
                       (list (name prop))) ) ) ))

; 03 Oct 03
; test if a type is a record, i.e. contains multiple values
(defun glrecordp (str)
  (and str
       (if (symbolp str)
           (and (not (glbasictypep str))
                (glrecordp (car (glstr str))))
           (and (consp str)
                (if (member (car str) *gltypenames*)
                    (not (member (car str) '(listof arrayof)))
                    (and (cdr str) (null (cddr str))
                         (glrecordp (cadr str))))))))

; 10 Apr 03; 29 May 04; 08 Jan 07
; add a prop to a cluster instance, replacing old value if it exists
(gldefun ciaddprop ((inst cinst) (prop ciarg))
  (let (old)
    (if (old = (that (args inst) with name == (name prop)))
        ((rest old) = (rest prop))        ; implementation dependent ***
        ((args inst) _+ prop) ) ))

; 11 Apr 02
; set the specified prop value of a GLisp type.  parm = prop, adj, isa, msg
; e.g. (glsetprop type 'prop 'zero '((0) result integer))
(defun glsetprop (str parm prop val)
  (let ((oldval (glgetprop str parm prop)))
    (if oldval
        (setf (cdr oldval) prop)
        (push (cons prop val)
              (getf (cdr (glstr str)) parm)) ) ))

; 21 Sep 04
; Make a symbol have a constant value for glisp compilation
(defun glmakeconstant (sym value &optional type)
  (let ()
    (setf (glispconstantflg sym) t)
    (setf (glispconstantval sym) value)
    (setf (glispconstanttype sym)
          (or type
              (glconstanttp value))) ))

; 01 May 03; 13 May 03; 15 May 03; 09 Jan 07; 20 Jul 10
(gldefun cidoprops ((inst cinst) &optional (vals (listof anything)))
  (let (done (didone t))
    (while (and (not done) didone)
      (done = t)
      (didone = nil)
      (for sp in (fnspecs (spec inst))             ; for each prop
           when (not (arg inst (name sp)))      ; not already done
           (done = nil)
           (if (cipropready inst (name sp) nil)
               (progn (cidoprop inst (name sp))
                      (if (arg inst (name sp)) (didone = t)) )) )
      (if (not didone)
          (for sp in (fnspecs (spec inst))             ; for each prop
               when (not (arg inst (name sp)))      ; not already done
               (if (cipropready inst (name sp) t)
                   (progn (cidoprop inst (name sp) nil nil
                                    (assoc (name sp) vals))
                          (if (arg inst (name sp)) (didone = t))) ) ) ) )
    (cioutprops inst) ))

; 27 May 04; 28 May 04; 29 May 04; 02 Sep 04; 26 Oct 04; 16 Nov 04; 22 Nov 04
; 23 Nov 04; 03 Feb 05; 03 Nov 05; 14 Jul 06; 02 Jan 07; 08 Jan 07; 01 Feb 07
; 15 May 08; 23 May 08; 28 May 08; 29 May 08; 15 May 09; 20 May 09; 14 Oct 09
; 15 Feb 10; 16 Feb 10; 08 Oct 10; 13 Oct 10
; acquire a function to satisfy a prop for cidoprop
(gldefun cipropfn ((inst cinst) (fnspec csfnspec))   (result ciarg)
  (let (sourcetps inps goaltp fn code typename tp outsig args nargs
                  moreargs viewtps)
    (outsig = (output (signature fnspec)))
    (inps = (inputs (signature fnspec)))
    (sourcetps = (for formal in inps
                      collect (ciactualtype inst formal)))
    (viewtps = (for formal in inps
                    collect (viewtype inst formal)))
    (goaltp = (citype inst outsig))
    (args = (mapcar #'(lambda (nm tp) (list nm tp))
                    '(self arg1 arg2 arg3 arg4 arg5) sourcetps))
    (case (glvmenu "How to specify fn for ~A" (list (name fnspec))
                   '(fn-name code vip dag record) nil)
      (fn-name (fn = (ttyinp "Specify function for ~A: "
                             (list (name fnspec)) 'symbol))
               (nargs = (glarity fn))
               (when (and (numberp nargs) (> nargs (length args)))
                 (args = (append args (cigetargs inst (- nargs (length args)))))
                 (code = (list 'glambda (mapcar #'car args)
                               (cons fn (mapcar #'car args)))) ) )
      (code (code = (ttyinp "Specify code for ~A: " (list (name fnspec)) 't))
            (fn = (cinewfn 'fn nil))
            (eval (list 'gldefun fn args code))  ; extra args treated as global
            (setf (glinline fn) t)         ; typically will be small
            (code = (list 'glambda (mapcar #'car args)
                          (cons fn (mapcar #'ciunwraparg args viewtps)))) )
      (vip (fn = (cinewfn 'fn t))
           (moreargs = (cigetargs inst 10))    ; need better max arg count
           (vip (append args moreargs) (list 'out goaltp) fn)
           (if (or (cdr args) (cdr (cadr (glgetd fn))))
               (code = (list 'glambda (mapcar #'car args)
                             (cons fn (mapcar #'car (append args moreargs)))))))
      (dag (moreargs = (cigetargs inst 10))    ; need better max arg count
           (fn = (dag (append args moreargs)))
           (if (or (cdr args) (cdr (cadr (glgetd fn))))
               (code = (list 'glambda (mapcar #'car args)
                             (cons fn (mapcar #'car (append args moreargs)))))))
      (record
           (goaltp = (ttyinp "Specify type of record: " nil nil))
           (if (consp goaltp)
               (if (eq *gp-language* 'lisp)
                   (progn (setq typename (glmkatom 'type))
                          (eval (list 'glispobjects (list typename goaltp)))
                          (setq goaltp typename))
                   (if (symbolp (car goaltp))
                       (progn (eval (list 'glispobjects
                                          (list (car goaltp)
                                                (cons 'crecord goaltp))))
                              (setq goaltp (car goaltp))))))
           (fn = (cinewfn 'fn t))
           (vip args (list 'out goaltp) fn) ) )
    (a ciarg with name = (name fnspec)  kind = 'fn
               choice = fn
               code   = (or code fn)
               type   = (if fn
                            (or (glfnresulttype fn)
                                (if (glgetd fn)
                                    (progn (glcc fn) (glfnresulttype fn)))))
               cltype = (viewtype inst outsig)
               source = 'user) ))

; 11 Oct 10; 13 Oct 10
; Unwrap an argument to use its actual type rather than wrapper type.
; (x integer) NIL would just return x.
; (x PART) ITEMTYPE48 whose structure is (Z139 part) returns (Z139 x)
(defun ciunwraparg (codetype viewtp)
  (let (str)
    (if (and viewtp
             (symbolp viewtp)
             (consp (setq str (car (glstructure viewtp))))
             (glgensymp (car str)) )
        (list (car str) (car codetype))
        (car codetype) ) ))

; 04 Mar 10; 11 Mar 10; 15 Mar 10
; acquire a program to be executed on items of an iterate-do
(gldefun ciprogram ((inst cinst)  (fnspec csfnspec))   (result ciarg)
  (let (fnname fnargs inps sourcetps args moreargs allargs fn
        fndef    code typename tp outsig nargs)

    (fnname = (ttyinp "Specify function for ~A: "
                  (list (name fnspec)) 'symbol))
    (fnargs = (glargs fnname))
    (inps = (inputs (signature fnspec)))
    (sourcetps = (for formal in inps
                      collect (ciactualtype inst formal)))
    (args = (mapcar #'(lambda (nm tp) (list nm tp))
                    '(self arg1 arg2 arg3 arg4 arg5) sourcetps))
    (case (glvmenu "How to specify args for ~A" (list (name fnspec))
                   '(code vip dag) nil)
      (code (code = (ttyinp "Specify code for ~A: " (list (name fnspec)) 't))
            (fn = (cinewfn 'fn nil))
            (eval (list 'gldefun fn args code))  ; extra args treated as global
            (code = (list 'glambda (mapcar #'car args)
                          (cons fn (mapcar #'car args)))) )
      (vip (fn = (cinewfn 'fn t))
           (moreargs = (cigetargs inst 10))      ; need better max arg count
           (allargs = (append args moreargs))
           (vip allargs fnargs fn)
           (fndef = (glgetd fn))
           (if (or (cdr args) (cdr (cadr (glgetd fn))))
               (code = (list 'glambda (mapcar #'car args)
                             (list 'apply fnname
                                   (cons fn (mapcar #'car allargs)))))
               (code = (list 'glambda (mapcar #'car args)
                             (list fnname
                                   (cons fn (mapcar #'car allargs)))))))
      (dag (moreargs = (cigetargs inst 10))    ; need better max arg count
           (moreargs = (cigetargs inst 10))    ; need better max arg count
           (allargs = (append args moreargs))
           (fn = (dag allargs))
           (if (or (cdr args) (cdr (cadr (glgetd fn))))
               (code = (list 'glambda (mapcar #'car args)
                             (cons fn (mapcar #'car (append args moreargs)))))))
      )
    (a ciarg with name = (name fnspec)  kind = 'fn
               choice = fnname
               code   = (or code fnname)
               type   = (if fnname
                            (or (glfnresulttype fnname)
                                (if (glgetd fnname)
                                    (progn (glcc fnname) (glfnresulttype fnname)))))
               cltype = (viewtype inst outsig)
               source = 'user) ))

; 07 May 07; 05 May 09; 27 May 09; 07 Aug 09; 17 Mar 11; 16 Nov 11
; Make function code for a prop/msg
; choice could also be ((name arg#) type) for args beyond first
(gldefun cifncode ((inst cinst) (fnspec csfnspec) (choice glnametype))
  (let (args argscode thisarg rg tp)
    (if (cdr (inputs fnspec))
        (if (symbolp (car choice))
            (progn
              (for arg in (inputs fnspec)
                   (push (list (glgensym 'arg) (cifnargtype inst arg)) args)
                   (push (if (and (viewtype inst arg)
                                  (consp (car (glstr (cadar args)))) )
                             (list (caar (glstr (cadar args)))
                                   (caar args))
                           (caar args))
                         argscode) )
              (list 'glambda (reverse args)
                    (cons (first choice) (reverse argscode))) )
            (progn
              (args = (for arg in (inputs fnspec)
                           collect (list (glgensym 'arg) (cifnargtype inst arg))))
              (thisarg = (nth (cadar choice) args))
              (rg = (nth (cadar choice) (inputs fnspec)))
              (push (if (viewtype inst rg)
                        (list (caar (glstr (cifnargtype inst rg)))
                              (car thisarg))
                        (car thisarg))
                    argscode)
              (list 'glambda args (cons (caar choice) argscode))))
;       (progn (format t "~A  ~A  ~A~%" (first (inputs fnspec))
;               (viewtype inst (first (inputs fnspec)))
;               (glstr (viewtype inst (first (inputs fnspec)))) )   ... )
        (progn (setq tp (or (viewtype inst (first (inputs fnspec)))
                            (actual inst (first (inputs fnspec)))) )
               (list (list (car choice)
                           (if (consp (car (glstr tp)))
                               (caar (glstr tp))
                               (car (glstr tp)))) ) ) )
    ))

; 05 May 09
(gldefun cifnargtype ((inst cinst) (arg symbol))
  (if (glbasictypep arg)
      arg
      (or (viewtype inst arg)
          (actual inst arg))) )

; 15 May 08; 29 May 08; 15 Feb 10
; Get up to n additional args to be used in a function / code
(gldefun cigetargs ((inst cinst) (n integer))    (result (listof glnametype))
  (let (args acts name done sel)
    (acts = (actuals (group inst)))
    (names = (for act in acts collect (name act)))
    (while (and names (not done) (> n 0))
      (sel = (menu (cons "Done" names)))
      (if (and (stringp sel) (string= sel "Done"))
          (setq done t)
          (when sel
            (n -= 1)
            (names = (remove sel names))
            (args = (append args (list (assoc sel acts)))) ) ) )
    args))

; 27 May 04
; get the type of a prop
(gldefun citype ((inst cinst) (tp anything))
  (or (actual inst tp)
      (and (gltypep tp) tp)))

; 09 Sep 04
; Test whether two types are equal; ignores names of crecords.
(defun citypeequal (x y)
  (or (equal x y)
      (and (consp x)
           (consp y)
           (eq (car x) (car y))
           (case (car x)
             (crecord (every #'citypeequal (cddr x) (cddr y)))
             (t (every #'citypeequal (cdr x) (cdr y)))) ) ) )

; 01 Oct 04
; extract a type from a list (name type)
(defun cixtrtype (type)
  (if (and (consp type)
           (symbolp (car type))
           (not (member (car type) *gltypenames*))
           (symbolp (cadr type)) )
      (cadr type)
      type))

; 14 Jul 06; 01 Oct 10
; Get actual types given type name(s)
; Arg may be a name symbol or list of name symbols
(gldefun ciactualtype ((inst cinst) name)
  (if (consp name)
      (mapcar #'(lambda (x) (ciactualtype inst x)) name)
      (or (actual (type inst name))
          (and (gltypep name) name) ) ) )

; 27 May 04; 10 Feb 05
; Redo a prop that may have been defaulted previously
(gldefun ciredoprop ((inst cinst) (name symbol))
  (let ()
    (ciundef inst (list name))    ; make the old value undefined
    (cidoprop inst name nil t)
    (cidoprops inst) ))

; 27 May 03; 28 May 03; 02 Jun 03; 04 Jun 03; 13 Aug 03; 11 Sep 03; 02 Aug 04
; 05 Aug 09; 07 Aug 09; 04 Mar 10; 02 Jun 10; 16 Jul 10; 13 Sep 10; 14 Sep 10
; 09 Mar 11
; Select a component to fill an interface of existing component
; inst = the instance, intname = name of the interface
; returns the new instance
; ch = previous choice: (name values)
(gldefun ciselect ((inst cinst) (intname symbol)
         &optional (ch (cons (chname symbol) (vals (listof anything))) ) )
  (let (int choice newinst args target destname)
    (if (and (int = (interfaced (spec inst) intname 'uses))
             (choice = (vacchoose (cioffers (kind int)) (name int)
                                  (chname ch)) ) )
        (progn (args = (ciselargs inst int))
               (newinst = (instcspec (group inst) choice args (vals ch)))
               (target = (findconn (spec (group inst))
                                   (role (group inst) inst) intname))
               (addinst (group inst) (menu-name target) newinst)
               (cidoprops newinst)
               (destname = (name (interfacek (spec newinst) (kind int))))
               (addconn (group inst)
                        (a cpconn from (a menu-port port = intname
                                                    menu-name = inst)
                          to   (a menu-port  port = destname
                                             menu-name = newinst)))
               (ciaddtypes inst (ciselargsb newinst destname) intname)
               newinst)
        (if (eq (kind int) 'program)
            (ciselectprogram inst intname)) ) ))

; mouse outside menu causes returning nil for choice ... should just ignore
;            (if int (error "ciselect ~A ~A~%" inst intname)) ) ) ))

; 27 May 03; 29 May 03
; Determine what args of a new instance are determined by what it
; is connected to.  Result is a list of ((name type) ...)
(gldefun ciselargs ((inst cinst) (int cintfc))
  (let (args typ cityp)
    (for intitem in (items int)
         when (and ((direction intitem) == 'out)
                   (cityp = (type inst (typename intitem)))
                   (typ = (or (viewtype cityp) (actual cityp))))
         collect (a glnametype name (name intitem) type typ) ) ))

; 28 May 03
; Determine what args of an instance are output by named interface
(gldefun ciselargsb ((inst cinst) (intname symbol))
  (ciselargs inst (interface (spec inst) intname)))

; 18 Mar 10
; *********** incomplete
; Select a program and make a component for it to fill an interface
(gldefun ciselectprogram ((inst cinst) (intname symbol))
  (let (int fnname fnargs args      choice newinst target destname)
    (int = (interfaced (spec inst) intname 'uses))
    (fnname = (ttyinp "Specify function for ~A: " (list intname) 'symbol))

    (args = (ciselargs inst int))

               (newinst = (instcspec (group inst) choice args (args int)))


    (fnname = (ttyinp "Specify function for ~A: "
                  (list (name fnspec)) 'symbol))
    (fnargs = (glargs fnname))

))

; 14 Mar 02; 29 May 04
; Make a view type whose concrete type is concr
(gldefun glmakeviewtype (name concr)   (result gltype)
  (let (viewtype)
    (viewtype = (glmkatom name))
    (setf (glstructure viewtype)
          (list (if (glpointerp concr)
                    concr
                    (list (gentemp "Z") concr))))
    viewtype))

; 12 Aug 04
; make a new type with substitutions
(defun cimaketype (type subs)
  (if (and (consp type) (eq (car type) 'crecord))
      (cons 'crecord (cons (glmkatom (cadr type))
                           (sublis subs (cddr type))))
      (sublis subs type)))

; 10 Feb 05
; Find what type names are used in making a new type
(defun citypesused (type subs)
  (mapcan #'(lambda (pair) (if (gloccurs (car pair) type) (list (car pair))))
          subs) )

; 17 Dec 10; 22 Mar 11
; collect types needed to instantiate a typecon pattern
(gldefun citypesusedb ((inst cinst) (tppat anything))
  (remove-duplicates
    (for tp in (types (spec inst))
         when (gloccurs (name tp)
                        (if (and (consp tppat)
                                 (eq (car tppat) 'crecord))
                            (cddr tppat)
                            tppat))
         collect (name tp) ) ) )

; 16 Nov 04; 18 Nov 04; 22 Nov 04
(gldefun cinewfn (fnname flag)    (result symbol)
  (let (fn)
    (fn = (glmkatom fnname))
    (if flag (push fn *glspecfnscompiled*))
    fn))

; 27 May 03; 02 Sep 04; 18 Mar 10; 13 Sep 10; 28 Oct 11
; Choose one of parts for role.  Previous choice (if any) is ch.
; cf. glvchoose
(defun vacchoose (parts role ch)
  (let (newparts res)
    (setq newparts (subset #'(lambda (x)
                               (not (or (member x *vac-lang* :key #'cadr)
                                        (and (eq x 'action)
                                             (eq role 'program)))))
                           parts))
    (setq res
          (if (and ch (member ch newparts))
              ch
              (if (cdr newparts)
                  (glvmenu "Specify choice for ~A" (list role) newparts ch)
                  (car newparts)) ) )
    (if (eq *gp-language* 'lisp)
        res
        (or (cadr (assoc res *vac-lang*)) res) ) ))

; 13 Mar 02
(defun glpointerto (type)
  (or (glgetpointer type) (list '^ type)) )

; 12 Aug 04
(defun glgensymp (sym)
  (let (name)
    (and (symbolp sym)
         (setq name (symbol-name sym))
         (alpha-char-p (char name 0))
         (digit-char-p (char name (1- (length name)))))))

; 12 Aug 04
; Make a name-type pair, using type as name if it is a gensym  ; ? good idea???
(gldefun cinametype ((type gltype))
  (a glnametype with name = (if (glgensymp type) type (glmkatom 'name))
                     type = type))

; 26 Nov 03; 14 Jul 06; 24 Apr 07; 09 May 07; 31 Dec 08; 27 May 09; 28 Oct 11
; get all names of fields or properties that match goaltp given a set of types
; returns list of (propname type) or ((propname i) type) for prop of ith arg
(defun ciallnames (types goaltp &optional kind)
  (let (type sigs res i)
    (setq type (car types))
    (setq sigs
          (if (or (cdr types) (eq kind 'msg))
              (glpropnamesigs type 'msg)
              (if (member type '(integer real number))
                  (if (eq goaltp 'boolean)
                      (union (glpropnamesigs type 'adj)
                             (glpropnamesigs type 'isa) :test #'equal)
                      (append (if (citypematch type goaltp)
                                  (list (list 'identity types type)))
                              (glpropnamesigs type 'prop)
                              (gldatanamesigs type)) )
                  (append (if (eq goaltp 'boolean)
                              (append (glpropnamesigs type 'adj)
                                      (glpropnamesigs type 'isa)))
                          (if (citypematch type goaltp)
                              (list (list 'identity types type)))
                          (glpropnamesigs type 'prop)
                          (gldatanamesigs type)) ) ) )            
    (setq res (mapcan #'(lambda (sig)
                          (and (= (length types) (length (second sig)))
                               (every #'(lambda (x y)
                                          (citypematch x (cadr y)))
                                      (cdr types) (cdadr sig))
                               (cifilter (third sig) goaltp)
                               (list (list (first sig) (third sig)))))
                      sigs))
    (setq i 0)
    (dolist (tp (cdr types))  ; add individual props of remaining args
      (incf i)
      (if (citypematch tp goaltp)
          (setq res (append res (list (list (list 'identity i) tp)))))
      (setq res (append res
                       (append (cifiltersigs (glpropnamesigs tp 'prop) goaltp i)
                               (cifiltersigs (gldatanamesigs tp) goaltp i))))
      (if (eq goaltp 'boolean)
          (setq res
                (append res
                        (append (cifiltersigs (glpropnamesigs tp 'adj) goaltp i)
                                (cifiltersigs (glpropnamesigs tp 'adj) goaltp i))))) )
    res))

; 27 May 09
(defun cifiltersigs (namesigs goaltp i)
  (mapcan #'(lambda (sig)
              (if (cifilter (third sig) goaltp)
                  (list (list (list (first sig) i) (third sig)))))
          namesigs))

; 03 Oct 03; 09 Oct 03; 17 Aug 04; 24 Feb 05; 24 Apr 07; 03 May 07
; filter a name/type on whether it could match goaltp
(gldefun cifilter ((tp gltype) (goaltp gltype))
  (let ()
    (or (and (glbasictypep goaltp)
             (or (glrecordp tp)
                 (case goaltp of
                   ((number integer real)
                     (not (or (member tp '(boolean anything))
                              (and (consp tp)
                                   (member (car tp) '(listof ^))))) )
                   (anything t))
                 (gltypematch tp goaltp)))
        (and (symbolp tp) (symbolp goaltp) (gldescendantp tp goaltp))
        (and (consp goaltp)
             (case (car goaltp)
               (^ (glpointerp tp))
               (or (some #'(lambda (x) (cifilter tp x)) (cdr goaltp)))
               ((listof arrayof sequence) (citypematch tp goaltp))
               (t t)))) ))

; 26 Nov 03
(defun cidatanames (type goaltp)
  (let ((names (gldatanames type)))
    (if (citypematch type goaltp)
        (cons (list 'identity type) names)
        names) ))

; 17 Apr 03; 09 Jan 07
; Test whether an instance is completely specified
(gldefun cidone ((inst cinst))
  (and (every #'(glambda (tp) (actual inst (name tp)))
              (types (spec inst)))
       (every #'(glambda (pr) (code (arg inst (name pr))))
              (fnspecs (spec inst))) ) )

; 21 May 09
(gldefun cifnspecnames ((inst cinst)) (result (listof symbol))
  (for fns in (fnspecs (spec inst)) collect (name fns)) )

; 21 May 09
(gldefun citypenames ((inst cinst)) (result (listof symbol))
  (for ty in (types (spec inst)) collect (name ty)) )

; 24 Sep 04
; Test whether type data structure needs to be created
; prior to use at runtime in itaccfn
(defun cicreatep (type)
  (and (not (glbasictypep (glxtrtypeb type)))
       (not (glpropdef (glxtrtypec (glxtrtype type)) 'msg 'init)) ) )

(setf (glevalwhenconst 'cicreatep) t)

; 28 Sep 04
; get the field name from a (gensym type) type
(defun ciacctype (type)
  (if (and (consp type)
           (not (member (car type) *gltypenames*)))
      (car type)
      'identity))

(setf (glevalwhenconst 'ciacctype) t)

; 31 Aug 04; 01 Nov 10
(gldefun cgoutprops ((group cigroup))
  (let ()
    (for ins in (insts group) do (cioutprops (params ins))) ))

; 22 Apr 03; 13 May 03; 16 May 03; 23 May 03; 30 May 03; 16 Aug 04; 03 Sep 04
; 10 Jan 07; 20 Mar 07
; Put props on types of an instance
(gldefun cioutprops ((inst cinst))
  (let (tp tmp)
    (for arg in (args inst)
      (if (and (eq (kind arg) 'fn)
               (tp = (viewtype inst (input1 (fnspec (spec inst) (name arg))))))
          (cioutprop inst tp (name arg)) )
      (if (and (eq (kind arg) 'type)
               (tmp = (assoc (name arg) (vwspecs (spec inst))))
               (tp = (viewtype inst (name arg))) )
          (setf (glviewspecs tp) (list (cdr tmp))) ) ) ))

; 30 May 03; 23 Sep 03; 29 May 04; 08 Jan 07; 07 May 07; 08 May 07; 28 May 08
; Put a single prop on type of an instance
(gldefun cioutprop ((inst cinst) (tp gltype) (prname symbol))
  (let (pr)
    (pr = (arg inst prname))
    (if (and tp pr)
        (gladdprop tp (if (or (cdr (inputs (fnspec (spec inst) prname)))
                              (and (consp (code pr))
                                   (eq (car (code pr)) 'glambda)
                                   (cdadr (code pr)) ))   ; multiple args
                          'msg
                          'prop)
                   (if (cltype pr)
                       (a glpropentry with name = prname
                          code = (code pr) result = (cltype pr))
                       (a glpropentry with name = prname
                             code = (code pr))))) ))

; 15 May 03; 09 Dec 03; 10 Aug 03; 17 Aug 04; 11 Oct 05; 09 Jan 07; 22 Jan 07
; 03 May 07; 09 May 07; 16 May 07; 27 May 09; 31 Jul 09; 06 Aug 09
; type matching: see if type matches goal
(defun citypematch (type goal)
  (or (and type (not (and (consp goal) (eq (car goal) 'hasop)))
           (gltypematch type goal))
      (and (member type '(integer real number))
           (member goal '(integer real number)))
      (and (eq goal 'gltype) (not (member type *glbasictypes*)) (gltypep type))
      (and (consp type)
           (symbolp (car type))
           (not (member (car type) *gltypenames*))
           (not (member (car type) '(sequence)))
           (consp (cdr type))
           (null (cddr type))
           (citypematch (cadr type) goal))
      (and type (consp goal)
           (case (car goal)
             (sequence
               (if (and (consp type)
                        (member (car type) '(listof arrayof tuple)))
                   (citypematch (cadr type) (cadr goal))
                   (if (and (consp type)
                            (eq (car type) '^))
                       (some #'(lambda (x)
                                 (and (symbolp (cadr x))
                                      (citypematch (cadr x) goal)))
                             (glget (cadr type) 'views))
                       (if (and (symbolp type)
                                (not (member type *glbasictypes*)))
                           (if (and (consp (car (glstr type)))
                                    (member (caar (glstr type))
                                            '(listof arrayof tuple)))
                               (citypematch (car (glstr type)) goal)
                               (and (not (member (glxtrtypeb type)
                                                 *glbasictypes*))
                                    (glfindmacro type 'iterator)))
                           (case type
                             (string (citypematch 'character (cadr goal)))
                             (t nil))) ) ) )
             (listof (and (consp type)
                          (member (car type) '(listof tuple))
                          (citypematch (cadr type) (cadr goal))) )
             (hasop (every #'(lambda (op) (glopdef type op))
                           (listify (cadr goal))))
             (or (some #'(lambda (x) (citypematch type x)) (cdr goal)))
             (t nil)) )
      (and type (symbolp type)
           (not (member type *glbasictypes*))
           (citypematch (car (glstr type)) goal)) ) )

; 02 Jun 03; 03 Jun 03; 04 Jun 03; 10 Aug 03; 10 Feb 05; 06 May 08; 07 May 08
; 05 Aug 09; 02 Jun 10; 20 Jul 10; 13 Sep 10; 16 Sep 10; 01 Nov 10; 02 Nov 10
; 22 Nov 10
; instantiate a new cigroup
; inps = inputs, must match arg order of spec formals
(gldefun instcigroup ((gspec cgspec) (inps (listof glnametype))
                      &optional (vals (listof anything)))
  (let ((group cigroup) inp ivar c v)
    (group = (glmkatom 'cigroup))
    ((spec group) = gspec)
    ((actuals group) = inps)
    ((cpset group) = (a cpset  actfns = '((software citypemsgfn))))
    (for comp in (comps gspec) when (spec comp)
      (addinst group (name comp)
               (instcspec group (spec comp) nil)) )
    (for formal in (formals gspec)
      (if (setq inp (pop inps))
          (progn (push (cons (name inp) (port (from formal)))
                       (bindings group))
                 (ciaddtype (inst group (menu-name (to formal)))
                            (port (to formal)) (type inp) nil nil))))
    (for conn in (conns gspec)
      when (and (inst group (menu-name (from conn)))
                (inst group (menu-name (to conn))))
      (addconn group
        (a cpconn from (a menu-port port = (port (from conn))
                           menu-name  = (inst group (menu-name (from conn))))
                  to   (a menu-port port = (port (to conn))
                           menu-name = (inst group (menu-name (to conn)))))) )
    (ivar = (insts group))
    (for ins in ivar
         (v = nil)
         (if vals
             (for c in (comps gspec)
                  (if (assoc (spec c) vals)
                      (v = (cdr (assoc (spec c) vals))) ) ) )
         (if v (instcspecvals (params ins) v))
         (cidoprops (params ins)) )
    group))

; 02 June 10
; Make a cigroup from a synopsis, e.g.
;    (ITER-ACC ((ARG205 ASSEMBLY))
;        (ITERATE-ACCUMULATE (SEQ PARTS)
;          (ACC (SUM     (SUMMAND SIZE)))
;          (ACC (AVERAGE (SUMMAND WEIGHT)))))
; can then use (cgspecialize 'CIGROUP5 'test5) to make the function
; (cgspecialize (cgmakefromsynopsis (synopsis (gpg))) 'myfn)
(gldefun cgmakefromsynopsis ((syn anything))
  (let (grp)
    (grp = (instcigroup (first syn) (second syn) (cddr syn)) )
    grp
))

; 25 Jan 11
(defun synopsis (name)
  (and (symbolp name)
       (or (get name 'synopsis)
           (and (cigroup name) (synopsis (cigroup name) ) ) ) ) )

; 03 Jun 03; 31 Aug 04; 21 Sep 04; 07 May 08; 14 May 08; 15 May 08; 30 Mar 10
; 01 Dec 10; 14 Dec 10
; Specialize the functions for a group
(gldefun cgspecialize ((group cigroup) &optional (fnname symbol))
  (let (in argl res binding args arg compargs comparg)
    (cgoutprops group)      ; do it again just to make sure
    (glmakeconstant '*vac-language* *gp-language*)   ; define output language
    (for comp in (comps (spec group)) when (fn comp)
      (in = (inst group (name comp)))
      (argl = nil)
      (if (eq comp (first (comps (spec group))))
          (progn
            (args = (actuals group))
            (compargs = (glargs (fn comp)))
            (while (or args compargs)
              (arg = (pop args))
              (comparg = (pop compargs))
              (argl _+ (if arg
                           (if (setq binding (assoc (name arg)
                                                    (bindings group)))
                               (a glnametype
                                  name (name arg)
                                  type (viewtype
                                        (type in (type (assoc (cdr binding)
                                                              (args comp))))))
                               arg)
                           (a glnametype name (name comparg)
                                         type (or (viewtype
                                                    (type in (type comparg)))
                                                  (type comparg)))) ) ) )

          (for arg in (args comp)
               (argl _+ (a glnametype name (name arg)
                           type (viewtype (type in (type arg)))))) )
      (push (glspecializefn (fn comp) argl
                            (or fnname (glmkatom 'specfn)) t)
            res) )
    (res = (nreverse res))
    (setf (cigroup (first res)) group)
    ((allfns group) = res)
    ((result group) = (glxtrtypeb (glxtrtyper (glfnresulttype (first res)))))
    res ))

; 04 Jun 03; 11 Sep 03; 01 Nov 10
; Look for boxes with interfaces to undefined boxes and select those
(gldefun cigsels ((group cigroup))
  (let ()
    (for i in (insts group)
      (for int in (interfaces (spec (params i)))
        when (and ((direction int) == 'uses)
                  (null (findconns group inst (name int))))
        (ciselect (params i) (name int)) ) ) ))

; 20 May 03; 03 Nov 10
; Find connections of a given port of a named box
(gldefun cigroup-findconns ((group cigroup) (box cinst) (port symbol))
  (result (listof menu-port))
  (let (res)
    (for conn in (conns group) do
      (if (and (box == (menu-name (to conn)))
               (port == (port (to conn))))
          (res +_ (from conn)))
      (if (and (box == (menu-name (from conn)))
               (port == (port (from conn))))
          (res +_ (to conn))) )
    (nreverse res)))

; 20 May 03
; Find connection of a given port of a named box
(gldefun cgspec-findconn ((gs cgspec) (box cinst) (port symbol))
  (result menu-port)
  (let (res)
    (for conn in (conns gs) do
      (if (and (box == (menu-name (to conn)))
               (port == (port (to conn))))
          (res = (from conn)))
      (if (and (box == (menu-name (from conn)))
               (port == (port (from conn))))
          (res = (to conn))) )
    res))

; 23 Sep 03; 12 Aug 04; 30 Jan 07
(gldefun citypesubs ((inst cinst))
  (let (act)
    (for tp in (args inst)
         when (and (eq (kind tp) 'type)
                   (act = (actual tp)))
         collect (cons (name tp)
                       (if (and (consp act)
                                (eq (car act) (cadr act)))
                           (car act)
                           act)))))

; 06 May 03; 02 Sep 04; 03 Nov 05; 18 Mar 10
; Simple function for typein value
; (ttyinp "Specify value for ~A: " '(init) 'integer)
(defun ttyinp (prompt-string prompt-parms type)
  (let (resp str)
    (setq str (apply #'format (cons nil (cons prompt-string prompt-parms))))
    (setq resp (if (and *gp-group* (cadadr (sixth *gp-group*))) ; window exists
                   (gp-get-input *gp-group* str)
                   (progn (format t str) (read))))
    (if (eq type 'integer)
        (truncate resp)
        (if type
            (coerce resp type)
            resp)) ))

; 05 Jan 07
; Output a message string
(gldefun cioutmsg ((str string))
   (if (and (boundp '*gp-group*) *gp-group*)
       (gp-msg (window *gp-group*) str)
       (format t str)))

; 07 May 03; 23 Sep 03; 25 Sep 03
; Test whether a type is concrete, i.e. fully specified
; alist = alist of type names and types
; prev  = list of previously considered types
(defun glconcrete? (str &optional alist prev)
  (or (and str (symbolp str)
           (not (eq str 'anything))   ; ???
           (or (member str *glbasictypes*)
               (member str prev)
               (glconcrete? (cdr (assoc str alist)) alist prev)
               (glconcrete? (car (glstr str)) alist (cons str prev)) ))
      (and (consp str)
           (symbolp (car str))
           (case (car str)
            ((cons list listof arrayof)
              (and (cdr str)
                   (every #'(lambda (x) (glconcrete? x alist prev))
                          (cdr str))))
            ((record crecord alist proplist tuple object atomobject listobject)
              (and (cdr str)
                   (every #'(lambda (x)
                              (and (consp x)
                                   (symbolp (car x))
                                   (glconcrete? (cadr x) alist prev)))
                          (if (eq (car str) 'crecord) (cddr str) (cdr str)))))
            (units (glunittypep str))
            (t (and (cdr str)
                    (null (cddr str))
                    (glconcrete? (cadr str) alist prev))) ) ) ) )

; 26 Oct 04; 01 Nov 10; 03 Nov 10; 10 Feb 11
; Test whether all 'uses' slots are filled
(gldefun cgalldef ((group cigroup))
  (let (unfilled (inst cinst))
    (for instz in (insts group)
      (inst = (params instz))
      (for int in (interfaces (spec inst))
        when (and ((direction int) == 'uses)
                ;  (not (gp-arity-multi (spec inst) (name int)))
                  (null (findconns group (params instz) (name int))))
        (push (list (name int) (params instz)) unfilled) ) )
    unfilled))

; 10 Feb 05; 30 Jan 07; 08 Nov 10
; undo inferences from things that have become undefined
(gldefun ciundef ((inst cinst) (names (listof symbol)))
  (let (rems rempr nms)
    (for tp in (args inst) when (intersection (depend tp) names)
         (if (eq (kind tp) 'type)
             (cipropatype inst tp t))
         (push (name tp) nms)
         (push tp rems) )
    ((args inst) = (set-difference (args inst) rems))
    (if nms (ciundef inst nms))    ; now make all deleted things undefined
    ))

; 24 Feb 05; 01 Mar 05; 07 Nov 06
; make a copy of arbitrary data structure
(gldefun generic-copy ((source anything))
  (if (or (glbasictypexp (typeof source))
          (glcopypointerp (typeof source)))
      source
    (let ((cpy (a (typeof source))))
      (for field in (gldatanamesonly (typeof source))
           ((funcall field cpy) = (generic-copy (funcall field source))))
      cpy) ) )

(setf (get 'generic-copy 'glinline) t)

; 02 Mar 05
; test equality of arbitrary data structure
(gldefun generic-equal ((source anything) (dest anything))
  (if (or (glbasictypep (typeof source))
          (glcopypointerp (typeof source)))
      (source == dest)
      (for field in (gldatanamesonly (typeof source))
           reduce 'and
           ((funcall field source) == (funcall field dest)) ) ) )

(setf (get 'generic-equal 'glinline) t)

; 01 Mar 05
; Test whether a type is a pointer for purposes of copying a record
(defun glcopypointerp (str)
  (or (and str
           (symbolp str)
           (not (glbasictypep str))
           (glcopypointerp (car (glstr str))))
      (and (consp str)
           (or (member (car str) '(^ arrayof listof))
               (and (not (member (car str) *gltypenames*))
                    (not (member (car str) *gluserstrnames*))
                    (glcopypointerp (cadr str)))))))

(setf (get 'glcopypointerp 'glevalwhenconst) t)

; 24 Apr 07; 10 May 07; 09 Jan 08
; get property/message names and signatures
; proptytpe = prop, adj, isa, msg
; result is ( (name ((arg type) ...) resulttype) ...)
(defun glpropnamesigs (type proptype)
  (let (names res propdef fndef args newargs tmp restype)
    (setq names (glpropnames type proptype))
    (dolist (name names)
      (setq propdef (glpropdef type proptype name))
      (setq fndef
            (if (symbolp (cadr propdef))
                (glgetd (cadr propdef))
                (if (and (consp (cadr propdef))
                         (member (caadr propdef) '(lambda glambda)))
                    (cadr propdef)
                    (cons 'glambda
                          (cons (list (list 'self type))
                                (cadr propdef))))))
      (setq args (glarglist (cadr fndef)))
      (if (null (third (car args)))
          (setq args (cons (list (caar args) nil type) (cdr args))))
      (setq newargs (mapcar #'(lambda (lst)
                                (list (car lst)
                                      (if (and (consp (third lst))
                                               (eq (car (third lst)) 'typeof)
                                               (symbolp (cadr (third lst)))
                                               (setq tmp
                                                     (assoc (cadr (third lst))
                                                            args)))
                                          (third tmp)
                                          (third lst))))
                            args))
      (setq restype (or (getf (cddr propdef) 'result)
                        (some #'(lambda (x) (and (consp x)
                                                 (eq (car x) 'result)
                                                 (consp (cdr x))
                                                 (cadr x)))
                              (cdr fndef))
                        (gevproptype type proptype name)))
      (if (and (consp restype)
               (eq (car restype) 'typeof)
               (symbolp (cadr restype))
               (setq tmp (assoc (cadr restype) args)))
          (setq restype (third tmp)))
      (push (list name newargs restype) res) )
    (nreverse res) ))

; 09 May 07
; Data names in  signature form
(defun gldatanamesigs (type)
  (mapcar #'(lambda (x) (list (car x) (list (list 'self type)) (cadr x)))
          (gldatanames type)))

; 04 May 07; 08 May 07; 01 Nov 10
; Print all results of the group for debugging
(gldefun ciprint ()
  (let ()
    (pprint (cons *cigroup* (symbol-plist *cigroup*)))
    (for x in (insts *cigroup*) do
      (print (list (params x) 'group (group (params x)) 'spec (spec (params x))))
      (terpri)
      (for arg in (args (params x))
        (format t "  ~A~%" arg)
        (case (kind arg)
          (type (if (viewtype arg)
                    (format t "    ~A~%"
                      (cons (viewtype arg) (glstr (viewtype arg))))))) ) ) ))

; 01 Nov 07
(gldefun ciinterfacenames ((spec cspec) (dir symbol))
  (for int in (items (that (interfaces spec) with direction == 'offers))
       when (eq (direction int) dir)
       collect (typename int)) )

; 28 Jan 10 ; 01 Feb 10; 10 Sep 10; 01 Nov 10
; Make a synopsis of a cigroup
(gldefun cigroup-synopsis (&optional (self cigroup))
  (let ()
    (or self (setq self (cigroup *gp-group*)))
    (list (spec self)
          (actuals self)
          (cidescription self (params (first (insts self))) ) ) ))

; 28 Jan 10; 29 Jan 10; 01 Feb 10; 03 Nov 10
; Make a compact description of a cinst
(gldefun cidescription ((group cigroup) (inst cinst))
  (let (ch argsels attach)
    (argsels = (for arg in (args inst)
                 when (and (setq ch (choice arg))
                           (not (member (source arg) '(default inference))) )
                 collect (list (name arg) ch) ) )
    (attach = (for conn in (conns group)
                   when ((menu-name (from conn)) == inst)
                   collect (list (port (from conn))
                                 (cidescription group (menu-name (to conn)))) ))
    (cons (spec inst) (append argsels attach)) ))

; 25 Mar 10
; number of args to use for a program kind
(gldefun cinargs ((kind symbol))  (result integer)
  (or (cadr (assoc kind '((iter-acc 1) (heurs 1) (convh 1) (find 1)
                          (dijkstra 1) (plot 1))))
      1) )

; 14 Mar 05
; Compile vac.lsp into a plain Lisp file
(defun compile-vac ()
  (glcompfiles *directory*
               '("glisp/vector.lsp"          ; auxiliary files
                 "X/dwindow.lsp"
                 "glisp/menu-set.lsp"
                 "glisp/equations.lsp"
                 "glisp/windowio.lsp")
               '("glisp/vac.lsp")          ; translated files
               "glisp/vactrans.lsp"        ; output file
               "glisp/vac-header.lsp"      ; header file
               '(generic-copy generic-equal itaccfn itdofn ipplotfn ipplotfnb
                 findfn))   ; except
;  (cf vactrans)
  )

; test data and functions
(glispobjects

(myadder anything
  msg ((init   (glambda (self &optional arg)
                 ((accum self) = (initial-value self))) )
        ; was    ((accum self) = (initial-value (cast arg (initview self))))) )
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                   ((accum self) _+ (summand (cast item (dataview self)))))))
       (final  ((accum self)))
       (newempty ((a (typeof self)))) ) )

(mymulter anything
  msg ((init   ((accum self) = (initial-value self)))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                   ((accum self) = (* (accum self)
                                      (summand (cast item (dataview self))))))))
       (final  ((accum self)))
       (newempty ((a (typeof self)))) ) )

; 09 Mar 11
(myavger anything
  msg ((init   (glambda (self)
                 ((accum self) = (initial-value self))
                 ((count self) = (initial-count self)) ) )
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                  (progn ((accum self) _+ (summand (cast item (dataview self))))
                         ((count self) _+ 1) ))))
       (final  (glambda (self)
                 (if (> (count self) 0)
                     ((accum self) = (/ (accum self) (count self))))
                 self) )
       (newempty ((a (typeof self)))) ) )

; 09 Mar 11; 15 Mar 11
(mycger anything
  msg ((init   (glambda (self)
                 ((accum self) = (initial-value self))
                 ((count self) = 0.0) ) )
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                  (progn ((accum self) _+
                            (if (= (weight (cast item (dataview self))) 1.0)
                                (summand (cast item (dataview self)))
                                (* (summand (cast item (dataview self)))
                                   (weight (cast item (dataview self)))) ) )
                            ((count self) _+
                             (weight (cast item (dataview self))))))))
       (final  (glambda (self)
                 (if (> (count self) 0.0)
                     ((accum self) = (* (accum self) (/ 1.0 (count self)))) )
                 self) )
       (newempty ((a (typeof self)))) ) )

; 30 Sep 04
(mystats anything
  msg ((init   ((progn ((accum self) = 0)
                       ((sumsq self) = 0)
                       ((count self) = 0) )))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                  (progn ((accum self) _+ (summand (cast item (dataview self))))
                         ((sumsq self) _+ (expt (summand (cast item (dataview self)))
                                                2))
                         ((count self) _+ 1) ))))
       (final  (self))
       (newempty ((a (typeof self)))) )
  supers (stats) )

; 24 Feb 05
(myminner anything
  msg ((init   ((okay self) = nil))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (let (val)
                       (val = (summand (cast item (dataview self))))
                       (if (or (not (okay self))
                               (< val (accum self)))
                           ((accum self) = val))
                       ((okay self) = t) ))))
       (final  ((accum self)))
       (newempty ((a (typeof self)))) ) )

; 24 Feb 05
(mymaxer anything
  msg ((init   ((okay self) = nil))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (let (val)
                       (val = (summand (cast item (dataview self))))
                       (if (or (not (okay self))
                               (> val (accum self)))
                           ((accum self) = val))
                       ((okay self) = t) ))))
       (final  ((accum self)))
       (newempty ((a (typeof self)))) ) )

; 24 Feb 05; 07 Nov 06
(myargmaxer anything
  msg ((init   ((okay self) = nil))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (let (val)
                       (val = (comparand (cast item (dataview self))))
                       (if (or (not (okay self))
                               (> val (accum self)))
                           (progn ((accum self) = val)
                                  ((best self) = item)))  ; was generic-copy
                       ((okay self) = t) ))))
       (final  ((if (valid self) (best self) *glnull*)))
       (newempty ((a (typeof self)))) ) )

; 24 Feb 05; 07 Nov 06
(myargminer anything
  msg ((init   ((okay self) = nil))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (let (val)
                       (val = (comparand (cast item (dataview self))))
                       (if (or (not (okay self))
                               (< val (accum self)))
                           (progn ((accum self) = val)
                                  ((best self) = item)))  ; was generic-copy
                       ((okay self) = t) ))))
       (final  ((if (valid self) (best self) *glnull*)))
       (newempty ((a (typeof self)))) ) )

; 11 Nov 04
(myhisto anything
  msg ((init   (glambda (self)
                 ((accum self) = (make-array (+ (nbins self) 2)
                                 :element-type (typeof (initial-value self))))
                 (dotimes (i (+ 2 (nbins self)))
                   (aref (accum self) i) = (initial-value self))))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                   ((aref (accum self)
                          (min (max 0
                                    (1+ (truncate
                                         (- (index (cast item (dataview self)))
                                            (minval self))
                                         (binwidth self))))
                               (+ (nbins self) 1)))
                     _+ (summand (cast item (dataview self)))))))
       (final  ((accum self)))
       (newempty (*glnull*)) ) )     ; was (a (typeof self))

; 26 May 04; 14 Sep 04
(mytpqof anything
  msg ((init   ((progn ((qstart self) = *glnull*)
                       ((qend self) = *glnull*) )))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (insert-item self
                                  (summand (cast item (dataview self)))))))
       (final  (self))
       (newempty ((a (typeof self)))) )
 supers (two-pointer-queue-record) )

; 14 Sep 04
(mylisptpqof (list (qstart (listof anything)) (qend (listof anything)))
  msg ((init   ((progn ((qstart self) = nil)
                       ((qend self) = nil) )))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (let (new)
                       (new = (cons (summand (cast item (dataview self))) nil))
                       (if (null (qstart self))
                           ((qstart self) = new)
                           ((rest (qend self)) = new) )
                       ((qend self) = new)) )) )
       (final  (self))
       (newempty ((a (typeof self)))) ) )

; 24 Jul 03; 28 Jul 03; 30 Sep 03; 13 Nov 03; 24 May 04; 20 Sep 04; 21 Sep 04
; 29 Sep 04; 28 Oct 04
; alist
(myalist anything
  prop ((order-one-access  (nil)))
  msg ((newempty   (*glnull*)  result (typeof self))     ; empty alist
       (init       (glambda (self) ))
       (member       (glambda (self key) (assoc key self :test #'equal))
                   result (typeof (car self)) )
       (insert-key (glambda (self key)
                     (cons (a (typeof (car self)) with alkey = key)
                           self))
                   result (typeof self))  ))

; 24 Jul 03; 28 Jul 03; 21 Nov 03; 25 Nov 03
; storage record
(mystgrec anything
  msg  ((init      (glambda (self)
                     (for ac in (accfields self) (init (funcall ac self)))
                     self))
        (update    (glambda (self item)
                     (for ac in (accfields self)
                       (update (funcall ac self) item))
                     self))
        (final     (self))
        (^.        (self))
        (newempty ((a (typeof self)))) ))

; 28 Oct 03; 04 Nov 03; 24 May 04; 21 Sep 04; 27 Sep 04; 28 Sep 04
(myarrayof anything
  prop ((order-one-access  (t))
        (init-val  ((if (member (glxtrtypeb (typeof (aref self 0)))
                                '(integer real))
                        (initial-value
                          (funcall (first (accfields (aref self 0)))
                                   (aref self 0)))
                        (if (glpropdef
                             (typeof (funcall (first (accfields (aref self 0)))
                                              (aref self 0))) 'msg 'newempty)
                            (newempty
                              (funcall (first (accfields (aref self 0)))
                                       (aref self 0)))
                            (a (typeof (aref self 0))) ) ))))
  msg ((newempty   (glambda (self)
                     (make-array (size self)
                       :element-type (glxtrtypeb (typeof (aref self 0))) ))
                   result (typeof self))     ; :initial-element ???
       (init       (glambda (self)
                     (dotimes (i (size self))
                       ((aref self i) = (init-val self)))) )
       (member     (glambda (self key) (aref self key)) )
       (insert-key (glambda (self key)
                     (setf (aref self key) 
                           (a (typeof (aref self 0))))
                     self)
                   result (typeof self)) ))

; 15 Sep 04; 16 Sep 04; 21 Sep 04
(myhistoarr anything
  prop ((order-one-access  (t))
        (init-val  ((if (member (glxtrtypeb (typeof (aref self 0)))
                                '(integer real))
                        (initial-value
                          (funcall (first (accfields (aref self 0)))
                                   (aref self 0)))
                        *glnull*)) ) )
  msg ((newempty   (glambda (self) (make-array (+ 2 (nbins self))))
                     result (typeof self))     ; :initial-element ???
     ; (initial-value (aref self 0))
       (init       (glambda (self)
                     (dotimes (i (+ 2 (nbins self)))
                       ((aref self i) = (init-val self)))) )
       (indx       (glambda (self key)
                     (min (max 0
                               (1+ (truncate
                                    (- (index (cast key (dataview self)))
                                       (minval self))
                                    (binwidth self))))
                          (+ (nbins self) 1))) )
       (member     (glambda (self key) (aref self (indx self key))) )
       (insert-key (glambda (self key)
                     (setf (aref self (indx self key) )
                           (a (typeof (aref self 0))))
                     self)
                   result (typeof self)) ))

; 31 Jul 03; 30 Sep 03; 13 Nov 03; 20 Nov 03; 24 May 04; 25 May 04; 21 Sep 04
; 24 Sep 04; 28 Sep 04; 29 Sep 04
(myfu anything
  msg ((init   (    ;  ((accum self) = (newempty (accum self)))
                (init (accum self)) ))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (if (order-one-access (accum self))  ; test for array
                         (progn
                           (if (memberp (accum self))
                            (if (null (member (accum self)
                                        (key (cast item (dataview self)))))
                                (progn
                                  ((accum self) = (insert-key (accum self)
                                            (key (cast item (dataview self)))))
                                  (for ac in (accfields (member (accum self)
                                      (key (cast item (dataview self))))) do
                                      (init (funcall ac (member (accum self)
                                       (key (cast item (dataview self))))))))))
                           (for ac in (accfields (member (accum self)
                                      (key (cast item (dataview self))))) do
                             (update (funcall ac (member (accum self)
                                       (key (cast item (dataview self)))))
                                     item)))
                     (let (rec)   ; else of (if (order-one-access (accum self))
                       (rec = (member (accum self)
                                      (key (cast item (dataview self)))))
                       (if (null rec)
                           (progn
                             ((accum self) = (insert-key (accum self)
                                            (key (cast item (dataview self)))))
                             (rec = (member (accum self)
                                            (key (cast item (dataview self)))))
                             (for ac in (accfields (^. rec)) do
                                  (init (funcall ac (^. rec)))) ))
                       (for ac in (accfields (^. rec)) do
                            (update (funcall ac (^. rec)) item)) )))))
       (final  (self))
       (newempty ((newempty (accum self)))) ) )

; 09 Oct 03; 16 Oct 03; 20 Oct 03; 25 Nov 03; 30 Sep 04
(mylistptr (^ mylistof)
  msg ((init   (self = *glnull*))
       (update (glambda (self item)
                 (let (newr)
                   (if (test (cast item (dataview self)))
                       (progn
                         (newr = (new (^. self)))
                         ((link (^. newr)) = self)
                         (self = newr)
                         ((contents (^. newr)) =
                            (summand (cast item (dataview self)))))))))
       (final  (glambda (self) (nreverse self)))
       (newempty (*glnull*)) )
  supers (linked-list-pointer) )

; 30 Sep 04; 05 Mar 08
(mylisplistptr anything
  msg ((init   (self = nil))
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (self = (cons (summand (cast item (dataview self))) self)))))
       (final  (glambda (self) (nreverse self)))
       (newempty (*glnull*)) ) )

(mylistof anything supers (linked-list-record))

; 08 Feb 05; 22 Feb 05; 24 Feb 05
(mychain anything
  msg ((init   (glambda (self)
                 ((accum self) =
                   (generic-copy (initial-value (cast arg (initview self)))))
                 (init (accumdata self)) ) )
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                   ((accum self) _+ (summand (cast item (dataview self)))))
                 (update (accumdata self) (accum self)) ) )
       (final  ((accumdata self)))
       (newempty ((a (typeof self)))) ) )

; 03 Apr 07; 05 Apr 07; 10 May 07; 11 May 07; 30 Apr 09; 08 May 09; 28 Jul 09
; 11 Aug 09
(myarrtpq anything
  adj ((empty        (glambda (self)
                       (while (and (< (lowest self) (nbins self))
                                   (empty (aref (queues self) (lowest self))))
                         ((lowest self) += 1))
                       (>= (lowest self) (nbins self)) ) ) )
  msg ((initialize   (glambda (self)
                       ((lowest self) = (nbins self))
                       ((queues self) = (make-array (nbins self)))
                       (dotimes (i (nbins self))
                         ((aref (queues self) i) =
                                      (a (typeof (aref (queues self) 0))))
                         (initialize (aref (queues self) i)))
                       self)  result (typeof self))
       (insert-item  (glambda (self item)
                       (let ((n (sort-value (cast item (itemtp self)))))
                         (insert-item (aref (queues self) n) item)
                         (if (< n (lowest self))
                             ((lowest self) = n))
                         self))
                     result (typeof self))
       (remove-item  (glambda (self)
                       (while (and (< (lowest self) (nbins self))
                                   (empty (aref (queues self) (lowest self))))
                         ((lowest self) += 1))
                       (if (< (lowest self) (nbins self))
                           (remove-item (aref (queues self) (lowest self))))))))

; 23 Mar 10
(mycirplot anything
  msg ((init   (glambda (self &optional arg) ) )
       (update (glambda (self w v item)
                 (if (test (cast item (dataview self)))
                     (window-draw-circle-xy w (x v) (y v)
                             (radiusval (cast item (dataview self))))) ) )
       (newempty ((a (typeof self)))) ) )

; 26 Mar 10
(mysqrplot anything
  msg ((init   (glambda (self &optional arg) ) )
       (update (glambda (self w v item)
                 (if (test (cast item (dataview self)))
                     (window-draw-box-xy w (x v) (y v)
                             (sideval (cast item (dataview self)))
                             (sideval (cast item (dataview self))))) ) )
       (newempty ((a (typeof self)))) ) )

; 14 Oct 11
(mypgm anything
 prop ((accfields ()) )
  msg ((init   (glambda (self &optional arg) ) )
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (action (cast item (dataview self))) ) ) )
       (final  ())
       (newempty ()) ) )

; 14 Nov 11; 21 Nov 11; 23 Nov 11; 30 Nov 11
(myheapacc anything
  msg ((init   (glambda (self &optional arg)
                 ((filled-size self) = 0) ) )
       (update (glambda (self item)
                 (if (test (cast item (dataview self)))
                     (insert-item self
                                  (a (typeof (aref (thearray self) 0))
                                     with priority = 
                                      (sort-value (cast item (dataview self)))
                                      item =
                                      (summand (cast item (dataview self))))))))
       (final  (self))
       (newempty ((new (a (typeof self)) 8))) )
  supers (heap) )

(part (list (name string) (size integer) (weight real) ; for testing
             (pretty boolean) (next (^ part))))

(partc (crecord partc (name string) (size integer) (weight real)
             (pretty boolean) (next (^ partc)))
  viewspecs ((linked-list linked-list (link next))) )

(fumble (list (j integer) (sm sumtype1)))    ; sumtype1 as part of a structure
(farble (list (j integer) (av avgtype1)))
(assembly (list (name string) (parts (listof part))))
(assemblyc (crecord assemblyc (name string) (ptr (^ partc)))
  prop ((parts ((linked-list (^. (ptr self)))))))
(myvo (list (v integer) (u integer)))      ; can be viewed as vector
(mypolyk (list (name string) (pts (listof myvo))))  ; polygon for testing

(mych (list (name string) (start vector) (chain (listof chaincode))))
) ; glispobjects

#| test programs commented out
(gldefun t71 ((l pointer1)) (sort l))   ; pointer type from myinst

(gldefun t72 ((i item1)) (if (test i) (print (init i))) (summand i))

(gldefun t73 ((p part)) (let ((s (a sumd1))) (init s) (update s p)))

(gldefun t74 ((p part)) (let ((s (a fumble))) (init (sm s)) (update (sm s) p)))

(gldefun t75 ((p part)) (let ((s (a farble))) (init (av s)) (update (av s) p)))

(gldefun t76 ((arg RECORDTYPE8))
  (let ((acc (a SUMD7)))
    (init acc)
    (for x in (seq arg) (update acc x))
    (final acc) ))

(gldefun t77 ((arg RECORDTYPE27))
  (let ((acc (a (eval (accumtp arg)))))
    (init acc)
    (for x in (seq arg) (update acc x))
    (final acc) ))

(gldefun t78 ((l alist1) (s symbol)) (insert-key l s))

(gldefun t87 ((r RECORD12) (p part))
  (for f in (accfields r) do
    (update (funcall f r) (cast p (dataview (funcall f r))))))

(gldefun t43 ((r RECORDTYPE8))
  (for g in (seq r) sum (x (vecview (cast x (dataview r))))))

(gldefun t81 ((s lstp1) (p part)) (update s p))
|#

; 12 Aug 04; 09 Sep 04; 23 Sep 04; 24 Sep 04; 28 Sep 04; 29 Sep 04; 30 Sep 04
; 04 Oct 04; 06 Oct 04; 07 Oct 04; 17 Feb 05; 17 Jan 07; 13 Oct 10
; iterate-accumulate generic
(gldefun itaccfn ((arg anything))
  (result (typeof (accumtp arg)))
  (let ((acc (typeof (accumtp arg))) )
    (if (not (glbasictypep (glxtrtypeb (typeof acc))))
        (if (cdr (accfields arg))
            (acc = (a (typeof acc)))
            (acc = (newempty (funcall (first (accfields arg)) acc)))))
    (for ac in (accfields arg) (init (funcall ac acc) arg))
    (for x in (seq arg)
         (for ac in (accfields arg) (update (funcall ac acc) x)))
    (for ac in (accfields arg)                              ; 13 Oct 10
         ((funcall ac acc) = (final (funcall ac acc)) ) )
    acc))

#|  commented out:
    (if (and (not (equal (typeof acc) (typeof res)))
             (not (glbasictypep (glxtrtypeb (typeof acc)))))
        (progn (if (not (glbasictypep (glxtrtypeb (typeof res))))
                   (res = (a (typeof res))))
               (if (glbasictypep (glxtrtypeb (typeof res)))
                   (res = (final (funcall (first (accfields arg)) acc)))
                   (for ac in (accfields arg)       ; collect had a problem
                      ((funcall ac res) = (final (funcall ac acc)) )))
               res)
        (progn (for ac in (accfields arg)       ; collect had a problem
                    ((funcall ac acc) = (final (funcall ac acc)) ))
               acc)) ))
|#

; 26 Mar 10
; iterate-accumulate generic
(gldefun ipplotfn ((arg anything) (w window) (base vector) (scale vector))
  (let ( (acc (typeof (accumtp arg))) )
    (for itm in (seq arg) when (test (cast itm (itemview arg)))
         (for ac in (accfields arg)
              (update (funcall ac acc) w
                      (scale (- (position (cast itm (itemview arg))) base)
                             scale)
                      (value (cast itm (itemview arg))))))  ))

; 17 Dec 10; 08 Feb 11
; plot by iterate-accumulate generic
(gldefun ipplotfnb ((arg anything) (w window))
  (let ( (acc (typeof (accumtp arg))) geom (xoff 20) (yoff 20)
         (xmin 99999999) (xmax -99999999) (ymin 99999999) (ymax -99999999)
         xx yy xrange yrange xscale yscale base xval started lastx lasty)
    (geom = (geometry w))
    (if (autoscale arg)
 ; ***** need to add code / parameters for the case where autoscale = false
     ; a case where we would like to use min, max verbs but want 1 loop
        (for itm in (seq arg) when (test (cast itm (itemview arg)))
             (xx = (x (cast itm (itemview arg))))
             (yy = (y (cast itm (itemview arg))))
             (xmin = (min xmin xx))
             (xmax = (max xmax xx))
             (ymin = (min ymin yy))
             (ymax = (max ymax yy)) )
        (progn (xmin = (minx arg))
               (xmax = (maxx arg))
               (ymin = (miny arg))
               (ymax = (maxy arg)) ) )
    (xrange = (- xmax xmin))
    (if (<= xrange 0) (xrange = 1))
    (xscale = (/ (- (third geom) (* 2 xoff)) xrange))
    (yrange = (- ymax ymin))
    (if (<= yrange 0) (yrange = 1))
    (yscale = (/ (- (fourth geom) (* 2 yoff)) yrange))
    (if (generatex arg) (xval = 0))
    (for itm in (seq arg) when (test (cast itm (itemview arg)))
         (xx = (if (generatex arg)
                   xval
                   (+ xoff (* xscale (- (x (cast itm (itemview arg))) xmin)))))
         (yy = (+ yoff (* yscale (- (y (cast itm (itemview arg))) ymin))))
         (for ac in (accfields arg)
              (update (funcall ac acc) w (a vector x = xx  y = yy)
                      (value (cast itm (itemview arg))))
     ; an optimization case where this data structure could be unpacked
     ; extra conses but ok for testing
              (if (connected arg)
                  (progn
                    (if started
                        (draw-line-xy w lastx lasty xx yy) )
                    (started = t)
                    (lastx = xx)
                    (lasty = yy)) )
              (if (generatex arg) (xval _+ 1)) ) ) ))

; 11 Mar 10; 14 Oct 11
; iterate-do generic
(gldefun itdofn ((arg anything))
  (let ((acc (typeof (accumtp arg))) )
    (for x in (seq arg)
         (for ac in (accfields arg) (update (funcall ac acc) x))) ))

; 31 Dec 08
(gldefun findfn ((arg anything))
  (result (typeof (valuetp arg)))
  (let ((val (typeof (valuetp arg))) (found boolean))
    (found = *glfalse*)
    (for x in (seq arg) when (test (cast x (itemview arg))) until found
         (val = (value (cast x (itemview arg))))
         (found = *gltrue*))
    val))

; 12 Apr 07; 17 Apr 07; 10 May 07; 11 May 07; 15 May 07; 30 Apr 09; 13 May 09
; 29 May 09; 28 Jul 09; 10 Aug 09; 08 Sep 09
; Generic heuristic search 
(gldefun heursfn ((start anything) (goal (typeof start)))
  (let (open est done current succ nextst newg)
    (done = *glfalse*)
    (open = (initialize (a (typeof (opentp start)))) )
    (est = (estimate start goal))
    (insert-item open
            (a (recordtp start) with
               state = start  f = est  g = 0  parent = *glnull*) )
    (while (and (not done) (not (empty open)))
      (current = (remove-item open))
      (if (stateequal (state current) goal)
          (done = *gltrue*)
          (for succ in (successors (state current))
            when (applicable (state current) succ)
            (nextst = (nextstate (state current) succ))
            (est = (estimate nextst goal))
            (newg = (+ (g current) (cost (state current) succ)))
            (insert-item open
                    (a (recordtp start) with
                       state = nextst
                       f = (+ newg est)
                       g = newg
                       parent = current
                       op = (op (state current) succ)) ) ) ) )
    (if done current *glnull*) ))

;    (for item in (linked-list current) collect (state item))

#| test programs commented out
; for printing word counts
(gldefun t90 ((z PTR2))
  (for x in z when (> (CONTENTS x) 2)
       (format t "~A~20T~3D~%"(SORT-VALUE x) (CONTENTS x))))

; 05 Oct 04
; for printing the kwic index -- needs editing to put in correct types.
(gldefun t91 ((p PTR12))
  (for word in p
       (for occurrence in (qstart (funcall (first (accfields p))
                                            (contents word)))
            (format t "~A~%" (subseq (str (contents occurrence))
                                     (col (contents occurrence)))))))
|#

(setq mypart (a part with name "widget" size 4 weight 3.1 pretty t
         next (a part with name "gadget" size 3 weight 2.7 pretty nil
          next (a part with name "grommet" size 5 weight 1.4 pretty t))))

(setq myasm (an assembly name "fromulus"
  parts (list (a part with name "widget"  size 4 weight 3.1 pretty t)
              (a part with name "gadget"  size 3 weight 2.7 pretty nil)
              (a part with name "grommet" size 5 weight 2.5 pretty nil)
              (a part with name "widget"  size 1 weight 1.4 pretty t)
              (a part with name "gadget"  size 2 weight 0.3 pretty nil)
              (a part with name "grommet" size 7 weight 6.8 pretty t))))

(setq myasmb (an assembly name "fromulus"
                parts (list (a part with name "widget"  size 700)
                            (a part with name "gadget"  size 1220)
                            (a part with name "grommet" size 1600)
                            (a part with name "widget"  size 1620)
                            (a part with name "gadget"  size 100)
                            (a part with name "grommet" size 950)
                            (a part with name "gadget"  size 900)
                            (a part with name "grommet" size 1280)
                            (a part with name "widget"  size 1240)
                            (a part with name "gadget"  size 1200)
                            (a part with name "grommet" size 980)
                            (a part with name "widget"  size 2240)
                            (a part with name "gadget"  size 200)
                            (a part with name "grommet" size 880) )))

(setq mypartc (a partc with name "widget" size 4 next
               (a partc with name "gadget" size 3 next
                 (a partc with name "grommet" size 5))))

(setq myasmc (an assemblyc name "fromulus"
   ptr (a partc with name "widget" size 4 weight 3.1 pretty t next
          (a partc with name "gadget" size 3 weight 2.7 pretty nil next
             (a partc with name "grommet" size 5 weight 2.5 pretty nil next
                (a partc with name "widget" size 1 weight 1.4 pretty t next
                   (a partc with name "gadget" size 2 weight 0.3 pretty nil next
                      (a partc with name "grommet" size 7 weight 6.8 pretty t))))))))

(setq myasmcb (an assemblyc name "fromulus"
                ptr (a partc with name "widget"  size 700 next
                            (a partc with name "gadget"  size 1220 next
                            (a partc with name "grommet" size 1600 next
                            (a partc with name "widget"  size 1620 next
                            (a partc with name "gadget"  size 100 next
                            (a partc with name "grommet" size 950 next
                            (a partc with name "gadget"  size 900 next
                            (a partc with name "grommet" size 1280 next
                            (a partc with name "widget"  size 1240 next
                            (a partc with name "gadget"  size 1200 next
                            (a partc with name "grommet" size 980 next
                            (a partc with name "widget"  size 2240 next
                            (a partc with name "gadget"  size 200 next
                            (a partc with name "grommet" size 880) )))
                            ))))))))))))

(setq mypolykd '("poly" ((5 5) (10 5) (17 10) (17 13) (12 16) (5 16) (3 10))))

; (3 4) (4 4) (5 4) (6 5) (7 6) (7 7) (6 8) (5 8) (4 7) (4 6) (5 5) (6 4) (7 3)
(setq chn '("chain" (3 4) (0 0 1 1 2 3 4 5 6 7 7 7)))
