; vector.lsp               Gordon S. Novak Jr.           ; 02 Apr 12

; Copyright (c) 2012 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 01 Mar 96; 28 Dec 98; 15 Jan 99; 26 Jan 99; 18 Feb 99; 01 Apr 99; 10 May 99
; 28 Feb 02; 05 Jan 04; 28 May 04; 01 Jun 04; 01 Feb 05; 22 Feb 05; 19 Jul 06
; 21 Jul 06; 01 Sep 06; 14 Sep 06; 15 Sep 06; 19 Sep 06; 27 Feb 07; 27 Feb 07
; 13 Sep 07; 19 Nov 07; 12 Dec 07; 18 Jan 08; 14 Feb 08; 19 Feb 08; 26 Dec 08
; 15 Jan 09; 03 Feb 09; 04 Sep 09; 23 Sep 09; 25 Mar 10; 26 Mar 10; 16 Mar 11

; Vector utility file

(glispobjects

(vector (list (x integer)
              (y integer))
prop    ((magnitude ((sqrt x ^ 2 + y ^ 2)))
         (sqmagnitude ((+ (expt x 2) (expt y 2))))
         (imagnitude ((truncate magnitude + 0.9999)))
         (angle ((atan y x)) result (units real radians))
         (unitvector ((a rvector with x = x / magnitude y = y / magnitude)))
         (zero  (glambda (self) (a (typeof self) x = 0 y = 0))) )
adj     ((zero? (x is zero and y is zero))
         (normalized (glambda (self)
                       (< (abs (- (magnitude self) 1.0)) 1.0e-8) ) ) )
msg     ((+           vectorplus         open t argtypes (vector))
         (+b          vectorplus-b       open t argtypes (vector))
         (++          vectorplus-v       open t argtypes (vector))
         (-           vectordiff         open t argtypes (vector))
         (*           vectortimes        open t argtypes (number))
         (dotproduct  vectordotproduct   open t argtypes (vector))
         (scale       vectorscale        open t argtypes (vector))
         (crossproduct  vectorcrossproduct   open t argtypes (vector))
         (clockwise   vectorclockwise    open t argtypes (vector vector))
         (/           vectorquotient     open t argtypes (number))
         (lowpass     vectorlowpass      open t argtypes (vector number))
         (>           vectorgreaterp     open t argtypes (vector))
         (<=          vectorleqp         open t argtypes (vector))
         (==          vectorequal        open t argtypes (vector))
         (<>          vectornotequal     open t argtypes (vector))
         (equal       vectorequal        open t argtypes (vector))
         (_+          vectormove         open t argtypes (vector))
         (max         vectormax          open t argtypes (vector))
         (maxb        vectormaxb         open t argtypes (vector))
         (distance    vector-distance    specialize t argtypes (vector))
;         (line        vector-vector-line open t argtypes (vector))
         (line-to     vector-vector-line open t argtypes (vector))
         (line-angle  line-from-point-angle     argtypes (real))
         (region      (glambda (self corner)
                        (virtual regionc with start = self
                                              corner = corner))
                                                argtypes (vector))
         (line-slope  vector-slope-line  open t argtypes (number))
         (angle-to    vector-angle-to    open t argtypes (vector))
         (dist-angle  vector-dist-angle  open t argtypes (number number))
         (prin1 ((format t "(%a,%a)" x y)))
         (print ((format t "(~a,~a)~%" x y)))
         (dx          vectordx           open t argtypes (vector))
         (dy          vectordy           open t argtypes (vector))
         (midpoint    vector-midpoint    open t argtypes (vector))
         (project     vector-project     open t)
         (vproject    vector-vproject    open t)
 ) )

; so obviously vector should be parameterized by number of dimensions,
; number representation, and units.

(consv (cons (x integer) (y integer))  supers  (vector))

(rvector (list (x real)  (y real))     supers  (vector))

(nvector (list (x number) (y number))  supers (vector))

(cvector (crecord cvector (x real) (y real)) supers (vector))

(rthvector (list (r real) (theta real))
  prop ((x   ((* r (cos theta))))
        (y   ((* r (sin theta)))))
  viewspecs ((vector  vector  (magnitude r) (angle theta))
             (nvector nvector (magnitude r) (angle theta))
             (rvector rvector (magnitude r) (angle theta)))
 supers (vector) )

; 16 Mar 11
(listvector (listof number)
prop    ((magnitude ((sqrt (for x in self sum (* x x)))) )
         (zero  (glambda (self) (list 0)) )
         (unitvector (glambda (self) (/ self (magnitude self))) ) )
adj     ((zero? (glambda (self) (every #'zerop self)) )
         (normalized (glambda (self)
                       (< (abs (- (magnitude self) 1.0)) 1.0e-8) ) ) )
msg     ((+           listvectorplus     argtypes (listvector))
         (-           listvectordiff     argtypes (listvector))
         (*           listvectortimes    argtypes (number))
         (dotproduct  listvectordotproduct  argtypes (listvector))
         (scale       listvectorscale    argtypes (listvector))
         (/           listvectorquotient argtypes (number))
         (==          listvectorequal    argtypes (listvector))
         (/=          listvectornotequal argtypes (listvector))
         (distance    listvector-distance argtypes (listvector))
 ) )

(region (list (start vector)
              (size vector))
prop    ((left         ((x start)))
         (bottom       ((y start)))
         (right        (left + width))
         (top          (bottom + height))
         (width        ((x size)))
         (height       ((y size)))
         (center       (start + size / 2))
         (topcenter    ((a vector with x = left + width / 2 y = top)))
         (bottomcenter ((a vector with x = left + width / 2 y = bottom)))
         (area         (width * height))
         (start        ((virtual vector with x = left y = bottom)))
         (size         ((virtual vector with x = width y = height)))
         (topleft      ((virtual vector with x = left y = top)))
         (bottomleft   ((virtual vector with x = left y = bottom)))
         (topright     ((virtual vector with x = right y = top)))
         (bottomright  ((virtual vector with x = right y = bottom)))
         (corners      ((list topleft bottomleft bottomright topright)))  )
adj     ((empty        (width is zero or height is zero))
         (zero?        (self is empty))  )
msg     ((contains?    region-contains open t)
         (contains-xy  region-contains-xy open t)
         (scontains?   region-scontains open t)
         (scontains-xy region-scontains-xy open t)
         (setposition  region-setposition open t)
         (centeroffset region-centeroffset open t)
         (union        region-union specialize t)
         (intersect    region-intersect specialize t)
         (overlaps?    region-overlaps specialize t)   ))

; region specified by corners
(regionc (list (start vector) (corner vector))
prop ((right ((x corner)))
      (top   ((y corner)))
      (size  ((virtual vector with x = (- right left) y = (- top bottom)))) )
supers (region) )

; 30 Dec 91; 02 Oct 92; 14 Oct 92; 22 Oct 93; 01 Mar 96; 28 Feb 02; 19 Jul 06
; 14 Sep 06; 19 Sep 06; 07 Feb 07; 26 Feb 07
(line-segment (list (p1 vector) (p2 vector))
 prop   ((p1x             ((x p1)))
         (p1y             ((y p1)))
         (p1              ((virtual vector with x = p1x y = p1y)))
         (p2x             ((x p2)))
         (p2y             ((y p2)))
         (p2              ((virtual vector with x = p2x y = p2y)))
         (deltax          (p2x - p1x))
         (deltay          (p2y - p1y))
         (size            ((virtual vector with x = deltax y = deltay)))
         (slope           ((if (vertical self)            ; 05 Jan 04
                               (if (deltay > 0)
                                   most-positive-single-float
                                   most-negative-single-float)
                               (okslope self))))
         (lengthsq        ( deltax ^ 2 + deltay ^ 2))
         (length          ((sqrt deltax ^ 2 + deltay ^ 2)))
         (theta           ((atan deltay deltax)))
         (angle           ((atan deltay deltax)))
         (center          ((virtual vector with
                             x = (/ (+ (x (p1 self)) (x (p2 self))) 2)
                             y = (/ (+ (y (p1 self)) (y (p2 self))) 2))))
         (okslope         (deltay / (float deltax)))
         (area-under      ((/ (* (+ (y (p1 self)) (y (p2 self)))
                                 (- (x (p2 self)) (x (p1 self))))
                              2)))
         (perpendicular-bisector
                          ((line-from-point-angle (center self)
                                (+ (angle self) (/ pi 2)))))
         (region          ((virtual region with
                             start = (virtual vector x = (min (x p1) (x p2))
                                                     y = (min (y p1) (y p2)))
                             size = (virtual vector x = (abs ((x p1) - (x p2)))
                                                    y = (abs ((y p1) - (y p2)))))))
         (line            line-segment-line open t))
 adj    ((vertical        (p2x == p1x)) )
 msg    ((leftof-distance line-segment-leftof-distance open t)
         (distance        line-segment-distance open t)
         (leftof          line-segment-leftof open t)
         (leftof-x        line-segment-leftof-x open t)
         (within-y        line-segment-within-y open t)
         (area-under2     line-segment-area-under2 open t)
         (cofg-area-x     line-segment-cofg-area-x open t)
         (cofg-area-y     line-segment-cofg-area-y open t)
         (draw            line-segment-draw open t)
         (intersect       line-segment-intersect specialize t)
         (intersect?      line-segment-intersect? specialize t)
         (contains?       line-segment-contains? open t)
         (point-along     line-segment-point-along open t)
         (leftofb         (glambda (self (p3 vector))  ; p3 left of line
                            (ccw (virtual triangle p1 (p1 self)
                                          p2 (p2 self) p3 p3))) )
 ))

(c-line-segment (crecord c-line-segment (p1 cvector) (p2 cvector))
  supers (line-segment))

; 23 Oct 92
(right-triangle (list (x number) (y number))
 prop   ((r               ((sqrt x ^ 2 + y ^ 2)))
         (theta           ((atan y x)))
         (slope           ((/ y x)))
         (phi             ((atan x y)))
         (area            (x * y / 2))) )

; 22 Feb 05
(chaincode integer
  prop ((delta    ((aref
                     '#((1 0) (1 1) (0 1) (-1 1) (-1 0) (-1 -1) (0 -1) (1 -1))
                      self))
                  result vector) ) )

  ) ; glispobjects


(setf (get 'vector 'ap-omit)
      '(double print prin1 maxb max _+ >= <= > / * ++ +b imagnitude))

(setf (get 'line-segment 'ap-omit)
      '(double draw cofg-area-y cofg-area-x within-y
        leftof-x okslope))

(setf (get 'region 'ap-omit)
      '(centeroffset setposition zero bottomcenter topcenter))

; GSN  2-FEB-83 14:00 
(gldefun region-centeroffset ((r region) (v vector))
  (a (typeof v) with x = ((width r) - (x v)) / 2
                     y = ((height r) - (y v)) / 2))


; 26-OCT-82; 01 Jun 95; 28 Dec 98; 01 Jun 04; 14 Feb 08
; Test whether a region contains a point P. 
(gldefun region-contains ((reg region) (p vector))
  (result boolean)
  (and (between (x p) (left reg) (right reg))
       (between (y p) (bottom reg) (top reg))) )

; strict containment
(gldefun region-scontains ((reg region) (p vector))
  (result boolean)
  (and (sbetween (x p) (left reg) (right reg))
       (sbetween (y p) (bottom reg) (top reg))) )

; 22 Nov 91; 28 Dec 98; 14 Feb 08
(gldefun region-contains-xy ((reg region) (x integer) (y integer))
  (and (between x (left reg) (right reg))
       (between y (bottom reg) (top reg))) )

(gldefun region-scontains-xy ((reg region) (x integer) (y integer))
  (and (sbetween (x p) (left reg) (right reg))
       (sbetween (y p) (bottom reg) (top reg))) )

; 30-JAN-83; 28 Dec 94; 01 Jun 95
(gldefun region-intersect ((p region) (q region))
  (result (typeof p))
; Produce a region which is the intersection of two given regions. 
  (let (newbottom newleft newarea xsize ysize)
      (newbottom = (max (bottom p) (bottom q)))
      (ysize = (min (top p) (top q)) - newbottom)
      (newleft = (max (left p) (left q)))
      (xsize = (min (right p) (right q)) - newleft)
      (newarea = (a (typeof p)))
      ((left newarea)   = newleft)
      ((bottom newarea) = newbottom)
      ((width newarea)  = (max 0 xsize))
      ((height newarea) = (max 0 ysize))
       newarea))


; 14-JAN-83 11:52 ; 01 Jun 95; 28 Dec 98
; Change the START point of region so that the position APOS relative to 
;   the region will have the position NEWPOS. 
(gldefun region-setposition ((reg region) (apos vector) (newpos vector))
((start reg) _+ newpos - apos))


; 30-JAN-83; 28 Dec 94; 01 Jun 95
(gldefun region-union ((p region) (q region))
  (result (typeof p))
; Produce a region which is the union of two given regions. 
  (let (newbottom newleft xsize ysize newarea)
    (newbottom = (min (bottom p) (bottom q)))
    (ysize = (max (top p) (top q)) - newbottom)
    (newleft = (min (left p) (left q)))
    (xsize = (max (right p) (right q)) - newleft)
    (newarea = (a (typeof p)))
    ((left newarea) = newleft)
    ((bottom newarea) = newbottom)
    ((width newarea) = xsize)
    ((height newarea) = ysize)
    newarea))

; 01 Sep 06
(gldefun region-overlaps ((p region) (q region))
  (let (flg)
    (for pt in (corners p) (setq flg (or flg (contains? q pt))))
    (for pt in (corners q) (setq flg (or flg (contains? p pt))))
    flg))

; GSN 10-FEB-83 13:41 
(gldefun vectorplus ((v1 vector) (v2 vector))
  (a (typeof v1) with x = (x v1) + (x v2)  y = (y v1) + (y v2)))

; 16 Mar 11
(gldefun listvectorplus ((v1 listvector) (v2 listvector))  (result listvector)
  (let (res)
    (while (or v1 v2)
      (res +_ (+ (or (car v1) 0) (or (car v2) 0)))
      (v1 = (cdr v1))
      (v2 = (cdr v2)))
    (nreverse res) ))

(gldefun vectorscale ((v1 vector) (v2 vector))
  (a (typeof v1) with x = (x v1) * (x v2)  y = (y v1) * (y v2)))

; 16 Mar 11
(gldefun listvectorscale ((v1 listvector) (v2 listvector))  (result listvector)
  (mapcar #'* v1 v2) )

; 08 Jan 92
(gldefun vectorplus-b ((u vector) (v vector))
  (let ((newv (a (typeof u))))
    (for nm in (components (typeof u)) do
      ((funcall nm newv) = (+ (funcall nm u) (funcall nm v))) )
    newv))

; 17 Oct 90; 24 Oct 90
; version of vectorplus using virtual view -- but it messes up the
; standard vector examples.
(gldefun vectorplus-v ((v1 vector) (v2 vector))
  (viewas vsum (typeof v1)  x = (x v1) + (x v2)  y = (y v1) + (y v2))
  vsum)

; 06 Feb 90
(gldefun vectordiff ((v1 vector) (v2 vector))
  (a (typeof v1) with x = (x v1) - (x v2)  y = (y v1) - (y v2)))

; 16 Mar 11
(gldefun listvectordiff ((v1 listvector) (v2 listvector))  (result listvector)
  (let (res)
    (while (or v1 v2)
      (res +_ (- (or (car v1) 0) (or (car v2) 0)))
      (v1 = (cdr v1))
      (v2 = (cdr v2)))
    (nreverse res) ))

(gldefun vector-midpoint ((v1 vector) (v2 vector))
  (a (typeof v1) with x = (/ ((x v1) + (x v2)) 2)
                      y = (/ ((y v1) + (y v2)) 2) ) )

; GSN 03 Oct 95
(gldefun vectordotproduct ((v1 vector) (v2 vector))
  ( (x v1) * (x v2) + (y v1) * (y v2) ) )

; 16 Mar 11
(gldefun listvectordotproduct ((v1 listvector) (v2 listvector))  (result number)
  (let ((sum 0))
    (mapcar #'(lambda (x y) (incf sum (* x y))) v1 v2)
    sum))

; 23 Sep 09
(gldefun vectorcrossproduct ((v1 vector) (v2 vector))
  ( (x v1) * (y v2) - (x v2) * (y v1) ) )

; 23 Sep 09
; test whether moving from v0 to v1, then to v2 is a clockwise turn
; Cormen p. 888
(gldefun vectorclockwise ((v0 vector) (v1 vector) (v2 vector))
  (plusp (crossproduct (- v2 v0) (- v1 v0))) )

; 01 Apr 99
(gldefun vectorlowpass ((v1 vector) (v2 vector) (f number))
  (a (typeof v1) with x = (lowpass (x v1) (x v2) f)
                      y = (lowpass (y v1) (y v2) f)) )

; GSN 14-JAN-83 12:33 
; This version of > tests whether one box will fit inside the other. 
(gldefun vectorgreaterp ((u vector) (v vector))
  ((x u) > (x v) or (y u) > (y v)))


; GSN 14-JAN-83 12:31 
(gldefun vectorleqp ((u vector) (v vector))
  ((x u) <= (x v) and (y u) <= (y v)))

; 17 May 93; 28 Feb 02
(gldefun vectorequal ((u vector) (v vector))
  ((x u) == (x v) and (y u) == (y v)))

; 16 Mar 11
(gldefun listvectorequal ((u listvector) (v listvector))  (result boolean)
  (every #'(lambda (x y) (= x y)) u v) )

; 17 May 93
(gldefun vectornotequal ((u vector) (v vector))
  ((x u) <> (x v) or (y u) <> (y v)))

; 16 Mar 11
(gldefun listvectornotequal ((u listvector) (v listvector))  (result boolean)
  (some #'(lambda (x y) (/= x y)) u v) )

; GSN 10-FEB-83 13:41 
(gldefun vectortimes ((v vector) (n number))
  (a (typeof v) with x = x*n  y = y*n))

; 16 Mar 11
(gldefun listvectortimes ((v listvector) (n number))  (result listvector)
  (mapcar #'(lambda (x) (* x n) ) v) )

; GSN 10-FEB-83 13:42 
(gldefun vectorquotient ((v vector) (n number))
  (a (typeof v) with x = x / n  y = y / n))

; 16 Mar 11
(gldefun listvectorquotient ((v1 listvector) (n number))
  (mapcar #'(lambda (x) (/ x n)) v1) )


; GSN 10-FEB-83 13:43 
(gldefun vectormove ((v vector) (delta vector))
  ((x v) _+ (x delta)) ((y v) _+ (y delta))v)

; 21 Dec 90
; Destructive max, alters first argument
(gldefun vectormax ((v vector) (new vector))
  ((x v) = (max (x v) (x new)))
  ((y v) = (max (y v) (y new)))
  v )

; 27 Feb 07
(gldefun vectordx ((u vector) (v vector))  (- (x u) (x v)) )
(gldefun vectordy ((u vector) (v vector))  (- (y u) (y v)) )

; 03 Jan 92
(gldefun vector-distance ((u vector) (v vector))
  (let ((dx ((x u) - (x v))) (dy ((y u) - (y v))))
    (sqrt dx * dx + dy * dy)))
; was   (magnitude (u - v))  -- elegant, but materializes the difference

; 16 Mar 11
(gldefun listvector-distance ((v1 listvector) (v2 listvector))
         (result real)
  (let ((sum 0))
    (mapc #'(lambda (x y) (incf sum (expt (- x y) 2))) v1 v2)
    (sqrt sum) ))

; 21 Dec 90
; Destructive max, alters first argument
; more general version
(gldefun vectormaxb ((v vector) (new vector))
  (for c in (components (typeof v)) do
    ((funcall c v) = (max (funcall c v) (funcall c new))))
  v)

; 19 Jul 06
(gldefun vector-vector-line ((v vector) (other vector))  (result line)
  (let (aval)
    (if (= (x v) (x other))
        (a line aa 1 b 0 c (- (x v)))
        (progn
          (aval = (- (/ (- (y v) (y other)) (- (x v) (x other)))))
          (a line aa aval
                  b  1
                  c  (- (- (* aval (x v))) (y v)) ) ) ) ))

; 19 Jul 06
(gldefun vector-slope-line ((v vector) (slope real))  (result line)
  (a line aa (- slope) b 1 c (- (* slope (x v)) (y v)) ) )

; 21 Jul 06
; find the point a distance d in direction of a line from given point
(gldefun vector-dist-angle ((pt vector) (d real) (ang real)) (result rvector)
  (a rvector x = (+ (x pt) (* (cos ang) d))
            y = (+ (y pt) (* (sin ang) d))) )

; 21 Jul 06
; find the angle from given point to another point
(gldefun vector-angle-to ((pt vector) (to vector))
  (atan (- (y to) (y pt)) (- (x to) (x pt))))

; 02 Apr 12
; project a 2-d vector to 3-d using function f
(gldefun vector-project ((v vector) (f anything))
  (a vector3d with x = x  y = y  z = (funcall f v)) )

(gldefun vector-vproject ((v vector) (f anything))
  (virtual vector3d with x = x  y = y  z = (funcall f v)) )

; 17 Sep 92
; Magnitude of perpendicular distance from a point to a line segment
(gldefun line-segment-distance ((ls line-segment) (p vector))
  (abs (leftof-distance ls p)) )

#|  ; old version -- commented out
; 30 Dec 91; 31 Dec 91; 14 Oct 92; 19 Jan 04
; Perpendicular distance of a point to the left of a directed line segment
(gldefun line-segment-leftof-distance ((ls line-segment) (p vector))
  (let ()
    (if ls is vertical
        (if ((p2y ls) > (p1y ls))
            ((p1x ls) - (x p))
            ((x p) - (p1x ls)))
        ((cos (theta ls))
              * (((y p) - (p1y ls)) - ((x p)  - (p1x ls)) * (slope ls))) ) ))

; 31 Dec 91; 14 Oct 92; 19 Jan 04
; Test whether a point is to the left of a directed line segment,
; from the point of view of an observer facing along the line segment.
(gldefun line-segment-leftof ((ls line-segment) (p vector))
  (let ( (dx (deltax ls)) (dy (deltay ls)) slope bdif)
    (if ls is vertical
        (if (dy > 0)
            ((p1x ls) > (x p))
            ((x p) < (p1x ls)))
        (progn (slope = dy / (float dx))
             (bdif = ((y p) - (p1y ls) - slope * ((x p) - (p1x ls))))
             (if (dx > 0)
                 (bdif > 0)
                 (bdif < 0)) ) )))
|#

; 21 Jan 93; 22 Jan 93; 16 Feb 95
; Perpendicular distance of a point to the left of a directed line segment
(gldefun line-segment-leftof-distance ((ls line-segment) (p vector))
    ( ( (deltax ls) * ( (y p) - (p1y ls) )
        - (deltay ls) * ( (x p) - (p1x ls) ) )
      / (length ls) ) )

; 31 Dec 91; 14 Oct 92; 22 Jan 93
; Test whether a point is to the left of a directed line segment,
; from the point of view of an observer facing along the line segment.
(gldefun line-segment-leftof ((ls line-segment) (p vector))
  ( (deltax ls) * ( (y p) - (p1y ls) ) > (deltay ls) * ( (x p) - (p1x ls) )) )

; 14 Jan 92; 14 Oct 92
; Test whether a point is within the y range of a line segment
(gldefun line-segment-within-y ((ls line-segment) (p vector))
  (or (((y p) <= (p2y ls)) and ((y p) > (p1y ls)))
      (((y p) <= (p1y ls)) and ((y p) > (p2y ls))) ) )

; 14 Jan 92; 14 Oct 92; 28 Feb 02; 05 Jan 04
; Test whether a point is to the left of a line segment, relative to x-y axes.
(gldefun line-segment-leftof-x ((ls line-segment) (p vector))
  (let ( (dx (deltax ls)) (dy (deltay ls)) slope bdif)
    (and (within-y ls p)
         (if (dx == 0)
             ((x p) < (p1x ls))
             (progn (slope = dy / (float dx))
                    (bdif = ((y p) - (p1y ls)
                               - slope * ((x p) - (p1x ls))))
                    (if (slope > 0) (bdif > 0) (bdif < 0)) ) ) )))

; 14 Jan 92; 14 Oct 92; 10 May 99
; Area under a line segment (to the x axis) * 2
; By returning the area * 2, the divide by 2 can be outside the loop.
(gldefun line-segment-area-under2 ((ls line-segment))
  ( (p2x ls) - (p1x ls)) * ((p2y ls) + (p1y ls) ) )

; Area of a line segment, for accumulating center of gravity
(gldefun line-segment-cofg-area-x ((ls line-segment))
  (let ( (dx (deltax ls)) )
    ( -0.5 * dx * (deltay ls) * ( (p1x ls) + dx / 3.0 )
      + dx * (p2y ls) * ( (p1x ls) + dx / 2.0) ) ))

(gldefun line-segment-cofg-area-y ((ls line-segment))
  (let ( (dx (deltax ls)) (dy (deltay ls)) )
    ( -0.5 * dx * dy * ( (p2y ls) - dy / 3.0 )
      + dx * ((p2y ls) ^ 2) / 2.0) ))

; 20 Oct 94; 18 Jan 08
(gldefun line-segment-draw ((ls line-segment) (substrate window))
  (draw-line-xy substrate (p1x ls) (p1y ls) (p2x ls) (p2y ls)))

; 27 Oct 94; 28 Oct 94; 05 Jan 04; 26 Sep 06
; K. Loo, adapted by G. Novak
; If ls1 and ls2 are not parallel, and there is a unique intersection,
; returns the intersection point, else nil.
; int-pt is used to give the desired result type
(gldefun line-segment-intersect ((ls1 line-segment) (ls2 line-segment)
                                 &optional (int-pt nvector))
   (result (typeof int-pt))
   (let (dy1 dy2 s r (denominator real))
     (dy1 = ((p2y ls1) - (p1y ls1)))
     (dy2 = ((p2y ls2) - (p1y ls2)))
     (denominator = (p1x ls1) * dy2 + (p2x ls2) * dy1
                      - ((p2x ls1) * dy2 + (p1x ls2) *dy1))
     (if (not (zerop denominator))
      (progn 
       (s = ( (p1x ls1) * dy2 +
                (p1x ls2) * ((p1y ls1) - (p2y ls2)) +
                (p2x ls2) * ((p1y ls2) - (p1y ls1)) ) / denominator)
       (r = - ((p1x ls2) * dy1 +
                 (p1x ls1) * ((p1y ls2) - (p2y ls1)) +
                 (p2x ls1) * ((p1y ls1) - (p1y ls2)) )
              / denominator)
       (if ((0.0 <= s) and (s <= 1.0) and (0.0 <= r) and (r <= 1.0))
           (a (typeof int-pt) with
                x = ((p1x ls1) + s * ((p2x ls1) - (p1x ls1)))
                y = ((p1y ls1) + s * dy1) ) ) ) )))

; 28 Sep 09
; Test whether two line segments intersect: Cormen p. 889
(gldefun line-segment-intersect? ((ls1 line-segment) (ls2 line-segment))
  (result boolean)
  (let (d1 xp1 xp2)
; quick rejection test: bounding boxes must intersect
(and (>= (max (p1x ls1) (p2x ls1)) (min (p1x ls2) (p2x ls2))) ; (>= x2 x3)
     (>= (max (p1x ls2) (p2x ls2)) (min (p1x ls1) (p2x ls1))) ; (>= x4 x1)
     (>= (max (p1y ls1) (p2y ls1)) (min (p1y ls2) (p2y ls2))) ; (>= y2 y3)
     (>= (max (p1y ls2) (p2y ls2)) (min (p1y ls1) (p2y ls1))) ; (>= y4 y1)
     (d1 = (- (p2 ls1) (p1 ls1)))
     (xp1 = (crossproduct (- (p1 ls2) (p1 ls1)) d1))
     (xp2 = (crossproduct (- (p2 ls2) (p1 ls1)) d1))
     (if (< xp1 0)
         (>= xp2 0)
         (if (> xp1 0)
             (<= xp2 0)
             t))
     (d1 = (- (p2 ls2) (p1 ls2)))
     (xp1 = (crossproduct (- (p1 ls1) (p1 ls2)) d1))
     (xp2 = (crossproduct (- (p2 ls1) (p1 ls2)) d1))
     (if (< xp1 0)
         (>= xp2 0)
         (if (> xp1 0)
             (<= xp2 0)
             t))
 ) ))

; 19 Jul 06
(gldefun line-segment-line ((ls line-segment)) (result line)
  (let (aval)
    (if (= (p1x ls) (p2x ls))
        (a line aa 1 b 0 c (- (p1x ls)))
        (progn
          (aval = (- (/ (- (p1y ls) (p2y ls)) (- (p1x ls) (p2x ls)))))
          (a line aa aval
                  b  1
                  c  (- (- (* aval (p1x ls))) (p1y ls)) ) ) ) ))

; 07 Feb 07
; Test if a point on a line is within the region around a line segment
(gldefun line-segment-contains? ((ls line-segment) (pt vector))
  (contains? (region ls) pt))

; 26 Feb 07
; 
(gldefun line-segment-point-along ((ls line-segment) (d number))
  (let ((lng (/ d (length ls))))
    (virtual nvector with x = (p1x ls) + (deltax ls) * lng
                          y = (p1y ls) + (deltay ls) * lng) ))

; 14 Feb 08
; Test if x is between y and z
(gldefun between ((x number) (y number) (z number))  (result boolean)
  (if (<= x y)
      (<= z x)
      (>= z x) ) )

(gldefun sbetween ((x number) (y number) (z number))  (result boolean)
  (or (and (< x y) (< z x))
      (and (> x y) (> z x)) ) )
