; xmltypes.lsp             Gordon S. Novak Jr.         ; 17 Nov 08

; Copyright (c) 2008 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 26 Oct 06; 10 Mar 08; 14 Mar 08; 20 Mar 08

; Type definitions for common types of data

(glispobjects

(weekday string
  prop ((number   ((cadr (assoc self '(("Sunday" 0) ("Monday" 1) ("Tuesday" 2)
                                       ("Wednesday" 3) ("Thursday" 4)
                                       ("Friday" 5) ("Saturday" 6)
                                       ("Sun" 0) ("Mon" 1) ("Tues" 2)
                                       ("Wed" 3) ("Thurs" 4) ("Thu" 4)
                                       ("Fri" 5) ("Sat" 6))
                                :test #'string-equal))) result integer) ) )

(currency (units real dollar)
  prop ((zero  ('(q 0.0 dollar))))
  supers (real) )

(phone-string string )

(monthname string
  prop ((number   ((cadr (assoc self
                    '(("January" 1) ("February" 2) ("March" 3) ("April" 4)
                      ("May" 5) ("June" 6) ("July" 7) ("August" 8)
                      ("September" 9) ("October" 10) ("November" 11)
                      ("December" 12) ("Jan" 1) ("Feb" 2) ("Mar" 3) ("Apr" 4)
                      ("Jun" 6) ("Jul" 7) ("Aug" 8) ("Sep" 9)
                      ("Sept" 9) ("Oct" 10) ("Nov" 11) ("Dec" 12))
                                :test #'string-equal))) result monthnumber)))

(monthnumber integer
  prop ((name   ((nth (1- self) '("January" "February" "March" "April"
                                  "May" "June" "July" "August" "September"
                                  "October" "November" "December")))
                  result monthname)
        (abbrev   ((nth (1- self) '("Jan" "Feb" "Mar" "Apr" "May" "Jun" "Jul"
                                    "Aug" "Sep" "Oct" "Nov" "Dec")))
                  result monthname) )
  supers (integer) )

(state (list (name string)
             (abbrev string)
             (capital city)
             (population integer)
             (area (units integer square-mile))) )

(statecode string
  prop ((state   ((find self *statedata* :key #'cadr :test #'string-equal))
                   result state)
        (name    ((name (state self))))) )

(statename string
  prop ((state   ((assoc self *statedata* :test #'string-equal))
                   result state)
        (code    ((abbrev (state self)))) ) )

(country (list (name string)
               (abbrev string)) )

(countrycode string
  prop ((country   ((find self *countrydata* :key #'cadr :test #'string-equal))
                   result country)
        (name    ((name (country self))))) )

(countryname string
  prop ((country   ((assoc self *countrydata* :test #'string-equal))
                   result country)
        (code    ((abbrev (country self)))) ) )


(url string )

(zipcode (self integer)
  prop ((zipdata    zipcode)
        (city       ((city zipdata)))
        (statecode  ((statecode zipdata)))
        (statename  ((statename statecode)))
        (lat-long   ((lat-long zipdata))) )
  msg  ((distance   (glambda (self other)
                      (distance (lat-long self) (lat-long other)))
                    argtypes (zipcode))        )
    )

(year (self (units integer year))  supers (integer) )

(ssn (self integer) )

(areacode (self integer) )

(phonenumber (self integer) )


) ; glispobjects
