/* applPrim.c
 * 17dec90abu
 */

#include "../src/pico.h"
#include "appl.h"
#include <X11/cursorfont.h>

/* Prototypes */
static pico Watch(pico);
static pico Arrow(pico);
static pico addDlgEsc(pico);
static pico addFDlgEsc(pico);
static pico createFont(pico);
static bool fndMatch(char*,char*);
static pico txFind(pico);
static pico newPict(void);
static pico zapPict(pico);
static pico clrPict(pico);
static pico movPict(pico);
static pico drawPict(pico);
static pico picPoint(pico);
static pico picLine(pico);
static pico picArc(pico);
static pico pustel(pico);
static pico button(pico);
static pico getMouse(pico);
static pico ptToAngle(pico);
static pico pRGB(pico);
/* static pico skipLine(pico); */

symInit applSyms[] = {
   {"WATCH",       Watch},
   {"ARROW",       Arrow},
   {"ADDDLGESC",   addDlgEsc},
   {"ADDFDLGESC",  addFDlgEsc},
   {"CREATEFONT",  createFont},
   {"TXFIND",      txFind},
   {"NEWPICT",     newPict},
   {"ZAPPICT",     zapPict},
   {"CLRPICT",     clrPict},
   {"MOVPICT",     movPict},
   {"DRAWPICT",    drawPict},
   {"PICPOINT",    picPoint},
   {"PICLINE",     picLine},
   {"PICARC",      picArc},
   {"PUSTEL",      pustel},
   {"BUTTON",      button},
   {"GETMOUSE",    getMouse},
   {"PTTOANGLE",   ptToAngle},
   {"RGB",         pRGB},
   NULL
};

static bool watch = NO;

pico Watch(x)
pico x;
{
   Display *disp;
   static Cursor curs = 0;

   disp = (Display*)nextNum(&x);
   if (!curs)
      curs = XCreateFontCursor(disp, XC_watch);
   if (watch)
      return nilSym;
   watch = YES;
   return boxNum(
      XGrabPointer(disp,DefaultRootWindow(disp),True,0, GrabModeAsync,
                  GrabModeAsync, None, curs, CurrentTime ) );
}

pico Arrow(x)
pico x;
{
   Display *disp;

   disp = (Display*)nextNum(&x);
   if (!watch)
      return nilSym;
   watch = NO;
   XUngrabPointer(disp, CurrentTime);
   return tSym;
}

pico dlgEsc;

void dlgEscAction()
{
   applyProc(dlgEsc);
}

pico addDlgEsc(x)
pico x;
{
   Widget widget;
   XtTranslations translation;
   XtAppContext   application_context;
   XtActionsRec   actions [1];

   widget = (Widget)nextNum(&x);
   application_context = XtWidgetToApplicationContext (widget);
   actions->string = "dlgEscAction";
   actions->proc = dlgEscAction;
   XtAppAddActions (application_context, actions, 1);

   translation = XtParseTranslationTable ("<Key>Escape: dlgEscAction()");
   XtOverrideTranslations (widget, translation);
   dlgEsc = nextFun(&x);
   return tSym;
}

pico fdlgEsc;

void fdlgEscAction()
{
   applyProc(fdlgEsc);
}


pico addFDlgEsc(x)
pico x;
{
   Widget widget;
   XtTranslations translation;
   XtAppContext   application_context;
   XtActionsRec   actions [1];

   widget = (Widget)nextNum(&x);
   application_context = XtWidgetToApplicationContext (widget);
   actions->string = "fdlgEscAction";
   actions->proc = fdlgEscAction;
   XtAppAddActions (application_context, actions, 1);

   translation = XtParseTranslationTable ("<Key>Escape: fdlgEscAction()");
   if( translation == NULL)
      return nilSym;
   XtOverrideTranslations (widget, translation);
   fdlgEsc = nextFun(&x);
   return tSym;
}

pico createFont(x)
pico x;
{
   Display *disp;
   char buf[100];
   XFontStruct *fontStruct;

   disp = (Display*)nextNum(&x);
   nextString(&x,buf,100);
   fontStruct = XLoadQueryFont(disp,buf);
   return boxNum(XmFontListCreate(fontStruct,-1));
      /* STRING_DEFAULT_CHARSET*/
}

static bool fndMatch(p,d)
register char *p,*d;
{
   while (*p) {
      if (*p != *d)
         return NO;
      p++, d++;
   }
   return YES;
}

pico txFind(x)
pico x;
{
   register number i;
   register char *p;
   number l,n;
   char buff[1024];

   p = (char*)nextNum(&x); /* Text */
   l = nextNum(&x); /* Length */
   n = nextNum(&x); /* Position */
   nextString(&x,buff,1024); /* Search string */
   l -= strlen(buff);
   for (i = n+1; i < l; ++i)
      if (fndMatch(buff, p+i))
         return boxNum(i);
   for (i = 0; i <= n; ++i)
      if (fndMatch(buff, p+i))
         return boxNum(i);
   return nilSym;
}

pico newPict()
{
   register picture *p;

   if (!(p = (picture*)malloc(sizeof(picture))))
      return nilSym;
   if (!(p->pp = (pointPic*)malloc(sizeof(pointPic))))
      return nilSym;
   if (!(p->lp = (linePic*)malloc(sizeof(linePic))))
      return nilSym;
   if (!(p->ap = (arcPic*)malloc(sizeof(arcPic))))
      return nilSym;
   p->pp->cnt = 0;
   p->lp->cnt = 0;
   p->ap->cnt = 0;
   return boxNum(p);
}

pico zapPict(x)
pico x;
{
   register picture *p;

   p = (picture*)nextNum(&x);
   free((char*)p->pp);
   free((char*)p->lp);
   free((char*)p->ap);
   free((char*)p);
   return tSym;
}

pico clrPict(x)
pico x;
{
   register picture *p;

   p = (picture*)nextNum(&x);
   p->pp->cnt = 0;
   p->lp->cnt = 0;
   p->ap->cnt = 0;
   return tSym;
}

pico movPict(x)
pico x;
{
   register picture *p;
   register number i,dh,dv;

   p = (picture*)nextNum(&x);
   dh = nextNum(&x);
   dv = nextNum(&x);
   i = p->pp->cnt;
   while (--i >= 0) {
      p->pp->data[i].x += dh;
      p->pp->data[i].y += dv;
   }
   i = p->lp->cnt;
   while (--i >= 0) {
      p->lp->data[i].x1 += dh;
      p->lp->data[i].y1 += dv;
      p->lp->data[i].x2 += dh;
      p->lp->data[i].y2 += dv;
   }
   i = p->ap->cnt;
   while (--i >= 0) {
      p->ap->data[i].x += dh;
      p->ap->data[i].y += dv;
   }
   return tSym;
}

#define SEGMAX 2000 /* ?? */

pico drawPict(x)
pico x;
{
   Display *disp;
   Drawable draw;
   GC gc;
   register picture *p;
   register number n,i;

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   p = (picture*)nextNum(&x);

   n = p->pp->cnt, i = 0;
   while (n > SEGMAX) {
      XDrawPoints(disp, draw, gc,
               p->pp->data + i, SEGMAX, CoordModeOrigin);
      n -= SEGMAX;
      i += SEGMAX;
   }
   XDrawPoints(disp, draw, gc, p->pp->data + i, n, CoordModeOrigin);

   n = p->lp->cnt, i = 0;
   while (n > SEGMAX) {
      XDrawSegments(disp, draw, gc, p->lp->data + i, SEGMAX);
      n -= SEGMAX;
      i += SEGMAX;
   }
   XDrawSegments(disp, draw, gc, p->lp->data + i, n);

   n = p->ap->cnt, i = 0;
   while (n > SEGMAX) {
      XDrawArcs(disp, draw, gc, p->ap->data + i, SEGMAX);
      n -= SEGMAX;
      i += SEGMAX;
   }
   XDrawArcs(disp, draw, gc, p->ap->data + i, n);

   return tSym;
}

pico picPoint(x)
pico x;
{
   register picture *p;
   register int i;

   p = (picture*)nextNum(&x);
   i = p->pp->cnt++;
   p->pp = (pointPic*)
              realloc((char*)p->pp, sizeof(int) + (i+1)*sizeof(XPoint));
   p->pp->data[i].x = nextNum(&x);
   p->pp->data[i].y = nextNum(&x);
   return tSym;
}

pico picLine(x)
pico x;
{
   register picture *p;
   register int i;

   p = (picture*)nextNum(&x);
   i = p->lp->cnt++;
   p->lp = (linePic*)
              realloc((char*)p->lp, sizeof(int) + (i+1)*sizeof(XSegment));
   p->lp->data[i].x1 = nextNum(&x);
   p->lp->data[i].y1 = nextNum(&x);
   p->lp->data[i].x2 = nextNum(&x);
   p->lp->data[i].y2 = nextNum(&x);
   return tSym;
}

pico picArc(x)
pico x;
{
   register picture *p;
   register int i;
   rect r;

   p = (picture*)nextNum(&x);
   i = p->ap->cnt++;
   p->ap = (arcPic*)
              realloc((char*)p->ap, sizeof(int) + (i+1)*sizeof(XArc));
   nextRect(&x,&r);
   p->ap->data[i].x = r.left;
   p->ap->data[i].y = r.top;
   p->ap->data[i].width = r.right - r.left;
   p->ap->data[i].height = r.bottom - r.top;
   p->ap->data[i].angle1 = nextAngle(&x);
   p->ap->data[i].angle2 = -nextNum(&x);
   return tSym;
}

pico pustel(x)
pico x;
{
   Display *disp;
   Drawable draw;
   GC gc;
   rect r;
   register number i,h,v,dh,dv,sc;
   XPoint pt[PUSTEL];

   disp = (Display*)nextNum(&x);
   draw = (Drawable)nextNum(&x);
   gc = (GC)nextNum(&x);
   nextRect(&x,&r);
   dh = nextNum(&x);
   dv = nextNum(&x);
   sc = nextNum(&x);
   i = -1;
   v = 0; do {
      h = 0; do {
         if (++i == PUSTEL)
            return nilSym;
         pt[i].x = r.left + h * dh * sc / PSCALE;
         pt[i].y = r.top + v * dv * sc / PSCALE;
         ++h;
      } while (pt[i].x < r.right);
      ++v;
   } while (pt[i].y < r.bottom);
   return boxNum(XDrawPoints(disp, draw, gc, pt, i+1, CoordModeOrigin));
}

pico button(x)
pico x;
{
   Display *disp;
   Window w,root,child;
   int rootX,rootY,winX,winY;
   unsigned int keys;

   disp = (Display*)nextNum(&x);
   w = (Window)nextNum(&x);
   if (!XQueryPointer(disp,w,&root,&child,&rootX,&rootY,&winX,&winY,&keys))
      return nilSym;
   return boxNum(keys);
}

pico getMouse(x)
pico x;
{
   Display *disp;
   Window w,root,child;
   int rootX,rootY,winX,winY;
   unsigned int keys;

   disp = (Display*)nextNum(&x);
   w = (Window)nextNum(&x);
   if (!XQueryPointer(disp,w,&root,&child,&rootX,&rootY,&winX,&winY,&keys))
      return nilSym;
   return newCell(boxNum(winX),boxNum(winY));
}

pico ptToAngle(x)
pico x;
{
   point pt1,pt2;

   nextPoint(&x,&pt1);
   nextPoint(&x,&pt2);
   if (pt1.h==pt2.h && pt1.v==pt2.v)
      return boxNum(0);
   return boxNum( (
         num(
            atan2((double)(pt2.h - pt1.h), (double)(pt1.v - pt2.v))
            * 180.0 * 64.0 / M_PI )
         + 23040 ) % 23040 );
}

pico pRGB(x)
pico x;
{
   register number y,m,c,k;

   y = nextNum(&x);
   m = nextNum(&x);
   c = nextNum(&x);
   k = nextNum(&x);
   y = 65535 * minNumber(100, (y + k));
   m = 65535 * minNumber(100, (m + k));
   c = 65535 * minNumber(100, (c + k));
   return boxColor(65535-c/100, 65535-m/100, 65535-y/100);
}

/* Arguments and results */
pico boxColor(red,green,blue)
integer red, green, blue;
{
   return packNum(red >> 6, green >> 6, blue >> 6);
}

unsigned long unBoxColor(x,disp)
register pico x;
register Display *disp;
{
   XColor col;
   register number n;

   NEEDNUM(x);
   n = unBox(x);
   col.red   = n >> 14 & 0xFFC0;
   col.green = n >>  4 & 0xFFC0;
   col.blue  = n <<  6 & 0xFFC0;
   XAllocColor(disp, DefaultColormap(disp,DefaultScreen(disp)), &col);
   return col.pixel;
}

unsigned long nextColor(p,disp)
register pico *p;
Display *disp;
{
   unsigned long n;

   n = unBoxColor(EVAL1(*p),disp);
   *p = cdr(*p);
   return n;
}

long nextAngle(p)
register pico *p;
{
   register pico y;

   y = EVAL1(*p);
   *p = cdr(*p);
   NEEDNUM(y);
   return (90*64 - unBox(y) + 23040) % 23040; /* ==360*64 */
   /* "+ 23040" is for bug in server */
}

pico nextFun(p)
register pico *p;
{
   register pico x;

   x = EVAL1(*p);
   *p = cdr(*p);
   NEEDFUN(x);
   return x;
}

pico fetchB(x,offs)
pico x;
integer offs;
{
   register char *adr;
   char old;

   adr = (char*)nextNum(&x) + offs;
   if (isNil(x = EVAL1(x)))
      return boxNum(*adr);
   NEEDNUM(x);
   old = *adr;
   *adr = unBox(x);
   return boxNum(old);
}

pico fetchW(x,offs)
pico x;
int offs;
{
   register integer *adr;
   integer old;

   adr = (integer*)((char*)nextNum(&x) + offs);
   if (isNil(x = EVAL1(x)))
      return boxNum(*adr);
   NEEDNUM(x);
   old = *adr;
   *adr = unBox(x);
   return boxNum(old);
}

pico fetchL(x,offs)
pico x;
int offs;
{
   register long *adr;
   long old;

   adr = (long*)((char*)nextNum(&x) + offs);
   if (isNil(x = EVAL1(x)))
      return boxNum(*adr);
   NEEDNUM(x);
   old = *adr;
   *adr = unBox(x);
   return boxNum(old);
}

pico fetchPoint(x,offs)
pico x;
int offs;
{
   register point *adr;
   point old;

   adr = (point*)((char*)nextNum(&x) + offs);
   if (!isCell(x))
      return newCell(boxNum(adr->h), boxNum(adr->v));
   old = *adr;
   nextPoint(&x,adr);
   return newCell(boxNum(old.h), boxNum(old.v));
}

pico fetchRect(x,offs)
pico x;
int offs;
{
   register rect *adr;
   rect old;

   adr = (rect*)((char*)nextNum(&x) + offs);
   if (!isCell(x))
      return boxRect(adr);
   old = *adr;
   nextRect(&x,adr);
   return boxRect(&old);
}
